/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.core.locks.Locking;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.ALookup;
import org.basex.query.expr.And;
import org.basex.query.expr.Arith;
import org.basex.query.expr.BaseXPragma;
import org.basex.query.expr.CachedFilter;
import org.basex.query.expr.CachedMap;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Castable;
import org.basex.query.expr.Catch;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Concat;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.DBPragma;
import org.basex.query.expr.DeepLookup;
import org.basex.query.expr.Except;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Extension;
import org.basex.query.expr.If;
import org.basex.query.expr.Instance;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.List;
import org.basex.query.expr.Lookup;
import org.basex.query.expr.Or;
import org.basex.query.expr.Otherwise;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pipeline;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Range;
import org.basex.query.expr.StructFilter;
import org.basex.query.expr.Switch;
import org.basex.query.expr.SwitchGroup;
import org.basex.query.expr.Treat;
import org.basex.query.expr.Try;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.Typeswitch;
import org.basex.query.expr.TypeswitchGroup;
import org.basex.query.expr.Unary;
import org.basex.query.expr.Union;
import org.basex.query.expr.constr.CArray;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CComm;
import org.basex.query.expr.constr.CDoc;
import org.basex.query.expr.constr.CElem;
import org.basex.query.expr.constr.CItemArray;
import org.basex.query.expr.constr.CMap;
import org.basex.query.expr.constr.CNSpace;
import org.basex.query.expr.constr.CPI;
import org.basex.query.expr.constr.CRecord;
import org.basex.query.expr.constr.CTxt;
import org.basex.query.expr.ft.FTAnd;
import org.basex.query.expr.ft.FTContains;
import org.basex.query.expr.ft.FTContent;
import org.basex.query.expr.ft.FTDistance;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTExtension;
import org.basex.query.expr.ft.FTMildNot;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.expr.ft.FTOptions;
import org.basex.query.expr.ft.FTOr;
import org.basex.query.expr.ft.FTOrder;
import org.basex.query.expr.ft.FTScope;
import org.basex.query.expr.ft.FTWeight;
import org.basex.query.expr.ft.FTWindow;
import org.basex.query.expr.ft.FTWords;
import org.basex.query.expr.ft.ThesAccessor;
import org.basex.query.expr.ft.ThesList;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.Condition;
import org.basex.query.expr.gflwor.Count;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.GroupBy;
import org.basex.query.expr.gflwor.GroupSpec;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.expr.gflwor.OrderBy;
import org.basex.query.expr.gflwor.OrderKey;
import org.basex.query.expr.gflwor.Where;
import org.basex.query.expr.gflwor.While;
import org.basex.query.expr.gflwor.Window;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedStep;
import org.basex.query.expr.path.DocTest;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Closure;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.Function;
import org.basex.query.func.Functions;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.fn.FnError;
import org.basex.query.scope.ContextScope;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.MainModule;
import org.basex.query.up.expr.Delete;
import org.basex.query.up.expr.Insert;
import org.basex.query.up.expr.Rename;
import org.basex.query.up.expr.Replace;
import org.basex.query.up.expr.Transform;
import org.basex.query.up.expr.TransformWith;
import org.basex.query.util.Flag;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.format.DecFormatOptions;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.util.hash.HashItemSet;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ExprList;
import org.basex.query.util.list.ItemList;
import org.basex.query.util.parse.FuncBuilder;
import org.basex.query.util.parse.LocalVars;
import org.basex.query.util.parse.ModInfo;
import org.basex.query.util.parse.Params;
import org.basex.query.util.parse.QNmCache;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.EnumType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTContents;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTMode;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.StopWords;
import org.basex.util.ft.Tokenizer;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;
import org.basex.util.options.Option;

public class QueryParser
extends InputParser {
    private static final Pattern LIBMOD_PATTERN = Pattern.compile("^(xquery( version ['\"].*?['\"])?( encoding ['\"].*?['\"])? ?; ?)?module .*");
    private static final byte[] SKIPCHECK = new byte[0];
    private static final TokenSet KEYWORDS = new TokenSet("attribute", "comment", "document-node", "element", "namespace-node", "node", "schema-attribute", "schema-element", "processing-instruction", "text", "fn", "function", "if", "switch", "typeswitch");
    public final TokenSet moduleURIs = new TokenSet();
    public final QueryContext qc;
    public final StaticContext sc;
    private final ArrayList<ModInfo> modules = new ArrayList();
    private final TokenObjectMap<byte[]> namespaces = new TokenObjectMap();
    private final ArrayList<StaticVar> vars = new ArrayList();
    private final ArrayList<StaticFunc> funcs = new ArrayList();
    private final QNmMap<SeqType> declaredTypes = new QNmMap();
    private final QNmMap<SeqType> publicTypes = new QNmMap();
    private final QNmMap<RecordType> namedRecordTypes = new QNmMap();
    private final QNmMap<RecordType> recordTypeRefs = new QNmMap();
    private final HashSet<String> decl = new HashSet();
    private final HashMap<String, Object> sparams = new HashMap();
    private final QNmCache qnames = new QNmCache();
    private final LocalVars localVars = new LocalVars(this);
    private final TokenBuilder token = new TokenBuilder();
    private final TokenBuilder docBuilder = new TokenBuilder();
    private String moduleDoc = "";
    private QueryError alter;
    private int alterPos;

    QueryParser(String query, String uri, QueryContext qctx, StaticContext sctx) {
        super(query);
        this.qc = qctx;
        StaticContext staticContext = this.sc = sctx != null ? sctx : new StaticContext(qctx);
        if (uri != null) {
            this.sc.baseURI(uri);
        }
    }

    final MainModule parseMain() throws QueryException {
        this.init();
        try {
            this.versionDecl();
            int p = this.pos;
            if (this.wsConsumeWs("module", null, "namespace")) {
                throw this.error(QueryError.MAINMOD, new Object[0]);
            }
            this.pos = p;
            this.prolog1();
            this.importModules();
            this.prolog2();
            this.localVars.pushContext(false);
            Expr expr = this.expr();
            if (expr == null) {
                throw this.alterError(QueryError.EXPREMPTY);
            }
            VarScope vs = this.localVars.popContext();
            MainModule mm = new MainModule(expr, vs, this.sc);
            mm.set(this.funcs, this.vars, this.publicTypes, this.moduleURIs, this.namespaces, this.moduleDoc);
            this.finish(mm);
            this.check(mm);
            return mm;
        }
        catch (QueryException expr) {
            this.mark();
            expr.pos(this);
            throw expr;
        }
    }

    final LibraryModule parseLibrary(boolean root) throws QueryException {
        this.init();
        try {
            this.versionDecl();
            this.wsCheck("module");
            this.wsCheck("namespace");
            this.skipWs();
            byte[] prefix = this.ncName(QueryError.NONAME_X);
            this.wsCheck("=");
            byte[] uri = this.stringLiteral();
            if (uri.length == 0) {
                throw this.error(QueryError.NSMODURI, new Object[0]);
            }
            this.sc.module = new QNm(prefix, uri);
            this.sc.ns.add(prefix, uri, this.info());
            this.namespaces.put(prefix, uri);
            this.wsCheck(";");
            IO baseO = this.sc.baseIO();
            byte[] pth = Token.token(baseO == null ? "" : baseO.path());
            this.qc.modParsed.put(pth, uri);
            this.qc.modStack.push(pth);
            this.prolog1();
            this.importModules();
            this.prolog2();
            this.finish(null);
            if (root) {
                this.check(null);
            }
            this.qc.modStack.pop();
            LibraryModule lm = new LibraryModule(this.sc);
            lm.set(this.funcs, this.vars, this.publicTypes, this.moduleURIs, this.namespaces, this.moduleDoc);
            return lm;
        }
        catch (QueryException expr) {
            this.mark();
            expr.pos(this);
            throw expr;
        }
    }

    final SeqType parseSeqType() throws QueryException {
        try {
            return this.sequenceType();
        }
        catch (QueryException expr) {
            Util.debug(expr);
            throw this.error(QueryError.CASTTYPE_X, null, expr.getLocalizedMessage());
        }
    }

    private void init() throws QueryException {
        IO baseIO = this.sc.baseIO();
        String string = this.path = baseIO == null ? null : baseIO.path();
        if (!this.more()) {
            throw this.error(QueryError.QUERYEMPTY, new Object[0]);
        }
        for (int i = 0; i < this.length; ++i) {
            int cp = this.input[i];
            if (XMLToken.valid(cp)) continue;
            this.pos = i;
            throw this.error(QueryError.MODLEINV_X, this.currentAsString());
        }
    }

    private void finish(MainModule mm) throws QueryException {
        if (this.more()) {
            if (this.alter != null) {
                throw this.alterError(null);
            }
            String rest = this.remaining();
            ++this.pos;
            if (mm == null) {
                throw this.error(QueryError.MODEXPR, rest);
            }
            throw this.error(QueryError.QUERYEND_X, rest);
        }
        this.qnames.assignURI(this, 0);
        if (this.sc.elemNS != null) {
            this.sc.ns.add(Token.EMPTY, this.sc.elemNS, null);
        }
        RecordType.resolveRefs(this.recordTypeRefs, this.namedRecordTypes);
    }

    private void check(MainModule main) throws QueryException {
        this.qc.functions.check(this.qc);
        this.qc.vars.check();
        if (this.qc.updating) {
            if (!this.sc.mixUpdates) {
                this.qc.functions.checkUp();
                this.qc.vars.checkUp();
                if (main != null) {
                    main.expr.checkUp();
                }
            }
            this.qc.updating = main != null && main.expr.has(Flag.UPD);
        }
    }

    private void versionDecl() throws QueryException {
        String string;
        int p = this.pos;
        if (!this.wsConsumeWs("xquery")) {
            return;
        }
        boolean version = this.wsConsumeWs("version");
        if (version && !QueryContext.isSupported(string = Token.string(this.stringLiteral()).replaceAll("0+(\\d)", "$1"))) {
            throw this.error(QueryError.XQUERYVER_X, string);
        }
        if (this.wsConsumeWs("encoding")) {
            String encoding = Token.string(this.stringLiteral());
            if (!Strings.encodingSupported(encoding)) {
                throw this.error(QueryError.XQUERYENC2_X, encoding);
            }
        } else if (!version) {
            this.pos = p;
            return;
        }
        this.wsCheck(";");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prolog1() throws QueryException {
        while (true) {
            block12: {
                int p;
                block13: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                p = this.pos;
                                                if (!this.wsConsumeWs("declare")) break block13;
                                                if (!this.wsConsumeWs("default")) break block14;
                                                if (!(this.defaultNamespaceDecl() || this.defaultCollationDecl() || this.emptyOrderDecl() || this.decimalFormatDecl(true))) {
                                                    throw this.error(QueryError.DECLINCOMPLETE, new Object[0]);
                                                }
                                                break block12;
                                            }
                                            if (!this.wsConsumeWs("boundary-space")) break block15;
                                            this.boundarySpaceDecl();
                                            break block12;
                                        }
                                        if (!this.wsConsumeWs("base-uri")) break block16;
                                        this.baseURIDecl();
                                        break block12;
                                    }
                                    if (!this.wsConsumeWs("construction")) break block17;
                                    this.constructionDecl();
                                    break block12;
                                }
                                if (!this.wsConsumeWs("ordering")) break block18;
                                this.orderingModeDecl();
                                break block12;
                            }
                            if (!this.wsConsumeWs("revalidation")) break block19;
                            this.revalidationDecl();
                            break block12;
                        }
                        if (!this.wsConsumeWs("copy-namespaces")) break block20;
                        this.copyNamespacesDecl();
                        break block12;
                    }
                    if (this.wsConsumeWs("decimal-format")) {
                        this.decimalFormatDecl(false);
                        break block12;
                    } else if (this.wsConsumeWs("namespace")) {
                        this.namespaceDecl();
                        break block12;
                    } else {
                        if (!this.wsConsumeWs("ft-option")) {
                            this.pos = p;
                            return;
                        }
                        FTOpt fto = new FTOpt();
                        while (this.ftMatchOption(fto)) {
                        }
                        this.qc.ftOpt().assign(fto);
                    }
                    break block12;
                }
                if (!this.wsConsumeWs("import")) {
                    return;
                }
                if (this.wsConsumeWs("schema")) {
                    this.schemaImport();
                } else {
                    if (!this.wsConsumeWs("module")) {
                        this.pos = p;
                        return;
                    }
                    this.moduleImport();
                }
            }
            this.docBuilder.reset();
            this.skipWs();
            this.check(';');
        }
    }

    private void prolog2() throws QueryException {
        while (true) {
            int p = this.pos;
            if (!this.wsConsumeWs("declare")) break;
            if (this.wsConsumeWs("context")) {
                this.contextValueDecl();
            } else if (this.wsConsumeWs("option")) {
                this.optionDecl();
            } else {
                if (this.wsConsumeWs("default")) {
                    throw this.error(QueryError.PROLOGORDER, new Object[0]);
                }
                AnnList anns = this.annotations(true);
                if (this.wsConsumeWs("variable")) {
                    if (anns.contains(Annotation.UPDATING)) {
                        throw this.error(QueryError.UPDATINGVAR, new Object[0]);
                    }
                    this.varDecl(anns.check(true, true, false));
                } else if (this.wsConsumeWs("function")) {
                    this.functionDecl(anns.check(false, true, false));
                } else if (this.wsConsumeWs("type")) {
                    if (anns.contains(Annotation.UPDATING)) {
                        throw this.error(QueryError.UPDATINGTYPE, new Object[0]);
                    }
                    this.typeDecl(anns.check(false, true, false));
                } else if (this.wsConsumeWs("record")) {
                    if (anns.contains(Annotation.UPDATING)) {
                        throw this.error(QueryError.UPDATINGTYPE, new Object[0]);
                    }
                    this.namedRecordTypeDecl(anns.check(false, true, false));
                } else {
                    if (!anns.isEmpty()) {
                        throw this.error(QueryError.VARFUNC, new Object[0]);
                    }
                    this.pos = p;
                    break;
                }
            }
            this.docBuilder.reset();
            this.skipWs();
            this.check(';');
        }
        if (!this.sparams.isEmpty()) {
            QueryBiConsumer<String, Object[]> parse = (k, v) -> this.qc.parameters().parse((String)k, (String)v[0], (InputInfo)v[1]);
            String key = SerializerOptions.PARAMETER_DOCUMENT.name();
            Object value = this.sparams.remove(key);
            if (value != null) {
                parse.accept(key, (Object[])value);
            }
            for (Map.Entry<String, Object> entry : this.sparams.entrySet()) {
                parse.accept(entry.getKey(), (Object[])entry.getValue());
            }
        }
    }

    private AnnList annotations(boolean updating) throws QueryException {
        AnnList anns = AnnList.EMPTY;
        while (true) {
            Ann ann;
            if (updating && this.wsConsumeWs("updating")) {
                ann = new Ann(this.info(), Annotation.UPDATING, (Value)Empty.VALUE);
            } else {
                Annotation def;
                if (!this.wsConsumeWs("%")) break;
                InputInfo ii = this.info();
                QNm name = this.eQName(QueryText.XQ_URI, QueryError.QNAME_X);
                ItemList items = new ItemList();
                if (this.wsConsume("(")) {
                    do {
                        Expr expr;
                        boolean truee;
                        if ((truee = this.wsConsume("true")) || this.consume("false")) {
                            this.wsCheck("(");
                            this.wsCheck(")");
                            expr = Bln.get(truee);
                        } else {
                            if (QueryParser.quote(this.current())) {
                                expr = Str.get(this.stringLiteral());
                            } else if (!this.consume(35)) {
                                expr = this.numericLiteral(0L, true);
                            } else {
                                this.skipWs();
                                expr = this.eQName(null, QueryError.QNAME_X);
                            }
                            if (!(expr instanceof Item)) {
                                if (Function.ERROR.is(expr)) {
                                    expr.item(this.qc, ii);
                                }
                                throw this.error(QueryError.ANNVALUE_X, this.currentAsString());
                            }
                        }
                        items.add((Item)expr);
                    } while (this.wsConsume(","));
                    this.wsCheck(")");
                }
                if ((def = Annotation.get(name)) == null) {
                    byte[] uri = name.uri();
                    if (NSGlobal.prefix(uri).length != 0 && !Token.eq(uri, QueryText.LOCAL_URI, QueryText.ERROR_URI)) {
                        throw this.error(NSGlobal.reserved(uri) ? QueryError.ANNWHICH_X_X : QueryError.BASEX_ANNOTATION1_X_X, ii, "%", name.string());
                    }
                    ann = new Ann(ii, name, items.value());
                } else {
                    if (def.single && anns.contains(def)) {
                        throw this.error(QueryError.BASEX_ANN3_X_X, ii, "%", def.name());
                    }
                    int is = items.size();
                    IntList arities = Functions.checkArity(is, def.minMax[0], def.minMax[1]);
                    if (arities != null) {
                        throw this.error(QueryError.BASEX_ANN2_X_X, ii, new Object[]{def, QueryError.arity(QueryError.arguments(is), arities)});
                    }
                    int al = def.params.length;
                    for (int i = 0; i < is; ++i) {
                        AtomType type = def.params[Math.min(al - 1, i)];
                        Item item = (Item)items.get(i);
                        if (item.type.instanceOf(type)) continue;
                        throw this.error(QueryError.BASEX_ANN_X_X_X, ii, new Object[]{def, type, item.seqType()});
                    }
                    ann = new Ann(ii, def, items.value());
                }
            }
            anns = anns.attach(ann);
            if (ann.definition != Annotation.UPDATING) continue;
            this.qc.updating();
        }
        return anns;
    }

    private void namespaceDecl() throws QueryException {
        byte[] prefix = this.ncName(QueryError.NONAME_X);
        this.wsCheck("=");
        byte[] uri = this.stringLiteral();
        if (this.sc.ns.staticURI(prefix) != null) {
            throw this.error(QueryError.DUPLNSDECL_X, new Object[]{prefix});
        }
        this.sc.ns.add(prefix, uri, this.info());
        this.namespaces.put(prefix, uri);
    }

    private void revalidationDecl() throws QueryException {
        if (!this.decl.add("revalidation")) {
            throw this.error(QueryError.DUPLREVAL, new Object[0]);
        }
        if (this.wsConsumeWs("strict") || this.wsConsumeWs("lax")) {
            throw this.error(QueryError.NOREVAL, new Object[0]);
        }
        this.wsCheck("skip");
    }

    private void boundarySpaceDecl() throws QueryException {
        if (!this.decl.add("boundary-space")) {
            throw this.error(QueryError.DUPLBOUND, new Object[0]);
        }
        boolean spaces = this.wsConsumeWs("preserve");
        if (!spaces) {
            this.wsCheck("strip");
        }
        this.sc.spaces = spaces;
    }

    private boolean defaultNamespaceDecl() throws QueryException {
        boolean elem = this.wsConsumeWs("element");
        if (!elem && !this.wsConsumeWs("function")) {
            return false;
        }
        this.wsCheck("namespace");
        byte[] uri = this.stringLiteral();
        if (Token.eq(QueryText.XML_URI, uri)) {
            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XML);
        }
        if (Token.eq(QueryText.XMLNS_URI, uri)) {
            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XMLNS);
        }
        if (elem) {
            if (!this.decl.add("element")) {
                throw this.error(QueryError.DUPLNS, new Object[0]);
            }
            this.sc.elemNS = uri.length == 0 ? null : uri;
        } else {
            if (!this.decl.add("function")) {
                throw this.error(QueryError.DUPLNS, new Object[0]);
            }
            this.sc.funcNS = uri.length == 0 ? null : uri;
        }
        return true;
    }

    private void optionDecl() throws QueryException {
        this.skipWs();
        QNm qname = this.eQName(QueryText.XQ_URI, QueryError.QNAME_X);
        String name = Token.string(qname.local());
        String value = Token.string(this.stringLiteral());
        byte[] uri = qname.uri();
        if (Token.eq(uri, QueryText.OUTPUT_URI)) {
            if (this.sc.module != null) {
                throw this.error(QueryError.OUTPUTLIB_X, name);
            }
            if (this.sparams.put(name, new Object[]{value, this.info()}) != null) {
                throw this.error(QueryError.OUTDUPL_X, name);
            }
        } else if (Token.eq(uri, QueryText.DB_URI)) {
            if (this.sc.module != null) {
                throw this.error(QueryError.BASEX_OPTIONSLIB_X, name);
            }
            this.qc.options.add(name, value, this);
        } else if (Token.eq(uri, QueryText.BASEX_URI)) {
            if (!name.equals("lock")) {
                throw this.error(QueryError.BASEX_OPTIONSINV_X, name);
            }
            for (String lock : Locking.queryLocks(Token.token(value))) {
                this.qc.locks.add(lock);
            }
        }
    }

    private void orderingModeDecl() throws QueryException {
        if (!this.decl.add("ordering")) {
            throw this.error(QueryError.DUPLORD, new Object[0]);
        }
        this.sc.ordered = this.wsConsumeWs("ordered");
        if (!this.sc.ordered) {
            this.wsCheck("unordered");
        }
    }

    private boolean emptyOrderDecl() throws QueryException {
        if (!this.wsConsumeWs("order")) {
            return false;
        }
        this.wsCheck("empty");
        if (!this.decl.add("empty")) {
            throw this.error(QueryError.DUPLORDEMP, new Object[0]);
        }
        this.sc.orderGreatest = this.wsConsumeWs("greatest");
        if (!this.sc.orderGreatest) {
            this.wsCheck("least");
        }
        return true;
    }

    private void copyNamespacesDecl() throws QueryException {
        if (!this.decl.add("copy-namespaces")) {
            throw this.error(QueryError.DUPLCOPYNS, new Object[0]);
        }
        this.sc.preserveNS = this.wsConsumeWs("preserve");
        if (!this.sc.preserveNS) {
            this.wsCheck("no-preserve");
        }
        this.wsCheck(",");
        this.sc.inheritNS = this.wsConsumeWs("inherit");
        if (!this.sc.inheritNS) {
            this.wsCheck("no-inherit");
        }
    }

    private boolean decimalFormatDecl(boolean def) throws QueryException {
        if (def && !this.wsConsumeWs("decimal-format")) {
            return false;
        }
        byte[] name = (def ? QNm.EMPTY : this.eQName(null, QueryError.QNAME_X)).unique();
        if (this.sc.decFormats.get(name) != null) {
            throw this.error(QueryError.DECDUPL, new Object[0]);
        }
        DecFormatOptions options = new DecFormatOptions();
        while (true) {
            this.skipWs();
            String prop = Token.string(this.ncName(null));
            if (prop.isEmpty()) break;
            this.wsCheck("=");
            if (options.get(prop) != null) {
                throw this.error(QueryError.DECDUPLPROP_X, prop);
            }
            try {
                options.assign(prop, Token.string(this.stringLiteral()));
            }
            catch (BaseXException ex) {
                throw this.error(QueryError.FORMPROP_X, ex);
            }
        }
        this.sc.decFormats.put(name, new DecFormatter(options, this.info()));
        return true;
    }

    private boolean defaultCollationDecl() throws QueryException {
        if (!this.wsConsumeWs("collation")) {
            return false;
        }
        if (!this.decl.add("collation")) {
            throw this.error(QueryError.DUPLCOLL, new Object[0]);
        }
        this.sc.collation = Collation.get(this.stringLiteral(), this.qc, this.info(), QueryError.WHICHDEFCOLL_X);
        return true;
    }

    private void baseURIDecl() throws QueryException {
        if (!this.decl.add("base-uri")) {
            throw this.error(QueryError.DUPLBASE, new Object[0]);
        }
        this.sc.baseURI(Token.string(this.stringLiteral()));
    }

    private void schemaImport() throws QueryException {
        byte[] prefix = null;
        if (this.wsConsumeWs("namespace")) {
            prefix = this.ncName(QueryError.NONAME_X);
            if (Token.eq(prefix, Token.XML, Token.XMLNS)) {
                throw this.error(QueryError.BINDXML_X, new Object[]{prefix});
            }
            this.wsCheck("=");
        } else if (this.wsConsumeWs("default")) {
            this.wsCheck("element");
            this.wsCheck("namespace");
        }
        byte[] uri = this.stringLiteral();
        if (prefix != null && uri.length == 0) {
            throw this.error(QueryError.NSEMPTY, new Object[0]);
        }
        if (!Uri.get(uri).isValid()) {
            throw this.error(QueryError.INVURI_X, new Object[]{uri});
        }
        this.addLocations(new TokenList());
        throw this.error(QueryError.IMPLSCHEMA, new Object[0]);
    }

    private void moduleImport() throws QueryException {
        byte[] pth;
        byte[] uri;
        byte[] prefix = Token.EMPTY;
        if (this.wsConsumeWs("namespace")) {
            prefix = this.ncName(QueryError.NONAME_X);
            this.wsCheck("=");
        }
        if ((uri = Token.trim(this.stringLiteral())).length == 0) {
            throw this.error(QueryError.NSMODURI, new Object[0]);
        }
        if (!Uri.get(uri).isValid()) {
            throw this.error(QueryError.INVURI_X, new Object[]{uri});
        }
        if (this.moduleURIs.contains(Token.token(uri))) {
            throw this.error(QueryError.DUPLMODULE_X, new Object[]{uri});
        }
        this.moduleURIs.add(uri);
        if (prefix != Token.EMPTY) {
            if (this.sc.ns.staticURI(prefix) != null) {
                throw this.error(QueryError.DUPLNSDECL_X, new Object[]{prefix});
            }
            this.sc.ns.add(prefix, uri, this.info());
            this.namespaces.put(prefix, uri);
        }
        ModInfo mi = new ModInfo();
        if (!this.addLocations(mi.paths) && (pth = this.qc.modDeclared.get(uri)) != null) {
            mi.paths.add(pth);
        }
        mi.uri = uri;
        mi.info = this.info();
        this.modules.add(mi);
    }

    private boolean addLocations(TokenList list) throws QueryException {
        boolean add = this.wsConsume("at");
        if (add) {
            do {
                byte[] uri;
                if (!Uri.get(uri = this.stringLiteral()).isValid() || IO.get(Token.string(uri)) instanceof IOContent) {
                    throw this.error(QueryError.INVURI_X, new Object[]{uri});
                }
                list.add(uri);
            } while (this.wsConsume(","));
        }
        return add;
    }

    private void importModules() throws QueryException {
        for (ModInfo mi : this.modules) {
            this.importModule(mi);
        }
    }

    private void importModule(ModInfo mi) throws QueryException {
        byte[] uri = mi.uri;
        if (mi.paths.isEmpty()) {
            if (Functions.staticURI(uri) || this.qc.resources.modules().addImport(Token.string(uri), this, mi.info)) {
                return;
            }
            throw this.error(QueryError.WHICHMOD_X, mi.info, new Object[]{uri});
        }
        for (byte[] pth : mi.paths) {
            this.module(Token.string(pth), Token.string(uri), mi.info);
        }
    }

    public final void module(String pth, String uri, InputInfo info) throws QueryException {
        LibraryModule lib;
        IO io = this.sc.resolve(pth, uri);
        byte[] tPath = Token.token(io.path());
        byte[] tUri = Token.token(uri);
        byte[] pUri = this.qc.modParsed.get(tPath);
        if (pUri != null) {
            if (!Token.eq(tUri, pUri)) {
                throw this.error(QueryError.WRONGMODULE_X_X_X, info, io.name(), uri, pUri);
            }
        } else {
            String query;
            this.qc.modParsed.put(tPath, tUri);
            try {
                query = io.readString();
            }
            catch (IOException expr) {
                Util.debug(expr);
                throw this.error(QueryError.WHICHMODFILE_X, info, io);
            }
            this.qc.modStack.push(tPath);
            QueryParser qp = new QueryParser(query, io.path(), this.qc, null);
            qp.sc.resolver = this.sc.resolver;
            LibraryModule lib2 = qp.parseLibrary(false);
            this.qc.libs.put(tPath, lib2);
            byte[] muri = lib2.sc.module.uri();
            if (!uri.equals(Token.string(muri))) {
                throw this.error(QueryError.WRONGMODULE_X_X_X, info, io.name(), uri, muri);
            }
            StaticContext sctx = qp.sc;
            if (sctx.contextType != null) {
                if (this.sc.contextType == null) {
                    this.sc.contextType = sctx.contextType;
                } else if (!sctx.contextType.eq(this.sc.contextType)) {
                    throw this.error(QueryError.VALUETYPES_X_X, sctx.contextType, this.sc.contextType);
                }
            }
            this.qc.modStack.pop();
        }
        if ((lib = this.qc.libs.get(tPath)) != null) {
            for (QNm qn : lib.types) {
                if (this.declaredTypes.contains(qn)) {
                    throw this.error(QueryError.DUPLTYPE_X, new Object[]{qn.string()});
                }
                this.declaredTypes.put(qn, (SeqType)lib.types.get(qn));
            }
        }
    }

    private void contextValueDecl() throws QueryException {
        SeqType st;
        boolean item = this.wsConsume("item");
        if (!item) {
            this.wsCheck("value");
        }
        if (!this.decl.add("value")) {
            throw this.error(QueryError.DUPLVALUE, new Object[0]);
        }
        SeqType cst = this.sc.contextType;
        SeqType seqType = cst != null ? cst : (st = item ? SeqType.ITEM_O : SeqType.ITEM_ZM);
        if (this.wsConsumeWs("as")) {
            this.sc.contextType = st = item ? this.itemType() : this.sequenceType();
            this.qc.contextType = st;
            if (cst != null && !cst.eq(st)) {
                throw this.error(QueryError.VALUETYPES_X_X, cst, st);
            }
        }
        boolean external = this.wsConsumeWs("external");
        if (!this.consume(":=")) {
            if (external) {
                return;
            }
            throw this.error(QueryError.WRONGCHAR_X_X, ":=", this.found());
        }
        if (!external) {
            this.qc.finalContext = true;
        }
        this.localVars.pushContext(false);
        Expr expr = this.check(this.single(), QueryError.NOEXPR);
        VarScope vs = this.localVars.popContext();
        this.qc.contextValue = new ContextScope(expr, st, vs, this.sc, this.info(), this.docBuilder.toString());
        if (this.sc.module != null) {
            throw this.error(QueryError.DECITEM, new Object[0]);
        }
        if (!this.sc.mixUpdates && expr.has(Flag.UPD)) {
            throw this.error(QueryError.UPCTX, expr);
        }
    }

    private void varDecl(AnnList anns) throws QueryException {
        Var var = this.newVar();
        if (this.sc.module != null && !Token.eq(var.name.uri(), this.sc.module.uri())) {
            throw this.error(QueryError.MODULENS_X, var);
        }
        this.localVars.pushContext(false);
        boolean external = this.wsConsumeWs("external");
        Expr expr = null;
        if (this.wsConsume(":=")) {
            expr = this.check(this.single(), QueryError.NOVARDECL);
        } else if (!external) {
            throw this.error(QueryError.WRONGCHAR_X_X, ":=", this.found());
        }
        VarScope vs = this.localVars.popContext();
        String doc = this.docBuilder.toString();
        StaticVar sv = this.qc.vars.declare(var, expr, anns, external, vs, doc);
        this.vars.add(sv);
    }

    private SeqType optAsType() throws QueryException {
        return this.wsConsumeWs("as") ? this.sequenceType() : null;
    }

    private void constructionDecl() throws QueryException {
        if (!this.decl.add("construction")) {
            throw this.error(QueryError.DUPLCONS, new Object[0]);
        }
        this.sc.strip = this.wsConsumeWs("strip");
        if (!this.sc.strip) {
            this.wsCheck("preserve");
        }
    }

    private void functionDecl(AnnList anns) throws QueryException {
        InputInfo ii = this.info();
        QNm name = this.eQName(this.sc.funcNS, QueryError.FUNCNAME);
        if (QueryParser.reserved(name)) {
            throw this.error(QueryError.RESERVED_X, new Object[]{name.local()});
        }
        this.wsCheck("(");
        if (this.sc.module != null && !Token.eq(name.uri(), this.sc.module.uri())) {
            throw this.error(QueryError.MODULENS_X, name);
        }
        this.localVars.pushContext(false);
        Params params = this.paramList(true);
        Expr expr = this.wsConsumeWs("external") ? null : this.enclosedExpr();
        String doc = this.docBuilder.toString();
        VarScope vs = this.localVars.popContext();
        StaticFunc func = this.qc.functions.declare(name, params, expr, anns, doc, vs, ii);
        this.funcs.add(func);
    }

    private static boolean reserved(QNm name) {
        return !name.hasPrefix() && KEYWORDS.contains(name.string());
    }

    private void typeDecl(AnnList anns) throws QueryException {
        QNm qn = this.eQName(this.sc.elemNS, QueryError.TYPENAME);
        if (this.declaredTypes.contains(qn)) {
            throw this.error(QueryError.DUPLTYPE_X, new Object[]{qn.string()});
        }
        if (NSGlobal.reserved(qn.uri())) {
            throw this.error(QueryError.TYPERESERVED_X, new Object[]{qn.string()});
        }
        this.wsCheck("as");
        SeqType st = this.itemType();
        if (!anns.contains(Annotation.PRIVATE)) {
            if (this.sc.module != null && !Token.eq(qn.uri(), this.sc.module.uri())) {
                throw this.error(QueryError.MODULENS_X, qn);
            }
            this.publicTypes.put(qn, st);
        }
        this.declaredTypes.put(qn, st);
    }

    private void namedRecordTypeDecl(AnnList anns) throws QueryException {
        InputInfo ii = this.info();
        QNm qn = this.eQName(this.sc.elemNS, QueryError.TYPENAME);
        if (this.declaredTypes.contains(qn)) {
            throw this.error(QueryError.DUPLTYPE_X, new Object[]{qn.string()});
        }
        if (NSGlobal.reserved(qn.uri())) {
            throw this.error(QueryError.TYPERESERVED_X, new Object[]{qn.string()});
        }
        this.wsCheck("(");
        TokenObjectMap<RecordField> fields = new TokenObjectMap<RecordField>();
        boolean extensible = false;
        if (!this.wsConsume(")")) {
            boolean exprRequired = false;
            do {
                Object seqType;
                this.skipWs();
                if (!fields.isEmpty() && this.consume("*")) {
                    extensible = true;
                    break;
                }
                byte[] name = this.ncName(QueryError.NONCNAME_X);
                boolean optional = this.wsConsume("?");
                Object object = seqType = this.wsConsume("as") ? this.sequenceType() : null;
                if (fields.contains(name)) {
                    throw this.error(QueryError.DUPFIELD_X, new Object[]{name});
                }
                this.skipWs();
                Expr expr = null;
                if (exprRequired && !optional || this.current() == 58) {
                    this.consume(":=");
                    this.localVars.pushContext(false);
                    expr = this.check(this.single(), QueryError.NOEXPR);
                    this.localVars.popContext();
                    exprRequired = true;
                }
                fields.put(name, new RecordField(optional, (SeqType)seqType, expr));
            } while (this.wsConsume(","));
            this.wsCheck(")");
        }
        RecordType rt = new RecordType(extensible, fields, qn);
        this.declaredTypes.put(qn, rt.seqType());
        this.namedRecordTypes.put(qn, rt);
        if (!anns.contains(Annotation.PRIVATE)) {
            if (this.sc.module != null && !Token.eq(qn.uri(), this.sc.module.uri())) {
                throw this.error(QueryError.MODULENS_X, qn);
            }
            this.publicTypes.put(qn, rt.seqType());
        }
        if (qn.uri().length != 0) {
            this.localVars.pushContext(false);
            Params params = new Params();
            boolean defaults = false;
            for (byte[] key : fields) {
                RecordField rf = fields.get(key);
                boolean optional = rf.isOptional();
                Expr initExpr = rf.expr();
                if (optional || initExpr != null) {
                    defaults = true;
                } else if (defaults) {
                    throw this.error(QueryError.PARAMOPTIONAL_X, new Object[]{key});
                }
                SeqType fst = rf.seqType();
                SeqType pst = optional ? fst.union(Occ.ZERO) : fst;
                Expr init = initExpr == null && optional ? Empty.VALUE : initExpr;
                params.add(new QNm(key), pst, init, null);
            }
            if (rt.isExtensible()) {
                Object name;
                byte[] key;
                int i = -1;
                while (fields.contains(key = Token.token((String)(name = ++i == 0 ? "options" : "options" + i)))) {
                }
                params.add(new QNm(key), SeqType.MAP_O, XQMap.empty(), null);
            }
            params.seqType(rt.seqType()).finish(this.qc, this.localVars);
            Var[] pv = params.vars();
            Expr[] args = new Expr[pv.length];
            for (int i = 0; i < pv.length; ++i) {
                args[i] = new VarRef(null, pv[i]);
            }
            CRecord expr = new CRecord(ii, rt, args);
            String doc = this.docBuilder.toString();
            VarScope vs = this.localVars.popContext();
            StaticFunc func = this.qc.functions.declare(qn, params, expr, anns, doc, vs, this.info());
            this.funcs.add(func);
        }
    }

    private Params paramList(boolean dflt) throws QueryException {
        Params params = new Params();
        boolean defaults = false;
        do {
            this.skipWs();
            if (this.current() != 36 && params.size() == 0) break;
            InputInfo ii = this.info();
            QNm name = this.varName();
            SeqType type = this.optAsType();
            Expr expr = null;
            if (dflt && this.wsConsume(":=")) {
                defaults = true;
                expr = this.single();
            } else if (defaults) {
                throw this.error(QueryError.PARAMOPTIONAL_X, name);
            }
            params.add(name, type, expr, ii);
        } while (this.consume(44));
        this.wsCheck(")");
        return params.seqType(this.optAsType()).finish(this.qc, this.localVars);
    }

    private Expr enclosedExpr() throws QueryException {
        this.wsCheck("{");
        Expr expr = this.expr();
        this.wsCheck("}");
        return expr == null ? Empty.VALUE : expr;
    }

    private Expr expr() throws QueryException {
        Expr expr = this.single();
        if (expr == null) {
            if (this.more()) {
                return null;
            }
            throw this.alterError(QueryError.NOEXPR);
        }
        if (!this.wsConsume(",")) {
            return expr;
        }
        ExprList el = (ExprList)((Object)new ExprList().add(expr));
        do {
            this.add(el, this.single());
        } while (this.wsConsume(","));
        return new List(this.info(), (Expr[])el.finish());
    }

    private Expr single() throws QueryException {
        this.alter = null;
        Expr expr = this.flwor();
        if (expr == null) {
            expr = this.quantified();
        }
        if (expr == null) {
            expr = this.switchh();
        }
        if (expr == null) {
            expr = this.typeswitch();
        }
        if (expr == null) {
            expr = this.iff();
        }
        if (expr == null) {
            expr = this.tryCatch();
        }
        if (expr == null) {
            expr = this.insert();
        }
        if (expr == null) {
            expr = this.delete();
        }
        if (expr == null) {
            expr = this.rename();
        }
        if (expr == null) {
            expr = this.replace();
        }
        if (expr == null) {
            expr = this.updatingFunctionCall();
        }
        if (expr == null) {
            expr = this.copyModify();
        }
        if (expr == null) {
            expr = this.or();
        }
        return expr;
    }

    /*
     * Unable to fully structure code
     */
    private Expr flwor() throws QueryException {
        s = this.localVars.openScope();
        clauses = this.initialClause(null);
        if (clauses == null) {
            return null;
        }
        curr = new TokenObjectMap<Var>();
        for (Clause fl : clauses) {
            for (Var var : fl.vars()) {
                curr.put(var.name.unique(), var);
            }
        }
        do lbl-1000:
        // 3 sources

        {
            size = clauses.size();
            this.initialClause(clauses);
            for (Clause clause : clauses) {
                for (Var var : clause.vars()) {
                    curr.put(var.name.unique(), var);
                }
            }
            if (size < clauses.size()) ** GOTO lbl-1000
            if (this.wsConsumeWs("where")) {
                this.alterPos = this.pos;
                clauses.add(new Where(this.check(this.single(), QueryError.NOWHERE), this.info()));
            }
            if (this.wsConsumeWs("while")) {
                this.alterPos = this.pos;
                clauses.add(new While(this.check(this.single(), QueryError.NOWHILE), this.info()));
            }
            if (this.wsConsumeWs("group")) {
                this.wsCheck("by");
                this.skipWs();
                this.alterPos = this.pos;
                specs = this.groupSpecs(clauses);
                ng = new ArrayList<VarRef>();
                for (GroupSpec spec : specs) {
                    curr.put(spec.var.name.unique(), spec.var);
                }
                block6: for (Var var : curr.values()) {
                    for (GroupSpec spec : specs) {
                        if (spec.var == var) continue block6;
                    }
                    ng.add(new VarRef(specs[0].info(), var));
                }
                ns = ng.size();
                ngrp = new Var[ns];
                i = ns;
                while (--i >= 0) {
                    ref = (VarRef)ng.get(i);
                    ngrp[i] = nv = this.localVars.add(new Var(ref.var.name, null, this.qc, ref.var.info));
                    curr.put(nv.name.unique(), nv);
                }
                clauses.add(new GroupBy(specs, (VarRef[])ng.toArray((IntFunction<VarRef[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$flwor$1(int ), (I)[Lorg/basex/query/var/VarRef;)()), ngrp, specs[0].info()));
            }
            if (stable = this.wsConsumeWs("stable")) {
                this.wsCheck("order");
            }
            if (stable || this.wsConsumeWs("order")) {
                this.wsCheck("by");
                this.alterPos = this.pos;
                keys = null;
                do {
                    key = this.orderSpec();
                    if (keys == null) {
                        v0 = new OrderKey[1];
                        v1 = v0;
                        v0[0] = key;
                        continue;
                    }
                    v1 = keys = Array.add(keys, key);
                } while (this.wsConsume(","));
                vs = new VarRef[curr.size()];
                i = 0;
                for (Var var : curr.values()) {
                    vs[i++] = new VarRef(keys[0].info(), var);
                }
                clauses.add(new OrderBy(vs, keys, keys[0].info()));
            }
            if (!this.wsConsumeWs("count", QueryError.NOCOUNT, new String[]{"$"})) continue;
            var = this.localVars.add(this.newVar(SeqType.INTEGER_O));
            curr.put(var.name.unique(), var);
            clauses.add(new Count(var));
        } while (size < clauses.size());
        if (!this.wsConsumeWs("return")) {
            throw this.alterError(QueryError.FLWORRETURN);
        }
        rtrn = this.check(this.single(), QueryError.NORETURN);
        this.localVars.closeScope(s);
        return new GFLWOR(clauses.peek().info(), clauses, rtrn);
    }

    private LinkedList<Clause> initialClause(LinkedList<Clause> clauses) throws QueryException {
        LinkedList<Clause> cls = clauses;
        if (this.wsConsumeWs("for", QueryError.NOWINDOW, "sliding", "tumbling")) {
            if (cls == null) {
                cls = new LinkedList();
            }
            cls.add(this.windowClause());
        } else {
            boolean fr;
            boolean lt = this.wsConsumeWs("let", QueryError.NOLET, "$", "score");
            boolean bl = fr = !lt && this.wsConsumeWs("for", QueryError.NOFOR, "$", "member", "key", "value");
            if (lt || fr) {
                if (cls == null) {
                    cls = new LinkedList();
                }
                if (lt) {
                    this.letClause(cls);
                } else {
                    this.forClause(cls);
                }
            }
        }
        return cls;
    }

    private void forClause(LinkedList<Clause> clauses) throws QueryException {
        do {
            Var entries;
            boolean empty;
            Var member = this.wsConsumeWs("member") ? this.newVar() : null;
            Var key = member == null && this.wsConsumeWs("key") ? this.newVar() : null;
            Var value = member == null && this.wsConsumeWs("value") ? this.newVar() : null;
            Var fr = member == null && key == null && value == null ? this.newVar() : null;
            boolean bl = empty = fr != null && this.wsConsume("allowing");
            if (empty) {
                this.wsCheck("empty");
            }
            Var at = this.wsConsumeWs("at") ? this.newVar(SeqType.INTEGER_O) : null;
            Var score = this.wsConsumeWs("score") ? this.newVar(SeqType.DOUBLE_O) : null;
            this.wsCheck("in");
            InputInfo ii = this.info();
            Expr expr = this.check(this.single(), QueryError.NOVARDECL);
            QNmSet names = new QNmSet();
            for (Var var : new Var[]{member, key, value, fr, at, score}) {
                if (var == null || names.add(var.name)) continue;
                throw this.error(QueryError.DUPLVAR_X, var);
            }
            this.localVars.add(fr, at, score);
            if (fr != null) {
                clauses.add(new For(fr, at, score, expr, empty));
                continue;
            }
            if (member != null) {
                Var split = new Var(member.name, null, this.qc, ii);
                this.localVars.add(split, member);
                clauses.add(new For(split, at, score, Function._ARRAY_SPLIT.get(ii, expr), false));
                clauses.add(new Let(member, Function._ARRAY_ITEMS.get(ii, new VarRef(ii, split))));
                continue;
            }
            if (value == null) {
                this.localVars.add(key);
                clauses.add(new For(key, at, score, Function._MAP_KEYS.get(ii, expr), false));
                continue;
            }
            if (key == null) {
                entries = new Var(value.name, null, this.qc, ii);
                this.localVars.add(entries, value);
                clauses.add(new For(entries, at, score, Function._MAP_ENTRIES.get(ii, expr), false));
                clauses.add(new Let(value, Function._MAP_ITEMS.get(ii, new VarRef(ii, entries))));
                continue;
            }
            entries = this.localVars.add(new Var(value.name, null, this.qc, ii));
            this.localVars.add(entries, key, value);
            clauses.add(new For(entries, at, score, Function._MAP_ENTRIES.get(ii, expr), false));
            clauses.add(new Let(key, Function._MAP_KEYS.get(ii, new VarRef(ii, entries))));
            clauses.add(new Let(value, Function._MAP_ITEMS.get(ii, new VarRef(ii, entries))));
        } while (this.wsConsumeWs(","));
    }

    private void letClause(LinkedList<Clause> clauses) throws QueryException {
        do {
            boolean score;
            Var lt = (score = this.wsConsumeWs("score")) ? this.newVar(SeqType.DOUBLE_O) : this.newVar();
            this.wsCheck(":=");
            Expr expr = this.check(this.single(), QueryError.NOVARDECL);
            clauses.add(new Let(this.localVars.add(lt), expr, score));
        } while (this.wsConsume(","));
    }

    private Window windowClause() throws QueryException {
        boolean check;
        boolean sliding = !this.wsConsume("tumbling") && this.wsConsume("sliding");
        this.wsCheck("window");
        this.skipWs();
        Var var = this.newVar();
        this.wsCheck("in");
        Expr expr = this.check(this.single(), QueryError.NOVARDECL);
        Condition start = this.wsConsume("start") ? this.windowCond(true) : new Condition(true, null, null, null, null, Bln.TRUE, this.info());
        Condition end = null;
        boolean only = this.wsConsume("only");
        boolean bl = check = sliding || only;
        if (check || this.wsConsume("end")) {
            if (check) {
                this.wsCheck("end");
            }
            end = this.windowCond(false);
        }
        return new Window(sliding, this.localVars.add(var), expr, start, only, end);
    }

    private Condition windowCond(boolean start) throws QueryException {
        this.skipWs();
        InputInfo ii = this.info();
        Var var = this.current(36) ? this.localVars.add(this.newVar(SeqType.ITEM_O)) : null;
        Var at = this.wsConsumeWs("at") ? this.localVars.add(this.newVar(SeqType.INTEGER_O)) : null;
        Var prv = this.wsConsumeWs("previous") ? this.localVars.add(this.newVar(SeqType.ITEM_ZO)) : null;
        Var nxt = this.wsConsumeWs("next") ? this.localVars.add(this.newVar(SeqType.ITEM_ZO)) : null;
        Bln expr = this.wsConsume("when") ? this.check(this.single(), QueryError.NOEXPR) : Bln.TRUE;
        return new Condition(start, var, at, prv, nxt, expr, ii);
    }

    private OrderKey orderSpec() throws QueryException {
        boolean least;
        Expr expr = this.check(this.single(), QueryError.ORDERBY);
        boolean desc = false;
        if (!this.wsConsumeWs("ascending")) {
            desc = this.wsConsumeWs("descending");
        }
        boolean bl = least = !this.sc.orderGreatest;
        if (this.wsConsumeWs("empty")) {
            boolean bl2 = least = !this.wsConsumeWs("greatest");
            if (least) {
                this.wsCheck("least");
            }
        }
        Collation coll = this.wsConsumeWs("collation") ? Collation.get(this.stringLiteral(), this.qc, this.info(), QueryError.FLWORCOLL_X) : this.sc.collation;
        return new OrderKey(this.info(), expr, desc, least, coll);
    }

    private GroupSpec[] groupSpecs(LinkedList<Clause> cl) throws QueryException {
        GroupSpec[] specs = null;
        do {
            Expr by;
            boolean checksType;
            Var var = this.newVar();
            boolean bl = checksType = var.declType != null;
            if (checksType || this.wsConsume(":=")) {
                if (checksType) {
                    this.wsCheck(":=");
                }
                by = this.check(this.single(), QueryError.NOVARDECL);
            } else {
                VarRef ref = this.localVars.resolveLocal(var.name, var.info);
                boolean dec = false;
                if (ref != null) {
                    for (Clause f : cl) {
                        if (!f.declares(ref.var)) continue;
                        dec = true;
                        break;
                    }
                    if (!dec && specs != null) {
                        for (Iterator iterator : specs) {
                            if (((GroupSpec)((Object)iterator)).var != ref.var) continue;
                            dec = true;
                            break;
                        }
                    }
                }
                if (!dec) {
                    throw this.error(QueryError.GVARNOTDEFINED_X, var);
                }
                by = ref;
            }
            Collation coll = this.wsConsumeWs("collation") ? Collation.get(this.stringLiteral(), this.qc, this.info(), QueryError.FLWORCOLL_X) : this.sc.collation;
            GroupSpec spec = new GroupSpec(var.info, this.localVars.add(var), by, coll);
            if (specs == null) {
                specs = new GroupSpec[]{spec};
                continue;
            }
            int i = specs.length;
            while (--i >= 0) {
                if (!specs[i].var.name.eq(spec.var.name)) continue;
                specs[i].occluded = true;
                break;
            }
            specs = Array.add(specs, spec);
        } while (this.wsConsumeWs(","));
        return specs;
    }

    private Expr quantified() throws QueryException {
        boolean every;
        boolean some = this.wsConsumeWs("some", QueryError.NOSOME, "$");
        boolean bl = every = !some && this.wsConsumeWs("every", QueryError.NOSOME, "$");
        if (!some && !every) {
            return null;
        }
        int s = this.localVars.openScope();
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        do {
            Var var = this.newVar();
            this.wsCheck("in");
            Expr expr = this.check(this.single(), QueryError.NOSOME);
            clauses.add(new For(this.localVars.add(var), expr));
        } while (this.wsConsumeWs(","));
        this.wsCheck("satisfies");
        StandardFunc rtrn = Function.BOOLEAN.get(this.info(), this.check(this.single(), QueryError.NOSOME));
        this.localVars.closeScope(s);
        InputInfo ii = ((Clause)clauses.peek()).info();
        GFLWOR flwor = new GFLWOR(ii, clauses, (Expr)rtrn);
        CmpG cmp = new CmpG(ii, (Expr)flwor, (Expr)Bln.get(some), CmpG.OpG.EQ);
        return some ? cmp : Function.NOT.get(ii, cmp);
    }

    private Expr switchh() throws QueryException {
        ExprList exprs;
        if (!this.wsConsumeWs("switch", QueryError.NOSWITCH, "(", "{", "case")) {
            return null;
        }
        InputInfo ii = this.info();
        this.check('(');
        Expr cond = this.expr();
        this.wsCheck(")");
        boolean brace = this.wsConsume("{");
        ArrayList<SwitchGroup> groups = new ArrayList<SwitchGroup>();
        do {
            exprs = (ExprList)((Object)new ExprList().add((Expr)null));
            while (this.wsConsumeWs("case")) {
                this.add(exprs, this.check(this.expr(), QueryError.NOSWITCH));
            }
            if (exprs.size() == 1) {
                if (groups.isEmpty()) {
                    throw this.error(QueryError.WRONGCHAR_X_X, "case", this.found());
                }
                this.wsCheck("default");
            }
            this.wsCheck("return");
            exprs.set(0, this.check(this.single(), QueryError.NOSWITCH));
            groups.add(new SwitchGroup(this.info(), (Expr[])exprs.finish()));
        } while (exprs.size() != 1);
        if (brace) {
            this.wsCheck("}");
        }
        return new Switch(ii, cond != null ? cond : Bln.TRUE, (SwitchGroup[])groups.toArray(SwitchGroup[]::new));
    }

    private Expr typeswitch() throws QueryException {
        boolean cs;
        if (!this.wsConsumeWs("typeswitch", QueryError.NOTYPESWITCH, "(")) {
            return null;
        }
        InputInfo ii = this.info();
        this.check('(');
        Expr ts = this.check(this.expr(), QueryError.NOTYPESWITCH);
        this.wsCheck(")");
        boolean brace = this.wsConsume("{");
        TypeswitchGroup[] cases = new TypeswitchGroup[]{};
        ArrayList<SeqType> types = new ArrayList<SeqType>();
        int s = this.localVars.openScope();
        do {
            if (!(cs = this.wsConsumeWs("case"))) {
                this.wsCheck("default");
                this.skipWs();
            }
            Var var = null;
            if (this.current(36)) {
                var = this.localVars.add(this.newVar(SeqType.ITEM_ZM));
                if (cs) {
                    this.wsCheck("as");
                }
            }
            if (cs) {
                do {
                    types.add(this.sequenceType());
                } while (this.wsConsume("|"));
            }
            this.wsCheck("return");
            Expr rtrn = this.check(this.single(), QueryError.NOTYPESWITCH);
            SeqType[] st = (SeqType[])types.toArray(SeqType[]::new);
            cases = Array.add(cases, new TypeswitchGroup(this.info(), var, st, rtrn));
            this.localVars.closeScope(s);
            types.clear();
        } while (cs);
        if (brace) {
            this.wsCheck("}");
        }
        if (cases.length == 1) {
            throw this.error(QueryError.NOTYPESWITCH, new Object[0]);
        }
        return new Typeswitch(ii, ts, cases);
    }

    private Expr iff() throws QueryException {
        Expr expr;
        if (!this.wsConsumeWs("if", QueryError.IFPAR, "(")) {
            return null;
        }
        LinkedList<InputInfo> infos = new LinkedList<InputInfo>();
        infos.add(this.info());
        ExprList list = (ExprList)((Object)new ExprList(3L).add(this.ifCond()));
        if (this.wsConsumeWs("then")) {
            list.add(this.check(this.single(), QueryError.NOIF));
            if (this.wsConsumeWs("else")) {
                list.add(this.check(this.single(), QueryError.NOIF));
            }
        } else {
            list.add(this.enclosedExpr());
            while (this.wsConsume("else")) {
                if (!this.wsConsume("if")) {
                    list.add(this.enclosedExpr());
                    break;
                }
                infos.add(this.info());
                ((ExprList)((Object)list.add(this.ifCond()))).add(this.enclosedExpr());
            }
        }
        Expr expr2 = expr = (list.size() & 1) == 0 ? Empty.VALUE : (Expr)list.pop();
        while (!list.isEmpty()) {
            Expr thn = (Expr)list.pop();
            Expr cond = (Expr)list.pop();
            expr = new If((InputInfo)infos.removeLast(), cond, thn, expr);
        }
        return expr;
    }

    private Expr ifCond() throws QueryException {
        this.wsCheck("(");
        Expr expr = this.check(this.expr(), QueryError.NOIF);
        this.wsCheck(")");
        return expr;
    }

    private Expr or() throws QueryException {
        Expr expr = this.and();
        if (!this.wsConsumeWs("or")) {
            return expr;
        }
        InputInfo ii = this.info();
        ExprList el = (ExprList)((Object)new ExprList(2L).add(expr));
        do {
            this.add(el, this.and());
        } while (this.wsConsumeWs("or"));
        return new Or(ii, (Expr[])el.finish());
    }

    private Expr and() throws QueryException {
        Expr expr = this.comparison();
        if (!this.wsConsumeWs("and")) {
            return expr;
        }
        InputInfo ii = this.info();
        ExprList el = (ExprList)((Object)new ExprList(2L).add(expr));
        do {
            this.add(el, this.comparison());
        } while (this.wsConsumeWs("and"));
        return new And(ii, (Expr[])el.finish());
    }

    private Expr comparison() throws QueryException {
        Expr expr = this.ftContains();
        if (expr != null) {
            for (CmpV.OpV opV : CmpV.OpV.values()) {
                if (!this.wsConsumeWs(opV.name)) continue;
                return new CmpV(this.info(), expr, this.check(this.ftContains(), QueryError.CMPEXPR), opV);
            }
            for (Enum enum_ : CmpN.OpN.values()) {
                for (String name : ((CmpN.OpN)enum_).names) {
                    if (!this.wsConsumeWs(name)) continue;
                    return new CmpN(this.info(), expr, this.check(this.ftContains(), QueryError.CMPEXPR), (CmpN.OpN)enum_);
                }
            }
            for (Enum enum_ : CmpG.OpG.values()) {
                if (!this.wsConsumeWs(((CmpG.OpG)enum_).name)) continue;
                return new CmpG(this.info(), expr, this.check(this.ftContains(), QueryError.CMPEXPR), (CmpG.OpG)enum_);
            }
        }
        return expr;
    }

    private Expr ftContains() throws QueryException {
        Expr expr = this.otherwise();
        int p = this.pos;
        if (!this.wsConsumeWs("contains") || !this.wsConsumeWs("text")) {
            this.pos = p;
            return expr;
        }
        FTExpr select = this.ftSelection(false);
        if (this.wsConsumeWs("without")) {
            this.wsCheck("content");
            this.union();
            throw this.error(QueryError.FTIGNORE, new Object[0]);
        }
        return new FTContains(expr, select, this.info());
    }

    private Expr otherwise() throws QueryException {
        Expr expr = this.stringConcat();
        if (expr == null || !this.wsConsumeWs("otherwise")) {
            return expr;
        }
        ExprList el = (ExprList)((Object)new ExprList().add(expr));
        do {
            this.add(el, this.stringConcat());
        } while (this.wsConsume("otherwise"));
        return new Otherwise(this.info(), (Expr[])el.finish());
    }

    private Expr stringConcat() throws QueryException {
        Expr expr = this.range();
        if (expr == null || !this.consume("||")) {
            return expr;
        }
        ExprList el = (ExprList)((Object)new ExprList().add(expr));
        do {
            this.add(el, this.range());
        } while (this.wsConsume("||"));
        return new Concat(this.info(), (Expr[])el.finish());
    }

    private Expr range() throws QueryException {
        Expr expr = this.additive();
        if (!this.wsConsumeWs("to")) {
            return expr;
        }
        return new Range(this.info(), expr, this.check(this.additive(), QueryError.INCOMPLETE));
    }

    private Expr additive() throws QueryException {
        Expr expr = this.multiplicative();
        while (expr != null) {
            Calc c;
            Calc calc = this.consume(43) ? Calc.ADD : (c = this.next() != 62 && this.consume(45) ? Calc.SUBTRACT : null);
            if (c == null) break;
            expr = new Arith(this.info(), expr, this.check(this.multiplicative(), QueryError.CALCEXPR), c);
        }
        return expr;
    }

    private Expr multiplicative() throws QueryException {
        Expr expr = this.union();
        while (expr != null) {
            Calc c;
            Calc calc = this.consume(42) || this.consume(215) ? Calc.MULTIPLY : (this.consume(247) || this.wsConsumeWs("div") ? Calc.DIVIDE : (this.wsConsumeWs("idiv") ? Calc.DIVIDEINT : (c = this.wsConsumeWs("mod") ? Calc.MODULO : null)));
            if (c == null) break;
            expr = new Arith(this.info(), expr, this.check(this.union(), QueryError.CALCEXPR), c);
        }
        return expr;
    }

    private Expr union() throws QueryException {
        Expr expr = this.intersect();
        if (expr == null || !this.isUnion()) {
            return expr;
        }
        ExprList el = (ExprList)((Object)new ExprList().add(expr));
        do {
            this.add(el, this.intersect());
        } while (this.isUnion());
        return new Union(this.info(), (Expr[])el.finish());
    }

    private boolean isUnion() throws QueryException {
        if (this.wsConsumeWs("union")) {
            return true;
        }
        int p = this.pos;
        if (this.consume("|") && !this.consume("|")) {
            return true;
        }
        this.pos = p;
        return false;
    }

    private Expr intersect() throws QueryException {
        boolean is;
        Expr expr = this.instanceOf();
        boolean lastIs = false;
        ExprList el = null;
        while ((is = this.wsConsumeWs("intersect")) || this.wsConsumeWs("except")) {
            if (is != lastIs && el != null) {
                expr = this.intersectExcept(lastIs, el);
                el = null;
            }
            lastIs = is;
            if (el == null) {
                el = (ExprList)((Object)new ExprList().add(expr));
            }
            this.add(el, this.instanceOf());
        }
        return el != null ? this.intersectExcept(lastIs, el) : expr;
    }

    private Expr intersectExcept(boolean intersect, ExprList el) {
        return intersect ? new Intersect(this.info(), (Expr[])el.finish()) : new Except(this.info(), (Expr[])el.finish());
    }

    private Expr instanceOf() throws QueryException {
        Expr expr = this.treat();
        if (!this.wsConsumeWs("instance")) {
            return expr;
        }
        this.wsCheck("of");
        return new Instance(this.info(), expr, this.sequenceType());
    }

    private Expr treat() throws QueryException {
        Expr expr = this.coerce();
        if (!this.wsConsumeWs("treat")) {
            return expr;
        }
        this.wsCheck("as");
        return new Treat(this.info(), expr, this.sequenceType());
    }

    private Expr coerce() throws QueryException {
        Expr expr = this.castable();
        if (!this.wsConsumeWs("coerce")) {
            return expr;
        }
        this.wsCheck("to");
        return new TypeCheck(this.info(), expr, this.sequenceType());
    }

    private Expr castable() throws QueryException {
        Expr expr = this.cast();
        if (!this.wsConsumeWs("castable")) {
            return expr;
        }
        this.wsCheck("as");
        return new Castable(this.info(), expr, this.castTarget());
    }

    private Expr cast() throws QueryException {
        Expr expr = this.transformWith();
        if (!this.wsConsumeWs("cast")) {
            return expr;
        }
        this.wsCheck("as");
        return new Cast(this.info(), expr, this.castTarget());
    }

    private Expr transformWith() throws QueryException {
        Expr expr = this.pipeline();
        while (expr != null) {
            if (this.wsConsume("transform")) {
                this.wsCheck("with");
            } else if (!this.wsConsume("update")) break;
            this.qc.updating();
            expr = new TransformWith(this.info(), expr, this.enclosedExpr());
        }
        return expr;
    }

    private Expr pipeline() throws QueryException {
        Expr expr = this.arrow();
        if (expr != null && (this.wsConsumeWs("->") || this.wsConsumeWs("-\uff1e"))) {
            ExprList el = new ExprList(expr);
            do {
                this.add(el, this.arrow());
            } while (this.wsConsumeWs("->") || this.wsConsumeWs("-\uff1e"));
            return new Pipeline(this.info(), (Expr[])el.finish());
        }
        return expr;
    }

    private Expr arrow() throws QueryException {
        Expr expr = this.unary();
        if (expr != null) {
            while (true) {
                Expr arg;
                Expr ex;
                boolean mapping;
                boolean bl = mapping = this.wsConsume("=!>") || this.wsConsume("=!\uff1e");
                if (!mapping && !this.consume("=>") && !this.consume("=\uff1e")) break;
                QNm name = null;
                this.skipWs();
                if (this.current(36)) {
                    ex = this.varRef();
                } else if (this.current(40)) {
                    ex = this.parenthesized();
                } else {
                    ex = this.mapConstructor();
                    if (ex == null) {
                        ex = this.arrayConstructor();
                    }
                    if (ex == null) {
                        ex = this.functionItem();
                    }
                    if (ex == null && QueryParser.reserved(name = this.eQName(this.sc.funcNS, QueryError.ARROWSPEC_X))) {
                        throw this.error(QueryError.RESERVED_X, new Object[]{name.local()});
                    }
                }
                InputInfo ii = this.info();
                For fr = null;
                int s = 0;
                if (mapping) {
                    s = this.localVars.openScope();
                    fr = new For(this.localVars.add(new Var(new QNm("item"), null, this.qc, ii)), expr);
                    arg = new VarRef(ii, fr.var);
                } else {
                    arg = expr;
                }
                FuncBuilder fb = this.argumentList(ex == null, arg);
                Expr expr2 = expr = ex != null ? Functions.dynamic(ex, fb) : Functions.get(name, fb, this.qc, this.moduleURIs.contains(name.uri()));
                if (!mapping) continue;
                expr = new GFLWOR(ii, fr, expr);
                this.localVars.closeScope(s);
            }
        }
        return expr;
    }

    private Expr unary() throws QueryException {
        boolean minus = false;
        boolean found = false;
        while (true) {
            this.skipWs();
            if (this.next() != 62 && this.consume(45)) {
                minus ^= true;
            } else if (!this.consume(43)) {
                Expr expr = this.value();
                return found ? new Unary(this.info(), this.check(expr, QueryError.EVALUNARY), minus) : expr;
            }
            found = true;
        }
    }

    private Expr value() throws QueryException {
        this.validate();
        Expr expr = this.extension();
        return expr == null ? this.itemMap() : expr;
    }

    private void validate() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("validate")) {
            return;
        }
        if (this.consume("type")) {
            InputInfo ii = this.info();
            this.qnames.add(this.eQName(SKIPCHECK, QueryError.QNAME_X), ii);
        }
        this.consume("strict");
        this.consume("lax");
        this.skipWs();
        if (this.current(123)) {
            this.enclosedExpr();
            throw this.error(QueryError.IMPLVAL, new Object[0]);
        }
        this.pos = p;
    }

    private Expr extension() throws QueryException {
        Pragma[] pragmas = this.pragma();
        if (pragmas == null) {
            return null;
        }
        this.wsCheck("{");
        Expr expr = this.check(this.expr(), QueryError.NOPRAGMA);
        this.wsCheck("}");
        for (int p = pragmas.length - 1; p >= 0; --p) {
            expr = new Extension(this.info(), pragmas[p], expr);
        }
        return expr;
    }

    private Pragma[] pragma() throws QueryException {
        int p = this.pos;
        if (!this.wsConsume("(#") || !this.consumeWS()) {
            this.pos = p;
            return null;
        }
        ArrayList<Pragma> el = new ArrayList<Pragma>();
        do {
            QNm name = this.eQName(null, QueryError.QNAME_X);
            int cp = this.current();
            if (cp != 35 && !Token.ws(cp)) {
                throw this.error(QueryError.PRAGMAINV, new Object[0]);
            }
            this.token.reset();
            while (cp != 35 || this.next() != 41) {
                if (cp == 0) {
                    throw this.error(QueryError.PRAGMAINV, new Object[0]);
                }
                this.token.add(this.consume());
                cp = this.current();
            }
            byte[] value = this.token.trim().toArray();
            if (Token.eq(name.prefix(), QueryText.DB_PREFIX)) {
                MainOptions options = this.qc.context.options;
                String key = Token.string(Token.uc(name.local()));
                Option<?> option = options.option(key);
                if (option == null) {
                    throw this.error(QueryError.BASEX_OPTIONSINV_X, options.similar(key));
                }
                el.add(new DBPragma(name, option, value));
            } else if (Token.eq(name.prefix(), QueryText.BASEX_PREFIX)) {
                el.add(new BaseXPragma(name, value));
            }
            this.pos += 2;
        } while (this.wsConsumeWs("(#"));
        return (Pragma[])el.toArray(Pragma[]::new);
    }

    private Expr itemMap() throws QueryException {
        int next;
        Expr expr = this.path();
        if (expr != null && (next = this.next()) != 61 && next != 33 && this.wsConsumeWs("!")) {
            ExprList el = (ExprList)((Object)new ExprList().add(expr));
            do {
                this.add(el, this.path());
            } while (this.next() != 61 && this.wsConsumeWs("!"));
            return new CachedMap(this.info(), (Expr[])el.finish());
        }
        return expr;
    }

    private Expr path() throws QueryException {
        ExprList el;
        this.checkInit();
        Expr root = null;
        if (this.consume(47)) {
            Expr expr;
            InputInfo ii = this.info();
            root = Function._UTIL_ROOT.get(ii, new ContextValue(ii));
            el = new ExprList();
            if (this.consume(47)) {
                this.checkAxis(Axis.DESCENDANT);
                this.add(el, new CachedStep(this.info(), Axis.DESCENDANT_OR_SELF, KindTest.NODE, new Expr[0]));
                this.mark();
                expr = this.step(true);
            } else {
                this.checkAxis(Axis.CHILD);
                this.mark();
                expr = this.step(false);
                if (expr == null) {
                    return root;
                }
            }
            this.add(el, expr);
        } else {
            this.mark();
            Expr expr = this.step(false);
            if (expr == null) {
                return null;
            }
            if (this.current() != 47 && !(expr instanceof Step)) {
                return expr;
            }
            el = new ExprList();
            if (expr instanceof Step) {
                this.add(el, expr);
            } else {
                root = expr;
            }
        }
        this.relativePath(el);
        return Path.get(this.info(), root, (Expr[])el.finish());
    }

    private void relativePath(ExprList el) throws QueryException {
        while (true) {
            if (this.consume(47)) {
                if (this.consume(47)) {
                    this.add(el, new CachedStep(this.info(), Axis.DESCENDANT_OR_SELF, KindTest.NODE, new Expr[0]));
                    this.checkAxis(Axis.DESCENDANT);
                } else {
                    this.checkAxis(Axis.CHILD);
                }
            } else {
                return;
            }
            this.mark();
            this.add(el, this.step(true));
        }
    }

    void checkInit() {
    }

    void checkAxis(Axis axis) {
    }

    void checkTest(Test test, boolean element) {
    }

    void checkPred(boolean open) {
    }

    private Expr step(boolean error) throws QueryException {
        Expr expr = this.postfix();
        return expr != null ? expr : this.axisStep(error);
    }

    private Step axisStep(boolean error) throws QueryException {
        Axis axis = null;
        Test test = null;
        if (this.wsConsume("..")) {
            axis = Axis.PARENT;
            test = KindTest.NODE;
            this.checkTest(test, true);
        } else if (this.consume(64)) {
            axis = Axis.ATTRIBUTE;
            if (this.wsConsume("(")) {
                test = this.unionNodeTest(false);
            } else {
                test = this.simpleNodeTest(NodeType.ATTRIBUTE, true);
                this.checkTest(test, false);
            }
            if (test == null) {
                --this.pos;
                throw this.error(QueryError.NOATTNAME, new Object[0]);
            }
        } else {
            for (Axis ax : Axis.values()) {
                int p = this.pos;
                if (!this.wsConsume(ax.name)) continue;
                if (this.wsConsumeWs("::")) {
                    boolean element;
                    this.alterPos = this.pos;
                    axis = ax;
                    boolean bl = element = ax != Axis.ATTRIBUTE;
                    if (this.consume("(")) {
                        test = this.unionNodeTest(element);
                    } else {
                        test = this.simpleNodeTest(element ? NodeType.ELEMENT : NodeType.ATTRIBUTE, true);
                        this.checkTest(test, element);
                    }
                    if (test != null) break;
                    throw this.error(QueryError.AXISMISS_X, new Object[]{axis});
                }
                this.pos = p;
            }
            if (axis == null) {
                axis = Axis.CHILD;
                test = this.simpleNodeTest(NodeType.ELEMENT, true);
                if (test == KindTest.NAMESPACE_NODE) {
                    throw this.error(QueryError.NSAXIS, new Object[0]);
                }
                if (test != null && test.type == NodeType.ATTRIBUTE) {
                    axis = Axis.ATTRIBUTE;
                }
                this.checkTest(test, axis != Axis.ATTRIBUTE);
            }
            if (test == null) {
                if (error) {
                    throw this.error(QueryError.STEPMISS_X, new Object[]{this.found()});
                }
                return null;
            }
        }
        ExprList el = new ExprList();
        while (this.wsConsume("[")) {
            this.checkPred(true);
            this.add(el, this.expr());
            this.wsCheck("]");
            this.checkPred(false);
        }
        return new CachedStep(this.info(), axis, test, (Expr[])el.finish());
    }

    private Test unionNodeTest(boolean element) throws QueryException {
        NodeType nodeType = element ? NodeType.ELEMENT : NodeType.ATTRIBUTE;
        ArrayList<Test> tests = new ArrayList<Test>();
        do {
            this.skipWs();
            Test test = this.simpleNodeTest(nodeType, true);
            this.checkTest(test, element);
            if (test == null) {
                return null;
            }
            if (tests.contains(test)) continue;
            tests.add(test);
        } while (this.wsConsume("|"));
        if (!this.consume(41)) {
            throw this.error(QueryError.WRONGCHAR_X_X, Character.valueOf(')'), this.found());
        }
        return Test.get(tests);
    }

    private Test simpleNodeTest(NodeType type, boolean all) throws QueryException {
        int p = this.pos;
        if (this.consume(42)) {
            p = this.pos;
            if (this.consume(58) && !this.consume(42)) {
                return new NameTest(new QNm(this.ncName(QueryError.QNAME_X)), NamePart.LOCAL, type, this.sc.elemNS);
            }
            this.pos = p;
            return KindTest.get(type);
        }
        if (this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            if (this.consume(42)) {
                return new NameTest(new QNm(Token.cpToken(58), uri), NamePart.URI, type, this.sc.elemNS);
            }
        }
        this.pos = p;
        InputInfo ii = this.info();
        QNm name = this.eQName(SKIPCHECK, null);
        if (name != null) {
            p = this.pos;
            if (all && this.wsConsumeWs("(")) {
                NodeType nt = NodeType.find(name);
                if (nt != null) {
                    Test test = this.kindTest(nt);
                    return test == null ? KindTest.get(nt) : test;
                }
            } else {
                this.pos = p;
                NamePart part = NamePart.FULL;
                if (!name.hasPrefix() && this.consume(":*")) {
                    name = new QNm(Token.concat(name.string(), Token.cpToken(58)));
                    part = NamePart.URI;
                }
                this.qnames.add(name, type == NodeType.ELEMENT, ii);
                return new NameTest(name, part, type, this.sc.elemNS);
            }
        }
        this.pos = p;
        return null;
    }

    private Expr postfix() throws QueryException {
        Expr expr;
        block6: {
            expr = this.primary();
            if (expr == null) break block6;
            while (true) {
                ExprList el;
                if (this.wsConsume("[")) {
                    el = new ExprList();
                    do {
                        this.add(el, this.expr());
                        this.wsCheck("]");
                    } while (this.wsConsume("["));
                    expr = new CachedFilter(this.info(), expr, (Expr[])el.finish());
                    continue;
                }
                if (this.consume("?[")) {
                    el = new ExprList();
                    do {
                        this.add(el, this.expr());
                        this.wsCheck("]");
                    } while (this.wsConsume("?["));
                    expr = new StructFilter(this.info(), expr, (Expr[])el.finish());
                    continue;
                }
                if (this.current(40)) {
                    expr = Functions.dynamic(expr, this.argumentList(false, null));
                    continue;
                }
                if (!this.current(63) || (expr = this.lookup(expr)) == null) break;
            }
        }
        return expr;
    }

    private Expr lookup(Expr expr) throws QueryException {
        boolean deep;
        int p = this.pos;
        if (this.consume(63) && ((deep = this.consume(63)) || !this.wsConsume(",") && !this.consume(")"))) {
            p = this.pos;
            ALookup.Modifier mod = ALookup.Modifier.ITEMS;
            for (ALookup.Modifier m : ALookup.Modifier.values()) {
                if (this.wsConsume(m.toString()) && this.wsConsumeWs("::")) {
                    mod = m;
                    break;
                }
                this.pos = p;
            }
            InputInfo info = this.info();
            Expr ctx = expr != null ? expr : new ContextValue(info);
            Expr spec = this.keySpecifier();
            return deep ? new DeepLookup(info, mod, ctx, spec) : new Lookup(info, mod, ctx, spec);
        }
        this.pos = p;
        return null;
    }

    private Expr primary() throws QueryException {
        Expr lookup;
        this.skipWs();
        Expr expr = this.functionItem();
        if (expr != null) {
            return expr;
        }
        int cp = this.current();
        if (cp == 60) {
            return this.dirConstructor(true);
        }
        if (cp == 96) {
            return this.stringConstructor();
        }
        if (cp == 36) {
            return this.varRef();
        }
        if (cp == 40) {
            return this.parenthesized();
        }
        expr = this.functionCall();
        if (expr != null) {
            return expr;
        }
        expr = this.compConstructor();
        if (expr != null) {
            return expr;
        }
        expr = this.mapConstructor();
        if (expr != null) {
            return expr;
        }
        expr = this.arrayConstructor();
        if (expr != null) {
            return expr;
        }
        if (this.wsConsumeWs("ordered", null, "{") || this.wsConsumeWs("unordered", null, "{")) {
            return this.enclosedExpr();
        }
        if (this.current(63) && (lookup = this.lookup(null)) != null) {
            return lookup;
        }
        if (cp == 46) {
            if (this.next() == 46) {
                return null;
            }
            if (!Token.digit(this.next())) {
                this.consume();
                return new ContextValue(this.info());
            }
        }
        return this.literal();
    }

    private Expr keySpecifier() throws QueryException {
        if (this.wsConsume("*")) {
            return ALookup.WILDCARD;
        }
        int cp = this.current();
        if (cp == 40) {
            return this.parenthesized();
        }
        if (cp == 36) {
            return this.varRef();
        }
        if (QueryParser.quote(cp)) {
            return Str.get(this.stringLiteral());
        }
        Expr num = this.numericLiteral(Long.MAX_VALUE, false);
        if (num != null) {
            if (Function.ERROR.is(num) || num instanceof Itr) {
                return num;
            }
            throw this.error(QueryError.NUMBERITR_X_X, num.seqType(), num);
        }
        return Str.get(this.ncName(QueryError.KEYSPEC_X));
    }

    private CMap mapConstructor() throws QueryException {
        if (this.wsConsumeWs("map", QueryError.MAPCONSTR, "{") || this.current(123)) {
            this.check('{');
            InputInfo info = this.info();
            ExprList el = new ExprList();
            if (!this.wsConsume("}")) {
                HashItemSet set = new HashItemSet(ItemSet.Mode.ATOMIC, info);
                do {
                    Item item;
                    Expr key = this.single();
                    this.add(el, this.check(key, QueryError.INVMAPKEY));
                    if (key instanceof Item && !set.add(item = (Item)key)) {
                        throw this.error(QueryError.MAPDUPLKEY_X, key);
                    }
                    if (!this.wsConsume(":")) {
                        throw this.error(QueryError.WRONGCHAR_X_X, ":", this.found());
                    }
                    this.add(el, this.check(this.single(), QueryError.INVMAPVAL));
                } while (this.wsConsume(","));
                this.wsCheck("}");
            }
            return new CMap(info, (Expr[])el.finish());
        }
        return null;
    }

    private Expr arrayConstructor() throws QueryException {
        if (this.wsConsumeWs("array", QueryError.ARRAYCONSTR, "{")) {
            this.check('{');
            Expr expr = this.expr();
            this.wsCheck("}");
            return expr == null ? XQArray.empty() : new CItemArray(this.info(), expr);
        }
        if (this.consume(91)) {
            InputInfo info = this.info();
            ExprList el = new ExprList();
            if (!this.wsConsume("]")) {
                do {
                    this.add(el, this.check(this.single(), QueryError.INVMAPVAL));
                } while (this.wsConsume(","));
                this.wsCheck("]");
            }
            return el.isEmpty() ? XQArray.empty() : new CArray(info, (Expr[])el.finish());
        }
        return null;
    }

    private Expr functionItem() throws QueryException {
        this.skipWs();
        int p = this.pos;
        AnnList anns = this.annotations(false).check(false, true, true);
        if (this.wsConsume("function") || this.wsConsume("fn")) {
            boolean focus;
            boolean args = this.wsConsume("(");
            boolean bl = focus = !args && this.current(123);
            if (args || focus) {
                Expr expr;
                Params params;
                HashMap<Var, Expr> global = this.localVars.pushContext(true);
                if (args) {
                    params = this.paramList(false);
                    expr = this.enclosedExpr();
                } else {
                    Ann method = anns.get(Annotation.METHOD);
                    if (method != null) {
                        throw QueryError.NOMETHOD.get(method.info, new Object[0]);
                    }
                    InputInfo ii = this.info();
                    QNm name = new QNm("arg");
                    params = new Params().add(name, SeqType.ITEM_ZM, null, ii).finish(this.qc, this.localVars);
                    expr = new Pipeline(ii, this.localVars.resolve(name, ii), this.enclosedExpr());
                }
                VarScope vs = this.localVars.popContext();
                if (anns.contains(Annotation.PRIVATE) || anns.contains(Annotation.PUBLIC)) {
                    throw this.error(QueryError.NOVISALLOWED, new Object[0]);
                }
                return new Closure(this.info(), expr, params, anns, vs, global);
            }
        }
        this.pos = p;
        if (!anns.isEmpty()) {
            throw this.error(QueryError.NOANN, new Object[0]);
        }
        QNm name = this.eQName(this.sc.funcNS, null);
        if (name != null && this.wsConsumeWs("#")) {
            Expr num = this.numericLiteral(Integer.MAX_VALUE, false);
            if (QueryParser.reserved(name)) {
                if (num != null) {
                    throw this.error(QueryError.RESERVED_X, new Object[]{name.local()});
                }
            } else {
                if (Function.ERROR.is(num)) {
                    return num;
                }
                if (num instanceof Itr) {
                    Itr itr = (Itr)num;
                    return Functions.item(name, (int)itr.itr(), false, this.info(), this.qc, this.moduleURIs.contains(name.uri()));
                }
            }
        }
        this.pos = p;
        return null;
    }

    private Expr literal() throws QueryException {
        if (QueryParser.quote(this.current())) {
            return Str.get(this.stringLiteral());
        }
        if (!this.consume(35)) {
            return this.numericLiteral(0L, false);
        }
        this.skipWs();
        return this.eQName(null, QueryError.QNAME_X);
    }

    private Expr numericLiteral(long max, boolean mns) throws QueryException {
        int c;
        int cp;
        boolean negate;
        boolean bl = negate = mns && this.consume(45);
        if (negate) {
            this.skipWs();
        }
        if (!Token.digit(cp = this.current()) && cp != 46) {
            return null;
        }
        this.token.reset();
        int base = 10;
        if (cp == 48) {
            int n = this.next();
            if (max == 0L) {
                if (n == 120 || n == 88) {
                    base = 16;
                } else if (n == 98 || n == 66) {
                    base = 2;
                }
                if (base != 10) {
                    this.consume();
                    this.consume();
                    if (this.current(95)) {
                        throw this.error(QueryError.NUMBER_X, this.token.add(95));
                    }
                }
            }
        }
        BigInteger l = BigInteger.ZERO;
        boolean us = false;
        while ((c = this.current()) != 0) {
            int n;
            if (this.consume(95)) {
                us = true;
                continue;
            }
            int n2 = n = c <= 57 ? c - 48 : (c & 0xDF) - 55;
            if (!(n < base && (c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90))) break;
            l = l.multiply(BigInteger.valueOf(base)).add(BigInteger.valueOf(n));
            this.token.add(this.consume());
            us = false;
        }
        if (us) {
            throw this.error(QueryError.NUMBER_X, this.token.add(95));
        }
        if (base == 10 && max == 0L) {
            boolean dec = this.consume(46);
            if (dec) {
                this.token.add(46);
                if (Token.digit(this.current())) {
                    this.digits();
                } else if (this.token.size() == 1) {
                    throw this.error(QueryError.NUMBER_X, this.token);
                }
            }
            if (XMLToken.isNCStartChar(this.current())) {
                if (!this.consume(101) && !this.consume(69)) {
                    throw this.error(QueryError.NUMBER_X, this.token);
                }
                this.token.add(101);
                if (this.current(43) || this.current(45)) {
                    this.token.add(this.consume());
                }
                if (!Token.digit(this.current())) {
                    throw this.error(QueryError.NUMBER_X, this.token);
                }
                this.digits();
                if (XMLToken.isNCStartChar(this.current())) {
                    throw this.error(QueryError.NUMBER_X, this.token);
                }
                double d = Dbl.parse(this.token.toArray(), this.info());
                return Dbl.get(negate ? -d : d);
            }
            if (dec) {
                BigDecimal d = new BigDecimal(Token.string(this.token.toArray()));
                return Dec.get(negate ? d.negate() : d);
            }
        }
        if (this.token.isEmpty()) {
            throw this.error(QueryError.NUMBER_X, this.token);
        }
        if (l.compareTo(BigInteger.valueOf(max != 0L ? max : Long.MAX_VALUE)) > 0) {
            return FnError.get(QueryError.RANGE_X.get(this.info(), this.token), Itr.ZERO);
        }
        return Itr.get(negate ? -l.longValue() : l.longValue());
    }

    private void digits() throws QueryException {
        boolean us;
        do {
            us = false;
            this.token.add(this.consume());
            while (this.consume(95)) {
                us = true;
            }
        } while (Token.digit(this.current()));
        if (us) {
            throw this.error(QueryError.NUMBER_X, this.token.add(95));
        }
    }

    private byte[] stringLiteral() throws QueryException {
        this.skipWs();
        int quote = this.current();
        if (!QueryParser.quote(quote)) {
            throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
        }
        this.consume();
        this.token.reset();
        while (true) {
            if (!this.consume(quote)) {
                if (!this.more()) {
                    throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
                }
                this.entity(this.token);
                continue;
            }
            if (!this.consume(quote)) break;
            this.token.add(quote);
        }
        return this.token.toArray();
    }

    private byte[] bracedURILiteral() throws QueryException {
        int p = this.pos;
        this.token.reset();
        while (!this.consume(125)) {
            if (!this.more() || this.current() == 123) {
                throw this.error(QueryError.WRONGCHAR_X_X, "}", this.found());
            }
            this.entity(this.token);
        }
        byte[] ns = Token.normalize(this.token.toArray());
        if (Token.eq(ns, QueryText.XMLNS_URI)) {
            this.pos = p;
            throw this.error(QueryError.ILLEGALEQNAME_X, new Object[]{ns});
        }
        return ns;
    }

    private QNm varName() throws QueryException {
        this.check('$');
        this.skipWs();
        return this.eQName(null, QueryError.NOVARNAME);
    }

    private Var newVar() throws QueryException {
        return this.newVar(null);
    }

    private Var newVar(SeqType type) throws QueryException {
        InputInfo ii = this.info();
        return new Var(this.varName(), type != null ? type : this.optAsType(), this.qc, ii);
    }

    private ParseExpr varRef() throws QueryException {
        InputInfo ii = this.info();
        return this.localVars.resolve(this.varName(), ii);
    }

    private Expr parenthesized() throws QueryException {
        this.check('(');
        Expr expr = this.expr();
        this.wsCheck(")");
        return expr == null ? Empty.VALUE : expr;
    }

    private Expr functionCall() throws QueryException {
        int p = this.pos;
        QNm name = this.eQName(this.sc.funcNS, null);
        if (name != null && !QueryParser.reserved(name)) {
            this.skipWs();
            if (this.current(40)) {
                return Functions.get(name, this.argumentList(true, null), this.qc, this.moduleURIs.contains(name.uri()));
            }
        }
        this.pos = p;
        return null;
    }

    private FuncBuilder argumentList(boolean keywords, Expr expr) throws QueryException {
        FuncBuilder fb = new FuncBuilder(this.info());
        if (expr != null) {
            fb.add(expr, null);
        }
        this.wsCheck("(");
        if (!this.wsConsumeWs(")")) {
            boolean kw = false;
            do {
                int p = this.pos;
                QNm name = null;
                if (keywords) {
                    QNm qnm = this.eQName(null, null);
                    if (this.wsConsume(":=")) {
                        name = qnm;
                        kw = true;
                    } else {
                        this.pos = p;
                    }
                }
                if (kw && name == null) continue;
                Expr arg = this.single();
                if (arg == null) {
                    arg = Empty.UNDEFINED;
                    if (!this.wsConsume("?")) {
                        throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
                    }
                }
                if (!fb.add(arg, name)) continue;
                throw this.error(QueryError.KEYWORDTWICE_X, name);
            } while (this.wsConsumeWs(","));
            if (!this.consume(")")) {
                throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
            }
        }
        return fb;
    }

    private Expr stringConstructor() throws QueryException {
        this.check('`');
        boolean constr = this.consume("`[");
        ExprList el = new ExprList();
        TokenBuilder tb = new TokenBuilder();
        while (this.more()) {
            int p = this.pos;
            if (constr ? this.consume(93) && this.consume(96) && this.consume(96) : this.consume(96) && !this.consume(96)) {
                if (!tb.isEmpty()) {
                    el.add(Str.get(tb.next()));
                }
                return el.size() == 1 ? (Expr)el.get(0) : new Concat(this.info(), (Expr[])el.finish());
            }
            this.pos = p;
            if (constr ? this.consume(96) && this.consume(123) : this.consume(123) && !this.consume(123)) {
                Expr expr;
                if (!tb.isEmpty()) {
                    el.add(Str.get(tb.next()));
                }
                if ((expr = this.expr()) != null) {
                    el.add(Function.STRING_JOIN.get(this.info(), expr, Str.get(32)));
                }
                this.skipWs();
                this.check('}');
                if (!constr) continue;
                this.check('`');
                continue;
            }
            this.pos = p;
            int cp = this.consume();
            if (!(constr || cp != 123 && cp != 125 && cp != 96)) {
                this.check((char)cp);
            }
            tb.add(cp);
        }
        throw this.error(QueryError.INCOMPLETE, new Object[0]);
    }

    private Expr dirConstructor(boolean root) throws QueryException {
        Expr expr;
        int p = this.pos;
        this.check('<');
        Expr expr2 = this.consume(33) ? this.dirComment() : (expr = this.consume(63) ? this.dirPI() : this.dirElement(root));
        if (expr != null) {
            return expr;
        }
        this.pos = p;
        return null;
    }

    private Expr dirElement(boolean root) throws QueryException {
        byte[] atn;
        InputInfo ii = this.info();
        byte[] qnm = this.qName(root ? null : QueryError.ELEMNAME_X);
        this.consumeWS();
        int cp = this.current();
        if (qnm.length == 0 || root && cp != 47 && cp != 62 && !XMLToken.isNCStartChar(cp)) {
            return null;
        }
        int size = this.sc.ns.size();
        byte[] nse = this.sc.elemNS;
        int npos = this.qnames.size();
        QNm name = new QNm(qnm);
        this.qnames.add(name, ii);
        Atts ns = new Atts();
        ExprList cont = new ExprList();
        boolean xmlDecl = false;
        ArrayList<QNm> atts = null;
        while ((atn = this.qName(null)).length != 0) {
            boolean pr;
            ExprList attv = new ExprList();
            this.consumeWS();
            if (root) {
                if (!this.consume(61)) {
                    return null;
                }
            } else {
                this.check('=');
            }
            this.consumeWS();
            int delim = this.consume();
            if (!QueryParser.quote(delim)) {
                throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
            }
            TokenBuilder tb = new TokenBuilder();
            boolean simple = true;
            block8: while (true) {
                if (!this.consume(delim)) {
                    cp = this.current();
                    switch (cp) {
                        case 123: {
                            if (this.next() == 123) {
                                tb.add(this.consume());
                                this.consume();
                                continue block8;
                            }
                            byte[] text = tb.next();
                            if (text.length == 0) {
                                this.add(attv, this.enclosedExpr());
                                simple = false;
                                continue block8;
                            }
                            this.add(attv, Str.get(text));
                            continue block8;
                        }
                        case 125: {
                            this.consume();
                            this.check('}');
                            tb.add(125);
                            continue block8;
                        }
                        case 0: 
                        case 60: {
                            throw this.error(QueryError.NOQUOTE_X, new Object[]{this.found()});
                        }
                        case 9: 
                        case 10: {
                            tb.add(32);
                            this.consume();
                            continue block8;
                        }
                        case 13: {
                            if (this.next() != 10) {
                                tb.add(32);
                            }
                            this.consume();
                            continue block8;
                        }
                    }
                    this.entity(tb);
                    continue;
                }
                if (!this.consume(delim)) break;
                tb.add(delim);
            }
            if (!tb.isEmpty()) {
                this.add(attv, Str.get(tb.finish()));
            }
            if ((pr = Token.startsWith(atn, Token.XMLNS_COLON)) || Token.eq(atn, Token.XMLNS)) {
                byte[] uri;
                if (!simple) {
                    throw this.error(QueryError.NSCONS, new Object[0]);
                }
                byte[] prefix = pr ? Token.local(atn) : Token.EMPTY;
                byte[] byArray = uri = attv.isEmpty() ? Token.EMPTY : ((Str)attv.get(0)).string();
                if (Token.eq(prefix, Token.XML) && Token.eq(uri, QueryText.XML_URI)) {
                    if (xmlDecl) {
                        throw this.error(QueryError.DUPLNSDEF_X, new Object[]{Token.XML});
                    }
                    xmlDecl = true;
                } else {
                    if (!Uri.get(uri).isValid()) {
                        throw this.error(QueryError.INVURI_X, new Object[]{uri});
                    }
                    if (pr) {
                        if (uri.length == 0) {
                            throw this.error(QueryError.NSEMPTYURI, new Object[0]);
                        }
                        if (Token.eq(prefix, Token.XML, Token.XMLNS)) {
                            throw this.error(QueryError.BINDXML_X, new Object[]{prefix});
                        }
                        if (Token.eq(uri, QueryText.XML_URI)) {
                            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XML);
                        }
                        if (Token.eq(uri, QueryText.XMLNS_URI)) {
                            throw this.error(QueryError.BINDXMLURI_X_X, uri, Token.XMLNS);
                        }
                        this.sc.ns.add(prefix, uri);
                    } else {
                        if (Token.eq(uri, QueryText.XML_URI)) {
                            throw this.error(QueryError.XMLNSDEF_X, new Object[]{uri});
                        }
                        this.sc.elemNS = uri;
                    }
                    if (ns.contains(prefix)) {
                        throw this.error(QueryError.DUPLNSDEF_X, new Object[]{prefix});
                    }
                    ns.add(prefix, uri);
                }
            } else {
                QNm attn = new QNm(atn);
                if (atts == null) {
                    atts = new ArrayList<QNm>(1);
                }
                atts.add(attn);
                this.qnames.add(attn, false, this.info());
                this.add(cont, new CAttr(this.info(), false, (Expr)attn, (Expr[])attv.finish()));
            }
            if (this.consumeWS()) continue;
            break;
        }
        if (this.consume(47)) {
            this.check('>');
        } else {
            this.check('>');
            while (this.current() != 60 || this.next() != 47) {
                Expr expr = this.dirElemContent(name.string());
                if (expr == null) continue;
                this.add(cont, expr);
            }
            this.pos += 2;
            byte[] close = this.qName(QueryError.ELEMNAME_X);
            this.consumeWS();
            this.check('>');
            if (!Token.eq(name.string(), close)) {
                throw this.error(QueryError.TAGWRONG_X_X, name.string(), close);
            }
        }
        this.qnames.assignURI(this, npos);
        if (atts != null) {
            int as = atts.size();
            for (int a = 0; a < as - 1; ++a) {
                for (int b = a + 1; b < as; ++b) {
                    if (!((QNm)atts.get(a)).eq((QNm)atts.get(b))) continue;
                    throw this.error(QueryError.ATTDUPL_X, atts.get(a));
                }
            }
        }
        this.sc.ns.size(size);
        this.sc.elemNS = nse;
        return new CElem(this.info(), false, (Expr)name, ns, (Expr[])cont.finish());
    }

    private Expr dirElemContent(byte[] name) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        boolean strip = true;
        while (true) {
            int cp;
            if ((cp = this.current()) == 60) {
                if (this.wsConsume("<![CDATA[")) {
                    tb.add(this.cDataSection());
                    strip = false;
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : (this.next() == 47 ? null : this.dirConstructor(false));
            }
            if (cp == 123) {
                if (this.next() == 123) {
                    tb.add(this.consume());
                    this.consume();
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : this.enclosedExpr();
            }
            if (cp == 125) {
                this.consume();
                this.check('}');
                tb.add(125);
                continue;
            }
            if (cp == 0) break;
            strip &= !this.entity(tb);
        }
        throw this.error(QueryError.NOCLOSING_X, new Object[]{name});
    }

    private Str text(TokenBuilder tb, boolean strip) {
        byte[] text = tb.toArray();
        return text.length == 0 || strip && !this.sc.spaces && Token.ws(text) ? null : Str.get(text);
    }

    private Expr dirComment() throws QueryException {
        this.check('-');
        this.check('-');
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            int cp;
            if ((cp = this.consume()) == 0) {
                throw this.error(QueryError.NOCOMMENT, new Object[0]);
            }
            if (cp == 45 && this.consume(45)) {
                this.check('>');
                return new CComm(this.info(), false, (Expr)Str.get(tb.finish()));
            }
            tb.add(cp);
        }
    }

    private Expr dirPI() throws QueryException {
        byte[] name = this.ncName(QueryError.NOPINAME);
        if (Token.eq(Token.lc(name), Token.XML)) {
            throw this.error(QueryError.PIXML_X, new Object[]{name});
        }
        boolean space = this.skipWs();
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            int cp;
            if ((cp = this.consume()) == 0) {
                throw this.error(QueryError.NOPI, new Object[0]);
            }
            if (cp == 63 && this.consume(62)) {
                return new CPI(this.info(), false, (Expr)Str.get(name), (Expr)Str.get(tb.finish()));
            }
            if (!space) {
                throw this.error(QueryError.NOPI, new Object[0]);
            }
            tb.add(cp);
        }
    }

    private byte[] cDataSection() throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            int cp;
            if ((cp = this.consume()) == 0) {
                throw this.error(QueryError.NOCDATA, new Object[0]);
            }
            if (cp == 93 && this.current(93) && this.next() == 62) {
                this.pos += 2;
                return tb.finish();
            }
            tb.add(cp);
        }
    }

    private Expr compConstructor() throws QueryException {
        Expr expr;
        int p = this.pos;
        Expr expr2 = this.wsConsumeWs("document") ? this.compDoc() : (this.wsConsumeWs("element") ? this.compElement() : (this.wsConsumeWs("attribute") ? this.compAttribute() : (this.wsConsumeWs("namespace") ? this.compNamespace() : (this.wsConsumeWs("text") ? this.compText() : (this.wsConsumeWs("comment") ? this.compComment() : (expr = this.wsConsumeWs("processing-instruction") ? this.compPI() : null))))));
        if (expr == null) {
            this.pos = p;
        }
        return expr;
    }

    private Expr compElement() throws QueryException {
        Expr name = this.compName(QueryError.NOELEMNAME, true);
        if (name == null) {
            return null;
        }
        if (name instanceof QNm) {
            QNm qnm = (QNm)name;
            this.qnames.add(qnm, this.info());
        }
        this.skipWs();
        return this.current(123) ? new CElem(this.info(), true, name, new Atts(), this.enclosedExpr()) : null;
    }

    private Expr compAttribute() throws QueryException {
        Expr name = this.compName(QueryError.NOATTNAME, true);
        if (name == null) {
            return null;
        }
        if (name instanceof QNm) {
            QNm qnm = (QNm)name;
            this.qnames.add(qnm, false, this.info());
        }
        this.skipWs();
        return this.current(123) ? new CAttr(this.info(), true, name, this.enclosedExpr()) : null;
    }

    private Expr compNamespace() throws QueryException {
        Expr name = this.compName(QueryError.NONSNAME, false);
        if (name == null) {
            return null;
        }
        this.skipWs();
        return this.current(123) ? new CNSpace(this.info(), true, name, this.enclosedExpr()) : null;
    }

    private Expr compPI() throws QueryException {
        Expr name = this.compName(QueryError.NOPINAME, false);
        if (name == null) {
            return null;
        }
        this.skipWs();
        return this.current(123) ? new CPI(this.info(), true, name, this.enclosedExpr()) : null;
    }

    private Expr compName(QueryError error, boolean qname) throws QueryException {
        if (this.consume("{")) {
            Expr name = this.check(this.expr(), error);
            this.wsCheck("}");
            return name;
        }
        this.consume("#");
        this.skipWs();
        if (qname) {
            return this.eQName(SKIPCHECK, null);
        }
        byte[] string = this.ncName(null);
        return string.length != 0 ? Str.get(string) : null;
    }

    private Expr compDoc() throws QueryException {
        return this.current(123) ? new CDoc(this.info(), false, this.enclosedExpr()) : null;
    }

    private Expr compText() throws QueryException {
        return this.current(123) ? new CTxt(this.info(), this.enclosedExpr()) : null;
    }

    private Expr compComment() throws QueryException {
        return this.current(123) ? new CComm(this.info(), true, this.enclosedExpr()) : null;
    }

    private SeqType castTarget() throws QueryException {
        Type type;
        if (this.wsConsume("(")) {
            type = this.choiceItemType().type;
        } else {
            QNm name = this.eQName(this.sc.elemNS, QueryError.TYPEINVALID);
            if (!name.hasURI() && Token.eq(name.local(), Token.token("enum"))) {
                if (!this.wsConsume("(")) {
                    throw this.error(QueryError.WHICHCAST_X, new Object[]{AtomType.similar(name)});
                }
                type = this.enumerationType();
            } else {
                type = ListType.find(name);
                if (type == null) {
                    type = AtomType.find(name, false);
                    if (this.consume("(")) {
                        throw this.error(QueryError.SIMPLETYPE_X, new Object[]{name.prefixId(Token.XML)});
                    }
                    if (type == null ? name.eq(AtomType.ANY_SIMPLE_TYPE.qname()) : type.oneOf(AtomType.ANY_ATOMIC_TYPE, AtomType.NOTATION)) {
                        throw this.error(QueryError.INVALIDCAST_X, new Object[]{name.prefixId(Token.XML)});
                    }
                    if (type == null) {
                        SeqType st = this.declaredTypes.get(name);
                        if (st == null) {
                            throw this.error(QueryError.WHICHCAST_X, new Object[]{AtomType.similar(name)});
                        }
                        type = st.type;
                    }
                }
            }
        }
        if (type.atomic() == null) {
            throw this.error(QueryError.INVALIDCAST_X, type);
        }
        this.skipWs();
        return SeqType.get(type, this.consume(63) ? Occ.ZERO_OR_ONE : Occ.EXACTLY_ONE);
    }

    private SeqType sequenceType() throws QueryException {
        if (this.wsConsumeWs("empty-sequence", QueryError.INCOMPLETE, "(")) {
            this.wsCheck("(");
            this.wsCheck(")");
            return SeqType.EMPTY_SEQUENCE_Z;
        }
        SeqType st = this.itemType();
        this.skipWs();
        Occ occ = this.consume(63) ? Occ.ZERO_OR_ONE : (this.consume(43) ? Occ.ONE_OR_MORE : (this.consume(42) ? Occ.ZERO_OR_MORE : Occ.EXACTLY_ONE));
        this.skipWs();
        return st.with(occ);
    }

    private SeqType itemType() throws QueryException {
        Type type;
        if (this.wsConsume("(")) {
            return this.choiceItemType();
        }
        AnnList anns = this.annotations(false).check(false, false, true);
        this.skipWs();
        SeqType st = null;
        QNm name = this.eQName(null, QueryError.TYPEINVALID);
        if (!name.hasURI() && Token.eq(name.local(), Token.token("enum"))) {
            if (!this.wsConsume("(")) {
                throw this.error(QueryError.WHICHCAST_X, new Object[]{AtomType.similar(name)});
            }
            type = this.enumerationType();
        } else if (this.wsConsume("(")) {
            type = FuncType.find(name);
            if (type != null) {
                return this.functionTest(anns, type).seqType();
            }
            type = NodeType.find(name);
            if (type != null) {
                if (!this.wsConsume(")")) {
                    st = SeqType.get(type, Occ.EXACTLY_ONE, this.kindTest((NodeType)type));
                }
            } else if (name.eq(AtomType.ITEM.qname())) {
                type = AtomType.ITEM;
                this.wsCheck(")");
            }
            if (type == null) {
                throw this.error(QueryError.WHICHTYPE_X, new Object[]{Type.similar(name)});
            }
        } else {
            if (!name.hasURI()) {
                name.uri(this.sc.elemNS);
            }
            if ((type = AtomType.find(name, false)) == null && (st = this.declaredTypes.get(name)) == null) {
                RecordType ref = this.recordTypeRefs.get(name);
                if (ref == null) {
                    ref = new RecordType(name, this.info());
                    this.recordTypeRefs.put(name, ref);
                }
                type = ref;
            }
        }
        if (!anns.isEmpty()) {
            throw this.error(QueryError.NOANN, new Object[0]);
        }
        return st != null ? st : type.seqType();
    }

    private Type functionTest(AnnList anns, Type type) throws QueryException {
        if (this.wsConsume("*")) {
            this.wsCheck(")");
            return type;
        }
        if (type instanceof RecordType) {
            boolean extensible;
            TokenObjectMap<RecordField> fields = new TokenObjectMap<RecordField>();
            boolean bl = extensible = !this.consume(41);
            if (extensible) {
                while (!(extensible = this.wsConsume("*"))) {
                    SeqType seqType;
                    byte[] name = QueryParser.quote(this.current()) ? this.stringLiteral() : this.ncName(QueryError.NOSTRNCN_X);
                    boolean optional = this.wsConsume("?");
                    SeqType seqType2 = seqType = this.wsConsume("as") ? this.sequenceType() : null;
                    if (fields.contains(name)) {
                        throw this.error(QueryError.DUPFIELD_X, new Object[]{name});
                    }
                    fields.put(name, new RecordField(optional, seqType));
                    if (this.wsConsume(",")) continue;
                }
                this.wsCheck(")");
            }
            return this.qc.shared.record(extensible, fields);
        }
        if (type instanceof MapType) {
            Type key = this.itemType().type;
            if (key instanceof RecordType) {
                RecordType rt = (RecordType)key;
                key = rt.getDeclaration(this.namedRecordTypes);
            }
            if (!key.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
                throw this.error(QueryError.MAPTAAT_X, key);
            }
            this.wsCheck(",");
            MapType tp = MapType.get(key, this.sequenceType());
            this.wsCheck(")");
            return tp;
        }
        if (type instanceof ArrayType) {
            ArrayType tp = ArrayType.get(this.sequenceType());
            this.wsCheck(")");
            return tp;
        }
        SeqType[] args = new SeqType[]{};
        if (!this.wsConsume(")")) {
            QNmSet names = new QNmSet();
            do {
                this.skipWs();
                if (this.current(36)) {
                    QNm qnm = this.varName();
                    if (!names.add(qnm)) {
                        throw QueryError.FUNCDUPL_X.get(this.info(), qnm);
                    }
                    this.wsCheck("as");
                }
                args = Array.add(args, this.sequenceType());
            } while (this.wsConsume(","));
            this.wsCheck(")");
        }
        this.wsCheck("as");
        return FuncType.get(anns, this.sequenceType(), args);
    }

    private Test kindTest(NodeType type) throws QueryException {
        Test tp = switch (type) {
            case NodeType.DOCUMENT_NODE -> this.documentTest();
            case NodeType.ELEMENT, NodeType.ATTRIBUTE -> this.elemAttrTest(type);
            case NodeType.PROCESSING_INSTRUCTION -> this.piTest();
            case NodeType.SCHEMA_ELEMENT, NodeType.SCHEMA_ATTRIBUTE -> this.schemaTest();
            default -> null;
        };
        this.wsCheck(")");
        return tp;
    }

    private Test documentTest() throws QueryException {
        Test test;
        boolean schema;
        boolean element = this.consume("element");
        boolean bl = schema = !element && this.consume("schema-element");
        if (element || schema) {
            this.wsCheck("(");
            this.skipWs();
            test = element ? this.elemAttrTest(NodeType.ELEMENT) : this.schemaTest();
            this.wsCheck(")");
        } else {
            test = Test.get(this.nameTestUnion(NodeType.ELEMENT));
            if (test == null) {
                return null;
            }
        }
        return new DocTest(test != null ? test : KindTest.ELEMENT);
    }

    private Test schemaTest() throws QueryException {
        throw this.error(QueryError.SCHEMAINV_X, this.eQName(this.sc.elemNS, QueryError.QNAME_X));
    }

    private Test elemAttrTest(NodeType type) throws QueryException {
        ArrayList<Test> tests = this.nameTestUnion(type);
        if (tests.isEmpty()) {
            return null;
        }
        if (this.wsConsumeWs(",")) {
            QNm name = this.eQName(this.sc.elemNS, QueryError.QNAME_X);
            Enum ann = ListType.find(name);
            if (ann == null) {
                ann = AtomType.find(name, true);
            }
            if (ann == null) {
                throw this.error(QueryError.TYPEUNDEF_X, new Object[]{AtomType.similar(name)});
            }
            if (type == NodeType.ELEMENT) {
                this.wsConsume("?");
            }
            if (!(ann.oneOf(AtomType.ANY_TYPE, AtomType.UNTYPED) || type != NodeType.ELEMENT && ann.oneOf(AtomType.ANY_SIMPLE_TYPE, AtomType.ANY_ATOMIC_TYPE, AtomType.UNTYPED_ATOMIC))) {
                throw this.error(QueryError.STATIC_X, ann);
            }
        }
        return Test.get(tests);
    }

    private Test piTest() throws QueryException {
        byte[] name;
        this.token.reset();
        if (QueryParser.quote(this.current())) {
            name = Token.trim(this.stringLiteral());
            if (!XMLToken.isNCName(name)) {
                throw this.error(QueryError.INVNCNAME_X, new Object[]{name});
            }
        } else if (this.ncName()) {
            name = this.token.toArray();
        } else {
            return null;
        }
        return Test.get(NodeType.PROCESSING_INSTRUCTION, new QNm(name), null);
    }

    private EnumType enumerationType() throws QueryException {
        TokenSet values = new TokenSet();
        do {
            values.add(this.stringLiteral());
        } while (this.wsConsume(","));
        this.check(')');
        return new EnumType(values);
    }

    private SeqType choiceItemType() throws QueryException {
        ArrayList<SeqType> types = new ArrayList<SeqType>(){

            @Override
            public boolean add(SeqType st) {
                if (!(st.type instanceof EnumType) || this.isEmpty()) {
                    return super.add(st);
                }
                int i = this.size() - 1;
                Type tp = ((SeqType)this.get((int)i)).type;
                if (!(tp instanceof EnumType)) {
                    return super.add(st);
                }
                this.set(i, tp.union(st.type).seqType());
                return true;
            }
        };
        do {
            SeqType st = this.itemType();
            if (st.type instanceof ChoiceItemType) {
                types.addAll(((ChoiceItemType)st.type).types);
                continue;
            }
            types.add(st);
        } while (this.wsConsume("|"));
        this.check(')');
        return types.size() == 1 ? (SeqType)types.get(0) : new ChoiceItemType((java.util.List<SeqType>)types).seqType();
    }

    private Expr tryCatch() throws QueryException {
        if (!this.wsConsumeWs("try")) {
            return null;
        }
        Expr expr = this.enclosedExpr();
        Catch[] catches = new Catch[]{};
        while (this.wsConsume("catch")) {
            Var[] vrs;
            ArrayList<Test> tests = this.nameTestUnion(NodeType.ELEMENT);
            if (tests.isEmpty()) {
                throw this.error(QueryError.NOCATCH, new Object[0]);
            }
            int s = this.localVars.openScope();
            InputInfo ii = this.info();
            for (Var var : vrs = QueryException.variables(this.qc, ii)) {
                this.localVars.add(var);
            }
            Catch c = new Catch(ii, this.enclosedExpr(), vrs, tests);
            this.localVars.closeScope(s);
            catches = Array.add(catches, c);
        }
        Expr fnlly = null;
        if (this.wsConsume("finally")) {
            fnlly = this.enclosedExpr();
        }
        if (catches.length == 0 && fnlly == null) {
            throw this.error(QueryError.NOCATCH, new Object[0]);
        }
        return new Try(this.info(), expr, fnlly != null ? fnlly : Empty.VALUE, catches);
    }

    private ArrayList<Test> nameTestUnion(NodeType type) throws QueryException {
        Test test;
        ArrayList<Test> tests = new ArrayList<Test>();
        int p = this.pos;
        do {
            this.skipWs();
            test = this.simpleNodeTest(type, false);
            if (test == null) break;
            tests.add(test);
        } while (this.wsConsume("|"));
        if (test == null) {
            this.pos = p;
        }
        return tests;
    }

    private FTExpr ftSelection(boolean prg) throws QueryException {
        FTExpr old;
        FTExpr expr = this.ftOr(prg);
        FTExpr first = null;
        boolean ordered = false;
        do {
            old = expr;
            if (this.wsConsumeWs("ordered")) {
                ordered = true;
                old = null;
            } else if (this.wsConsumeWs("window")) {
                expr = new FTWindow(this.info(), expr, this.additive(), this.ftUnit());
            } else if (this.wsConsumeWs("distance")) {
                Expr[] rng = this.ftRange(false);
                if (rng == null) {
                    throw this.error(QueryError.FTRANGE, new Object[0]);
                }
                expr = new FTDistance(this.info(), expr, rng[0], rng[1], this.ftUnit());
            } else if (this.wsConsumeWs("at")) {
                FTContents cont;
                FTContents fTContents = this.wsConsumeWs("start") ? FTContents.START : (cont = this.wsConsumeWs("end") ? FTContents.END : null);
                if (cont == null) {
                    throw this.error(QueryError.INCOMPLETE, new Object[0]);
                }
                expr = new FTContent(this.info(), expr, cont);
            } else if (this.wsConsumeWs("entire")) {
                this.wsCheck("content");
                expr = new FTContent(this.info(), expr, FTContents.ENTIRE);
            } else {
                boolean diff;
                boolean same = this.wsConsumeWs("same");
                boolean bl = diff = !same && this.wsConsumeWs("different");
                if (same || diff) {
                    FTUnit unit;
                    if (this.wsConsumeWs("sentence")) {
                        unit = FTUnit.SENTENCES;
                    } else if (this.wsConsumeWs("paragraph")) {
                        unit = FTUnit.PARAGRAPHS;
                    } else {
                        throw this.error(QueryError.INCOMPLETE, new Object[0]);
                    }
                    expr = new FTScope(this.info(), expr, same, unit);
                }
            }
            if (first != null || old == null || old == expr) continue;
            first = expr;
        } while (old != expr);
        if (ordered) {
            if (first == null) {
                return new FTOrder(this.info(), expr);
            }
            first.exprs[0] = new FTOrder(this.info(), first.exprs[0]);
        }
        return expr;
    }

    private FTExpr ftOr(boolean prg) throws QueryException {
        FTExpr expr = this.ftAnd(prg);
        if (!this.wsConsumeWs("ftor")) {
            return expr;
        }
        FTExpr[] list = new FTExpr[]{expr};
        do {
            list = Array.add(list, this.ftAnd(prg));
        } while (this.wsConsumeWs("ftor"));
        return new FTOr(this.info(), list);
    }

    private FTExpr ftAnd(boolean prg) throws QueryException {
        FTExpr expr = this.ftMildNot(prg);
        if (!this.wsConsumeWs("ftand")) {
            return expr;
        }
        FTExpr[] list = new FTExpr[]{expr};
        do {
            list = Array.add(list, this.ftMildNot(prg));
        } while (this.wsConsumeWs("ftand"));
        return new FTAnd(this.info(), list);
    }

    private FTExpr ftMildNot(boolean prg) throws QueryException {
        FTExpr not;
        FTExpr expr = this.ftUnaryNot(prg);
        if (!this.wsConsumeWs("not")) {
            return expr;
        }
        FTExpr[] list = new FTExpr[]{};
        do {
            this.wsCheck("in");
            list = Array.add(list, this.ftUnaryNot(prg));
        } while (this.wsConsumeWs("not"));
        InputInfo ii = this.info();
        FTExpr fTExpr = not = list.length == 1 ? list[0] : new FTOr(ii, list);
        if (expr.usesExclude() || not.usesExclude()) {
            throw this.error(QueryError.FTMILD, ii, new Object[0]);
        }
        return new FTMildNot(ii, expr, not);
    }

    private FTExpr ftUnaryNot(boolean prg) throws QueryException {
        boolean not = this.wsConsumeWs("ftnot");
        FTExpr expr = this.ftPrimaryWithOptions(prg);
        return not ? new FTNot(this.info(), expr) : expr;
    }

    private FTExpr ftPrimaryWithOptions(boolean prg) throws QueryException {
        FTExpr expr = this.ftPrimary(prg);
        FTOpt fto = new FTOpt();
        boolean found = false;
        while (this.ftMatchOption(fto)) {
            found = true;
        }
        if (found) {
            if (fto.ln == null) {
                fto.ln = Language.def();
            }
            if (!Tokenizer.supportFor(fto.ln)) {
                throw this.error(QueryError.FTNOTOK_X, fto.ln);
            }
            if (fto.is(FTFlag.ST) && fto.sd == null && !Stemmer.supportFor(fto.ln)) {
                throw this.error(QueryError.FTNOSTEM_X, fto.ln);
            }
        }
        if (this.wsConsumeWs("weight")) {
            expr = new FTWeight(this.info(), expr, this.enclosedExpr());
        }
        return found ? new FTOptions(this.info(), expr, fto) : expr;
    }

    private FTExpr ftPrimary(boolean prg) throws QueryException {
        Expr e;
        Pragma[] pragmas = this.pragma();
        if (pragmas != null) {
            this.wsCheck("{");
            FTExpr expr = this.ftSelection(true);
            this.wsCheck("}");
            for (int p = pragmas.length - 1; p >= 0; --p) {
                expr = new FTExtension(this.info(), pragmas[p], expr);
            }
            return expr;
        }
        if (this.wsConsume("(")) {
            FTExpr expr = this.ftSelection(false);
            this.wsCheck(")");
            return expr;
        }
        this.skipWs();
        if (QueryParser.quote(this.current())) {
            e = Str.get(this.stringLiteral());
        } else if (this.current(123)) {
            e = this.enclosedExpr();
        } else {
            throw this.error(prg ? QueryError.NOPRAGMA : QueryError.NOFTSELECT_X, new Object[]{this.found()});
        }
        FTMode mode = FTMode.ANY;
        if (this.wsConsumeWs("all")) {
            mode = this.wsConsumeWs("words") ? FTMode.ALL_WORDS : FTMode.ALL;
        } else if (this.wsConsumeWs("any")) {
            mode = this.wsConsumeWs("word") ? FTMode.ANY_WORD : FTMode.ANY;
        } else if (this.wsConsumeWs("phrase")) {
            mode = FTMode.PHRASE;
        }
        Expr[] occ = null;
        if (this.wsConsumeWs("occurs")) {
            occ = this.ftRange(false);
            if (occ == null) {
                throw this.error(QueryError.FTRANGE, new Object[0]);
            }
            this.wsCheck("times");
        }
        return new FTWords(this.info(), e, mode, occ);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expr[] ftRange(boolean i) throws QueryException {
        Expr[] occ = new Expr[]{Itr.ZERO, Itr.MAX};
        if (this.wsConsumeWs("exactly")) {
            occ[0] = this.ftAdditive(i);
            occ[1] = occ[0];
            return occ;
        } else if (this.wsConsumeWs("at")) {
            if (this.wsConsumeWs("least")) {
                occ[0] = this.ftAdditive(i);
                return occ;
            } else {
                if (!this.wsConsumeWs("most")) return null;
                occ[1] = this.ftAdditive(i);
            }
            return occ;
        } else {
            if (!this.wsConsumeWs("from")) return null;
            occ[0] = this.ftAdditive(i);
            this.wsCheck("to");
            occ[1] = this.ftAdditive(i);
        }
        return occ;
    }

    private Expr ftAdditive(boolean i) throws QueryException {
        if (!i) {
            return this.additive();
        }
        this.skipWs();
        this.token.reset();
        while (Token.digit(this.current())) {
            this.token.add(this.consume());
        }
        if (this.token.isEmpty()) {
            throw this.error(QueryError.INTEXP, new Object[0]);
        }
        return Itr.get(Token.toLong(this.token.toArray()));
    }

    private FTUnit ftUnit() throws QueryException {
        if (this.wsConsumeWs("words")) {
            return FTUnit.WORDS;
        }
        if (this.wsConsumeWs("sentences")) {
            return FTUnit.SENTENCES;
        }
        if (this.wsConsumeWs("paragraphs")) {
            return FTUnit.PARAGRAPHS;
        }
        throw this.error(QueryError.INCOMPLETE, new Object[0]);
    }

    private boolean ftMatchOption(FTOpt opt) throws QueryException {
        if (!this.wsConsumeWs("using")) {
            return false;
        }
        if (this.wsConsumeWs("lowercase")) {
            if (opt.cs != null) {
                throw this.error(QueryError.FTDUP_X, "case");
            }
            opt.cs = FTCase.LOWER;
        } else if (this.wsConsumeWs("uppercase")) {
            if (opt.cs != null) {
                throw this.error(QueryError.FTDUP_X, "case");
            }
            opt.cs = FTCase.UPPER;
        } else if (this.wsConsumeWs("case")) {
            if (opt.cs != null) {
                throw this.error(QueryError.FTDUP_X, "case");
            }
            if (this.wsConsumeWs("sensitive")) {
                opt.cs = FTCase.SENSITIVE;
            } else {
                opt.cs = FTCase.INSENSITIVE;
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("diacritics")) {
            if (opt.isSet(FTFlag.DC)) {
                throw this.error(QueryError.FTDUP_X, "diacritics");
            }
            opt.set(FTFlag.DC, this.wsConsumeWs("sensitive"));
            if (!opt.is(FTFlag.DC)) {
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("language")) {
            if (opt.ln != null) {
                throw this.error(QueryError.FTDUP_X, "language");
            }
            byte[] lan = this.stringLiteral();
            opt.ln = Language.get(Token.string(lan));
            if (opt.ln == null) {
                throw this.error(QueryError.FTNOTOK_X, new Object[]{lan});
            }
        } else if (this.wsConsumeWs("option")) {
            this.optionDecl();
        } else {
            boolean using;
            boolean bl = using = !this.wsConsumeWs("no");
            if (this.wsConsumeWs("stemming")) {
                if (opt.isSet(FTFlag.ST)) {
                    throw this.error(QueryError.FTDUP_X, "stemming");
                }
                opt.set(FTFlag.ST, using);
            } else if (this.wsConsumeWs("thesaurus")) {
                if (opt.th != null) {
                    throw this.error(QueryError.FTDUP_X, "thesaurus");
                }
                opt.th = new ThesList();
                if (using) {
                    boolean par = this.wsConsume("(");
                    if (!this.wsConsumeWs("default")) {
                        this.ftThesaurusID(opt.th);
                    }
                    while (par && this.wsConsume(",")) {
                        this.ftThesaurusID(opt.th);
                    }
                    if (par) {
                        this.wsCheck(")");
                    }
                }
            } else if (this.wsConsumeWs("stop")) {
                StopWords sw;
                this.wsCheck("words");
                if (opt.sw != null) {
                    throw this.error(QueryError.FTDUP_X, "stop words");
                }
                opt.sw = sw = new StopWords();
                if (this.wsConsumeWs("default")) {
                    if (!using) {
                        throw this.error(QueryError.FTSTOP, new Object[0]);
                    }
                } else if (using) {
                    boolean union = false;
                    boolean except = false;
                    do {
                        if (this.wsConsume("(")) {
                            do {
                                byte[] sl = this.stringLiteral();
                                if (except) {
                                    sw.remove(sl);
                                    continue;
                                }
                                sw.add(sl);
                            } while (this.wsConsume(","));
                            this.wsCheck(")");
                        } else if (this.wsConsumeWs("at")) {
                            IO fl = this.qc.resources.stopWords(Token.string(this.stringLiteral()), this.sc);
                            try {
                                opt.sw.read(fl, except);
                            }
                            catch (IOException expr) {
                                Util.debug(expr);
                                throw this.error(QueryError.NOSTOPFILE_X, fl);
                            }
                        } else if (!union && !except) {
                            throw this.error(QueryError.FTSTOP, new Object[0]);
                        }
                        union = this.wsConsumeWs("union");
                        boolean bl2 = except = !union && this.wsConsumeWs("except");
                    } while (union || except);
                }
            } else if (this.wsConsumeWs("wildcards")) {
                if (opt.isSet(FTFlag.WC)) {
                    throw this.error(QueryError.FTDUP_X, "wildcards");
                }
                if (opt.is(FTFlag.FZ)) {
                    throw this.error(QueryError.FT_OPTIONS, new Object[0]);
                }
                opt.set(FTFlag.WC, using);
            } else if (this.wsConsumeWs("fuzzy")) {
                if (opt.isSet(FTFlag.FZ)) {
                    throw this.error(QueryError.FTDUP_X, "fuzzy");
                }
                if (opt.is(FTFlag.WC)) {
                    throw this.error(QueryError.FT_OPTIONS, new Object[0]);
                }
                opt.set(FTFlag.FZ, using);
                if (Token.digit(this.current())) {
                    opt.errors = (int)((ANum)this.ftAdditive(true)).itr();
                    this.wsCheck("errors");
                }
            } else {
                throw this.error(QueryError.FTMATCH_X, this.currentAsString());
            }
        }
        return true;
    }

    private void ftThesaurusID(ThesList queries) throws QueryException {
        this.wsCheck("at");
        IO fl = this.qc.resources.thesaurus(Token.string(this.stringLiteral()), this.sc);
        byte[] rel = this.wsConsumeWs("relationship") ? this.stringLiteral() : Token.EMPTY;
        Expr[] range = this.ftRange(true);
        long min = 0L;
        long max = Long.MAX_VALUE;
        if (range != null) {
            this.wsCheck("levels");
            min = ((ANum)range[0]).itr();
            max = ((ANum)range[1]).itr();
        }
        queries.add(new ThesAccessor(fl, rel, min, max, this.info()));
    }

    private Expr insert() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("insert") || !this.wsConsumeWs("node") && !this.wsConsumeWs("nodes")) {
            this.pos = p;
            return null;
        }
        Expr s = this.check(this.single(), QueryError.INCOMPLETE);
        Insert.Mode mode = Insert.Mode.INTO;
        if (this.wsConsumeWs("as")) {
            if (this.wsConsumeWs("first")) {
                mode = Insert.Mode.FIRST;
            } else {
                this.wsCheck("last");
                mode = Insert.Mode.LAST;
            }
            this.wsCheck("into");
        } else if (!this.wsConsumeWs("into")) {
            if (this.wsConsumeWs("after")) {
                mode = Insert.Mode.AFTER;
            } else if (this.wsConsumeWs("before")) {
                mode = Insert.Mode.BEFORE;
            } else {
                throw this.error(QueryError.INCOMPLETE, new Object[0]);
            }
        }
        Expr trg = this.check(this.single(), QueryError.INCOMPLETE);
        this.qc.updating();
        return new Insert(this.info(), s, mode, trg);
    }

    private Expr delete() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("delete") || !this.wsConsumeWs("nodes") && !this.wsConsumeWs("node")) {
            this.pos = p;
            return null;
        }
        this.qc.updating();
        return new Delete(this.info(), this.check(this.single(), QueryError.INCOMPLETE));
    }

    private Expr rename() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("rename") || !this.wsConsumeWs("node") && !this.wsConsumeWs("nodes")) {
            this.pos = p;
            return null;
        }
        Expr trg = this.check(this.single(), QueryError.INCOMPLETE);
        this.wsCheck("as");
        Expr n = this.check(this.single(), QueryError.INCOMPLETE);
        this.qc.updating();
        return new Rename(this.info(), trg, n);
    }

    private Expr replace() throws QueryException {
        int p = this.pos;
        if (!this.wsConsumeWs("replace")) {
            return null;
        }
        boolean value = this.wsConsumeWs("value");
        if (value) {
            this.wsCheck("of");
            if (!this.wsConsumeWs("nodes")) {
                this.wsCheck("node");
            }
        } else if (!this.wsConsumeWs("node") && !this.wsConsumeWs("nodes")) {
            this.pos = p;
            return null;
        }
        Expr trg = this.check(this.single(), QueryError.INCOMPLETE);
        this.wsCheck("with");
        Expr src = this.check(this.single(), QueryError.INCOMPLETE);
        this.qc.updating();
        return new Replace(this.info(), trg, src, value);
    }

    private Expr copyModify() throws QueryException {
        if (!this.wsConsumeWs("copy", QueryError.INCOMPLETE, "$")) {
            return null;
        }
        int s = this.localVars.openScope();
        Let[] fl = new Let[]{};
        do {
            Var var = this.newVar(SeqType.NODE_O);
            this.wsCheck(":=");
            Expr expr = this.check(this.single(), QueryError.INCOMPLETE);
            fl = Array.add(fl, new Let(this.localVars.add(var), expr));
        } while (this.wsConsumeWs(","));
        this.wsCheck("modify");
        InputInfo ii = this.info();
        Expr m = this.check(this.single(), QueryError.INCOMPLETE);
        this.wsCheck("return");
        Expr r = this.check(this.single(), QueryError.INCOMPLETE);
        this.localVars.closeScope(s);
        this.qc.updating();
        return new Transform(ii, fl, m, r);
    }

    private Expr updatingFunctionCall() throws QueryException {
        int p = this.pos;
        this.wsConsume("invoke");
        boolean upd = this.wsConsumeWs("updating");
        boolean ndt = this.wsConsumeWs("nondeterministic");
        if (upd || ndt) {
            Expr func = this.primary();
            if (this.wsConsume("(")) {
                InputInfo ii = this.info();
                ExprList argList = new ExprList();
                if (!this.wsConsume(")")) {
                    do {
                        Expr expr;
                        if ((expr = this.single()) == null) {
                            throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
                        }
                        argList.add(expr);
                    } while (this.wsConsume(","));
                    if (!this.wsConsume(")")) {
                        throw this.error(QueryError.FUNCARG_X, new Object[]{this.found()});
                    }
                }
                if (upd) {
                    this.qc.updating();
                }
                return new DynFuncCall(ii, upd, ndt, func, (Expr[])argList.finish());
            }
        }
        this.pos = p;
        return null;
    }

    private byte[] ncName(QueryError error) throws QueryException {
        this.token.reset();
        if (this.ncName()) {
            return this.token.toArray();
        }
        if (error != null) {
            throw this.error(error, this.currentAsString());
        }
        return Token.EMPTY;
    }

    private QNm eQName(byte[] ns, QueryError error) throws QueryException {
        byte[] nm;
        Object name;
        int p = this.pos;
        if (this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            name = this.ncName(null);
            if (((byte[])name).length != 0) {
                return new QNm((byte[])name, uri);
            }
            this.pos = p;
        }
        if ((nm = this.qName(error)).length == 0) {
            return null;
        }
        if (ns == SKIPCHECK) {
            return new QNm(nm);
        }
        name = new QNm(nm, this.sc);
        if (!name.hasURI()) {
            if (name.hasPrefix()) {
                this.pos = p;
                throw this.error(QueryError.NOURI_X, new Object[]{name.prefix()});
            }
            name.uri(ns);
        }
        return name;
    }

    private byte[] qName(QueryError error) throws QueryException {
        this.token.reset();
        if (!this.ncName()) {
            if (error != null) {
                throw this.error(error, this.currentAsString());
            }
        } else if (this.consume(58)) {
            if (XMLToken.isNCStartChar(this.current())) {
                this.token.add(58);
                do {
                    this.token.add(this.consume());
                } while (XMLToken.isNCChar(this.current()));
            } else {
                --this.pos;
            }
        }
        return this.token.toArray();
    }

    private boolean ncName() {
        if (!XMLToken.isNCStartChar(this.current())) {
            return false;
        }
        do {
            this.token.add(this.consume());
        } while (XMLToken.isNCChar(this.current()));
        return true;
    }

    private boolean entity(TokenBuilder tb) throws QueryException {
        int p = this.pos;
        boolean entity = this.consume(38);
        if (entity) {
            if (this.consume(35)) {
                int b = this.consume(120) ? 16 : 10;
                boolean ok = true;
                int n = 0;
                do {
                    boolean h;
                    int cp = this.current();
                    boolean m = Token.digit(cp);
                    boolean bl = h = b == 16 && (cp >= 97 && cp <= 102 || cp >= 65 && cp <= 70);
                    if (!m && !h) {
                        this.entityError(p, QueryError.INVENTITY_X);
                    }
                    long nn = n;
                    if ((long)(n = n * b + (this.consume() & 0xF)) < nn) {
                        ok = false;
                    }
                    if (m) continue;
                    n += 9;
                } while (!this.consume(59));
                if (!ok) {
                    this.entityError(p, QueryError.INVCHARREF_X);
                }
                if (!XMLToken.valid(n)) {
                    this.entityError(p, QueryError.INVCHARREF_X);
                }
                tb.add(n);
            } else {
                if (this.consume("lt")) {
                    tb.add(60);
                } else if (this.consume("gt")) {
                    tb.add(62);
                } else if (this.consume("amp")) {
                    tb.add(38);
                } else if (this.consume("quot")) {
                    tb.add(34);
                } else if (this.consume("apos")) {
                    tb.add(39);
                } else {
                    this.entityError(p, QueryError.INVENTITY_X);
                }
                if (!this.consume(59)) {
                    this.entityError(p, QueryError.INVENTITY_X);
                }
            }
        } else {
            tb.add(this.consume());
        }
        return entity;
    }

    private void entityError(int start, QueryError code) throws QueryException {
        String sub = this.substring(start, Math.min(start + 20, this.length)).toString();
        int semi = sub.indexOf(59);
        throw this.error(code, semi == -1 ? sub + "..." : sub.substring(0, semi + 1));
    }

    private <E extends Expr> E check(E expr, QueryError error) throws QueryException {
        if (expr == null) {
            throw this.error(error, new Object[0]);
        }
        return expr;
    }

    private void check(char ch) throws QueryException {
        if (!this.consume(ch)) {
            throw this.error(QueryError.WRONGCHAR_X_X, Character.valueOf(ch), this.found());
        }
    }

    private void wsCheck(String string) throws QueryException {
        if (!this.wsConsume(string)) {
            throw this.error(QueryError.WRONGCHAR_X_X, string, this.found());
        }
    }

    private boolean wsConsumeWs(String string) throws QueryException {
        int p = this.pos;
        if (this.wsConsume(string)) {
            if (this.skipWs() || !XMLToken.isNCStartChar(string.charAt(0)) || !XMLToken.isNCChar(this.current())) {
                return true;
            }
            this.pos = p;
        }
        return false;
    }

    private boolean wsConsumeWs(String string, QueryError expr, String ... strings) throws QueryException {
        int p1 = this.pos;
        if (!this.wsConsumeWs(string)) {
            return false;
        }
        int p2 = this.pos;
        this.alter = expr;
        this.alterPos = p2;
        for (String s : strings) {
            if (!this.wsConsume(s)) continue;
            this.pos = p2;
            return true;
        }
        this.pos = p1;
        return false;
    }

    private boolean wsConsume(String string) throws QueryException {
        this.skipWs();
        return this.consume(string);
    }

    private boolean skipWs() throws QueryException {
        int i = this.pos;
        while (this.more()) {
            int cp = this.current();
            if (cp == 40 && this.next() == 58) {
                this.comment();
                continue;
            }
            if (cp == 0 || cp > 32) {
                return i != this.pos;
            }
            ++this.pos;
        }
        return i != this.pos;
    }

    private void comment() throws QueryException {
        boolean xqdoc;
        ++this.pos;
        boolean bl = xqdoc = this.next() == 126;
        if (xqdoc) {
            this.docBuilder.reset();
            ++this.pos;
        }
        this.comment(false, xqdoc);
    }

    private void comment(boolean nested, boolean xqdoc) throws QueryException {
        while (++this.pos < this.length) {
            int curr = this.current();
            if (curr == 40 && this.next() == 58) {
                ++this.pos;
                this.comment(true, xqdoc);
                curr = this.current();
            }
            if (curr == 58 && this.next() == 41) {
                this.pos += 2;
                if (!nested && this.moduleDoc.isEmpty()) {
                    this.moduleDoc = this.docBuilder.toString().trim();
                    this.docBuilder.reset();
                }
                return;
            }
            if (!xqdoc) continue;
            this.docBuilder.add(curr);
        }
        throw this.error(QueryError.COMCLOSE, new Object[0]);
    }

    private boolean consumeWS() {
        int i = this.pos;
        while (this.more()) {
            int cp = this.current();
            if (cp == 0 || cp > 32) {
                return i != this.pos;
            }
            ++this.pos;
        }
        return true;
    }

    private QueryException alterError(QueryError error) {
        if (this.alter == null) {
            return this.error(error, new Object[0]);
        }
        this.pos = this.alterPos;
        return this.error(this.alter, new Object[0]);
    }

    private void add(ExprList ar, Expr expr) throws QueryException {
        if (expr == null) {
            throw this.error(QueryError.INCOMPLETE, new Object[0]);
        }
        ar.add(expr);
    }

    private QueryException error(QueryError error, Object ... arg) {
        return this.error(error, this.info(), arg);
    }

    public QueryException error(QueryError error, InputInfo info, Object ... arg) {
        return error.get(info, arg);
    }

    public static boolean isLibrary(String query) {
        return LIBMOD_PATTERN.matcher(QueryParser.removeComments(query, 80)).matches();
    }

    public static String removeComments(String query, int max) {
        StringBuilder sb = new StringBuilder();
        boolean s = false;
        int ql = query.length();
        int m = 0;
        for (int c = 0; c < ql && sb.length() < max; ++c) {
            char ch = query.charAt(c);
            if (ch == '\r') continue;
            if (ch == '(' && c + 1 < ql && query.charAt(c + 1) == ':') {
                if (m == 0 && !s) {
                    sb.append(' ');
                    s = true;
                }
                ++m;
                ++c;
                continue;
            }
            if (m != 0 && ch == ':' && c + 1 < ql && query.charAt(c + 1) == ')') {
                --m;
                ++c;
                continue;
            }
            if (m != 0) continue;
            if (ch > ' ') {
                sb.append(ch);
            } else if (!s) {
                sb.append(' ');
            }
            s = ch <= ' ';
        }
        if (sb.length() >= max) {
            sb.append("...");
        }
        return sb.toString().trim();
    }

    @Override
    public final InputInfo info() {
        return new InputInfo(this, this.sc);
    }

    private static /* synthetic */ VarRef[] lambda$flwor$1(int x$0) {
        return new VarRef[x$0];
    }
}

