/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Mapping;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Pipeline
extends Mapping {
    public Pipeline(InputInfo info, Expr ... exprs) {
        super(info, exprs[exprs.length - 1].seqType(), exprs);
    }

    public static Expr get(CompileContext cc, InputInfo info, Expr ... exprs) throws QueryException {
        int el = exprs.length;
        return el > 1 ? new Pipeline(info, exprs).optimize(cc) : exprs[0];
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.flatten(cc);
        Expr[] merged = this.merge(cc);
        if (merged != null) {
            return Pipeline.get(cc, this.info, merged);
        }
        int el = this.exprs.length;
        this.exprType.assign(this.exprs[el - 1]);
        return this;
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        return new Iter(){
            QueryFocus qf;
            Iter iter;

            @Override
            public Item next() throws QueryException {
                QueryFocus focus = qc.focus;
                try {
                    if (this.iter == null) {
                        this.qf = Pipeline.this.eval(qc);
                        this.iter = Pipeline.this.exprs[Pipeline.this.exprs.length - 1].iter(qc);
                    }
                    qc.focus = this.qf;
                    Item item = this.iter.next();
                    return item;
                }
                finally {
                    qc.focus = focus;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        QueryFocus focus = qc.focus;
        try {
            this.eval(qc);
            Value value = this.exprs[this.exprs.length - 1].value(qc);
            return value;
        }
        finally {
            qc.focus = focus;
        }
    }

    private QueryFocus eval(QueryContext qc) throws QueryException {
        QueryFocus qf = new QueryFocus();
        qf.value = this.exprs[0].value(qc);
        qc.focus = qf;
        int last = this.exprs.length - 1;
        for (int e = 1; e < last; ++e) {
            qf.value = this.exprs[e].value(qc);
        }
        return qf;
    }

    @Override
    boolean items() {
        return false;
    }

    @Override
    Expr merge(Expr expr, Expr next, CompileContext cc) {
        return expr.has(Flag.NDT) ? null : (next.has(Flag.CTX) ? Pipeline.inline(expr, next, cc) : next);
    }

    @Override
    public Pipeline copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Pipeline(this.info, Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Pipeline && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " -> ", true);
    }
}

