/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.map.MapCompilation;
import org.basex.query.func.map.MapMerge;
import org.basex.query.func.map.ValueMerger;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class MapOfPairs
extends MapMerge {
    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter input = this.arg(0).iter(qc);
        MapMerge.MergeOptions options = this.toOptions(this.arg(1), new MapMerge.MergeOptions(), qc);
        ValueMerger merger = this.merger(options, qc, MapMerge.Duplicates.COMBINE);
        MapBuilder builder = new MapBuilder(input.size());
        while ((item = qc.next(input)) != null) {
            Value old;
            XQMap pair = this.toRecord(item, SeqType.PAIR, qc);
            Item key = this.toAtomItem(pair.get(Str.KEY), qc);
            Value val = merger.merge(key, old = builder.get(key), pair.get(Str.VALUE));
            if (val == null) continue;
            builder.put(key, val);
        }
        return builder.map(this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        this.prepareMerge(1, MapMerge.Duplicates.COMBINE, cc);
        RecordField key = null;
        RecordField value = null;
        MapCompilation mc = MapCompilation.get(this.arg(0));
        if (mc.record != null) {
            key = mc.record.fields().get(Str.KEY.string());
            value = mc.record.fields().get(Str.VALUE.string());
        }
        if (key != null && value != null) {
            this.assignType(key.seqType().type, value.seqType());
        } else if (mc.mapType != null) {
            SeqType vt = mc.mapType.valueType();
            this.assignType(vt.type.atomic(), vt);
        }
        return this;
    }
}

