/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xquery;

import java.util.ArrayList;
import java.util.concurrent.ForkJoinPool;
import org.basex.core.jobs.JobException;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.xquery.TaskContext;
import org.basex.query.func.xquery.TaskOptions;
import org.basex.query.func.xquery.XQueryTask;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Util;

public final class XQueryForkJoin
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item function;
        Iter functions = this.arg(0).iter(qc);
        TaskOptions options = this.toOptions(this.arg(1), new TaskOptions(), qc);
        long size = functions.size();
        if (size == 0L) {
            return Empty.VALUE;
        }
        ArrayList<FItem> list = new ArrayList<FItem>(Seq.initialCapacity(size));
        while ((function = functions.next()) != null) {
            list.add(this.checkUp(this.toFunction(function, 0, qc), false));
        }
        if (list.size() == 1) {
            return ((FItem)list.get(0)).invoke(qc, this.info, new Value[0]);
        }
        ForkJoinPool pool = new ForkJoinPool(options.parallel());
        TaskContext tc = new TaskContext(list, options, qc, this.info);
        try {
            Value value = pool.invoke(new XQueryTask(tc));
            return value;
        }
        catch (Exception ex) {
            Throwable e = Util.rootException(ex);
            if (e instanceof QueryException) {
                QueryException qe = (QueryException)e;
                throw qe;
            }
            if (e instanceof JobException) {
                JobException je = (JobException)e;
                throw je;
            }
            throw QueryError.XQUERY_UNEXPECTED_X.get(this.info, e);
        }
        finally {
            pool.shutdown();
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Boolean results;
        Expr functions = this.arg(0);
        Expr options = this.arg(1);
        SeqType st = functions.seqType();
        if (st.zero()) {
            return functions;
        }
        if (st.one()) {
            return new DynFuncCall(this.info, this.coerceFunc(0, cc), new Expr[0]).optimize(cc);
        }
        Boolean bl = options == Empty.UNDEFINED ? Boolean.TRUE : (results = options instanceof Value ? this.toOptions(options, new TaskOptions(), cc.qc).get(TaskOptions.RESULTS) : null);
        if (results == Boolean.TRUE) {
            FuncType ft = functions.funcType();
            if (ft != null) {
                SeqType dt = ft.declType;
                this.exprType.assign(dt.with(dt.occ.multiply(st.occ)));
            }
        } else if (results == Boolean.FALSE) {
            this.exprType.assign(SeqType.EMPTY_SEQUENCE_Z);
        }
        return this;
    }

    @Override
    public int hofIndex() {
        return 0;
    }
}

