/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xslt;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.function.Supplier;
import javax.xml.transform.Transformer;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.type.NodeType;
import org.basex.util.Reflect;
import org.basex.util.Util;

final class XsltReport {
    private static final Class<?> TI = Reflect.find("net.sf.saxon.jaxp.TransformerImpl");
    private static final Class<?> XC = Reflect.find("net.sf.saxon.trans.XsltController");
    private static final Class<?> MW = Reflect.find("net.sf.saxon.serialize.MessageWarner");
    private static final Method TI_GUC = Reflect.method(TI, "getUnderlyingController", new Class[0]);
    private static final Method MW_GW = Reflect.method(MW, "getWriter", new Class[0]);
    private static final Method MW_SMW = Reflect.method(XC, "setMessageFactory", Supplier.class);
    private final MapBuilder report = new MapBuilder();
    private final Stack<Object> messages = new Stack();
    private final QueryContext qc;

    XsltReport(QueryContext qc) {
        this.qc = qc;
    }

    void register(Transformer tr) {
        if (tr.getClass() == TI) {
            try {
                Supplier<Object> supplier = () -> {
                    Object mw = Reflect.get(MW);
                    this.messages.add(mw);
                    return mw;
                };
                MW_SMW.invoke(TI_GUC.invoke((Object)tr, new Object[0]), supplier);
            }
            catch (Exception ex) {
                Util.stack(ex);
            }
        }
    }

    void addResult(byte[] result) throws QueryException {
        this.report.put("result", this.convert(new IOContent(result), true));
    }

    void addMessage() throws QueryException {
        ValueBuilder vb = new ValueBuilder(this.qc);
        try {
            for (Object e : this.messages) {
                ArrayBuilder ab = new ArrayBuilder(this.qc);
                for (Item item : this.convert(new IOContent(MW_GW.invoke(e, new Object[0]).toString()), false)) {
                    ab.add(item);
                }
                vb.add(ab.array());
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        this.report.put("messages", vb.value());
    }

    void addError(Str error) throws QueryException {
        this.report.put("error", (Value)error);
    }

    XQMap finish() {
        return this.report.map();
    }

    private Value convert(IOContent content, boolean result) {
        DBNode node;
        FBuilder doc = result ? FDoc.build() : null;
        try {
            node = new DBNode(content);
        }
        catch (IOException ex) {
            Util.debug(ex);
            try {
                node = new DBNode(new XMLParser(content, new MainOptions(), true));
            }
            catch (IOException ex2) {
                Util.debug(ex2);
                return Str.get(content.read());
            }
        }
        ValueBuilder vb = new ValueBuilder(this.qc);
        for (ANode child : ((ANode)node).childIter()) {
            vb.add(child.type == NodeType.TEXT ? Atm.get(child.string()) : (result ? doc.add(child.finish()).finish() : child.finish()));
        }
        return vb.value();
    }
}

