/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryBiPredicate;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.TrieEmpty;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.map.TrieOrder;
import org.basex.query.value.map.TrieUpdate;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public final class XQTrieMap
extends XQMap {
    static final XQMap EMPTY = new XQTrieMap(TrieEmpty.VALUE, null, SeqType.MAP);
    private final TrieNode root;
    private final TrieOrder order;

    XQTrieMap(TrieNode root, TrieOrder order, Type type) {
        super(type);
        this.root = root;
        this.order = order;
    }

    @Override
    public Value getOrNull(Item key) throws QueryException {
        return this.root.get(key.hashCode(), key, 0);
    }

    @Override
    public Value keys() {
        long size = this.structSize();
        return size == 0L ? Empty.VALUE : (size == 1L ? ((TrieLeaf)this.root).key : this.order.keys());
    }

    @Override
    public Item keyAt(int index) {
        return this.keys().itemAt(index);
    }

    @Override
    public Value valueAt(int index) {
        try {
            return this.getOrNull(this.keyAt(index));
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public XQTrieMap put(Item key, Value value) throws QueryException {
        MapType mt;
        TrieOrder to;
        long oldSize = this.structSize();
        if (oldSize == 0L) {
            return new XQTrieMap(new TrieLeaf(key.hashCode(), key, value), null, MapType.get(key.type, value.seqType()));
        }
        TrieUpdate update = new TrieUpdate(key, value, this.order);
        TrieNode node = this.root.put(key.hashCode(), 0, update);
        if (node == this.root) {
            return this;
        }
        if (node.size == 1) {
            to = null;
            mt = MapType.get(((TrieLeaf)this.root).key.type, value.seqType());
        } else {
            to = oldSize == 1L ? new TrieOrder(((TrieLeaf)this.root).key, key) : update.order();
            mt = ((MapType)this.type).union(key.type, value.seqType());
        }
        return new XQTrieMap(node, to, mt);
    }

    @Override
    public XQTrieMap putAt(int index, Value value) throws QueryException {
        return this.put(this.keyAt(index), value);
    }

    @Override
    public XQMap remove(Item key) throws QueryException {
        TrieUpdate update = new TrieUpdate(key, null, this.order);
        TrieNode node = this.root.remove(key.hashCode(), 0, update);
        if (node == this.root) {
            return this;
        }
        if (node == null) {
            return EMPTY;
        }
        TrieOrder to = node.size == 1 ? null : update.order();
        return new XQTrieMap(node, to, this.type);
    }

    @Override
    public long structSize() {
        return this.root.size;
    }

    @Override
    public void forEach(QueryBiConsumer<Item, Value> func) throws QueryException {
        for (Item key : this.keys()) {
            func.accept(key, this.get(key));
        }
    }

    @Override
    public boolean test(QueryBiPredicate<Item, Value> func) throws QueryException {
        for (Item key : this.keys()) {
            if (func.test(key, this.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Item shrink(QueryContext qc) throws QueryException {
        return this == EMPTY ? this : this.rebuild(qc);
    }
}

