/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntSet;
import org.basex.util.list.ByteList;
import org.basex.util.list.IntList;
import org.basex.util.list.LongList;
import org.basex.util.list.ShortList;

public final class IntSeq
extends NativeSeq {
    private final int[] values;

    private IntSeq(int[] values, Type type) {
        super(values.length, type);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        int[] values = new int[size];
        for (int s = 0; s < size; ++s) {
            values[s] = (int)in.readLong();
        }
        return IntSeq.get(values, type);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (int v : this.values) {
            out.writeLong(v);
        }
    }

    @Override
    public Itr itemAt(long index) {
        return Itr.get(this.values[(int)index], this.type);
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        if (pos == 0L) {
            return super.test(qc, ii, pos);
        }
        int[] nArray = this.values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long value = nArray[i];
            if (value != pos) continue;
            return true;
        }
        return false;
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        int[] tmp = new int[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return IntSeq.get(tmp, this.type);
    }

    public int[] values() {
        return this.values;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value expr = this;
        int[] tmp = null;
        if (mode == CompileContext.Simplify.PREDICATE) {
            tmp = new IntList((int)this.size).add(this.values).ddo().finish();
        } else if (mode == CompileContext.Simplify.DISTINCT) {
            IntSet is = new IntSet(this.size);
            for (int i : this.values) {
                is.add(i);
            }
            tmp = is.keys();
        }
        if (tmp != null) {
            int tl = tmp.length;
            int t = 0;
            if (this.seqType().type == AtomType.INTEGER) {
                while (++t < tl && tmp[0] + t == tmp[t]) {
                }
            }
            if (t == tl) {
                expr = RangeSeq.get(tmp[0], tl, true);
            } else if ((long)tl != this.size) {
                expr = IntSeq.get(tmp, this.type);
            }
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public Object toJava() {
        switch ((AtomType)this.type) {
            case BYTE: {
                ByteList bl = new ByteList((int)this.size);
                for (int value : this.values) {
                    bl.add((byte)value);
                }
                return bl.finish();
            }
            case SHORT: 
            case UNSIGNED_BYTE: {
                ShortList sl = new ShortList((int)this.size);
                for (int value : this.values) {
                    sl.add((short)value);
                }
                return sl.finish();
            }
            case UNSIGNED_SHORT: {
                char[] chars = new char[(int)this.size];
                int c = 0;
                for (int value : this.values) {
                    chars[c++] = (char)value;
                }
                return chars;
            }
            case INT: {
                return this.values;
            }
        }
        LongList il = new LongList((int)this.size);
        for (int value : this.values) {
            il.add((long)value);
        }
        return il.finish();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof IntSeq) {
            IntSeq seq = (IntSeq)obj;
            if (this.type != seq.type) return false;
            if (!Arrays.equals(this.values, seq.values)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    public static Value get(int[] values) {
        return IntSeq.get(values, AtomType.INTEGER);
    }

    public static Value get(int[] values, Type type) {
        int i;
        int vl = values.length;
        if (vl == 0) {
            return Empty.VALUE;
        }
        int first = values[0];
        if (vl == 1) {
            return Itr.get(first, type);
        }
        boolean singleton = true;
        int v = 0;
        for (boolean range = true; (singleton || range) && ++v < vl; singleton &= (i = values[v]) == first, range &= i == first + v) {
        }
        if (v == vl) {
            if (singleton) {
                return SingletonSeq.get(Itr.get(first, type), vl);
            }
            if (type == AtomType.INTEGER) {
                return RangeSeq.get(first, vl, true);
            }
        }
        return new IntSeq(values, type);
    }
}

