/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class TableMemBlock {
    private long[] data;
    int firstPre;

    private TableMemBlock(boolean compact) {
        this.data = new long[(compact ? 1 : 4096) << 1];
    }

    private static ArrayList<TableMemBlock> get(int count, boolean compact) {
        int bs = 4096 + count - 1 >>> 12;
        ArrayList<TableMemBlock> list = new ArrayList<TableMemBlock>(bs);
        for (int b = 0; b < bs; ++b) {
            list.add(new TableMemBlock(compact));
        }
        return list;
    }

    static ArrayList<TableMemBlock> get(int count, int pre) {
        ArrayList<TableMemBlock> blocks = TableMemBlock.get(count, true);
        int fp = pre;
        for (TableMemBlock block : blocks) {
            block.firstPre = fp;
            fp += 4096;
        }
        return blocks;
    }

    int remaining(int nextPre) {
        return 4096 - nextPre + this.firstPre;
    }

    long value(int pre, int offset) {
        return this.data[this.index(pre, offset)];
    }

    void value(int pre, int offset, long value) {
        int i = this.index(pre, offset);
        this.resize(i + 1);
        this.data[i] = value;
    }

    int delete(int pre, int count, int nextPre) {
        int first = pre - this.firstPre;
        int last = first + count;
        int filled = nextPre - this.firstPre;
        if (last >= filled) {
            return filled - first;
        }
        System.arraycopy(this.data, last << 1, this.data, first << 1, filled - last << 1);
        return count;
    }

    ArrayList<TableMemBlock> insert(int pre, int count, int nextPre) {
        int first = pre - this.firstPre;
        int last = first + count;
        int filled = nextPre - this.firstPre;
        int remaining = 4096 - filled;
        int copy = nextPre - pre;
        if (count <= remaining) {
            this.resize(last + copy << 1);
            System.arraycopy(this.data, first << 1, this.data, last << 1, copy << 1);
            return null;
        }
        this.resize(8192);
        ArrayList<TableMemBlock> blocks = TableMemBlock.get(count - remaining, false);
        int total = filled + count;
        long[] longs = new long[total << 1];
        System.arraycopy(this.data, 0, longs, 0, first << 1);
        System.arraycopy(this.data, first << 1, longs, last << 1, copy << 1);
        int bs = blocks.size();
        int fill = (total + bs) / (bs + 1);
        int total2 = total << 1;
        int fill2 = fill << 1;
        System.arraycopy(longs, 0, this.data, 0, fill2);
        int copied = fill;
        int copied2 = fill2;
        for (TableMemBlock block : blocks) {
            block.firstPre = this.firstPre + copied;
            System.arraycopy(longs, copied2, block.data, 0, Math.min(fill2, total2 - copied2));
            copied += fill;
            copied2 += fill2;
        }
        return blocks;
    }

    private void resize(int size) {
        long[] dt = this.data;
        int dl = dt.length;
        if (dl < size) {
            this.data = Arrays.copyOf(dt, Math.min(Math.max(size, dl << 1), 8192));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Util.className(this) + "[" + this.firstPre + ": ");
        IntList ints = new IntList();
        int first = -1;
        int last = 0;
        int dl = this.data.length;
        for (int d = 0; d < dl; ++d) {
            if (this.data[d] != 0L) {
                if (first == -1) {
                    first = d;
                }
                last = d;
                continue;
            }
            if (first == -1) continue;
            ints.add(first).add(last);
            first = -1;
        }
        if (first != -1) {
            ints.add(first).add(last);
        }
        for (int i = 0; i < ints.size(); i += 2) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(ints.get(i)).append('-').append(ints.get(i + 1));
        }
        return sb.append(']').toString();
    }

    private int index(int pre, int offset) {
        int p = pre - this.firstPre << 1;
        return offset < 8 ? p : p + 1;
    }
}

