/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.math.BigDecimal;
import java.math.MathContext;
import org.basex.query.CompileContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.CalcOpt;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Unary;
import org.basex.query.func.Function;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.Enums;
import org.basex.util.InputInfo;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Calc {
    ADD("+"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            boolean num2 = type2.isNumberOrUntyped();
            if (num1 && num2) {
                return switch (1.numType(type1, type2)) {
                    case AtomType.INTEGER -> CalcOpt.addInt(item1, item2, info);
                    case AtomType.DOUBLE -> CalcOpt.addDbl(item1, item2, info);
                    case AtomType.FLOAT -> CalcOpt.addFlt(item1, item2, info);
                    default -> CalcOpt.addDec(item1, item2, info);
                };
            }
            if (type1 == type2) {
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    return new YMDur((YMDur)item1, (YMDur)item2, true, info);
                }
                if (type1 == AtomType.DAY_TIME_DURATION) {
                    return new DTDur((DTDur)item1, (DTDur)item2, true, info);
                }
            } else {
                if (type1.instanceOf(AtomType.DATE_TIME)) {
                    return new Dtm((Dtm)item1, 1.dur(info, item2), true, info);
                }
                if (type2.instanceOf(AtomType.DATE_TIME)) {
                    return new Dtm((Dtm)item2, 1.dur(info, item1), true, info);
                }
                if (type1 == AtomType.DATE) {
                    return new Dat((Dat)item1, 1.dur(info, item2), true, info);
                }
                if (type2 == AtomType.DATE) {
                    return new Dat((Dat)item2, 1.dur(info, item1), true, info);
                }
                if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION) {
                    return new Tim((Tim)item1, (DTDur)item2, true);
                }
                if (type2 == AtomType.TIME && type1 == AtomType.DAY_TIME_DURATION) {
                    return new Tim((Tim)item2, (DTDur)item1, true);
                }
            }
            throw this.typeError(info, item1, item2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            ANum num;
            AtomType type = 1.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && (num = (ANum)expr2).dbl() == 0.0) {
                return new Cast(info, expr1, type.seqType()).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return new Arith(info, expr1, (Expr)Itr.get(2L), MULTIPLY).optimize(cc);
            }
            if (expr2 instanceof Unary) {
                Unary unry = (Unary)expr2;
                return new Arith(info, expr1, unry.expr, SUBTRACT).optimize(cc);
            }
            if (expr1 instanceof Arith) {
                Expr expr;
                Arith arth = (Arith)expr1;
                if (arth.calc == MULTIPLY && arth.exprs[0].equals(expr2) && (expr = arth.exprs[1]) instanceof Itr) {
                    Itr itr = (Itr)expr;
                    return new Arith(info, arth.exprs[0], (Expr)Itr.get(itr.itr() + 1L), MULTIPLY).optimize(cc);
                }
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1 == type2) {
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    return AtomType.YEAR_MONTH_DURATION;
                }
                if (type1 == AtomType.DAY_TIME_DURATION) {
                    return AtomType.DAY_TIME_DURATION;
                }
            }
            if (type1.instanceOf(AtomType.DATE_TIME)) {
                return type1;
            }
            if (type2.instanceOf(AtomType.DATE_TIME)) {
                return type2;
            }
            if (type1 == AtomType.DATE || type2 == AtomType.DATE) {
                return AtomType.DATE;
            }
            if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION || type1 == AtomType.DAY_TIME_DURATION && type2 == AtomType.TIME) {
                return AtomType.TIME;
            }
            return 1.numType(type1, type2);
        }

        @Override
        public Calc invert() {
            return SUBTRACT;
        }
    }
    ,
    SUBTRACT("-"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            boolean num2 = type2.isNumberOrUntyped();
            if (num1 && num2) {
                return switch (2.numType(type1, type2)) {
                    case AtomType.INTEGER -> CalcOpt.subtractInt(item1, item2, info);
                    case AtomType.DOUBLE -> CalcOpt.subtractDbl(item1, item2, info);
                    case AtomType.FLOAT -> CalcOpt.subtractFlt(item1, item2, info);
                    default -> CalcOpt.subtractDec(item1, item2, info);
                };
            }
            if (type1.instanceOf(AtomType.DATE_TIME) && type2.instanceOf(AtomType.DATE_TIME)) {
                return new DTDur((ADate)item1, (ADate)item2, info);
            }
            if (type1 == type2) {
                if (type1.oneOf(AtomType.DATE, AtomType.TIME)) {
                    return new DTDur((ADate)item1, (ADate)item2, info);
                }
                if (type1 == AtomType.DAY_TIME_DURATION) {
                    return new DTDur((DTDur)item1, (DTDur)item2, false, info);
                }
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    return new YMDur((YMDur)item1, (YMDur)item2, false, info);
                }
            } else {
                if (type1.instanceOf(AtomType.DATE_TIME)) {
                    return new Dtm((Dtm)item1, 2.dur(info, item2), false, info);
                }
                if (type1 == AtomType.DATE) {
                    return new Dat((Dat)item1, 2.dur(info, item2), false, info);
                }
                if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION) {
                    return new Tim((Tim)item1, (DTDur)item2, false);
                }
            }
            throw this.typeError(info, item1, item2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            ANum num;
            AtomType type = 2.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && (num = (ANum)expr2).dbl() == 0.0) {
                return new Cast(info, expr1, type.seqType()).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return type == AtomType.DECIMAL ? Dec.ZERO : (type == AtomType.INTEGER ? Itr.ZERO : null);
            }
            if (expr2 instanceof Unary) {
                Unary unry = (Unary)expr2;
                return new Arith(info, expr1, unry.expr, ADD).optimize(cc);
            }
            if (expr1 instanceof Arith) {
                Expr expr;
                Arith arth = (Arith)expr1;
                if (arth.calc == MULTIPLY && arth.exprs[0].equals(expr2) && (expr = arth.exprs[1]) instanceof Itr) {
                    Itr itr = (Itr)expr;
                    return new Arith(info, arth.exprs[0], (Expr)Itr.get(itr.itr() - 1L), MULTIPLY).optimize(cc);
                }
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1.instanceOf(AtomType.DATE_TIME) && type2.instanceOf(AtomType.DATE_TIME)) {
                return AtomType.DAY_TIME_DURATION;
            }
            if (type1 == type2) {
                if (type1.oneOf(AtomType.DATE, AtomType.TIME, AtomType.DAY_TIME_DURATION)) {
                    return AtomType.DAY_TIME_DURATION;
                }
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    return AtomType.YEAR_MONTH_DURATION;
                }
            }
            if (type1.instanceOf(AtomType.DATE_TIME)) {
                return type1;
            }
            if (type1 == AtomType.DATE) {
                return AtomType.DATE;
            }
            if (type1 == AtomType.TIME && type2 == AtomType.DAY_TIME_DURATION) {
                return AtomType.TIME;
            }
            return 2.numType(type1, type2);
        }

        @Override
        public Calc invert() {
            return ADD;
        }
    }
    ,
    MULTIPLY("*"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            boolean num2 = type2.isNumberOrUntyped();
            if (type1 == AtomType.YEAR_MONTH_DURATION) {
                if (num2) {
                    return new YMDur((Dur)item1, item2.dbl(info), true, info);
                }
            } else if (type2 == AtomType.YEAR_MONTH_DURATION) {
                if (num1) {
                    return new YMDur((Dur)item2, item1.dbl(info), true, info);
                }
            } else if (type1 == AtomType.DAY_TIME_DURATION) {
                if (num2) {
                    return new DTDur((Dur)item1, item2.dbl(info), true, info);
                }
            } else if (type2 == AtomType.DAY_TIME_DURATION) {
                if (num1) {
                    return new DTDur((Dur)item2, item1.dbl(info), true, info);
                }
            } else if (num1 && num2) {
                return switch (3.numType(type1, type2)) {
                    case AtomType.INTEGER -> CalcOpt.multiplyInt(item1, item2, info);
                    case AtomType.DOUBLE -> CalcOpt.multiplyDbl(item1, item2, info);
                    case AtomType.FLOAT -> CalcOpt.multiplyFlt(item1, item2, info);
                    default -> CalcOpt.multiplyDec(item1, item2, info);
                };
            }
            throw this.typeError(info, item1, item2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            ANum num;
            AtomType type = 3.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum) {
                num = (ANum)expr2;
                double dbl2 = num.dbl();
                if (dbl2 == 1.0) {
                    return new Cast(info, expr1, type.seqType()).optimize(cc);
                }
                if (dbl2 == 0.0) {
                    return type == AtomType.DECIMAL ? Dec.ZERO : (type == AtomType.INTEGER ? Itr.ZERO : null);
                }
            }
            if (type == AtomType.DOUBLE) {
                Expr expr;
                if (expr1.equals(expr2)) {
                    return cc.function(Function._MATH_POW, info, expr1, Dbl.get(2.0));
                }
                if (Function._MATH_POW.is(expr1) && expr1.arg(0).equals(expr2) && (expr = expr1.arg(1)) instanceof ANum) {
                    num = (ANum)expr;
                    return cc.function(Function._MATH_POW, info, expr1.arg(0), Dbl.get(num.dbl() + 1.0));
                }
            }
            if (expr2 instanceof Arith) {
                Arith arth = (Arith)expr2;
                if (arth.calc == DIVIDE && arth.exprs[0] instanceof Itr && arth.exprs[1].equals(expr1)) {
                    return new Cast(info, arth.exprs[0], type.seqType()).optimize(cc);
                }
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1 == AtomType.YEAR_MONTH_DURATION || type2 == AtomType.YEAR_MONTH_DURATION) {
                return AtomType.YEAR_MONTH_DURATION;
            }
            if (type1 == AtomType.DAY_TIME_DURATION || type2 == AtomType.DAY_TIME_DURATION) {
                return AtomType.DAY_TIME_DURATION;
            }
            return 3.numType(type1, type2);
        }

        @Override
        public Calc invert() {
            return DIVIDE;
        }
    }
    ,
    DIVIDE("div"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            boolean num2 = type2.isNumberOrUntyped();
            if (type1 == type2) {
                if (type1 == AtomType.YEAR_MONTH_DURATION) {
                    BigDecimal bd = BigDecimal.valueOf(((YMDur)item2).ymd());
                    if (bd.doubleValue() == 0.0) {
                        throw QueryError.DIVZERO_X.get(info, item1);
                    }
                    return Dec.get(BigDecimal.valueOf(((YMDur)item1).ymd()).divide(bd, MathContext.DECIMAL64));
                }
                if (type1 == AtomType.DAY_TIME_DURATION) {
                    BigDecimal bd = ((DTDur)item2).dtd();
                    if (bd.doubleValue() == 0.0) {
                        throw QueryError.DIVZERO_X.get(info, item1);
                    }
                    return Dec.get(((DTDur)item1).dtd().divide(bd, MathContext.DECIMAL64));
                }
            }
            if (type1 == AtomType.YEAR_MONTH_DURATION) {
                if (num2) {
                    return new YMDur((Dur)item1, item2.dbl(info), false, info);
                }
            } else if (type1 == AtomType.DAY_TIME_DURATION) {
                if (num2) {
                    return new DTDur((Dur)item1, item2.dbl(info), false, info);
                }
            } else if (num1 && num2) {
                return switch (4.numType(type1, type2)) {
                    case AtomType.DOUBLE -> CalcOpt.divideDbl(item1, item2, info);
                    case AtomType.FLOAT -> CalcOpt.divideFlt(item1, item2, info);
                    default -> CalcOpt.divideDec(item1, item2, info);
                };
            }
            throw this.typeError(info, item1, item2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            Expr expr;
            ANum num;
            AtomType type = 4.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && (num = (ANum)expr2).dbl() == 1.0) {
                return new Cast(info, expr1, type.seqType()).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return type == AtomType.DECIMAL ? Dec.ONE : (type == AtomType.INTEGER ? Itr.ONE : null);
            }
            if (Function._MATH_POW.is(expr1) && expr1.arg(0).equals(expr2) && (expr = expr1.arg(1)) instanceof ANum) {
                num = (ANum)expr;
                return cc.function(Function._MATH_POW, info, expr1.arg(0), Dbl.get(num.dbl() - 1.0));
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            if (type1 == type2 && type1.oneOf(AtomType.YEAR_MONTH_DURATION, AtomType.DAY_TIME_DURATION)) {
                return AtomType.DECIMAL;
            }
            if (type1 == AtomType.YEAR_MONTH_DURATION) {
                return AtomType.YEAR_MONTH_DURATION;
            }
            if (type1 == AtomType.DAY_TIME_DURATION) {
                return AtomType.DAY_TIME_DURATION;
            }
            AtomType type = 4.numType(type1, type2);
            return type == AtomType.INTEGER ? AtomType.DECIMAL : type;
        }

        @Override
        public Calc invert() {
            return MULTIPLY;
        }
    }
    ,
    DIVIDEINT("idiv"){

        @Override
        public Itr eval(Item item1, Item item2, InputInfo info) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            boolean num2 = type2.isNumberOrUntyped();
            if (num1 && num2) {
                return switch (5.numType(type1, type2)) {
                    case AtomType.INTEGER -> CalcOpt.divideIntInt(item1, item2, info);
                    case AtomType.DOUBLE -> CalcOpt.divideIntDbl(item1, item2, info);
                    case AtomType.FLOAT -> CalcOpt.divideIntFlt(item1, item2, info);
                    default -> CalcOpt.divideIntDec(item1, item2, info);
                };
            }
            throw this.typeError(info, item1, item2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) throws QueryException {
            ANum num;
            AtomType type = 5.numType(expr1.seqType().type, expr2.seqType().type);
            if (expr2 instanceof ANum && (num = (ANum)expr2).dbl() == 1.0) {
                return new Cast(info, expr1, Types.INTEGER_O).optimize(cc);
            }
            if (expr1.equals(expr2)) {
                return type.oneOf(AtomType.DECIMAL, AtomType.INTEGER) ? Itr.ONE : null;
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            return AtomType.INTEGER;
        }

        @Override
        public Calc invert() {
            return null;
        }
    }
    ,
    MODULO("mod"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            boolean num2 = type2.isNumberOrUntyped();
            if (num1 && num2) {
                return switch (6.numType(type1, type2)) {
                    case AtomType.INTEGER -> CalcOpt.moduloInt(item1, item2, info);
                    case AtomType.DOUBLE -> CalcOpt.moduloDbl(item1, item2, info);
                    case AtomType.FLOAT -> CalcOpt.moduloFlt(item1, item2, info);
                    default -> CalcOpt.moduloDec(item1, item2, info);
                };
            }
            throw this.typeError(info, item1, item2);
        }

        @Override
        public Expr optimize(Expr expr1, Expr expr2, InputInfo info, CompileContext cc) {
            AtomType type = 6.numType(expr1.seqType().type, expr2.seqType().type);
            if (type == AtomType.INTEGER && expr2 == Itr.ONE) {
                return Itr.ZERO;
            }
            return null;
        }

        @Override
        public Type type(Type type1, Type type2) {
            AtomType type = 6.numType(type1, type2);
            return type == AtomType.ANY_ATOMIC_TYPE ? AtomType.NUMERIC : type;
        }

        @Override
        public Calc invert() {
            return null;
        }
    };

    final String name;

    private Calc(String name) {
        this.name = name;
    }

    public abstract Item eval(Item var1, Item var2, InputInfo var3) throws QueryException;

    public abstract Expr optimize(Expr var1, Expr var2, InputInfo var3, CompileContext var4) throws QueryException;

    public abstract Type type(Type var1, Type var2);

    public abstract Calc invert();

    public boolean oneOf(Calc ... candidates) {
        return Enums.oneOf((Enum)this, (Enum[])candidates);
    }

    public static AtomType numType(Type type1, Type type2) {
        if (!type1.isNumberOrUntyped() || !type2.isNumberOrUntyped()) {
            return AtomType.ANY_ATOMIC_TYPE;
        }
        if (type1 == AtomType.DOUBLE || type2 == AtomType.DOUBLE || type1.isUntyped() || type2.isUntyped()) {
            return AtomType.DOUBLE;
        }
        if (type1 == AtomType.FLOAT || type2 == AtomType.FLOAT) {
            return AtomType.FLOAT;
        }
        if (type1 == AtomType.DECIMAL || type2 == AtomType.DECIMAL) {
            return AtomType.DECIMAL;
        }
        if (type1 == AtomType.NUMERIC || type2 == AtomType.NUMERIC) {
            return AtomType.NUMERIC;
        }
        return AtomType.INTEGER;
    }

    final QueryException typeError(InputInfo info, Item item1, Item item2) {
        return QueryError.CALCTYPE_X_X_X_X_X.get(info, item1.type, item2.type, item1, this.name, item2);
    }

    static Dur dur(InputInfo info, Item item) throws QueryException {
        Type type = item.type;
        if (item instanceof Dur) {
            Dur dur = (Dur)item;
            if (type == AtomType.DURATION) {
                throw QueryError.NOSUBDUR_X.get(info, item);
            }
            return dur;
        }
        throw QueryError.NODUR_X_X.get(info, type, item);
    }

    public String toString() {
        return this.name;
    }
}

