/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.util.HashMap;
import java.util.Map;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.util.InputInfo;

public final class DBRename
extends DBUpdate {
    private final HashMap<String, String> map = new HashMap();

    public DBRename(Data data, String src, String trg, InputInfo info) {
        super(UpdateType.DBRENAME, data, info);
        this.map.put(src, trg);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() {
        this.map.forEach((source, target) -> {
            IOFile src = new IOFile((String)source);
            IOFile trg = new IOFile((String)target);
            if (src.exists()) {
                if (trg.exists()) {
                    trg.delete();
                } else {
                    trg.parent().md();
                }
                src.rename(trg);
            }
        });
    }

    @Override
    public void merge(Update update) throws QueryException {
        for (Map.Entry<String, String> e : ((DBRename)update).map.entrySet()) {
            String src = e.getKey();
            if (this.map.containsKey(src)) {
                throw QueryError.UPPATHREN_X.get(this.info, src);
            }
            this.map.put(src, e.getValue());
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

