/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnRound;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Uln
extends ANum {
    public static final BigDecimal MAXULN = BigDecimal.valueOf(Long.MAX_VALUE).multiply(Dec.BD_2).add(BigDecimal.ONE);
    private final BigInteger value;

    public Uln(BigInteger value) {
        super(AtomType.UNSIGNED_LONG);
        this.value = value;
    }

    @Override
    public byte[] string() {
        return Token.token(this.value.toString());
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value.signum() != 0;
    }

    @Override
    public long itr() {
        return this.value.longValue();
    }

    @Override
    public float flt() {
        return this.value.floatValue();
    }

    @Override
    public double dbl() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return new BigDecimal(this.value);
    }

    @Override
    public ANum abs() {
        long l = this.itr();
        return l >= 0L ? this : Itr.get(-l);
    }

    @Override
    public Uln ceiling() {
        return this;
    }

    @Override
    public Uln floor() {
        return this;
    }

    @Override
    public ANum round(int prec, FnRound.RoundMode mode) {
        if (this.value.equals(BigInteger.ZERO) || prec >= 0) {
            return this;
        }
        BigInteger v = Dec.round(new BigDecimal(this.value), prec, mode).toBigInteger();
        return v.equals(this.value) ? this : new Uln(v);
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        int n;
        if (item instanceof Uln) {
            Uln uln = (Uln)item;
            n = this.value.compareTo(uln.value);
        } else {
            n = this.compare(item, transitive, ii);
        }
        return n;
    }

    @Override
    public Object toJava() {
        return new BigInteger(this.value.toString());
    }

    @Override
    public int hashCode() {
        return this.value.bitLength() < 32 ? this.value.intValue() : super.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Uln)) return false;
        Uln uln = (Uln)obj;
        if (this.value.compareTo(uln.value) != 0) return false;
        return true;
    }
}

