/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.BaseXServer;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryProcessor;
import org.basex.query.value.node.DBNode;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.options.Option;

public final class HTTPContext {
    private StaticOptions soptions;
    private Context context;
    private IOException exception;
    private BaseXServer server;
    private IOFile initFile;
    private Map<String, ?> initParams;
    private static volatile HTTPContext instance;

    private HTTPContext() {
    }

    public static HTTPContext get() {
        if (instance == null) {
            instance = new HTTPContext();
        }
        return instance;
    }

    public Context context() {
        return this.context;
    }

    public Map<String, ?> initParams() {
        if (this.initParams == null && this.context != null && this.initFile != null) {
            try {
                String query = "{ .//*:init-param ! { *:param-name: data(*:param-value) } }";
                try (QueryProcessor qp = new QueryProcessor("{ .//*:init-param ! { *:param-name: data(*:param-value) } }", this.context).context((Object)new DBNode((IO)this.initFile));){
                    this.initParams = (HashMap)qp.value().toJava();
                }
            }
            catch (Exception ex) {
                Util.debug((Throwable)ex);
            }
        }
        if (this.initParams == null) {
            this.initParams = new HashMap();
        }
        return this.initParams;
    }

    public void init(StaticOptions sopts, IOFile webXml) {
        this.soptions = sopts;
        this.initFile = webXml;
    }

    public synchronized void init(ServletContext sc) throws IOException {
        if (this.context != null) {
            return;
        }
        String webapp = sc.getRealPath("/");
        System.setProperty("org.basex.path", webapp);
        Prop.put((Option)StaticOptions.WEBPATH, (String)webapp);
        for (String name : Collections.list(sc.getInitParameterNames())) {
            String value = sc.getInitParameter(name);
            if (name.startsWith("org.basex.") && name.endsWith("path") && !new File(value).isAbsolute()) {
                Util.debugln((Object)(name.toUpperCase(Locale.ENGLISH) + ": " + value), (Object[])new Object[0]);
                value = new IOFile(webapp, value).path();
            }
            Prop.put((String)name, (String)value);
        }
        if (this.soptions == null) {
            this.soptions = new StaticOptions(false);
        } else {
            this.soptions.setSystem();
        }
        this.context = new Context(this.soptions);
        if (!this.soptions.get(StaticOptions.HTTPLOCAL).booleanValue()) {
            try {
                this.server = new BaseXServer(this.context, new String[]{"-D"});
            }
            catch (IOException ex) {
                this.exception = ex;
                throw ex;
            }
        }
        this.context.initServer();
    }

    public synchronized IOException exception() {
        return this.exception;
    }

    public synchronized void close() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (IOException ex) {
                Util.stack((Throwable)ex);
            }
            this.server = null;
        }
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
    }
}

