/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.inject.Provider;
import org.eclipse.sisu.EagerSingleton;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.Typed;
import org.eclipse.sisu.inject.Legacy;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.space.MediationListener;
import org.eclipse.sisu.space.QualifiedTypeListener;
import org.eclipse.sisu.space.WildcardKey;

public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL;
    private static final boolean HAS_JSR299_TYPED;
    private final Binder rootBinder;
    private MediationListener mediationListener;
    private Object currentSource;
    private Binder binder;

    static {
        boolean hasJsr299Typed;
        try {
            hasJsr299Typed = javax.enterprise.inject.Typed.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasJsr299Typed = false;
        }
        HAS_JSR299_TYPED = hasJsr299Typed;
        OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    }

    public QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Class qualifiedType, Object source2) {
        if (this.currentSource != source2) {
            if (source2 != null) {
                this.binder = this.rootBinder.withSource(source2);
                this.currentSource = source2;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if (!TypeArguments.isConcrete(qualifiedType)) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (org.sonatype.inject.Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerLegacyMediator(qualifiedType);
        } else if (Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (module != null) {
            this.binder.install(module);
        }
    }

    private void registerMediator(Class<Mediator> mediatorType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(mediatorType, Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = this.newInstance(mediatorType);
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void registerLegacyMediator(Class<org.sonatype.inject.Mediator> mediatorType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(mediatorType, org.sonatype.inject.Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = Legacy.adapt(this.newInstance(mediatorType));
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void mediate(Key watchedKey, Mediator mediator, Class watcherType) {
        if (this.mediationListener == null) {
            this.mediationListener = new MediationListener(this.binder);
            this.binder.bindListener(this.mediationListener, this.mediationListener);
        }
        this.mediationListener.mediate(watchedKey, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(providerType, Provider.class);
        if (args.length != 1) {
            this.binder.addError(providerType + " has wrong number of type arguments", new Object[0]);
        } else {
            this.binder.bind(providerType).in(Scopes.SINGLETON);
            Named bindingName = QualifiedTypeBinder.getBindingName(providerType);
            Class<?>[] types = QualifiedTypeBinder.getBindingTypes(providerType);
            Key<?> key2 = QualifiedTypeBinder.getBindingKey(args[0], bindingName);
            ScopedBindingBuilder sbb = this.binder.bind(key2).toProvider(providerType);
            if (QualifiedTypeBinder.isEagerSingleton(providerType)) {
                sbb.asEagerSingleton();
            } else if (QualifiedTypeBinder.isSingleton(providerType)) {
                sbb.in(Scopes.SINGLETON);
            }
            if (types != null) {
                Class<?>[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> bindingType = classArray[n2];
                    this.binder.bind(key2.ofType(bindingType)).to(key2);
                    ++n2;
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder<?> sbb = this.binder.bind(qualifiedType);
        if (QualifiedTypeBinder.isEagerSingleton(qualifiedType)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (types != null) {
            Key<Object> key2 = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, bindingName);
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> bindingType = classArray[n2];
                this.binder.bind(key2.ofType(bindingType)).to(qualifiedType);
                ++n2;
            }
        } else {
            this.binder.bind(WildcardKey.get(qualifiedType, bindingName)).to(qualifiedType);
        }
    }

    private <T> T newInstance(Class<T> type2) {
        try {
            final Constructor<T> ctor = type2.getDeclaredConstructor(new Class[0]);
            if (!ctor.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ctor.setAccessible(true);
                        return null;
                    }
                });
            }
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e2) {
            Throwable cause = e2 instanceof InvocationTargetException ? e2.getCause() : e2;
            this.binder.addError("Error creating instance of: " + type2 + " reason: " + cause, new Object[0]);
            return null;
        }
        catch (LinkageError e3) {
            this.binder.addError("Error creating instance of: " + type2 + " reason: " + e3, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] resolveTypeArguments(Class<?> type2, Class<?> superType) {
        return TypeArguments.get(TypeLiteral.get(type2).getSupertype(superType));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return qualifier != null ? Key.get(bindingType, qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        javax.inject.Named jsr330 = qualifiedType.getAnnotation(javax.inject.Named.class);
        if (jsr330 != null) {
            try {
                String name2 = jsr330.value();
                if (name2.length() > 0) {
                    return "default".equals(name2) ? null : Names.named(name2);
                }
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {}
        } else {
            String name3;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (guice != null && (name3 = guice.value()).length() > 0) {
                return "default".equals(name3) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("Default")) {
            return null;
        }
        return Names.named(qualifiedType.getName());
    }

    private static Class<?>[] getBindingTypes(Class<?> clazz) {
        Class<?> c = clazz;
        while (c != null && c != Object.class) {
            Object typed;
            if (HAS_JSR299_TYPED && (typed = c.getAnnotation(javax.enterprise.inject.Typed.class)) != null) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            typed = c.getAnnotation(Typed.class);
            if (typed != null) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private static boolean isSingleton(Class<?> type2) {
        return type2.isAnnotationPresent(javax.inject.Singleton.class) || type2.isAnnotationPresent(Singleton.class);
    }

    private static boolean isEagerSingleton(Class<?> type2) {
        return type2.isAnnotationPresent(EagerSingleton.class) || type2.isAnnotationPresent(org.sonatype.inject.EagerSingleton.class);
    }

    private static <T> Key<T> watchedKey(TypeLiteral<T> type2, Class qualifierType) {
        return qualifierType.isAnnotation() ? Key.get(type2, (Class<? extends Annotation>)qualifierType) : Key.get(type2);
    }
}

