/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;

public final class ConflictMarker
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node2, DependencyGraphTransformationContext context) throws RepositoryException {
        Objects.requireNonNull(node2, "node cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        Map stats = (Map)context.get(TransformationContextKeys.STATS);
        long time1 = System.nanoTime();
        IdentityHashMap<DependencyNode, Object> nodes2 = new IdentityHashMap<DependencyNode, Object>(1024);
        HashMap<Object, ConflictGroup> groups = new HashMap<Object, ConflictGroup>(1024);
        this.analyze(node2, nodes2, groups, new int[]{0});
        long time2 = System.nanoTime();
        Map<DependencyNode, Object> conflictIds = this.mark(nodes2.keySet(), groups);
        context.put(TransformationContextKeys.CONFLICT_IDS, conflictIds);
        if (stats != null) {
            long time3 = System.nanoTime();
            stats.put("ConflictMarker.analyzeTime", time2 - time1);
            stats.put("ConflictMarker.markTime", time3 - time2);
            stats.put("ConflictMarker.nodeCount", nodes2.size());
        }
        return node2;
    }

    private void analyze(DependencyNode node2, Map<DependencyNode, Object> nodes2, Map<Object, ConflictGroup> groups, int[] counter) {
        if (nodes2.put(node2, Boolean.TRUE) != null) {
            return;
        }
        Set<Object> keys2 = this.getKeys(node2);
        if (!keys2.isEmpty()) {
            ConflictGroup group2 = null;
            boolean fixMappings = false;
            for (Object key2 : keys2) {
                Set<Object> newKeys;
                ConflictGroup g2 = groups.get(key2);
                if (group2 == g2) continue;
                if (group2 == null) {
                    newKeys = this.merge(g2.keys, keys2);
                    if (newKeys == g2.keys) {
                        group2 = g2;
                        break;
                    }
                    int n = counter[0];
                    counter[0] = n + 1;
                    group2 = new ConflictGroup(newKeys, n);
                    fixMappings = true;
                    continue;
                }
                if (g2 == null) {
                    fixMappings = true;
                    continue;
                }
                newKeys = this.merge(g2.keys, group2.keys);
                if (newKeys == g2.keys) {
                    group2 = g2;
                    fixMappings = false;
                    break;
                }
                if (newKeys == group2.keys) continue;
                int n = counter[0];
                counter[0] = n + 1;
                group2 = new ConflictGroup(newKeys, n);
                fixMappings = true;
            }
            if (group2 == null) {
                int n = counter[0];
                counter[0] = n + 1;
                group2 = new ConflictGroup(keys2, n);
                fixMappings = true;
            }
            if (fixMappings) {
                for (Object key2 : group2.keys) {
                    groups.put(key2, group2);
                }
            }
        }
        for (DependencyNode child : node2.getChildren()) {
            this.analyze(child, nodes2, groups, counter);
        }
    }

    private Set<Object> merge(Set<Object> keys1, Set<Object> keys2) {
        int size2;
        int size1 = keys1.size();
        if (size1 < (size2 = keys2.size())) {
            if (keys2.containsAll(keys1)) {
                return keys2;
            }
        } else if (keys1.containsAll(keys2)) {
            return keys1;
        }
        HashSet<Object> keys3 = new HashSet<Object>();
        keys3.addAll(keys1);
        keys3.addAll(keys2);
        return keys3;
    }

    private Set<Object> getKeys(DependencyNode node2) {
        Set<Object> keys2;
        Dependency dependency = node2.getDependency();
        if (dependency == null) {
            Set keys22 = Collections.emptySet();
        } else {
            Object key2 = ConflictMarker.toKey(dependency.getArtifact());
            if (node2.getRelocations().isEmpty() && node2.getAliases().isEmpty()) {
                keys2 = Collections.singleton(key2);
            } else {
                keys2 = new HashSet<Object>();
                keys2.add(key2);
                for (Artifact artifact : node2.getRelocations()) {
                    key2 = ConflictMarker.toKey(artifact);
                    keys2.add(key2);
                }
                for (Artifact artifact : node2.getAliases()) {
                    key2 = ConflictMarker.toKey(artifact);
                    keys2.add(key2);
                }
            }
        }
        return keys2;
    }

    private Map<DependencyNode, Object> mark(Collection<DependencyNode> nodes2, Map<Object, ConflictGroup> groups) {
        IdentityHashMap<DependencyNode, Object> conflictIds = new IdentityHashMap<DependencyNode, Object>(nodes2.size() + 1);
        for (DependencyNode node2 : nodes2) {
            Dependency dependency = node2.getDependency();
            if (dependency == null) continue;
            Object key2 = ConflictMarker.toKey(dependency.getArtifact());
            conflictIds.put(node2, groups.get((Object)key2).index);
        }
        return conflictIds;
    }

    private static Object toKey(Artifact artifact) {
        return new Key(artifact);
    }

    static class Key {
        private final Artifact artifact;

        Key(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            int hash2 = 17;
            hash2 = hash2 * 31 + this.artifact.getArtifactId().hashCode();
            hash2 = hash2 * 31 + this.artifact.getGroupId().hashCode();
            hash2 = hash2 * 31 + this.artifact.getClassifier().hashCode();
            hash2 = hash2 * 31 + this.artifact.getExtension().hashCode();
            return hash2;
        }

        public String toString() {
            return this.artifact.getGroupId() + ':' + this.artifact.getArtifactId() + ':' + this.artifact.getClassifier() + ':' + this.artifact.getExtension();
        }
    }

    static class ConflictGroup {
        final Set<Object> keys;
        final int index;

        ConflictGroup(Set<Object> keys2, int index2) {
            this.keys = keys2;
            this.index = index2;
        }

        public String toString() {
            return String.valueOf(this.keys);
        }
    }
}

