/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class ChunkedWriter
extends FilterWriter {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private final int chunkSize;

    public ChunkedWriter(Writer writer2) {
        this(writer2, 8192);
    }

    public ChunkedWriter(Writer writer2, int chunkSize) {
        super(writer2);
        if (chunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = chunkSize;
    }

    @Override
    public void write(char[] data2, int srcOffset, int length) throws IOException {
        int bytes2 = length;
        int dstOffset = srcOffset;
        while (bytes2 > 0) {
            int chunk2 = Math.min(bytes2, this.chunkSize);
            this.out.write(data2, dstOffset, chunk2);
            bytes2 -= chunk2;
            dstOffset += chunk2;
        }
    }
}

