/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.maven.shared.utils.xml.Xpp3Dom;
import org.apache.maven.shared.utils.xml.pull.XmlPullParserException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Xpp3DomBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static Xpp3Dom build(@WillClose @Nonnull Reader reader2) throws XmlPullParserException {
        return Xpp3DomBuilder.build(reader2, true);
    }

    public static Xpp3Dom build(@WillClose InputStream is2, @Nonnull String encoding2) throws XmlPullParserException {
        return Xpp3DomBuilder.build(is2, encoding2, true);
    }

    public static Xpp3Dom build(@WillClose InputStream is2, @Nonnull String encoding2, boolean trim2) throws XmlPullParserException {
        try {
            InputStreamReader reader2 = new InputStreamReader(is2, encoding2);
            return Xpp3DomBuilder.build(reader2, trim2);
        }
        catch (UnsupportedEncodingException e2) {
            throw new XmlPullParserException(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Xpp3Dom build(@WillClose Reader in, boolean trim2) throws XmlPullParserException {
        try (Reader reader2 = in;){
            DocHandler docHandler = Xpp3DomBuilder.parseSax(new InputSource(reader2), trim2);
            reader2.close();
            Xpp3Dom xpp3Dom = docHandler.result;
            return xpp3Dom;
        }
        catch (IOException e2) {
            throw new XmlPullParserException(e2);
        }
    }

    private static DocHandler parseSax(@Nonnull InputSource inputSource, boolean trim2) throws XmlPullParserException {
        try {
            DocHandler ch = new DocHandler(trim2);
            XMLReader parser = Xpp3DomBuilder.createXmlReader();
            parser.setContentHandler(ch);
            parser.parse(inputSource);
            return ch;
        }
        catch (IOException e2) {
            throw new XmlPullParserException(e2);
        }
        catch (SAXException e3) {
            throw new XmlPullParserException(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLReader createXmlReader() throws SAXException {
        XMLReader comSunXmlReader = Xpp3DomBuilder.instantiate("com.sun.org.apache.xerces.internal.parsers.SAXParser");
        if (comSunXmlReader != null) {
            return comSunXmlReader;
        }
        String key2 = "org.xml.sax.driver";
        String oldParser = System.getProperty(key2);
        System.clearProperty(key2);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            return xMLReader;
        }
        finally {
            if (oldParser != null) {
                System.setProperty(key2, oldParser);
            }
        }
    }

    private static XMLReader instantiate(String s2) {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(s2);
            return (XMLReader)aClass.newInstance();
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
        catch (InstantiationException e3) {
            return null;
        }
        catch (IllegalAccessException e4) {
            return null;
        }
    }

    private static class DocHandler
    extends DefaultHandler {
        private final List<Xpp3Dom> elemStack = new ArrayList<Xpp3Dom>();
        private final List<StringBuilder> values = new ArrayList<StringBuilder>();
        Xpp3Dom result = null;
        private final boolean trim;
        private boolean spacePreserve = false;

        DocHandler(boolean trim2) {
            this.trim = trim2;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.spacePreserve = false;
            Xpp3Dom child = new Xpp3Dom(localName);
            this.attachToParent(child);
            this.pushOnStack(child);
            this.values.add(new StringBuilder());
            int size = attributes.getLength();
            for (int i = 0; i < size; ++i) {
                String name2 = attributes.getQName(i);
                String value = attributes.getValue(i);
                child.setAttribute(name2, value);
                this.spacePreserve = this.spacePreserve || "xml:space".equals(name2) && "preserve".equals(value);
            }
        }

        private boolean pushOnStack(Xpp3Dom child) {
            return this.elemStack.add(child);
        }

        private void attachToParent(Xpp3Dom child) {
            int depth = this.elemStack.size();
            if (depth > 0) {
                this.elemStack.get(depth - 1).addChild(child);
            }
        }

        private Xpp3Dom pop() {
            int depth = this.elemStack.size() - 1;
            return this.elemStack.remove(depth);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            int depth = this.elemStack.size() - 1;
            Xpp3Dom element2 = this.pop();
            StringBuilder accumulatedValue = this.values.remove(depth);
            if (element2.getChildCount() == 0) {
                if (accumulatedValue == null) {
                    element2.setValue("");
                } else {
                    element2.setValue(((Object)accumulatedValue).toString());
                }
            }
            if (depth == 0) {
                this.result = element2;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String text = new String(ch, start, length);
            this.appendToTopValue(this.trim && !this.spacePreserve ? text.trim() : text);
        }

        private void appendToTopValue(String toAppend) {
            StringBuilder stringBuilder = this.values.get(this.values.size() - 1);
            stringBuilder.append(toAppend);
        }
    }
}

