/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { MCPServerConfig, GeminiCLIExtension, ExtensionInstallMetadata } from '@google/gemini-cli-core';
import { SettingScope } from '../config/settings.js';
import type { LoadExtensionContext } from './extensions/variableSchema.js';
import { ExtensionEnablementManager } from './extensions/extensionEnablement.js';
import type { ConfirmationRequest } from '../ui/types.js';
export declare const EXTENSIONS_DIRECTORY_NAME: string;
export declare const EXTENSIONS_CONFIG_FILENAME = "gemini-extension.json";
export declare const INSTALL_METADATA_FILENAME = ".gemini-extension-install.json";
export declare const INSTALL_WARNING_MESSAGE = "**The extension you are about to install may have been created by a third-party developer and sourced from a public repository. Google does not vet, endorse, or guarantee the functionality or security of extensions. Please carefully inspect any extension and its source code before installing to understand the permissions it requires and the actions it may perform.**";
/**
 * Extension definition as written to disk in gemini-extension.json files.
 * This should *not* be referenced outside of the logic for reading files.
 * If information is required for manipulating extensions (load, unload, update)
 * outside of the loading process that data needs to be stored on the
 * GeminiCLIExtension class defined in Core.
 */
interface ExtensionConfig {
    name: string;
    version: string;
    mcpServers?: Record<string, MCPServerConfig>;
    contextFileName?: string | string[];
    excludeTools?: string[];
}
export interface ExtensionUpdateInfo {
    name: string;
    originalVersion: string;
    updatedVersion: string;
}
export declare class ExtensionStorage {
    private readonly extensionName;
    constructor(extensionName: string);
    getExtensionDir(): string;
    getConfigPath(): string;
    static getUserExtensionsDir(): string;
    static createTmpDir(): Promise<string>;
}
export declare function copyExtension(source: string, destination: string): Promise<void>;
export declare function loadExtensions(extensionEnablementManager: ExtensionEnablementManager, workspaceDir?: string): GeminiCLIExtension[];
export declare function loadExtension(context: LoadExtensionContext): GeminiCLIExtension | null;
export declare function loadExtensionByName(name: string, extensionEnablementManager: ExtensionEnablementManager, workspaceDir?: string): GeminiCLIExtension | null;
export declare function loadInstallMetadata(extensionDir: string): ExtensionInstallMetadata | undefined;
/**
 * Requests consent from the user to perform an action, by reading a Y/n
 * character from stdin.
 *
 * This should not be called from interactive mode as it will break the CLI.
 *
 * @param consentDescription The description of the thing they will be consenting to.
 * @returns boolean, whether they consented or not.
 */
export declare function requestConsentNonInteractive(consentDescription: string): Promise<boolean>;
/**
 * Requests consent from the user to perform an action, in interactive mode.
 *
 * This should not be called from non-interactive mode as it will not work.
 *
 * @param consentDescription The description of the thing they will be consenting to.
 * @param setExtensionUpdateConfirmationRequest A function to actually add a prompt to the UI.
 * @returns boolean, whether they consented or not.
 */
export declare function requestConsentInteractive(consentDescription: string, addExtensionUpdateConfirmationRequest: (value: ConfirmationRequest) => void): Promise<boolean>;
export declare function hashValue(value: string): string;
export declare function installOrUpdateExtension(installMetadata: ExtensionInstallMetadata, requestConsent: (consent: string) => Promise<boolean>, cwd?: string, previousExtensionConfig?: ExtensionConfig): Promise<string>;
export declare function validateName(name: string): void;
export declare function loadExtensionConfig(context: LoadExtensionContext): ExtensionConfig;
export declare function uninstallExtension(extensionIdentifier: string, isUpdate: boolean, cwd?: string): Promise<void>;
export declare function toOutputString(extension: GeminiCLIExtension, workspaceDir: string): string;
export declare function disableExtension(name: string, scope: SettingScope, extensionEnablementManager: ExtensionEnablementManager, cwd?: string): void;
export declare function enableExtension(name: string, scope: SettingScope, extensionEnablementManager: ExtensionEnablementManager, cwd?: string): void;
export {};
