/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type Settings, SettingScope } from './settings.js';
import { type ExtensionConfig } from './extension.js';
import { type ExtensionInstallMetadata, type GeminiCLIExtension } from '@google/gemini-cli-core';
import { type ExtensionSetting } from './extensions/extensionSettings.js';
import type { ExtensionEvents, ExtensionLoader } from '@google/gemini-cli-core/src/utils/extensionLoader.js';
import { EventEmitter } from 'node:events';
interface ExtensionManagerParams {
    enabledExtensionOverrides?: string[];
    settings: Settings;
    requestConsent: (consent: string) => Promise<boolean>;
    requestSetting: ((setting: ExtensionSetting) => Promise<string>) | null;
    workspaceDir: string;
}
/**
 * Actual implementation of an ExtensionLoader.
 *
 * You must call `loadExtensions` prior to calling other methods on this class.
 */
export declare class ExtensionManager implements ExtensionLoader {
    private extensionEnablementManager;
    private settings;
    private requestConsent;
    private requestSetting;
    private telemetryConfig;
    private workspaceDir;
    private loadedExtensions;
    private eventEmitter;
    constructor(options: ExtensionManagerParams);
    setRequestConsent(requestConsent: (consent: string) => Promise<boolean>): void;
    setRequestSetting(requestSetting?: (setting: ExtensionSetting) => Promise<string>): void;
    getExtensions(): GeminiCLIExtension[];
    extensionEvents(): EventEmitter<ExtensionEvents>;
    installOrUpdateExtension(installMetadata: ExtensionInstallMetadata, previousExtensionConfig?: ExtensionConfig): Promise<GeminiCLIExtension>;
    uninstallExtension(extensionIdentifier: string, isUpdate: boolean): Promise<void>;
    loadExtensions(): Promise<GeminiCLIExtension[]>;
    private loadExtension;
    private unloadExtension;
    loadExtensionConfig(extensionDir: string): ExtensionConfig;
    toOutputString(extension: GeminiCLIExtension): string;
    disableExtension(name: string, scope: SettingScope): Promise<void>;
    enableExtension(name: string, scope: SettingScope): Promise<void>;
}
export declare function copyExtension(source: string, destination: string): Promise<void>;
export declare function getExtensionId(config: ExtensionConfig, installMetadata?: ExtensionInstallMetadata): string;
export declare function hashValue(value: string): string;
export {};
