#include <framecpp_config.h>

#include "framecpp/FrHistory.hh"

#include "framecppc/FrameH.h"
#include "framecppc/FrHistory.h"

#include "FrameCInternal.hh"
#include "FrHistoryInternal.hh"

using FrameC::Set;

namespace FrameC
{
  template<>
  const char* Pointers::
  Name< POINTER_FR_HISTORY >( )
  {
    return "FrHistory";
  }
  
}

fr_history_t*
FrameCFrHistoryAlloc( FrameCError** Error,
		      const char* Name,
		      fr_history_time_t Time,
		      const char* Comment )
{
  Set( Error );

  FrameC::FrHistory*			retval = (FrameC::FrHistory*)NULL;
  std::unique_ptr< FrameC::FrHistory >	tmp;

  try
  {
    tmp.reset( new FrameC::FrHistory( Name, Time, Comment ) );
  }
  catch( const std::exception& Exception )
  {
    Set( Error, FRAMEC_ERRNO_FR_HISTORY_ALLOC_ERROR, Exception.what( ) );
    tmp.reset( (FrameC::FrHistory*)NULL );
  }

  if ( tmp.get( ) )
  {
    FrameC::Handle::Deposit( tmp.get( ) );
    retval = tmp.release( );
  }
  return( reinterpret_cast< fr_history_t* >( retval ) );
}

int
FrameCFrHistoryFree( FrameCError** Error,
		     fr_history_t *History )
{
  int	retval = true;

  Set( Error );

  FrameC::Handle::Free( Error, History, FrameC::POINTER_FR_HISTORY, FRAMEC_ERRNO_FR_HISTORY_FREE_ERROR );

  if ( *Error )
  {
    retval = false;
  }

  return retval;
}


namespace FrameC
{
  FrHistory::
  FrHistory( )
    : Handle( POINTER_FR_HISTORY )
  {
  }

  FrHistory::
  FrHistory( const char* Name,
	     time_t Time,
	     const char* Comment )
    : Handle( POINTER_FR_HISTORY )
  {
    m_data.reset( new FrameCPP::FrHistory( Name,
					   Time,
					   Comment ) );
  }
}
