#ifndef FRAME_CPP__C_INTERFACE__FRAME_H_INTERNAL_HH
#define FRAME_CPP__C_INTERFACE__FRAME_H_INTERNAL_HH

#include "ldastoolsal/SharedPtr.hh"

namespace FrameC
{
  struct FrameH
    : public Handle
  {
    typedef FrameCPP::FrameH			data_core_t;
    typedef LDASTools::AL::SharedPtr< data_core_t >	data_t;

    data_t	m_data;

    FrameH( );

    FrameH( const char* Name,
	    frame_h_gtime_t Start,
	    frame_h_dt_t Dt,
	    frame_h_frame_t FrameNumber );

    ~FrameH( );

    inline
    void Read( ::fr_file_t* Stream,
	       ::frame_h_frame_t Offset )
    {
      FrameCPP::IFrameStream*	fs( StreamAsInput( Stream ) );

      m_data = fs->ReadFrameH( Offset, 0 );
      
      if ( ! m_data )
      {
	std::ostringstream	msg;

	msg << "Failed to read frame " << Offset << " from the stream.";

	throw std::runtime_error( msg.str( ) );
      }
    }

    inline
    void ReadNext( ::fr_file_t* Stream )
    {
      FrameCPP::IFrameStream*	fs( StreamAsInput( Stream ) );

      m_data = fs->ReadNextFrame( );
      
      if ( ! m_data )
      {
	std::ostringstream	msg;

	msg << "Failed to read the next frame from the stream.";

	throw std::runtime_error( msg.str( ) );
      }
    }
  };


  template<>
  inline pointer_type
  PointerType( FrameH* Value )
  {
    return POINTER_FRAME_H;
  }

  template<>
  const char* Pointers::
  Name< POINTER_FRAME_H >( )
  {
    return "FrameH";
  }
}

#endif /* FRAME_CPP__C_INTERFACE__FRAME_H_INTERNAL_HH */
