#ifndef FrameCPP__Common__FrSH_HH
#define FrameCPP__Common__FrSH_HH

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/StringStream.hh"

#include <iostream>

namespace FrameCPP
{
  namespace Common
  {
    class Description;
    class IStringStream;

    //-------------------------------------------------------------------
    /// \brief Interface definition for an FrSH structure
    class FrSH
      : public FrameSpec::Object
    {
    public:
      typedef INT_2U cmn_classId_type;
      typedef IStringStream assign_stream_type;

      FrSH( );

      //-----------------------------------------------------------------
      /// \todo
      ///     See about storing name in this class and eliminate the
      ///     need for this virtual method.
      //-----------------------------------------------------------------
      virtual const std::string& name( ) const = 0;

      virtual cmn_classId_type classId( ) const = 0;

      //-----------------------------------------------------------------
      /// \brief Assign the contents of the instance
      ///
      /// \param[in] Stream
      ///     An input stream from which to read information for
      ///     the instance.
      //-----------------------------------------------------------------
      virtual void assign( assign_stream_type& Stream ) = 0;
    };

    inline FrSH::
    FrSH( )
      : FrameSpec::Object( FrameSpec::Info::FSI_FR_SH,
			   (Description*)NULL )
    {
    }
  } // namespace - Common
} // namespace - FrameCPP

#endif /* FrameCPP__Common__FrSH_HH */
