#ifndef FRAMECPP__COMMON__MD5SUM_HH
#define FRAMECPP__COMMON__MD5SUM_HH

#if ! defined(SWIGIMPORTED)
#include <iostream>
#include <stdexcept>
#endif /* ! defined(SWIGIMPORTED) */

#include "ldastoolsal/types.hh"
#include "ldastoolsal/SharedPtr.hh"

namespace FrameCPP
{
  namespace Common
  {
    class MD5Sum;
  }
}

namespace std
{
  std::ostream& operator<<( std::ostream& Stream,
			    const FrameCPP::Common::MD5Sum& Data );
}

namespace FrameCPP
{
  namespace Common
  {
    class MD5Sum
    {
    public:
      typedef void*	data_type;
      typedef INT_4U	size_type;
      typedef CHAR_U*	md_type;

      MD5Sum( );

      MD5Sum( const MD5Sum& Source );

      std::ostream& DumpIntermediate( std::ostream& Stream ) const;

      void Finalize( ) const;

      bool Finalized( ) const;

      void Reset( );

      void Update( const data_type Data, size_type Length );

      md_type Value( ) const;

      std::ostream& operator<<( std::ostream& Stream );

      MD5Sum& operator=( const MD5Sum& MD5 );

      bool operator==( const MD5Sum& RHS ) const;

      bool operator!=( const MD5Sum& RHS ) const;
    private:
      friend std::ostream& std::operator<<( std::ostream& stream,
					    const MD5Sum& Data );

      struct _state_type;

      typedef LDASTools::AL::SharedPtr< _state_type > state_type;

      mutable state_type	state;
    };

    inline bool MD5Sum::
    operator!=( const MD5Sum& RHS ) const
    {
      return ! operator==( RHS );
    }
  } // namespace - Common
} // namespace - FrameCPP

#endif /* FRAMECPP__COMMON__MD5SUM_HH */
