#ifndef FrameCPP__VERSION_3__FrSE_HH
#define FrameCPP__VERSION_3__FrSE_HH

#include "framecpp/Common/FrameSpec.hh"

#include "framecpp/Version3/STRING.hh"

namespace FrameCPP
{
  namespace Version_3
  {
    class FrSE
      : public Common::FrameSpec::Object
    {
    public:

      using Common::FrameSpec::Object::Create;

      static const char* StructName( );

      //: Default constructor
      FrSE( );

      //: constructor
      FrSE( const std::string& Name,
	    const std::string& ClassId,
	    const std::string& Comment = "" );

      //: Desctructor
      virtual ~FrSE( );

      //: Return the number of bytes needed to write this object
      INT_8U Bytes( const Common::StreamBase& Stream ) const;

      virtual const char* ObjectStructName( ) const;

      //: Return class of object
      std::string GetClass( ) const;

      //: Return comment of object
      std::string GetComment( ) const;

      //: Return name of object
      std::string GetName( ) const;

      //: Create a new instance of the object based on the input stream
      virtual FrSE* Create( istream_type& Stream ) const;

      //: Create a new instance of the object based on an instance
      virtual FrSE* Clone( ) const;

      //: Write the structure to the stream
      virtual void Write( ostream_type& Stream ) const;

      /// \brief comparison operator
      bool operator==( const FrSE& RHS ) const;

      /// \brief comparison operator
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

    protected:
      /// \brief Down grade an object
      virtual demote_ret_type demote( INT_2U Target,
				      demote_arg_type Obj,
				      istream_type* Stream ) const;

      /// \brief Upgrade an object
      virtual promote_ret_type promote( INT_2U Target,
					promote_arg_type Obj,
					istream_type* Stream ) const;

    private:
      static const Common::FrameSpec::Info::frame_object_types s_object_id
      = Common::FrameSpec::Info::FSI_FR_SE;
      
      struct image_t
      {
	STRING	name;
	STRING	classId;
	STRING	comment;
      } m_data;

      FrSE( istream_type& Stream );

    }; // class - FrSE

    inline const char* FrSE::
    StructName( )
    {
      static const char* const class_name( "FrSE" );
      return class_name;
    }

    inline std::string FrSE::
    GetClass( ) const
    {
      return m_data.classId;
    }

    inline std::string FrSE::
    GetComment( ) const
    {
      return m_data.comment;
    }

  } // namespace - Version_3
} // namespace - FrameCPP
#endif /* FrameCPP__VERSION_3__FrSE_HH */
