/* -*- mode: c++; c-basic-offset: 2; -*- */
#ifndef FRAMECPP__VERSION_6__FR_VECT_ICC
#define FRAMECPP__VERSION_6__FR_VECT_ICC

template< class T > INT_2U get_type( );

template< >
inline INT_2U get_type< CHAR >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_C;
}

template< >
inline INT_2U get_type< INT_2S >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_2S;
}

template< >
inline INT_2U get_type< REAL_8 >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_8R;
}

template< >
inline INT_2U get_type< REAL_4 >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_4R;
}

template< >
inline INT_2U get_type< INT_4S >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_4S;
}

template< >
inline INT_2U get_type< INT_8S >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_8S;
}

template< >
inline INT_2U get_type< COMPLEX_8 >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_8C;
}

template< >
inline INT_2U get_type< COMPLEX_16 >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_16C;
}

template< >
inline INT_2U get_type< FrameCPP::Version_6::STRING >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_STRING;
}

template< >
inline INT_2U get_type< INT_2U >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_2U;
}

template< >
inline INT_2U get_type< INT_4U >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_4U;
}
template< >
inline INT_2U get_type< INT_8U >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_8U;
}

template< >
inline INT_2U get_type< CHAR_U >( )
{
  return FrameCPP::Version_6::FrVect::FR_VECT_1U;
}

//=======================================================================
//=======================================================================

template< class T >
FrameCPP::Version_6::FrVect::
FrVect( const std::string& name, INT_4U nDim,
	const Dimension* dims,
	const T* data, const std::string& unitY )
  : FrameSpec::Object( s_object_id, StructDescription( ) ),
    m_data( name, get_type< T >(), BYTE_ORDER_HOST, nDim, dims, unitY )
{
#ifdef MEM_ALLOCATE
  MEM_ALLOCATE( );
#endif /* MEM_ALLOCATE */
  m_data.compress = NONE;
  data_copy( reinterpret_cast< data_const_pointer_type >( data ), m_data.nBytes );
}

template< class T >
FrameCPP::Version_6::FrVect::
FrVect( const std::string& name, INT_4U nDim,
	const Dimension* dims,
	T* data, const std::string& unitY )
  : FrameSpec::Object( s_object_id, StructDescription( ) ),
    m_data( name, get_type< T >(), BYTE_ORDER_HOST, nDim, dims, unitY )
{
#ifdef MEM_ALLOCATE
  MEM_ALLOCATE( );
#endif /* MEM_ALLOCATE */
  m_data.compress = NONE;

  data_copy( reinterpret_cast< data_pointer_type >( data ), m_data.nBytes );
}

inline void FrameCPP::Version_6::FrVect::
data_alloc( nBytes_type NBytes )
{
  m_data.data.reset( new CHAR_U[ NBytes ] );
  m_data.nBytes = NBytes;
}

#endif /* FRAMECPP__VERSION_6__FR_VECT_ICC */
