#ifndef FrameCPP_VERSION_8_FrTOCSimData_HH
#define FrameCPP_VERSION_8_FrTOCSimData_HH

#if ! defined(SWIGIMPORTED)
#include "framecpp/Version7/FrTOCSimData.hh"

#include "framecpp/Version8/STRING.hh"
#endif /* ! defined(SWIGIMPORTED) */

namespace FrameCPP
{
#if ! defined(SWIGIMPORTED)
  namespace Common
  {
    class TOCInfo;
  }
#endif /* ! defined(SWIGIMPORTED) */

  namespace Version_8
  {
    //===================================================================
    /// \brief Indexed elements of the FrSimData structure.
    //===================================================================
    class FrTOCSimData
    {
    public:
      typedef INT_4U	nsim_type;
      typedef STRING	name_type;
      typedef INT_8U	position_type;

      typedef std::vector< position_type > sim_info_type;
      typedef std::map< name_type, sim_info_type >
      MapSim_type;

      //-----------------------------------------------------------------
      /// \brief Default constructor.
      //-----------------------------------------------------------------
      FrTOCSimData( );

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      Common::FrameSpec::size_type
      Bytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Return all channels
      ///
      /// \return
      ///     Constant container to the indexed FrSimData elements.
      //-----------------------------------------------------------------
      const MapSim_type& GetSim( ) const;

      //-----------------------------------------------------------------
      /// \brief Return the indexed data for a named channel.
      ///
      /// \param[in] Name
      ///     The name of the channel.
      ///
      /// \return
      ///     Constant iterator to the indexed FrSimData element.
      //-----------------------------------------------------------------
      MapSim_type::const_iterator GetSim( const std::string& Name ) const;

      //-----------------------------------------------------------------
      /// \brief Return the indexed data for a named channel.
      ///
      /// \param[in] index
      ///     The numeric offset of the channel.
      ///
      /// \return
      ///     Constant iterator to the indexed FrSimData element.
      //-----------------------------------------------------------------
      MapSim_type::const_iterator GetSim( INT_4U index ) const;

      //-----------------------------------------------------------------
      /// \brief Gather TOC info for FrSimData being written.
      ///
      /// \param[in] Info
      ///     Information
      ///
      /// \param[in] FrameOffset
      ///     The frame offset of the frame being written.
      ///     The frame offsets start at 0 (zero).
      ///
      /// \param[in] Position
      ///     The byte offset from the start of the file
      ///     where the structure is written.
      //-----------------------------------------------------------------
      void QuerySim( const Common::TOCInfo& Info,
		     INT_4U FrameOffset,
		     INT_8U Position );

#if ! defined(SWIG)
      //-----------------------------------------------------------------
      /// \brief asignment operator
      ///
      /// \param[in] Source
      ///     The source to be copied.
      //-----------------------------------------------------------------
      const FrTOCSimData& operator=( const Previous::FrTOCSimData& Source );
#endif /* ! defined(SWIG) */

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrTOCAdcData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrTOCSimData& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \param[out] Desc
      ///     Storage for the description of the structure.
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      template< typename SE >
      static void Description( Common::Description& Desc );

    protected:
      typedef std::vector< name_type >	key_container_type;
      key_container_type	m_keys;
      MapSim_type		m_info;

      //-----------------------------------------------------------------
      /// \brief Stream constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      ///
      /// \param[in] FrameCount
      ///     The frame offset.
      //-----------------------------------------------------------------
      FrTOCSimData( Common::IStream& Stream, INT_4U FrameCount );

      //-----------------------------------------------------------------
      /// \brief Iterate over contents.
      ///
      /// \param[in] Info
      ///     Specifies the type of information to be searched.
      ///
      /// \param[in] Action
      ///     Action to be taken for each piece of information found.
      //-----------------------------------------------------------------
      void forEach( Common::FrTOC::query_info_type Info,
		    Common::FrTOC::FunctionBase& Action ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      void write( Common::OStream& Stream ) const;
    };

    inline Common::FrameSpec::size_type FrTOCSimData::
    Bytes( const Common::StreamBase& Stream ) const
    {
      Common::FrameSpec::size_type 
	retval = sizeof( nsim_type );
      if ( m_info.size( ) )
      {
	retval
	  += ( m_info.size( )
	       * ( sizeof( position_type )
		   * m_info.begin( )->second.size( )
		   ) );
      }
      for ( MapSim_type::const_iterator
	      cur = m_info.begin( ),
	      last = m_info.end( );
	    cur != last;
	    ++cur )
      {
	retval += cur->first.Bytes( );
      }
      return retval;
    }

    template< typename SE >
    void FrTOCSimData::
    Description( Common::Description& Desc )
    {
      Desc( SE( "nSim", "INT_4U",
		"Number of unique FrSimData names in file." ) );
      Desc( SE( "nameSim", "STRING[nSim]", "Array of FrSimData names" ) );
      Desc( SE( "positionSim", "INT_8U[nSim][nFrame]",
		"Array of lists of FrSimData offset positions, in bytes,"
		" from beginning of file (size of nFrame*nSim)"
		) );
    }

    inline const FrTOCSimData::MapSim_type& FrTOCSimData::
    GetSim( ) const
    {
      return m_info;
    }

  } // namespace - Version_8
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_8_FrTOCSimData_HH */
