/* -*- mode: c++ -*- */
#ifndef FR_SIM_DATA_I
#define FR_SIM_DATA_I

%module frameCPP

%{
#include "ldastoolsal/types.hh"
#include "framecpp/FrSimData.hh"

using namespace FrameCPP;
%}

%import "framecpp/FrameCPP.hh"
%import "framecpp/FrSimData.hh"

%import "ldastoolsal/SharedPtr.i"
%import "Container.i"

%SharedPtr(FrSimData)

%feature("autodoc",
"""
FrSimData (Simulated Data) implementation of the frame specification.

  Attributes:

    name           Name of simulated data.
    comment        Comment.
    sampleRate     Data Acquisition rate, samples/s.
    timeOffset     Offset of 1st sample relative to the frame start
                   time (seconds). Must be positive and smaller
                   than the frame length.
    fShift         fShift is the frequency (in Hz) in the origional
                   data that corresponds to 0 Hz in the heterodyned
                   series.
    phase          Phase (in radian) of heterodyning signal at
                   start of dataset.
    data           Data vector.
""" ) FrSimData;

class FrSimData
{
public:
#define DECLARE(X,Y)				\
  typedef FR_SIM_DATA_##Y##_TYPE X##_type

  DECLARE(sampleRate,SAMPLERATE);
  DECLARE(timeOffset,TIMEOFFSET);
  DECLARE(fShift,FSHIFT);
  DECLARE(phase,PHASE);

#undef DECLARE

#ifdef SWIGPYTHON
  typedef Container< FrVect > data_type;
#else
  using FrameCPP::FrSimData::data_type;
#endif

  FrSimData( );
  FrSimData( const std::string& Name,
	     const std::string& Comment,
	     const sampleRate_type SampleRate, 
	     const fShift_type FShift,
	     const phase_type Phase,
	     const timeOffset_type TimeOffset );

  const std::string& GetName() const; 
  const std::string& GetComment( ) const;
  sampleRate_type GetSampleRate( ) const;
  timeOffset_type GetTimeOffset( ) const;
  fShift_type GetFShift( ) const;
  phase_type GetPhase( ) const;

  void SetSampleRate( sampleRate_type Value );
  void SetTimeOffset( timeOffset_type  Value );

  %extend {
    void
    AppendData( FrVect& Data )
    {
      self->RefData( ).append( Data );
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    size_t RefDataSize( );
    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    // LDASTools::AL::SharedPtr< FrVect > RefData( size_t Offset );
    data_type& RefData( );
  }

  LDAS_PROPERTY_READ_ONLY("name",GetName)
  LDAS_PROPERTY_READ_ONLY("comment",GetComment)
  LDAS_PROPERTY_READ_WRITE("sampleRate",GetSampleRate,SetSampleRate)
  LDAS_PROPERTY_READ_WRITE("timeOffset",GetTimeOffset,SetTimeOffset)
  LDAS_PROPERTY_READ_ONLY("fShift",GetFShift)
  LDAS_PROPERTY_READ_ONLY("phase",GetPhase)
  LDAS_PROPERTY_READ_ONLY("data",RefData)
};

#if ! SWIGIMPORTED
%{
  FrSimData::data_type&
  FrSimData_RefData( FrSimData* Data )
  {
    if ( Data->RefData( ).size( ) <= 0 )
    {
      throw std::length_error( "FrSimData no data available" );
    }
    return Data->RefData( );
  }

  size_t
  FrSimData_RefDataSize( FrSimData* Data )
  {
    return Data->RefData( ).size( );
  }
%}

CONTAINER_WRAP(FrSimData,FrSimData)
#endif /* SWIGIMPORTED */

#endif /* FR_SIM_DATA_I */
