#! /usr/bin/env python
#------------------------------------------------------------------------
#------------------------------------------------------------------------
import ctypes
from optparse import OptionParser
import frameCPP

COMPRESSION_STRING = {
    frameCPP.FrVect.BIGENDIAN_RAW : 'RAW (bigendian)',
    frameCPP.FrVect.LITTLEENDIAN_RAW : 'RAW (littleendian)',
    frameCPP.FrVect.BIGENDIAN_GZIP : 'GZIP (bigendian)',
    frameCPP.FrVect.LITTLEENDIAN_GZIP : 'GZIP (littleendian)',
    frameCPP.FrVect.BIGENDIAN_DIFF_GZIP : 'DIFF_GZIP (bigendian)',
    frameCPP.FrVect.LITTLEENDIAN_DIFF_GZIP : 'DIFF_GZIP (littleendian)',
    frameCPP.FrVect.BIGENDIAN_ZERO_SUPPRESS_WORD_2 : 'ZERO_SUPPRESS_WORD_2 (bigendian)',
    frameCPP.FrVect.LITTLEENDIAN_ZERO_SUPPRESS_WORD_2 : 'ZERO_SUPPRESS_WORD_2 (littleendian)',
    frameCPP.FrVect.BIGENDIAN_ZERO_SUPPRESS_WORD_4 : 'ZERO_SUPPRESS_WORD_4 (bigendian)',
    frameCPP.FrVect.LITTLEENDIAN_ZERO_SUPPRESS_WORD_4 : 'ZERO_SUPPRESS_WORD_4 (littleendian)',
    frameCPP.FrVect.BIGENDIAN_ZERO_SUPPRESS_WORD_8 : 'ZERO_SUPPRESS_WORD_8 (bigendian)',
    frameCPP.FrVect.LITTLEENDIAN_ZERO_SUPPRESS_WORD_8 : 'ZERO_SUPPRESS_WORD_8 (littleendian)'
    }

DATA_TYPE_STRING = {
    frameCPP.FrVect.FR_VECT_C : 'FR_VECT_C',
    frameCPP.FrVect.FR_VECT_1U : 'FR_VECT_1U',
    frameCPP.FrVect.FR_VECT_2S : 'FR_VECT_2S',
    frameCPP.FrVect.FR_VECT_2U : 'FR_VECT_2U',
    frameCPP.FrVect.FR_VECT_4S : 'FR_VECT_4S',
    frameCPP.FrVect.FR_VECT_4U : 'FR_VECT_4U',
    frameCPP.FrVect.FR_VECT_8S : 'FR_VECT_8S',
    frameCPP.FrVect.FR_VECT_8U : 'FR_VECT_8U',
    frameCPP.FrVect.FR_VECT_4R : 'FR_VECT_4R',
    frameCPP.FrVect.FR_VECT_8R : 'FR_VECT_8R',
    frameCPP.FrVect.FR_VECT_8C : 'FR_VECT_8C',
    frameCPP.FrVect.FR_VECT_16C : 'FR_VECT_16C'
    }

def DumpChannels( Stream, TOC, FrameOffset ):
    DumpChannelsFrAdcData( Stream, TOC, FrameOffset )
    DumpChannelsFrProcData( Stream, TOC, FrameOffset )

def DumpChannelsFrAdcData( Stream, TOC, FrameOffset ):
    #--------------------------------------------------------------------
    # ADC channels
    #--------------------------------------------------------------------
    toc_adc = TOC.GetADC( );
    for k, v in toc_adc.iteritems( ):
        print ( "FrAdcData: %s channelID: %d groupID: %d"
                ) % (
                k, v[0], v[1]
                )
        adc = Stream.ReadFrAdcData( FrameOffset, k );
        print ( "\tname: %s\n"
                + "\tcomment: %s\n"
                + "\tchannelGroup: %d\n"
                + "\tchannelNumber: %d\n"
                + "\tnBits: %d\n"
                + "\tbias: %g\n"
                + "\tslope: %g\n"
                + "\tsampleRate: %g\n" 
                + "\ttimeOffset: %g\n"
                + "\tfShift: %g\n"
                + "\tphase: %g\n"
                + "\tdataValid: %d"
                ) % (
                adc.name,
                adc.comment,
                adc.channelGroup,
                adc.channelNumber,
                adc.nBits,
                adc.bias,
                adc.slope,
                adc.sampleRate,
                adc.timeOffset,
                adc.fShift,
                adc.phase,
                adc.dataValid
                )
        #------------------------------------------------------------
        # Dump the vector information.
        #------------------------------------------------------------
        for i in range( 0, adc.RefDataSize( ) ):
            DumpFrVect( adc.RefData( i ) )

def DumpChannelsFrProcData( Stream, TOC, FrameOffset ):
    #--------------------------------------------------------------------
    # FrProcData channels
    #--------------------------------------------------------------------
    toc_proc = TOC.GetProc( );
    for i in range( toc_proc.Size( ) ):
        print ( "FrProcData: %s" ) % ( toc_proc.Name( i ) )
        proc = Stream.ReadFrProcData( FrameOffset, toc_proc.Name( i ) );
        print ( "\tname: %s\n"
                + "\tcomment: %s\n"
                + "\ttype: %d\n"
                + "\tsubType: %d\n"
                + "\ttimeOffset: %g\n"
                + "\ttRange: %g\n"
                + "\tfShift: %g\n"
                + "\tphase: %g\n"
                + "\tfRange: %g\n"
                + "\tBW: %g"
                ) % (
                proc.name,
                proc.comment,
                proc.type,
                proc.subType,
                proc.timeOffset,
                proc.tRange,
                proc.fShift,
                proc.phase,
                proc.fRange,
                proc.BW
                )
        #----------------------------------------------------------------
        # Dump the vector information.
        #----------------------------------------------------------------
        #for i in range( 0, proc.RefDataSize( ) ):
        #    DumpFrVect( proc.RefData( i ) )
        print ("DEBUG: length of FrVect Set: %d\n" ) % ( len( proc.RefData( ) ) )
        for i in proc.RefData( ):
            DumpFrVect( i )

def DumpFrVect( Vector ):
    dim_str = ""
    #for i in range( 0, Vector.GetNDim( ) ):
    #    dim = Vector.GetDim( i )
    #    dim_str += ( "\t\t\tnx: %d"
    #                 + " dx: %g"
    #                 + " startX: %g"
    #                 + " unitX: %s\n"
    #                 ) % (
    #        dim.nx,
    #        dim.dx,
    #        dim.startX,
    #        dim.unitX )
    print ( "\t\tname: %s\n"
            + "\t\tcompress: %s\n"
            + "\t\ttype: %s\n"
            + "\t\tnData: %d\n"
            + "\t\tnBytes: %d\n"
            + "\t\tnDim: %d\n"
            + "%s\t\tunitY: %s"
          ) % (
            Vector.name,
            COMPRESSION_STRING[ Vector.compress ],
            DATA_TYPE_STRING[ Vector.type ],
            Vector.nData,
            Vector.nBytes,
            Vector.nDim,
            dim_str,
            Vector.unitY
          )
    print "\t\tData:",
    data = Vector.GetDataUncompressed( )
    data_type = Vector.GetType( )
    step = 1;
    if data_type == frameCPP.FrVect.FR_VECT_C:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_byte ) )
        format = "%d"
    elif data_type == frameCPP.FrVect.FR_VECT_1U:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_ubyte ) )
        format = "%d"
    elif data_type == frameCPP.FrVect.FR_VECT_2S:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_short ) )
        format = "%d"
    elif data_type == frameCPP.FrVect.FR_VECT_2U:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_ushort ) )
        format = "%d"
    elif data_type == frameCPP.FrVect.FR_VECT_4S:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_int ) )
        format = "%d"
    elif data_type == frameCPP.FrVect.FR_VECT_4U:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_uint ) )
        format = "%d"
    elif data_type == frameCPP.FrVect.FR_VECT_8S:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_longlong ) )
        format = "%ld"
    elif data_type == frameCPP.FrVect.FR_VECT_8U:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_ulonglong ) )
        format = "%ld"
    elif data_type == frameCPP.FrVect.FR_VECT_4R:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_float ) )
        format = "%g"
    elif data_type == frameCPP.FrVect.FR_VECT_8R:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_double ) )
        format = "%g"
    elif data_type == frameCPP.FrVect.FR_VECT_8C:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_float ) )
        format = "(%g, %g)"
        step = 2
    elif data_type == frameCPP.FrVect.FR_VECT_16C:
        datap = ctypes.cast( data.__long__( ), ctypes.POINTER( ctypes.c_double ) )
        format = "(%g, %g)"
        step = 2
    else:
        print ( " WARNING: Currently don't support printing of %s"
               ) % ( DATA_TYPE_STRING[ Vector.GetType( ) ] )
        return
    #
    elipse = "";
    last = Vector.GetNData( )
    if ( last > 10):
        last = 10
        elipse = " ..."
    last = last * step;
    if ( step == 2 ):
        # Printing of complex numbers
        for i in range(0, last, step ):
            print ( " " + format ) % ( datap[i], datap[i+1] ),
    else:
        # Printing of non-complex numbers
        for i in range(0, last, step ):
            print ( " " + format ) % ( datap[i] ),
    print( "%s\n" ) % elipse
    
def ProcessFile( Filename ):
  print "Filename: %s" % Filename
  fs = frameCPP.IFrameFStream( Filename )
  print "There are %d frame(s)." % fs.GetNumberOfFrames( )
  toc = fs.GetTOC( );
  #----------------------------------------------------------------------
  # GTimeS
  #----------------------------------------------------------------------
  print "GTimeS: ",
  for s in toc.GTimeS:
      print ( " %d" ) % ( s ),
  print
  #----------------------------------------------------------------------
  # GTimeN
  #----------------------------------------------------------------------
  print "GTimeN: ",
  for s in toc.GTimeN:
      print ( " %09d" ) % ( s ),
  print
  #----------------------------------------------------------------------
  # Detector information
  #----------------------------------------------------------------------
  dn = toc.GetNameDetector( );
  print "There are %d detectors" % len( dn )
  if len( dn ) > 0:
    for name in dn:
      detector = fs.ReadDetector( name )
      print ( "Detector Info: %s\n"
            + "\tprefix: %s\n"
            + "\tlatitude: %g longitude: %g elevation: %g\n"
            + "\tazimuth: x-arm: %g y-arm: %g\n"
            + "\taltitude: x-arm: %g y-arm: %g\n"
            + "\tmidpoint: x-arm: %g y-arm: %g\n"
            + "\tlocal time: %d"
            ) % (
              name,
              detector.GetPrefix( ),
              detector.GetLatitude( ),
              detector.GetLongitude( ),
              detector.GetElevation( ),
              detector.GetArmXazimuth( ), detector.GetArmYazimuth( ),
              detector.GetArmXaltitude( ), detector.GetArmYaltitude( ),
              detector.GetArmXmidpoint( ), detector.GetArmYmidpoint( ),
              detector.GetLocalTime( )
            )
      # for - end
    # if - end
  #----------------------------------------------------------------------
  # Dump the Channels
  #----------------------------------------------------------------------
  DumpChannels( fs, toc, 0 )
  
      
#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
def dump_objects_main():
    parser = OptionParser( )

    (options, args) = parser.parse_args( )
    for filename in args:
        ProcessFile( filename )

#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
if __name__ == "__main__":
    dump_objects_main( )
