/* -*- mode: C++; c-basic-offset: 2; -*- */
#ifndef FRAME_CPP__TEST__TOC_TCC
#define FRAME_CPP__TEST__TOC_TCC

#include <algorithm>

void dump( const FrameCPP::Common::FrTOC* TOC );

template < typename J >
class printer
{
public:
  typedef void (*func_type)( std::ostream&, const J& );
  inline printer( std::ostream& Stream, func_type Func )
    : m_out( Stream ),
      m_func( Func )
  {
  }
  
  inline virtual ~printer( )
  {
  }

  inline void operator( )( const J& Data )
  {
    m_out << " ";
    (*m_func)( m_out, Data );
  }

protected:
  std::ostream&	m_out;
  func_type		m_func;
};

template< typename T >
void
dump_toc_array( const char* Lead, const T& Element )
{
  std::cout << Lead << ":";

  for ( typename T::const_iterator
	  cur = Element.begin( ),
	  last = Element.end( );
	cur != last;
	++cur )
  {
    std::cout << " " << *cur;
  }
  std::cout << std::endl;
}


template< typename P, typename C >
void
dump_toc_internal_data( const char* Lead,
			const C& Container,
			void (*Func)( std::ostream& Stream, const P& Data ) )
{
  std::cout << Lead << ":";
  std::for_each( Container.begin( ),
		 Container.end( ),
		 printer<P>( std::cout, Func ) );
  std::cout << std::endl;
}

template< typename TOC_TYPE >
inline bool dump_ver_toc( const FrameCPP::Common::FrTOC* TOC )
{
  const TOC_TYPE* t = dynamic_cast< const TOC_TYPE * >( TOC );
  if ( t )
  {
    dump( t );
  }
  return ( t != (const TOC_TYPE*)NULL);
}

#include "toc4.tcc"
#include "toc6.tcc"
#include "toc8.tcc"

inline
void
dump( const FrameCPP::Common::FrTOC* TOC )
{
  if ( TOC )
  {
#if 0
    //-------------------------------------------------------------------
    // This should work, but it currently fails with gcc 4.1.2 with
    // segfault on dynamic_cast<>.
    //-------------------------------------------------------------------
    if ( dump_ver_toc<FrameCPP::Version_8::FrTOC>( TOC ) ) { return; }
    else if ( dump_ver_toc<FrameCPP::Version_6::FrTOC>( TOC ) ) { return; }
    else if ( dump_ver_toc<FrameCPP::Version_4::FrTOC>( TOC ) ) { return; }
#else
    if ( dynamic_cast< const FrameCPP::Version_8::FrTOC* >( TOC ) )
    {
      dump( dynamic_cast< const FrameCPP::Version_8::FrTOC* >( TOC ) );
    }
    else if ( dynamic_cast< const FrameCPP::Version_6::FrTOC* >( TOC ) )
    {
      dump( dynamic_cast< const FrameCPP::Version_6::FrTOC* >( TOC ) );
    }
    else if ( dynamic_cast< const FrameCPP::Version_4::FrTOC* >( TOC ) )
    {
      dump( dynamic_cast< const FrameCPP::Version_4::FrTOC* >( TOC ) );
    }
#endif /* 0 */
    else
    {
      throw std::range_error( "Unknown TOC version" );
    }
  }
  else
  {
    throw
      std::invalid_argument( "TOC pointer was null" );
  }
}

#endif /* FRAME_CPP__TEST__TOC_TCC */
