dnl ---------------------------------------------------------------------
dnl  Check for Support of md5sum calculations
dnl ---------------------------------------------------------------------
AC_DEFUN([AX_LDAS_CHECK_LIB_MD5SUM],
  [ dnl -----------------------------------------------------------------
    dnl  Check for the library first
    dnl -----------------------------------------------------------------
    case `uname` in
    Linux)

      AC_CHECK_LIB(crypto,MD5_Init,
	[ AC_DEFINE(HAVE_MD5_IN_CRYPTO,1,[Defined if have md5 routines in libcrypto])
	  LIBMD5="-lcrypto"
	  AC_SUBST(LIBMD5)
          AC_CHECK_HEADERS([openssl/md5.h])
	],[ AC_CHECK_LIB(md5,MD5Init,
	    [ AC_DEFINE(HAVE_LIBMD5,1,[Defined if have libmd5])
	      LIBMD5="-lmd5"
	      AC_SUBST(LIBMD5)
	      AC_CHECK_HEADERS([md5.h])
	      AC_CHECK_HEADERS([md5global.h])
            ],[AC_MSG_ERROR(Missing md5 support) ])])
      ;;
    *)
      AC_CHECK_HEADERS([CommonCrypto/CommonDigest.h])
      AC_CHECK_LIB(md5,MD5Init,
	[ AC_DEFINE(HAVE_LIBMD5,1,[Defined if have libmd5])
	  LIBMD5="-lmd5"
	  AC_SUBST(LIBMD5)
	  AC_CHECK_HEADERS([md5.h])
	  AC_CHECK_HEADERS([md5global.h])
	],[ AC_CHECK_LIB(crypto,MD5_Init,
	    [ AC_DEFINE(HAVE_MD5_IN_CRYPTO,1,[Defined if have md5 routines in libcrypto])
	      LIBMD5="-lcrypto"
	      AC_SUBST(LIBMD5)
              AC_CHECK_HEADERS([openssl/md5.h])
            ],[AC_MSG_ERROR(Missing md5 support) ])])
      ;;
    esac
  ])
