/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */

#include "framecpp/Common/BaseMemoryBuffer.hh"

namespace FrameCPP
{
  namespace Common
  {
    //===================================================================
    //===================================================================
    //-------------------------------------------------------------------
    /// The default constructor manages a zero length buffer.
    //-------------------------------------------------------------------
    ROMemoryStreamBuf::
    ROMemoryStreamBuf( )
    {
      //----------------------------------------------------------------
      // By default, have it be a zero length buffer. Use of this
      // is to ensure valid memory address. Having all three values
      // being identical, ensures zero length.
      //----------------------------------------------------------------
      setg( reinterpret_cast<char_type*>( this ),
            reinterpret_cast<char_type*>( this ),
            reinterpret_cast<char_type*>( this ) );
    }

    ROMemoryStreamBuf::pos_type ROMemoryStreamBuf::
    ROMemoryStreamBuf::
    position( )
    {
      return ( gptr( ) - eback( ) );
    }

    ROMemoryStreamBuf::pos_type ROMemoryStreamBuf::
    seekpos( pos_type Pos,
             std::ios_base::openmode Which )
    {
      if ( Which == std::ios_base::out )
      {
        return pos_type( -1 );
      }
      if ( Pos > ( egptr( ) - eback( )  ) )
      {
        return pos_type( -1 );
      }
      setg( eback( ), eback( ) + Pos, egptr( ) );
      return position( );
    }

    ROMemoryStreamBuf::pos_type ROMemoryStreamBuf::
    seekoff( off_type Off,
             std::ios_base::seekdir Way,
             std::ios_base::openmode Which )
    {
      if ( Which == std::ios_base::out )
      {
        return pos_type( -1 );
      }
      char_type* beg = eback( );
      char_type* cur = gptr( );
      char_type* end = egptr( );

      if ( Way ==  std::ios_base::beg )
      {
        if ( ( Off < 0 ) || ( ( beg + Off ) > end ) )
        {
          return pos_type( -1 );
        }
        cur = beg + Off;
      }
      else if ( Way == std::ios_base::cur )
      {
        if ( ( ( cur + Off ) < beg )
             || ( ( cur + Off ) > end ) )
        {
          return pos_type( -1 );
        }
        cur += Off;
      }
      else if ( Way == std::ios_base::end )
      {
        if ( ( Off > 0 ) || ( ( end + Off) < beg ) )
        {
          return pos_type( -1 );
        }
        cur = end + Off;
      }
      setg( beg, cur, end );
      return position( );
    }

    
    ROMemoryStreamBuf::buffer_type* ROMemoryStreamBuf::
    setbuf( char_type* S, std::streamsize N )
    {
      setg( S, S, S + N );
      return this;
    }

    //-------------------------------------------------------------------
    //===================================================================
    //===================================================================
    //-------------------------------------------------------------------
    /// The default constructor will initialize all the parts used
    /// in the general case.
    //-------------------------------------------------------------------
    template< typename BT >
    BaseMemoryBufferT< BT >::
    BaseMemoryBufferT( )
    {
    }

    //-------------------------------------------------------------------
    /// Be careful to release all the resources that were created
    /// for this object.
    //-------------------------------------------------------------------
    template< typename BT >
    BaseMemoryBufferT< BT >::
    ~BaseMemoryBufferT( )
    {
    }

    //-------------------------------------------------------------------
    /// Filtering currently is not optimized at the this layer so
    /// this method will always return false.
    //-------------------------------------------------------------------
    template< typename BT >
    bool BaseMemoryBufferT< BT >::
    FilterInternally( ) const
    {
      return false;
    }

    template< typename BT >
    void BaseMemoryBufferT< BT >::
    buffer( )
    {
    }

    //-------------------------------------------------------------------
    /// \brief Perform filtering operations on the stream
    //-------------------------------------------------------------------
    template< typename BT >
    void BaseMemoryBufferT< BT >::
    filter( const char_type* Begin,
            const char_type* End )
    {
    }

    template class BaseMemoryBufferT< ROMemoryStreamBuf >;

  } // namespace Common

} // namespace FrameCPP
