/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */

#include "framecpp/Common/FrameBuffer.hh"

#include <cassert>

using LDASTools::System::ErrnoMessage;

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    // Specialization of Open based on std::filebuf
    //-------------------------------------------------------------------
    template<> FrameBuffer< std::filebuf >*
    FrameBuffer< std::filebuf >::
    close( )
    {
      if ( std::filebuf::close( ) != (std::filebuf*)NULL )
      {
	bufferId( "" );
	return this;
      }
      return (buffer_type*)NULL;
    }

    template<> FrameBuffer< std::filebuf >*
    FrameBuffer< std::filebuf >::
    open( const std::string& Filename, std::ios::openmode Mode )
    {
      std::ostringstream	msg;

      element_type::open( Filename.c_str( ), Mode );
      if ( element_type::is_open( ) == false )
      {
	msg << "Unable to open file: " << Filename
	    << " (" << ErrnoMessage( ) << ")"
	  ;
        std::runtime_error err( msg.str( ).c_str( ) );
	throw err;
      }
      bufferId( Filename );
      return this;
    }

    template<> void
    FrameBuffer< std::filebuf >::
    UseMemoryMappedIO( bool Value )
    {
    }

  } // namespace Common

} // namespace FrameCPP

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    // Specialization of Open based on LDASTools::AL::std::filebuf
    //-------------------------------------------------------------------
    template<> void
    FrameBuffer< LDASTools::AL::filebuf >::
    UseMemoryMappedIO( bool Value )
    {
      LDASTools::AL::filebuf::UseMemoryMappedIO( Value );
    }

    template<> FrameBuffer< LDASTools::AL::filebuf >*
    FrameBuffer< LDASTools::AL::filebuf >::
    close( )
    {
      if ( LDASTools::AL::filebuf::close( ) != (LDASTools::AL::filebuf*)NULL )
      {
	bufferId( "" );
	return this;
      }
      return (buffer_type*)NULL;
    }

    template<> FrameBuffer< LDASTools::AL::filebuf >*
    FrameBuffer< LDASTools::AL::filebuf >::
    open( const std::string& Filename, std::ios::openmode Mode )
    {
      LDASTools::AL::filebuf::open( Filename.c_str( ), Mode );
      if ( LDASTools::AL::filebuf::is_open( ) == false )
      {
	std::ostringstream	msg;

	msg << "Unable to open file: " << Filename
	    << " (" << ErrnoMessage( ) << ")"
	  ;
	throw std::runtime_error( msg.str( ) );
      }
      bufferId( Filename );
      return this;
    }

  } // namespace Common

} // namespace FrameCPP

template class FrameCPP::Common::FrameBuffer< LDASTools::AL::filebuf >;
