#ifndef FrameCPP__COMMON__StreamRefInterface_HH
#define FrameCPP__COMMON__StreamRefInterface_HH

#include "ldastoolsal/types.hh"

#include "framecpp/Common/FrameSpec.hh"

namespace FrameCPP
{
  namespace Common
  {
    class IStringStream;
    class StreamRefInterface
      : public FrameSpec::Object
    {
    public:
      typedef INT_2U class_type;
      typedef INT_4U instance_type;
      typedef INT_8U length_type;

      StreamRefInterface( );

      virtual void assign( IStringStream& Stream ) = 0;

      virtual class_type GetClass( ) const = 0;

      virtual instance_type GetInstance( ) const = 0;

      virtual length_type GetLength( ) const = 0;

      virtual void SetClass( class_type Class ) = 0;

      virtual void SetInstance( instance_type Instance ) = 0;

      virtual void SetLength( length_type Length ) = 0;

      virtual FrameSpec::size_type SizeOf( ) const = 0;

    private:
      static const FrameSpec::Info::frame_object_types s_object_id
      = FrameSpec::Info::FSI_COMMON_ELEMENTS;

    };
  } // namespace - Common
} // namespace - FrameCPP
#endif /* FrameCPP__COMMON__StreamRefInterface_HH */
