#ifndef FrameCPP_VERSION_8_FrTOCSummary_HH
#define FrameCPP_VERSION_8_FrTOCSummary_HH

#include "framecpp/Version4/FrTOCPosition.hh"

#include "framecpp/Version7/FrTOCSummary.hh"

#include "framecpp/Version8/STRING.hh"

namespace FrameCPP
{
  namespace Common
  {
    class TOCInfo;
  }

  namespace Version_8
  {
    //===================================================================
    //===================================================================
    using Version_4::FrTOCPosition;

    //===================================================================
    /// \brief Indexed elements of the FrSummary structure.
    //===================================================================
    class FrTOCSummary
      : public FrTOCPosition
    {
    public:
      typedef FrTOCPosition::n_type		nsummary_type;
      typedef FrTOCPosition::position_type	position_type;

      typedef FrTOCPosition::info_type	summary_info_type;
      typedef FrTOCPosition::Map_type	MapSummary_type;

      //-----------------------------------------------------------------
      /// \brief Default constructor.
      //-----------------------------------------------------------------
      FrTOCSummary( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \param[out] Desc
      ///     Storage for the description of the structure.
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      template< typename SE >
      static void Description( Common::Description& Desc );

      //-----------------------------------------------------------------
      /// \brief Return all summary elements.
      ///
      /// \return
      ///     Constant container to the indexed FrSummary elements.
      //-----------------------------------------------------------------
      const MapSummary_type& GetSummary( ) const;

      //-----------------------------------------------------------------
      /// \brief Return the indexed data for a named summary elemnet.
      ///
      /// \param[in] Name
      ///     The name of the summary elment.
      ///
      /// \return
      ///     Constant iterator to the indexed FrSummary element.
      //-----------------------------------------------------------------
      MapSummary_type::const_iterator GetSummary( const std::string& Name ) const;

      //-----------------------------------------------------------------
      /// \brief Return the indexed data for an index summary element.
      ///
      /// \param[in] index
      ///     The numeric offset of the summary element.
      ///
      /// \return
      ///     Constant iterator to the indexed FrSummary element.
      //-----------------------------------------------------------------
      MapSummary_type::const_iterator GetSummary( INT_4U index ) const;

      //-----------------------------------------------------------------
      /// \brief Gather TOC info for FrSummary being written.
      ///
      /// \param[in] Info
      ///     Information
      ///
      /// \param[in] FrameOffset
      ///     The frame offset of the frame being written.
      ///     The frame offsets start at 0 (zero).
      ///
      /// \param[in] Position
      ///     The byte offset from the start of the file
      ///     where the structure is written.
      //-----------------------------------------------------------------
      void QuerySum( const Common::TOCInfo& Info,
		     INT_4U FrameOffset,
		     INT_8U Position );

      //-----------------------------------------------------------------
      /// \brief asignment operator
      ///
      /// \param[in] Source
      ///     The source to be copied.
      //-----------------------------------------------------------------
      const FrTOCSummary& operator=( const Previous::FrTOCSummary& Source );

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrTOCAdcData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrTOCSummary& RHS ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Stream constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      ///
      /// \param[in] FrameCount
      ///     The frame offset.
      //-----------------------------------------------------------------
      FrTOCSummary( Common::IStream& Stream, INT_4U FrameCount );

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      void write( Common::OStream& Stream ) const;
    };

    inline FrTOCSummary::
    FrTOCSummary( )
    {
    }

    inline FrTOCSummary::
    FrTOCSummary( Common::IStream& Stream, INT_4U FrameCount )
      : FrTOCPosition( Stream, FrameCount )
    {
    }

    template< typename SE >
    void FrTOCSummary::
    Description( Common::Description& Desc )
    {
      Desc( SE( "nSummary", "INT_4U",
		"Number of unique FrSummary names in file." ) );
      Desc( SE( "nameSum", "STRING[nSummary]", "Array of FrSummary names" ) );
      Desc( SE( "positionSum", "INT_8U[nSummary][nFrame]",
		"Array of lists of FrSummary offset positions, in bytes,"
		" from beginning of file (size of nFrame*nSer)"
		) );
    }

    inline const FrTOCSummary::MapSummary_type& FrTOCSummary::
    GetSummary( ) const
    {
      return getInfo( );
    }

    inline FrTOCSummary::MapSummary_type::const_iterator FrTOCSummary::
    GetSummary( const std::string& Channel ) const
    {
      return getInfo( Channel );
    }

    inline FrTOCSummary::MapSummary_type::const_iterator FrTOCSummary::
    GetSummary( INT_4U Channel ) const
    {
      return getInfo( Channel );
    }

    inline void FrTOCSummary::
    write( Common::OStream& Stream ) const
    {
      FrTOCPosition::write( Stream );
    }
  } // namespace - Version_8
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_8_FrTOCSummary_HH */
