#include <framecpp_config.h>

#define ACCESS_FRAME_H_PRIVATE_PARTS 1

#include "ldastoolsal/types.hh"

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/Description.hh"
#include "framecpp/Common/FrameSpec.tcc"
#include "framecpp/Common/Verify.hh"

#include "framecpp/Version8/FrameH.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/FrEndOfFrame.hh"
#include "framecpp/Version8/PTR_STRUCT.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;

#define TRACE_MEMORY 0
#if TRACE_MEMORY
#define MEM_ALLOCATE() std::cerr << "MEMORY: Allocate: " << FrameH::getStaticName() << " " << (void*)this << std::endl;
#define MEM_DELETE() std::cerr << "MEMORY: Delete: " << FrameH::getStaticName() << " " << (void*)this << std::endl;
#else
#define MEM_ALLOCATE()
#define MEM_DELETE()
#endif

#define	LM_DEBUG 0

#if LM_DEBUG
#define	AT() std::cerr << __FILE__ << " " << __LINE__ << std::endl;
#else
#define	AT()
#endif

namespace FrameCPP
{
  namespace Version_8
  {
#if 0
    FrameHNPS::
    FrameHNPS( )
    {
    }

    FrameHNPS::
    FrameHNPS( const FrameHNPS& Source )
      :   m_data( Source.m_data )
    {
    }

    FrameHNPS::
    FrameHNPS( const std::string& name,
	       INT_4S run,
	       INT_4U frame,
	       const GPSTime& time,
	       INT_2U uLeapS,
	       const REAL_8 dt,
	       INT_4U dqual )
      : m_data( name, run, frame, time, uLeapS, dt, dqual )
    {
    }

    void FrameHNPS::
    TOCQuery( int InfoClass, ... ) const
    {
      using Common::TOCInfo;

      va_list	vl;
      va_start( vl, InfoClass );
      while ( InfoClass != TOCInfo::IC_EOQ )
      {
	int data_type = va_arg( vl, int );
	switch( data_type )
	{
	case TOCInfo::DT_INT_2S:
	  {
	    INT_2S*	data = va_arg( vl, INT_2S* );
	    switch( InfoClass )
	    {
	    case TOCInfo::IC_ULEAP_S:
	      *data = GetULeapS( );
	      break;
	    default:
	      goto cleanup;
	      break;
	    }
	  }
	  break;
	case TOCInfo::DT_INT_4S:
	  {
	    INT_4S*	data = va_arg( vl, INT_4S* );
	    switch( InfoClass )
	    {
	    case TOCInfo::IC_RUN:
	      *data = GetRun( );
	      break;
	    default:
	      goto cleanup;
	      break;
	    }
	  }
	  break;
	case TOCInfo::DT_INT_4U:
	  {
	    INT_4U*	data = va_arg( vl, INT_4U* );
	    switch( InfoClass )
	    {
	    case TOCInfo::IC_DATA_QUALITY:
	      *data = GetDataQuality( );
	      break;
	    case TOCInfo::IC_GTIME_S:
	      *data = GetGTime( ).GetSeconds( );
	      break;
	    case TOCInfo::IC_GTIME_N:
	      *data = GetGTime( ).GetNanoseconds( );
	      break;
	    case TOCInfo::IC_FRAME:
	      *data = GetFrame( );
	      break;
	    default:
	      goto cleanup;
	      break;
	    }
	  }
	  break;
	case TOCInfo::DT_REAL_8:
	  {
	    REAL_8* data = va_arg( vl, REAL_8* );
	    switch( InfoClass )
	    {
	    case TOCInfo::IC_DT:
	      *data = GetDt( );
	      break;
	    default:
	      goto cleanup;
	      break;
	    }
	  }
	  break;
	default:
	  // Stop processing
	  goto cleanup;
	}
	InfoClass = va_arg( vl, int );
      }
    cleanup:
      va_end( vl );
    }
#endif /* 0 */

    //=======================================================================
    //
    //=======================================================================
    FrameH::
    FrameH( )
      : object_type( StructDescription( ) )
    {
      MEM_ALLOCATE();
    }

    FrameH::
    FrameH( const FrameH& frame )
      : object_type( StructDescription( ) ),
	FrameHNPS( frame ),
	FrameHPS( frame )
    {
    }

    FrameH::
    FrameH( const std::string& name,
	    INT_4S run,
	    INT_4U frame,
	    const GPSTime& time,
	    INT_2U uLeapS,
	    const REAL_8 dt,
	    INT_4U dqual )
      : object_type( StructDescription( ) ),
	FrameHNPS( name, run, frame, time, uLeapS, dt, dqual )
    {
      MEM_ALLOCATE();
    }

    FrameH::
    FrameH( const FrameHNPS& Source )
      : object_type( StructDescription( ) ),
	FrameHNPS( Source )
    {
    }

    FrameH::
    FrameH( istream_type& Stream )
      : object_type( StructDescription( ) )
    {
      m_data( Stream );
      m_refs( Stream );
    }

    FrameH::
    ~FrameH( )
    {
      MEM_DELETE();
    }

    FrameH* FrameH::
    Clone( ) const
    {
      return new FrameH( *this );
    }

    const char* FrameH::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    const Description* FrameH::
    StructDescription( )
    {
      static Description ret;

      if ( ret.size( ) == 0 )
      {
	ret( FrSH( FrameH::StructName( ),
		   FrameCPP::Common::FrameH::s_object_id,
		   "Frame Header Structure" ) );

	dataDescription< FrSE >( ret );
	refDescription< FrSE >( ret );

	ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
      }

      return &ret;
    }

    void FrameH::
    VerifyObject( Common::Verify& Verifier,
		  Common::IFrameStream& Stream ) const
    {
      if ( Verifier.ValidateMetadata( ) &&
	   ( GetGTime( ).GetLeapSeconds( ) != GetULeapS( ) ) )
      {
	std::ostringstream	msg;

	msg << "Bad ULeapS value ( for gpstime: "
	    << GetGTime( )
	    << " expected: "
	    << GetGTime( ).GetLeapSeconds( )
	    << " read: " << GetULeapS( )
	    << " )"
	  ;
	throw Common::VerifyException( Common::VerifyException::METADATA_INVALID,
				       msg.str( ) );
      }
    }
		  
    bool FrameH::
    operator==( const Common::FrameSpec::Object& RHS ) const
    {
      return compare( *this, RHS );
    }

    void FrameH::
    assign( assign_stream_type& Stream )
    {
      FrameHNPS::assign( Stream );
    }

    FrameH::demote_ret_type FrameH::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      if ( Target >= DATA_FORMAT_VERSION )
      {
	return Obj;
      }
      try
      {
	//-------------------------------------------------------------------
	// Copy non-reference information
	//-------------------------------------------------------------------
	// Do actual down conversion
	LDASTools::AL::SharedPtr< Previous::FrameH >
	  retval( new Previous::FrameH( GetName( ),
					GetRun( ),
					GetFrame( ),
					GetGTime( ),
					GetULeapS( ),
					GetDt( ),
					GetDataQuality( )
					) )
	  ;
	if ( Stream )
	{
	  //-----------------------------------------------------------------
	  // Modify references
	  //-----------------------------------------------------------------
	  Stream->ReplaceRef( retval->RefType( ), RefType( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefUser( ), RefUser( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefDetectSim( ), RefDetectSim( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefDetectProc( ), RefDetectProc( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefHistory( ), RefHistory( ), MAX_REF );
	  Stream->ReplacePtr( retval->AddressOfRawData( ),
			      AddressOfRawData( ),
			      MAX_REF );
	  Stream->ReplaceRef( retval->RefProcData( ), RefProcData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefSimData( ), RefSimData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefEvent( ), RefEvent( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefSimEvent( ), RefSimEvent( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefSummaryData( ), RefSummaryData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefAuxData( ), RefAuxData( ), MAX_REF );
	  Stream->ReplaceRef( retval->RefAuxTable( ), RefAuxTable( ), MAX_REF );

	}
	//-------------------------------------------------------------------
	// Return demoted object
	//-------------------------------------------------------------------
	return retval;
      }
      catch( ... )
      {
      }
      throw
	Unimplemented( "Object* FrameH::demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrameH::promote_ret_type FrameH::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      return Promote( Target, Obj, Stream );
    }

    FrameCPP::cmn_streamsize_type FrameH::
    pBytes( const Common::StreamBase& Stream ) const
    {
      return
	m_data.Bytes( )
	+ m_refs.Bytes( )
	;
    }

    FrameH* FrameH::
    pCreate( istream_type& Stream ) const
    {
      return new FrameH( Stream );
    }

    void FrameH::
    pWrite( ostream_type& Stream ) const
    {
      m_data( Stream );
      m_refs( Stream );
  
      LDASTools::AL::SharedPtr< FrEndOfFrame >
	eof( new FrEndOfFrame( GetRun( ), GetFrame( ) ) );
      Stream.PushSingle( eof );
    }

    void FrameH::
    readSubset( istream_type& Stream, INT_4U ElementMask )
    {
      m_refs.readSubset( Stream, ElementMask );
    }

  } // namespace - Version_8
} // namespace - FrameCPP
