/* -*- mode: c++ -*- */
#ifndef IFRAME_FSTREAM_I
#define IFRAME_FSTREAM_I

%module frameCPP

%{
#include "framecpp/IFrameStream.hh"
%}

%import "framecpp/Common/FrHeader.hh"
%import "FrameH.i"

class IFrameFStream
{
public:
  enum sub_element_type {
    HISTORY = FrameCPP::FrameH::HISTORY,
    DETECT_SIM = FrameCPP::FrameH::DETECT_SIM,
    DETECT_PROC = FrameCPP::FrameH::DETECT_PROC,
    AUX_DATA = FrameCPP::FrameH::AUX_DATA,
    AUX_TABLE = FrameCPP::FrameH::AUX_TABLE,
    TYPE = FrameCPP::FrameH::TYPE,
    USER = FrameCPP::FrameH::USER
  };

  typedef FR_HEADER__VERSION_TYPE			version_type;
  typedef FR_HEADER__FRAME_LIBRARY_TYPE			frame_library_type;
  typedef FR_HEADER__LIBRARY_REVISION_TYPE		library_revision_type;

  typedef FrameCPP::Common::IFrameStream::size_type	size_type;
  typedef LDASTools::AL::SharedPtr< FrDetector >	fr_detector_type;
  typedef LDASTools::AL::SharedPtr< FrEvent >		fr_event_type;
  typedef LDASTools::AL::SharedPtr< FrAdcData >		fr_adc_data_type;
  typedef LDASTools::AL::SharedPtr< FrProcData >	fr_proc_data_type;
  typedef LDASTools::AL::SharedPtr< FrSimData >		fr_sim_data_type;
  typedef LDASTools::AL::SharedPtr< FrSimEvent >	fr_sim_event_type;
  typedef LDASTools::AL::SharedPtr< FrameH >		frame_h_type;
  typedef INT_4U                                        fr_event_offset_type;
  typedef INT_4U                                        fr_sim_event_offset_type;

  IFrameFStream( const char* Filename );

  frame_library_type FrameLibrary( ) const;

  std::string FrameLibraryName( ) const;

  size_type GetNumberOfFrames( ) const;

  const FrTOC& GetTOC( ) const;

  library_revision_type LibraryRevision( ) const;

  fr_detector_type ReadDetector( const std::string& Name );

  fr_event_type ReadFrEvent( INT_4U Frame, const std::string& Channel );

  fr_event_type ReadFrEvent( const std::string& EventType, fr_event_offset_type Offset );

  fr_adc_data_type ReadFrAdcData( INT_4U Frame, const std::string& Channel );

  fr_proc_data_type ReadFrProcData( INT_4U Frame, const std::string& Channel );

  fr_sim_data_type ReadFrSimData( INT_4U Frame, const std::string& Channel );

  fr_sim_event_type ReadFrSimEvent( const std::string& EventType, fr_sim_event_offset_type Offset );

  frame_h_type ReadFrameN( INT_4U Index );

  frame_h_type ReadFrameNSubset( INT_4U Index, INT_4U Elements );

  frame_h_type ReadNextFrame( );

  version_type Version( ) const;

};

#endif /* IFRAME_FSTREAM_I */
