#ifndef FRAME_CPP__TEST__IFRAMESTREAM_HH
#define FRAME_CPP__TEST__IFRAMESTREAM_HH

namespace FrameCPP
{
  namespace Version_7
  {
    class IFrameStream;
  }

  namespace Version_6
  {
    class IFrameStream;
  }
  namespace Common
  {
    class IFrameStreamGen;
  }

  namespace Test
  {
    //-------------------------------------------------------------------
    /// \brief Version independent manipulation of frame stream.
    //-------------------------------------------------------------------
    class IFrameStream
    {
    private:
      typedef FrameCPP::Version_7::IFrameStream iframestream7;
      typedef FrameCPP::Version_6::IFrameStream iframestream6;
      typedef FrameCPP::Common::IFrameStreamGen iframestream;

    public:
      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Filename
      ///     The name of the frame file to be queried.
      /// \param[in] FrameSpec
      ///     Version frame specification version to use to create
      ///     the actual frame reader.
      ///
      /// \return
      ///     An instance of the class.
      //-----------------------------------------------------------------
      IFrameStream( const char* const Filename, int FrameSpec );

      INT_2U GetVersion( );

      const char* GetOriginator( );

      INT_2U GetLibraryRevision( );

    private:
      LDASTools::AL::ifstream	m_istream;
      int			m_frame_spec;
      iframestream*		m_gen_frame_stream;
      union {
	iframestream7*	v7;
	iframestream6*	v6;
      } m_frame_stream;
    }; // class - IFrameStream
  } // namespace - Test
} // namespace - FrameCPP

#endif /* FRAME_CPP__TEST__IFRAMESTREAM_HH */
