# Configuration Examples

These practical examples will help you optimize Netdata for various real-world deployment scenarios.

## Single Agent Configuration

Single Agents work great out of the box with sensible defaults.

:::tip

Check out our [configuration documentation](/docs/netdata-agent/configuration/README.md) for all available options.

:::

## Parent-Child Configuration Examples

### Lightweight Child Configuration

This example helps you make Children super lightweight by offloading work to Parents, minimizing resource usage on production systems.

<details>
<summary><strong>Click to see lightweight Child configuration</strong></summary><br/>

**Why minimize Child footprint?**
We don't recommend connecting Children to Cloud directly. This reduces the Netdata Agent footprint on your production systems, as some capabilities can be switched OFF for the Child and kept ON for the Parent.

**What this does:**

- Stores metrics in RAM only (zero disk I/O)
- Disables machine learning (Parent handles it)
- Disables alerts (Parent handles them)
- Keeps only 20 minutes of data locally
- Restricts dashboard to localhost only

Edit `netdata.conf` on the Child using the [edit-config](/docs/netdata-agent/configuration/README.md#locate-your-config-directory) script:

```ini
[db]
    # https://github.com/netdata/netdata/blob/master/src/database/README.md
    # none = no retention, ram = some retention in ram
    mode = ram
    # The retention in seconds.
    # This provides some tolerance to the time the child has to find a parent 
    # to transfer the data. For IoT, this can be lowered to 120.
    retention = 1200
    # The granularity of metrics, in seconds.
    # You may increase this to lower CPU resources.
    update every = 1
[ml]
    # Disable Machine Learning
    enabled = no
[health]
    # Disable Health Checks (Alerting)
    enabled = no
[web]
    # Disable remote access to the local dashboard
    bind to = localhost
[plugins]
    # Uncomment the following line to disable all external plugins on extreme IoT cases by default.
    # enable running new plugins = no
```

Edit `stream.conf` on the Child using the [edit-config](/docs/netdata-agent/configuration/README.md#locate-your-config-directory) script:

```ini
[stream]
    # Stream metrics to another Netdata
    enabled = yes
    # The IP and PORT of the parent
    destination = PARENT_IP_ADDRESS:19999
    # The shared API key, generated by uuidgen
    api key = API_KEY
```

**Perfect for:** IoT devices, containers, or any resource-constrained system.

</details><br/>

### Parent with Tiered Storage

This example helps you configure a Parent with intelligent storage tiers to store different time ranges at different resolutions.

<details>
<summary><strong>Click to see Parent with tiered storage configuration</strong></summary><br/>

This example provides configuration for multiple [tiers of metrics storage](/src/database/README.md#tiers), for 10 Children with about 2k metrics each.

**What this gives you:**

- 1-second resolution for 1 week (recent data at full detail)
- 1-minute resolution for 1 month (medium-term trends)
- 1-hour resolution for 1 year (long-term patterns)

**Resource requirements:**

- Disk space: 25GB total
- RAM usage: 3.5GB typical (2.5GB under memory pressure)

Edit `netdata.conf` on the Parent using the [edit-config](/docs/netdata-agent/configuration/README.md#locate-your-config-directory) script:

```ini
[db]
    mode = dbengine
    dbengine tier backfill = new
    storage tiers = 3
    dbengine page cache size = 1.4GiB

    # storage tier 0
    update every = 1
    dbengine tier 0 retention size = 12GiB

    # storage tier 1
    dbengine tier 1 update every iterations = 60
    dbengine tier 1 retention size = 4GiB

    # storage tier 2
    dbengine tier 2 update every iterations = 60
    dbengine tier 2 retention size = 2GiB
[ml]
    # Enabled by default
    # enabled = yes
[health]
    # Enabled by default
    # enabled = yes
[web]
    # Enabled by default
    # bind to = *
```

Edit `stream.conf` on the Parent using the [edit-config](/docs/netdata-agent/configuration/README.md#locate-your-config-directory) script:

```ini
[API_KEY]
    # Accept metrics streaming from other Agents with the specified API key
    enabled = yes
```

**Perfect for:** Central monitoring servers with enough storage for historical data.

</details><br/>

### Active-Active Parents

This example guides you through setting up active-active Parents that sync with each other for high availability.

<details>
<summary><strong>Click to see high availability configuration</strong></summary><br/>

:::info

- To set up active-active streaming between Parent 1 and Parent 2, Parent 1 needs to be instructed to stream data to Parent 2 and Parent 2 to stream data to Parent 1.

- The Child Agents need to be configured with the addresses of both Parent Agents. An Agent will only connect to one Parent at a time, falling back to the next upon failure.

:::

**Parent 1 stream.conf:**

```ini
[stream]
    # Stream metrics to another Netdata
    enabled = yes
    # The IP and PORT of Parent 2
    destination = PARENT_2_IP_ADDRESS:19999
    # This is the API key for the outgoing connection to Parent 2
    api key = API_KEY
[API_KEY]
    # Accept metrics streams from Parent 2 and Child Agents
    enabled = yes
```

**Parent 2 stream.conf:**

```ini
[stream]
    # Stream metrics to another Netdata
    enabled = yes
    # The IP and PORT of Parent 1
    destination = PARENT_1_IP_ADDRESS:19999
    api key = API_KEY
[API_KEY]
    # Accept metrics streams from Parent 1 and Child Agents
    enabled = yes
```

**Children stream.conf:**

```ini
[stream]
    # Stream metrics to another Netdata
    enabled = yes
    # The IP and PORT of the parent
    destination = PARENT_1_IP_ADDRESS:19999 PARENT_2_IP_ADDRESS:19999
    # The shared API key, generated by uuidgen
    api key = API_KEY
```

</details><br/>

## Further Reading

We strongly recommend the following configuration changes for production deployments:

1. Understand Netdata's [security and privacy design](/docs/security-and-privacy-design/README.md) and [secure your nodes](/docs/netdata-agent/securing-netdata-agents.md)

   To safeguard your infrastructure and comply with your organization's security policies.

2. [Optimize the Netdata Agents system utilization and performance](/docs/netdata-agent/configuration/optimize-the-netdata-agents-performance.md)

   To save valuable system resources, especially when running on weak IoT devices.

We also suggest that you:

1. [Use Netdata Cloud to access the dashboards](/docs/netdata-cloud/README.md)

   For increased security, user management and access to our latest features, tools and troubleshooting solutions.

2. [Change how long Netdata stores metrics](/src/database/CONFIGURATION.md#tiers)

   To control Netdata's memory use, when you have a lot of ephemeral metrics.

3. [Use host labels](/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts.md)

   To organize systems, metrics, and alerts.
