## [1.47.0] - 2024-08-22

### Merged Pull Requests:

- Fix space percentage calculation in dbengine retention chart ([#17963](https://github.com/netdata/netdata/issues/17963))
- Go.d replace colon in job name ([#17967](https://github.com/netdata/netdata/issues/17967))
- Go.d postgres index name replace space ([#17968](https://github.com/netdata/netdata/issues/17968))
- Cgroups: bring back "use unified cgroups" option ([#17969](https://github.com/netdata/netdata/issues/17969))
- Go.d dyncfg add job name validation ([#17971](https://github.com/netdata/netdata/issues/17971))
- Fix go.d rspamd unexpected response check ([#17974](https://github.com/netdata/netdata/issues/17974))
- Go.d docker respect DOCKER_HOST env var ([#17979](https://github.com/netdata/netdata/issues/17979))
- Docs: add "For Netdata running in a Docker container" to go.d/smartcl ([#17980](https://github.com/netdata/netdata/issues/17980))
- Regenerate integrations.js ([#17981](https://github.com/netdata/netdata/issues/17981))
- Improve ping_host_reachable alert calc ([#17982](https://github.com/netdata/netdata/issues/17982))
- Make cgroups version detection more reliable ([#17973](https://github.com/netdata/netdata/issues/17973))
- Change logging to debug  ([#17983](https://github.com/netdata/netdata/issues/17983))
- Docs: update "What's New and Coming?" ([#17984](https://github.com/netdata/netdata/issues/17984))
- Docs: smartctl: add the "no_check_power_mode" option ([#17985](https://github.com/netdata/netdata/issues/17985))
- Regenerate integrations.js ([#17986](https://github.com/netdata/netdata/issues/17986))
- Bump docker/build-push-action from 5 to 6 ([#17998](https://github.com/netdata/netdata/issues/17998))
- Health convert value to days in calc in whoisquery/x509check alarms ([#17999](https://github.com/netdata/netdata/issues/17999))
- Go.d whoisquery change  default days until expiration 90/30 => 30/15 ([#18000](https://github.com/netdata/netdata/issues/18000))
- Apps.plugin: remove "Normalization Ratio" internal charts ([#18004](https://github.com/netdata/netdata/issues/18004))
- Docs: add Troubleshoot->Getting Logs section to collectors ([#18005](https://github.com/netdata/netdata/issues/18005))
- Regenerate integrations.js ([#18006](https://github.com/netdata/netdata/issues/18006))
- Update netdata global stats and enable them by default ([#18001](https://github.com/netdata/netdata/issues/18001))
- Fix small typo ([#17875](https://github.com/netdata/netdata/issues/17875))
- Fix RPM repoconfig naming ([#18003](https://github.com/netdata/netdata/issues/18003))
- Detect on startup if the netdata-meta.db file is not a valid database file ([#17924](https://github.com/netdata/netdata/issues/17924))
- Tidy-up build related CI jobs. ([#17962](https://github.com/netdata/netdata/issues/17962))
- Sign DEB packages in the GHA runners that build them. ([#17949](https://github.com/netdata/netdata/issues/17949))
- Fix typo in packaging workflows.
- Fix DEB package signing issues.
- Fix Slack error reporting for packaging workflows. ([#18011](https://github.com/netdata/netdata/issues/18011))
- Enforce proper include ordering for vendored libraries. ([#18008](https://github.com/netdata/netdata/issues/18008))
- Explicitly disable logsmanagement plugin on known-broken environments. ([#18002](https://github.com/netdata/netdata/issues/18002))
- Fix key identification for DEB package signing.
- Fix key ID handling for DEB package signing.
- Rrdlabels: allow uppercase A-Z in label name ([#18013](https://github.com/netdata/netdata/issues/18013))
- Go.d snmp: add collecting network interface stats ([#18014](https://github.com/netdata/netdata/issues/18014))
- Regenerate integrations.js ([#18016](https://github.com/netdata/netdata/issues/18016))
- Ping meta fix configuring ping_group_range ([#18020](https://github.com/netdata/netdata/issues/18020))
- Go.d snmp: add config options to filter interfaces by name and type ([#18023](https://github.com/netdata/netdata/issues/18023))
- Fix grep warning in kickstart ([#18021](https://github.com/netdata/netdata/issues/18021))
- Regenerate integrations.js ([#18022](https://github.com/netdata/netdata/issues/18022))
- Alert prototype: set default "after" to -600 ([#18025](https://github.com/netdata/netdata/issues/18025))
- Sysinfo (WinAPI) ([#17857](https://github.com/netdata/netdata/issues/17857))
- Fix proxy connect response ([#18017](https://github.com/netdata/netdata/issues/18017))
- Port postfix collector from python to go ([#18026](https://github.com/netdata/netdata/issues/18026))
- Go.d k8state: skip jobs/cronjobs Pods ([#18028](https://github.com/netdata/netdata/issues/18028))
- Improve global statistics thread shutdown ([#18018](https://github.com/netdata/netdata/issues/18018))
- Go.d/postfix: simplify and fix tests ([#18029](https://github.com/netdata/netdata/issues/18029))
- Regenerate integrations.js ([#18030](https://github.com/netdata/netdata/issues/18030))
- Add Win CPU interrupts ([#17753](https://github.com/netdata/netdata/issues/17753))
- Troubleshooter must be assigned to rooms docs ([#18031](https://github.com/netdata/netdata/issues/18031))
- Fix Coverity scan CI. ([#18024](https://github.com/netdata/netdata/issues/18024))
- Bump repository config fetched by kickstart to latest version. ([#18034](https://github.com/netdata/netdata/issues/18034))
- Fix diskspace plugin in Docker ([#18035](https://github.com/netdata/netdata/issues/18035))
- Docs: fix go.d/weblog parser config ([#18037](https://github.com/netdata/netdata/issues/18037))
- Regenerate integrations.js ([#18038](https://github.com/netdata/netdata/issues/18038))
- Fix installing netdata-updater svc/timer for native packages ([#18032](https://github.com/netdata/netdata/issues/18032))
- Diskspace: update exclude paths/filesystems ([#18039](https://github.com/netdata/netdata/issues/18039))
- Proc/diskstats: Increase accuracy of average IO operation time ([#18040](https://github.com/netdata/netdata/issues/18040))
- Bump github.com/gofrs/flock from 0.8.1 to 0.11.0 in /src/go/collectors/go.d.plugin ([#18045](https://github.com/netdata/netdata/issues/18045))
- Bump go.mongodb.org/mongo-driver from 1.15.1 to 1.16.0 in /src/go/collectors/go.d.plugin ([#18048](https://github.com/netdata/netdata/issues/18048))
- Bump actions/add-to-project from 1.0.1 to 1.0.2 ([#18043](https://github.com/netdata/netdata/issues/18043))
- Bump github.com/docker/docker from 27.0.0+incompatible to 27.0.2+incompatible in /src/go/collectors/go.d.plugin ([#18047](https://github.com/netdata/netdata/issues/18047))
- Bump github.com/likexian/whois-parser from 1.24.16 to 1.24.18 in /src/go/collectors/go.d.plugin ([#18046](https://github.com/netdata/netdata/issues/18046))
- Bump github.com/prometheus/common from 0.54.0 to 0.55.0 in /src/go/collectors/go.d.plugin ([#18049](https://github.com/netdata/netdata/issues/18049))
- Update role-based-access-model.md ([#18050](https://github.com/netdata/netdata/issues/18050))
- Docs: deploy docker add host root mount ([#18051](https://github.com/netdata/netdata/issues/18051))
- Regenerate integrations.js ([#18052](https://github.com/netdata/netdata/issues/18052))
- Go.d update packages ([#18054](https://github.com/netdata/netdata/issues/18054))
- Go.d chrony add serverstats query (disabled for now) ([#18055](https://github.com/netdata/netdata/issues/18055))
- Ndsudo add 'chronyc serverstats' ([#18056](https://github.com/netdata/netdata/issues/18056))
- Freeipmi: add "no-restart" ([#17931](https://github.com/netdata/netdata/issues/17931)) ([#18057](https://github.com/netdata/netdata/issues/18057))
- Run the agent as a Windows service. ([#17766](https://github.com/netdata/netdata/issues/17766))
- Restructure go.d ([#18058](https://github.com/netdata/netdata/issues/18058))
- Go.d vsphere add update_every ui:help ([#18060](https://github.com/netdata/netdata/issues/18060))
- Fix prometeus export: missing comma before "instance" label ([#18061](https://github.com/netdata/netdata/issues/18061))
- Go.d postgres github.com/jackc/pgx/v5 ([#18062](https://github.com/netdata/netdata/issues/18062))
- Remove hard-coded url from python.d puppet chart plugin ([#18064](https://github.com/netdata/netdata/issues/18064))
- Disable health thread on windows ([#18066](https://github.com/netdata/netdata/issues/18066))
- Go.d set sensitive props to "password" widget ([#18068](https://github.com/netdata/netdata/issues/18068))
- Update golang version in netdata.spec ([#18069](https://github.com/netdata/netdata/issues/18069))
- Port ipfs from python to Go ([#18070](https://github.com/netdata/netdata/issues/18070))
- Regenerate integrations.js ([#18073](https://github.com/netdata/netdata/issues/18073))
- Go.d ipfs fix tests ([#18074](https://github.com/netdata/netdata/issues/18074))
- Health add alarm docker container down ([#18075](https://github.com/netdata/netdata/issues/18075))
- Proc: collect ksm/swap/cma/zswap only when feature enabled ([#18076](https://github.com/netdata/netdata/issues/18076))
- Bump golang.org/x/net from 0.26.0 to 0.27.0 in /src/go ([#18078](https://github.com/netdata/netdata/issues/18078))
- Bump github.com/gofrs/flock from 0.11.0 to 0.12.0 in /src/go ([#18077](https://github.com/netdata/netdata/issues/18077))
- Go.d fail2ban: add docker support ([#18081](https://github.com/netdata/netdata/issues/18081))
- Netdata.spec/plugin-go: added weak dependency for lm_sensors ([#18067](https://github.com/netdata/netdata/issues/18067))
- Relax strict version constraints for DEB package dependencies. ([#17681](https://github.com/netdata/netdata/issues/17681))
- Remove Debian 10 from supported platforms. ([#18083](https://github.com/netdata/netdata/issues/18083))
- Remove Ubuntu 23.10 from supported platforms. ([#18082](https://github.com/netdata/netdata/issues/18082))
- Switch to legacy images for CentOS 7 CI. ([#18085](https://github.com/netdata/netdata/issues/18085))
- Update go.d path in docs and ci ([#18087](https://github.com/netdata/netdata/issues/18087))
- Regenerate integrations.js ([#18086](https://github.com/netdata/netdata/issues/18086))
- Track LTS for Debian EOL status. ([#18084](https://github.com/netdata/netdata/issues/18084))
- Go.d fix compiling for windows ([#18091](https://github.com/netdata/netdata/issues/18091))
- Go.d megacli: return error if no adapters found (parsing failed) ([#18090](https://github.com/netdata/netdata/issues/18090))
- Semaphore (common context) ([#18041](https://github.com/netdata/netdata/issues/18041))
- Ndsudo set uid/gid/egid to 0 before executing command ([#18093](https://github.com/netdata/netdata/issues/18093))
- Go.d use pgx v4 for pgbouncer ([#18097](https://github.com/netdata/netdata/issues/18097))
- Update securing-netdata-agents.md ([#18096](https://github.com/netdata/netdata/issues/18096))
- Fix network sent dimensions ([#18099](https://github.com/netdata/netdata/issues/18099))
- Spawn server (Windows support for external plugins) ([#17866](https://github.com/netdata/netdata/issues/17866))
- Add authorization to spawn requests ([#18103](https://github.com/netdata/netdata/issues/18103))
- Docs: deploy docker add host root mount (stable) ([#18105](https://github.com/netdata/netdata/issues/18105))
- Regenerate integrations.js ([#18106](https://github.com/netdata/netdata/issues/18106))
- Fix detection of Coverity archive in scan script. ([#18104](https://github.com/netdata/netdata/issues/18104))
- Add port service names to network viewer ([#18107](https://github.com/netdata/netdata/issues/18107))
- Move "api key" option in stream.conf ([#18108](https://github.com/netdata/netdata/issues/18108))
- Port puppet collector from Python to Go ([#18088](https://github.com/netdata/netdata/issues/18088))
- Regenerate integrations.js ([#18110](https://github.com/netdata/netdata/issues/18110))
- EBPF cgroup and mutex ([#17915](https://github.com/netdata/netdata/issues/17915))
- Regenerate integrations.js ([#18114](https://github.com/netdata/netdata/issues/18114))
- Spawn server improvements ([#18115](https://github.com/netdata/netdata/issues/18115))
- Make claiming work again ([#18116](https://github.com/netdata/netdata/issues/18116))
- Spawn server fixes 3 ([#18117](https://github.com/netdata/netdata/issues/18117))
- Log in the same line ([#18118](https://github.com/netdata/netdata/issues/18118))
- Go.d smartctl: add scsi read/write/verify error rate ([#18119](https://github.com/netdata/netdata/issues/18119))
- Regenerate integrations.js ([#18124](https://github.com/netdata/netdata/issues/18124))
- Go.d whoisquery fix "days until" in config_schema.json ([#18121](https://github.com/netdata/netdata/issues/18121))
- Go.d filecheck fix dir existence chart label ([#18126](https://github.com/netdata/netdata/issues/18126))
- Spawn server fixes No 4 ([#18127](https://github.com/netdata/netdata/issues/18127))
- Spawn server improvements 5 ([#18131](https://github.com/netdata/netdata/issues/18131))
- Go.d fix url path overwrite ([#18132](https://github.com/netdata/netdata/issues/18132))
- Docs: go.d mysql: remove unix sockets from auto_detection ([#18134](https://github.com/netdata/netdata/issues/18134))
- Regenerate integrations.js ([#18135](https://github.com/netdata/netdata/issues/18135))
- Spawn server fixes 6 ([#18136](https://github.com/netdata/netdata/issues/18136))
- Go.d smartctl add "extra_devices" option ([#18140](https://github.com/netdata/netdata/issues/18140))
- Regenerate integrations.js ([#18141](https://github.com/netdata/netdata/issues/18141))
- Ndsudo add smartctl scan-open ([#18143](https://github.com/netdata/netdata/issues/18143))
- Go.d smartctl: do scan only once on startup if interval is 0 ([#18144](https://github.com/netdata/netdata/issues/18144))
- Regenerate integrations.js ([#18145](https://github.com/netdata/netdata/issues/18145))
- Go.d smartctl: use scan-open when "no_check_power_mode" is "never" ([#18146](https://github.com/netdata/netdata/issues/18146))
- Bump github.com/likexian/whois from 1.15.3 to 1.15.4 in /src/go ([#18169](https://github.com/netdata/netdata/issues/18169))
- Bump github.com/lmittmann/tint from 1.0.4 to 1.0.5 in /src/go ([#18167](https://github.com/netdata/netdata/issues/18167))
- Fix detection of Coverity archive path in scan script. ([#18112](https://github.com/netdata/netdata/issues/18112))
- Stop a bit more quickly on a failure when using Ninja. ([#18101](https://github.com/netdata/netdata/issues/18101))
- Bump CMake supported versions. ([#18102](https://github.com/netdata/netdata/issues/18102))
- Fix issue in platform EOL check workflow. ([#18171](https://github.com/netdata/netdata/issues/18171))
- Fix logic bug in platform EOL check code. ([#18172](https://github.com/netdata/netdata/issues/18172))
- Add support for sending Telegram notifications to topics ([#18173](https://github.com/netdata/netdata/issues/18173))
- Regenerate integrations.js ([#18174](https://github.com/netdata/netdata/issues/18174))
- Docs: add "install smartmontools" for Docker netdata ([#18175](https://github.com/netdata/netdata/issues/18175))
- Regenerate integrations.js ([#18176](https://github.com/netdata/netdata/issues/18176))
- Addition to postfix meta ([#18177](https://github.com/netdata/netdata/issues/18177))
- Go.d smarctl simplify scan open ([#18180](https://github.com/netdata/netdata/issues/18180))
- Port AP collector to Go ([#18170](https://github.com/netdata/netdata/issues/18170))
- Regenerate integrations.js ([#18181](https://github.com/netdata/netdata/issues/18181))
- Docs: go.d/ap update data_collection description ([#18182](https://github.com/netdata/netdata/issues/18182))
- Regenerate integrations.js ([#18183](https://github.com/netdata/netdata/issues/18183))
- Create release branches for major releases as well. ([#18184](https://github.com/netdata/netdata/issues/18184))
- Personalize installer and uninstaller Windows (Control Panel) ([#18147](https://github.com/netdata/netdata/issues/18147))
- Ndsudo setuid before looking for command ([#18189](https://github.com/netdata/netdata/issues/18189))
- Remove logs-management plugin. ([#18186](https://github.com/netdata/netdata/issues/18186))
- Improve alerts ([#18080](https://github.com/netdata/netdata/issues/18080))
- Port Icecast collector to Go ([#18190](https://github.com/netdata/netdata/issues/18190))
- Regenerate integrations.js ([#18193](https://github.com/netdata/netdata/issues/18193))
- Go.d icecast single source response ([#18195](https://github.com/netdata/netdata/issues/18195))
- Remove fluent-bit submodule ([#18196](https://github.com/netdata/netdata/issues/18196))
- Add Widnows CI jobs. ([#18187](https://github.com/netdata/netdata/issues/18187))
- Skip building ndsudo when it’s not actually needed. ([#18191](https://github.com/netdata/netdata/issues/18191))
- Do not include REMOVED status in the alert snapshot ([#18197](https://github.com/netdata/netdata/issues/18197))
- Do not rely on the queued flag to queue a context ([#18198](https://github.com/netdata/netdata/issues/18198))
- Fix RPM dependency issue with old logs management plugin package.
- Docs: simplify "Disk Requirements and Retention" ([#18205](https://github.com/netdata/netdata/issues/18205))
- Bump k8s.io/client-go from 0.30.2 to 0.30.3 in /src/go ([#18208](https://github.com/netdata/netdata/issues/18208))
- Go.d megacli: add bbu capacity degradation % ([#18211](https://github.com/netdata/netdata/issues/18211))
- Regenerate integrations.js ([#18212](https://github.com/netdata/netdata/issues/18212))
- Dont install test bash scripts by default ([#18214](https://github.com/netdata/netdata/issues/18214))
- Port memcached collector to Go ([#18209](https://github.com/netdata/netdata/issues/18209))
- Go.d chrony fix client read/write timeout ([#18215](https://github.com/netdata/netdata/issues/18215))
- Regenerate integrations.js ([#18216](https://github.com/netdata/netdata/issues/18216))
- Go.d drop using cancelreader ([#18219](https://github.com/netdata/netdata/issues/18219))
- Go.d fix netdata dir path on win under msys ([#18221](https://github.com/netdata/netdata/issues/18221))
- Port Tomcat collector to Go ([#18220](https://github.com/netdata/netdata/issues/18220))
- Regenerate integrations.js ([#18225](https://github.com/netdata/netdata/issues/18225))
- Improve windows agent ([#18227](https://github.com/netdata/netdata/issues/18227))
- Windows build fix ([#18231](https://github.com/netdata/netdata/issues/18231))
- Bump github.com/gofrs/flock from 0.12.0 to 0.12.1 in /src/go ([#18235](https://github.com/netdata/netdata/issues/18235))
- Bump github.com/prometheus-community/pro-bing from 0.4.0 to 0.4.1 in /src/go ([#18237](https://github.com/netdata/netdata/issues/18237))
- Bump github.com/vmware/govmomi from 0.38.0 to 0.39.0 in /src/go ([#18236](https://github.com/netdata/netdata/issues/18236))
- Bump github.com/docker/docker from 27.0.3+incompatible to 27.1.1+incompatible in /src/go ([#18234](https://github.com/netdata/netdata/issues/18234))
- Update libbpf (1.45.0) ([#18226](https://github.com/netdata/netdata/issues/18226))
- Fix up CMake feature handling for Windows. ([#18229](https://github.com/netdata/netdata/issues/18229))
- Default to release with debug symbols for Windows builds. ([#18230](https://github.com/netdata/netdata/issues/18230))
- Support IPV6 when establishing MQTT connection to the cloud ([#18217](https://github.com/netdata/netdata/issues/18217))
- Update node info payload ([#18240](https://github.com/netdata/netdata/issues/18240))
- Bump github.com/tidwall/gjson from 1.17.1 to 1.17.3 in /src/go ([#18244](https://github.com/netdata/netdata/issues/18244))
- Clean up unneeded depencdencies. ([#18242](https://github.com/netdata/netdata/issues/18242))
- Fix OS detection messages in CMake. ([#18243](https://github.com/netdata/netdata/issues/18243))
- Update Cloud MSTeam documentation ([#18224](https://github.com/netdata/netdata/issues/18224))
- Docs: add a note that the min dbengine tier size is 256 MB ([#18256](https://github.com/netdata/netdata/issues/18256))
- Update README.md ([#18246](https://github.com/netdata/netdata/issues/18246))
- Docs: improve "Settings on Microsoft Teams" description ([#18257](https://github.com/netdata/netdata/issues/18257))
- Regenerate integrations.js ([#18258](https://github.com/netdata/netdata/issues/18258))
- Update Installer Code (Services) ([#18253](https://github.com/netdata/netdata/issues/18253))
- Go.d x509check add not_revoked dimension ([#18261](https://github.com/netdata/netdata/issues/18261))
- Regenerate integrations.js ([#18262](https://github.com/netdata/netdata/issues/18262))
- Don’t install netdata-updater code on Windows. ([#18251](https://github.com/netdata/netdata/issues/18251))
- Apps conf add beanstalkd ([#18267](https://github.com/netdata/netdata/issues/18267))
- Go.d beanstalk ([#18263](https://github.com/netdata/netdata/issues/18263))
- Fix CI issues in build workflow. ([#18266](https://github.com/netdata/netdata/issues/18266))
- Remove python.d/beanstalk ([#18259](https://github.com/netdata/netdata/issues/18259))
- Go.d smartctl: improve checking scsi-sat in scan ([#18269](https://github.com/netdata/netdata/issues/18269))
- Regenerate integrations.js ([#18268](https://github.com/netdata/netdata/issues/18268))
- Go.d smartctl: undo extra_devices skip from #18269 ([#18270](https://github.com/netdata/netdata/issues/18270))
- Go.d fix dimension id check ([#18272](https://github.com/netdata/netdata/issues/18272))
- Go.d snmp: adjust max repetitions automatically ([#18274](https://github.com/netdata/netdata/issues/18274))
- Set GOPROXY when building go.d.plugin ([#18275](https://github.com/netdata/netdata/issues/18275))
- Add detailed reporting of failed checksums in kickstart script. ([#18265](https://github.com/netdata/netdata/issues/18265))
- Add code signing for Windows executables. ([#18222](https://github.com/netdata/netdata/issues/18222))
- Fix typos in code signing steps in Windows build job.
- Add go.d/rethinkdb ([#18278](https://github.com/netdata/netdata/issues/18278))
- Remove python.d/rethinkdb ([#18277](https://github.com/netdata/netdata/issues/18277))
- Regenerate integrations.js ([#18280](https://github.com/netdata/netdata/issues/18280))
- Inital commit for Go squid ([#18279](https://github.com/netdata/netdata/issues/18279))
- Squid collector port to Go ([#18276](https://github.com/netdata/netdata/issues/18276))
- Regenerate integrations.js ([#18282](https://github.com/netdata/netdata/issues/18282))
- Bump go.mongodb.org/mongo-driver from 1.16.0 to 1.16.1 in /src/go ([#18286](https://github.com/netdata/netdata/issues/18286))
- Bump github.com/gosnmp/gosnmp from 1.37.0 to 1.38.0 in /src/go ([#18287](https://github.com/netdata/netdata/issues/18287))
- Bump golang.org/x/net from 0.27.0 to 0.28.0 in /src/go ([#18284](https://github.com/netdata/netdata/issues/18284))
- Bump google-github-actions/upload-cloud-storage from 2.1.0 to 2.1.2 ([#18283](https://github.com/netdata/netdata/issues/18283))
- Bump google-github-actions/setup-gcloud from 2.1.0 to 2.1.1 ([#18285](https://github.com/netdata/netdata/issues/18285))
- Go.d rethinkdb fix cluster_servers_stats_request ([#18289](https://github.com/netdata/netdata/issues/18289))
- Remove python.d/alarms ([#18290](https://github.com/netdata/netdata/issues/18290))
- Regenerate integrations.js ([#18292](https://github.com/netdata/netdata/issues/18292))
- Remove python.d/gearman ([#18291](https://github.com/netdata/netdata/issues/18291))
- Add go.d/gearman ([#18294](https://github.com/netdata/netdata/issues/18294))
- Go.d gearman fix meta ([#18298](https://github.com/netdata/netdata/issues/18298))
- Regenerate integrations.js ([#18299](https://github.com/netdata/netdata/issues/18299))
- Add nsd-control to ndsudo ([#18301](https://github.com/netdata/netdata/issues/18301))
- Remove python.d/nsd ([#18300](https://github.com/netdata/netdata/issues/18300))
- Add go.d/nsd ([#18302](https://github.com/netdata/netdata/issues/18302))
- Regenerate integrations.js ([#18303](https://github.com/netdata/netdata/issues/18303))
- Add exim to ndsudo ([#18304](https://github.com/netdata/netdata/issues/18304))
- Add go.d/exim ([#18306](https://github.com/netdata/netdata/issues/18306))
- Remove python.d/exim ([#18305](https://github.com/netdata/netdata/issues/18305))
- Regenerate integrations.js ([#18308](https://github.com/netdata/netdata/issues/18308))
- Go.d nvidia_smi remove "csv" mode ([#18311](https://github.com/netdata/netdata/issues/18311))
- Regenerate integrations.js ([#18312](https://github.com/netdata/netdata/issues/18312))
- Go.d nvidia_smi: add loop mode ([#18313](https://github.com/netdata/netdata/issues/18313))
- Use system certificate configuration for Yum/DNF repos. ([#18293](https://github.com/netdata/netdata/issues/18293))
- Go.d nvidia_smi: enable by default ([#18315](https://github.com/netdata/netdata/issues/18315))
- Remove python.d/nvidia_smi ([#18316](https://github.com/netdata/netdata/issues/18316))
- Regenerate integrations.js ([#18317](https://github.com/netdata/netdata/issues/18317))
- Handle GOROOT inside build system instead of outside. ([#18296](https://github.com/netdata/netdata/issues/18296))
- Go.d redis: fix default "address" in config_schema.json ([#18320](https://github.com/netdata/netdata/issues/18320))
- Add go.d dovecot ([#18321](https://github.com/netdata/netdata/issues/18321))
- Remove python.d/dovecot ([#18322](https://github.com/netdata/netdata/issues/18322))
- Regenerate integrations.js ([#18324](https://github.com/netdata/netdata/issues/18324))
- Remove python.d/uwsgi ([#18325](https://github.com/netdata/netdata/issues/18325))
- Add go.d/uwsgi ([#18326](https://github.com/netdata/netdata/issues/18326))
- Regenerate integrations.js ([#18328](https://github.com/netdata/netdata/issues/18328))
- Add trigger to clean up chart labels and charts ([#18248](https://github.com/netdata/netdata/issues/18248))
- Remove python.d/riakkv ([#18329](https://github.com/netdata/netdata/issues/18329))
- Go.d riakkv ([#18330](https://github.com/netdata/netdata/issues/18330))
- Ensure files in /usr/lib/netdata/system are not executable. ([#18318](https://github.com/netdata/netdata/issues/18318))
- Regenerate integrations.js ([#18333](https://github.com/netdata/netdata/issues/18333))
- Add dashboard v2 license to readme ([#18334](https://github.com/netdata/netdata/issues/18334))
- Add i2pd to apps_groups.conf ([#18335](https://github.com/netdata/netdata/issues/18335))
- Bump k8s.io/client-go from 0.30.3 to 0.31.0 in /src/go ([#18336](https://github.com/netdata/netdata/issues/18336))
- Bump github.com/miekg/dns from 1.1.61 to 1.1.62 in /src/go ([#18337](https://github.com/netdata/netdata/issues/18337))
- Bump github.com/docker/docker from 27.1.1+incompatible to 27.1.2+incompatible in /src/go ([#18340](https://github.com/netdata/netdata/issues/18340))
- Bump github.com/vmware/govmomi from 0.39.0 to 0.40.0 in /src/go ([#18338](https://github.com/netdata/netdata/issues/18338))
- Add license to readmes menu ([#18345](https://github.com/netdata/netdata/issues/18345))
- Fix sending CLEAR notifications with critical severity modifier ([#18347](https://github.com/netdata/netdata/issues/18347))
- Remove python.d/monit ([#18343](https://github.com/netdata/netdata/issues/18343))
- Add missing initial slashes for internal documation links ([#18348](https://github.com/netdata/netdata/issues/18348))
- Add go.d/monit ([#18344](https://github.com/netdata/netdata/issues/18344))
- Regenerate integrations.js ([#18350](https://github.com/netdata/netdata/issues/18350))
- EBPF memory ([#18232](https://github.com/netdata/netdata/issues/18232))
- Go.d httpcheck: add status description to docs ([#18351](https://github.com/netdata/netdata/issues/18351))
- Regenerate integrations.js ([#18353](https://github.com/netdata/netdata/issues/18353))
- Remove python.d lm_sensors.py ([#18356](https://github.com/netdata/netdata/issues/18356))
- Remove python.d/retroshare ([#18355](https://github.com/netdata/netdata/issues/18355))
- Regenerate integrations.js ([#18357](https://github.com/netdata/netdata/issues/18357))
- Update README.md
- Remove python.d/tor ([#18358](https://github.com/netdata/netdata/issues/18358))
- Add go.d/tor ([#18361](https://github.com/netdata/netdata/issues/18361))
- Regenerate integrations.js ([#18363](https://github.com/netdata/netdata/issues/18363))
- Bump github.com/axiomhq/hyperloglog from 0.0.0-20240507144631-af9851f82b27 to 0.1.0 in /src/go ([#18367](https://github.com/netdata/netdata/issues/18367))
- Bump github.com/vmware/govmomi from 0.40.0 to 0.42.0 in /src/go ([#18366](https://github.com/netdata/netdata/issues/18366))
- EBPF (reduce CPU and memory usage) ([#18365](https://github.com/netdata/netdata/issues/18365))
- Go.d squidlog: improve parser init and parsing ([#18368](https://github.com/netdata/netdata/issues/18368))
- Remove python.d/example ([#18369](https://github.com/netdata/netdata/issues/18369))
- Remove python.d/changefinder ([#18370](https://github.com/netdata/netdata/issues/18370))
- Regenerate integrations.js ([#18373](https://github.com/netdata/netdata/issues/18373))
- Go.d dnsmasq: query metrics individually to handle v2.90+ SERVFAIL ([#18376](https://github.com/netdata/netdata/issues/18376))
- Add SCIM integration docs ([#18094](https://github.com/netdata/netdata/issues/18094))
- Regenerate integrations.js ([#18377](https://github.com/netdata/netdata/issues/18377))
- Ci gen integrations: add cloud-authentication dir ([#18378](https://github.com/netdata/netdata/issues/18378))
- Go.d docs: add a note that debug mode not supported for Dyncfg jobs ([#18379](https://github.com/netdata/netdata/issues/18379))
- Regenerate integrations.js ([#18380](https://github.com/netdata/netdata/issues/18380))
- Remove host immediately on stale node removal ([#18381](https://github.com/netdata/netdata/issues/18381))
- Switch to DEB822 format for APT repository configuration. ([#18374](https://github.com/netdata/netdata/issues/18374))
- Remove debug message ([#18382](https://github.com/netdata/netdata/issues/18382))
- Origin-sign all DEB packages regardless of upload target. ([#18372](https://github.com/netdata/netdata/issues/18372))
- Go.d zfspool: collect vdev health state ([#18383](https://github.com/netdata/netdata/issues/18383))
- Regenerate integrations.js ([#18387](https://github.com/netdata/netdata/issues/18387))
- Update windows installer ([#18385](https://github.com/netdata/netdata/issues/18385))
- Remove proc zfspools ([#18389](https://github.com/netdata/netdata/issues/18389))
- Modify CLI command remove-stale-node to accept hostname ([#18386](https://github.com/netdata/netdata/issues/18386))
- Regenerate integrations.js ([#18391](https://github.com/netdata/netdata/issues/18391))
- Go.d dnsmsasq_dhcp: improve parsing of dhcp ranges ([#18394](https://github.com/netdata/netdata/issues/18394))
- Fix issues with file-check for build workflow.

## [1.46.0] - 2024-06-19

### Merged Pull Requests:

- Add -Wno-builtin-macro-redefined to compiler flags. ([#17209](https://github.com/netdata/netdata/issues/17209))
- Fix job depdendencies in Docker workflow. ([#17215](https://github.com/netdata/netdata/issues/17215))
- Add warning on old custom dashboards and rephrase existing page ([#17214](https://github.com/netdata/netdata/issues/17214))
- Bump github.com/docker/docker from 25.0.4+incompatible to 25.0.5+incompatible in /src/go/collectors/go.d.plugin ([#17211](https://github.com/netdata/netdata/issues/17211))
- Go.d: local-listeners sd: fix mariadbd comm ([#17218](https://github.com/netdata/netdata/issues/17218))
- Reduce flush operations during journal build ([#17220](https://github.com/netdata/netdata/issues/17220))
- Go.d: mysql: disable session query log and slow query log ([#17219](https://github.com/netdata/netdata/issues/17219))
- Fixing the helm login command for the onprem installation ([#17222](https://github.com/netdata/netdata/issues/17222))
- Update flowchart cloud-onprem ([#17227](https://github.com/netdata/netdata/issues/17227))
- Feat: add netdata cloud api-tokens docs ([#17225](https://github.com/netdata/netdata/issues/17225))
- Fix html ([#17228](https://github.com/netdata/netdata/issues/17228))
- Update README.md
- Dbengine: cache bug-fix when under pressure ([#17231](https://github.com/netdata/netdata/issues/17231))
- Updated dbengine unittest ([#17232](https://github.com/netdata/netdata/issues/17232))
- DBENGINE: use gorilla by default ([#17234](https://github.com/netdata/netdata/issues/17234))
- Code cleanup ([#17237](https://github.com/netdata/netdata/issues/17237))
- Fix MRG Metric refcount issue ([#17239](https://github.com/netdata/netdata/issues/17239))
- DBENGINE: support ZSTD compression ([#17244](https://github.com/netdata/netdata/issues/17244))
- Bump github.com/docker/docker from 25.0.5+incompatible to 26.0.0+incompatible in /src/go/collectors/go.d.plugin ([#17248](https://github.com/netdata/netdata/issues/17248))
- Bump actions/add-to-project from 0.6.0 to 0.6.1 ([#17245](https://github.com/netdata/netdata/issues/17245))
- Bump github.com/prometheus/common from 0.50.0 to 0.51.1 in /src/go/collectors/go.d.plugin ([#17247](https://github.com/netdata/netdata/issues/17247))
- Go.d: sd local-listeners: discover /proc/net/tcp6 only apps ([#17252](https://github.com/netdata/netdata/issues/17252))
- Remove USR1 "Save internal DB to disk" ([#17249](https://github.com/netdata/netdata/issues/17249))
- Go.d: sd local-listeners: drop docker-proxy targets ([#17254](https://github.com/netdata/netdata/issues/17254))
- Go.d: job manager: set config defaults ([#17255](https://github.com/netdata/netdata/issues/17255))
- Add dbengine compression info in -W buildinfo ([#17257](https://github.com/netdata/netdata/issues/17257))
- Try finding OpenSSL using pkg-config first on macOS. ([#17250](https://github.com/netdata/netdata/issues/17250))
- Assorted macOS build fixes. ([#17216](https://github.com/netdata/netdata/issues/17216))
- Include reachability alert fields ([#17258](https://github.com/netdata/netdata/issues/17258))
- Update whats new ([#17251](https://github.com/netdata/netdata/issues/17251))
- Docs: update pagerduty meta ([#17264](https://github.com/netdata/netdata/issues/17264))
- Regenerate integrations.js ([#17261](https://github.com/netdata/netdata/issues/17261))
- Reset database connection handle on close ([#17266](https://github.com/netdata/netdata/issues/17266))
- Fix duplicate chart context ([#17267](https://github.com/netdata/netdata/issues/17267))
- Regenerate integrations.js ([#17268](https://github.com/netdata/netdata/issues/17268))
- Go.d: config schemas update: prohibit additional properties ([#17269](https://github.com/netdata/netdata/issues/17269))
- Add additional fields to webhook reachability notifications ([#17271](https://github.com/netdata/netdata/issues/17271))
- Go.d: dyncfg: allow "name" additional property ([#17272](https://github.com/netdata/netdata/issues/17272))
- Regenerate integrations.js ([#17273](https://github.com/netdata/netdata/issues/17273))
- Trigger subsequent workflows for Helmchart and MSI ([#17224](https://github.com/netdata/netdata/issues/17224))
- Minor fix in monitor releases workflow ([#17256](https://github.com/netdata/netdata/issues/17256))
- Enable sentry on all Debian and Ubuntu versions. ([#17259](https://github.com/netdata/netdata/issues/17259))
- Correctly propagate errors from child scripts in kickstart.sh. ([#17263](https://github.com/netdata/netdata/issues/17263))
- Apps_proc_pid_fd: ignore kf_sock_inpcb on modern FreeBSD ([#17243](https://github.com/netdata/netdata/issues/17243))
- REFERENCE - Fix small unligned typo ([#17274](https://github.com/netdata/netdata/issues/17274))
- Revert "Enable sentry on all Debian and Ubuntu versions." ([#17279](https://github.com/netdata/netdata/issues/17279))
- Correctly handle libyaml linking for log2journal. ([#17276](https://github.com/netdata/netdata/issues/17276))
- Go.d: socket package: don't set client on connect() err ([#17283](https://github.com/netdata/netdata/issues/17283))
- Go.d: sd docker: create multiple nginx configs ([#17285](https://github.com/netdata/netdata/issues/17285))
- Go.d: set User-Agent automatically when creating HTTP req ([#17286](https://github.com/netdata/netdata/issues/17286))
- Fix conditional for Amazon Linux 2023 in repoconfig spec file. ([#17056](https://github.com/netdata/netdata/issues/17056))
- Bump Wandalen/wretry.action from 1 to 2 ([#17246](https://github.com/netdata/netdata/issues/17246))
- Update Codeowners ([#17270](https://github.com/netdata/netdata/issues/17270))
- Fix action lints ([#17120](https://github.com/netdata/netdata/issues/17120))
- Go.d: don't create jobs with unknown module ([#17289](https://github.com/netdata/netdata/issues/17289))
- Fix positive and negative matches on labels ([#17290](https://github.com/netdata/netdata/issues/17290))
- Fix rrdlabels traversal ([#17292](https://github.com/netdata/netdata/issues/17292))
- Add label for cgroup ([#17156](https://github.com/netdata/netdata/issues/17156))
- Compatibility with Prometheus HELP ([#17191](https://github.com/netdata/netdata/issues/17191))
- Bump tj-actions/changed-files from 43 to 44 ([#17296](https://github.com/netdata/netdata/issues/17296))
- Update hpssa.chart.py ([#17294](https://github.com/netdata/netdata/issues/17294))
- Bump github.com/go-sql-driver/mysql from 1.8.0 to 1.8.1 in /src/go/collectors/go.d.plugin ([#17299](https://github.com/netdata/netdata/issues/17299))
- Bump github.com/vmware/govmomi from 0.36.1 to 0.36.2 in /src/go/collectors/go.d.plugin ([#17300](https://github.com/netdata/netdata/issues/17300))
- Go.d: sd local listeners: add unix socket job ([#17304](https://github.com/netdata/netdata/issues/17304))
- Fix repoconfig publishing. ([#17288](https://github.com/netdata/netdata/issues/17288))
- Add Fedora 40 to CI, packages, and support policy. ([#17282](https://github.com/netdata/netdata/issues/17282))
- Go.d: sd ll: add mysql socket jobs ([#17305](https://github.com/netdata/netdata/issues/17305))
- Bump Wandalen/wretry.action from 2 to 3 ([#17297](https://github.com/netdata/netdata/issues/17297))
- Bump actions/add-to-project from 0.6.1 to 1.0.0 ([#17298](https://github.com/netdata/netdata/issues/17298))
- Fix handling of post-release workflows triggered by Docker workflow. ([#17306](https://github.com/netdata/netdata/issues/17306))
- Update metadata frequency ([#17307](https://github.com/netdata/netdata/issues/17307))
- Fix SWAP pages ([#17295](https://github.com/netdata/netdata/issues/17295))
- Dyncfg function on parents should not require any access rights ([#17310](https://github.com/netdata/netdata/issues/17310))
- Fix assorted issues in the Docker build process. ([#17312](https://github.com/netdata/netdata/issues/17312))
- Drop legacy dbengine support ([#17315](https://github.com/netdata/netdata/issues/17315))
- Set min thread stack size to 1 MB ([#17317](https://github.com/netdata/netdata/issues/17317))
- Add basic support for dinit in our system service handling code. ([#16836](https://github.com/netdata/netdata/issues/16836))
- Drop generic bitmap implementation. ([#17322](https://github.com/netdata/netdata/issues/17322))
- Remove old overview infrastructure and add home tab doc ([#17323](https://github.com/netdata/netdata/issues/17323))
- Go.d: schemas: add missing "body" and "method" ([#17325](https://github.com/netdata/netdata/issues/17325))
- Bump github.com/likexian/whois from 1.15.1 to 1.15.2 in /src/go/collectors/go.d.plugin ([#17337](https://github.com/netdata/netdata/issues/17337))
- Bump github.com/prometheus/common from 0.51.1 to 0.52.2 in /src/go/collectors/go.d.plugin ([#17335](https://github.com/netdata/netdata/issues/17335))
- Bump github.com/vmware/govmomi from 0.36.2 to 0.36.3 in /src/go/collectors/go.d.plugin ([#17336](https://github.com/netdata/netdata/issues/17336))
- Fix proc-power-supply charts family ([#17338](https://github.com/netdata/netdata/issues/17338))
- Remove unused install_go.sh ([#17339](https://github.com/netdata/netdata/issues/17339))
- Go.d: schema windows: fix url placeholder scheme ([#17326](https://github.com/netdata/netdata/issues/17326))
- Fix invalid var in prepare_offline_install_source() ([#17342](https://github.com/netdata/netdata/issues/17342))
- Call with resize true when dictionary has DICT_OPTION_INDEX_HASHTABLE ([#17316](https://github.com/netdata/netdata/issues/17316))
- Increase number of pages per extent in dbengine ([#17343](https://github.com/netdata/netdata/issues/17343))
- Add intel_gpu_top collector ([#17344](https://github.com/netdata/netdata/issues/17344))
- Add try except ([#17352](https://github.com/netdata/netdata/issues/17352))
- Regenerate integrations.js ([#17353](https://github.com/netdata/netdata/issues/17353))
- Add intel_gpu_top to apps_groups.conf ([#17354](https://github.com/netdata/netdata/issues/17354))
- Add prerequisites to go.d/intelgpu meta ([#17355](https://github.com/netdata/netdata/issues/17355))
- Regenerate integrations.js ([#17356](https://github.com/netdata/netdata/issues/17356))
- Check for Snappy only when required. ([#17319](https://github.com/netdata/netdata/issues/17319))
- Enable Sentry for Ubuntu and Debian native packages. ([#17327](https://github.com/netdata/netdata/issues/17327))
- Uninstaller: remove LaunchDaemons plist file (macOS) ([#17357](https://github.com/netdata/netdata/issues/17357))
- Make file if not found ([#17359](https://github.com/netdata/netdata/issues/17359))
- Revised node-tab document ([#17348](https://github.com/netdata/netdata/issues/17348))
- Regenerate integrations.js ([#17360](https://github.com/netdata/netdata/issues/17360))
- Go.d intelgpu: rename label engine to engine_class ([#17361](https://github.com/netdata/netdata/issues/17361))
- Regenerate integrations.js ([#17362](https://github.com/netdata/netdata/issues/17362))
- Add Okta SSO integration ([#17351](https://github.com/netdata/netdata/issues/17351))
- Regenerate integrations.js ([#17364](https://github.com/netdata/netdata/issues/17364))
- Move bundling of JSON-C to CMake. ([#17207](https://github.com/netdata/netdata/issues/17207))
- Skip Go code in CI if it hasn’t changed. ([#17077](https://github.com/netdata/netdata/issues/17077))
- Kickstart: Add detection of multiple concurrent installs. ([#16555](https://github.com/netdata/netdata/issues/16555))
- Move vendoring of Sentry to it’s own module and switch to using Git instead of the releases page. ([#17358](https://github.com/netdata/netdata/issues/17358))
- Fix required toolchain version for Go code. ([#17366](https://github.com/netdata/netdata/issues/17366))
- Fix logic in detection of multiple installs. ([#17369](https://github.com/netdata/netdata/issues/17369))
- Go.d intelgpu: uncomment stock config and update meta setup prerequisites ([#17370](https://github.com/netdata/netdata/issues/17370))
- Add collector to monitor ZFS pools space usage ([#17367](https://github.com/netdata/netdata/issues/17367))
- Regenerate integrations.js ([#17371](https://github.com/netdata/netdata/issues/17371))
- Canonicalize paths before comparison when checking for multiple installs. ([#17373](https://github.com/netdata/netdata/issues/17373))
- Fix typo in kickstart script.
- Go.d zfspool minor schema and meta fixes ([#17372](https://github.com/netdata/netdata/issues/17372))
- Regenerate integrations.js ([#17375](https://github.com/netdata/netdata/issues/17375))
- Metrics tab doc ([#17365](https://github.com/netdata/netdata/issues/17365))
- Go.d intelgpu meta update icon ([#17378](https://github.com/netdata/netdata/issues/17378))
- Regenerate integrations.js ([#17379](https://github.com/netdata/netdata/issues/17379))
- Add intel_gpu_top to ndsudo ([#17376](https://github.com/netdata/netdata/issues/17376))
- Hardcode ndsudo PATH ([#17377](https://github.com/netdata/netdata/issues/17377))
- Lowercase word ([#17381](https://github.com/netdata/netdata/issues/17381))
- Go.d intelgpu switch to using ndsudo ([#17380](https://github.com/netdata/netdata/issues/17380))
- Regenerate integrations.js ([#17382](https://github.com/netdata/netdata/issues/17382))
- Remove seemingly dead logging related code from libnetdata. ([#17320](https://github.com/netdata/netdata/issues/17320))
- Add Ubuntu 24.04 to CI, package builds, and support policy. ([#17281](https://github.com/netdata/netdata/issues/17281))
- Add repo config for Amazon Linux 2023. ([#17330](https://github.com/netdata/netdata/issues/17330))
- Go.d intelgpu: use cmd.Wait instead of process.Wait ([#17384](https://github.com/netdata/netdata/issues/17384))
- Go.d nvme: drop using `nvme` directly ([#17386](https://github.com/netdata/netdata/issues/17386))
- Regenerate integrations.js ([#17387](https://github.com/netdata/netdata/issues/17387))
- Fix percentages on alerts ([#17391](https://github.com/netdata/netdata/issues/17391))
- Fix mis-labeling of Ubuntu codenames in distros.yml
- Go.d nvme meta: remove sudoers prereq ([#17395](https://github.com/netdata/netdata/issues/17395))
- Regenerate integrations.js ([#17396](https://github.com/netdata/netdata/issues/17396))
- Fix publishing Docker images to Docker Hub. ([#17397](https://github.com/netdata/netdata/issues/17397))
- Add simple collector to monitor lvm thin volumes space usage ([#17394](https://github.com/netdata/netdata/issues/17394))
- Regenerate integrations.js ([#17399](https://github.com/netdata/netdata/issues/17399))
- Apply first alarms, then alarm templates ([#17398](https://github.com/netdata/netdata/issues/17398))
- Bump actions/add-to-project from 1.0.0 to 1.0.1 ([#17402](https://github.com/netdata/netdata/issues/17402))
- Bump go.mongodb.org/mongo-driver from 1.14.0 to 1.15.0 in /src/go/collectors/go.d.plugin ([#17406](https://github.com/netdata/netdata/issues/17406))
- Bump github.com/docker/docker from 26.0.0+incompatible to 26.0.1+incompatible in /src/go/collectors/go.d.plugin ([#17403](https://github.com/netdata/netdata/issues/17403))
- Bump github.com/prometheus/common from 0.52.2 to 0.52.3 in /src/go/collectors/go.d.plugin ([#17405](https://github.com/netdata/netdata/issues/17405))
- Add option to cleanup health_log table  ([#17385](https://github.com/netdata/netdata/issues/17385))
- Bump tj-actions/changed-files from 42 to 44 ([#17401](https://github.com/netdata/netdata/issues/17401))
- Bump github.com/vmware/govmomi from 0.36.3 to 0.37.0 in /src/go/collectors/go.d.plugin ([#17404](https://github.com/netdata/netdata/issues/17404))
- Gh labeler: go.d.plugin rm suffix ([#17407](https://github.com/netdata/netdata/issues/17407))
- Split Sentry enablement to be per-architecture. ([#17383](https://github.com/netdata/netdata/issues/17383))
- Logs tab docs in dashboard section ([#17408](https://github.com/netdata/netdata/issues/17408))
- Function docs edits ([#17390](https://github.com/netdata/netdata/issues/17390))
- Add fallback logic in installer for fetching files. ([#17045](https://github.com/netdata/netdata/issues/17045))
- Go.d sd ll set max_time_series for prometheus/clickhouse ([#17415](https://github.com/netdata/netdata/issues/17415))
- Rewrite megacli in go ([#17410](https://github.com/netdata/netdata/issues/17410))
- Go.d megacli fix meta metrics_description ([#17418](https://github.com/netdata/netdata/issues/17418))
- Alert transitions code cleanup ([#17103](https://github.com/netdata/netdata/issues/17103))
- Go.d megacli health fix megacli_phys_drive_media_errors ([#17419](https://github.com/netdata/netdata/issues/17419))
- Remove python.d/megacli ([#17417](https://github.com/netdata/netdata/issues/17417))
- Regenerate integrations.js ([#17416](https://github.com/netdata/netdata/issues/17416))
- Regenerate integrations.js ([#17425](https://github.com/netdata/netdata/issues/17425))
- Add a build option to disable all optional features by default. ([#17309](https://github.com/netdata/netdata/issues/17309))
- Explicitly require systemd for systemd journal plugin. ([#17313](https://github.com/netdata/netdata/issues/17313))
- Cncf changed the url ([#17427](https://github.com/netdata/netdata/issues/17427))
- Go.d rewrite python.d/adaptec_raid ([#17428](https://github.com/netdata/netdata/issues/17428))
- Go.d adaptec fix meta ([#17430](https://github.com/netdata/netdata/issues/17430))
- Remove python.d/adaptec_raid ([#17429](https://github.com/netdata/netdata/issues/17429))
- Regenerate integrations.js ([#17432](https://github.com/netdata/netdata/issues/17432))
- Go.d fix adaptec/megacli meta name ([#17433](https://github.com/netdata/netdata/issues/17433))
- Regenerate integrations.js ([#17434](https://github.com/netdata/netdata/issues/17434))
- Fix coverity issue 425241 ([#17424](https://github.com/netdata/netdata/issues/17424))
- Address cmake compilation ([#17314](https://github.com/netdata/netdata/issues/17314))
- Start watcher thread after fork ([#17436](https://github.com/netdata/netdata/issues/17436))
- Indent generated files ([#17423](https://github.com/netdata/netdata/issues/17423))
- Regenerate integrations.js ([#17437](https://github.com/netdata/netdata/issues/17437))
- Go.d mega/adaptec meta add alerts ([#17438](https://github.com/netdata/netdata/issues/17438))
- Regenerate integrations.js ([#17439](https://github.com/netdata/netdata/issues/17439))
- Associate sentry events with guid. ([#17420](https://github.com/netdata/netdata/issues/17420))
- Add documentation for VictorOps cloud notifications ([#17445](https://github.com/netdata/netdata/issues/17445))
- Regenerate integrations.js ([#17446](https://github.com/netdata/netdata/issues/17446))
- Dashboards doc edits ([#17409](https://github.com/netdata/netdata/issues/17409))
- Bump github.com/docker/docker from 26.0.1+incompatible to 26.0.2+incompatible in /src/go/collectors/go.d.plugin ([#17447](https://github.com/netdata/netdata/issues/17447))
- Timex is not supported on windows. ([#17443](https://github.com/netdata/netdata/issues/17443))
- Reconnect to the cloud when resuming from suspension ([#17444](https://github.com/netdata/netdata/issues/17444))
- Bump github.com/prometheus/common from 0.52.3 to 0.53.0 in /src/go/collectors/go.d.plugin ([#17448](https://github.com/netdata/netdata/issues/17448))
- Bump github.com/miekg/dns from 1.1.58 to 1.1.59 in /src/go/collectors/go.d.plugin ([#17449](https://github.com/netdata/netdata/issues/17449))
- Bump github.com/vmware/govmomi from 0.37.0 to 0.37.1 in /src/go/collectors/go.d.plugin ([#17451](https://github.com/netdata/netdata/issues/17451))
- Ndsudo add storcli ([#17455](https://github.com/netdata/netdata/issues/17455))
- Go.d add storcli collector ([#17454](https://github.com/netdata/netdata/issues/17454))
- Regenerate integrations.js ([#17458](https://github.com/netdata/netdata/issues/17458))
- Go.d storcli update ([#17460](https://github.com/netdata/netdata/issues/17460))
- Regenerate integrations.js ([#17461](https://github.com/netdata/netdata/issues/17461))
- Go.d add hddtemp ([#17462](https://github.com/netdata/netdata/issues/17462))
- Regenerate integrations.js ([#17464](https://github.com/netdata/netdata/issues/17464))
- Remove python.d/hddtemp ([#17463](https://github.com/netdata/netdata/issues/17463))
- Regenerate integrations.js ([#17465](https://github.com/netdata/netdata/issues/17465))
- Add section for regenerate claiming token ([#17457](https://github.com/netdata/netdata/issues/17457))
- Bump github.com/likexian/whois-parser from 1.24.12 to 1.24.15 in /src/go/collectors/go.d.plugin ([#17469](https://github.com/netdata/netdata/issues/17469))
- Go.d add sensors ([#17466](https://github.com/netdata/netdata/issues/17466))
- Regenerate integrations.js ([#17472](https://github.com/netdata/netdata/issues/17472))
- Remove python.d/sensors ([#17473](https://github.com/netdata/netdata/issues/17473))
- Regenerate integrations.js ([#17477](https://github.com/netdata/netdata/issues/17477))
- Bump go toolchain to v1.22.0 in check-for-go-toolchain.sh ([#17474](https://github.com/netdata/netdata/issues/17474))
- Move dashboards file ([#17476](https://github.com/netdata/netdata/issues/17476))
- Go.d windows add "vnode" to config schema ([#17478](https://github.com/netdata/netdata/issues/17478))
- K8s doc edits ([#17471](https://github.com/netdata/netdata/issues/17471))
- Update Libbpf to 1.4 ([#17470](https://github.com/netdata/netdata/issues/17470))
- Move dashboards file ([#17479](https://github.com/netdata/netdata/issues/17479))
- Go.d pkg prometheus improve parsing err msg ([#17480](https://github.com/netdata/netdata/issues/17480))
- Go.d nvidia_smi: use XML format by default ([#17481](https://github.com/netdata/netdata/issues/17481))
- Add power consumption metric to power supply monitoring module ([#17329](https://github.com/netdata/netdata/issues/17329))
- Regenerate integrations.js ([#17483](https://github.com/netdata/netdata/issues/17483))
- Move netdata charts documentation to proper folder ([#17486](https://github.com/netdata/netdata/issues/17486))
- Fix maintainer documentation to reflect the new build system. ([#17441](https://github.com/netdata/netdata/issues/17441))
- Move netdata charts documentation to proper folder ([#17488](https://github.com/netdata/netdata/issues/17488))
- Go.d update go.mod 1.22.0 and update some packages ([#17489](https://github.com/netdata/netdata/issues/17489))
- Regenerate integrations.js ([#17487](https://github.com/netdata/netdata/issues/17487))
- Move file ([#17490](https://github.com/netdata/netdata/issues/17490))
- Go.d fix intelgpu with update_every > 3 ([#17491](https://github.com/netdata/netdata/issues/17491))
- Public NC Spaces access fix ([#17492](https://github.com/netdata/netdata/issues/17492))
- Fix usage of sha256sum in static builds. ([#17495](https://github.com/netdata/netdata/issues/17495))
- Add generic sso authenciation page and SP-initiated SSO on Okta ([#17494](https://github.com/netdata/netdata/issues/17494))
- Fix labels name-only matching ([#17482](https://github.com/netdata/netdata/issues/17482))
- Add fail2ban-client to ndsudo ([#17499](https://github.com/netdata/netdata/issues/17499))
- Better redirect ([#17500](https://github.com/netdata/netdata/issues/17500))
- Add go.d fail2ban ([#17501](https://github.com/netdata/netdata/issues/17501))
- Remove python.d/fail2ban ([#17502](https://github.com/netdata/netdata/issues/17502))
- Sso improvements ([#17506](https://github.com/netdata/netdata/issues/17506))
- Regenerate integrations.js ([#17505](https://github.com/netdata/netdata/issues/17505))
- Move libbpf and eBPF CO-RE bundling into CMake. ([#17484](https://github.com/netdata/netdata/issues/17484))
- Additional SQL code cleanup ([#17503](https://github.com/netdata/netdata/issues/17503))
- Report correct error code when data insert fails ([#17508](https://github.com/netdata/netdata/issues/17508))
- Go.d traefik fix "got a SET but dimension does not exist" ([#17511](https://github.com/netdata/netdata/issues/17511))
- Work around MS’s broken infra in CI. ([#17513](https://github.com/netdata/netdata/issues/17513))
- Documentation edits ([#17509](https://github.com/netdata/netdata/issues/17509))
- Fix handling of kernel version detection in CMake. ([#17514](https://github.com/netdata/netdata/issues/17514))
- Clean up CMake build options. ([#17442](https://github.com/netdata/netdata/issues/17442))
- Add smartctl to ndsudo ([#17515](https://github.com/netdata/netdata/issues/17515))
- Move handling of legacy eBPF programs into CMake. ([#17512](https://github.com/netdata/netdata/issues/17512))
- Update CMake to request new behavior for all policies through v3.28.0. ([#17496](https://github.com/netdata/netdata/issues/17496))
- Go.d prometheus fix units for snmp_exporter ([#17524](https://github.com/netdata/netdata/issues/17524))
- Update the file ([#17522](https://github.com/netdata/netdata/issues/17522))
- Bump github.com/docker/docker from 26.0.2+incompatible to 26.1.0+incompatible in /src/go/collectors/go.d.plugin ([#17520](https://github.com/netdata/netdata/issues/17520))
- Anomaly Advisor documentation edits ([#17518](https://github.com/netdata/netdata/issues/17518))
- Fix _ndpath in detect_existing_install() ([#17527](https://github.com/netdata/netdata/issues/17527))
- Revert changes to ENABLE_CLOUD option. ([#17528](https://github.com/netdata/netdata/issues/17528))
- Don’t unnescesarily clean repo during static builds. ([#17530](https://github.com/netdata/netdata/issues/17530))
- Add features section requested on Okta review ([#17531](https://github.com/netdata/netdata/issues/17531))
- Bump github.com/likexian/whois from 1.15.2 to 1.15.3 in /src/go/collectors/go.d.plugin ([#17542](https://github.com/netdata/netdata/issues/17542))
- Fix platform EOL check issue assignment. ([#17544](https://github.com/netdata/netdata/issues/17544))
- Really fix platform EOL checks.
- Refresh the ML documentation and consolidate the two docs ([#17543](https://github.com/netdata/netdata/issues/17543))
- Notification section updates ([#17551](https://github.com/netdata/netdata/issues/17551))
- Try hardcode docs links ([#17553](https://github.com/netdata/netdata/issues/17553))
- Adjust eBPF code. ([#17550](https://github.com/netdata/netdata/issues/17550))
- Use CPack to generate Debian packages ([#17475](https://github.com/netdata/netdata/issues/17475))
- Additional code cleanup ([#17541](https://github.com/netdata/netdata/issues/17541))
- Go.d smartctl ([#17536](https://github.com/netdata/netdata/issues/17536))
- Regenerate integrations.js ([#17560](https://github.com/netdata/netdata/issues/17560))
- Add OIDC docs ([#17557](https://github.com/netdata/netdata/issues/17557))
- Regenerate integrations.js ([#17561](https://github.com/netdata/netdata/issues/17561))
- Go.d smartctl improve units ([#17564](https://github.com/netdata/netdata/issues/17564))
- Events tab documentation updates ([#17521](https://github.com/netdata/netdata/issues/17521))
- Go.d smartctl small improvements ([#17565](https://github.com/netdata/netdata/issues/17565))
- Go.d smartctl add meta setup prerequisites ([#17568](https://github.com/netdata/netdata/issues/17568))
- Regenerate integrations.js ([#17567](https://github.com/netdata/netdata/issues/17567))
- Clean up handling of compiler flags in CMake. ([#17532](https://github.com/netdata/netdata/issues/17532))
- Significantly simplify the protobuf handling in CMake. ([#17533](https://github.com/netdata/netdata/issues/17533))
- Detect and use ld.mold instead of the system linker. ([#17534](https://github.com/netdata/netdata/issues/17534))
- Go.d prometheus remove apostrophe in label values ([#17570](https://github.com/netdata/netdata/issues/17570))
- Remove go.d symbol/debug info with RelWithDebInfo ([#17569](https://github.com/netdata/netdata/issues/17569))
- Fix handling of netdata.conf on install in build system. ([#17572](https://github.com/netdata/netdata/issues/17572))
- Bump google-github-actions/setup-gcloud from 2.0.1 to 2.1.0 ([#16860](https://github.com/netdata/netdata/issues/16860))
- Bump google-github-actions/upload-cloud-storage from 2.0.0 to 2.1.0 ([#16859](https://github.com/netdata/netdata/issues/16859))
- Increase the message size to the spawn server ([#17566](https://github.com/netdata/netdata/issues/17566))
- Fix compilation without `dbengine` ([#17575](https://github.com/netdata/netdata/issues/17575))
- Update Netdata subscription plans documentation ([#17571](https://github.com/netdata/netdata/issues/17571))
- Regenerate integrations.js ([#17578](https://github.com/netdata/netdata/issues/17578))
- Fix table ([#17581](https://github.com/netdata/netdata/issues/17581))
- Cpack fixes ([#17576](https://github.com/netdata/netdata/issues/17576))
- Fix invalid item in postinst script for Netdata package. ([#17580](https://github.com/netdata/netdata/issues/17580))
- Fix ndsudo setuid bit for static builds ([#17583](https://github.com/netdata/netdata/issues/17583))
- Fix DEB package conflict entries. ([#17584](https://github.com/netdata/netdata/issues/17584))
- Docs: Add Ubuntu AArch64 that is missing from the list ([#17538](https://github.com/netdata/netdata/issues/17538))
- Go.d/python.d respect all netdata log levels ([#17587](https://github.com/netdata/netdata/issues/17587))
- Fix handling of service startup in DEB packages. ([#17589](https://github.com/netdata/netdata/issues/17589))
- Bump github.com/docker/docker from 26.1.0+incompatible to 26.1.1+incompatible in /src/go/collectors/go.d.plugin ([#17592](https://github.com/netdata/netdata/issues/17592))
- Bump golang.org/x/text from 0.14.0 to 0.15.0 in /src/go/collectors/go.d.plugin ([#17596](https://github.com/netdata/netdata/issues/17596))
- Go.d postgres: reset table/index bloat stats before querying ([#17598](https://github.com/netdata/netdata/issues/17598))
- Fix handling of vendored eBPF code in CMake. ([#17556](https://github.com/netdata/netdata/issues/17556))
- Update eBPF code to v1.4.1. ([#17591](https://github.com/netdata/netdata/issues/17591))
- Remove python.d/smartd_log ([#17600](https://github.com/netdata/netdata/issues/17600))
- Make offline installs properly offline again. ([#17602](https://github.com/netdata/netdata/issues/17602))
- Regenerate integrations.js ([#17603](https://github.com/netdata/netdata/issues/17603))
- Bump jinja2 from 3.1.3 to 3.1.4 in /packaging/dag ([#17607](https://github.com/netdata/netdata/issues/17607))
- Bump golang.org/x/net from 0.24.0 to 0.25.0 in /src/go/collectors/go.d.plugin ([#17609](https://github.com/netdata/netdata/issues/17609))
- Go.d systemdunits add unit files state ([#17606](https://github.com/netdata/netdata/issues/17606))
- Regenerate integrations.js ([#17610](https://github.com/netdata/netdata/issues/17610))
- Go.d dyncfg return 200 on Enable for running jobs ([#17611](https://github.com/netdata/netdata/issues/17611))
- Add option to limit architectures for offline installs. ([#17604](https://github.com/netdata/netdata/issues/17604))
- Reset health when children disconnect ([#17612](https://github.com/netdata/netdata/issues/17612))
- Add update every to json schema ([#17613](https://github.com/netdata/netdata/issues/17613))
- Remove contrib now that we use cpack for DEB packages ([#17614](https://github.com/netdata/netdata/issues/17614))
- Log to journal all transitions ([#17618](https://github.com/netdata/netdata/issues/17618))
- Go.d systemdunits fix unit files selector ([#17622](https://github.com/netdata/netdata/issues/17622))
- Go.d filecheck update to create a chart per instance ([#17624](https://github.com/netdata/netdata/issues/17624))
- Regenerate integrations.js ([#17626](https://github.com/netdata/netdata/issues/17626))
- Python.d remove bind_rndc ([#17628](https://github.com/netdata/netdata/issues/17628))
- Go.d isc_dhcpd create a chart for each pool ([#17629](https://github.com/netdata/netdata/issues/17629))
- Regenerate integrations.js ([#17630](https://github.com/netdata/netdata/issues/17630))
- Improve handling of an alert that transitions to the REMOVED state ([#17621](https://github.com/netdata/netdata/issues/17621))
- Bump github.com/docker/docker from 26.1.1+incompatible to 26.1.2+incompatible in /src/go/collectors/go.d.plugin ([#17631](https://github.com/netdata/netdata/issues/17631))
- Health update isc dhcp alarms ([#17634](https://github.com/netdata/netdata/issues/17634))
- Add pcre2 to install-required-packages "netdata" for macOS ([#17633](https://github.com/netdata/netdata/issues/17633))
- Ndsudo add ssacli ([#17635](https://github.com/netdata/netdata/issues/17635))
- Add Sentry support to new CPack packages. ([#17627](https://github.com/netdata/netdata/issues/17627))
- Add valkey to apps_groups.conf ([#17639](https://github.com/netdata/netdata/issues/17639))
- Logs: add ND_ALERT_STATUS to facets ([#17641](https://github.com/netdata/netdata/issues/17641))
- Go.d ping add missing setting to schema ([#17642](https://github.com/netdata/netdata/issues/17642))
- Fix incorrect bind failure warning ([#17643](https://github.com/netdata/netdata/issues/17643))
- Bump github.com/vmware/govmomi from 0.37.1 to 0.37.2 in /src/go/collectors/go.d.plugin ([#17644](https://github.com/netdata/netdata/issues/17644))
- Remove doc and consolidate info to main section page ([#17645](https://github.com/netdata/netdata/issues/17645))
- Go.d hpssa ([#17637](https://github.com/netdata/netdata/issues/17637))
- Python.d remove hpssa ([#17638](https://github.com/netdata/netdata/issues/17638))
- Regenerate integrations.js ([#17652](https://github.com/netdata/netdata/issues/17652))
- Update the claim readme ([#17646](https://github.com/netdata/netdata/issues/17646))
- Go.d hpssa fix cache battery chart ctx ([#17654](https://github.com/netdata/netdata/issues/17654))
- Regenerate integrations.js ([#17655](https://github.com/netdata/netdata/issues/17655))
- Update libbpf ([#17650](https://github.com/netdata/netdata/issues/17650))
- Go.d cockroachdb fix calculation ([#17659](https://github.com/netdata/netdata/issues/17659))
- Files movearound ([#17653](https://github.com/netdata/netdata/issues/17653))
- Regenerate integrations.js ([#17660](https://github.com/netdata/netdata/issues/17660))
- Go.d update config dirs ([#17661](https://github.com/netdata/netdata/issues/17661))
- Files movearound ([#17662](https://github.com/netdata/netdata/issues/17662))
- Remove Fedora 38 from CI. ([#17548](https://github.com/netdata/netdata/issues/17548))
- Support offline installs in the updater code. ([#17648](https://github.com/netdata/netdata/issues/17648))
- Python.d remove litespeed ([#17663](https://github.com/netdata/netdata/issues/17663))
- Go.d litespeed ([#17665](https://github.com/netdata/netdata/issues/17665))
- Regenerate integrations.js ([#17668](https://github.com/netdata/netdata/issues/17668))
- Include the Host in the HTTP header ([#17670](https://github.com/netdata/netdata/issues/17670))
- Fix broken links and links pointing to Learn ([#17675](https://github.com/netdata/netdata/issues/17675))
- Fix CentOS 7 builds for ML. ([#17667](https://github.com/netdata/netdata/issues/17667))
- Regenerate integrations.js ([#17676](https://github.com/netdata/netdata/issues/17676))
- Windows Support Phase 1 ([#17497](https://github.com/netdata/netdata/issues/17497))
- Correctly handle required compilation flags for dependencies. ([#17664](https://github.com/netdata/netdata/issues/17664))
- Support to WolfSSL (Step 1) ([#17516](https://github.com/netdata/netdata/issues/17516))
- Add go.d/rspamd ([#17679](https://github.com/netdata/netdata/issues/17679))
- Add rspamd to apps_groups.conf ([#17674](https://github.com/netdata/netdata/issues/17674))
- Re-enable ML for RHEL 7 and AL 2 RPM packages. ([#17682](https://github.com/netdata/netdata/issues/17682))
- Go.d sd fix rspamd classify match ([#17686](https://github.com/netdata/netdata/issues/17686))
- Regenerate integrations.js ([#17683](https://github.com/netdata/netdata/issues/17683))
- Fix compilation without h2o, cloud enabled ([#17673](https://github.com/netdata/netdata/issues/17673))
- Fix timex slow shutdown ([#17688](https://github.com/netdata/netdata/issues/17688))
- Check for empty dimension id from a plugin ([#17690](https://github.com/netdata/netdata/issues/17690))
- Fall back to querying libc.so.6 if ldd can’t detect libc implementation. ([#17657](https://github.com/netdata/netdata/issues/17657))
- Properly detect attribute format types ([#17685](https://github.com/netdata/netdata/issues/17685))
- Dyncfg files on disk do not contain colons ([#17694](https://github.com/netdata/netdata/issues/17694))
- Go.d dyncfg add userconfig action ([#17684](https://github.com/netdata/netdata/issues/17684))
- Fix sender parsing when receiving remote input ([#17696](https://github.com/netdata/netdata/issues/17696))
- Revert "Support to WolfSSL (Step 1)" ([#17697](https://github.com/netdata/netdata/issues/17697))
- DYNCFG: add userconfig action ([#17692](https://github.com/netdata/netdata/issues/17692))
- Go.d dyncfg rm space yaml contentType ([#17698](https://github.com/netdata/netdata/issues/17698))
- Do not specify linker in compilation flags. ([#17677](https://github.com/netdata/netdata/issues/17677))
- Corrected grammar and mispelling ([#17699](https://github.com/netdata/netdata/issues/17699))
- Go.d fix some JB code inspection issues ([#17702](https://github.com/netdata/netdata/issues/17702))
- Regenerate integrations.js ([#17701](https://github.com/netdata/netdata/issues/17701))
- Some markdown fixes ([#17703](https://github.com/netdata/netdata/issues/17703))
- Bump k8s.io/client-go from 0.30.0 to 0.30.1 in /src/go/collectors/go.d.plugin ([#17708](https://github.com/netdata/netdata/issues/17708))
- Bump github.com/likexian/whois-parser from 1.24.15 to 1.24.16 in /src/go/collectors/go.d.plugin ([#17710](https://github.com/netdata/netdata/issues/17710))
- Bump github.com/docker/docker from 26.1.2+incompatible to 26.1.3+incompatible in /src/go/collectors/go.d.plugin ([#17706](https://github.com/netdata/netdata/issues/17706))
- Fix on link ([#17712](https://github.com/netdata/netdata/issues/17712))
- Gha labeler add collectors/windows ([#17711](https://github.com/netdata/netdata/issues/17711))
- Fix multipler on Windows ("Memory") ([#17705](https://github.com/netdata/netdata/issues/17705))
- Add agent CLI command to remove a stale node ([#17691](https://github.com/netdata/netdata/issues/17691))
- Fix compilation with disable-cloud ([#17714](https://github.com/netdata/netdata/issues/17714))
- Rename a variable in FreeIMPI (WolfSSL support) ([#17687](https://github.com/netdata/netdata/issues/17687))
- Fix mongodb default config indentation ([#17715](https://github.com/netdata/netdata/issues/17715))
- Go.d weblog ignore reqProcTime on HTTP 101 ([#17717](https://github.com/netdata/netdata/issues/17717))
- Fix proc plugin disk_avgsz ([#17718](https://github.com/netdata/netdata/issues/17718))
- Change links to relative links in one doc ([#17719](https://github.com/netdata/netdata/issues/17719))
- PR to change absolute links to relative ([#17720](https://github.com/netdata/netdata/issues/17720))
- Regenerate integrations.js ([#17721](https://github.com/netdata/netdata/issues/17721))
- Minor fix on link ([#17722](https://github.com/netdata/netdata/issues/17722))
- Fix handling of OpenSSL linking on macOS ([#17535](https://github.com/netdata/netdata/issues/17535))
- Make CMake options for platform-dependent plugins depend on being build for a supported platform. ([#17517](https://github.com/netdata/netdata/issues/17517))
- Go.d systemdunits add "skip_transient" ([#17725](https://github.com/netdata/netdata/issues/17725))
- Regenerate integrations.js ([#17726](https://github.com/netdata/netdata/issues/17726))
- Grammar pass on alerts and notifications dir ([#17729](https://github.com/netdata/netdata/issues/17729))
- Clean up DEB package dependencies. ([#17680](https://github.com/netdata/netdata/issues/17680))
- Add alert meta info ([#17730](https://github.com/netdata/netdata/issues/17730))
- Include the Host in the HTTP header (mqtt) ([#17731](https://github.com/netdata/netdata/issues/17731))
- Grammar pass on docs ([#17735](https://github.com/netdata/netdata/issues/17735))
- Update netdata-agent-security.md ([#17738](https://github.com/netdata/netdata/issues/17738))
- Simplify and unify the way we are handling versions. ([#17693](https://github.com/netdata/netdata/issues/17693))
- Fix ebpf cgroup swap context ([#17740](https://github.com/netdata/netdata/issues/17740))
- Fix clickhouse in apps groups ([#17742](https://github.com/netdata/netdata/issues/17742))
- Ensure that the choice of compiler and target is passed to sub-projects. ([#17732](https://github.com/netdata/netdata/issues/17732))
- Remove Alpine 3.16 from CI. ([#17547](https://github.com/netdata/netdata/issues/17547))
- Win processes ("System" name) ([#17704](https://github.com/netdata/netdata/issues/17704))
- Add go.d clickhouse ([#17743](https://github.com/netdata/netdata/issues/17743))
- Regenerate integrations.js ([#17748](https://github.com/netdata/netdata/issues/17748))
- Remove unused go.d/prometheus meta file ([#17749](https://github.com/netdata/netdata/issues/17749))
- Go.d clickhouse add running queries ([#17751](https://github.com/netdata/netdata/issues/17751))
- Regenerate integrations.js ([#17752](https://github.com/netdata/netdata/issues/17752))
- Mention how to remove highlight in documentation ([#17755](https://github.com/netdata/netdata/issues/17755))
- Collecting metrics docs grammar pass ([#17736](https://github.com/netdata/netdata/issues/17736))
- Go.d clickhouse add more metrics ([#17756](https://github.com/netdata/netdata/issues/17756))
- Regenerate integrations.js ([#17758](https://github.com/netdata/netdata/issues/17758))
- Collecting metrics docs section simplification ([#17757](https://github.com/netdata/netdata/issues/17757))
- Simplify installation page ([#17759](https://github.com/netdata/netdata/issues/17759))
- Add clickhouse alerts ([#17760](https://github.com/netdata/netdata/issues/17760))
- Regenerate integrations.js ([#17761](https://github.com/netdata/netdata/issues/17761))
- Schedule a node info on label reload ([#17762](https://github.com/netdata/netdata/issues/17762))
- Go.d sd local-listeners fix extractComm ([#17763](https://github.com/netdata/netdata/issues/17763))
- Fix version for go.d plugin ([#17764](https://github.com/netdata/netdata/issues/17764))
- Fix DEB package builds. ([#17765](https://github.com/netdata/netdata/issues/17765))
- Docs: simplify claiming readme part1 ([#17771](https://github.com/netdata/netdata/issues/17771))
- Docs fix "Prevent the double access.log" ([#17773](https://github.com/netdata/netdata/issues/17773))
- Netdata Cloud docs section edits ([#17768](https://github.com/netdata/netdata/issues/17768))
- Proc/diskstats and diskspace: remove "ignore zero metrics" ([#17775](https://github.com/netdata/netdata/issues/17775))
- Fix links ([#17779](https://github.com/netdata/netdata/issues/17779))
- Remove "ignore zero metrics" from proc network modules ([#17776](https://github.com/netdata/netdata/issues/17776))
- Go.d phpfpm switch to github.com/kanocz/fcgi_client ([#17784](https://github.com/netdata/netdata/issues/17784))
- Rm "ignore zero metrics" proc meminfo ([#17781](https://github.com/netdata/netdata/issues/17781))
- Docs fix statsd conf dir ([#17785](https://github.com/netdata/netdata/issues/17785))
- Change "War Room" to "Room" and other docs changes ([#17783](https://github.com/netdata/netdata/issues/17783))
- Regenerate integrations.js ([#17786](https://github.com/netdata/netdata/issues/17786))
- Restructure packaging related files to better reflect usage. ([#17678](https://github.com/netdata/netdata/issues/17678))
- Proc/net_dev: remove "ignore zero metrics" ([#17789](https://github.com/netdata/netdata/issues/17789))
- Use correct path for package files. ([#17793](https://github.com/netdata/netdata/issues/17793))
- Use semver releases with sentry. ([#17746](https://github.com/netdata/netdata/issues/17746))
- Correctly handle eBPF check in package test script. ([#17794](https://github.com/netdata/netdata/issues/17794))
- EBPF OOMKills adjust and fixes. ([#17734](https://github.com/netdata/netdata/issues/17734))
- Cgroup plugin: simplify and remove "ignore zero metrics" ([#17795](https://github.com/netdata/netdata/issues/17795))
- Upgrade sqlite version to 3.45.3 ([#17769](https://github.com/netdata/netdata/issues/17769))
- Fix cgroups pressure ([#17800](https://github.com/netdata/netdata/issues/17800))
- Add Alpine 3.20 to CI checks. ([#17788](https://github.com/netdata/netdata/issues/17788))
- Remove CentOS Stream 8 from CI. ([#17599](https://github.com/netdata/netdata/issues/17599))
- Fix buffer overflow incgroups_detect_systemd() ([#17799](https://github.com/netdata/netdata/issues/17799))
- Bump github.com/prometheus/common from 0.53.0 to 0.54.0 in /src/go/collectors/go.d.plugin ([#17804](https://github.com/netdata/netdata/issues/17804))
- Remove "ingore zero metrics" from freebsd plugin ([#17805](https://github.com/netdata/netdata/issues/17805))
- Remove "ingore 0 metrics" from macos plugin ([#17803](https://github.com/netdata/netdata/issues/17803))
- Health: add go.d/lvm alerts ([#17807](https://github.com/netdata/netdata/issues/17807))
- Regenerate integrations.js ([#17808](https://github.com/netdata/netdata/issues/17808))
- EBPF contexts (part I) ([#17797](https://github.com/netdata/netdata/issues/17797))
- Fix ebpf units ([#17809](https://github.com/netdata/netdata/issues/17809))
- Change classification to "cls" since "cl" is clear count ([#17811](https://github.com/netdata/netdata/issues/17811))
- Remove "ignore 0 metrics" from tc/btrfs/ksm ([#17810](https://github.com/netdata/netdata/issues/17810))
- Update libbpf ([#17806](https://github.com/netdata/netdata/issues/17806))
- Fix typo: `round tripe` → `round trip` ([#17814](https://github.com/netdata/netdata/issues/17814))
- Regenerate integrations.js ([#17815](https://github.com/netdata/netdata/issues/17815))
- Remove "ignore 0 metrics" leftovers ([#17817](https://github.com/netdata/netdata/issues/17817))
- Fix coverity report ([#17820](https://github.com/netdata/netdata/issues/17820))
- Update contexts - eBPF.plugin (part II) ([#17819](https://github.com/netdata/netdata/issues/17819))
- Regenerate integrations.js ([#17822](https://github.com/netdata/netdata/issues/17822))
- Fix health alert load15 info ([#17823](https://github.com/netdata/netdata/issues/17823))
- Proper check for static_thread being NULL ([#17821](https://github.com/netdata/netdata/issues/17821))
- Claiming: add proxy to cloud.conf if set ([#17828](https://github.com/netdata/netdata/issues/17828))
- Add alert meta info (node index) ([#17818](https://github.com/netdata/netdata/issues/17818))
- Docs: claiming: rename connect button ([#17831](https://github.com/netdata/netdata/issues/17831))
- Fix order of loading schema files in dyncfg_get_schema_from ([#17829](https://github.com/netdata/netdata/issues/17829))
- Sockets VFS (context update) ([#17830](https://github.com/netdata/netdata/issues/17830))
- Health dyncfg userconfig: remove first newline ([#17834](https://github.com/netdata/netdata/issues/17834))
- Tc plugin simplify config ([#17835](https://github.com/netdata/netdata/issues/17835))
- Fix tc plugin undeclared vars ([#17839](https://github.com/netdata/netdata/issues/17839))
- Explicitly disable removed collectors in python.d.conf ([#17840](https://github.com/netdata/netdata/issues/17840))
- Proc net dev: simplify config ([#17837](https://github.com/netdata/netdata/issues/17837))
- Use bundled protobuf for openSUSE packages. ([#17827](https://github.com/netdata/netdata/issues/17827))
- Hide sqlite config (netdata.conf) ([#17838](https://github.com/netdata/netdata/issues/17838))
- Dyncfg doc ([#17832](https://github.com/netdata/netdata/issues/17832))
- Aclk: move "proxy" from "netdata.conf" to "cloud.conf" ([#17836](https://github.com/netdata/netdata/issues/17836))
- Support time based retention ([#17413](https://github.com/netdata/netdata/issues/17413))
- Properly initialize spinlock in ARAL. ([#17844](https://github.com/netdata/netdata/issues/17844))
- Fix compilation without dbengine ([#17843](https://github.com/netdata/netdata/issues/17843))
- Remove unused variable ([#17846](https://github.com/netdata/netdata/issues/17846))
- Update dbengine retention chart family and priority ([#17847](https://github.com/netdata/netdata/issues/17847))
- Fix: check memory mode before creating dbengine retention chart ([#17848](https://github.com/netdata/netdata/issues/17848))
- Fix tier statistics  ([#17849](https://github.com/netdata/netdata/issues/17849))
- Delay retention check until agent has initialized ([#17850](https://github.com/netdata/netdata/issues/17850))
- Bump golang.org/x/net from 0.25.0 to 0.26.0 in /src/go/collectors/go.d.plugin ([#17852](https://github.com/netdata/netdata/issues/17852))
- Bump github.com/docker/docker from 26.1.3+incompatible to 26.1.4+incompatible in /src/go/collectors/go.d.plugin ([#17851](https://github.com/netdata/netdata/issues/17851))
- Bump github.com/vmware/govmomi from 0.37.2 to 0.37.3 in /src/go/collectors/go.d.plugin ([#17854](https://github.com/netdata/netdata/issues/17854))
- Disable updater jitter when run from anacron. ([#17826](https://github.com/netdata/netdata/issues/17826))
- Create retention charts for higher tiers ([#17855](https://github.com/netdata/netdata/issues/17855))
- DYNCFG: health, generate userconfig for incomplete alerts ([#17859](https://github.com/netdata/netdata/issues/17859))
- Add improved handling for TLS certificates for static builds. ([#17605](https://github.com/netdata/netdata/issues/17605))
- Update CI infrastructure to publish to secondary packaging host. ([#17863](https://github.com/netdata/netdata/issues/17863))
- Fix typo in repoconfig packages workflow.
- Improve anacron detection in updater. ([#17862](https://github.com/netdata/netdata/issues/17862))
- Go.d phpfpm: debug log the response on decoding error ([#17870](https://github.com/netdata/netdata/issues/17870))
- Go.d phpfpm add config schema ([#17872](https://github.com/netdata/netdata/issues/17872))
- Fix updating release info when publishing nightly releases. ([#17871](https://github.com/netdata/netdata/issues/17871))
- Add openSUSE 15.6 to CI. ([#17865](https://github.com/netdata/netdata/issues/17865))
- Improve filecheck module metadata. ([#17874](https://github.com/netdata/netdata/issues/17874))
- Regenerate integrations.js ([#17877](https://github.com/netdata/netdata/issues/17877))
- Update Telegram Cloud notification docs to include new topic ID field ([#17873](https://github.com/netdata/netdata/issues/17873))
- RBAC for dynamic configuration documentation ([#17861](https://github.com/netdata/netdata/issues/17861))
- Regenerate integrations.js ([#17878](https://github.com/netdata/netdata/issues/17878))
- Make our LSB init script _actually_ LSB compliant. ([#17824](https://github.com/netdata/netdata/issues/17824))
- Update bundled UI to v6.138.0 ([#17879](https://github.com/netdata/netdata/issues/17879))
- Fix detect_libc in installer ([#17880](https://github.com/netdata/netdata/issues/17880))
- Improve agent shutdown ([#17868](https://github.com/netdata/netdata/issues/17868))
- Restore ML thread termination to original order ([#17885](https://github.com/netdata/netdata/issues/17885))
- Ndsudo update intel_gpu_top ([#17883](https://github.com/netdata/netdata/issues/17883))
- Go.d intelgpu add an option to select specific GPU ([#17884](https://github.com/netdata/netdata/issues/17884))
- Regenerate integrations.js ([#17886](https://github.com/netdata/netdata/issues/17886))
- Update netdata-charts.md ([#17888](https://github.com/netdata/netdata/issues/17888))
- Integrations make `<details>` open ([#17895](https://github.com/netdata/netdata/issues/17895))
- Regenerate integrations.js ([#17897](https://github.com/netdata/netdata/issues/17897))
- Go.d ll netlisteners add support for wildcard address ([#17896](https://github.com/netdata/netdata/issues/17896))
- Allow alerts to be created without too many requirements ([#17894](https://github.com/netdata/netdata/issues/17894))
- Improve ml thread termination during agent shutdown ([#17889](https://github.com/netdata/netdata/issues/17889))
- Fix Caddy setup in Install Netdata with Docker ([#17901](https://github.com/netdata/netdata/issues/17901))
- Add netdata journald configuration ([#17882](https://github.com/netdata/netdata/issues/17882))
- Sys_block_zram: don't use "/dev" ([#17900](https://github.com/netdata/netdata/issues/17900))
- Update x509check/metadata: add missing smtp schema ([#17908](https://github.com/netdata/netdata/issues/17908))
- Go.d whoisquery: check if exp date is empty ([#17911](https://github.com/netdata/netdata/issues/17911))
- Update nvme/metadata: add how to use in a docker ([#17909](https://github.com/netdata/netdata/issues/17909))
- Regenerate integrations.js ([#17910](https://github.com/netdata/netdata/issues/17910))
- Go.d whoisquery: try requesting extended data if no expiration date ([#17913](https://github.com/netdata/netdata/issues/17913))
- Bump github.com/miekg/dns from 1.1.59 to 1.1.61 in /src/go/collectors/go.d.plugin ([#17916](https://github.com/netdata/netdata/issues/17916))
- Bump github.com/jessevdk/go-flags from 1.5.0 to 1.6.1 in /src/go/collectors/go.d.plugin ([#17919](https://github.com/netdata/netdata/issues/17919))
- Bump go.mongodb.org/mongo-driver from 1.15.0 to 1.15.1 in /src/go/collectors/go.d.plugin ([#17917](https://github.com/netdata/netdata/issues/17917))
- Bump k8s.io/client-go from 0.30.1 to 0.30.2 in /src/go/collectors/go.d.plugin ([#17923](https://github.com/netdata/netdata/issues/17923))
- Go.d bump github.com/docker/docker v27.0.0+incompatible ([#17921](https://github.com/netdata/netdata/issues/17921))
- Go.d whoisquery: use Domain.ExpirationDateInTime if provided ([#17926](https://github.com/netdata/netdata/issues/17926))
- Systemd: start `netdata` after network is online ([#17906](https://github.com/netdata/netdata/issues/17906))
- Updater: handle json decode error in newer_commit_date() ([#17925](https://github.com/netdata/netdata/issues/17925))
- Go.d whoisquery fix defaults in config_schema ([#17932](https://github.com/netdata/netdata/issues/17932))
- Regenerate integrations.js ([#17933](https://github.com/netdata/netdata/issues/17933))
- Go.d smartctl: don't log found devices on every scan ([#17934](https://github.com/netdata/netdata/issues/17934))
- Adds GreptimeDB to prometheus metadata ([#17936](https://github.com/netdata/netdata/issues/17936))
- Go.d storcli add initial support for mpt3sas controllers ([#17938](https://github.com/netdata/netdata/issues/17938))
- Regenerate integrations.js ([#17937](https://github.com/netdata/netdata/issues/17937))
- Update bundled UI to v6.138.3 ([#17939](https://github.com/netdata/netdata/issues/17939))
- Add OpenSearch to exporting prom meta ([#17942](https://github.com/netdata/netdata/issues/17942))
- Regenerate integrations.js ([#17944](https://github.com/netdata/netdata/issues/17944))
- Update enable-an-exporting-connector.md ([#17943](https://github.com/netdata/netdata/issues/17943))
- Add "dmsetup status --target cache --noflush" to ndsudo ([#17946](https://github.com/netdata/netdata/issues/17946))
- Fix disk max calculation ([#17945](https://github.com/netdata/netdata/issues/17945))
- Fix indentation in go.d/dnsquery conf ([#17948](https://github.com/netdata/netdata/issues/17948))
- Fix warnings ([#17940](https://github.com/netdata/netdata/issues/17940))
- Move to using CPack for repository configuration packages. ([#17930](https://github.com/netdata/netdata/issues/17930))
- Fix repoconfig package uploads.
- Go.d add dmcache collector ([#17947](https://github.com/netdata/netdata/issues/17947))
- Regenerate integrations.js ([#17950](https://github.com/netdata/netdata/issues/17950))
- Rename env var for extended internal monitoring ([#17951](https://github.com/netdata/netdata/issues/17951))
- Remove Discord badge (rate limited by upstream service) ([#17953](https://github.com/netdata/netdata/issues/17953))
- Go.d systemdunits: remove "omitempty" tag from collect_unit_files ([#17956](https://github.com/netdata/netdata/issues/17956))
- Fix installing netdata journald conf for native packages ([#17954](https://github.com/netdata/netdata/issues/17954))
- Docs: add time-based retention to "Change how long Netdata stores metrics" ([#17957](https://github.com/netdata/netdata/issues/17957))
- Docs: clarify setting time/disk limits to 0 ([#17958](https://github.com/netdata/netdata/issues/17958))
- Fix apcupsd status ([#17960](https://github.com/netdata/netdata/issues/17960))
- Fix apcupsd status "slave" ([#17961](https://github.com/netdata/netdata/issues/17961))

## [1.45.0] - 2024-03-21

### Merged Pull Requests:

- Add README for gorilla ([#16553](https://github.com/netdata/netdata/issues/16553))
- Update README.md
- Revert "remove discourse badge from readme" ([#16560](https://github.com/netdata/netdata/issues/16560))
- Fix release metadata workflow ([#16563](https://github.com/netdata/netdata/issues/16563))
- Make  the systemd-journal mandatory package on Centos 7  and Amazon linux 2 ([#16562](https://github.com/netdata/netdata/issues/16562))
- Set "HOME" after switching to netdata user ([#16548](https://github.com/netdata/netdata/issues/16548))
- Remove openSUSE 15.4 from CI ([#16449](https://github.com/netdata/netdata/issues/16449))
- Remove fedora 37 from CI ([#16422](https://github.com/netdata/netdata/issues/16422))
- Fix for AMD GPU drm different format proc file ([#16561](https://github.com/netdata/netdata/issues/16561))
- Bump new version on the release changelog GHA ([#16551](https://github.com/netdata/netdata/issues/16551))
- Bump google-github-actions/auth from 1 to 2 ([#16526](https://github.com/netdata/netdata/issues/16526))
- Resolve issue on startup in servers with 1 core ([#16565](https://github.com/netdata/netdata/issues/16565))
- Fix cpu arch/ram/disk values in buildinfo ([#16567](https://github.com/netdata/netdata/issues/16567))
- Fix memory leak during host chart label cleanup ([#16568](https://github.com/netdata/netdata/issues/16568))
- Make debugfs exit on sigpipe ([#16569](https://github.com/netdata/netdata/issues/16569))
- Change the workflow on how we set the right permissions for perf-plugin ([#16558](https://github.com/netdata/netdata/issues/16558))
- Bump heinrichreimer/github-changelog-generator-action from 2.3 to 2.4 ([#16575](https://github.com/netdata/netdata/issues/16575))
- Bump actions/setup-python from 4 to 5 ([#16578](https://github.com/netdata/netdata/issues/16578))
- Wip documentation about functions table ([#16535](https://github.com/netdata/netdata/issues/16535))
- Add Alpine Linux 3.19 to CI. ([#16579](https://github.com/netdata/netdata/issues/16579))
- Uninstaller remove log2journal and systemd-cat-native ([#16585](https://github.com/netdata/netdata/issues/16585))
- Handle coverity issues related to Y2K38_SAFETY ([#16583](https://github.com/netdata/netdata/issues/16583))
- Code cleanup ([#16542](https://github.com/netdata/netdata/issues/16542))
- Update categories.yaml to add Logs ([#16582](https://github.com/netdata/netdata/issues/16582))
- Adds docs for Splunk cloud notifications ([#16586](https://github.com/netdata/netdata/issues/16586))
- Regenerate integrations.js ([#16587](https://github.com/netdata/netdata/issues/16587))
- Disable cpu per core metrics by default ([#16572](https://github.com/netdata/netdata/issues/16572))
- Systemd-journal: exit if unable to locate journal data directories ([#16592](https://github.com/netdata/netdata/issues/16592))
- Bump google-github-actions/setup-gcloud from 1.1.1 to 2.0.0 ([#16577](https://github.com/netdata/netdata/issues/16577))
- Fix: use black version icon for Splunk in order to make it visible ([#16593](https://github.com/netdata/netdata/issues/16593))
- Fix coverity issues ([#16589](https://github.com/netdata/netdata/issues/16589))
- CMake build system. ([#15996](https://github.com/netdata/netdata/issues/15996))
- Cleanup am files ([#16597](https://github.com/netdata/netdata/issues/16597))
- Allow passing cmake options with NETDATA_CMAKE_OPTIONS. ([#16598](https://github.com/netdata/netdata/issues/16598))
- Fix coverity issues ([#16596](https://github.com/netdata/netdata/issues/16596))
- Fix not assigned proc_count in installer ([#16602](https://github.com/netdata/netdata/issues/16602))
- Improve enable_feature function in the installer ([#16601](https://github.com/netdata/netdata/issues/16601))
- Bump actions/labeler from 4 to 5 ([#16576](https://github.com/netdata/netdata/issues/16576))
- Assorted kickstart script fixes. ([#16537](https://github.com/netdata/netdata/issues/16537))
- Remove build/ ([#16600](https://github.com/netdata/netdata/issues/16600))
- Remove v1 dashboard version check from installer ([#16603](https://github.com/netdata/netdata/issues/16603))
- Remove CPack stuff from CMake ([#16608](https://github.com/netdata/netdata/issues/16608))
- Remove assert ([#16611](https://github.com/netdata/netdata/issues/16611))
- Fix small coverity issue ([#16616](https://github.com/netdata/netdata/issues/16616))
- Robustness improvements to netdata-updater.sh ([#16613](https://github.com/netdata/netdata/issues/16613))
- Ndsudo - a helper to run privileged commands ([#16614](https://github.com/netdata/netdata/issues/16614))
- Queries Progress ([#16574](https://github.com/netdata/netdata/issues/16574))
- Fix coverity issues, logically dead code and error checking ([#16618](https://github.com/netdata/netdata/issues/16618))
- Cgroups: filter lxcfs.service/.control ([#16620](https://github.com/netdata/netdata/issues/16620))
- Remove includes outside of libnetdata. ([#16607](https://github.com/netdata/netdata/issues/16607))
- Regenerate integrations.js ([#16595](https://github.com/netdata/netdata/issues/16595))
- Fix UB of unaligned loads/stores and signed shifts. ([#16628](https://github.com/netdata/netdata/issues/16628))
- Correctly handle basic permissions for most scripts on install. ([#16629](https://github.com/netdata/netdata/issues/16629))
- Docs: add "Rootless mode" to Docker install guide ([#16632](https://github.com/netdata/netdata/issues/16632))
- Bump github/codeql-action from 2 to 3 ([#16623](https://github.com/netdata/netdata/issues/16623))
- Bump google-github-actions/upload-cloud-storage from 1.0.3 to 2.0.0 ([#16624](https://github.com/netdata/netdata/issues/16624))
- Remove code relying on autotools. ([#16634](https://github.com/netdata/netdata/issues/16634))
- Added energy efficiency img README.md ([#16617](https://github.com/netdata/netdata/issues/16617))
- Create alerts-configuration-manager.md ([#16642](https://github.com/netdata/netdata/issues/16642))
- Cmake: make WEB_DIR configurable ([#16638](https://github.com/netdata/netdata/issues/16638))
- Fix compilation error when using --disable-dbengine ([#16645](https://github.com/netdata/netdata/issues/16645))
- Update bundled UI to v6.72.0 ([#16647](https://github.com/netdata/netdata/issues/16647))
- Remove Netdata packages from APT cache when attempting to install. ([#16566](https://github.com/netdata/netdata/issues/16566))
- Update artifact-handling actions to latest version. ([#16639](https://github.com/netdata/netdata/issues/16639))
- Necessary changes for Learn ([#16651](https://github.com/netdata/netdata/issues/16651))
- Docs: add a few examples how to query Netdata logs using journalctl ([#16650](https://github.com/netdata/netdata/issues/16650))
- Increase max response size to 100MiB ([#16649](https://github.com/netdata/netdata/issues/16649))
- Rename bundle dashboard scripts ([#16648](https://github.com/netdata/netdata/issues/16648))
- Fix overrun in crc32set ([#16654](https://github.com/netdata/netdata/issues/16654))
- Docs: Correct chart_labels summary ([#16656](https://github.com/netdata/netdata/issues/16656))
- Dont exceed buffer boundaries, when the buffer is empty ([#16664](https://github.com/netdata/netdata/issues/16664))
- Fix compiler warnings ([#16665](https://github.com/netdata/netdata/issues/16665))
- Bump google-github-actions/setup-gcloud from 2.0.0 to 2.0.1 ([#16667](https://github.com/netdata/netdata/issues/16667))
- Shutdown dbengine event loop properly ([#16658](https://github.com/netdata/netdata/issues/16658))
- Fix coverity issues ([#16655](https://github.com/netdata/netdata/issues/16655))
- Set log level of too-old-data message to debug ([#16663](https://github.com/netdata/netdata/issues/16663))
- Kickstart: add a note on how to access the UI to the success banner ([#16673](https://github.com/netdata/netdata/issues/16673))
- EBPF socket (eBPF) ([#16669](https://github.com/netdata/netdata/issues/16669))
- Remove unused github scripts ([#16661](https://github.com/netdata/netdata/issues/16661))
- Remove contrib/rhel ([#16672](https://github.com/netdata/netdata/issues/16672))
- Update bundled UI to v6.75.2 ([#16674](https://github.com/netdata/netdata/issues/16674))
- Fix alerts-configuration-manager.md ([#16679](https://github.com/netdata/netdata/issues/16679))
- Docs: add "Require Cloud" column to functions table ([#16681](https://github.com/netdata/netdata/issues/16681))
- Fix exporting internal charts context and family ([#16683](https://github.com/netdata/netdata/issues/16683))
- Cmake missing defines ([#16680](https://github.com/netdata/netdata/issues/16680))
- Fix claiming on macOS ([#16686](https://github.com/netdata/netdata/issues/16686))
- Atomically load the metric reference count ([#16687](https://github.com/netdata/netdata/issues/16687))
- Add --disable-logsmanagement when building static ([#16684](https://github.com/netdata/netdata/issues/16684))
- Kickstart: dont run install-required-packages.sh as root on macOS ([#16675](https://github.com/netdata/netdata/issues/16675))
- Revert "Update artifact-handling actions to latest version." ([#16689](https://github.com/netdata/netdata/issues/16689))
- Improve the error message when accessing functions ([#16692](https://github.com/netdata/netdata/issues/16692))
- Cmake log2journal netdatacli ([#16688](https://github.com/netdata/netdata/issues/16688))
- Cups exit on sigpipe ([#16691](https://github.com/netdata/netdata/issues/16691))
- Fix installing service file and start/stop ND using `launchctl` on macOS ([#16693](https://github.com/netdata/netdata/issues/16693))
- Fix minor omission on netdata-installers arguments ([#16690](https://github.com/netdata/netdata/issues/16690))
- Fix quota calculation when the the db is empty ([#16699](https://github.com/netdata/netdata/issues/16699))
- Disable logsmanagement when installing on macOS ([#16697](https://github.com/netdata/netdata/issues/16697))
- Delay collecting double linked network interfaces ([#16701](https://github.com/netdata/netdata/issues/16701))
- Bump tj-actions/changed-files from 40 to 41 ([#16668](https://github.com/netdata/netdata/issues/16668))
- Add the Mobile App notification Integration ([#16715](https://github.com/netdata/netdata/issues/16715))
- Regenerate integrations.js ([#16716](https://github.com/netdata/netdata/issues/16716))
- Add info to distros.yml for handling of legacy platforms. ([#16718](https://github.com/netdata/netdata/issues/16718))
- Fix clock resolution detection ([#16720](https://github.com/netdata/netdata/issues/16720))
- Add Netdata Mobile App to issue template config ([#16723](https://github.com/netdata/netdata/issues/16723))
- Add extra build flags to CMakeLists.txt. ([#16641](https://github.com/netdata/netdata/issues/16641))
- Add GHA workflow to upload kickstart script to our repo server. ([#16724](https://github.com/netdata/netdata/issues/16724))
- Update ebpf-socket function name and columns ([#16727](https://github.com/netdata/netdata/issues/16727))
- Update go.d.plugin to v0.58.0 ([#16725](https://github.com/netdata/netdata/issues/16725))
- Cgroups: don't multiply cgroup_check_for_new_every by update_every ([#16719](https://github.com/netdata/netdata/issues/16719))
- Disable logsmanagement when installing on macOS ([#16708](https://github.com/netdata/netdata/issues/16708))
- Regenerate integrations.js ([#16728](https://github.com/netdata/netdata/issues/16728))
- Fix --distro-override parameter name in docs ([#16726](https://github.com/netdata/netdata/issues/16726))
- Fix excessive "maximum number of cgroups reached" log messages ([#16730](https://github.com/netdata/netdata/issues/16730))
- Fix missing CPU frequency ([#16732](https://github.com/netdata/netdata/issues/16732))
- Health: add httpcheck bad header alert ([#16736](https://github.com/netdata/netdata/issues/16736))
- Fix (and improve) Coverity scanning. ([#16605](https://github.com/netdata/netdata/issues/16605))
- Change get kickstart url to https://get.netdata.cloud/kickstart.sh ([#16738](https://github.com/netdata/netdata/issues/16738))
- Regenerate integrations.js ([#16739](https://github.com/netdata/netdata/issues/16739))
- Fatal relaxation of unknown page types. ([#16682](https://github.com/netdata/netdata/issues/16682))
- Cleanup proc net-dev renames ([#16745](https://github.com/netdata/netdata/issues/16745))
- Remove unused file ([#16747](https://github.com/netdata/netdata/issues/16747))
- Uninstaller: improve removing `netdata` from groups ([#16742](https://github.com/netdata/netdata/issues/16742))
- Update default netdata.conf used for native packages ([#16734](https://github.com/netdata/netdata/issues/16734))
- Address sanitizer through CMake and use it for unit tests. ([#16748](https://github.com/netdata/netdata/issues/16748))
- Minor - fix/update codeowners ([#16750](https://github.com/netdata/netdata/issues/16750))
- Fix cpu per core charts priority ([#16749](https://github.com/netdata/netdata/issues/16749))
- Name storage engine variables consistently. ([#16753](https://github.com/netdata/netdata/issues/16753))
- Dyncfg v2 ([#16702](https://github.com/netdata/netdata/issues/16702))
- Packaging: add cap_dac_read_search to go.d.plugin ([#16754](https://github.com/netdata/netdata/issues/16754))
- Add schemas to /usr/lib/netdata/conf.d/schema.d ([#16757](https://github.com/netdata/netdata/issues/16757))
- Report timestamps with progress ([#16758](https://github.com/netdata/netdata/issues/16758))
- Delete memory mode "map" and "save". ([#16604](https://github.com/netdata/netdata/issues/16604))
- Fix sanitizer errors ([#16759](https://github.com/netdata/netdata/issues/16759))
- Recursively merge mqtt_websockets ([#16755](https://github.com/netdata/netdata/issues/16755))
- Fix phtread-detatch() call ([#16760](https://github.com/netdata/netdata/issues/16760))
- Fix cmake _GNU_SOURCE warnings ([#16761](https://github.com/netdata/netdata/issues/16761))
- Fix compiler warnings ([#16763](https://github.com/netdata/netdata/issues/16763))
- /api/v1/config tree improvements and swagger documentation ([#16764](https://github.com/netdata/netdata/issues/16764))
- Fix coverity issues ([#16766](https://github.com/netdata/netdata/issues/16766))
- Add missing call for aral_freez (eBPF) ([#16765](https://github.com/netdata/netdata/issues/16765))
- Keep transaction id of request headers ([#16769](https://github.com/netdata/netdata/issues/16769))
- Allow POST requests to be received from ACLK ([#16770](https://github.com/netdata/netdata/issues/16770))
- Fix thread name on fatal and cgroup netdev rename crash ([#16771](https://github.com/netdata/netdata/issues/16771))
- Fix handling of hardening flags with Clang ([#16731](https://github.com/netdata/netdata/issues/16731))
- Delete unused variable. ([#16776](https://github.com/netdata/netdata/issues/16776))
- Use unsigned char for binary data in mqtt. ([#16775](https://github.com/netdata/netdata/issues/16775))
- Fix warning. ([#16774](https://github.com/netdata/netdata/issues/16774))
- Remove h2o header from libnetdata ([#16780](https://github.com/netdata/netdata/issues/16780))
- Diskspace missing mutex use ([#16784](https://github.com/netdata/netdata/issues/16784))
- Diskspace: reworked the cleanup to fix race conditions ([#16786](https://github.com/netdata/netdata/issues/16786))
- Free key and search, replace patterns ([#16789](https://github.com/netdata/netdata/issues/16789))
- Update telegram documentation ([#16777](https://github.com/netdata/netdata/issues/16777))
- Update role-based-access.md ([#16791](https://github.com/netdata/netdata/issues/16791))
- Change default build directory in installer to `build`. ([#16768](https://github.com/netdata/netdata/issues/16768))
- Regenerate integrations.js ([#16792](https://github.com/netdata/netdata/issues/16792))
- Improve context load  ([#16659](https://github.com/netdata/netdata/issues/16659))
- Use original summary for alert transition ([#16793](https://github.com/netdata/netdata/issues/16793))
- Add additional fail reason and source during database initialization ([#16794](https://github.com/netdata/netdata/issues/16794))
- Use named constants for keyword tokens. ([#16787](https://github.com/netdata/netdata/issues/16787))
- Add check to avoid auto-installing new major versions of Netdata. ([#15898](https://github.com/netdata/netdata/issues/15898))
- CI runtime check cleanup ([#16713](https://github.com/netdata/netdata/issues/16713))
- Update GHA steps that handle artifacts to use latest versions of upload/download actions. ([#16714](https://github.com/netdata/netdata/issues/16714))
- Update replication documentation ([#16778](https://github.com/netdata/netdata/issues/16778))
- Update binaries (eBPF) ([#16671](https://github.com/netdata/netdata/issues/16671))
- Cgroups: containers-vms add CPU throttling % ([#16800](https://github.com/netdata/netdata/issues/16800))
- Remove help text that no longer applies. ([#16805](https://github.com/netdata/netdata/issues/16805))
- Move mqtt_websockets under aclk/ ([#16804](https://github.com/netdata/netdata/issues/16804))
- Fix incorrect major version check in updater. ([#16803](https://github.com/netdata/netdata/issues/16803))
- Apply ASCII-based comparisons to commands in kickstart script that rely on a particular language setting ([#16806](https://github.com/netdata/netdata/issues/16806))
- Update naming for swagger api ([#16564](https://github.com/netdata/netdata/issues/16564))
- Set app_group label automatically ([#16810](https://github.com/netdata/netdata/issues/16810))
- Better support running the Docker entrypoint code as a non-root user. ([#15118](https://github.com/netdata/netdata/issues/15118))
- Updates to light onprem docs ([#16811](https://github.com/netdata/netdata/issues/16811))
- Fix verify_netdata_host_prefix log spam ([#16814](https://github.com/netdata/netdata/issues/16814))
- Use fs type to veryfiy procfs/sysfs ([#16813](https://github.com/netdata/netdata/issues/16813))
- Preserve label source during migration ([#16821](https://github.com/netdata/netdata/issues/16821))
- Bump tj-actions/changed-files from 41 to 42 ([#16823](https://github.com/netdata/netdata/issues/16823))
- Bump actions/cache from 3 to 4 ([#16824](https://github.com/netdata/netdata/issues/16824))
- Add netdata_os_info metric ([#16756](https://github.com/netdata/netdata/issues/16756))
- Improve container detection logic for edit-config. ([#16825](https://github.com/netdata/netdata/issues/16825))
- Add script to ensure a usable Go toolchain is installed. ([#16815](https://github.com/netdata/netdata/issues/16815))
- DYNCFG: dynamically configured alerts ([#16779](https://github.com/netdata/netdata/issues/16779))
- Change query label matching logic ([#16827](https://github.com/netdata/netdata/issues/16827))
- Add brotli and libyaml to buildinfo ([#16830](https://github.com/netdata/netdata/issues/16830))
- Fix coverity issue ([#16831](https://github.com/netdata/netdata/issues/16831))
- Add explicit callback types for readability. ([#16820](https://github.com/netdata/netdata/issues/16820))
- Fix directory handling in Go toolchain handling script. ([#16828](https://github.com/netdata/netdata/issues/16828))
- Adds docs for cloud MS Teams integration ([#16834](https://github.com/netdata/netdata/issues/16834))
- Make the kickstart checksum's placeholder value more concrete ([#16843](https://github.com/netdata/netdata/issues/16843))
- Kickstart: use extended-regexp in `get_redirect()` ([#16844](https://github.com/netdata/netdata/issues/16844))
- Include timer units failed state alert as default ([#16845](https://github.com/netdata/netdata/issues/16845))
- Regenerate integrations.js ([#16835](https://github.com/netdata/netdata/issues/16835))
- Disable local Go builds in our RPM packages. ([#16848](https://github.com/netdata/netdata/issues/16848))
- Improve service thread shutdown ([#16841](https://github.com/netdata/netdata/issues/16841))
- CNCF link fix ([#16851](https://github.com/netdata/netdata/issues/16851))
- New Permissions System ([#16837](https://github.com/netdata/netdata/issues/16837))
- Detect sockets direction ([#16861](https://github.com/netdata/netdata/issues/16861))
- Apply the right prototype to instances ([#16862](https://github.com/netdata/netdata/issues/16862))
- Port useful code from incomplete PRs ([#16863](https://github.com/netdata/netdata/issues/16863))
- Add ARMv6 static builds. ([#16853](https://github.com/netdata/netdata/issues/16853))
- Remove Ubuntu 23.04 from the CI ([#16694](https://github.com/netdata/netdata/issues/16694))
- Update alpine 3.16 fts-dev ([#16865](https://github.com/netdata/netdata/issues/16865))
- Remove old mention of save db mode ([#16864](https://github.com/netdata/netdata/issues/16864))
- Add freebsd jail detection to system-info.sh ([#16858](https://github.com/netdata/netdata/issues/16858))
- Update statistics to address slow queries ([#16838](https://github.com/netdata/netdata/issues/16838))
- Use dagger to build and test the agent. ([#16868](https://github.com/netdata/netdata/issues/16868))
- Fix coverity issue ([#16866](https://github.com/netdata/netdata/issues/16866))
- Local sockets for network namespaces ([#16867](https://github.com/netdata/netdata/issues/16867))
- Fix coverity issues ([#16873](https://github.com/netdata/netdata/issues/16873))
- Network Viewer (local-sockets version) ([#16872](https://github.com/netdata/netdata/issues/16872))
- Rm refs to map and save modes ([#16874](https://github.com/netdata/netdata/issues/16874))
- Network viewer fixes ([#16877](https://github.com/netdata/netdata/issues/16877))
- Add requirements.txt for dag ([#16875](https://github.com/netdata/netdata/issues/16875))
- Setup sentry-native SDK. ([#16798](https://github.com/netdata/netdata/issues/16798))
- Network viewer UI minor fixes ([#16880](https://github.com/netdata/netdata/issues/16880))
- Fix crash on query_progress initializer ([#16885](https://github.com/netdata/netdata/issues/16885))
- Highlight Challenge Secret title to be more visible ([#16882](https://github.com/netdata/netdata/issues/16882))
- Fix order of openning a file and checking its inode ([#16887](https://github.com/netdata/netdata/issues/16887))
- Add the CLOEXEC flag to all sockets and files ([#16881](https://github.com/netdata/netdata/issues/16881))
- Set build type to release with debug info. ([#16889](https://github.com/netdata/netdata/issues/16889))
- Fixed missing collisions and drag on newly added apps ([#16891](https://github.com/netdata/netdata/issues/16891))
- Limit what we upload to GCS for nightlies. ([#16870](https://github.com/netdata/netdata/issues/16870))
- Add a constant env var for Sentry's  DSN when someone wants to build Agent and doesn't have access to GH secrets.  ([#16892](https://github.com/netdata/netdata/issues/16892))
- Do not cancel detection thread. ([#16897](https://github.com/netdata/netdata/issues/16897))
- Updating What's new based on Office Hours shared plans ([#16895](https://github.com/netdata/netdata/issues/16895))
- Local-sockets: use netlink when libmnl is available ([#16893](https://github.com/netdata/netdata/issues/16893))
- Create a top-level directory to contain source code. ([#16896](https://github.com/netdata/netdata/issues/16896))
- Network-viewer: show unknown container ([#16900](https://github.com/netdata/netdata/issues/16900))
- Regenerate integrations.js ([#16886](https://github.com/netdata/netdata/issues/16886))
- Updated permissions map comment ([#16902](https://github.com/netdata/netdata/issues/16902))
- Enable sentry sessions ([#16898](https://github.com/netdata/netdata/issues/16898))
- Move aclk/ under src/ ([#16899](https://github.com/netdata/netdata/issues/16899))
- Use spinlock for reference counting. ([#16901](https://github.com/netdata/netdata/issues/16901))
- Update README.md ([#16904](https://github.com/netdata/netdata/issues/16904))
- Remove markdown linter ([#16905](https://github.com/netdata/netdata/issues/16905))
- Rename network functions ([#16908](https://github.com/netdata/netdata/issues/16908))
- Fluent-bit & logsmanagement under src/ ([#16903](https://github.com/netdata/netdata/issues/16903))
- Build network-viewer only on linux ([#16910](https://github.com/netdata/netdata/issues/16910))
- Network viewer: filter by username ([#16911](https://github.com/netdata/netdata/issues/16911))
- Update file match patterns in CI jobs. ([#16917](https://github.com/netdata/netdata/issues/16917))
- Add support for the info parameter to all external plugin functions ([#16915](https://github.com/netdata/netdata/issues/16915))
- Update network-connections-chart.html
- Split dictionary into multiple files ([#16920](https://github.com/netdata/netdata/issues/16920))
- Minor rework on document ([#16925](https://github.com/netdata/netdata/issues/16925))
- Bump nick-fields/retry from 2 to 3 ([#16927](https://github.com/netdata/netdata/issues/16927))
- Bump nick-invision/retry from 2 to 3 ([#16928](https://github.com/netdata/netdata/issues/16928))
- Release label key if already in use ([#16916](https://github.com/netdata/netdata/issues/16916))
- Move exporting/ under src/ ([#16913](https://github.com/netdata/netdata/issues/16913))
- Fix installation of `libfluent-bit.so` ([#16924](https://github.com/netdata/netdata/issues/16924))
- Regenerate integrations.js ([#16930](https://github.com/netdata/netdata/issues/16930))
- Protect analytics set data ([#16929](https://github.com/netdata/netdata/issues/16929))
- Exporting moved, so changes needed for integrations, + CODEOWNERS change ([#16932](https://github.com/netdata/netdata/issues/16932))
- Regenerate integrations.js ([#16934](https://github.com/netdata/netdata/issues/16934))
- Bump peter-evans/create-pull-request from 5 to 6 ([#16926](https://github.com/netdata/netdata/issues/16926))
- Make sure the duration is not negative ([#16931](https://github.com/netdata/netdata/issues/16931))
- Drop ESLint CI jobs and config. ([#16935](https://github.com/netdata/netdata/issues/16935))
- Remove duplicate check ([#16936](https://github.com/netdata/netdata/issues/16936))
- Check for agent already running ([#16937](https://github.com/netdata/netdata/issues/16937))
- Respect log level for all sources ([#16922](https://github.com/netdata/netdata/issues/16922))
- Fix charts.d.plugin configuration directory names ([#16939](https://github.com/netdata/netdata/issues/16939))
- Update documentation (Replication DB) ([#16816](https://github.com/netdata/netdata/issues/16816))
- Update CODEOWNERS ([#16907](https://github.com/netdata/netdata/issues/16907))
- Respect NETDATA_LOG_LEVEL if set ([#16943](https://github.com/netdata/netdata/issues/16943))
- Move daemon/ under src/ ([#16933](https://github.com/netdata/netdata/issues/16933))
- Update bundled UI to v6.85.0 ([#16948](https://github.com/netdata/netdata/issues/16948))
- Enable network-viewer aggregated views ([#16940](https://github.com/netdata/netdata/issues/16940))
- Assorted cleanup of native packaging code. ([#16640](https://github.com/netdata/netdata/issues/16640))
- Fix wrong sizeof ([#16950](https://github.com/netdata/netdata/issues/16950))
- Update codeowners and cleanup .gitignore ([#16946](https://github.com/netdata/netdata/issues/16946))
- Fix linking of a markdown file ([#16952](https://github.com/netdata/netdata/issues/16952))
- Remove cleanup_destroyed_dictionaries call during shutdown ([#16944](https://github.com/netdata/netdata/issues/16944))
- Do not declare struct meant for internal usage ([#16951](https://github.com/netdata/netdata/issues/16951))
- Remove tags field from RRD hosts. ([#16894](https://github.com/netdata/netdata/issues/16894))
- Move health/ under src/ ([#16954](https://github.com/netdata/netdata/issues/16954))
- Fix path in health integrations ([#16956](https://github.com/netdata/netdata/issues/16956))
- Updated txt - Prometheus section README.md ([#16957](https://github.com/netdata/netdata/issues/16957))
- Network-viewer: aggregated view improvements ([#16960](https://github.com/netdata/netdata/issues/16960))
- DYNCFG: support test on new jobs ([#16958](https://github.com/netdata/netdata/issues/16958))
- Improve agent shutdown ([#16959](https://github.com/netdata/netdata/issues/16959))
- Move collectors/ under src/ ([#16965](https://github.com/netdata/netdata/issues/16965))
- Necessary changes for integrations to work after moving collectors/ i… ([#16966](https://github.com/netdata/netdata/issues/16966))
- Fix move collectors to src/ leftovers ([#16967](https://github.com/netdata/netdata/issues/16967))
- Update go.d.plugin version to v0.58.1 ([#16968](https://github.com/netdata/netdata/issues/16968))
- Regenerate integrations.js ([#16955](https://github.com/netdata/netdata/issues/16955))
- Change edac ecc errors from incremental to absolute ([#16970](https://github.com/netdata/netdata/issues/16970))
- Regenerate integrations.js ([#16974](https://github.com/netdata/netdata/issues/16974))
- Use C++14 by default when building on systems that support it. ([#16972](https://github.com/netdata/netdata/issues/16972))
- Update input paths for tj-actions/changed-files ([#16982](https://github.com/netdata/netdata/issues/16982))
- Update synology.md ([#16980](https://github.com/netdata/netdata/issues/16980))
- Update input skip patterns ([#16984](https://github.com/netdata/netdata/issues/16984))
- Updated message ids for systemd and dbus ([#16987](https://github.com/netdata/netdata/issues/16987))
- Detect machine GUID change ([#16979](https://github.com/netdata/netdata/issues/16979))
- Use changed files in check-files workflow ([#16993](https://github.com/netdata/netdata/issues/16993))
- Remove config macros that are always set. ([#16994](https://github.com/netdata/netdata/issues/16994))
- Move web/ under src/ ([#16992](https://github.com/netdata/netdata/issues/16992))
- Remove historical changelog and cppcheck ([#16995](https://github.com/netdata/netdata/issues/16995))
- Move CO-RE headers (integration between eBPF and Network Viewer) ([#16978](https://github.com/netdata/netdata/issues/16978))
- Small cleanup ([#16996](https://github.com/netdata/netdata/issues/16996))
- Add spinlock to protect metric release ([#16989](https://github.com/netdata/netdata/issues/16989))
- Move diagrams/ under docs/ ([#16998](https://github.com/netdata/netdata/issues/16998))
- Adjust storage tiers if we fail to create the requested number of tiers ([#16999](https://github.com/netdata/netdata/issues/16999))
- Include Go plugin sources in main repository. ([#16997](https://github.com/netdata/netdata/issues/16997))
- Misc improvements ([#17001](https://github.com/netdata/netdata/issues/17001))
- Dyncfg: fix support for testing new jobs ([#17009](https://github.com/netdata/netdata/issues/17009))
- Abort on non-zero rc. ([#17008](https://github.com/netdata/netdata/issues/17008))
- Assorted cleanup of CI/packaging related code. ([#16938](https://github.com/netdata/netdata/issues/16938))
- EBPF & NV (update packages) ([#17012](https://github.com/netdata/netdata/issues/17012))
- Dyncfg: allow tree for individual IDs ([#17017](https://github.com/netdata/netdata/issues/17017))
- EBPF - Network Viewer (Move code) ([#17018](https://github.com/netdata/netdata/issues/17018))
- DYNCFG support deleting orphan configurations ([#17023](https://github.com/netdata/netdata/issues/17023))
- Fix determining repo root in Coverity scan script. ([#17024](https://github.com/netdata/netdata/issues/17024))
- Protect metric release in dimension delete callback ([#17020](https://github.com/netdata/netdata/issues/17020))
- Bump k8s.io/client-go from 0.29.1 to 0.29.2 in /src/go/collectors/go.d.plugin ([#17029](https://github.com/netdata/netdata/issues/17029))
- Bump go.mongodb.org/mongo-driver from 1.13.1 to 1.14.0 in /src/go/collectors/go.d.plugin ([#17030](https://github.com/netdata/netdata/issues/17030))
- Increase RRD_ID_LENGTH_MAX to 1200 ([#17028](https://github.com/netdata/netdata/issues/17028))
- Metric release does not need to fetch retention ([#17033](https://github.com/netdata/netdata/issues/17033))
- Documentation changes, new files and restructuring the hierarchy ([#17014](https://github.com/netdata/netdata/issues/17014))
- Regenerate integrations.js ([#17034](https://github.com/netdata/netdata/issues/17034))
- Populate the SSL section in Observability and centralization points -… ([#17035](https://github.com/netdata/netdata/issues/17035))
- Update machine-learning-and-assisted-troubleshooting.md
- Update disk-requirements-and-retention.md
- Code cleanup ([#17036](https://github.com/netdata/netdata/issues/17036))
- Improved query target cleanup ([#17038](https://github.com/netdata/netdata/issues/17038))
- Liquify start-stop-restart doc ([#17037](https://github.com/netdata/netdata/issues/17037))
- Regenerate integrations.js ([#17039](https://github.com/netdata/netdata/issues/17039))
- Do not use backtrace when sentry is enabled. ([#17043](https://github.com/netdata/netdata/issues/17043))
- Correctly mark protobuf as required in find_package. ([#17021](https://github.com/netdata/netdata/issues/17021))
- Update README.md
- Keep a count of metrics and samples collected ([#17042](https://github.com/netdata/netdata/issues/17042))
- Fix alerts jsonschema prototype for latest dyncfg ([#17047](https://github.com/netdata/netdata/issues/17047))
- Fix zpool state chart family ([#17054](https://github.com/netdata/netdata/issues/17054))
- DYNCFG: call the interceptor when a test is made on a new job ([#17052](https://github.com/netdata/netdata/issues/17052))
- Updated sizing netdata ([#17057](https://github.com/netdata/netdata/issues/17057))
- Add watcher thread to report shutdown steps. ([#17010](https://github.com/netdata/netdata/issues/17010))
- Protect type anomaly rate map ([#17044](https://github.com/netdata/netdata/issues/17044))
- Fix a few minor bits of build-related infrastructure. ([#17051](https://github.com/netdata/netdata/issues/17051))
- Fix typo ([#17059](https://github.com/netdata/netdata/issues/17059))
- More concretely utilize local modules in our CMake code. ([#17022](https://github.com/netdata/netdata/issues/17022))
- Assorted build-related changes. ([#16906](https://github.com/netdata/netdata/issues/16906))
- Integrate Go plugin with build system. ([#17005](https://github.com/netdata/netdata/issues/17005))
- Regenerate integrations.js ([#17061](https://github.com/netdata/netdata/issues/17061))
- Fix links pointing to old go.d repo and update the integrations ([#17040](https://github.com/netdata/netdata/issues/17040))
- Regenerate integrations.js ([#17063](https://github.com/netdata/netdata/issues/17063))
- Bump the version of the installed Go toolchain to 1.22.0. ([#17004](https://github.com/netdata/netdata/issues/17004))
- Go.d.plugin: set max chart id length to 1200 ([#17062](https://github.com/netdata/netdata/issues/17062))
- Abort the agent if a single shutdown step takes more than 60 seconds. ([#17060](https://github.com/netdata/netdata/issues/17060))
- Add CI checks for Go code. ([#17066](https://github.com/netdata/netdata/issues/17066))
- Add missing "gotify" to list of notification methods in alarm-notify.sh ([#17069](https://github.com/netdata/netdata/issues/17069))
- Netdata Agent: Backup restore documentation ([#17006](https://github.com/netdata/netdata/issues/17006))
- Split network viewer plugin to it’s own package. ([#16949](https://github.com/netdata/netdata/issues/16949))
- Cache key wasn't taking account changes in the version of bundled software ([#16985](https://github.com/netdata/netdata/issues/16985))
- Make watcher thread wait for explicit steps. ([#17079](https://github.com/netdata/netdata/issues/17079))
- Improve message in kickstart if a static build can’t be found. ([#17081](https://github.com/netdata/netdata/issues/17081))
- Prepare to functions (eBPF) ([#16788](https://github.com/netdata/netdata/issues/16788))
- Rename network plugin post and pre install actions ([#17084](https://github.com/netdata/netdata/issues/17084))
- Amend the logic of ebpf-plugin package suggestion for network-viewer plugin ([#17085](https://github.com/netdata/netdata/issues/17085))
- Deb packages fix on ioping perms ([#17086](https://github.com/netdata/netdata/issues/17086))
- Fix cups plugin group owner ([#17087](https://github.com/netdata/netdata/issues/17087))
- Bump github.com/stretchr/testify from 1.8.4 to 1.9.0 in /src/go/collectors/go.d.plugin ([#17092](https://github.com/netdata/netdata/issues/17092))
- Fix go.d.plugin/pulsar tests ([#17093](https://github.com/netdata/netdata/issues/17093))
- Bump actions/add-to-project from 0.5.0 to 0.6.0 ([#17091](https://github.com/netdata/netdata/issues/17091))
- Delete docs/netdata-security.md and replace links to proper points ([#17094](https://github.com/netdata/netdata/issues/17094))
- Remove distributed-data-architecture.md and omit mentions to it ([#17097](https://github.com/netdata/netdata/issues/17097))
- Remove deployment-strategies ([#17096](https://github.com/netdata/netdata/issues/17096))
- Fix ebpf compilation warnings ([#17100](https://github.com/netdata/netdata/issues/17100))
- HEALTH: eliminate fields that should be labels ([#17048](https://github.com/netdata/netdata/issues/17048))
- Rework Docker CI to build each platform in it's own runner. ([#17088](https://github.com/netdata/netdata/issues/17088))
- Add missing checkout step in Docker workflow.
- Go.d.plugin dyncfgv2 ([#17064](https://github.com/netdata/netdata/issues/17064))
- Remove "foreach" from health REFERENCE.md ([#17106](https://github.com/netdata/netdata/issues/17106))
- Push Docker images to registries individually.
- Reorganize and cleanup database related code ([#17101](https://github.com/netdata/netdata/issues/17101))
- Fix links in go.d.plugin ([#17108](https://github.com/netdata/netdata/issues/17108))
- Rm unused files from go.d.plugin ([#17110](https://github.com/netdata/netdata/issues/17110))
- Regenerate integrations.js ([#17107](https://github.com/netdata/netdata/issues/17107))
- Improve cleanup of ephemeral hosts during agent startup ([#17104](https://github.com/netdata/netdata/issues/17104))
- Go.d.plugin add notice log level ([#17112](https://github.com/netdata/netdata/issues/17112))
- Remove "os" "hosts" "plugin" and "module" from stock alarms ([#17113](https://github.com/netdata/netdata/issues/17113))
- Fix discovered config default values ([#17115](https://github.com/netdata/netdata/issues/17115))
- Remove deprecated settings from the health ref doc ([#17116](https://github.com/netdata/netdata/issues/17116))
- Very minor docs update ([#17117](https://github.com/netdata/netdata/issues/17117))
- Minor fix; broken link on on prem installation doc ([#17118](https://github.com/netdata/netdata/issues/17118))
- Fix links ([#17095](https://github.com/netdata/netdata/issues/17095))
- Fix memory leak ([#17114](https://github.com/netdata/netdata/issues/17114))
- Second pass at reworking Docker CI. ([#17111](https://github.com/netdata/netdata/issues/17111))
- Fix new Docker workflow skip logic.
- Fix issues with Docker workflow.
- Fix creation of Docker image manifests.
- Switch publishing Docker images to regular repo.
- EBPF cgroup update ([#16630](https://github.com/netdata/netdata/issues/16630))
- Improve go.d.plugin dyncfg config schemas ([#17124](https://github.com/netdata/netdata/issues/17124))
- Fix health alert dyncfg schema fullPage option ([#17125](https://github.com/netdata/netdata/issues/17125))
- Packaging: remove Suggests nut ([#17129](https://github.com/netdata/netdata/issues/17129))
- Detect self thread when exiting. ([#17126](https://github.com/netdata/netdata/issues/17126))
- Fix login to GHCR when publishing Docker images. ([#17127](https://github.com/netdata/netdata/issues/17127))
- Bump github.com/likexian/whois-parser from 1.24.10 to 1.24.11 in /src/go/collectors/go.d.plugin ([#17137](https://github.com/netdata/netdata/issues/17137))
- Bump github.com/jackc/pgx/v4 from 4.18.1 to 4.18.3 in /src/go/collectors/go.d.plugin ([#17135](https://github.com/netdata/netdata/issues/17135))
- Bump github.com/cloudflare/cfssl from 1.6.4 to 1.6.5 in /src/go/collectors/go.d.plugin ([#17136](https://github.com/netdata/netdata/issues/17136))
- Bump golang.org/x/net from 0.21.0 to 0.22.0 in /src/go/collectors/go.d.plugin ([#17134](https://github.com/netdata/netdata/issues/17134))
- Bump github.com/vmware/govmomi from 0.35.0 to 0.36.0 in /src/go/collectors/go.d.plugin ([#17140](https://github.com/netdata/netdata/issues/17140))
- Bump github.com/go-sql-driver/mysql from 1.7.1 to 1.8.0 in /src/go/collectors/go.d.plugin ([#17142](https://github.com/netdata/netdata/issues/17142))
- Bump github.com/prometheus-community/pro-bing from 0.3.0 to 0.4.0 in /src/go/collectors/go.d.plugin ([#17141](https://github.com/netdata/netdata/issues/17141))
- Update go.d.plugin packages ([#17145](https://github.com/netdata/netdata/issues/17145))
- Bring back old docs that were containing missing information ([#17146](https://github.com/netdata/netdata/issues/17146))
- Update functions tables docs ([#17071](https://github.com/netdata/netdata/issues/17071))
- Check alert duration on submission to the cloud ([#17144](https://github.com/netdata/netdata/issues/17144))
- Document new field on PagerDuty cloud integration ([#17149](https://github.com/netdata/netdata/issues/17149))
- Remove repetitive words ([#17131](https://github.com/netdata/netdata/issues/17131))
- Add macos check (build from source) ([#17139](https://github.com/netdata/netdata/issues/17139))
- Go.d.plugin: add docker service discovery ([#17152](https://github.com/netdata/netdata/issues/17152))
- Go.d.plugin: sd compose: allow multi config template ([#17157](https://github.com/netdata/netdata/issues/17157))
- Install the correct service file based on systemd version ([#17159](https://github.com/netdata/netdata/issues/17159))
- Go.d.plugin: execute local-listeners periodically ([#17160](https://github.com/netdata/netdata/issues/17160))
- Bump google.golang.org/protobuf from 1.32.0 to 1.33.0 in /src/go/collectors/go.d.plugin ([#17154](https://github.com/netdata/netdata/issues/17154))
- Go.d.plugin: update file path pattern in jsonschema ([#17164](https://github.com/netdata/netdata/issues/17164))
- Go.d.plugin: jsonschema allow array/object to be null ([#17166](https://github.com/netdata/netdata/issues/17166))
- Docs: add "With NVIDIA GPUs monitoring" to docker install ([#17167](https://github.com/netdata/netdata/issues/17167))
- Announce dynamic configuration capability to the cloud ([#17162](https://github.com/netdata/netdata/issues/17162))
- Go.d sd docker add mongodb-community-server ([#17173](https://github.com/netdata/netdata/issues/17173))
- Go.d sd docker use well-known port for app identification too ([#17174](https://github.com/netdata/netdata/issues/17174))
- Update themes.md ([#17172](https://github.com/netdata/netdata/issues/17172))
- Go.d sd config add "disabled" ([#17171](https://github.com/netdata/netdata/issues/17171))
- Update themes.md ([#17176](https://github.com/netdata/netdata/issues/17176))
- Fix macOS issue with SOCK_CLOEXEC ([#17151](https://github.com/netdata/netdata/issues/17151))
- Bump k8s.io/client-go from 0.29.2 to 0.29.3 in /src/go/collectors/go.d.plugin ([#17184](https://github.com/netdata/netdata/issues/17184))
- Bump github.com/prometheus/common from 0.48.0 to 0.50.0 in /src/go/collectors/go.d.plugin ([#17182](https://github.com/netdata/netdata/issues/17182))
- Bump github.com/vmware/govmomi from 0.36.0 to 0.36.1 in /src/go/collectors/go.d.plugin ([#17185](https://github.com/netdata/netdata/issues/17185))
- Split apps.plugin into multiple files and support MacOS ([#17180](https://github.com/netdata/netdata/issues/17180))
- DYNCFG: alerts improvements ([#17165](https://github.com/netdata/netdata/issues/17165))
- Bump tj-actions/changed-files from 42 to 43 ([#17187](https://github.com/netdata/netdata/issues/17187))
- Add callout that snapshots only available on v1 ([#17189](https://github.com/netdata/netdata/issues/17189))
- Health: unsilence cpu % alarm ([#17194](https://github.com/netdata/netdata/issues/17194))
- Fix sum calculation in rrdr2value ([#17193](https://github.com/netdata/netdata/issues/17193))
- Fix alert hash table definition ([#17196](https://github.com/netdata/netdata/issues/17196))
- Handle agents will wrong alert_hash table definition ([#17197](https://github.com/netdata/netdata/issues/17197))
- Fix issues with permissions when installing from source on macOS ([#17198](https://github.com/netdata/netdata/issues/17198))
- Go.d: local-listeners sd: use "ip:port" as address instead of "localhost" ([#17203](https://github.com/netdata/netdata/issues/17203))
- Go.d: weblog allow PURGE HTTP method ([#17204](https://github.com/netdata/netdata/issues/17204))
- Go.d: local-listeners sd: trust known ports to identify an app ([#17205](https://github.com/netdata/netdata/issues/17205))
- Prefer Protobuf’s own CMake config over CMake's FindProtobuf. ([#17128](https://github.com/netdata/netdata/issues/17128))
- Go.d: adjust dyncfg return codes ([#17206](https://github.com/netdata/netdata/issues/17206))
- Update bundled UI to v6.104.1 ([#17208](https://github.com/netdata/netdata/issues/17208))
- Improve offline install error handling. ([#17153](https://github.com/netdata/netdata/issues/17153))
- Move bundling of libyaml to CMake. ([#17190](https://github.com/netdata/netdata/issues/17190))
- Dynamic configuration switch to version 2 ([#17212](https://github.com/netdata/netdata/issues/17212))

## [1.44.0] - 2023-12-06

### Merged Pull Requests:

- Facets: minimize hashtable collisions ([#16215](https://github.com/netdata/netdata/issues/16215))
- Update README.md
- Update kickstart.md
- Cgroup-network: don't log an error opening pid file if doesn't exist ([#16196](https://github.com/netdata/netdata/issues/16196))
- Fix meta unittest ([#16221](https://github.com/netdata/netdata/issues/16221))
- Changes to `systemd-journal` docs ([#16225](https://github.com/netdata/netdata/issues/16225))
- Update go.d plugin version to v0.56.3 ([#16228](https://github.com/netdata/netdata/issues/16228))
- Add Erlang to Apps configuration ([#16231](https://github.com/netdata/netdata/issues/16231))
- Update passive_journal_centralization_guide_no_encryption.md
- Update passive_journal_centralization_guide_self_signed_certs.md
- Remove charts.d/nut ([#16230](https://github.com/netdata/netdata/issues/16230))
- Fix statistics calculation in 32bit systems ([#16222](https://github.com/netdata/netdata/issues/16222))
- Fix dimension HETEROGENEOUS check ([#16234](https://github.com/netdata/netdata/issues/16234))
- Uninstaller: remove /etc/cron.d/netdata-updater-daily ([#16233](https://github.com/netdata/netdata/issues/16233))
- Update bundled UI to v6.53.0 ([#16239](https://github.com/netdata/netdata/issues/16239))
- Active journal centralization guide no encryption ([#16236](https://github.com/netdata/netdata/issues/16236))
- Journal: script to generate self-signed-certificates ([#16235](https://github.com/netdata/netdata/issues/16235))
- Add info to native packages docs about mirroring our repos. ([#16069](https://github.com/netdata/netdata/issues/16069))
- Improvements for labels handling ([#16172](https://github.com/netdata/netdata/issues/16172))
- Kickstart: rename auto-update-method to auto-update-type ([#16229](https://github.com/netdata/netdata/issues/16229))
- Reuse ML load prepared statement ([#16240](https://github.com/netdata/netdata/issues/16240))
- Improve context load on startup ([#16203](https://github.com/netdata/netdata/issues/16203))
- Add integrations JSON file for website usage. ([#15959](https://github.com/netdata/netdata/issues/15959))
- Added systemd-journal forward_secure_sealing ([#16247](https://github.com/netdata/netdata/issues/16247))
- Fix apps plugin metric names in meta ([#16243](https://github.com/netdata/netdata/issues/16243))
- Regenerate integrations.js ([#16237](https://github.com/netdata/netdata/issues/16237))
- Drop an unused index from aclk_alert table ([#16242](https://github.com/netdata/netdata/issues/16242))
- Terminate cgroups discovery thread faster during shutdown ([#16246](https://github.com/netdata/netdata/issues/16246))
- Dyncfg improvements ([#16250](https://github.com/netdata/netdata/issues/16250))
- Add DYNCFG_RESET ([#16241](https://github.com/netdata/netdata/issues/16241))
- Update active_journal_centralization_guide_no_encryption.md
- Fix label copy to correctly handle duplicate keys ([#16249](https://github.com/netdata/netdata/issues/16249))
- Docker install: support for Proxmox vms/containers name resolution ([#16193](https://github.com/netdata/netdata/issues/16193))
- Python.d(smartd_log): collect Total LBAs written/read ([#16245](https://github.com/netdata/netdata/issues/16245))
- Introduce workflow to always update bundled packages (static builds) into their latest release (part1) ([#16191](https://github.com/netdata/netdata/issues/16191))
- `most_popular` on markdown metadata for integrations ([#16251](https://github.com/netdata/netdata/issues/16251))
- Shutdown while waiting for collectors to finish ([#16023](https://github.com/netdata/netdata/issues/16023))
- Journal multiple sources ([#16252](https://github.com/netdata/netdata/issues/16252))
- Fix Discord webhook payload ([#16257](https://github.com/netdata/netdata/issues/16257))
- Regenerate integrations.js ([#16258](https://github.com/netdata/netdata/issues/16258))
- QUERIES: use tiers only when they have useful data ([#16263](https://github.com/netdata/netdata/issues/16263))
- SUBSTRING simple patterns fix ([#16264](https://github.com/netdata/netdata/issues/16264))
- Fix coverity issue 403725 ([#16265](https://github.com/netdata/netdata/issues/16265))
- Fix HAProxy server status parsing and add MAINT status chart ([#16253](https://github.com/netdata/netdata/issues/16253))
- Cgroup: add net container_device label ([#16261](https://github.com/netdata/netdata/issues/16261))
- Journal minor updates ([#16267](https://github.com/netdata/netdata/issues/16267))
- Fix sources match ([#16271](https://github.com/netdata/netdata/issues/16271))
- DYNCFG fix REPORT_JOB_STATUS streaming ([#16272](https://github.com/netdata/netdata/issues/16272))
- Add document outlining our versioning policy and public API. ([#16227](https://github.com/netdata/netdata/issues/16227))
- Prevent wrong optimization armv7l static build ([#16274](https://github.com/netdata/netdata/issues/16274))
- Remove semicolons from strings ([#16276](https://github.com/netdata/netdata/issues/16276))
- Update bundled UI to v6.57.0 ([#16277](https://github.com/netdata/netdata/issues/16277))
- Regenerate integrations.js ([#16266](https://github.com/netdata/netdata/issues/16266))
- Update go.d version to 0.56.4 ([#16281](https://github.com/netdata/netdata/issues/16281))
- Small optimization of alert queries ([#16282](https://github.com/netdata/netdata/issues/16282))
- Local_listeners: add cmd args for reading specific files ([#16273](https://github.com/netdata/netdata/issues/16273))
- Regenerate integrations.js ([#16284](https://github.com/netdata/netdata/issues/16284))
- ZSTD and GZIP/DEFLATE streaming support ([#16268](https://github.com/netdata/netdata/issues/16268))
- Faster parents ([#16127](https://github.com/netdata/netdata/issues/16127))
- Brotli streaming compression ([#16287](https://github.com/netdata/netdata/issues/16287))
- Fix retention loading ([#16290](https://github.com/netdata/netdata/issues/16290))
- Integrations: yes/no instead of True/False in tables ([#16289](https://github.com/netdata/netdata/issues/16289))
- Fix renames in freebsd ([#16292](https://github.com/netdata/netdata/issues/16292))
- Fix missing labels from parents ([#16293](https://github.com/netdata/netdata/issues/16293))
- Fix various issues identified by coverity ([#16294](https://github.com/netdata/netdata/issues/16294))
- Do not propagate upstream internal label sources ([#16295](https://github.com/netdata/netdata/issues/16295))
- Fix missing labels from parents ([#16296](https://github.com/netdata/netdata/issues/16296))
- Update journal sources once per minute ([#16298](https://github.com/netdata/netdata/issues/16298))
- Regenerate integrations.js ([#16291](https://github.com/netdata/netdata/issues/16291))
- Fix label copy ([#16297](https://github.com/netdata/netdata/issues/16297))
- Typo fixed in gen_docs_integrations.py ([#16288](https://github.com/netdata/netdata/issues/16288))
- Bump tj-actions/changed-files from 39 to 40 ([#16301](https://github.com/netdata/netdata/issues/16301))
- Bump openssl for static in 3.1.4 ([#16303](https://github.com/netdata/netdata/issues/16303))
- Claim.sh: use echo instead of /bin/echo ([#16300](https://github.com/netdata/netdata/issues/16300))
- Apcupsd selftest metric ([#16286](https://github.com/netdata/netdata/issues/16286))
- Use proper icons for deploy integrations ([#16305](https://github.com/netdata/netdata/issues/16305))
- Fix 404s in markdown files ([#16285](https://github.com/netdata/netdata/issues/16285))
- Improve dimension ML model load ([#16262](https://github.com/netdata/netdata/issues/16262))
- Replace distutils with packaging for version ([#16259](https://github.com/netdata/netdata/issues/16259))
- Add a note for the docker deployment alongside with cetus ([#16312](https://github.com/netdata/netdata/issues/16312))
- Update docker swarm deploy info ([#16308](https://github.com/netdata/netdata/issues/16308))
- `tcp_v6_connect` monitoring ([#16316](https://github.com/netdata/netdata/issues/16316))
- Update ObservabilityCon README.md ([#16311](https://github.com/netdata/netdata/issues/16311))
- Improve shutdown when collectors are active ([#16315](https://github.com/netdata/netdata/issues/16315))
- Regenerate integrations.js ([#16306](https://github.com/netdata/netdata/issues/16306))
- Optimize database before agent shutdown ([#16317](https://github.com/netdata/netdata/issues/16317))
- Fix journal file index when collision is detected ([#16319](https://github.com/netdata/netdata/issues/16319))
- Cgroup-top function ([#16314](https://github.com/netdata/netdata/issues/16314))
- Systemd units function ([#16318](https://github.com/netdata/netdata/issues/16318))
- Rename newly added functions ([#16325](https://github.com/netdata/netdata/issues/16325))
- Fix README images ([#16320](https://github.com/netdata/netdata/issues/16320))
- Added section Blog posts README.md ([#16323](https://github.com/netdata/netdata/issues/16323))
- Fix readme images ([#16327](https://github.com/netdata/netdata/issues/16327))
- Fix coverity warnings in cgroups ([#16328](https://github.com/netdata/netdata/issues/16328))
- Integrations: fix nightly tag in helm deploy ([#16326](https://github.com/netdata/netdata/issues/16326))
- Fix: check for null rrdim in cgroup functions ([#16331](https://github.com/netdata/netdata/issues/16331))
- H2o evloop netdata stream support ([#14868](https://github.com/netdata/netdata/issues/14868))
- Regenerate integrations.js ([#16330](https://github.com/netdata/netdata/issues/16330))
- Systemd-units improvements ([#16333](https://github.com/netdata/netdata/issues/16333))
- Proc netstat: add network interface statistics function ([#16334](https://github.com/netdata/netdata/issues/16334))
- Network-interfaces function small improvements ([#16336](https://github.com/netdata/netdata/issues/16336))
- Keep precompiled statements for alarm log queries to improve performance ([#16321](https://github.com/netdata/netdata/issues/16321))
- Proc/diskstats: add block-devices function ([#16338](https://github.com/netdata/netdata/issues/16338))
- Network-interfaces function: add UsedBy field to  ([#16337](https://github.com/netdata/netdata/issues/16337))
- Update info about custom dashboards ([#16121](https://github.com/netdata/netdata/issues/16121))
- Removing support for Alpine 3.15 ([#16205](https://github.com/netdata/netdata/issues/16205))
- Diskspace: add mount-points function ([#16345](https://github.com/netdata/netdata/issues/16345))
- Give the streaming function to nightly users ([#16346](https://github.com/netdata/netdata/issues/16346))
- Change defaults for functions ([#16347](https://github.com/netdata/netdata/issues/16347))
- Cleanup systemd unit files After ([#16332](https://github.com/netdata/netdata/issues/16332))
- Update packaging instructions ([#16344](https://github.com/netdata/netdata/issues/16344))
- Improve unittests ([#16329](https://github.com/netdata/netdata/issues/16329))
- Update distros.yml
- Better database corruption detention during runtime ([#16343](https://github.com/netdata/netdata/issues/16343))
- H2o add api/v2 support ([#16340](https://github.com/netdata/netdata/issues/16340))
- Fix zstd in static build ([#16349](https://github.com/netdata/netdata/issues/16349))
- Add an obsoletion time for statsd private charts ([#16269](https://github.com/netdata/netdata/issues/16269))
- Improve agent to cloud status update process ([#16342](https://github.com/netdata/netdata/issues/16342))
- Replace rrdset_is_obsolete & rrdset_isnot_obsolete ([#16351](https://github.com/netdata/netdata/issues/16351))
- Docs: getting started with netdata cloud onprem ([#15954](https://github.com/netdata/netdata/issues/15954))
- Add rrddim_get_last_stored_value to simplify function code in internal collectors ([#16348](https://github.com/netdata/netdata/issues/16348))
- Copy outdated alert guides to health/guides ([#16352](https://github.com/netdata/netdata/issues/16352))
- Update CODEOWNERS ([#16353](https://github.com/netdata/netdata/issues/16353))
- Update bundle UI to v6.58.5 ([#16354](https://github.com/netdata/netdata/issues/16354))
- Import alert guides from Netdata Assistant ([#16355](https://github.com/netdata/netdata/issues/16355))
- Health: put guides into subdirs ([#16358](https://github.com/netdata/netdata/issues/16358))
- Switch charts / chart to use buffer json functions ([#16359](https://github.com/netdata/netdata/issues/16359))
- Collectors/freeipmi: add ipmi-sensors function ([#16363](https://github.com/netdata/netdata/issues/16363))
- Fix system.net when inside lxc ([#16364](https://github.com/netdata/netdata/issues/16364))
- Cgroups: fix throttle_duration chart context ([#16367](https://github.com/netdata/netdata/issues/16367))
- Cgroups: collect pids/pids.current ([#16369](https://github.com/netdata/netdata/issues/16369))
- Docs: Correct time unit for tier 2 explanation ([#16368](https://github.com/netdata/netdata/issues/16368))
- Docs: remove unused cloud notification methods mds ([#16372](https://github.com/netdata/netdata/issues/16372))
- Add configuration documentation for Cloud AWS SNS ([#16371](https://github.com/netdata/netdata/issues/16371))
- Regenerate integrations.js ([#16373](https://github.com/netdata/netdata/issues/16373))
- Pacakging: add zstd dev to install-required-packages ([#16370](https://github.com/netdata/netdata/issues/16370))
- Add pids current to cgroups meta ([#16374](https://github.com/netdata/netdata/issues/16374))
- Add assorted improvements to the version policy draft. ([#16362](https://github.com/netdata/netdata/issues/16362))
- Regenerate integrations.js ([#16378](https://github.com/netdata/netdata/issues/16378))
- Docs: remove 'families' from health reference ([#16380](https://github.com/netdata/netdata/issues/16380))
- Fix cloud aws sns notification meta ([#16379](https://github.com/netdata/netdata/issues/16379))
- Use pre-configured message_ids to identify common logs ([#16383](https://github.com/netdata/netdata/issues/16383))
- Regenerate integrations.js ([#16384](https://github.com/netdata/netdata/issues/16384))
- Skip spaces when reading cpuset ([#16385](https://github.com/netdata/netdata/issues/16385))
- Split chars (eBPF <-> Apps integration) ([#16139](https://github.com/netdata/netdata/issues/16139))
- Fix v0 dashboard ([#16389](https://github.com/netdata/netdata/issues/16389))
- Docker: mount /etc/localtime ([#16392](https://github.com/netdata/netdata/issues/16392))
- Fix "differ in signedness" warn in cgroup ([#16391](https://github.com/netdata/netdata/issues/16391))
- Update bundled UI to v6.59.0 ([#16377](https://github.com/netdata/netdata/issues/16377))
- Health guides: remove guides for alerts that don't exist in the repo ([#16375](https://github.com/netdata/netdata/issues/16375))
- Fix systemd-units func expiration time ([#16393](https://github.com/netdata/netdata/issues/16393))
- EBPF apps order ([#16395](https://github.com/netdata/netdata/issues/16395))
- Add a apcupsd status code metric ([#16361](https://github.com/netdata/netdata/issues/16361))
- Switch alarm_log to use the buffer json functions ([#16360](https://github.com/netdata/netdata/issues/16360))
- Adaptec_raid: fix parsing PD without NCQ status ([#16400](https://github.com/netdata/netdata/issues/16400))
- Regenerate integrations.js ([#16386](https://github.com/netdata/netdata/issues/16386))
- Fix typo in metadata (eBPF) ([#16405](https://github.com/netdata/netdata/issues/16405))
- Regenerate integrations.js ([#16409](https://github.com/netdata/netdata/issues/16409))
- Fix: don't count reused connections as new ([#16414](https://github.com/netdata/netdata/issues/16414))
- /api/v1/charts: bring back chart id to `title` ([#16416](https://github.com/netdata/netdata/issues/16416))
- Don't print errors from reading filtered alerts ([#16417](https://github.com/netdata/netdata/issues/16417))
- Improve handling around EPEL requirement for RPM packages. ([#16406](https://github.com/netdata/netdata/issues/16406))
- Disable socket port reuse ([#16420](https://github.com/netdata/netdata/issues/16420))
- Fix proc net dev: keep iface speed chart var in Mbits ([#16418](https://github.com/netdata/netdata/issues/16418))
- Minor: Remove backtick from doc ([#16423](https://github.com/netdata/netdata/issues/16423))
- Docker: use /host/etc/hostname if mounted ([#16401](https://github.com/netdata/netdata/issues/16401))
- Introduce agent release metadata pipelines ([#16366](https://github.com/netdata/netdata/issues/16366))
- Add support for installing a specific major version of the agent on install. ([#16413](https://github.com/netdata/netdata/issues/16413))
- Proc_net_dev: keep nic_speed_max in kilobits ([#16429](https://github.com/netdata/netdata/issues/16429))
- Update go.d plugin to v0.57.0 ([#16427](https://github.com/netdata/netdata/issues/16427))
- Regenerate integrations.js ([#16430](https://github.com/netdata/netdata/issues/16430))
- Adds config info for Telegram cloud notification ([#16424](https://github.com/netdata/netdata/issues/16424))
- Regenerate integrations.js ([#16431](https://github.com/netdata/netdata/issues/16431))
- Update netdata-functions.md ([#16421](https://github.com/netdata/netdata/issues/16421))
- Journal sampling ([#16433](https://github.com/netdata/netdata/issues/16433))
- Removes Observabilitycon banner README.md ([#16434](https://github.com/netdata/netdata/issues/16434))
- Minor: Small health docs typo fix ([#16439](https://github.com/netdata/netdata/issues/16439))
- Remove queue limit from ACLK sync event loop ([#16411](https://github.com/netdata/netdata/issues/16411))
- Fix icon filename ([#16441](https://github.com/netdata/netdata/issues/16441))
- Journal startup ([#16443](https://github.com/netdata/netdata/issues/16443))
- Add support for gorilla pages for tier 0. ([#15969](https://github.com/netdata/netdata/issues/15969))
- Doc change: Curl no longer supports spaces in the URL. ([#16446](https://github.com/netdata/netdata/issues/16446))
- New logging layer ([#16357](https://github.com/netdata/netdata/issues/16357))
- Fix: link daemon.log to stderr in docker ([#16447](https://github.com/netdata/netdata/issues/16447))
- Journal estimations ([#16445](https://github.com/netdata/netdata/issues/16445))
- Add missing argument. ([#16451](https://github.com/netdata/netdata/issues/16451))
- Set journal path for logging ([#16457](https://github.com/netdata/netdata/issues/16457))
- When the namespace socket does not work, continue trying ([#16458](https://github.com/netdata/netdata/issues/16458))
- Log flood protection to 1000 log lines / 1 minute ([#16450](https://github.com/netdata/netdata/issues/16450))
- Add sbindir_POST to PATH of bash scripts that use `systemd-cat-native` ([#16456](https://github.com/netdata/netdata/issues/16456))
- Fixes for logging ([#16459](https://github.com/netdata/netdata/issues/16459))
- Add LogNamespace to systemd units ([#16454](https://github.com/netdata/netdata/issues/16454))
- Fix log2journal incorrect log ([#16460](https://github.com/netdata/netdata/issues/16460))
- Fix logs bashism ([#16461](https://github.com/netdata/netdata/issues/16461))
- Fix analytics logs ([#16462](https://github.com/netdata/netdata/issues/16462))
- Add option to disable ML. ([#16463](https://github.com/netdata/netdata/issues/16463))
- Update non-zero uuid key + child conf. ([#16452](https://github.com/netdata/netdata/issues/16452))
- Update go.d plugin version to v0.57.1 ([#16465](https://github.com/netdata/netdata/issues/16465))
- Handle ephemeral hosts ([#16381](https://github.com/netdata/netdata/issues/16381))
- Fix charts.d plugin loading configuration ([#16471](https://github.com/netdata/netdata/issues/16471))
- SEO changes for Collector names ([#16473](https://github.com/netdata/netdata/issues/16473))
- Journal better estimations and watcher ([#16467](https://github.com/netdata/netdata/issues/16467))
- Fix error limit to respect the log every ([#16469](https://github.com/netdata/netdata/issues/16469))
- Journals management improvements ([#16475](https://github.com/netdata/netdata/issues/16475))
- Regenerate integrations.js ([#16442](https://github.com/netdata/netdata/issues/16442))
- Log2journal yaml configuration support ([#16479](https://github.com/netdata/netdata/issues/16479))
- Logs Management ([#13291](https://github.com/netdata/netdata/issues/13291))
- Disable netdata monitoring section by default ([#16480](https://github.com/netdata/netdata/issues/16480))
- Bump new version to cov-analysis tool ([#16482](https://github.com/netdata/netdata/issues/16482))
- Fix incorrect DEB package build dep. ([#16483](https://github.com/netdata/netdata/issues/16483))
- Log2journal moved to collectors ([#16481](https://github.com/netdata/netdata/issues/16481))
- Log2journal: added missing yaml elements ([#16488](https://github.com/netdata/netdata/issues/16488))
- On-Prem documentation full and light ([#16440](https://github.com/netdata/netdata/issues/16440))
- Switch to using Debian as a base for our Docker images. ([#15823](https://github.com/netdata/netdata/issues/15823))
- Spelling fixes to documentation ([#16490](https://github.com/netdata/netdata/issues/16490))
- Check context post processing queue before sending status to cloud ([#16472](https://github.com/netdata/netdata/issues/16472))
- Logs-management: Add function cancellability ([#16484](https://github.com/netdata/netdata/issues/16484))
- Add /var/log mount to docker ([#16496](https://github.com/netdata/netdata/issues/16496))
- Proc_net_dev: remove device config section ([#16492](https://github.com/netdata/netdata/issues/16492))
- Fix occasional shutdown deadlock ([#16495](https://github.com/netdata/netdata/issues/16495))
- Fix builds on macOS due to missing endianness functions ([#16489](https://github.com/netdata/netdata/issues/16489))
- When unregistering an ephemeral host, delete its chart labels ([#16486](https://github.com/netdata/netdata/issues/16486))
- Fix CID 410152 Dereference after null check ([#16502](https://github.com/netdata/netdata/issues/16502))
- Log2journal improvements part2 ([#16494](https://github.com/netdata/netdata/issues/16494))
- Diskspace/diskstats: don't create runtime disk config by default ([#16503](https://github.com/netdata/netdata/issues/16503))
- Remove discourse badge from readme ([#16499](https://github.com/netdata/netdata/issues/16499))
- Proc_net_dev: don't create runtime device config by default ([#16501](https://github.com/netdata/netdata/issues/16501))
- Convert some error messages to info ([#16505](https://github.com/netdata/netdata/issues/16505))
- Resolve coverity issue 410232 ([#16507](https://github.com/netdata/netdata/issues/16507))
- Logs-management: Add option to submit logs to system journal ([#16485](https://github.com/netdata/netdata/issues/16485))
- Journal improvements part 3 ([#16509](https://github.com/netdata/netdata/issues/16509))
- Log alarm notifications to health.log ([#16476](https://github.com/netdata/netdata/issues/16476))
- Add curl example to create_netdata_conf() ([#16498](https://github.com/netdata/netdata/issues/16498))
- Convert some error messages to info ([#16508](https://github.com/netdata/netdata/issues/16508))
- Docs: add with-systemd-units-monitoring example to docker ([#16513](https://github.com/netdata/netdata/issues/16513))
- Apps: fix "has aggregated" debug output ([#16512](https://github.com/netdata/netdata/issues/16512))
- Python.d: mute stock jobs logging during check() ([#16515](https://github.com/netdata/netdata/issues/16515))
- Logs-management: Add prefix to chart names ([#16514](https://github.com/netdata/netdata/issues/16514))
- Remove system info logging ([#16517](https://github.com/netdata/netdata/issues/16517))
- Python.d: logger: remove timestamp when logging to journald. ([#16516](https://github.com/netdata/netdata/issues/16516))
- Log2journal improvements 4 ([#16510](https://github.com/netdata/netdata/issues/16510))
- Regenerate integrations.js ([#16500](https://github.com/netdata/netdata/issues/16500))
- Code cleanup ([#16448](https://github.com/netdata/netdata/issues/16448))
- Change log level to debug for dbengine routine operations on start ([#16518](https://github.com/netdata/netdata/issues/16518))
- Include more cases for megacli degraded state ([#16522](https://github.com/netdata/netdata/issues/16522))
- Log method = none is not respected ([#16523](https://github.com/netdata/netdata/issues/16523))
- Logs-management: Disable logs management monitoring section ([#16525](https://github.com/netdata/netdata/issues/16525))
- Log2journal improvements 5 ([#16519](https://github.com/netdata/netdata/issues/16519))
- Make image available to Learn + add a category overview page for new … ([#16527](https://github.com/netdata/netdata/issues/16527))
- Update getting-started.md ([#16528](https://github.com/netdata/netdata/issues/16528))
- Update getting-started-light-poc.md ([#16532](https://github.com/netdata/netdata/issues/16532))
- Update bundled UI to v6.65.0 ([#16520](https://github.com/netdata/netdata/issues/16520))
- Link aclk.log to stdout in docker ([#16529](https://github.com/netdata/netdata/issues/16529))
- Update go.d plugin to v0.57.2 ([#16533](https://github.com/netdata/netdata/issues/16533))
- Acquire receiver_lock to to avoid race condition ([#16531](https://github.com/netdata/netdata/issues/16531))
- Fix alpine deps ([#16543](https://github.com/netdata/netdata/issues/16543))
- Reorg kickstart guide's steps ([#16534](https://github.com/netdata/netdata/issues/16534))
- Change level to debug "took too long to be updated" ([#16540](https://github.com/netdata/netdata/issues/16540))
- Apps: fix uptime for groups with 0 processes ([#16538](https://github.com/netdata/netdata/issues/16538))
- Add option to change page type for tier 0 to gorilla ([#16545](https://github.com/netdata/netdata/issues/16545))
- Docs required for release ([#16546](https://github.com/netdata/netdata/issues/16546))
- Proper Learn-friendly links ([#16547](https://github.com/netdata/netdata/issues/16547))
- Improve page validity check during database extent load ([#16552](https://github.com/netdata/netdata/issues/16552))
- Update bundled UI to v6.66.1 ([#16554](https://github.com/netdata/netdata/issues/16554))
- Regenerate integrations.js ([#16536](https://github.com/netdata/netdata/issues/16536))

## [1.43.0] - 2023-10-16

### Merged Pull Requests:

- Update an oversight on the openSUSE 15.5 packages ([#15781](https://github.com/netdata/netdata/issues/15781))
- Mark integrations milestones as completed in README.md ([#15783](https://github.com/netdata/netdata/issues/15783))
- Update README.md
- Set correct path for ansible-playbook in deployment tutorial ([#15786](https://github.com/netdata/netdata/issues/15786))
- Fix docker-compose example ([#15784](https://github.com/netdata/netdata/issues/15784))
- Minor Dyncfg mvp0 fixes ([#15785](https://github.com/netdata/netdata/issues/15785))
- Count functions as collections, to restart plugins ([#15787](https://github.com/netdata/netdata/issues/15787))
- Fix typo in Readme ([#15794](https://github.com/netdata/netdata/issues/15794))
- Fix hpssa handle unassigned drives ([#15793](https://github.com/netdata/netdata/issues/15793))
- Prevent reporting negative retention when the db is empty ([#15796](https://github.com/netdata/netdata/issues/15796))
- Function systemd-journal: always have a nd_journal_process ([#15798](https://github.com/netdata/netdata/issues/15798))
- Bump openssl version of static builds to 1.1.1v ([#15779](https://github.com/netdata/netdata/issues/15779))
- Clean up python deps for RPM packages. ([#15804](https://github.com/netdata/netdata/issues/15804))
- Add proper SUID fallback for DEB plugin packages. ([#15803](https://github.com/netdata/netdata/issues/15803))
- Fix systemd journal build deps in DEB packages. ([#15805](https://github.com/netdata/netdata/issues/15805))
- Fix api v1 mgmt/health ([#15806](https://github.com/netdata/netdata/issues/15806))
- Return 412 instead of 403 when a bearer token is required ([#15808](https://github.com/netdata/netdata/issues/15808))
- Bump ui to v6.28.0 ([#15810](https://github.com/netdata/netdata/issues/15810))
- Nfacct.plugin increase restart time from 4 hours to 1 day ([#15801](https://github.com/netdata/netdata/issues/15801))
- Fix: the cleanup was not performed during the kickstart.sh dry run ([#15775](https://github.com/netdata/netdata/issues/15775))
- Fix packaging: link health.log to stdout ([#15813](https://github.com/netdata/netdata/issues/15813))
- Docs rename alarm to alert ([#15812](https://github.com/netdata/netdata/issues/15812))
- Systemd-journal fixes ([#15814](https://github.com/netdata/netdata/issues/15814))
- Installer setuid fallback for perf and slabinfo plugins ([#15807](https://github.com/netdata/netdata/issues/15807))
- Added /api/v2/ilove.svg endpoint ([#15815](https://github.com/netdata/netdata/issues/15815))
- Release job message status to avoid memory leak ([#15822](https://github.com/netdata/netdata/issues/15822))
- Update cmakelist ([#15817](https://github.com/netdata/netdata/issues/15817))
- ML improve init ([#15819](https://github.com/netdata/netdata/issues/15819))
- Improve dyncfg exit ([#15824](https://github.com/netdata/netdata/issues/15824))
- Release fd if setsockopt or bind fails ([#15826](https://github.com/netdata/netdata/issues/15826))
- Increase alert snapshot chunk size ([#15748](https://github.com/netdata/netdata/issues/15748))
- RPM: fixed attrs for conf.d dirs ([#15828](https://github.com/netdata/netdata/issues/15828))
- Avoid resource leak  ([#15827](https://github.com/netdata/netdata/issues/15827))
- Systemd-journal in containers ([#15830](https://github.com/netdata/netdata/issues/15830))
- Workaround for systems that do not have SD_JOURNAL_OS_ROOT ([#15837](https://github.com/netdata/netdata/issues/15837))
- Added ilove.html ([#15836](https://github.com/netdata/netdata/issues/15836))
- Fix CID 382964:  Code maintainability issues  (SIZEOF_MISMATCH) ([#15833](https://github.com/netdata/netdata/issues/15833))
- Fix coverity 393052:  API usage errors  (LOCK) ([#15832](https://github.com/netdata/netdata/issues/15832))
- Fix use after free ([#15825](https://github.com/netdata/netdata/issues/15825))
- Fix warning when compiling with -flto ([#15838](https://github.com/netdata/netdata/issues/15838))
- Fix configure: WARNING: unrecognized options: --with-zlib ([#15840](https://github.com/netdata/netdata/issues/15840))
- Added CentOS-Stream to distros ([#15742](https://github.com/netdata/netdata/issues/15742))
- Bump bundled ui to v6.29.0 ([#15841](https://github.com/netdata/netdata/issues/15841))
- Fix compilation warning ([#15839](https://github.com/netdata/netdata/issues/15839))
- Fix static build SSL ([#15842](https://github.com/netdata/netdata/issues/15842))
- Facets histograms ([#15846](https://github.com/netdata/netdata/issues/15846))
- Reworked pluginsd caching of RDAs to avoid crashes ([#15845](https://github.com/netdata/netdata/issues/15845))
- Fix packaging static build openssl 32bit ([#15855](https://github.com/netdata/netdata/issues/15855))
- Packaging cleanup after #15842 ([#15857](https://github.com/netdata/netdata/issues/15857))
- Fix packaging mark stable static build ([#15854](https://github.com/netdata/netdata/issues/15854))
- Fix proc meminfo cached calculation ([#15859](https://github.com/netdata/netdata/issues/15859))
- Update deploy.yaml
- Update platform_info.md
- Update metadata.yaml
- Regenerate integrations.js ([#15862](https://github.com/netdata/netdata/issues/15862))
- Fix compilation warnings ([#15858](https://github.com/netdata/netdata/issues/15858))
- Apply a label prefix for netdata labels ([#15860](https://github.com/netdata/netdata/issues/15860))
- Add plugin and module information to collector integrations. ([#15864](https://github.com/netdata/netdata/issues/15864))
- Regenerate integrations.js ([#15867](https://github.com/netdata/netdata/issues/15867))
- Explicitly depend on version-matched plugins in native packages. ([#15861](https://github.com/netdata/netdata/issues/15861))
- Misc code cleanup ([#15665](https://github.com/netdata/netdata/issues/15665))
- Add a fail reason to pinpoint exactly what went wrong ([#15866](https://github.com/netdata/netdata/issues/15866))
- Unconditionally delete very old models. ([#15720](https://github.com/netdata/netdata/issues/15720))
- Add a chart that groups anomaly rate by chart type. ([#15856](https://github.com/netdata/netdata/issues/15856))
- ML add new `delete old models param` to readme ([#15873](https://github.com/netdata/netdata/issues/15873))
- Use the newer XXH3 128bits algorithm, instead of the classic XXH128 ([#15878](https://github.com/netdata/netdata/issues/15878))
- Allow any field to be a facet ([#15880](https://github.com/netdata/netdata/issues/15880))
- Regenerate integrations.js ([#15879](https://github.com/netdata/netdata/issues/15879))
- Update SQLITE version to 3.42.0 ([#15870](https://github.com/netdata/netdata/issues/15870))
- Metadata cleanup improvements ([#15462](https://github.com/netdata/netdata/issues/15462))
- Add index to ACLK table to improve update statements ([#15890](https://github.com/netdata/netdata/issues/15890))
- Fix build with --disable-https ([#15395](https://github.com/netdata/netdata/issues/15395))
- Make `anomaly_detection.type_anomaly_rate` stacked ([#15895](https://github.com/netdata/netdata/issues/15895))
- Bump ui to v6.32.0 ([#15897](https://github.com/netdata/netdata/issues/15897))
- Reduce label memory ([#15255](https://github.com/netdata/netdata/issues/15255))
- Limit atomic operations for statistics ([#15887](https://github.com/netdata/netdata/issues/15887))
- Add better recovery for corrupted metadata ([#15891](https://github.com/netdata/netdata/issues/15891))
- Improve shutdown of the metadata thread ([#15901](https://github.com/netdata/netdata/issues/15901))
- Update change-metrics-storage.md ([#15896](https://github.com/netdata/netdata/issues/15896))
- Update pfsense.md ([#15894](https://github.com/netdata/netdata/issues/15894))
- Assorted Dockerfile cleanup. ([#15902](https://github.com/netdata/netdata/issues/15902))
- Properly document issues with installing on hosts without IPv4. ([#15882](https://github.com/netdata/netdata/issues/15882))
- Python.d/sensors: Increase voltage limits 127 -> 400 ([#15905](https://github.com/netdata/netdata/issues/15905))
- Reduce workload during cleanup ([#15919](https://github.com/netdata/netdata/issues/15919))
- Reset the obsolete flag on service thread ([#15892](https://github.com/netdata/netdata/issues/15892))
- Replace _ with spaces for name variable for ntfy ([#15909](https://github.com/netdata/netdata/issues/15909))
- Don't return `-1` if the socket was closed ([#15771](https://github.com/netdata/netdata/issues/15771))
- Systemd-journal and facets improvements ([#15926](https://github.com/netdata/netdata/issues/15926))
- Fix memory leak on prometheus exporter and code cleanup ([#15929](https://github.com/netdata/netdata/issues/15929))
- Systemd-journal and facets: info and sources ([#15928](https://github.com/netdata/netdata/issues/15928))
- Improved facets info ([#15936](https://github.com/netdata/netdata/issues/15936))
- Bump actions/checkout from 3 to 4 ([#15935](https://github.com/netdata/netdata/issues/15935))
- Add specific info on how to access the dashboards ([#15925](https://github.com/netdata/netdata/issues/15925))
- Integrations: Add a note to enable the collectors ([#15945](https://github.com/netdata/netdata/issues/15945))
- Feat: Adds access control configuration for ntfy ([#15932](https://github.com/netdata/netdata/issues/15932))
- Skip copying environment/install-type files when checking existing installs. ([#15876](https://github.com/netdata/netdata/issues/15876))
- Facets optimizations ([#15940](https://github.com/netdata/netdata/issues/15940))
- Add description about packages ([#15941](https://github.com/netdata/netdata/issues/15941))
- Streaming logs ([#15948](https://github.com/netdata/netdata/issues/15948))
- Disk Labels ([#15949](https://github.com/netdata/netdata/issues/15949))
- Fix CID 400366 ([#15953](https://github.com/netdata/netdata/issues/15953))
- Update descriptions. ([#15952](https://github.com/netdata/netdata/issues/15952))
- Update slabinfo metadata ([#15951](https://github.com/netdata/netdata/issues/15951))
- Facets and journal improvements ([#15956](https://github.com/netdata/netdata/issues/15956))
- Fix journal direction parsing ([#15957](https://github.com/netdata/netdata/issues/15957))
- Clarifying the possible installation types ([#15958](https://github.com/netdata/netdata/issues/15958))
- Enable `ml_1min_node_ar` as a default alert ([#14687](https://github.com/netdata/netdata/issues/14687))
- RPM: build go.d.plugin native for CentOS-Stream ([#14551](https://github.com/netdata/netdata/issues/14551))
- Integrations: Add a note to install charts.d plugin ([#15943](https://github.com/netdata/netdata/issues/15943))
- Fix using undefined var when loading job statuses in python.d ([#15965](https://github.com/netdata/netdata/issues/15965))
- Skip trying to preserve file owners when bundling external code. ([#15966](https://github.com/netdata/netdata/issues/15966))
- Facets: data-only queries ([#15961](https://github.com/netdata/netdata/issues/15961))
- Facets: do not shadow local variable ([#15968](https://github.com/netdata/netdata/issues/15968))
- EBPF socket function ([#15850](https://github.com/netdata/netdata/issues/15850))
- Facets histogram when empty ([#15970](https://github.com/netdata/netdata/issues/15970))
- Facets histogram: do not send db retention for facets ([#15974](https://github.com/netdata/netdata/issues/15974))
- Facets: fixes 5 ([#15976](https://github.com/netdata/netdata/issues/15976))
- Apps.plugin function is not thread safe ([#15978](https://github.com/netdata/netdata/issues/15978))
- Bump UI to v6.37.1 ([#15980](https://github.com/netdata/netdata/issues/15980))
- Update go.d.plugin to v0.55.0 ([#15981](https://github.com/netdata/netdata/issues/15981))
- Regenerate integrations.js ([#15946](https://github.com/netdata/netdata/issues/15946))
- Functions: allow collectors to be restarted ([#15983](https://github.com/netdata/netdata/issues/15983))
- Metadata fixes for some collectors ([#15982](https://github.com/netdata/netdata/issues/15982))
- Regenerate integrations.js ([#15985](https://github.com/netdata/netdata/issues/15985))
- Initial tooling for Integrations Documentation ([#15893](https://github.com/netdata/netdata/issues/15893))
- Bump docker/login-action from 2 to 3 ([#15992](https://github.com/netdata/netdata/issues/15992))
- Bump docker/setup-qemu-action from 2 to 3 ([#15991](https://github.com/netdata/netdata/issues/15991))
- Bump docker/build-push-action from 4 to 5 ([#15990](https://github.com/netdata/netdata/issues/15990))
- Bump docker/setup-buildx-action from 2 to 3 ([#15989](https://github.com/netdata/netdata/issues/15989))
- Re-store rrdvars on late dimensions ([#15984](https://github.com/netdata/netdata/issues/15984))
- Extend ml default training from ~24 to ~48 hours ([#15971](https://github.com/netdata/netdata/issues/15971))
- Functions cancelling ([#15977](https://github.com/netdata/netdata/issues/15977))
- Fix compilation warnings ([#16001](https://github.com/netdata/netdata/issues/16001))
- Update CMakeLists.txt ([#16005](https://github.com/netdata/netdata/issues/16005))
- Update integrations/gen_docs_integrations.py ([#15997](https://github.com/netdata/netdata/issues/15997))
- Fix compilation warnings ([#16006](https://github.com/netdata/netdata/issues/16006))
- Add a summary field to alerts ([#15886](https://github.com/netdata/netdata/issues/15886))
- EBPF socket: function with event loop ([#16004](https://github.com/netdata/netdata/issues/16004))
- Preserve README info inside metadata.yaml for freeipmi.plugin ([#15955](https://github.com/netdata/netdata/issues/15955))
- Systemd-Journal: fix crash when the uid or gid do not have names ([#16015](https://github.com/netdata/netdata/issues/16015))
- Fix crash on setting thread name ([#16016](https://github.com/netdata/netdata/issues/16016))
- Update bundled UI to v6.39.0 ([#16020](https://github.com/netdata/netdata/issues/16020))
- Some collector metadata improvements ([#16008](https://github.com/netdata/netdata/issues/16008))
- Change the build image of EL packages from alma to rocky ([#15944](https://github.com/netdata/netdata/issues/15944))
- Clarify shipping repos cases ([#15960](https://github.com/netdata/netdata/issues/15960))
- Fix handling of CI skipping. ([#16022](https://github.com/netdata/netdata/issues/16022))
- Add systemd-journal.plugin to apps_groups.conf ([#16024](https://github.com/netdata/netdata/issues/16024))
- Fix package builds on Rocky Linux. ([#16026](https://github.com/netdata/netdata/issues/16026))
- Regenerate integrations.js ([#16011](https://github.com/netdata/netdata/issues/16011))
- Remove the line length limit from pluginsd ([#16013](https://github.com/netdata/netdata/issues/16013))
- Disable mongodb exporter builds where broken. ([#16033](https://github.com/netdata/netdata/issues/16033))
- Add description for Homebrew on Apple Silicon Mac(netdata/learn/#1789) ([#16027](https://github.com/netdata/netdata/issues/16027))
- Update collector metadata for python collectors ([#16019](https://github.com/netdata/netdata/issues/16019))
- Use `status` as units for `anomaly_detection.detector_events` ([#16028](https://github.com/netdata/netdata/issues/16028))
- Simplify the script for generating documentation from integrations ([#16009](https://github.com/netdata/netdata/issues/16009))
- Remove discontinued Hangouts and StackPulse notification methods ([#16041](https://github.com/netdata/netdata/issues/16041))
- Doc about running a local dashboard through Cloudflare (community) ([#16043](https://github.com/netdata/netdata/issues/16043))
- Fix summary field in table ([#16050](https://github.com/netdata/netdata/issues/16050))
- Run health queries from tier 0 ([#16032](https://github.com/netdata/netdata/issues/16032))
- Switch to uint64_t to avoid overflow in 32bit systems ([#16048](https://github.com/netdata/netdata/issues/16048))
- Fix missing find command when installing/updating on Rocky Linux systems. ([#16052](https://github.com/netdata/netdata/issues/16052))
- Update bundled ui version to v6.41.1 ([#16054](https://github.com/netdata/netdata/issues/16054))
- Maintain node's last connected timestamp in the db ([#15979](https://github.com/netdata/netdata/issues/15979))
- Regenerate integrations.js ([#16044](https://github.com/netdata/netdata/issues/16044))
- Health: add upsd alerts ([#16036](https://github.com/netdata/netdata/issues/16036))
- Update to use versioned base images for CI. ([#16053](https://github.com/netdata/netdata/issues/16053))
- Bugfix on integrations/gen_docs_integrations.py ([#16059](https://github.com/netdata/netdata/issues/16059))
- Update go.d version to v0.56.0 ([#16061](https://github.com/netdata/netdata/issues/16061))
- Fix coverity 402975 ([#16058](https://github.com/netdata/netdata/issues/16058))
- Make collectors/COLLECTORS.md have its list autogenerated from integrations.js ([#15995](https://github.com/netdata/netdata/issues/15995))
- Convert the ML database  ([#16046](https://github.com/netdata/netdata/issues/16046))
- Improve description about tc.plugin ([#16068](https://github.com/netdata/netdata/issues/16068))
- [Integrations Docs] Add a badge for either netdata or community maintained ([#16073](https://github.com/netdata/netdata/issues/16073))
- Dyncfg add streaming support ([#15791](https://github.com/netdata/netdata/issues/15791))
- Send alerts summary field to cloud ([#16056](https://github.com/netdata/netdata/issues/16056))
- Split cgroup charts ([#15975](https://github.com/netdata/netdata/issues/15975))
- Regenerate integrations.js ([#16062](https://github.com/netdata/netdata/issues/16062))
- Change @linuxnetdata to @netdatahq ([#16082](https://github.com/netdata/netdata/issues/16082))
- Avoid duplicate keys in labels ([#16014](https://github.com/netdata/netdata/issues/16014))
- Systemd-Journal by file ([#16038](https://github.com/netdata/netdata/issues/16038))
- Address reported socket issue ([#16083](https://github.com/netdata/netdata/issues/16083))
- Functions: prevent a busy wait loop ([#16086](https://github.com/netdata/netdata/issues/16086))
- Severity level for logs ([#14727](https://github.com/netdata/netdata/issues/14727))
- Python.d: respect env NETDATA_LOG_SEVERITY_LEVEL ([#16084](https://github.com/netdata/netdata/issues/16084))
- Charts.d: respect env NETDATA_LOG_SEVERITY_LEVEL ([#16085](https://github.com/netdata/netdata/issues/16085))
- Update UI to v6.42.0 ([#16088](https://github.com/netdata/netdata/issues/16088))
- Dont use sd_journal_open_files_fd() that is buggy on older libsystemd ([#16090](https://github.com/netdata/netdata/issues/16090))
- Update UI to v6.42.1 ([#16091](https://github.com/netdata/netdata/issues/16091))
- Update go.d.plugin to v0.56.1 ([#16092](https://github.com/netdata/netdata/issues/16092))
- Fix querying out of retention ([#16094](https://github.com/netdata/netdata/issues/16094))
- Regenerate integrations.js ([#16093](https://github.com/netdata/netdata/issues/16093))
- External plugins: respect env NETDATA_LOG_SEVERITY_LEVEL ([#16089](https://github.com/netdata/netdata/issues/16089))
- Journal: fix incremental queries ([#16098](https://github.com/netdata/netdata/issues/16098))
- A simple journal optimization ([#16099](https://github.com/netdata/netdata/issues/16099))
- Better journal logging ([#16101](https://github.com/netdata/netdata/issues/16101))
- Update UI to v6.42.2 ([#16100](https://github.com/netdata/netdata/issues/16100))
- Update categories.yaml ([#16097](https://github.com/netdata/netdata/issues/16097))
- Fix systemd-journal.plugin README and prepare it for Learn ([#16096](https://github.com/netdata/netdata/issues/16096))
- Add integrations/cloud-notifications to cleanup ([#16102](https://github.com/netdata/netdata/issues/16102))
- Have one documentation page about Netdata Charts ([#16042](https://github.com/netdata/netdata/issues/16042))
- Documentation for Dynamic Configuration ([#15643](https://github.com/netdata/netdata/issues/15643))
- Journal: go up to stop anchor on data only queries ([#16107](https://github.com/netdata/netdata/issues/16107))
- Regenerate integrations.js ([#16103](https://github.com/netdata/netdata/issues/16103))
- Update collectors/python.d.plugin/pandas/metadata.yaml ([#16106](https://github.com/netdata/netdata/issues/16106))
- Skip database migration steps in new installation ([#16071](https://github.com/netdata/netdata/issues/16071))
- Journal: respect anchor on non-data-only queries ([#16109](https://github.com/netdata/netdata/issues/16109))
- Fix in generate integrations docs script ([#16108](https://github.com/netdata/netdata/issues/16108))
- Update UI to v6.43.0 ([#16112](https://github.com/netdata/netdata/issues/16112))
- Fix crash on parsing clabel command with no source ([#16114](https://github.com/netdata/netdata/issues/16114))
- Do not force OOMKill ([#16115](https://github.com/netdata/netdata/issues/16115))
- Regenerate integrations.js ([#16111](https://github.com/netdata/netdata/issues/16111))
- Dont strip newlines when forwarding FUNCTION_PAYLOAD ([#16120](https://github.com/netdata/netdata/issues/16120))
- Split apps charts ([#16095](https://github.com/netdata/netdata/issues/16095))
- Journal: fix the 1 second latency in play mode ([#16123](https://github.com/netdata/netdata/issues/16123))
- Update UI to v6.45.0 ([#16124](https://github.com/netdata/netdata/issues/16124))
- Remove multiple categories due to bug ([#16126](https://github.com/netdata/netdata/issues/16126))
- Regenerate integrations.js ([#16125](https://github.com/netdata/netdata/issues/16125))
- Apps: change user_group to usergroup ([#16131](https://github.com/netdata/netdata/issues/16131))
- Fix journal help and mark debug keys in the output ([#16133](https://github.com/netdata/netdata/issues/16133))
- Fix proc netstat metrics ([#16122](https://github.com/netdata/netdata/issues/16122))
- Retain a list structure instead of a set for data collection integrations categories ([#16130](https://github.com/netdata/netdata/issues/16130))
- Regenerate integrations.js ([#16132](https://github.com/netdata/netdata/issues/16132))
- Add summary to alerts configurations ([#16129](https://github.com/netdata/netdata/issues/16129))
- Remove family from alerts ([#16025](https://github.com/netdata/netdata/issues/16025))
- Fix random crashes on pthread_detach() ([#16137](https://github.com/netdata/netdata/issues/16137))
- Introduce stringify function for integrations ([#16140](https://github.com/netdata/netdata/issues/16140))
- Fixes in integration generation script ([#16141](https://github.com/netdata/netdata/issues/16141))
- Bugfix in integrations/setup/template ([#16142](https://github.com/netdata/netdata/issues/16142))
- Regenerate integrations.js ([#16138](https://github.com/netdata/netdata/issues/16138))
- Update python.d./varnish/metadata.yaml ([#16143](https://github.com/netdata/netdata/issues/16143))
- Regenerate integrations.js ([#16144](https://github.com/netdata/netdata/issues/16144))
- Health: don't log an unknown key error for "families" ([#16145](https://github.com/netdata/netdata/issues/16145))
- Code improvements ([#16104](https://github.com/netdata/netdata/issues/16104))
- Fix `test -x` check for uninstaller script ([#16146](https://github.com/netdata/netdata/issues/16146))
- Journal: updates ([#16150](https://github.com/netdata/netdata/issues/16150))
- Make io charts "write" negative in apps and cgroups (systemd) ([#16152](https://github.com/netdata/netdata/issues/16152))
- Uninstaller: remove ND systemd preset and tmp dir ([#16148](https://github.com/netdata/netdata/issues/16148))
- Docker: make chmod o+rX /  non fatal ([#16156](https://github.com/netdata/netdata/issues/16156))
- Fix compilation warnings ([#16158](https://github.com/netdata/netdata/issues/16158))
- Don't queue removed when there is a newer alert ([#16157](https://github.com/netdata/netdata/issues/16157))
- Batch ML model load commands ([#16155](https://github.com/netdata/netdata/issues/16155))
- [BUGFIX] MQTT ARM fix ([#16154](https://github.com/netdata/netdata/issues/16154))
- Fix repo path for openSUSE 15.5 packages ([#16161](https://github.com/netdata/netdata/issues/16161))
- Modify eBPF exit ([#16159](https://github.com/netdata/netdata/issues/16159))
- Apps: remove mem_private on FreeBSD ([#16166](https://github.com/netdata/netdata/issues/16166))
- Fix netdata-uninstaller; blindly deletes NETDATA_PREFIX env var ([#16167](https://github.com/netdata/netdata/issues/16167))
- Facets: do not corrupt the index when doubling the hashtable ([#16171](https://github.com/netdata/netdata/issues/16171))
- Add icons to integrations markdown files ([#16169](https://github.com/netdata/netdata/issues/16169))
- Regenerate integrations.js ([#16176](https://github.com/netdata/netdata/issues/16176))
- Update go.d to v0.56.2 ([#16181](https://github.com/netdata/netdata/issues/16181))
- Regenerate integrations.js ([#16182](https://github.com/netdata/netdata/issues/16182))
- Disable _go_build in centos 8 & 9 ([#16183](https://github.com/netdata/netdata/issues/16183))
- Add support for Fedora 39 native packages into our CI ([#16180](https://github.com/netdata/netdata/issues/16180))
- Add support for Ubuntu 23.10 native packages into our CI ([#16179](https://github.com/netdata/netdata/issues/16179))
- Update bundled static packages  ([#16177](https://github.com/netdata/netdata/issues/16177))
- Functions columns ([#16184](https://github.com/netdata/netdata/issues/16184))
- Fix access of memory after free ([#16185](https://github.com/netdata/netdata/issues/16185))
- Suppress "families" log ([#16186](https://github.com/netdata/netdata/issues/16186))
- Add agent version on startup ([#16188](https://github.com/netdata/netdata/issues/16188))
- Journal updates ([#16189](https://github.com/netdata/netdata/issues/16189))
- Update bundled UI to v6.49.0 ([#16192](https://github.com/netdata/netdata/issues/16192))
- Faster facets ([#16190](https://github.com/netdata/netdata/issues/16190))
- Systemd-journal timeout to 55 secs ([#16194](https://github.com/netdata/netdata/issues/16194))
- Journal timeout ([#16195](https://github.com/netdata/netdata/issues/16195))
- Apps: always expose "other" group ([#16198](https://github.com/netdata/netdata/issues/16198))
- Health: attach drops ratio alarms to net.drops ([#16199](https://github.com/netdata/netdata/issues/16199))
- Update ui to 6.50.2 ([#16201](https://github.com/netdata/netdata/issues/16201))
- Update ui to 6.50.2 again ([#16202](https://github.com/netdata/netdata/issues/16202))
- Add order in available histograms ([#16204](https://github.com/netdata/netdata/issues/16204))
- Regenerate integrations.js ([#16200](https://github.com/netdata/netdata/issues/16200))
- Rework guide, add SSL with self-signed certs ([#16153](https://github.com/netdata/netdata/issues/16153))
- Ui-6.51.0 ([#16208](https://github.com/netdata/netdata/issues/16208))
- Allow patterns in journal queries ([#16210](https://github.com/netdata/netdata/issues/16210))
- Registry action hello should always work ([#16212](https://github.com/netdata/netdata/issues/16212))
- Apps: fix divide by zero when calc avg uptime ([#16211](https://github.com/netdata/netdata/issues/16211))
- Add summary to /alerts ([#16213](https://github.com/netdata/netdata/issues/16213))
- Disable logging to syslog by default ([#16214](https://github.com/netdata/netdata/issues/16214))
- Update bundled UI to v6.52.0 ([#16216](https://github.com/netdata/netdata/issues/16216))
- Update bundled UI to v6.52.1 ([#16217](https://github.com/netdata/netdata/issues/16217))
- Dynamic meta queue size ([#16218](https://github.com/netdata/netdata/issues/16218))
- Update bundled UI to v6.52.2 ([#16219](https://github.com/netdata/netdata/issues/16219))

## [1.42.0] - 2023-08-09

### Merged Pull Requests:

- Update README.md
- Add linux powercap metrics collector ([#15364](https://github.com/netdata/netdata/issues/15364))
- Add short descriptions to cgroups yaml ([#15457](https://github.com/netdata/netdata/issues/15457))
- Add community key in schema ([#15465](https://github.com/netdata/netdata/issues/15465))
- Freeipmi yaml updates ([#15458](https://github.com/netdata/netdata/issues/15458))
- Macos yaml updates ([#15459](https://github.com/netdata/netdata/issues/15459))
- Update proc plugin yaml ([#15460](https://github.com/netdata/netdata/issues/15460))
- Hash table charts ([#15323](https://github.com/netdata/netdata/issues/15323))
- Store and transmit chart_name to cloud in alert events ([#15441](https://github.com/netdata/netdata/issues/15441))
- Apps.plugin fds limits improvements ([#15467](https://github.com/netdata/netdata/issues/15467))
- Fix the calculation of incremental-sum ([#15468](https://github.com/netdata/netdata/issues/15468))
- Fix non-interactive options for apt-get and zypper. ([#15288](https://github.com/netdata/netdata/issues/15288))
- Meta schema change multi-instance to multi_instance ([#15470](https://github.com/netdata/netdata/issues/15470))
- Fix anchors ([#15469](https://github.com/netdata/netdata/issues/15469))
- Rename most-popular to most_popular in categories.yaml ([#15476](https://github.com/netdata/netdata/issues/15476))
- Fix coverity issue ([#15475](https://github.com/netdata/netdata/issues/15475))
- Overhaul deployment strategies documentation ([#15464](https://github.com/netdata/netdata/issues/15464))
- Docs: note that health foreach works only with template ([#15478](https://github.com/netdata/netdata/issues/15478))
- Update debugfs plugin metadata. ([#15463](https://github.com/netdata/netdata/issues/15463))
- Add basic slabinfo metadata. ([#15484](https://github.com/netdata/netdata/issues/15484))
- Yaml file updates ([#15477](https://github.com/netdata/netdata/issues/15477))
- Memory Controller (MC) and DIMM Error Detection And Correction (EDAC) ([#15473](https://github.com/netdata/netdata/issues/15473))
- Improve the update of the alert chart name in the database ([#15490](https://github.com/netdata/netdata/issues/15490))
- Fix resource leak - CID 396310 ([#15491](https://github.com/netdata/netdata/issues/15491))
- Freeipmi flush keepalive msgs ([#15499](https://github.com/netdata/netdata/issues/15499))
- Update charts.d.plugin yaml ([#15483](https://github.com/netdata/netdata/issues/15483))
- Add required properties to multi-module schema ([#15496](https://github.com/netdata/netdata/issues/15496))
- Apps.plugin limits tracing ([#15504](https://github.com/netdata/netdata/issues/15504))
- Docs: clarify health percentage option ([#15492](https://github.com/netdata/netdata/issues/15492))
- Drop support for native packages of Ubuntu 22.10 ([#15292](https://github.com/netdata/netdata/issues/15292))
- Add a machine distinct id to analytics ([#15485](https://github.com/netdata/netdata/issues/15485))
- EBPF Yaml ([#15474](https://github.com/netdata/netdata/issues/15474))
- Allow manage/health api call to be used without bearer ([#15503](https://github.com/netdata/netdata/issues/15503))
- Make title reflect legacy agent dashboard ([#15479](https://github.com/netdata/netdata/issues/15479))
- Readme: reorder cols in whats new and add links ([#15455](https://github.com/netdata/netdata/issues/15455))
- Add schema for deployment integrations and centralize integrations schemas. ([#15509](https://github.com/netdata/netdata/issues/15509))
- Fill in metadata for idlejitter plugin. ([#15506](https://github.com/netdata/netdata/issues/15506))
- Fix collector multi schema ([#15520](https://github.com/netdata/netdata/issues/15520))
- Wait for node_id while claiming ([#15526](https://github.com/netdata/netdata/issues/15526))
- Allow to create alert hashes with --disable-cloud ([#15519](https://github.com/netdata/netdata/issues/15519))
- Add quick_start key to deploy schema. ([#15522](https://github.com/netdata/netdata/issues/15522))
- Add a schema for the categories.yaml file. ([#15521](https://github.com/netdata/netdata/issues/15521))
- Python collector yaml updates ([#15517](https://github.com/netdata/netdata/issues/15517))
- Update gitignore to include vscode settings for schema validation ([#15508](https://github.com/netdata/netdata/issues/15508))
- Updated all Linux distros, macOS and Docker ([#15532](https://github.com/netdata/netdata/issues/15532))
- Added cloud status in registry?action=hello ([#15530](https://github.com/netdata/netdata/issues/15530))
- Proc integrations ([#15494](https://github.com/netdata/netdata/issues/15494))
- Update platform support info and add a schema. ([#15531](https://github.com/netdata/netdata/issues/15531))
- PCI Advanced Error Reporting (AER) ([#15488](https://github.com/netdata/netdata/issues/15488))
- Update nfacct yaml ([#15535](https://github.com/netdata/netdata/issues/15535))
- Update yaml description (diskspace) ([#15527](https://github.com/netdata/netdata/issues/15527))
- Freeimpi yaml ([#15533](https://github.com/netdata/netdata/issues/15533))
- Update metadata.yaml for some python collectors ([#15513](https://github.com/netdata/netdata/issues/15513))
- Add `diskquota` collector to third party collectors list ([#15524](https://github.com/netdata/netdata/issues/15524))
- Change api.netdata.cloud to app.netdata.cloud ([#15538](https://github.com/netdata/netdata/issues/15538))
- Docs: fix apps fd badges and typos ([#15539](https://github.com/netdata/netdata/issues/15539))
- Bump ui to v6.22.0 ([#15542](https://github.com/netdata/netdata/issues/15542))
- Update metadata.yaml for some python collectors ([#15510](https://github.com/netdata/netdata/issues/15510))
- Update python d varnish metadata ([#15528](https://github.com/netdata/netdata/issues/15528))
- Fill in yaml files for some python collectors ([#15541](https://github.com/netdata/netdata/issues/15541))
- Fix deployment and categories ([#15540](https://github.com/netdata/netdata/issues/15540))
- Add Samba collector yaml ([#15507](https://github.com/netdata/netdata/issues/15507))
- Add exporter integration schema. ([#15545](https://github.com/netdata/netdata/issues/15545))
- Refactor RRD code. ([#15423](https://github.com/netdata/netdata/issues/15423))
- Avoid an extra uuid_copy when creating new MRG entries ([#15502](https://github.com/netdata/netdata/issues/15502))
- Postfix metadata.yaml - add links and some descriptions ([#15544](https://github.com/netdata/netdata/issues/15544))
- Update memcached metadata.yaml ([#15529](https://github.com/netdata/netdata/issues/15529))
- Fix expiration dates for API responses ([#15546](https://github.com/netdata/netdata/issues/15546))
- Bump ui to v6.22.1 ([#15550](https://github.com/netdata/netdata/issues/15550))
- Fixes for `deploy.yaml`. ([#15551](https://github.com/netdata/netdata/issues/15551))
- Fixed typos in code blocks and added missing icons ([#15555](https://github.com/netdata/netdata/issues/15555))
- Add schema and examples for notification method metadata. ([#15549](https://github.com/netdata/netdata/issues/15549))
- Detect the path the netdata-claim.sh script is in ([#15556](https://github.com/netdata/netdata/issues/15556))
- Added Exporter and Notifications categories and removed them from Data Collection ([#15561](https://github.com/netdata/netdata/issues/15561))
- Fix ebpf.plugin system swapcalls ([#15553](https://github.com/netdata/netdata/issues/15553))
- Fix yamls ([#15547](https://github.com/netdata/netdata/issues/15547))
- Update metadata.yaml for some python collectors - 2 ([#15537](https://github.com/netdata/netdata/issues/15537))
- Fix schema validation for some meta files ([#15569](https://github.com/netdata/netdata/issues/15569))
- Added FreeBSD integration and fixed Windows installation Steps ([#15570](https://github.com/netdata/netdata/issues/15570))
- Fixed deployment commands for Docker, Kubernetes and Linux ([#15572](https://github.com/netdata/netdata/issues/15572))
- Timex yaml update ([#15565](https://github.com/netdata/netdata/issues/15565))
- Update ioping yaml ([#15534](https://github.com/netdata/netdata/issues/15534))
- Add missing file in CMakeLists.txt ([#15574](https://github.com/netdata/netdata/issues/15574))
- Drop duplicate / unused index ([#15568](https://github.com/netdata/netdata/issues/15568))
- Xen yaml update ([#15567](https://github.com/netdata/netdata/issues/15567))
- Create metadata.yaml for OpenTSDB Exporter ([#15563](https://github.com/netdata/netdata/issues/15563))
- Small readme icon fix ([#15583](https://github.com/netdata/netdata/issues/15583))
- Filter out systemd-udevd.service/udevd ([#15571](https://github.com/netdata/netdata/issues/15571))
- Remove temporarily  the CI Tumbleweed support ([#15554](https://github.com/netdata/netdata/issues/15554))
- Update icon for power supply ([#15586](https://github.com/netdata/netdata/issues/15586))
- Fix cpu MHz from /proc/cpuinfo ([#15584](https://github.com/netdata/netdata/issues/15584))
- Fix typo in notification schema. ([#15588](https://github.com/netdata/netdata/issues/15588))
- Update metadata for multiple python collectors. ([#15543](https://github.com/netdata/netdata/issues/15543))
- Update Slabinfo Logo ([#15585](https://github.com/netdata/netdata/issues/15585))
- Update icons for relevant integrations in proc.plugin ([#15587](https://github.com/netdata/netdata/issues/15587))
- Create metadata.yaml for JSON exporter ([#15579](https://github.com/netdata/netdata/issues/15579))
- Create metadata.yaml for MongoDB exporter ([#15580](https://github.com/netdata/netdata/issues/15580))
- Create metadata.yaml for AWS kinesis exporter ([#15577](https://github.com/netdata/netdata/issues/15577))
- Create metadata.yaml for Google PubSub exporter ([#15578](https://github.com/netdata/netdata/issues/15578))
- Create multi_metadata.yaml for graphite exporters ([#15576](https://github.com/netdata/netdata/issues/15576))
- Create multi_metadata.yaml ([#15575](https://github.com/netdata/netdata/issues/15575))
- Remove the noise by silencing alerts that dont need to wake up people ([#15590](https://github.com/netdata/netdata/issues/15590))
- Change nvidia_smi link to go version in COLLECTORS.md ([#15536](https://github.com/netdata/netdata/issues/15536))
- Perf yaml ([#15558](https://github.com/netdata/netdata/issues/15558))
- Update slabinfo yaml ([#15560](https://github.com/netdata/netdata/issues/15560))
- TC yaml update ([#15562](https://github.com/netdata/netdata/issues/15562))
- EBPF Yaml complement ([#15516](https://github.com/netdata/netdata/issues/15516))
- Added a sample metadata.yaml for Alerta ([#15591](https://github.com/netdata/netdata/issues/15591))
- Fix health query ([#15589](https://github.com/netdata/netdata/issues/15589))
- CUPS yaml update ([#15594](https://github.com/netdata/netdata/issues/15594))
- Updated icons in deploy section ([#15596](https://github.com/netdata/netdata/issues/15596))
- Fix tomcat meta ([#15592](https://github.com/netdata/netdata/issues/15592))
- 10 points per query min ([#15595](https://github.com/netdata/netdata/issues/15595))
- Update pandas collector metadata ([#15582](https://github.com/netdata/netdata/issues/15582))
- Update zscores metadata yaml ([#15581](https://github.com/netdata/netdata/issues/15581))
- Update python sensors metadata yaml ([#15548](https://github.com/netdata/netdata/issues/15548))
- Update icon ([#15608](https://github.com/netdata/netdata/issues/15608))
- Update icon ([#15607](https://github.com/netdata/netdata/issues/15607))
- Update icons ([#15609](https://github.com/netdata/netdata/issues/15609))
- Sample Cloud Notifications metadata for Discord ([#15597](https://github.com/netdata/netdata/issues/15597))
- Fix descriptions in config objects, make them single line ([#15610](https://github.com/netdata/netdata/issues/15610))
- Remove metrics.csv files ([#15593](https://github.com/netdata/netdata/issues/15593))
- Reviewed icos for a bunch of integrations ([#15599](https://github.com/netdata/netdata/issues/15599))
- Update documentation ([#15606](https://github.com/netdata/netdata/issues/15606))
- Ci disable yamllint line-length check ([#15612](https://github.com/netdata/netdata/issues/15612))
- Comment out anomalies metadata and add note ([#15573](https://github.com/netdata/netdata/issues/15573))
- Update metadata.yaml for charts.d collectors ([#15559](https://github.com/netdata/netdata/issues/15559))
- Fix up notification schema to better support cloud notifications. ([#15616](https://github.com/netdata/netdata/issues/15616))
- Fix icons for db integrations ([#15621](https://github.com/netdata/netdata/issues/15621))
- Fix icons for webservers integrations ([#15624](https://github.com/netdata/netdata/issues/15624))
- Rename multi_metadata.yaml to metadata.yaml ([#15619](https://github.com/netdata/netdata/issues/15619))
- Fix icons for message brokers and hardware ([#15626](https://github.com/netdata/netdata/issues/15626))
- Rename multi_metadata.yaml to metadata.yaml ([#15618](https://github.com/netdata/netdata/issues/15618))
- Updated all cloud notifications except generic webhook ([#15615](https://github.com/netdata/netdata/issues/15615))
- Macos yaml update ([#15602](https://github.com/netdata/netdata/issues/15602))
- Updated Cloud Notification Integrations with the new schema ([#15628](https://github.com/netdata/netdata/issues/15628))
- FreeBSD yaml update ([#15603](https://github.com/netdata/netdata/issues/15603))
- Add notification metadata for agent notifications ([#15622](https://github.com/netdata/netdata/issues/15622))
- Add additional variable section to instance data in schema. ([#15627](https://github.com/netdata/netdata/issues/15627))
- Add key for notifications to control what global config options get displayed ([#15625](https://github.com/netdata/netdata/issues/15625))
- Review images for integrations from security to windows systems ([#15630](https://github.com/netdata/netdata/issues/15630))
- Update metadata.yaml ([#15632](https://github.com/netdata/netdata/issues/15632))
- Debugfs yaml update ([#15633](https://github.com/netdata/netdata/issues/15633))
- Bump ui to v6.23.0 ([#15629](https://github.com/netdata/netdata/issues/15629))
- Fix potential crash bug. ([#15605](https://github.com/netdata/netdata/issues/15605))
- Minor changes in README.md ([#15601](https://github.com/netdata/netdata/issues/15601))
- The icon_filename value was not in quotes - Fixed ([#15635](https://github.com/netdata/netdata/issues/15635))
- Update graphite metadata.yaml ([#15634](https://github.com/netdata/netdata/issues/15634))
- Update netdata-functions.md ([#14441](https://github.com/netdata/netdata/issues/14441))
- Convert collectors meta files from single to multi ([#15642](https://github.com/netdata/netdata/issues/15642))
- Fix icons for notifications ([#15644](https://github.com/netdata/netdata/issues/15644))
- Fix name in the yaml of example python collector ([#15646](https://github.com/netdata/netdata/issues/15646))
- Fix icons ([#15645](https://github.com/netdata/netdata/issues/15645))
- Fixing icons in netdata/netdata repo ([#15647](https://github.com/netdata/netdata/issues/15647))
- Fix exporter schema to support multiple entries per file. ([#15649](https://github.com/netdata/netdata/issues/15649))
- Fixing FreeBSD icons ([#15650](https://github.com/netdata/netdata/issues/15650))
- Fix exporter icons ([#15652](https://github.com/netdata/netdata/issues/15652))
- Disable freeipmi in docker by default ([#15651](https://github.com/netdata/netdata/issues/15651))
- Fix Apps plugin icons ([#15655](https://github.com/netdata/netdata/issues/15655))
- Fix pandas category ([#15654](https://github.com/netdata/netdata/issues/15654))
- Fix icon for solarwinds ([#15657](https://github.com/netdata/netdata/issues/15657))
- Fix proc.plugin meta filename ([#15659](https://github.com/netdata/netdata/issues/15659))
- Update categories.yaml to add notifications ([#15613](https://github.com/netdata/netdata/issues/15613))
- Small improvements to README.md ([#15658](https://github.com/netdata/netdata/issues/15658))
- Freeipmi change restart message to info ([#15664](https://github.com/netdata/netdata/issues/15664))
- Fix icon prometheus exporter icon ([#15666](https://github.com/netdata/netdata/issues/15666))
- Remove " Metrics" from linux categories ([#15669](https://github.com/netdata/netdata/issues/15669))
- Fixing tables (aws sns) ([#15671](https://github.com/netdata/netdata/issues/15671))
- Fix table formatting (custom exporter) ([#15668](https://github.com/netdata/netdata/issues/15668))
- Update metadata.yaml for Cloud Notifications ([#15670](https://github.com/netdata/netdata/issues/15670))
- Fix formatting ([#15673](https://github.com/netdata/netdata/issues/15673))
- Adapt Cloud notifications to the new schema ([#15674](https://github.com/netdata/netdata/issues/15674))
- Update deploy.yaml to fix Docker and Kubernetes commands ([#15676](https://github.com/netdata/netdata/issues/15676))
- Meta MacOS => macOS ([#15675](https://github.com/netdata/netdata/issues/15675))
- Update Webhook icon ([#15677](https://github.com/netdata/netdata/issues/15677))
- Update metadata.yaml ([#15678](https://github.com/netdata/netdata/issues/15678))
- Update metadata.yaml ([#15679](https://github.com/netdata/netdata/issues/15679))
- Update metadata.yaml ([#15680](https://github.com/netdata/netdata/issues/15680))
- Update categories.yaml ([#15681](https://github.com/netdata/netdata/issues/15681))
- Update categories.yaml ([#15682](https://github.com/netdata/netdata/issues/15682))
- Update categories.yaml ([#15683](https://github.com/netdata/netdata/issues/15683))
- Update categories.yaml ([#15685](https://github.com/netdata/netdata/issues/15685))
- Update metadata.yaml ([#15684](https://github.com/netdata/netdata/issues/15684))
- Update deploy.yaml ([#15687](https://github.com/netdata/netdata/issues/15687))
- Update categories.yaml ([#15686](https://github.com/netdata/netdata/issues/15686))
- Update metadata.yaml ([#15688](https://github.com/netdata/netdata/issues/15688))
- Update categories.yaml ([#15689](https://github.com/netdata/netdata/issues/15689))
- Update metadata.yaml ([#15690](https://github.com/netdata/netdata/issues/15690))
- Update names ([#15691](https://github.com/netdata/netdata/issues/15691))
- Bump go.d.plugin v0.54.1 ([#15692](https://github.com/netdata/netdata/issues/15692))
- Fix: 🐛 docker bind-mount stock files creation ([#15639](https://github.com/netdata/netdata/issues/15639))
- Add initial tooling for generating integrations.js file. ([#15406](https://github.com/netdata/netdata/issues/15406))
- Fix integrations regen workflow ([#15693](https://github.com/netdata/netdata/issues/15693))
- Use PyPI packages for integrations generation dependencies.
- Correctly fix dependencies for generating integrations.
- Fix edit-config for containerized Netdata when running from host ([#15641](https://github.com/netdata/netdata/issues/15641))
- Regenerate integrations.js ([#15695](https://github.com/netdata/netdata/issues/15695))
- Extend eBPF default shutdown ([#15694](https://github.com/netdata/netdata/issues/15694))
- Update categories.yaml ([#15696](https://github.com/netdata/netdata/issues/15696))
- Update vscode yaml schemas association ([#15697](https://github.com/netdata/netdata/issues/15697))
- Dynamic Config MVP0 ([#15486](https://github.com/netdata/netdata/issues/15486))
- Fix handling of troubleshooting section in integrations. ([#15700](https://github.com/netdata/netdata/issues/15700))
- Integrations: fix metrics availability ([#15701](https://github.com/netdata/netdata/issues/15701))
- Fix typo in categories for beanstalk collector metadata. ([#15703](https://github.com/netdata/netdata/issues/15703))
- Assorted fixes for integrations templates. ([#15702](https://github.com/netdata/netdata/issues/15702))
- Regenerate integrations.js ([#15705](https://github.com/netdata/netdata/issues/15705))
- Better cleanup of aclk alert table entries ([#15706](https://github.com/netdata/netdata/issues/15706))
- Integrations: fix docker compose indent ([#15708](https://github.com/netdata/netdata/issues/15708))
- Regenerate integrations.js ([#15709](https://github.com/netdata/netdata/issues/15709))
- Update metadata.yaml ([#15710](https://github.com/netdata/netdata/issues/15710))
- Regenerate integrations.js ([#15713](https://github.com/netdata/netdata/issues/15713))
- Fix meta deploy docker swarm NC env var ([#15716](https://github.com/netdata/netdata/issues/15716))
- Regenerate integrations.js ([#15717](https://github.com/netdata/netdata/issues/15717))
- Update the bundled v2 dashboard to the latest release. ([#15718](https://github.com/netdata/netdata/issues/15718))
- Fix the freez pointer of dyncfg ([#15719](https://github.com/netdata/netdata/issues/15719))
- Prefer titles, families, units and priorities from collected charts ([#15614](https://github.com/netdata/netdata/issues/15614))
- Revert "Refactor RRD code. ([#15423](https://github.com/netdata/netdata/issues/15423))" ([#15723](https://github.com/netdata/netdata/issues/15723))
- Disable systemdunits alarms ([#15726](https://github.com/netdata/netdata/issues/15726))
- Fix memory corruption ([#15724](https://github.com/netdata/netdata/issues/15724))
- Systemd-journal plugin ([#15363](https://github.com/netdata/netdata/issues/15363))
- Fix systemd-journal makefile ([#15727](https://github.com/netdata/netdata/issues/15727))
- Changes to the templates for integrations ([#15721](https://github.com/netdata/netdata/issues/15721))
- Regenerate integrations.js ([#15728](https://github.com/netdata/netdata/issues/15728))
- Update to latest copy of v2 dashboard. ([#15735](https://github.com/netdata/netdata/issues/15735))
- Proc.plugin: dont log if pressure/irq does not exist ([#15732](https://github.com/netdata/netdata/issues/15732))
- Adjust namespace used for sd_journal_open ([#15736](https://github.com/netdata/netdata/issues/15736))
- Faster facets and journal fixes ([#15737](https://github.com/netdata/netdata/issues/15737))
- Don't overwrite my vscode settings! ([#15738](https://github.com/netdata/netdata/issues/15738))
- Ci: run "Generate Integrations" only in netdata/netdata ([#15731](https://github.com/netdata/netdata/issues/15731))
- Add systemd-journal.plugin to gitignore ([#15743](https://github.com/netdata/netdata/issues/15743))
- Ci: add systemd-journal and metdata to labeler ([#15746](https://github.com/netdata/netdata/issues/15746))
- Prefer cap over setuid for sysetmd-journal in installer ([#15741](https://github.com/netdata/netdata/issues/15741))
- Add dependencies for systemd journal plugin. ([#15747](https://github.com/netdata/netdata/issues/15747))
- Add netdata-plugin-systemd-journal package. ([#15733](https://github.com/netdata/netdata/issues/15733))
- Meta: align left metrics, alerts, and config options ([#15749](https://github.com/netdata/netdata/issues/15749))
- Regenerate integrations.js ([#15751](https://github.com/netdata/netdata/issues/15751))
- Ci labeler: remove integrations from area/docs ([#15750](https://github.com/netdata/netdata/issues/15750))
- Update bundled UI to v2.26.2 ([#15758](https://github.com/netdata/netdata/issues/15758))
- Fix nvidia_smi power_readings for new drivers ([#15759](https://github.com/netdata/netdata/issues/15759))
- [cloud-blocker] https_client add TLS ext. SNI + support chunked transfer encoding ([#15739](https://github.com/netdata/netdata/issues/15739))
- Add AMD GPU collector  ([#15515](https://github.com/netdata/netdata/issues/15515))
- Update metadata.yaml ([#15762](https://github.com/netdata/netdata/issues/15762))
- Update metadata.yaml ([#15761](https://github.com/netdata/netdata/issues/15761))
- Update metadata.yaml
- Regenerate integrations.js ([#15760](https://github.com/netdata/netdata/issues/15760))
- Meta update proc drm icon ([#15763](https://github.com/netdata/netdata/issues/15763))
- Regenerate integrations.js ([#15764](https://github.com/netdata/netdata/issues/15764))
- Update ui to v6.26.3 ([#15767](https://github.com/netdata/netdata/issues/15767))
- Fix CID 398318 ([#15766](https://github.com/netdata/netdata/issues/15766))
- Change FreeBSD / macOS system.swap(io) to mem.swap(io) ([#15769](https://github.com/netdata/netdata/issues/15769))
- Fix coverity issues introduced via drm proc module ([#15765](https://github.com/netdata/netdata/issues/15765))
- Extend the trimming window to avoid empty points at the end of queries ([#15773](https://github.com/netdata/netdata/issues/15773))
- Regenerate integrations.js ([#15772](https://github.com/netdata/netdata/issues/15772))
- Fix claiming via UI for static build ([#15774](https://github.com/netdata/netdata/issues/15774))
- Ci: codacy exclude web/gui/v2/ ([#15780](https://github.com/netdata/netdata/issues/15780))
- Ci: fix labeler area/docs ([#15776](https://github.com/netdata/netdata/issues/15776))
- Update UI to v6.27.0 ([#15778](https://github.com/netdata/netdata/issues/15778))

## [1.41.0] - 2023-07-19

### Merged Pull Requests:

- Redirect to index.html when a file is not found by web server ([#15143](https://github.com/netdata/netdata/issues/15143))
- Sqlite_health.c: remove `uuid.h` include ([#15195](https://github.com/netdata/netdata/issues/15195))
- RPM: Added elfutils-libelf-devel for build with eBPF (again) ([#15192](https://github.com/netdata/netdata/issues/15192))
- Consistently start the agent as root and rely on it to drop privileges properly. ([#14890](https://github.com/netdata/netdata/issues/14890))
- RocketChat cloud integration docs ([#15205](https://github.com/netdata/netdata/issues/15205))
- Fix file permissions under directory ([#15208](https://github.com/netdata/netdata/issues/15208))
- Fix health crash ([#15209](https://github.com/netdata/netdata/issues/15209))
- Add two functions that allow someone to start/stop ML. ([#15185](https://github.com/netdata/netdata/issues/15185))
- Speed up eBPF exit before to bring functions ([#15187](https://github.com/netdata/netdata/issues/15187))
- Fix issues in sync thread (eBPF plugin) ([#15174](https://github.com/netdata/netdata/issues/15174))
- /api/v2/nodes and streaming function ([#15168](https://github.com/netdata/netdata/issues/15168))
- Obvious memory reductions ([#15204](https://github.com/netdata/netdata/issues/15204))
- RW_SPINLOCK: recursive readers support ([#15217](https://github.com/netdata/netdata/issues/15217))
- Update dashboard to version v3.0.0. ([#15219](https://github.com/netdata/netdata/issues/15219))
- Cgroups: remove pod_uid and container_id labels in k8s ([#15216](https://github.com/netdata/netdata/issues/15216))
- Fix arch detection on i386 (native packages) ([#15218](https://github.com/netdata/netdata/issues/15218))
- Fix /api/v2/contexts,nodes,nodes_instances,q before match ([#15223](https://github.com/netdata/netdata/issues/15223))
- Fix SSL non-blocking retry handling in the web server ([#15222](https://github.com/netdata/netdata/issues/15222))
- Use a single health log table ([#15157](https://github.com/netdata/netdata/issues/15157))
- Remove erroneous space for unit ([#15226](https://github.com/netdata/netdata/issues/15226))
- Allow overriding pipename from env ([#15215](https://github.com/netdata/netdata/issues/15215))
- Fix not handling N/A value in python.d/nvidia_smi ([#15231](https://github.com/netdata/netdata/issues/15231))
- /api/v2 improvements ([#15227](https://github.com/netdata/netdata/issues/15227))
- Create index for health log migration ([#15233](https://github.com/netdata/netdata/issues/15233))
- New alerts endpoint ([#15232](https://github.com/netdata/netdata/issues/15232))
- Add module column to apps.plugin csv ([#15235](https://github.com/netdata/netdata/issues/15235))
- Fix handling of plugin ownership in static builds. ([#15230](https://github.com/netdata/netdata/issues/15230))
- Install the correct systemd unit file on older RPM systems. ([#15240](https://github.com/netdata/netdata/issues/15240))
- Fix coverity 393183 & 393182 ([#15234](https://github.com/netdata/netdata/issues/15234))
- URL rewrite at the agent web server to support multiple dashboard versions ([#15247](https://github.com/netdata/netdata/issues/15247))
- Relax jnfv2 caching ([#15224](https://github.com/netdata/netdata/issues/15224))
- Use gperf for the pluginsd/streaming parser hashtable ([#15251](https://github.com/netdata/netdata/issues/15251))
- Delay collecting virtual network interfaces ([#15244](https://github.com/netdata/netdata/issues/15244))
- Update pfsense.md package install instructions ([#15250](https://github.com/netdata/netdata/issues/15250))
- Fix $(libh2o_dir) not expanded properly sometimes. ([#15253](https://github.com/netdata/netdata/issues/15253))
- Update libbpf version ([#15258](https://github.com/netdata/netdata/issues/15258))
- Fix tc.plugin charts labels ([#15262](https://github.com/netdata/netdata/issues/15262))
- Assorted kickstart script improvements. ([#15243](https://github.com/netdata/netdata/issues/15243))
- Add hardening options to CFLAGS by default if they are available. ([#15087](https://github.com/netdata/netdata/issues/15087))
- Small readme improvements ([#15270](https://github.com/netdata/netdata/issues/15270))
- Exporting: change priority to synchronous when calculating value ([#15276](https://github.com/netdata/netdata/issues/15276))
- Rewrite /api/v2/alerts ([#15257](https://github.com/netdata/netdata/issues/15257))
- Optimizations Part 2 ([#15267](https://github.com/netdata/netdata/issues/15267))
- Agent dashboard reorganization. ([#15200](https://github.com/netdata/netdata/issues/15200))
- Revert "Optimizations Part 2" ([#15279](https://github.com/netdata/netdata/issues/15279))
- Fixed mistype for 'send automatic labels' Prometheus option ([#15282](https://github.com/netdata/netdata/issues/15282))
- Optimizations part 2 ([#15280](https://github.com/netdata/netdata/issues/15280))
- Add configuration file for netdata-updater.sh. ([#15149](https://github.com/netdata/netdata/issues/15149))
- Misc alert fixes ([#15274](https://github.com/netdata/netdata/issues/15274))
- Use stat() instead of lstat() ([#15287](https://github.com/netdata/netdata/issues/15287))
- Only try to enable _FORTIFY_SOURCE if the user has not disabled optimizations ([#15284](https://github.com/netdata/netdata/issues/15284))
- Expose CmdLine in apps function ([#15275](https://github.com/netdata/netdata/issues/15275))
- Merged spaces, war rooms and invite your team to one place ([#15289](https://github.com/netdata/netdata/issues/15289))
- Docs: update stream.conf "health enabled by default" description ([#15291](https://github.com/netdata/netdata/issues/15291))
- Replace `info` macro with a less generic name ([#15266](https://github.com/netdata/netdata/issues/15266))
- Optimizations part 3 ([#15293](https://github.com/netdata/netdata/issues/15293))
- Remove extra parenthesis from doc ([#15290](https://github.com/netdata/netdata/issues/15290))
- Add profile.plugin ([#13962](https://github.com/netdata/netdata/issues/13962))
- S/info/netdata_log_info/ ([#15299](https://github.com/netdata/netdata/issues/15299))
- Yaml template finalization ([#15265](https://github.com/netdata/netdata/issues/15265))
- Send alert chart labels config key to cloud ([#15283](https://github.com/netdata/netdata/issues/15283))
- Change info to netdata_log_info in sqlite_db_migration.c ([#15303](https://github.com/netdata/netdata/issues/15303))
- Ci: disable clang format ([#15305](https://github.com/netdata/netdata/issues/15305))
- Check for source field when requesting /api/v1/alarm_log ([#15306](https://github.com/netdata/netdata/issues/15306))
- Release acquired dimensions ([#15307](https://github.com/netdata/netdata/issues/15307))
- Change query to store host system info values ([#15300](https://github.com/netdata/netdata/issues/15300))
- Move collectors meta to metadata/ ([#15308](https://github.com/netdata/netdata/issues/15308))
- Update metrics-streaming-and-replication.md ([#15297](https://github.com/netdata/netdata/issues/15297))
- Fix wording issue in Docker README ([#15298](https://github.com/netdata/netdata/issues/15298))
- Health: respect overriding nc binary for IRC notifications ([#15310](https://github.com/netdata/netdata/issues/15310))
- Hide not available for viewers charts when exporting in shell format ([#15309](https://github.com/netdata/netdata/issues/15309))
- Code reorg and cleanup - enrichment of /api/v2 ([#15294](https://github.com/netdata/netdata/issues/15294))
- Fix(alerting): removing some of criticals ([#15124](https://github.com/netdata/netdata/issues/15124))
- Stale vitual hosts ([#15313](https://github.com/netdata/netdata/issues/15313))
- Fix alerts transitions sorting ([#15315](https://github.com/netdata/netdata/issues/15315))
- Additional CO-RE code (eBPF.plugin) ([#15078](https://github.com/netdata/netdata/issues/15078))
- Bump go.d.plugin to v0.54.0 ([#15312](https://github.com/netdata/netdata/issues/15312))
- Add add summary linking to alert instances (ati) when options=summary,values is requested ([#15317](https://github.com/netdata/netdata/issues/15317))
- Local-listener using libnetdata ([#15319](https://github.com/netdata/netdata/issues/15319))
- Avoid memory allocations for alert transitions facets processing ([#15318](https://github.com/netdata/netdata/issues/15318))
- Local-listeners: use host prefix in read_cmdline ([#15320](https://github.com/netdata/netdata/issues/15320))
- Rename generic `error` function ([#15296](https://github.com/netdata/netdata/issues/15296))
- Create integrations JSON schema ([#15302](https://github.com/netdata/netdata/issues/15302))
- Fix coverity issue 394862 - Argument cannot be negative ([#15324](https://github.com/netdata/netdata/issues/15324))
- Single module schema, add required properties ([#15326](https://github.com/netdata/netdata/issues/15326))
- Fix compilation on BSD ([#15331](https://github.com/netdata/netdata/issues/15331))
- Alerts_transitions outputs hostnames and items statistics ([#15329](https://github.com/netdata/netdata/issues/15329))
- Add missing required field in schema ([#15335](https://github.com/netdata/netdata/issues/15335))
- Multi-threaded version of freeipmi.plugin ([#15327](https://github.com/netdata/netdata/issues/15327))
- Use spinlock in host and chart ([#15328](https://github.com/netdata/netdata/issues/15328))
- Add internal stats metrics csv ([#15337](https://github.com/netdata/netdata/issues/15337))
- Bearer authorization API ([#15321](https://github.com/netdata/netdata/issues/15321))
- Bearer improvements ([#15342](https://github.com/netdata/netdata/issues/15342))
- Fix workflow references in release workflow.
- Remove availability from required fields on metric level ([#15340](https://github.com/netdata/netdata/issues/15340))
- Fix coverity issues ([#15345](https://github.com/netdata/netdata/issues/15345))
- Bearer protection - additions ([#15349](https://github.com/netdata/netdata/issues/15349))
- Add missing labels to freeipmi metrics csv ([#15347](https://github.com/netdata/netdata/issues/15347))
- Health: fix evaluating expression with `nan` ([#15348](https://github.com/netdata/netdata/issues/15348))
- Add yaml metadata for metrics.csv files ([#15238](https://github.com/netdata/netdata/issues/15238))
- Fix installation type command ([#15351](https://github.com/netdata/netdata/issues/15351))
- Docs: make the default Docker installation provide the full feature set ([#15339](https://github.com/netdata/netdata/issues/15339))
- Attempt to more aggressively skip CI jobs on PRs if those jobs are irrelevant to the PR. ([#15341](https://github.com/netdata/netdata/issues/15341))
- Update dashboard to version v3.0.1. ([#15352](https://github.com/netdata/netdata/issues/15352))
- Rename log Macros (debug) ([#15322](https://github.com/netdata/netdata/issues/15322))
- Rename multi module yamls to same name but wuth prefix ([#15356](https://github.com/netdata/netdata/issues/15356))
- Fix(freeipmi): set sensor state on every reading ([#15360](https://github.com/netdata/netdata/issues/15360))
- Format the sdr cache filenames ([#15361](https://github.com/netdata/netdata/issues/15361))
- Keep health log history in seconds ([#15314](https://github.com/netdata/netdata/issues/15314))
- Move not really related props single-module.json -> definitions.json ([#15366](https://github.com/netdata/netdata/issues/15366))
- Update libbpf on netdata repo ([#15343](https://github.com/netdata/netdata/issues/15343))
- Add keys to integrations schema, categories, icon path, plus some fixes ([#15365](https://github.com/netdata/netdata/issues/15365))
- Dont log error on opening .environment ([#15371](https://github.com/netdata/netdata/issues/15371))
- Simplify collector schema by moving some props under meta ([#15372](https://github.com/netdata/netdata/issues/15372))
- Add most-popular entry in oneOf of categories in definitions.json ([#15370](https://github.com/netdata/netdata/issues/15370))
- EBPF Functions (enable/disable threads) ([#15214](https://github.com/netdata/netdata/issues/15214))
- Health: fix windows alarms for vnodes ([#15376](https://github.com/netdata/netdata/issues/15376))
- Update bundled v2 dashboard. ([#15374](https://github.com/netdata/netdata/issues/15374))
- Agent alert notifications redirect ([#15350](https://github.com/netdata/netdata/issues/15350))
- Update bundled v2 dashboard ([#15377](https://github.com/netdata/netdata/issues/15377))
- Fix coverity issues ([#15375](https://github.com/netdata/netdata/issues/15375))
- Rename log_access and log_health ([#15368](https://github.com/netdata/netdata/issues/15368))
- Update http response code descriptions ([#15379](https://github.com/netdata/netdata/issues/15379))
- Fix CodeQL alert  ([#15384](https://github.com/netdata/netdata/issues/15384))
- Update libbpf version (1.2.2) ([#15373](https://github.com/netdata/netdata/issues/15373))
- Add missing files to web/gui/Makefile.am. ([#15383](https://github.com/netdata/netdata/issues/15383))
- Updates on JSON schemas ([#15382](https://github.com/netdata/netdata/issues/15382))
- Update bundled v2 dashboard; make v2 the default dashboard ([#15386](https://github.com/netdata/netdata/issues/15386))
- Dont add all nodes to registry action hello ([#15388](https://github.com/netdata/netdata/issues/15388))
- Revert "dont add all nodes to registry action hello" ([#15389](https://github.com/netdata/netdata/issues/15389))
- Dont add all nodes to registry action hello ([#15390](https://github.com/netdata/netdata/issues/15390))
- Add expiration to bearer token response ([#15392](https://github.com/netdata/netdata/issues/15392))
- Packaging: fix arch detection in update_static ([#15396](https://github.com/netdata/netdata/issues/15396))
- Collector meta schema: global config examples folding + per example ([#15398](https://github.com/netdata/netdata/issues/15398))
- Make yamls pass the schema, and use decided temporary naming scheme ([#15401](https://github.com/netdata/netdata/issues/15401))
- Create categories.yaml ([#15385](https://github.com/netdata/netdata/issues/15385))
- Bump v2 dashboard to latest prod ([#15402](https://github.com/netdata/netdata/issues/15402))
- Remove collector meta definitions ([#15403](https://github.com/netdata/netdata/issues/15403))
- Pre release fixes ([#15405](https://github.com/netdata/netdata/issues/15405))
- Hide eBPF functions ([#15404](https://github.com/netdata/netdata/issues/15404))
- Add reference to cncf ([#15408](https://github.com/netdata/netdata/issues/15408))
- Update README.md ([#15044](https://github.com/netdata/netdata/issues/15044))
- Update README.md ([#15412](https://github.com/netdata/netdata/issues/15412))
- Update README.md ([#15414](https://github.com/netdata/netdata/issues/15414))
- Update README.md ([#15416](https://github.com/netdata/netdata/issues/15416))
- Update README.md
- Update REDISTRIBUTED.md
- Collector meta: restrict chart_type to known values ([#15413](https://github.com/netdata/netdata/issues/15413))
- Make skipped CI run even faster. ([#15407](https://github.com/netdata/netdata/issues/15407))
- Use real-time clock for http response headers ([#15421](https://github.com/netdata/netdata/issues/15421))
- Minor typo fix on consul.conf ([#15419](https://github.com/netdata/netdata/issues/15419))
- Support nativa packages for openSUSE tumbleweed ([#14692](https://github.com/netdata/netdata/issues/14692))
- Update README.md ([#15424](https://github.com/netdata/netdata/issues/15424))
- Fix unlocked registry access and add hostname to search response ([#15426](https://github.com/netdata/netdata/issues/15426))
- Update v2 dashboard ([#15427](https://github.com/netdata/netdata/issues/15427))
- Monitor applications file descriptor limits ([#15417](https://github.com/netdata/netdata/issues/15417))
- Bugfix on alerts generation for yamls ([#15420](https://github.com/netdata/netdata/issues/15420))
- Suppress H2O compilation warnings ([#15378](https://github.com/netdata/netdata/issues/15378))
- Remove duplicate category from categories.yaml ([#15432](https://github.com/netdata/netdata/issues/15432))
- Readme: add link for netdata cloud and sign-in cta ([#15431](https://github.com/netdata/netdata/issues/15431))
- Decode url before checking for question mark ([#15422](https://github.com/netdata/netdata/issues/15422))
- Add catch-all category entry in categories.yaml ([#15434](https://github.com/netdata/netdata/issues/15434))
- Build optimizations ([#15381](https://github.com/netdata/netdata/issues/15381))
- Add chart id and name to alert instances and transitions ([#15430](https://github.com/netdata/netdata/issues/15430))
- Disable apps_group_file_descriptors_utilization alarm ([#15435](https://github.com/netdata/netdata/issues/15435))
- Apps.plugin fds limits improvements ([#15437](https://github.com/netdata/netdata/issues/15437))
- Update CODEOWNERS ([#15433](https://github.com/netdata/netdata/issues/15433))
- Removed dup categories ([#15440](https://github.com/netdata/netdata/issues/15440))
- Added missing fields to alerts instances ([#15442](https://github.com/netdata/netdata/issues/15442))
- Fix alerts transitions search when something specific is asked for ([#15447](https://github.com/netdata/netdata/issues/15447))
- Collector meta: remove meta.alternative_monitored_instances ([#15445](https://github.com/netdata/netdata/issues/15445))
- Bump v2 dashboard to v6.21.3 ([#15448](https://github.com/netdata/netdata/issues/15448))
- Fix multiline ([#15449](https://github.com/netdata/netdata/issues/15449))
- Create netdata-assistant docs ([#15438](https://github.com/netdata/netdata/issues/15438))
- Documentation update for the release of the new UI ([#15359](https://github.com/netdata/netdata/issues/15359))
- Add cgroups yaml ([#15450](https://github.com/netdata/netdata/issues/15450))
- Add apps yaml ([#15451](https://github.com/netdata/netdata/issues/15451))
- Updates to metadata.yaml ([#15452](https://github.com/netdata/netdata/issues/15452))
- Include license for web v2 ([#15453](https://github.com/netdata/netdata/issues/15453))

## [1.40.0] - 2023-06-14

### Merged Pull Requests:

- Update chart documentation ([#15010](https://github.com/netdata/netdata/issues/15010))
- Review the billing docs for the flow ([#15014](https://github.com/netdata/netdata/issues/15014))
- Rollback ML transaction on failure. ([#15013](https://github.com/netdata/netdata/issues/15013))
- Update troubleshooting-agent-with-cloud-connection.md ([#15029](https://github.com/netdata/netdata/issues/15029))
- Slight wording fix on the database readme ([#15034](https://github.com/netdata/netdata/issues/15034))
- Silence dimensions with noisy ML models ([#15011](https://github.com/netdata/netdata/issues/15011))
- Adjust buffers to prevent overflow ([#15025](https://github.com/netdata/netdata/issues/15025))
- Initial minimal h2o webserver integration ([#14585](https://github.com/netdata/netdata/issues/14585))
- Make zlib compulsory dep ([#14928](https://github.com/netdata/netdata/issues/14928))
- Update tor.chart.py ([#15041](https://github.com/netdata/netdata/issues/15041))
- Remove old logic for handling of legacy stock config files. ([#14829](https://github.com/netdata/netdata/issues/14829))
- Fatal in claim() only if --claim-only is used ([#15039](https://github.com/netdata/netdata/issues/15039))
- Libjudy: remove JudyLTablesGen ([#14984](https://github.com/netdata/netdata/issues/14984))
- Fix handling of permissions in static installs. ([#15042](https://github.com/netdata/netdata/issues/15042))
- Wording fix in interact with charts doc ([#15040](https://github.com/netdata/netdata/issues/15040))
- Small update ml defaults ([#15046](https://github.com/netdata/netdata/issues/15046))
- Update SQLITE to version 3.41.2 ([#15031](https://github.com/netdata/netdata/issues/15031))
- Reduce netdatacli size ([#15024](https://github.com/netdata/netdata/issues/15024))
- Bump google-github-actions/setup-gcloud from 1.1.0 to 1.1.1 ([#15053](https://github.com/netdata/netdata/issues/15053))
- Bump google-github-actions/upload-cloud-storage from 1.0.1 to 1.0.3 ([#15052](https://github.com/netdata/netdata/issues/15052))
- Comment out default `role_recipients_*` values ([#15047](https://github.com/netdata/netdata/issues/15047))
- Debugfs collector ([#15017](https://github.com/netdata/netdata/issues/15017))
- Fix(debugfs/zswap): don't collect metrics if Zswap is disabled ([#15054](https://github.com/netdata/netdata/issues/15054))
- Fix ACLK memleak ([#15055](https://github.com/netdata/netdata/issues/15055))
- Bump go.d.plugin to v0.53.0 ([#15059](https://github.com/netdata/netdata/issues/15059))
- Fix infiniband bytes counters multiplier and divisor ([#14748](https://github.com/netdata/netdata/issues/14748))
- Remove Fedora 36 from CI and platform support. ([#14938](https://github.com/netdata/netdata/issues/14938))
- Fix memory leak when sending alerts checkoint ([#15060](https://github.com/netdata/netdata/issues/15060))
- Update netdata-security.md ([#15063](https://github.com/netdata/netdata/issues/15063))
- Update CODEOWNERS ([#15064](https://github.com/netdata/netdata/issues/15064))
- Update netdata-security.md ([#15067](https://github.com/netdata/netdata/issues/15067))
- Update netdata-security.md ([#15068](https://github.com/netdata/netdata/issues/15068))
- Honor maximum message size limit of MQTT server ([#15009](https://github.com/netdata/netdata/issues/15009))
- Fix CodeQL warning  ([#15062](https://github.com/netdata/netdata/issues/15062))
- Update Security doc ([#15072](https://github.com/netdata/netdata/issues/15072))
- Free context when establishing ACLK connection ([#15073](https://github.com/netdata/netdata/issues/15073))
- Simplify loop in alert checkpoint ([#15065](https://github.com/netdata/netdata/issues/15065))
- Use chart labels to filter alerts ([#14982](https://github.com/netdata/netdata/issues/14982))
- Python Dependency Migration - OracleDB Python Module ([#15074](https://github.com/netdata/netdata/issues/15074))
- Better cleanup of health log table ([#15045](https://github.com/netdata/netdata/issues/15045))
- Try to detect bind mounts ([#14831](https://github.com/netdata/netdata/issues/14831))
- Release buffer in case of error -- CID 385075 ([#15090](https://github.com/netdata/netdata/issues/15090))
- Mentioned waive off of space subscription price ([#15082](https://github.com/netdata/netdata/issues/15082))
- Create category overview pages for learn's restructure ([#15091](https://github.com/netdata/netdata/issues/15091))
- Address issue with Thanos Receiver ([#15094](https://github.com/netdata/netdata/issues/15094))
- Fix cockroachdb alarms ([#15095](https://github.com/netdata/netdata/issues/15095))
- New eBPF option ([#14691](https://github.com/netdata/netdata/issues/14691))
- Invert order in remote write ([#15097](https://github.com/netdata/netdata/issues/15097))
- Add chart labels to Prometheus. ([#15099](https://github.com/netdata/netdata/issues/15099))
- /api/v2/data percentage calculation on grouped queries ([#15100](https://github.com/netdata/netdata/issues/15100))
- Update ml defaults to 24h ([#15093](https://github.com/netdata/netdata/issues/15093))
- Fix the units when returning percentage of a group ([#15105](https://github.com/netdata/netdata/issues/15105))
- Percentage-of-group: fix uninitialized array vh ([#15106](https://github.com/netdata/netdata/issues/15106))
- Update agent telemetry url to be cloud function instead of posthog ([#15085](https://github.com/netdata/netdata/issues/15085))
- Oracledb: make conn protocol configurable ([#15104](https://github.com/netdata/netdata/issues/15104))
- Only queue an alert to the cloud when it's inserted ([#15110](https://github.com/netdata/netdata/issues/15110))
- Percentage of group is now aggregatable at cloud across multiple nodes ([#15109](https://github.com/netdata/netdata/issues/15109))
- Split plugins to individual packages for DEB/RPM packaging. ([#13927](https://github.com/netdata/netdata/issues/13927))
- Improve some of the error messages in the kickstart script. ([#15061](https://github.com/netdata/netdata/issues/15061))
- Initial draft for the silencing docs ([#15112](https://github.com/netdata/netdata/issues/15112))
- Fix handling of eBPF plugin for DEB packages. ([#15117](https://github.com/netdata/netdata/issues/15117))
- Revert "percentage of group is now aggregatable at cloud across multiple nodes" ([#15122](https://github.com/netdata/netdata/issues/15122))
- Fix package versioning issues. ([#15125](https://github.com/netdata/netdata/issues/15125))
- Percentage of group aggregatable at cloud - fixed for backwards compatibility ([#15126](https://github.com/netdata/netdata/issues/15126))
- Add netdata demo rooms to the list of demo urls ([#15120](https://github.com/netdata/netdata/issues/15120))
- Fix bundling of eBPF legacy code for DEB packages. ([#15127](https://github.com/netdata/netdata/issues/15127))
- Health: remove "families" from alarms config ([#15086](https://github.com/netdata/netdata/issues/15086))
- Fix: allow square brackets in label value ([#15131](https://github.com/netdata/netdata/issues/15131))
- Provide necessary permission for the kickstart to run the netdata-updater script ([#15132](https://github.com/netdata/netdata/issues/15132))
- Fix a typo in `libnetdata/simple_pattern/README.md` ([#15135](https://github.com/netdata/netdata/issues/15135))
- Updated events docs and minor fix on silecing rules table ([#15134](https://github.com/netdata/netdata/issues/15134))
- Generate, store and transmit a unique alert event_hash_id ([#15111](https://github.com/netdata/netdata/issues/15111))
- Minor - fix syntax in config.ac ([#15139](https://github.com/netdata/netdata/issues/15139))
- Send EXIT before exiting in freeipmi and debugfs plugins ([#15140](https://github.com/netdata/netdata/issues/15140))
- Check null transition id and config hash ([#15147](https://github.com/netdata/netdata/issues/15147))
- Mattermost cloud integration docs ([#15141](https://github.com/netdata/netdata/issues/15141))
- Update libbpf ([#15038](https://github.com/netdata/netdata/issues/15038))
- Freeipmi: add availability status chart and alarm ([#15151](https://github.com/netdata/netdata/issues/15151))
- Re-write of SSL support in Netdata; restoration of SIGCHLD; detection of stale plugins; streaming improvements ([#15113](https://github.com/netdata/netdata/issues/15113))
- Make plugin packages hard dependencies. ([#15160](https://github.com/netdata/netdata/issues/15160))
- Restrict ebpf dep in DEB package to amd64 only. ([#15161](https://github.com/netdata/netdata/issues/15161))
- Add library to encode/decode Gorilla compressed buffers. ([#15128](https://github.com/netdata/netdata/issues/15128))
- Fix CID 385073 -- Uninitialized scalar variable ([#15163](https://github.com/netdata/netdata/issues/15163))
- Api v2 nodes for streaming statuses ([#15162](https://github.com/netdata/netdata/issues/15162))
- Change mandatory packages for RPMs ([#15165](https://github.com/netdata/netdata/issues/15165))
- Fix user and group handling in DEB packages. ([#15166](https://github.com/netdata/netdata/issues/15166))
- Fix coverity issues ([#15169](https://github.com/netdata/netdata/issues/15169))
- Update smartd_log.conf ([#15171](https://github.com/netdata/netdata/issues/15171))
- Change package conflicts policy on deb based packages ([#15170](https://github.com/netdata/netdata/issues/15170))
- Bump go.d.plugin to v0.53.1 ([#15179](https://github.com/netdata/netdata/issues/15179))
- EBPF unittest + bug fix ([#15146](https://github.com/netdata/netdata/issues/15146))
- Do strdupz on empty string ([#15183](https://github.com/netdata/netdata/issues/15183))
- Set setuid for go.d.plugin in container ([#15180](https://github.com/netdata/netdata/issues/15180))
- Bump go.d.plugin to v0.53.2 ([#15184](https://github.com/netdata/netdata/issues/15184))
- Ebpf: disable sync by default ([#15190](https://github.com/netdata/netdata/issues/15190))
- Add support for openSUSE 15.5 ([#15189](https://github.com/netdata/netdata/issues/15189))

## [1.39.0] - 2023-05-08

### Merged Pull Requests:

- Typos in in notification docs ([#14440](https://github.com/netdata/netdata/issues/14440))
- Add @andrewm4894 as docs/ codeowner ([#14398](https://github.com/netdata/netdata/issues/14398))
- Kickstart.sh: Fix `--release-channel` as `--nightly-channel` options ([#14424](https://github.com/netdata/netdata/issues/14424))
- Indicate what root privileges are needed for in kickstart.sh. ([#14314](https://github.com/netdata/netdata/issues/14314))
- Roles permissions docs ([#14391](https://github.com/netdata/netdata/issues/14391))
- Minor fix in the metadata of libnetdata/ebpf AND log documents ([#14445](https://github.com/netdata/netdata/issues/14445))
- Minor fix, convert metadata of the learn to hidden sections ([#14427](https://github.com/netdata/netdata/issues/14427))
- Do not report dimensions that failed to be queried ([#14447](https://github.com/netdata/netdata/issues/14447))
- Fix agent build failure on FreeBSD 14.0 due to new tcpstat struct ([#14446](https://github.com/netdata/netdata/issues/14446))
- Add cakrit as docs and md codeowner ([#14442](https://github.com/netdata/netdata/issues/14442))
- Roles permissions docs ([#14444](https://github.com/netdata/netdata/issues/14444))
- Add note about not needing to have room id ([#14390](https://github.com/netdata/netdata/issues/14390))
- Add mention of cloud in next steps UI etc ([#14459](https://github.com/netdata/netdata/issues/14459))
- Update the "Kubernetes visualizations" doc ([#14347](https://github.com/netdata/netdata/issues/14347))
- Update the "Install Netdata with kickstart.sh" doc ([#14338](https://github.com/netdata/netdata/issues/14338))
- Streaming interpolated values ([#14431](https://github.com/netdata/netdata/issues/14431))
- Remove deprecated python.d collectors announced in v1.38.0 ([#14454](https://github.com/netdata/netdata/issues/14454))
- Fix the concurrency group name for PR labeler workflow. ([#14460](https://github.com/netdata/netdata/issues/14460))
- Bump google-github-actions/setup-gcloud from 1.0.1 to 1.1.0 ([#14438](https://github.com/netdata/netdata/issues/14438))
- Bump docker/build-push-action from 3 to 4 ([#14437](https://github.com/netdata/netdata/issues/14437))
- Fix links and add to learn ([#14458](https://github.com/netdata/netdata/issues/14458))
- Add export for people running their own registry ([#14457](https://github.com/netdata/netdata/issues/14457))
- Add contents of packaging/installer/readme.md ([#14461](https://github.com/netdata/netdata/issues/14461))
- Only load required charts for rrdvars ([#14443](https://github.com/netdata/netdata/issues/14443))
- Update the "Install Netdata with Docker" doc ([#14385](https://github.com/netdata/netdata/issues/14385))
- Delete docs/cloud/get-started.mdx ([#14382](https://github.com/netdata/netdata/issues/14382))
- Update the "Deploy Kubernetes monitoring with Netdata" doc ([#14345](https://github.com/netdata/netdata/issues/14345))
- Update static build packages ([#14450](https://github.com/netdata/netdata/issues/14450))
- Moved contents of get started to installer readme ([#14467](https://github.com/netdata/netdata/issues/14467))
- Correct link to ansible playbook ([#14468](https://github.com/netdata/netdata/issues/14468))
- Move ansible md ([#14469](https://github.com/netdata/netdata/issues/14469))
- Add markdown files in Learn ([#14466](https://github.com/netdata/netdata/issues/14466))
- Fix a possible bug with an image ([#14472](https://github.com/netdata/netdata/issues/14472))
- Add sbindir_POST template for v235 service file ([#14471](https://github.com/netdata/netdata/issues/14471))
- Fix random crash on agent shutdown ([#14470](https://github.com/netdata/netdata/issues/14470))
- Upgrade demo sites to the getting started section ([#14474](https://github.com/netdata/netdata/issues/14474))
- Add a file to Learn ([#14473](https://github.com/netdata/netdata/issues/14473))
- Incorporate interoperability and fix edit link ([#14475](https://github.com/netdata/netdata/issues/14475))
- Remove obsolete or redundant docs ([#14476](https://github.com/netdata/netdata/issues/14476))
- Generates dual ksy for njfv2 + fix for padding after page blocks ([#14383](https://github.com/netdata/netdata/issues/14383))
- Fix compiler error when CLOSE_RANGE_CLOEXEC is missing ([#14430](https://github.com/netdata/netdata/issues/14430))
- Update AD title ([#14484](https://github.com/netdata/netdata/issues/14484))
- Make the introduction a category link ([#14485](https://github.com/netdata/netdata/issues/14485))
- Update Demo-Sites.md ([#14488](https://github.com/netdata/netdata/issues/14488))
- Try making it landing page of getting started directly ([#14489](https://github.com/netdata/netdata/issues/14489))
- Virtual hosts for data collection ([#14464](https://github.com/netdata/netdata/issues/14464))
- Fix crash when child connects ([#14492](https://github.com/netdata/netdata/issues/14492))
- Fix coverity issues ([#14480](https://github.com/netdata/netdata/issues/14480))
- Category overview pages ([#14495](https://github.com/netdata/netdata/issues/14495))
- Delete getting-started-overview.md ([#14497](https://github.com/netdata/netdata/issues/14497))
- Correct title of contribute to doccumentation ([#14498](https://github.com/netdata/netdata/issues/14498))
- Events docs ([#14341](https://github.com/netdata/netdata/issues/14341))
- Plans docs ([#14491](https://github.com/netdata/netdata/issues/14491))
- Reorganize contents of Getting Started ([#14499](https://github.com/netdata/netdata/issues/14499))
- Update Demo-Sites.md ([#14501](https://github.com/netdata/netdata/issues/14501))
- Top level learn changes ([#14503](https://github.com/netdata/netdata/issues/14503))
- Revert changes to platform support policy ([#14504](https://github.com/netdata/netdata/issues/14504))
- More learn reorg/reordering ([#14505](https://github.com/netdata/netdata/issues/14505))
- Fix broken links in collectors/COLLECTORS.md ([#14502](https://github.com/netdata/netdata/issues/14502))
- Guides and collectors reorg and cleanup part 1 ([#14507](https://github.com/netdata/netdata/issues/14507))
- Move collectors under Integrations/Monitoring ([#14509](https://github.com/netdata/netdata/issues/14509))
- Member role on roles permissions docs ([#14500](https://github.com/netdata/netdata/issues/14500))
- Learn integrations category changes ([#14510](https://github.com/netdata/netdata/issues/14510))
- Make external plugins a category page in learn ([#14511](https://github.com/netdata/netdata/issues/14511))
- Add .NET info ([#14429](https://github.com/netdata/netdata/issues/14429))
- Prevent crash when running '-W createdataset' ([#14455](https://github.com/netdata/netdata/issues/14455))
- Replicating gaps ([#14506](https://github.com/netdata/netdata/issues/14506))
- Added section to explain impacts on member role ([#14527](https://github.com/netdata/netdata/issues/14527))
- Fix broken links in markdown files ([#14513](https://github.com/netdata/netdata/issues/14513))
- Update role-based-access.md ([#14528](https://github.com/netdata/netdata/issues/14528))
- Simplify parser README.md and add parser files to CMakeLists.txt ([#14523](https://github.com/netdata/netdata/issues/14523))
- Update main metric retention docs ([#14530](https://github.com/netdata/netdata/issues/14530))
- Add Debian 12 to our CI and platform support document. ([#14529](https://github.com/netdata/netdata/issues/14529))
- Use curl from static builds if no system-wide copy exists. ([#14403](https://github.com/netdata/netdata/issues/14403))
- Use BoxListItemRegexLink component in docs/quickstart/insfrastructure.md ([#14533](https://github.com/netdata/netdata/issues/14533))
- Fix broken Alma Linux entries in build matrix generation. ([#14536](https://github.com/netdata/netdata/issues/14536))
- Reorganize learn documents under Integrations part 2 ([#14538](https://github.com/netdata/netdata/issues/14538))
- Fix broken svgs and improve database queries API doc ([#14539](https://github.com/netdata/netdata/issues/14539))
- Add renamed markdown files ([#14540](https://github.com/netdata/netdata/issues/14540))
- JSON internal API, IEEE754 base64/hex streaming, weights endpoint optimization ([#14493](https://github.com/netdata/netdata/issues/14493))
- Remove unused config options and functions ([#14542](https://github.com/netdata/netdata/issues/14542))
- Assorted shellcheck cleanup. ([#14524](https://github.com/netdata/netdata/issues/14524))
- Fix setting go.d.plugin capabilities ([#14525](https://github.com/netdata/netdata/issues/14525))
- Reorg markdown files for learn ([#14547](https://github.com/netdata/netdata/issues/14547))
- Hide netdata for IoT from learn. ([#14548](https://github.com/netdata/netdata/issues/14548))
- Update learn path of python plugin readme ([#14549](https://github.com/netdata/netdata/issues/14549))
- Roles docs: Add Early Bird and Member role ([#14537](https://github.com/netdata/netdata/issues/14537))
- More reorg learn 021623 ([#14550](https://github.com/netdata/netdata/issues/14550))
- Fix broken links in integrations-overview ([#14554](https://github.com/netdata/netdata/issues/14554))
- Reorg learn 021723 ([#14556](https://github.com/netdata/netdata/issues/14556))
- Update email notification docs with info about setup in Docker. ([#14555](https://github.com/netdata/netdata/issues/14555))
- Add misc landing page and move proxy guides ([#14557](https://github.com/netdata/netdata/issues/14557))
- Make secure nodes a category landing page ([#14558](https://github.com/netdata/netdata/issues/14558))
- Fix kickstart link ([#14559](https://github.com/netdata/netdata/issues/14559))
- Re-index when machine guid changes ([#14535](https://github.com/netdata/netdata/issues/14535))
- Remove obsolete instruction to lower memory usage ([#14568](https://github.com/netdata/netdata/issues/14568))
- Reviewed plans page to be according to latest updates ([#14560](https://github.com/netdata/netdata/issues/14560))
- Fix broken links in our documentation ([#14565](https://github.com/netdata/netdata/issues/14565))
- Include troubleshooting section in the docs of python.d modules ([#13721](https://github.com/netdata/netdata/issues/13721))
- Fix doc capitalization and remove obsolete section ([#14569](https://github.com/netdata/netdata/issues/14569))
- Remove References category from learn ([#14571](https://github.com/netdata/netdata/issues/14571))
- Bump go.d to v0.51.0 ([#14572](https://github.com/netdata/netdata/issues/14572))
- Pandas collector add `read_sql()` support ([#14563](https://github.com/netdata/netdata/issues/14563))
- Fix coverity issues ([#14543](https://github.com/netdata/netdata/issues/14543))
- Fix two issues with the edit-config script. ([#14545](https://github.com/netdata/netdata/issues/14545))
- Support installing extra packages in Docker images at runtime. ([#14456](https://github.com/netdata/netdata/issues/14456))
- Update static binary readme ([#14574](https://github.com/netdata/netdata/issues/14574))
- Reorg learn ([#14575](https://github.com/netdata/netdata/issues/14575))
- Update README.md ([#14576](https://github.com/netdata/netdata/issues/14576))
- Memory management eBPF ([#14462](https://github.com/netdata/netdata/issues/14462))
- Reorg learn 2102 1 ([#14577](https://github.com/netdata/netdata/issues/14577))
- Add link to all installation options ([#14578](https://github.com/netdata/netdata/issues/14578))
- Learn installation reorg part 2 ([#14579](https://github.com/netdata/netdata/issues/14579))
- Final install reorg for learn ([#14580](https://github.com/netdata/netdata/issues/14580))
- Correct the sidebar position label metdata for learn ([#14583](https://github.com/netdata/netdata/issues/14583))
- Misc SSL improvements 2 ([#14334](https://github.com/netdata/netdata/issues/14334))
- Merge security documents ([#14588](https://github.com/netdata/netdata/issues/14588))
- Change link text to collectors.md ([#14590](https://github.com/netdata/netdata/issues/14590))
- Clean host structure ([#14584](https://github.com/netdata/netdata/issues/14584))
- Get update every from page ([#14573](https://github.com/netdata/netdata/issues/14573))
- /api/v2/data - multi-host/context/instance/dimension/label queries ([#14564](https://github.com/netdata/netdata/issues/14564))
- Delete interact-dashboard-charts ([#14594](https://github.com/netdata/netdata/issues/14594))
- Update interact-new-charts.md ([#14596](https://github.com/netdata/netdata/issues/14596))
- Replace web server readme with its improved replica ([#14598](https://github.com/netdata/netdata/issues/14598))
- Add flake8 to review CI to check Python files. ([#14582](https://github.com/netdata/netdata/issues/14582))
- Add deployment strategies ([#14600](https://github.com/netdata/netdata/issues/14600))
- Update deployment-strategies.md ([#14601](https://github.com/netdata/netdata/issues/14601))
- Fix context unittest coredump ([#14595](https://github.com/netdata/netdata/issues/14595))
- Prevent core dump when the agent is performing a quick shutdown ([#14587](https://github.com/netdata/netdata/issues/14587))
- Add a scheduled CI job to flag supported platforms going EOL upstream. ([#14581](https://github.com/netdata/netdata/issues/14581))
- Temporarily remove platform EOL check for Debian 12 ([#14603](https://github.com/netdata/netdata/issues/14603))
- Fix broken links ([#14605](https://github.com/netdata/netdata/issues/14605))
- Update overview.md ([#14607](https://github.com/netdata/netdata/issues/14607))
- Reorg information and add titles ([#14608](https://github.com/netdata/netdata/issues/14608))
- Fix links to chart interactions ([#14609](https://github.com/netdata/netdata/issues/14609))
- Update go.d.plugin v0.51.1 ([#14611](https://github.com/netdata/netdata/issues/14611))
- Reorg learn 0226 ([#14610](https://github.com/netdata/netdata/issues/14610))
- Fix links from removed docs ([#14612](https://github.com/netdata/netdata/issues/14612))
- Fix proxy links in netdata security ([#14613](https://github.com/netdata/netdata/issues/14613))
- Fix relative link to anonymous statistics ([#14614](https://github.com/netdata/netdata/issues/14614))
- Use vector allocation whenever is possible (eBPF) ([#14591](https://github.com/netdata/netdata/issues/14591))
- Bump actions/checkout from 2 to 3 ([#14615](https://github.com/netdata/netdata/issues/14615))
- Reorganize system directory to better reflect what files are actually used for. ([#14544](https://github.com/netdata/netdata/issues/14544))
- Bump go.d.plugin v0.51.2 ([#14618](https://github.com/netdata/netdata/issues/14618))
- Reorg learn 0227 ([#14621](https://github.com/netdata/netdata/issues/14621))
- Rename glossary ([#14622](https://github.com/netdata/netdata/issues/14622))
- Fix python version check to work for 3.10 and above ([#14616](https://github.com/netdata/netdata/issues/14616))
- Port ML from C++ to C. ([#14567](https://github.com/netdata/netdata/issues/14567))
- Fix handling of no data in platform EOL checks. ([#14617](https://github.com/netdata/netdata/issues/14617))
- Update REFERENCE.md ([#14627](https://github.com/netdata/netdata/issues/14627))
- Make the title metadata H1 in all markdown files ([#14625](https://github.com/netdata/netdata/issues/14625))
- Add an option to the kickstart script to override distro detection. ([#14589](https://github.com/netdata/netdata/issues/14589))
- Misc SSL improvements 3 ([#14602](https://github.com/netdata/netdata/issues/14602))
- Added Challenge secret and rooms object on the payload ([#14496](https://github.com/netdata/netdata/issues/14496))
- Fix broken link ([#14630](https://github.com/netdata/netdata/issues/14630))
- Ensure consistency of kickstart script options that change operational mode of the script. ([#13896](https://github.com/netdata/netdata/issues/13896))
- Re-add link from install page to DEB/RPM package documentation. ([#14631](https://github.com/netdata/netdata/issues/14631))
- Add link to native packages also on the list ([#14633](https://github.com/netdata/netdata/issues/14633))
- Fix broken links ([#14634](https://github.com/netdata/netdata/issues/14634))
- Assorted improvements to OpenRC support. ([#14620](https://github.com/netdata/netdata/issues/14620))
- Link statically libnetfilter_acct into our static builds ([#14516](https://github.com/netdata/netdata/issues/14516))
- [docs]: Revert #14178 that documents how to set nofile limit for Netdata containers ([#14635](https://github.com/netdata/netdata/issues/14635))
- Update change-metrics-storage.md ([#14640](https://github.com/netdata/netdata/issues/14640))
- Update change-metrics-storage.md ([#14641](https://github.com/netdata/netdata/issues/14641))
- Update pi-hole-raspberry-pi.md ([#14644](https://github.com/netdata/netdata/issues/14644))
- Update README.md ([#14647](https://github.com/netdata/netdata/issues/14647))
- Update guidelines.md ([#14649](https://github.com/netdata/netdata/issues/14649))
- /api/v2/contexts ([#14592](https://github.com/netdata/netdata/issues/14592))
- Fix doc links ([#14650](https://github.com/netdata/netdata/issues/14650))
- Fix links ([#14651](https://github.com/netdata/netdata/issues/14651))
- Fix handling of missing release codename on DEB systems. ([#14642](https://github.com/netdata/netdata/issues/14642))
- Fix simple_pattern_create on freebsd ([#14656](https://github.com/netdata/netdata/issues/14656))
- Fix broken links in glossary.md ([#14653](https://github.com/netdata/netdata/issues/14653))
- Add support for bypassing static build cache on PRs. ([#14646](https://github.com/netdata/netdata/issues/14646))
- Bump actions/add-to-project from 0.4.0 to 0.4.1 ([#14669](https://github.com/netdata/netdata/issues/14669))
- Properly handle service type detection failures when installing as a system service. ([#14658](https://github.com/netdata/netdata/issues/14658))
- Add note on readme on how to easily see all ml related blog posts ([#14675](https://github.com/netdata/netdata/issues/14675))
- Fix intermittent permissions issues in some Docker builds. ([#14629](https://github.com/netdata/netdata/issues/14629))
- If a child is not streaming, send to the cloud last known version instead of unknown ([#14671](https://github.com/netdata/netdata/issues/14671))
- Guard for null host when sending node instances ([#14673](https://github.com/netdata/netdata/issues/14673))
- Handle conffiles for DEB packages explicitly instead of automatically. ([#14662](https://github.com/netdata/netdata/issues/14662))
- Move images in "interact-new-charts" from zenhub to github ([#14654](https://github.com/netdata/netdata/issues/14654))
- Fix conditionals for claim-only case in kickstart.sh. ([#14679](https://github.com/netdata/netdata/issues/14679))
- Fix platform EOL checks to properly return success. ([#14681](https://github.com/netdata/netdata/issues/14681))
- Fix issue template formatting for platform EOL check.
- Fix build matrix generation for platform EOL check.
- Fix kernel test script ([#14676](https://github.com/netdata/netdata/issues/14676))
- EBPF new charts (user ring) ([#14623](https://github.com/netdata/netdata/issues/14623))
- Fix Azure IMDS ([#14686](https://github.com/netdata/netdata/issues/14686))
- Fix cloud node stale status when a virtual host is created ([#14660](https://github.com/netdata/netdata/issues/14660))
- Send an EOF from charts.d.plugin before exit ([#14680](https://github.com/netdata/netdata/issues/14680))
- Remove google hangouts from list of integrations ([#14689](https://github.com/netdata/netdata/issues/14689))
- Add FAQ information provided by Finance ([#14664](https://github.com/netdata/netdata/issues/14664))
- Reviewed role description to be according to app ([#14672](https://github.com/netdata/netdata/issues/14672))
- Fix: detect the host os in k8s on non-docker cri ([#14694](https://github.com/netdata/netdata/issues/14694))
- Fix compilation error when --disable-cloud is specified ([#14695](https://github.com/netdata/netdata/issues/14695))
- Refactor ML code. ([#14659](https://github.com/netdata/netdata/issues/14659))
- /api/v2/X improvements part 3 ([#14665](https://github.com/netdata/netdata/issues/14665))
- Revert "Handle conffiles for DEB packages explicitly instead of automatically." ([#14700](https://github.com/netdata/netdata/issues/14700))
- Fix system info disk size detection on raspberry pi ([#14711](https://github.com/netdata/netdata/issues/14711))
- Don’t try to use tput in edit-config unless it’s installed. ([#14705](https://github.com/netdata/netdata/issues/14705))
- Add Amazon Linux 2 to CI and platform support. ([#14599](https://github.com/netdata/netdata/issues/14599))
- Add vnodes default configuration file. ([#14553](https://github.com/netdata/netdata/issues/14553))
- Change H1 of collector docs to separate from the website ([#14715](https://github.com/netdata/netdata/issues/14715))
- Add instructions for reconnecting a Docker node to another Space ([#14714](https://github.com/netdata/netdata/issues/14714))
- /api/v2 part 4 ([#14706](https://github.com/netdata/netdata/issues/14706))
- RPM: Added elfutils-libelf-devel for build with eBPF ([#14552](https://github.com/netdata/netdata/issues/14552))
- Auto-trigger MSI build on release. ([#14721](https://github.com/netdata/netdata/issues/14721))
- Add experimental support for running under runit. ([#13841](https://github.com/netdata/netdata/issues/13841))
- Improve guideline docs ([#14678](https://github.com/netdata/netdata/issues/14678))
- Update change-metrics-storage.md ([#14726](https://github.com/netdata/netdata/issues/14726))
- Add go.d example collector to #etc section ([#14722](https://github.com/netdata/netdata/issues/14722))
- New build_external scenario. ([#14725](https://github.com/netdata/netdata/issues/14725))
- Correct calc and explain how to get METRICS in RAM usage ([#14733](https://github.com/netdata/netdata/issues/14733))
- Update change-metrics-storage.md ([#14734](https://github.com/netdata/netdata/issues/14734))
- Pandas collector replace `self.warn()` with `self.warning()` ([#14736](https://github.com/netdata/netdata/issues/14736))
- Update dashboard to version v2.30.0. ([#14732](https://github.com/netdata/netdata/issues/14732))
- Update data-privacy.md ([#14738](https://github.com/netdata/netdata/issues/14738))
- Update data-privacy.md ([#14739](https://github.com/netdata/netdata/issues/14739))
- Create pci-soc-hipaa.md ([#14740](https://github.com/netdata/netdata/issues/14740))
- Add contexts to privacy doc. ([#14741](https://github.com/netdata/netdata/issues/14741))
- Update change-metrics-storage.md ([#14742](https://github.com/netdata/netdata/issues/14742))
- Update Performance Optimization Options ([#14743](https://github.com/netdata/netdata/issues/14743))
- Use one thread for ACLK synchonization ([#14281](https://github.com/netdata/netdata/issues/14281))
- Increase RRD_ID_LENGTH_MAX to 1000 ([#14744](https://github.com/netdata/netdata/issues/14744))
- Bump go.d.plugin version to v0.51.3 ([#14745](https://github.com/netdata/netdata/issues/14745))
- Update edit-config documentation ([#14749](https://github.com/netdata/netdata/issues/14749))
- Organize information from war-rooms.md to its correct location ([#14729](https://github.com/netdata/netdata/issues/14729))
- Update sign-in.md ([#14751](https://github.com/netdata/netdata/issues/14751))
- Suggest PRs to go to the community project ([#14724](https://github.com/netdata/netdata/issues/14724))
- Update deployment-strategies.md ([#14716](https://github.com/netdata/netdata/issues/14716))
- Add ethtool in third party collectors ([#14753](https://github.com/netdata/netdata/issues/14753))
- Add CI support for Fedora 38 & Ubuntu 23.04 native packages ([#14735](https://github.com/netdata/netdata/issues/14735))
- Bump go.d.plugin to v0.51.4 ([#14756](https://github.com/netdata/netdata/issues/14756))
- Bundle libyaml ([#14704](https://github.com/netdata/netdata/issues/14704))
- Accept all=true for alarms api v1 call ([#14762](https://github.com/netdata/netdata/issues/14762))
- Minor addition to distros matrix ([#14767](https://github.com/netdata/netdata/issues/14767))
- Fix /sys/block/zram in docker ([#14759](https://github.com/netdata/netdata/issues/14759))
- Update "View active alerts" documentation ([#14766](https://github.com/netdata/netdata/issues/14766))
- Pass node_id and config_hash vars when queueing alert configurations ([#14769](https://github.com/netdata/netdata/issues/14769))
- Use static thread-pool for training. ([#14702](https://github.com/netdata/netdata/issues/14702))
- Assorted improvements for our platform EOL check code. ([#14768](https://github.com/netdata/netdata/issues/14768))
- Update API ([#14772](https://github.com/netdata/netdata/issues/14772))
- Add gzip compression info to nginx proxy readme ([#14773](https://github.com/netdata/netdata/issues/14773))
- Create reverse-proxies.md ([#14774](https://github.com/netdata/netdata/issues/14774))
- Update performance.md ([#14776](https://github.com/netdata/netdata/issues/14776))
- Update reverse-proxies.md ([#14777](https://github.com/netdata/netdata/issues/14777))
- Improve performance.md ([#14778](https://github.com/netdata/netdata/issues/14778))
- Replace hardcoded links pointing to "learn.netdata.cloud" with github absolute links ([#14779](https://github.com/netdata/netdata/issues/14779))
- Add validation step before using Azure metadata (AZURE_IMDS_DATA) ([#14775](https://github.com/netdata/netdata/issues/14775))
- Revert "Use static thread-pool for training. ([#14702](https://github.com/netdata/netdata/issues/14702))" ([#14782](https://github.com/netdata/netdata/issues/14782))
- Update dashboard to version v2.30.1. ([#14784](https://github.com/netdata/netdata/issues/14784))
- Update journal v2 ([#14750](https://github.com/netdata/netdata/issues/14750))
- /api/v2/X part 5 ([#14718](https://github.com/netdata/netdata/issues/14718))
- Uuid_compare() replaced with uuid_memcmp() ([#14787](https://github.com/netdata/netdata/issues/14787))
- /api/v2/X part 6 ([#14785](https://github.com/netdata/netdata/issues/14785))
- Use mCPU in k8s cgroup cpu charts title ([#14791](https://github.com/netdata/netdata/issues/14791))
- Fix capitalization on readme ([#14793](https://github.com/netdata/netdata/issues/14793))
- Fix links in README.md ([#14794](https://github.com/netdata/netdata/issues/14794))
- Schedule node info to the cloud after child connection ([#14790](https://github.com/netdata/netdata/issues/14790))
- Fix handling of logrotate on static installs. ([#14792](https://github.com/netdata/netdata/issues/14792))
- Replace `/docs` links with GitHub links ([#14796](https://github.com/netdata/netdata/issues/14796))
- Add validation step before using GCP metadata ([#14801](https://github.com/netdata/netdata/issues/14801))
- Fix how we are handling system services in RPM packages. ([#14781](https://github.com/netdata/netdata/issues/14781))
- Address Learn feedback from users ([#14802](https://github.com/netdata/netdata/issues/14802))
- Update role-based-access.md ([#14811](https://github.com/netdata/netdata/issues/14811))
- Consolidate security and privacy documents ([#14812](https://github.com/netdata/netdata/issues/14812))
- Update privacy link in aclk doc ([#14813](https://github.com/netdata/netdata/issues/14813))
- Minor improvements to netdata-security.md ([#14815](https://github.com/netdata/netdata/issues/14815))
- Diskspace: don't collect inodes on msdosfs ([#14809](https://github.com/netdata/netdata/issues/14809))
- /api/v2/X part 7 ([#14797](https://github.com/netdata/netdata/issues/14797))
- Fix failure logic for publishing packages. ([#14720](https://github.com/netdata/netdata/issues/14720))
- Clean up install method list in bug report template. ([#14819](https://github.com/netdata/netdata/issues/14819))
- Configure extent cache size ([#14821](https://github.com/netdata/netdata/issues/14821))
- Delete installation instructions specific to FreeNAS ([#14826](https://github.com/netdata/netdata/issues/14826))
- Add Amazon Linux 2023 to CI, packaging, and platform support. ([#14771](https://github.com/netdata/netdata/issues/14771))
- Update change-metrics-storage.md ([#14834](https://github.com/netdata/netdata/issues/14834))
- Update database engine readme ([#14836](https://github.com/netdata/netdata/issues/14836))
- Update change-metrics-storage.md ([#14835](https://github.com/netdata/netdata/issues/14835))
- Update deployment-strategies.md ([#14837](https://github.com/netdata/netdata/issues/14837))
- Update enable-notifications.md ([#14838](https://github.com/netdata/netdata/issues/14838))
- Update netdata-security.md ([#14833](https://github.com/netdata/netdata/issues/14833))
- Docs, shorten too long titles, and add a description below ([#14820](https://github.com/netdata/netdata/issues/14820))
- Add some third party collectors ([#14830](https://github.com/netdata/netdata/issues/14830))
- First batch of adding descriptions to the documentation ([#14825](https://github.com/netdata/netdata/issues/14825))
- Fix Btrfs unallocated space accounting ([#14824](https://github.com/netdata/netdata/issues/14824))
- Update parent child examples ([#14842](https://github.com/netdata/netdata/issues/14842))
- Fix double host prefix when reading ZFS pools state ([#14840](https://github.com/netdata/netdata/issues/14840))
- Minor - add capability signifying this agent can speak apiv2 ([#14817](https://github.com/netdata/netdata/issues/14817))
- Fix  #14841 Exception funktion call Rados.mon_command() ([#14844](https://github.com/netdata/netdata/issues/14844))
- Fix typo alerms -> alarms ([#14854](https://github.com/netdata/netdata/issues/14854))
- Remove ubuntu 18.04 from our CI ([#14731](https://github.com/netdata/netdata/issues/14731))
- Update posthog domain ([#14818](https://github.com/netdata/netdata/issues/14818))
- Bump google-github-actions/upload-cloud-storage from 1.0.0 to 1.0.1 ([#14853](https://github.com/netdata/netdata/issues/14853))
- Review usage of you to say user instead ([#14858](https://github.com/netdata/netdata/issues/14858))
- Update Agent notification methods documentation ([#14827](https://github.com/netdata/netdata/issues/14827))
- Add labels for cgroup name ([#14856](https://github.com/netdata/netdata/issues/14856))
- Add basic clang-format checking to PR review. ([#13951](https://github.com/netdata/netdata/issues/13951))
- Fix js tag in documentation ([#14862](https://github.com/netdata/netdata/issues/14862))
- Update link from http to https ([#14864](https://github.com/netdata/netdata/issues/14864))
- Add opsgenie integration docs ([#14828](https://github.com/netdata/netdata/issues/14828))
- Set a default registry unique id when there is none for statistics script ([#14861](https://github.com/netdata/netdata/issues/14861))
- Assorted installer code cleanup. ([#14632](https://github.com/netdata/netdata/issues/14632))
- Bump go.d.plugin v0.52.0 ([#14870](https://github.com/netdata/netdata/issues/14870))
- Fix regex syntax for clang-format checks. ([#14871](https://github.com/netdata/netdata/issues/14871))
- Boost dbengine ([#14832](https://github.com/netdata/netdata/issues/14832))
- Cgroups.plugin: add image label ([#14872](https://github.com/netdata/netdata/issues/14872))
- Add support for alert notifications to ntfy.sh ([#14875](https://github.com/netdata/netdata/issues/14875))
- /api/v2 part 8 ([#14885](https://github.com/netdata/netdata/issues/14885))
- Bump actions/add-to-project from 0.4.1 to 0.5.0 ([#14881](https://github.com/netdata/netdata/issues/14881))
- Bump peter-evans/create-pull-request from 4 to 5 ([#14883](https://github.com/netdata/netdata/issues/14883))
- Handle conffiles for DEB packages explicitly instead of automatically. ([#14703](https://github.com/netdata/netdata/issues/14703))
- EBPF bug fixes ([#14869](https://github.com/netdata/netdata/issues/14869))
- /api/v2 part 9 ([#14888](https://github.com/netdata/netdata/issues/14888))
- Add example configuration to w1sensor collector ([#14886](https://github.com/netdata/netdata/issues/14886))
- Update the bundled version of makeself used to create static builds. ([#14822](https://github.com/netdata/netdata/issues/14822))
- Collect additional BTRFS metrics ([#14636](https://github.com/netdata/netdata/issues/14636))
- Remove dry run option from uninstall documentation ([#14894](https://github.com/netdata/netdata/issues/14894))
- Add opsgenie as a business level notificaiton method ([#14895](https://github.com/netdata/netdata/issues/14895))
- Update README.md ([#14898](https://github.com/netdata/netdata/issues/14898))
- Update README.md ([#14899](https://github.com/netdata/netdata/issues/14899))
- Update REFERENCE.md ([#14900](https://github.com/netdata/netdata/issues/14900))
- Disable threads that update with high frequency ([#14897](https://github.com/netdata/netdata/issues/14897))
- Cgroups: add option to use Kubelet for pods metadata ([#14891](https://github.com/netdata/netdata/issues/14891))
- /api/v2 part 10 ([#14904](https://github.com/netdata/netdata/issues/14904))
- Update change-metrics-storage.md ([#14905](https://github.com/netdata/netdata/issues/14905))
- Save and load ML models ([#14810](https://github.com/netdata/netdata/issues/14810))
- Revert ML changes. ([#14908](https://github.com/netdata/netdata/issues/14908))
- Update suggested replication setups ([#14914](https://github.com/netdata/netdata/issues/14914))
- Add section for scaling parent nodes ([#14915](https://github.com/netdata/netdata/issues/14915))
- Add windows diagram ([#14916](https://github.com/netdata/netdata/issues/14916))
- Fix judyltablesgen crosscompile ([#14349](https://github.com/netdata/netdata/issues/14349))
- Change docusaurus admonitions to our style of admonitions ([#14917](https://github.com/netdata/netdata/issues/14917))
- Minor - remove RX_MSGLEN_MAX ([#14918](https://github.com/netdata/netdata/issues/14918))
- Fix warnings and error when compiling with --disable-dbengine ([#14919](https://github.com/netdata/netdata/issues/14919))
- Fix/introduce links inside charts.d.plugin documentation  ([#14884](https://github.com/netdata/netdata/issues/14884))
- Document CetusGuard as a Docker socket proxy solution ([#14806](https://github.com/netdata/netdata/issues/14806))
- Bump go.d.plugin to v0.52.1 ([#14921](https://github.com/netdata/netdata/issues/14921))
- Make the document more generic ([#14932](https://github.com/netdata/netdata/issues/14932))
- Bump go.d.plugin v0.52.2 ([#14933](https://github.com/netdata/netdata/issues/14933))
- Skip ML initialization when it's been disabled in netdata.conf ([#14920](https://github.com/netdata/netdata/issues/14920))
- Initialize machine GUID earlier in the agent startup sequence ([#14922](https://github.com/netdata/netdata/issues/14922))
- Zfspool: add suspended state ([#14934](https://github.com/netdata/netdata/issues/14934))
- Update using-host-labels.md ([#14939](https://github.com/netdata/netdata/issues/14939))
- Update COLLECTORS.md
- Fix broken image, in database/README.md ([#14936](https://github.com/netdata/netdata/issues/14936))
- Add a description to proc.plugin/README.md ([#14935](https://github.com/netdata/netdata/issues/14935))
- Optimize the cheat sheet to be in a printable form factor  ([#14903](https://github.com/netdata/netdata/issues/14903))
- Add windows MSI installer start stop restart instructions to docs ([#14929](https://github.com/netdata/netdata/issues/14929))
- Replace "XYZ view" with "XYZ tab" in documentation files ([#14930](https://github.com/netdata/netdata/issues/14930))
- Add Docker instructions to enable Nvidia GPUs ([#14924](https://github.com/netdata/netdata/issues/14924))
- WEBRTC for communication between agents and browsers ([#14874](https://github.com/netdata/netdata/issues/14874))
- Fix 32bit segv ([#14940](https://github.com/netdata/netdata/issues/14940))
- Skip alert template variables from alert snapshots ([#14763](https://github.com/netdata/netdata/issues/14763))
- Add a checkpoint message to alerts stream ([#14847](https://github.com/netdata/netdata/issues/14847))
- Remove netdatacli response size limitation ([#14906](https://github.com/netdata/netdata/issues/14906))
- Update freebsd.md ([#14010](https://github.com/netdata/netdata/issues/14010))
- Update README.md ([#14948](https://github.com/netdata/netdata/issues/14948))
- Disable SQL operations in training thread ([#14947](https://github.com/netdata/netdata/issues/14947))
- Update dbengine README.md ([#14951](https://github.com/netdata/netdata/issues/14951))
- Terminate JSX element in doc file ([#14952](https://github.com/netdata/netdata/issues/14952))
- Address issues on `EC2` (eBPF). ([#14902](https://github.com/netdata/netdata/issues/14902))
- Prevent pager from preventing non-interactive install ([#14950](https://github.com/netdata/netdata/issues/14950))
- Reject child when context is loading ([#14960](https://github.com/netdata/netdata/issues/14960))
- Update README.md ([#14962](https://github.com/netdata/netdata/issues/14962))
- Document netdatacli dumpconfig option ([#14963](https://github.com/netdata/netdata/issues/14963))
- Add adaptec_raid metrics.csv ([#14955](https://github.com/netdata/netdata/issues/14955))
- Fix handling of users and groups on install. ([#14961](https://github.com/netdata/netdata/issues/14961))
- Update ML README.md ([#14964](https://github.com/netdata/netdata/issues/14964))
- Add support for acquire/release operations on RRDSETs ([#14945](https://github.com/netdata/netdata/issues/14945))
- Add metrics.csv to apps.plugin ([#14968](https://github.com/netdata/netdata/issues/14968))
- Add metrics.csv to timex.plugin ([#14970](https://github.com/netdata/netdata/issues/14970))
- Add metrics.csv to charts.d ([#14966](https://github.com/netdata/netdata/issues/14966))
- Add metrics.csv to slabinfo.plugin ([#14971](https://github.com/netdata/netdata/issues/14971))
- Add metrics.csv to xenstat.plugin ([#14972](https://github.com/netdata/netdata/issues/14972))
- Add metrics.csv to perf.plugin ([#14973](https://github.com/netdata/netdata/issues/14973))
- Do not convert to percentage, when the raw option is given ([#14969](https://github.com/netdata/netdata/issues/14969))
- Add metrics.csv to some c collectors ([#14974](https://github.com/netdata/netdata/issues/14974))
- Fix adding chart labels in tc.plugin ([#14976](https://github.com/netdata/netdata/issues/14976))
- Add metrics.csv to macos, freebsd and cgroups plugins ([#14977](https://github.com/netdata/netdata/issues/14977))
- Interrupt callback on api/v1/data ([#14978](https://github.com/netdata/netdata/issues/14978))
- Fix TYPO in README.md ([#14980](https://github.com/netdata/netdata/issues/14980))
- Add metrics.csv to proc.plugin ([#14979](https://github.com/netdata/netdata/issues/14979))
- Add metadata.csv to python.d.plugin ([#14959](https://github.com/netdata/netdata/issues/14959))
- Add metrics.csv for ebpf ([#14965](https://github.com/netdata/netdata/issues/14965))
- Fix config generation for plugins ([#14990](https://github.com/netdata/netdata/issues/14990))
- Remove alpine 3.14 from the ci ([#14873](https://github.com/netdata/netdata/issues/14873))
- Disable CPU full pressure at the system level ([#14991](https://github.com/netdata/netdata/issues/14991))
- Feat: add OpsGenie alert levels to payload ([#14992](https://github.com/netdata/netdata/issues/14992))
- Update netdata-security.md ([#14995](https://github.com/netdata/netdata/issues/14995))
- Set api v2 version 2 ([#14954](https://github.com/netdata/netdata/issues/14954))
- Add Cancel Pending Request Message ([#14953](https://github.com/netdata/netdata/issues/14953))
- Remove lighttpd2 from docs ([#14997](https://github.com/netdata/netdata/issues/14997))
- Load/Store ML models ([#14981](https://github.com/netdata/netdata/issues/14981))
- Fix cmake errors ([#14998](https://github.com/netdata/netdata/issues/14998))
- Address log issue ([#14958](https://github.com/netdata/netdata/issues/14958))
- Add support for monitoring thp, ballooning, zswap, ksm cow ([#15000](https://github.com/netdata/netdata/issues/15000))
- Weights endpoint: volume diff of anomaly rates ([#15004](https://github.com/netdata/netdata/issues/15004))
- Bump Coverity scan tool version. ([#15003](https://github.com/netdata/netdata/issues/15003))
- Fix coverity issues  ([#15005](https://github.com/netdata/netdata/issues/15005))
- Feat(apps.plugin): collect context switches ([#15002](https://github.com/netdata/netdata/issues/15002))
- Differentiate error codes better when claiming from kickstart script. ([#15015](https://github.com/netdata/netdata/issues/15015))
- Set file capabilities correctly on static installs. ([#15018](https://github.com/netdata/netdata/issues/15018))
- Add `grafana` to `apps_groups.conf` ([#15020](https://github.com/netdata/netdata/issues/15020))
- On data and weight queries now instances filter matches also instance_id@node_id ([#15021](https://github.com/netdata/netdata/issues/15021))
- Fix typo in file capabilities settings in static installer. ([#15023](https://github.com/netdata/netdata/issues/15023))

## [1.38.0] - 2023-02-06

### Merged Pull Requests:

- Remove python.d/springboot ([#14075](https://github.com/netdata/netdata/issues/14075))
- Remove openSUSE Leap 15.3 from CI and support. ([#13416](https://github.com/netdata/netdata/issues/13416))
- Fix backfilling statistics ([#14074](https://github.com/netdata/netdata/issues/14074))
- Fix SSL related crashes ([#14076](https://github.com/netdata/netdata/issues/14076))
- Add workflow dispatch trigger for parent/child with cloud integration smoke tests ([#14070](https://github.com/netdata/netdata/issues/14070))
- Optimize workers statistics performance ([#14077](https://github.com/netdata/netdata/issues/14077))
- Replication fixes 9 ([#14079](https://github.com/netdata/netdata/issues/14079))
- Add basic dashboard info for NGINX Plus ([#14080](https://github.com/netdata/netdata/issues/14080))
- Fix 1.37 crashes ([#14081](https://github.com/netdata/netdata/issues/14081))
- Update workflows to use $GITHUB_OUTPUT instead of ::set-output:: ([#13960](https://github.com/netdata/netdata/issues/13960))
- Fix typo in Fedora 37 build configuration. ([#14082](https://github.com/netdata/netdata/issues/14082))
- Fix __atomic_compare_exchange_n() atomics ([#14085](https://github.com/netdata/netdata/issues/14085))
- Fix v1.37 dbengine page alignment crashes ([#14086](https://github.com/netdata/netdata/issues/14086))
- Wmi descriptions ([#14001](https://github.com/netdata/netdata/issues/14001))
- Docs: add a note to set container nofile ulimit for Fedora users ([#14092](https://github.com/netdata/netdata/issues/14092))
- Cleanly reimplement system/edit-config.in. ([#13702](https://github.com/netdata/netdata/issues/13702))
- Fix missing required package install of tar on FreeBSD ([#14095](https://github.com/netdata/netdata/issues/14095))
- Add version to netdatacli ([#14094](https://github.com/netdata/netdata/issues/14094))
- Remove deprecated methods for passing additional options to install code. ([#12943](https://github.com/netdata/netdata/issues/12943))
- Add clickhouse third party collector and install instructions ([#14021](https://github.com/netdata/netdata/issues/14021))
- Fix docker host editable config ([#14104](https://github.com/netdata/netdata/issues/14104))
- Fix health emphemerality labels src ([#14105](https://github.com/netdata/netdata/issues/14105))
- Fix minor typo. ([#14111](https://github.com/netdata/netdata/issues/14111))
- Ci: fix cgroup-parent name in packaging ([#14118](https://github.com/netdata/netdata/issues/14118))
- Remove deprecated python.d collectors announced in v1.37.0 deprecation notice ([#14072](https://github.com/netdata/netdata/issues/14072))
- Remove deprecated fping.plugin in accordance with v1.37.0 deprecation notice ([#14073](https://github.com/netdata/netdata/issues/14073))
- Add filtering options to functions table output ([#14108](https://github.com/netdata/netdata/issues/14108))
- Don't log too much about streaming connections ([#14117](https://github.com/netdata/netdata/issues/14117))
- Heartbeat: don't log every discrepancy ([#14122](https://github.com/netdata/netdata/issues/14122))
- Fix get_system_cpus() ([#14116](https://github.com/netdata/netdata/issues/14116))
- ARAL: add destroy function and optimize ifdefs ([#14121](https://github.com/netdata/netdata/issues/14121))
- Bump go.d.plugin to v0.46.0 ([#14124](https://github.com/netdata/netdata/issues/14124))
- Fix eBPF load on RH 8.x family and improve code. ([#14090](https://github.com/netdata/netdata/issues/14090))
- MQTT 5 publish topic alias support ([#14067](https://github.com/netdata/netdata/issues/14067))
- Fix httpcheck alarms ([#14133](https://github.com/netdata/netdata/issues/14133))
- Fix conditions for uploading repoconfig packages to new infra. ([#14134](https://github.com/netdata/netdata/issues/14134))
- Fix incorrect matrix parameter names in repoconfig package upload workflow.
- Remove Fedora 35 from the list of supported platforms. ([#14136](https://github.com/netdata/netdata/issues/14136))
- Expose ACLK SSL KeyLog interface for developers ([#14109](https://github.com/netdata/netdata/issues/14109))
- Use chart labels in portcheck alarms ([#14137](https://github.com/netdata/netdata/issues/14137))
- Fix(packaging): add setuid for cgroup-network and ebpf.plugin in RPM ([#14140](https://github.com/netdata/netdata/issues/14140))
- Correctly fix repoconfig package uploads.
- Really, truly fix the repoconfig package upload process.
- Revert "MQTT 5 publish topic alias support" ([#14145](https://github.com/netdata/netdata/issues/14145))
- Disable integration by default (eBPF <-> APPS) ([#14147](https://github.com/netdata/netdata/issues/14147))
- Bump go.d.plugin to v0.46.1 ([#14151](https://github.com/netdata/netdata/issues/14151))
- Populate field values in send_slack() for Mattermost ([#14153](https://github.com/netdata/netdata/issues/14153))
- Add a health configuration option of what alarms to load ([#14150](https://github.com/netdata/netdata/issues/14150))
- Switch to self-hosted infrastructure for RPM package distribution. ([#14100](https://github.com/netdata/netdata/issues/14100))
- Document memory mode alloc ([#14142](https://github.com/netdata/netdata/issues/14142))
- Support HTTP proxy Basic auth ([#13762](https://github.com/netdata/netdata/issues/13762))
- Fix nodejs app detection ([#14156](https://github.com/netdata/netdata/issues/14156))
- Fix race on query thread startup ([#14164](https://github.com/netdata/netdata/issues/14164))
- Refactor ML code and add support for multiple KMeans models. ([#14065](https://github.com/netdata/netdata/issues/14065))
- Add tkatsoulas as a codeowner for documentation. ([#14169](https://github.com/netdata/netdata/issues/14169))
- Finish switch to self-hosted RPM repositories. ([#14158](https://github.com/netdata/netdata/issues/14158))
- Minor - fix localhost nodeinstance fnc caps ([#14166](https://github.com/netdata/netdata/issues/14166))
- Fix a typo in debian postinst ([#14171](https://github.com/netdata/netdata/issues/14171))
- Revert "Refactor ML code and add support for multiple KMeans models. … ([#14172](https://github.com/netdata/netdata/issues/14172))
- Ensure --claim-url for the claim script is a URL ([#14160](https://github.com/netdata/netdata/issues/14160))
- Minor - Adds query type "function[s]" for aclk chart ([#14165](https://github.com/netdata/netdata/issues/14165))
- Feat(packaging): add netdata to www-data group on Proxmox ([#14168](https://github.com/netdata/netdata/issues/14168))
- Docs: explicitly set the `nofile` limit for Netdata container and document the reason for this ([#14178](https://github.com/netdata/netdata/issues/14178))
- Add alarms and dashboard info for Consul ([#14163](https://github.com/netdata/netdata/issues/14163))
- Use specific charts labels instead of family in alarms ([#14173](https://github.com/netdata/netdata/issues/14173))
- Remove interface name from cgroup net family ([#14174](https://github.com/netdata/netdata/issues/14174))
- Bump go.d.plugin to v0.47.0 ([#14182](https://github.com/netdata/netdata/issues/14182))
- Fix logrotate postrotate ([#14180](https://github.com/netdata/netdata/issues/14180))
- Add compatibility links for RHEL repos. ([#14176](https://github.com/netdata/netdata/issues/14176))
- Add `telegraf` to `apps_groups.conf` monitoring section ([#14188](https://github.com/netdata/netdata/issues/14188))
- Bump go.d.plugin to v0.48.0 ([#14195](https://github.com/netdata/netdata/issues/14195))
- EBPF (memory, NV, basis for functions) ([#14131](https://github.com/netdata/netdata/issues/14131))
- Switch to actions/labeler@v4 for labeling PRs. ([#14203](https://github.com/netdata/netdata/issues/14203))
- Finish renaming the `--install` option to `--install-prefix`. ([#13881](https://github.com/netdata/netdata/issues/13881))
- Refactor ML code and add support for multiple KMeans models ([#14198](https://github.com/netdata/netdata/issues/14198))
- Fix typos ([#14194](https://github.com/netdata/netdata/issues/14194))
- Dont call worker_utilization_finish() twice ([#14204](https://github.com/netdata/netdata/issues/14204))
- Create ML charts on child hosts. ([#14207](https://github.com/netdata/netdata/issues/14207))
- Fix docker builds ([#14211](https://github.com/netdata/netdata/issues/14211))
- Use brackets around info variables ([#14206](https://github.com/netdata/netdata/issues/14206))
- Add few alarms for elasticsearch ([#14197](https://github.com/netdata/netdata/issues/14197))
- Remove lgtm.com ([#14216](https://github.com/netdata/netdata/issues/14216))
- Bump go.d v0.49.0 ([#14220](https://github.com/netdata/netdata/issues/14220))
- MQTT5 Topic Alias ([#14148](https://github.com/netdata/netdata/issues/14148))
- Fix consul_raft_leadership_transitions alarm units ([#14232](https://github.com/netdata/netdata/issues/14232))
- Ci: show docker logs if docker-test fails ([#14219](https://github.com/netdata/netdata/issues/14219))
- Drop ARMv7 native packages for Fedora 36. ([#14233](https://github.com/netdata/netdata/issues/14233))
- DBENGINE v2 ([#14125](https://github.com/netdata/netdata/issues/14125))
- Pre gcc v5 support and allow building without dbengine ([#14239](https://github.com/netdata/netdata/issues/14239))
- Cancel ml threads on shutdown and join them on host free ([#14240](https://github.com/netdata/netdata/issues/14240))
- `ml - machine learning` to just `machine learning` ([#14242](https://github.com/netdata/netdata/issues/14242))
- Profile startup and shutdown timings ([#14243](https://github.com/netdata/netdata/issues/14243))
- Allow the cache to grow when huge queries are running that exceed the cache size ([#14247](https://github.com/netdata/netdata/issues/14247))
- Rename "Pid" to "PID" in functions ([#14144](https://github.com/netdata/netdata/issues/14144))
- Remove temporary allocations when preprocessing a samples buffer ([#14208](https://github.com/netdata/netdata/issues/14208))
- Fix kickstart download counter badges in documentation. ([#14246](https://github.com/netdata/netdata/issues/14246))
- Update handling of uploads of DEB packages to our new infrastructure. ([#14253](https://github.com/netdata/netdata/issues/14253))
- Update netdata-overview.xml ([#14245](https://github.com/netdata/netdata/issues/14245))
- DBENGINE v2 - improvements part 1 ([#14251](https://github.com/netdata/netdata/issues/14251))
- Fix(proc.plugin): handle disabled IPv6 ([#14252](https://github.com/netdata/netdata/issues/14252))
- Remove daemon/common.h header from libnetdata ([#14248](https://github.com/netdata/netdata/issues/14248))
- Always mark nightly build releases as latest. ([#14261](https://github.com/netdata/netdata/issues/14261))
- Enable retries for SSL_ERROR_WANT_READ ([#14120](https://github.com/netdata/netdata/issues/14120))
- Fix binpkg updates on OpenSUSE ([#14260](https://github.com/netdata/netdata/issues/14260))
- Chore(packaging): remove python-pymongo ([#14196](https://github.com/netdata/netdata/issues/14196))
- DBENGINE v2 - improvements 2 ([#14257](https://github.com/netdata/netdata/issues/14257))
- Fix(health): don't assume 2 cores if the number is unknown ([#14265](https://github.com/netdata/netdata/issues/14265))
- More 32bit fixes ([#14264](https://github.com/netdata/netdata/issues/14264))
- Skip cross-platform validation when preparing releases. ([#14268](https://github.com/netdata/netdata/issues/14268))
- Adds some introspection into the MQTT_WSS ([#14039](https://github.com/netdata/netdata/issues/14039))
- Fix(pacakging): fix cpu/memory metrics when running inside LXC container as systemd service ([#14255](https://github.com/netdata/netdata/issues/14255))
- Switch nightlies to GitHub releases. ([#14020](https://github.com/netdata/netdata/issues/14020))
- Bump go.d.plugin to v0.49.1 ([#14275](https://github.com/netdata/netdata/issues/14275))
- Replace individual collector images/links on infographic ([#14262](https://github.com/netdata/netdata/issues/14262))
- Set an explicit timeout in updater checks. ([#14273](https://github.com/netdata/netdata/issues/14273))
- Fix conditional in matrix generation for packaging jobs. ([#14274](https://github.com/netdata/netdata/issues/14274))
- Minor - add kaitaistruct for journal v2 files ([#14267](https://github.com/netdata/netdata/issues/14267))
- Update infographic image on main README ([#14276](https://github.com/netdata/netdata/issues/14276))
- Check session variable before resuming it ([#14279](https://github.com/netdata/netdata/issues/14279))
- Readme updates ([#14224](https://github.com/netdata/netdata/issues/14224))
- Make sure variables are streamed after SENDER_CONNECTED flag is set ([#14283](https://github.com/netdata/netdata/issues/14283))
- Store host and claim info in sqlite as soon as possible ([#14263](https://github.com/netdata/netdata/issues/14263))
- DBENGINE v2 - improvements part 3 ([#14269](https://github.com/netdata/netdata/issues/14269))
- Fix for dbengine2 improvements part 3 ([#14284](https://github.com/netdata/netdata/issues/14284))
- DBENGINE v2 - improvements part 4 ([#14285](https://github.com/netdata/netdata/issues/14285))
- Revert health to run in a single thread ([#14244](https://github.com/netdata/netdata/issues/14244))
- Fix(alarms): treat 0 processors as unknown in load_cpu_number ([#14286](https://github.com/netdata/netdata/issues/14286))
- Allow multiple local-build/static-install options in kickstart ([#14287](https://github.com/netdata/netdata/issues/14287))
- DBENGINE v2 - improvements part 5 ([#14289](https://github.com/netdata/netdata/issues/14289))
- Improve file descriptor closing loops ([#14213](https://github.com/netdata/netdata/issues/14213))
- Remove archivedcharts endpoint, optimize indices ([#14296](https://github.com/netdata/netdata/issues/14296))
- Fix macos struct definition. ([#14297](https://github.com/netdata/netdata/issues/14297))
- Track memory footprint of Netdata ([#14294](https://github.com/netdata/netdata/issues/14294))
- Update to SQLITE version 3.40.1 ([#14282](https://github.com/netdata/netdata/issues/14282))
- Switch to self-hosted infrastructure for DEB package distribution. ([#14290](https://github.com/netdata/netdata/issues/14290))
- Fix build CI jobs. ([#14302](https://github.com/netdata/netdata/issues/14302))
- Add consul license expiration time alarm ([#14298](https://github.com/netdata/netdata/issues/14298))
- Bump go.d.plugin to v0.49.2 ([#14305](https://github.com/netdata/netdata/issues/14305))
- Fixes required to make the agent work without crashes on MacOS ([#14304](https://github.com/netdata/netdata/issues/14304))
- Fix Exporiting compilaton error ([#14306](https://github.com/netdata/netdata/issues/14306))
- DBENGINE v2 - improvements part 6 ([#14299](https://github.com/netdata/netdata/issues/14299))
- Update kickstart script to use new DEB infrastructure. ([#14301](https://github.com/netdata/netdata/issues/14301))
- Remove mqtt-c from websockets ([#14181](https://github.com/netdata/netdata/issues/14181))
- DBENGINE v2 - improvements part 7 ([#14307](https://github.com/netdata/netdata/issues/14307))
- DBENGINE v2 - improvements part 8 ([#14319](https://github.com/netdata/netdata/issues/14319))
- Fix up codeowners based on recent staffing changes. ([#14320](https://github.com/netdata/netdata/issues/14320))
- Fix(proc.plugin): add "cpu" label to per core util% charts ([#14322](https://github.com/netdata/netdata/issues/14322))
- Minor - kaitai for netdata datafiles ([#14312](https://github.com/netdata/netdata/issues/14312))
- Misc SSL improvements ([#14317](https://github.com/netdata/netdata/issues/14317))
- Introduce the new Structure of the documentation ([#13915](https://github.com/netdata/netdata/issues/13915))
- Assorted infrastructure cleanup. ([#14223](https://github.com/netdata/netdata/issues/14223))
- Revert "Misc SSL improvements" ([#14327](https://github.com/netdata/netdata/issues/14327))
- Add Collector log ([#14309](https://github.com/netdata/netdata/issues/14309))
- DBENGINE v2 - improvements part 9 ([#14326](https://github.com/netdata/netdata/issues/14326))
- Add |nowarn and |noclear notification modifiers ([#14330](https://github.com/netdata/netdata/issues/14330))
- DBENGINE v2 - improvements part 10 ([#14332](https://github.com/netdata/netdata/issues/14332))
- Use "getent group" instead of reading "/etc/group" to get group information ([#14316](https://github.com/netdata/netdata/issues/14316))
- Improve ebpf exit ([#14270](https://github.com/netdata/netdata/issues/14270))
- Minor fix on notification doc (Discord) ([#14339](https://github.com/netdata/netdata/issues/14339))
- Delete BUILD.md ([#14348](https://github.com/netdata/netdata/issues/14348))
- Update  functions  documents ([#14331](https://github.com/netdata/netdata/issues/14331))
- Add libnetdata readmes to learn, delete empty ([#14371](https://github.com/netdata/netdata/issues/14371))
- Add ansible.md to learn ([#14350](https://github.com/netdata/netdata/issues/14350))
- Delete BREAKING_CHANGES.md ([#14353](https://github.com/netdata/netdata/issues/14353))
- Delete data structures readme ([#14354](https://github.com/netdata/netdata/issues/14354))
- Delete QUICKSTART.md ([#14355](https://github.com/netdata/netdata/issues/14355))
- Add main health readme to learn ([#14356](https://github.com/netdata/netdata/issues/14356))
- Delete libnetdata readme ([#14357](https://github.com/netdata/netdata/issues/14357))
- Add redistributed doc into learn ([#14352](https://github.com/netdata/netdata/issues/14352))
- Revert "Add libnetdata readmes to learn, delete empty" ([#14373](https://github.com/netdata/netdata/issues/14373))
- Add explanation of config files to learn ([#14360](https://github.com/netdata/netdata/issues/14360))
- Add dictionary readme to learn ([#14361](https://github.com/netdata/netdata/issues/14361))
- Add BUFFER lib doc to learn ([#14362](https://github.com/netdata/netdata/issues/14362))
- Add ARL readme to learn ([#14363](https://github.com/netdata/netdata/issues/14363))
- Add July README to learn ([#14364](https://github.com/netdata/netdata/issues/14364))
- Add one way allocator readme to learn ([#14365](https://github.com/netdata/netdata/issues/14365))
- Add simple patterns readme to learn ([#14366](https://github.com/netdata/netdata/issues/14366))
- Add collectors list to learn temporarily ([#14369](https://github.com/netdata/netdata/issues/14369))
- Add collectors main readme to learn ([#14370](https://github.com/netdata/netdata/issues/14370))
- Revert "Delete libnetdata readme" ([#14374](https://github.com/netdata/netdata/issues/14374))
- Update the Get started doc ([#14336](https://github.com/netdata/netdata/issues/14336))
- Patch master ([#14377](https://github.com/netdata/netdata/issues/14377))
- DBENGINE v2 - improvements part 11 ([#14337](https://github.com/netdata/netdata/issues/14337))
- Bump go.d.plugin v0.50.0 ([#14378](https://github.com/netdata/netdata/issues/14378))
- Add missing entries in README.md ([#14351](https://github.com/netdata/netdata/issues/14351))
- Publish Docker images to GHCR.io and Quay.io ([#14372](https://github.com/netdata/netdata/issues/14372))
- Fix publishing Docker Images to secondary registries. ([#14389](https://github.com/netdata/netdata/issues/14389))
- Update the notifications/integrations docs ([#14335](https://github.com/netdata/netdata/issues/14335))
- Fix typo on the page ([#14397](https://github.com/netdata/netdata/issues/14397))
- Fix typos in Docker debug image tags. ([#14400](https://github.com/netdata/netdata/issues/14400))
- Remove equality when deciding how to use point ([#14402](https://github.com/netdata/netdata/issues/14402))
- Add nvidia smi pci bandwidth percent collector ([#14315](https://github.com/netdata/netdata/issues/14315))
- Don't send alert variables to the cloud ([#14325](https://github.com/netdata/netdata/issues/14325))
- Fix link to ebpf collector ([#14405](https://github.com/netdata/netdata/issues/14405))
- DBENGINE v2 - improvements part 12 ([#14379](https://github.com/netdata/netdata/issues/14379))
- Feat(charts.d): add load usage (Watts) to nuts collector ([#14407](https://github.com/netdata/netdata/issues/14407))
- Covert our documentation links to GH absolute links ([#14344](https://github.com/netdata/netdata/issues/14344))
- Fix(cgroups.plugin): fix collecting full pressure stall time ([#14410](https://github.com/netdata/netdata/issues/14410))
- DBENGINE v2 - bug fixes ([#14413](https://github.com/netdata/netdata/issues/14413))
- Fix kickstart and updater not working with BusyBox wget ([#14392](https://github.com/netdata/netdata/issues/14392))
- Fix kubelet alarms ([#14414](https://github.com/netdata/netdata/issues/14414))
- Minor fixes for markdown links ([#14415](https://github.com/netdata/netdata/issues/14415))
- Update dashboard ([#14342](https://github.com/netdata/netdata/issues/14342))
- Add help line to functions response ([#14399](https://github.com/netdata/netdata/issues/14399))
- Fix functions memory leak ([#14419](https://github.com/netdata/netdata/issues/14419))
- Better logging of invalid pages detected on dbengine files ([#14420](https://github.com/netdata/netdata/issues/14420))
- Reduce service exit ([#14381](https://github.com/netdata/netdata/issues/14381))
- Update screenshot of timezone selector ([#14425](https://github.com/netdata/netdata/issues/14425))
- Move under Developer in Learn ([#14417](https://github.com/netdata/netdata/issues/14417))
- Libnetdata readmes learn ([#14416](https://github.com/netdata/netdata/issues/14416))
- Fix typo on the netdata-functions.md ([#14426](https://github.com/netdata/netdata/issues/14426))
- Stop training thread from processing training requests once cancelled. ([#14423](https://github.com/netdata/netdata/issues/14423))
- Check on parents the microseconds delta sent by agents ([#14422](https://github.com/netdata/netdata/issues/14422))
- Turn error() to internal_error() ([#14428](https://github.com/netdata/netdata/issues/14428))
- Updated w1sensor.chart.py ([#14435](https://github.com/netdata/netdata/issues/14435))
- Replication to streaming transition when there are gaps ([#14434](https://github.com/netdata/netdata/issues/14434))

## [1.37.0] - 2022-11-30

### Merged Pull Requests:

- Calculate name hash after rrdvar_fix_name ([#13509](https://github.com/netdata/netdata/issues/13509))
- Fix(packaging): add CAP_NET_ADMIN for go.d.plugin ([#13507](https://github.com/netdata/netdata/issues/13507))
- Chore(python.d): remove python.d/* announced in v1.36.0 deprecation notice ([#13503](https://github.com/netdata/netdata/issues/13503))
- Print rrdcontexts versions with PRIu64 ([#13511](https://github.com/netdata/netdata/issues/13511))
- Modify PID monitoring (ebpf.plugin) ([#13397](https://github.com/netdata/netdata/issues/13397))
- Remove extra U from log message ([#13514](https://github.com/netdata/netdata/issues/13514))
- Docs: add some tips on collecting per-queue metrics for RabbitMQ ([#12227](https://github.com/netdata/netdata/issues/12227))
- Docs(postfix): add a note about `authorized_mailq_users` ([#13515](https://github.com/netdata/netdata/issues/13515))
- Fix(ci): fix fetching tags in Build workflow ([#13517](https://github.com/netdata/netdata/issues/13517))
- Reduce memcpy and memory usage on mqtt5 ([#13450](https://github.com/netdata/netdata/issues/13450))
- Netdata.service: Update PIDFile to avoid systemd legacy path warning ([#13504](https://github.com/netdata/netdata/issues/13504))
- Remove reference to charts now in netdata monitoring ([#13521](https://github.com/netdata/netdata/issues/13521))
- Support chart labels in alerts ([#13290](https://github.com/netdata/netdata/issues/13290))
- Use LVM UUIDs in chart ids for logical volumes ([#13525](https://github.com/netdata/netdata/issues/13525))
- Update FreeIPMI and CUPS plugin documentation. ([#13526](https://github.com/netdata/netdata/issues/13526))
- Fix(cgroups.plugin): use Docker API for name resolution when Docker is a snap package ([#13523](https://github.com/netdata/netdata/issues/13523))
- Fix(health): set default curl connection timeout if not set ([#13529](https://github.com/netdata/netdata/issues/13529))
- Schedule next rotation based on absolute time ([#13531](https://github.com/netdata/netdata/issues/13531))
- Add `jupyter` to `apps_groups.conf` ([#13533](https://github.com/netdata/netdata/issues/13533))
- Add summary dashboard for PostgreSQL ([#13534](https://github.com/netdata/netdata/issues/13534))
- Chore(python.d): rename dockerd job on lock registration ([#13537](https://github.com/netdata/netdata/issues/13537))
- Bump go.d version to v0.36.0 ([#13538](https://github.com/netdata/netdata/issues/13538))
- Update MacOS community support details ([#13536](https://github.com/netdata/netdata/issues/13536))
- Bump Coverity version to latest (2022.06). ([#13541](https://github.com/netdata/netdata/issues/13541))
- Cleanup of APIs ([#13539](https://github.com/netdata/netdata/issues/13539))
- Fix telegram-bot rate limit ([#13119](https://github.com/netdata/netdata/issues/13119))
- Fix a crash when xen libraries are misconfigured ([#13535](https://github.com/netdata/netdata/issues/13535))
- Bump go.d.plugin to v0.37.0 ([#13546](https://github.com/netdata/netdata/issues/13546))
- Add docker dashboard info ([#13547](https://github.com/netdata/netdata/issues/13547))
- Fix coverity 380387 ([#13551](https://github.com/netdata/netdata/issues/13551))
- Bump go.d.plugin to v0.37.1 ([#13555](https://github.com/netdata/netdata/issues/13555))
- Feat(python.d/sensors): discover chips, features at runtime ([#13545](https://github.com/netdata/netdata/issues/13545))
- Improve PID monitoring (step 2) ([#13530](https://github.com/netdata/netdata/issues/13530))
- Prefer context attributes from non archived charts ([#13559](https://github.com/netdata/netdata/issues/13559))
- Update dashboard to version v2.28.6. ([#13562](https://github.com/netdata/netdata/issues/13562))
- Fix(health.d/mysql): adjust `mysql_galera_cluster_size_max_2m` lookup to make time in warn/crit predictable ([#13563](https://github.com/netdata/netdata/issues/13563))
- Remove aclk_api.[ch] ([#13540](https://github.com/netdata/netdata/issues/13540))
- Add more monitoring tools to `apps_groups.conf` ([#13566](https://github.com/netdata/netdata/issues/13566))
- Chore: removing logging that a chart collection in the same interpolation point ([#13567](https://github.com/netdata/netdata/issues/13567))
- Minor - eBPF cmake missing include dir ([#13568](https://github.com/netdata/netdata/issues/13568))
- Add `apt` to `apps_groups.conf` ([#13571](https://github.com/netdata/netdata/issues/13571))
- Bump go.d.plugin to v0.37.2 ([#13574](https://github.com/netdata/netdata/issues/13574))
- Updating info for postgreqsql metrics ([#13573](https://github.com/netdata/netdata/issues/13573))
- Prevent crash on rrdcontext apis when rrdcontexts is not initialized ([#13578](https://github.com/netdata/netdata/issues/13578))
- Fix(python.d/nvidia_smi): repsect update_every for polling ([#13579](https://github.com/netdata/netdata/issues/13579))
- Feat(python.d/nvidia_smi): collect power state ([#13580](https://github.com/netdata/netdata/issues/13580))
- Sqlite3 global statistics ([#13594](https://github.com/netdata/netdata/issues/13594))
- Add link to the performance optimization guide ([#13595](https://github.com/netdata/netdata/issues/13595))
- Update logind dashboard info ([#13597](https://github.com/netdata/netdata/issues/13597))
- Fix(cgroups.plugin): fix chart id length check ([#13601](https://github.com/netdata/netdata/issues/13601))
- Bump go.d.plugin to v0.38.0 ([#13603](https://github.com/netdata/netdata/issues/13603))
- Temporary fix for command injection vulnerability in GHA workflow. ([#13600](https://github.com/netdata/netdata/issues/13600))
- Add info text for wal and update for checkpoints ([#13607](https://github.com/netdata/netdata/issues/13607))
- Don't try to load db rows when chart_id or dim_id is null ([#13608](https://github.com/netdata/netdata/issues/13608))
- Update dashboard to version v2.28.8. ([#13609](https://github.com/netdata/netdata/issues/13609))
- Use prepared statements for context related queries ([#13602](https://github.com/netdata/netdata/issues/13602))
- Improve coverage of Linux kernel threads in apps_groups.conf ([#13612](https://github.com/netdata/netdata/issues/13612))
- Add spiceproxy to proxmox group ([#13615](https://github.com/netdata/netdata/issues/13615))
- Update Postgres "connections" dashboard info ([#13619](https://github.com/netdata/netdata/issues/13619))
- Add Postgres total connection utilization alarm ([#13620](https://github.com/netdata/netdata/issues/13620))
- Fix apps plugin users charts descriptipon ([#13621](https://github.com/netdata/netdata/issues/13621))
- Assorted updates for apps_groups.conf. ([#13618](https://github.com/netdata/netdata/issues/13618))
- Clean chart hash map  ([#13611](https://github.com/netdata/netdata/issues/13611))
- Deduplicate all netdata strings ([#13570](https://github.com/netdata/netdata/issues/13570))
- Faster rrdcontext ([#13629](https://github.com/netdata/netdata/issues/13629))
- Remove forgotten avl structure from rrdcalc ([#13632](https://github.com/netdata/netdata/issues/13632))
- Fix worker utilization cleanup ([#13633](https://github.com/netdata/netdata/issues/13633))
- Obsolete RRDSET state ([#13635](https://github.com/netdata/netdata/issues/13635))
- Updated tc.plugin (linux bandwidth QoS) ([#13634](https://github.com/netdata/netdata/issues/13634))
- Fix compile issues ([#13640](https://github.com/netdata/netdata/issues/13640))
- Deaggregate the `gui` and `email` app groupx and improve GUI coverage. ([#13631](https://github.com/netdata/netdata/issues/13631))
- Apps.plugin: Re-add `chrome` to the `webbrowser` group. ([#13642](https://github.com/netdata/netdata/issues/13642))
- EBPF different improvements ([#13624](https://github.com/netdata/netdata/issues/13624))
- Fix rrdcontexts left in the post-processing queue from the garbage collector ([#13645](https://github.com/netdata/netdata/issues/13645))
- Fix a memory leak on archived host creation ([#13641](https://github.com/netdata/netdata/issues/13641))
- Add _collect_job label to python.d/* charts ([#13648](https://github.com/netdata/netdata/issues/13648))
- Improve agent shutdown time ([#13649](https://github.com/netdata/netdata/issues/13649))
- Do not free AR dimensions from within ML. ([#13651](https://github.com/netdata/netdata/issues/13651))
- CMake improvements part 1 ([#13575](https://github.com/netdata/netdata/issues/13575))
- Fix container virtualization info ([#13653](https://github.com/netdata/netdata/issues/13653))
- Update dashboard to version v2.29.0. ([#13654](https://github.com/netdata/netdata/issues/13654))
- Use mmap if possible during startup for journal replay ([#13660](https://github.com/netdata/netdata/issues/13660))
- Bump go.d.plugin to v0.39.0 ([#13662](https://github.com/netdata/netdata/issues/13662))
- Update Postgres dashboard info ([#13661](https://github.com/netdata/netdata/issues/13661))
- Adjust systemdunits alarms ([#13623](https://github.com/netdata/netdata/issues/13623))
- Add sqlite page cache hit and miss statistics ([#13665](https://github.com/netdata/netdata/issues/13665))
- Advance the buffer properly to scan the journal file ([#13666](https://github.com/netdata/netdata/issues/13666))
- Additional sqlite statistics ([#13668](https://github.com/netdata/netdata/issues/13668))
- Add proxysql dashboard info ([#13669](https://github.com/netdata/netdata/issues/13669))
- Fix typo not deleting collected flag; force removing collected flag on child disconnect ([#13672](https://github.com/netdata/netdata/issues/13672))
- Remove _instance_family label ([#13674](https://github.com/netdata/netdata/issues/13674))
- Feat(health): add Postgres alarms ([#13671](https://github.com/netdata/netdata/issues/13671))
- Bump go.d.plugin v0.40.0 ([#13675](https://github.com/netdata/netdata/issues/13675))
- RRD structures managed by dictionaries ([#13646](https://github.com/netdata/netdata/issues/13646))
- Disable internal log ([#13678](https://github.com/netdata/netdata/issues/13678))
- Dictionary updated documentation and cosmetics ([#13679](https://github.com/netdata/netdata/issues/13679))
- Store nulls instead of empty strings in health tables ([#13683](https://github.com/netdata/netdata/issues/13683))
- Add a document outlining how to build native packages locally. ([#12431](https://github.com/netdata/netdata/issues/12431))
- Docs: nvidia-smi in a container limitation note ([#13695](https://github.com/netdata/netdata/issues/13695))
- Update dashboard to version v2.29.1. ([#13696](https://github.com/netdata/netdata/issues/13696))
- Update uninstaller documentation. ([#13627](https://github.com/netdata/netdata/issues/13627))
- Disable Postgres last vacuum/analyze alarms ([#13698](https://github.com/netdata/netdata/issues/13698))
- Fix inconsistent alert class names ([#13699](https://github.com/netdata/netdata/issues/13699))
- Alarms collector: ability to exclude certain alarms via config ([#13701](https://github.com/netdata/netdata/issues/13701))
- Build judy even without dbengine ([#13703](https://github.com/netdata/netdata/issues/13703))
- Bump go.d.plugin to v0.40.1 ([#13704](https://github.com/netdata/netdata/issues/13704))
- Do not create train/predict dimensions meant for tracking anomaly rates. ([#13707](https://github.com/netdata/netdata/issues/13707))
- Specify paths to source files for out-of-tree build. ([#11475](https://github.com/netdata/netdata/issues/11475))
- Feat(health): add new Redis alarms ([#13715](https://github.com/netdata/netdata/issues/13715))
- Faster streaming by 25% on the child ([#13708](https://github.com/netdata/netdata/issues/13708))
- Update exporting unit tests ([#13706](https://github.com/netdata/netdata/issues/13706))
- Use CMake generated config.h also in out of tree CMake build ([#13692](https://github.com/netdata/netdata/issues/13692))
- Do not try to start an archived host in dbengine if dbengine is not compiled ([#13724](https://github.com/netdata/netdata/issues/13724))
- Fix warnings during compilation time on ARM (32 bits) ([#13681](https://github.com/netdata/netdata/issues/13681))
- Remove Chart/Dim based communication ([#13650](https://github.com/netdata/netdata/issues/13650))
- CMake - add possibility to build without ACLK ([#13736](https://github.com/netdata/netdata/issues/13736))
- Change cast to remove coverity warnings ([#13735](https://github.com/netdata/netdata/issues/13735))
- Dont send NodeInfo during first database cleanup ([#13740](https://github.com/netdata/netdata/issues/13740))
- Fix handling of temporary directories in kickstart code. ([#13744](https://github.com/netdata/netdata/issues/13744))
- Fix(python.d): set correct label source for _collect_job label ([#13746](https://github.com/netdata/netdata/issues/13746))
- Bump go.d v0.40.2 ([#13747](https://github.com/netdata/netdata/issues/13747))
- Add info for Docker containers about using hostname from host. ([#13685](https://github.com/netdata/netdata/issues/13685))
- Provide Details on Label Filtering/Custom Labels ([#13745](https://github.com/netdata/netdata/issues/13745))
- Fix streaming crash when child reconnects and is archived on the parent ([#13754](https://github.com/netdata/netdata/issues/13754))
- Add node level AR based example ([#13684](https://github.com/netdata/netdata/issues/13684))
- Add CloudLinux OS detection to kickstart ([#13750](https://github.com/netdata/netdata/issues/13750))
- Add CloudLinux OS detection to the updater script ([#13752](https://github.com/netdata/netdata/issues/13752))
- Add ZFS rate charts ([#13757](https://github.com/netdata/netdata/issues/13757))
- Use /bin/sh instead of ls to detect glibc ([#13758](https://github.com/netdata/netdata/issues/13758))
- Add 1m delay for tcp reset alarms ([#13761](https://github.com/netdata/netdata/issues/13761))
- Remove anomaly detector ([#13657](https://github.com/netdata/netdata/issues/13657))
- Allow netdata plugins to expose functions for querying more information about specific charts ([#13720](https://github.com/netdata/netdata/issues/13720))
- Fix bad merge ([#13764](https://github.com/netdata/netdata/issues/13764))
- Overhaul handling of installation of Netdata as a system service. ([#13451](https://github.com/netdata/netdata/issues/13451))
- Bump go.d.plugin v0.40.3 ([#13771](https://github.com/netdata/netdata/issues/13771))
- Rename variable for old CentOS version ([#13775](https://github.com/netdata/netdata/issues/13775))
- Bump websockets submodule ([#13776](https://github.com/netdata/netdata/issues/13776))
- Feat: disable cloud if `NETDATA_DISABLE_CLOUD` is set to 1 ([#13106](https://github.com/netdata/netdata/issues/13106))
- Remove extern from function declared in headers. ([#13790](https://github.com/netdata/netdata/issues/13790))
- Allow netdata installer to install and run netdata as any user ([#13780](https://github.com/netdata/netdata/issues/13780))
- Full memory tracking and profiling of Netdata Agent ([#13789](https://github.com/netdata/netdata/issues/13789))
- Initialize st->rrdvars from rrdset insert callback ([#13786](https://github.com/netdata/netdata/issues/13786))
- Array Allocator Memory Leak Fix ([#13792](https://github.com/netdata/netdata/issues/13792))
- Feat(python.d): respect NETDATA_INTERNALS_MONITORING ([#13793](https://github.com/netdata/netdata/issues/13793))
- Update libbpf 1.0.1 ([#13778](https://github.com/netdata/netdata/issues/13778))
- Parser cleanup  ([#13782](https://github.com/netdata/netdata/issues/13782))
- Stop pulling in netcat as a mandatory dependency. ([#13787](https://github.com/netdata/netdata/issues/13787))
- Also enable rrdvars from health ([#13795](https://github.com/netdata/netdata/issues/13795))
- Return memory freed properly ([#13799](https://github.com/netdata/netdata/issues/13799))
- Use string_freez instead of freez in rrdhost_init_timezone ([#13798](https://github.com/netdata/netdata/issues/13798))
- Fix minor typo in systemdunits.conf alert ([#13796](https://github.com/netdata/netdata/issues/13796))
- Internal log error, when passing NULL dictionary ([#13803](https://github.com/netdata/netdata/issues/13803))
- ARAL optimal alloc size ([#13804](https://github.com/netdata/netdata/issues/13804))
- Minor - add host labels for ephemerality and nodes with unstable connections ([#13784](https://github.com/netdata/netdata/issues/13784))
- Add Ubuntu 22.10 to supported distros, CI, and package builds. ([#13785](https://github.com/netdata/netdata/issues/13785))
- Add Fedora 37 to CI and package builds. ([#13489](https://github.com/netdata/netdata/issues/13489))
- Fix warning when -Wfree-nonheap-object is used ([#13805](https://github.com/netdata/netdata/issues/13805))
- Fix post-processing of contexts ([#13807](https://github.com/netdata/netdata/issues/13807))
- Merge netstat, snmp, and snmp6 modules ([#13806](https://github.com/netdata/netdata/issues/13806))
- Bump go.d.plugin v0.40.4 ([#13808](https://github.com/netdata/netdata/issues/13808))
- Overload libc memory allocators with custom ones to trace all allocations ([#13810](https://github.com/netdata/netdata/issues/13810))
- Dbengine free from RRDSET and RRDDIM ([#13772](https://github.com/netdata/netdata/issues/13772))
- Allow disabling netdata monitoring section of the dashboard ([#13788](https://github.com/netdata/netdata/issues/13788))
- Count currently streaming senders on the localhost ([#13755](https://github.com/netdata/netdata/issues/13755))
- Fix existing install detection for FreeBSD and macOS. ([#13243](https://github.com/netdata/netdata/issues/13243))
- Update fping plugin documentation with better details about the required version. ([#13765](https://github.com/netdata/netdata/issues/13765))
- Minor - add trace alloc to buildinfo ([#13817](https://github.com/netdata/netdata/issues/13817))
- Fix exporting unit tests ([#13816](https://github.com/netdata/netdata/issues/13816))
- Fix crash on child reconnect and lost metrics ([#13821](https://github.com/netdata/netdata/issues/13821))
- Remove NFS readahead histogram ([#13819](https://github.com/netdata/netdata/issues/13819))
- Add variants of functions allowing callers to specify the time to use. ([#13791](https://github.com/netdata/netdata/issues/13791))
- Add a CodeQL analysis workflow. ([#13812](https://github.com/netdata/netdata/issues/13812))
- Extended processes function info from apps.plugin ([#13822](https://github.com/netdata/netdata/issues/13822))
- Add a thread to asynchronously process metadata updates ([#13783](https://github.com/netdata/netdata/issues/13783))
- Bump google-github-actions/setup-gcloud from 0.6.0 to 0.6.2 ([#13836](https://github.com/netdata/netdata/issues/13836))
- Bump google-github-actions/upload-cloud-storage from 0.10.2 to 0.10.4 ([#13837](https://github.com/netdata/netdata/issues/13837))
- Chore(health): rm pihole_blocklist_gravity_file_existence_state ([#13826](https://github.com/netdata/netdata/issues/13826))
- Improve error and warning messages in the kickstart script. ([#13825](https://github.com/netdata/netdata/issues/13825))
- Further improvements to the new service installation code. ([#13774](https://github.com/netdata/netdata/issues/13774))
- Add PR labels to force running Reviewdog checks. ([#13818](https://github.com/netdata/netdata/issues/13818))
- Inject costallocz to mqtt_websockets library and its children ([#13813](https://github.com/netdata/netdata/issues/13813))
- Fix service installation on FreeBSD. ([#13842](https://github.com/netdata/netdata/issues/13842))
- Fix tiers update frequency ([#13844](https://github.com/netdata/netdata/issues/13844))
- Use PR label to trigger full packaging CI instead of PR body contents. ([#13839](https://github.com/netdata/netdata/issues/13839))
- Change CI trigger label prefix from `ci/` to `run-ci/`. ([#13849](https://github.com/netdata/netdata/issues/13849))
- Fix runtime directory ownership when installed as non-root user. ([#13797](https://github.com/netdata/netdata/issues/13797))
- Pandas collector ([#13773](https://github.com/netdata/netdata/issues/13773))
- Properly propagate errors from installer/updater to kickstart script. ([#13802](https://github.com/netdata/netdata/issues/13802))
- Properly guard commands when installing services for offline service managers. ([#13848](https://github.com/netdata/netdata/issues/13848))
- Health thread per host ([#13712](https://github.com/netdata/netdata/issues/13712))
- Fix typo ([#13853](https://github.com/netdata/netdata/issues/13853))
- Retry reading carrier, duplex, and speed files periodically ([#13850](https://github.com/netdata/netdata/issues/13850))
- Bump go.d.plugin to v0.41.0 ([#13861](https://github.com/netdata/netdata/issues/13861))
- Add ACLK access to ml_info (fix anomalies tab in cloud) ([#13863](https://github.com/netdata/netdata/issues/13863))
- Update step-09 for dbmode update.md ([#13864](https://github.com/netdata/netdata/issues/13864))
- Fix(cgroup.plugin): handle qemu-1- prefix when extracting virsh domain ([#13866](https://github.com/netdata/netdata/issues/13866))
- QUERY_TARGET: new query engine for Netdata Agent ([#13697](https://github.com/netdata/netdata/issues/13697))
- Use llvm's ar and ranlib when compiling with clang ([#13854](https://github.com/netdata/netdata/issues/13854))
- Use mmap to read an extent from a datafile ([#13834](https://github.com/netdata/netdata/issues/13834))
- App to api netdata cloud ([#13856](https://github.com/netdata/netdata/issues/13856))
- Bump go.d.plugin v0.41.1 ([#13874](https://github.com/netdata/netdata/issues/13874))
- Cassandra dashboard description ([#13835](https://github.com/netdata/netdata/issues/13835))
- Store hidden status when creating / updating dimension metadata ([#13869](https://github.com/netdata/netdata/issues/13869))
- Allow single chart to be filtered in context queries ([#13879](https://github.com/netdata/netdata/issues/13879))
- Don't create a REMOVED alert event after a REMOVED. ([#13871](https://github.com/netdata/netdata/issues/13871))
- Apps.plugin function processes cosmetic changes ([#13880](https://github.com/netdata/netdata/issues/13880))
- Assorted cleanup in the OpenRC init script. ([#13115](https://github.com/netdata/netdata/issues/13115))
- Suppress ML and dlib ABI warnings ([#13875](https://github.com/netdata/netdata/issues/13875))
- Fix typo in CI distribution data file. ([#13882](https://github.com/netdata/netdata/issues/13882))
- Use print macros ([#13876](https://github.com/netdata/netdata/issues/13876))
- Add description for TCP WMI ([#13878](https://github.com/netdata/netdata/issues/13878))
- Find the chart and dimension UUID from the context ([#13868](https://github.com/netdata/netdata/issues/13868))
- Fix duplicate error code in kickstart.sh. ([#13887](https://github.com/netdata/netdata/issues/13887))
- Filtering out charts in context queries, includes them in full_xxx variables ([#13886](https://github.com/netdata/netdata/issues/13886))
- Tune rrdcontext timings ([#13889](https://github.com/netdata/netdata/issues/13889))
- Fix(proc.plugin): fix read retry logic when reading interface speed ([#13893](https://github.com/netdata/netdata/issues/13893))
- Fix reading health "enable" from the configuration ([#13894](https://github.com/netdata/netdata/issues/13894))
- Add pandas collector to collectors.md ([#13895](https://github.com/netdata/netdata/issues/13895))
- Record installation command in telemetry events. ([#13892](https://github.com/netdata/netdata/issues/13892))
- Bump go.d.plugin v0.41.2 ([#13903](https://github.com/netdata/netdata/issues/13903))
- Remove option to use MQTT 3 ([#13824](https://github.com/netdata/netdata/issues/13824))
- Reference the bash collector for RPi ([#13907](https://github.com/netdata/netdata/issues/13907))
- Improve intro paragraph ([#13906](https://github.com/netdata/netdata/issues/13906))
- Apps.plugin function add max value on all value columns ([#13899](https://github.com/netdata/netdata/issues/13899))
- Prompt users about updates/claiming on unknown install types. ([#13890](https://github.com/netdata/netdata/issues/13890))
- Timeframe matching should take into account the update frequency of the chart ([#13911](https://github.com/netdata/netdata/issues/13911))
- Do not free hosts if a change on db mode is not needed ([#13912](https://github.com/netdata/netdata/issues/13912))
- Bump go.d.plugin to v0.42.0 ([#13913](https://github.com/netdata/netdata/issues/13913))
- Feat(packaging): add CAP_NET_RAW to go.d.plugin ([#13909](https://github.com/netdata/netdata/issues/13909))
- Replication of metrics (gaps filling) during streaming ([#13873](https://github.com/netdata/netdata/issues/13873))
- Add ping dashboard info and alarms ([#13916](https://github.com/netdata/netdata/issues/13916))
- Fix crash on query plan switch ([#13920](https://github.com/netdata/netdata/issues/13920))
- Return accidentaly removed 32bit RPi keep alive fix ([#13925](https://github.com/netdata/netdata/issues/13925))
- Fix systemd chart update (eBPF) ([#13884](https://github.com/netdata/netdata/issues/13884))
- Remove Alpine 3.13 from CI and official support. ([#13415](https://github.com/netdata/netdata/issues/13415))
- Fix compiling without dbengine ([#13931](https://github.com/netdata/netdata/issues/13931))
- Error_limit() function to limit number of error lines per instance ([#13924](https://github.com/netdata/netdata/issues/13924))
- Rrddim acquire on replay set ([#13932](https://github.com/netdata/netdata/issues/13932))
- Bump go.d.plugin to v0.42.1 ([#13930](https://github.com/netdata/netdata/issues/13930))
- Remove pluginsd action param & dead code. ([#13928](https://github.com/netdata/netdata/issues/13928))
- Update print message on startup ([#13934](https://github.com/netdata/netdata/issues/13934))
- Statsd dictionaries should be multi-threaded ([#13938](https://github.com/netdata/netdata/issues/13938))
- Overhaul generation of distinct-ids for install telemetry events. ([#13891](https://github.com/netdata/netdata/issues/13891))
- Fix chart definition end time_t printing and parsing ([#13942](https://github.com/netdata/netdata/issues/13942))
- Update link to point at demo spaces ([#13939](https://github.com/netdata/netdata/issues/13939))
- Recalculate last_collected_total ([#13945](https://github.com/netdata/netdata/issues/13945))
- Enable aclk conversation log even without NETDATA_INTERNAL CHECKS ([#13917](https://github.com/netdata/netdata/issues/13917))
- Do not resend charts upstream when chart variables are being updated ([#13946](https://github.com/netdata/netdata/issues/13946))
- Setup default certificates path ([#13941](https://github.com/netdata/netdata/issues/13941))
- Fix oracle linux (eBPF plugin) ([#13935](https://github.com/netdata/netdata/issues/13935))
- Reduce unnecessary alert events to the cloud ([#13897](https://github.com/netdata/netdata/issues/13897))
- Fix local dashboard cloud links ([#13953](https://github.com/netdata/netdata/issues/13953))
- Bump go.d.plugin to v0.43.0 ([#13954](https://github.com/netdata/netdata/issues/13954))
- Health/ping: use 'host' label in alerts info ([#13955](https://github.com/netdata/netdata/issues/13955))
- Provide improved messaging in the kickstart script for existing installs managed by the system package manager. ([#13947](https://github.com/netdata/netdata/issues/13947))
- Require -DENABLE_DLSYM=1 to use dlsym() ([#13958](https://github.com/netdata/netdata/issues/13958))
- Remove anomaly rates chart. ([#13763](https://github.com/netdata/netdata/issues/13763))
- Document password param for tor collector ([#13966](https://github.com/netdata/netdata/issues/13966))
- Break active-active loop from replicating non-existing child to each other ([#13968](https://github.com/netdata/netdata/issues/13968))
- Enable collecting ECC memory errors by default ([#13970](https://github.com/netdata/netdata/issues/13970))
- Fallback to ar and ranlib if llvm-ar and llvm-ranlib are not there ([#13959](https://github.com/netdata/netdata/issues/13959))
- Add Cassandra icon to dashboard info ([#13975](https://github.com/netdata/netdata/issues/13975))
- Remove health_thread_stop ([#13948](https://github.com/netdata/netdata/issues/13948))
- Change the db-engine calculator to a read only gsheet ([#13974](https://github.com/netdata/netdata/issues/13974))
- Dont crash when netdata cannot execute its external plugins ([#13978](https://github.com/netdata/netdata/issues/13978))
- Add _total suffix to raw increment metrics for remote write ([#13977](https://github.com/netdata/netdata/issues/13977))
- Apps.plugin function processes: keys should not have spaces ([#13980](https://github.com/netdata/netdata/issues/13980))
- WMI Process (Dashboard, Documentation) ([#13910](https://github.com/netdata/netdata/issues/13910))
- Replication improvements ([#13989](https://github.com/netdata/netdata/issues/13989))
- Added debug info on left-over query targets ([#13990](https://github.com/netdata/netdata/issues/13990))
- Bump go.d.plugin to v0.43.1 ([#13993](https://github.com/netdata/netdata/issues/13993))
- Bump google-github-actions/setup-gcloud from 0.6.2 to 1.0.1 ([#13991](https://github.com/netdata/netdata/issues/13991))
- Remove python.d/nginx_plus ([#13995](https://github.com/netdata/netdata/issues/13995))
- Publish nightly builds to netdata/netdata-nightlies repository. ([#13961](https://github.com/netdata/netdata/issues/13961))
- New journal disk based indexing for agent memory reduction ([#13885](https://github.com/netdata/netdata/issues/13885))
- Add 'funcs' capability ([#13992](https://github.com/netdata/netdata/issues/13992))
- Fixes MQTT-NG QoS0 ([#13997](https://github.com/netdata/netdata/issues/13997))
- Enable dbengine tiering by default ([#13914](https://github.com/netdata/netdata/issues/13914))
- Revert "enable dbengine tiering by default" ([#13999](https://github.com/netdata/netdata/issues/13999))
- Revert "New journal disk based indexing for agent memory reduction" ([#14000](https://github.com/netdata/netdata/issues/14000))
- Minor typo in the uninstall command ([#14002](https://github.com/netdata/netdata/issues/14002))
- Fix connection resets on big parents ([#14004](https://github.com/netdata/netdata/issues/14004))
- Use calculator app instead of spreadsheet ([#13981](https://github.com/netdata/netdata/issues/13981))
- Change relative links to absolute for learn components ([#14015](https://github.com/netdata/netdata/issues/14015))
- Allow statsd tags to modify chart metadata on the fly ([#14014](https://github.com/netdata/netdata/issues/14014))
- Minor - silence misleading error ([#14013](https://github.com/netdata/netdata/issues/14013))
- Fix nightly build uploads. ([#14017](https://github.com/netdata/netdata/issues/14017))
- Fix typo in GHA workflow.
- Streaming compression, query planner and replication fixes ([#14023](https://github.com/netdata/netdata/issues/14023))
- Remove retries from SSL ([#14026](https://github.com/netdata/netdata/issues/14026))
- Fix documentation TLS streaming ([#14024](https://github.com/netdata/netdata/issues/14024))
- Update codeowners ([#14025](https://github.com/netdata/netdata/issues/14025))
- Bump go.d.plugin v0.44.0 ([#14030](https://github.com/netdata/netdata/issues/14030))
- Change static image urls to app.netdata.cloud in alarm-notify.sh ([#14007](https://github.com/netdata/netdata/issues/14007))
- Use 2 levels of judy arrays to speed up replication on very busy parents ([#14031](https://github.com/netdata/netdata/issues/14031))
- Do not force internal collectors to call rrdset_next. ([#13926](https://github.com/netdata/netdata/issues/13926))
- Improve performance of worker utilization statistics ([#14034](https://github.com/netdata/netdata/issues/14034))
- Replication fixes #3 ([#14035](https://github.com/netdata/netdata/issues/14035))
- Do not merge duplicate replication requests  ([#14037](https://github.com/netdata/netdata/issues/14037))
- Replication fixes #5 ([#14038](https://github.com/netdata/netdata/issues/14038))
- Add up to date info on improving performance ([#13801](https://github.com/netdata/netdata/issues/13801))
- Fix dictionaries unittest ([#14042](https://github.com/netdata/netdata/issues/14042))
- Minor - Adds better information in case of SSL error ([#14041](https://github.com/netdata/netdata/issues/14041))
- Minor - wss to point to master instead of branch ([#14043](https://github.com/netdata/netdata/issues/14043))
- Don't let slow disk plugin thread delay shutdown ([#14044](https://github.com/netdata/netdata/issues/14044))
- Fix build on old openssl versions on centos ([#14045](https://github.com/netdata/netdata/issues/14045))
- Improve eBPF exit ([#14012](https://github.com/netdata/netdata/issues/14012))
- Replication fixes #6 ([#14046](https://github.com/netdata/netdata/issues/14046))
- Replication fixes No 7 ([#14053](https://github.com/netdata/netdata/issues/14053))
- Remove cmocka tests from ci ([#14054](https://github.com/netdata/netdata/issues/14054))
- Remove eBPF plugin warning ([#14047](https://github.com/netdata/netdata/issues/14047))
- Bump go.d.plugin to v0.45.0 ([#14052](https://github.com/netdata/netdata/issues/14052))
- Bump actions/add-to-project from 0.3.0 to 0.4.0 ([#14048](https://github.com/netdata/netdata/issues/14048))
- Bump google-github-actions/upload-cloud-storage from 0.10.4 to 1.0.0 ([#14049](https://github.com/netdata/netdata/issues/14049))
- Add Alpine 3.17 to supported distros. ([#14056](https://github.com/netdata/netdata/issues/14056))
- Fix(updater): don't produce any output if static update completed successfully ([#14058](https://github.com/netdata/netdata/issues/14058))
- Replication fixes No 8 ([#14061](https://github.com/netdata/netdata/issues/14061))
- Sanitize command arguments. ([#14064](https://github.com/netdata/netdata/issues/14064))
- Strict control of streaming API keys and MACHINE GUIDs in stream.conf ([#14063](https://github.com/netdata/netdata/issues/14063))
- Dummy commit to force rebuilding nightlies.
- Fix spinlock ([#14068](https://github.com/netdata/netdata/issues/14068))

## [1.36.0] - 2022-08-10

### Merged Pull Requests:

- Temporarily disable updates for static builds. ([#13100](https://github.com/netdata/netdata/issues/13100))
- Remove unnescesary ‘cleanup’ code. ([#13103](https://github.com/netdata/netdata/issues/13103))
- Re-enable updates for systems using static builds. ([#13110](https://github.com/netdata/netdata/issues/13110))
- Docs(statsd.plugin): fix indentation ([#13096](https://github.com/netdata/netdata/issues/13096))
- Add openSUSE Leap 15.4 to CI and package builds. ([#12270](https://github.com/netdata/netdata/issues/12270))
- Fix virtualization detection on FreeBSD ([#13087](https://github.com/netdata/netdata/issues/13087))
- Add user netdata to secondary group in DEB package ([#13109](https://github.com/netdata/netdata/issues/13109))
- Labels with dictionary ([#13070](https://github.com/netdata/netdata/issues/13070))
- 73x times faster metrics correlations at the agent ([#13107](https://github.com/netdata/netdata/issues/13107))
- Ci coverage ([#13118](https://github.com/netdata/netdata/issues/13118))
- Fix typo in release base prep script. ([#13098](https://github.com/netdata/netdata/issues/13098))
- Fixed coveriry 379136 379135 379134 379133 ([#13123](https://github.com/netdata/netdata/issues/13123))
- Allow label names to have slashes ([#13125](https://github.com/netdata/netdata/issues/13125))
- Buffer overflow detected by the compiler ([#13120](https://github.com/netdata/netdata/issues/13120))
- ACLK statistics on bytes recvd and sent ([#13091](https://github.com/netdata/netdata/issues/13091))
- Fix(python.d/mongodb): set `serverSelectionTimeoutMS` for pymongo4+ ([#13135](https://github.com/netdata/netdata/issues/13135))
- Fix(python.d): urllib3 import collection for py3.10+ ([#13136](https://github.com/netdata/netdata/issues/13136))
- Use a separate thread for slow mountpoints in the diskspace plugin ([#13067](https://github.com/netdata/netdata/issues/13067))
- Use ks2 as MC default ([#13131](https://github.com/netdata/netdata/issues/13131))
- Fix crashes due to misaligned allocations ([#13137](https://github.com/netdata/netdata/issues/13137))
- Add missing control to streaming ([#13112](https://github.com/netdata/netdata/issues/13112))
- Add an option to use malloc for page cache instead of mmap ([#13142](https://github.com/netdata/netdata/issues/13142))
- Update docs on what to do if collector not there ([#13152](https://github.com/netdata/netdata/issues/13152))
- Remove pinned page reference ([#13108](https://github.com/netdata/netdata/issues/13108))
- Add cargo/rustc/bazel/buck to apps_groups.conf ([#13143](https://github.com/netdata/netdata/issues/13143))
- Revert to default of `host anomaly rate threshold=0.01` ([#13150](https://github.com/netdata/netdata/issues/13150))
- Fix conditions for nightly build triggers ([#13145](https://github.com/netdata/netdata/issues/13145))
- Fix labels unit test ([#13156](https://github.com/netdata/netdata/issues/13156))
- Add CAP_SYS_RAWIO to Netdata's systemd unit CapabilityBoundingSet ([#13154](https://github.com/netdata/netdata/issues/13154))
- Add mem.available chart to FreeBSD ([#13140](https://github.com/netdata/netdata/issues/13140))
- Configurable storage engine for Netdata agents: step 3 ([#12892](https://github.com/netdata/netdata/issues/12892))
- Use memset to mark the empty words in the quoted_strings_splitter function ([#13161](https://github.com/netdata/netdata/issues/13161))
- Don’t manipulate positional parameters in DEB postinst script. ([#13169](https://github.com/netdata/netdata/issues/13169))
- Fix coverity issues ([#13168](https://github.com/netdata/netdata/issues/13168))
- Enable ml by default ([#13158](https://github.com/netdata/netdata/issues/13158))
- Fix data query on stale chart ([#13159](https://github.com/netdata/netdata/issues/13159))
- Feat(proc/proc_net_dev): add dim per operstate to the "Interface Operational State" chart ([#13167](https://github.com/netdata/netdata/issues/13167))
- Revert "Configurable storage engine for Netdata agents: step 3 ([#12892](https://github.com/netdata/netdata/issues/12892))" ([#13171](https://github.com/netdata/netdata/issues/13171))
- Feat(proc/proc_net_dev): add dim per duplex state to the "Interface Duplex State" chart ([#13165](https://github.com/netdata/netdata/issues/13165))
- Allow traversing null-value dictionaries ([#13162](https://github.com/netdata/netdata/issues/13162))
- Fix coverity 378587 ([#13024](https://github.com/netdata/netdata/issues/13024))
- Feat(proc/proc_net_dev): add dim per phys link state to the "Interface Physical Link State" chart ([#13176](https://github.com/netdata/netdata/issues/13176))
- Update dashboard to version v2.26.2. ([#13177](https://github.com/netdata/netdata/issues/13177))
- Set default for `minimum num samples to train` to `900` ([#13174](https://github.com/netdata/netdata/issues/13174))
- Add k8s_state dashboard_info ([#13181](https://github.com/netdata/netdata/issues/13181))
- Add ml alerts examples ([#13173](https://github.com/netdata/netdata/issues/13173))
- Fix(freebsd.plugin): fix wired/cached/avail memory calculation on FreeBSD with ZFS ([#13183](https://github.com/netdata/netdata/issues/13183))
- Update dashboard to version v2.26.5. ([#13192](https://github.com/netdata/netdata/issues/13192))
- Query Engine multi-granularity support (and MC improvements) ([#13155](https://github.com/netdata/netdata/issues/13155))
- Add type label for network interfaces ([#13187](https://github.com/netdata/netdata/issues/13187))
- Feat(python.d/smartd_log): add 2nd job that tries to read from '/var/lib/smartmontools/' ([#13188](https://github.com/netdata/netdata/issues/13188))
- Fix cgroups netdev chart labels ([#13200](https://github.com/netdata/netdata/issues/13200))
- Allow for an easy way to do metadata migrations ([#13196](https://github.com/netdata/netdata/issues/13196))
- Clean sqlite prepared statements on thread shutdown ([#13193](https://github.com/netdata/netdata/issues/13193))
- Add configuration for dbengine page fetch timeout and retry count ([#13194](https://github.com/netdata/netdata/issues/13194))
- Print INTERNAL BUG messages only when NETDATA_INTERNAL_CHECKS is enabled ([#13207](https://github.com/netdata/netdata/issues/13207))
- Chore(netdata-installer): remove a call to 'cleanup_old_netdata_updater()' because it is no longer exists ([#13189](https://github.com/netdata/netdata/issues/13189))
- Add user plugin dirs to environment ([#13203](https://github.com/netdata/netdata/issues/13203))
- Make configuration example clearer ([#13182](https://github.com/netdata/netdata/issues/13182))
- Deduplicate mountinfo based on mount point ([#13215](https://github.com/netdata/netdata/issues/13215))
- Use new mqtt implementation as default ([#13132](https://github.com/netdata/netdata/issues/13132))
- Fix(updater): fix updating when using `--force-update` and new version of the updater script is available ([#13104](https://github.com/netdata/netdata/issues/13104))
- Ensure tmpdir is set for every function that uses it. ([#13206](https://github.com/netdata/netdata/issues/13206))
- Don’t use realpath to find kickstart source path. ([#13208](https://github.com/netdata/netdata/issues/13208))
- Properly handle interactivity in the updater code. ([#13209](https://github.com/netdata/netdata/issues/13209))
- Removes Legacy JSON Cloud Protocol Support In Agent ([#13111](https://github.com/netdata/netdata/issues/13111))
- Ci: add issues to the Agent Board project workflow ([#13225](https://github.com/netdata/netdata/issues/13225))
- Fix(cgroups.plugin): fix qemu VMs and LXC containers name resolution ([#13220](https://github.com/netdata/netdata/issues/13220))
- Feat(python.d): load modules from user plugin directories (NETDATA_USER_PLUGINS_DIRS) ([#13214](https://github.com/netdata/netdata/issues/13214))
- Add more sqlite unittests ([#13227](https://github.com/netdata/netdata/issues/13227))
- Bump repoconfig package version used in kickstart.sh ([#13235](https://github.com/netdata/netdata/issues/13235))
- Update netdata commands ([#13080](https://github.com/netdata/netdata/issues/13080))
- Use correct PAT for add-to-project workflow. ([#13234](https://github.com/netdata/netdata/issues/13234))
- Implement PackageCloud cleanup ([#13236](https://github.com/netdata/netdata/issues/13236))
- Upload packages to new self-hosted repository infrastructure. ([#13240](https://github.com/netdata/netdata/issues/13240))
- Netdata doubles ([#13217](https://github.com/netdata/netdata/issues/13217))
- Dictionaries with reference counters and full deletion support during traversal ([#13195](https://github.com/netdata/netdata/issues/13195))
- Delay health until obsoletions check is complete ([#13239](https://github.com/netdata/netdata/issues/13239))
- Updates the sqlite version in the agent ([#13233](https://github.com/netdata/netdata/issues/13233))
- Fix build matrix generation for build workflow. ([#13254](https://github.com/netdata/netdata/issues/13254))
- Fix: fix a base64_encode bug ([#13074](https://github.com/netdata/netdata/issues/13074))
- Use old mqtt implementation as default ([#13258](https://github.com/netdata/netdata/issues/13258))
- Add fstype labels to disk charts ([#13245](https://github.com/netdata/netdata/issues/13245))
- Query engine with natural and virtual points ([#13248](https://github.com/netdata/netdata/issues/13248))
- Get rid of extra semicolon in Graphite exporting ([#13261](https://github.com/netdata/netdata/issues/13261))
- Remove warnings while compiling ML on FreeBSD ([#13255](https://github.com/netdata/netdata/issues/13255))
- Ebpf issues ([#13259](https://github.com/netdata/netdata/issues/13259))
- Chore(python.d): remove deprecated modules from python.d.conf ([#13264](https://github.com/netdata/netdata/issues/13264))
- Fix issues with DEB postinstall script. ([#13252](https://github.com/netdata/netdata/issues/13252))
- Remove warnings when openssl 3 is used. ([#13170](https://github.com/netdata/netdata/issues/13170))
- Fix RAM calculation on macOS in system-info ([#13260](https://github.com/netdata/netdata/issues/13260))
- Fix package build filtering on PRs. ([#13267](https://github.com/netdata/netdata/issues/13267))
- Update documentation about our REST API documentation. ([#13269](https://github.com/netdata/netdata/issues/13269))
- Assorted cleanups for new package infrastructure upload support. ([#13270](https://github.com/netdata/netdata/issues/13270))
- Remove obsolete --use-system-lws option from netdata-installer.sh help ([#13272](https://github.com/netdata/netdata/issues/13272))
- Add new `test` key to distros.yml entries. ([#13241](https://github.com/netdata/netdata/issues/13241))
- Remove official support for Debian 9. ([#13065](https://github.com/netdata/netdata/issues/13065))
- Fix alignment in charts endpoint ([#13275](https://github.com/netdata/netdata/issues/13275))
- Dont print io errors for cgroups ([#13274](https://github.com/netdata/netdata/issues/13274))
- Rename the chart of real memory usage in FreeBSD ([#13271](https://github.com/netdata/netdata/issues/13271))
- Pluginsd doc ([#13273](https://github.com/netdata/netdata/issues/13273))
- Fixes vbi parser in mqtt5 implementation ([#13277](https://github.com/netdata/netdata/issues/13277))
- Bump go.d.plugin version to v0.33.0 ([#13280](https://github.com/netdata/netdata/issues/13280))
- Query engine fixes for alarms and dashboards ([#13282](https://github.com/netdata/netdata/issues/13282))
- Don’t pull in GCC for build if Clang is already present. ([#13244](https://github.com/netdata/netdata/issues/13244))
- Improve anomaly detection guide ([#13238](https://github.com/netdata/netdata/issues/13238))
- Rpm group creation ([#13197](https://github.com/netdata/netdata/issues/13197))
- Migrate data when machine GUID changes ([#13232](https://github.com/netdata/netdata/issues/13232))
- Fix(health): fix incorrect Redis dimension names ([#13296](https://github.com/netdata/netdata/issues/13296))
- Chore: remove python-mysql from install-required-packages.sh ([#13288](https://github.com/netdata/netdata/issues/13288))
- Null terminate string if file read was not successful ([#13299](https://github.com/netdata/netdata/issues/13299))
- Fix(cgroups.plugin): adjust kubepods regex to fix name resolution in a kind cluster ([#13302](https://github.com/netdata/netdata/issues/13302))
- Bump actions/add-to-project from 0.0.5 to 0.1.0 ([#13295](https://github.com/netdata/netdata/issues/13295))
- Keep rc before freeing it during labels unlink alarms ([#13305](https://github.com/netdata/netdata/issues/13305))
- Fix(health): disable go.d last collected alarm for prometheus module ([#13309](https://github.com/netdata/netdata/issues/13309))
- Remove strftime from statements and use unixepoch instead ([#13250](https://github.com/netdata/netdata/issues/13250))
- Use new MQTT as default ([#13258](https://github.com/netdata/netdata/issues/13258))" ([#13287](https://github.com/netdata/netdata/issues/13287))
- Multi-Tier database backend for long term metrics storage ([#13263](https://github.com/netdata/netdata/issues/13263))
- Explicitly skip uploads and notifications in third-party repositories. ([#13308](https://github.com/netdata/netdata/issues/13308))
- Fix(apps.plugin): adjust `zmstat*` pattern to exclude zoneminder scripts ([#13314](https://github.com/netdata/netdata/issues/13314))
- Add link to docker config section ([#13323](https://github.com/netdata/netdata/issues/13323))
- Add hostname in the worker structure to avoid constant lookups ([#13199](https://github.com/netdata/netdata/issues/13199))
- Fix two helgrind reports ([#13325](https://github.com/netdata/netdata/issues/13325))
- Cid 379238 379238 ([#13328](https://github.com/netdata/netdata/issues/13328))
- Fix(cgroups.plugin): adjust kubepods patterns to filter pods when using Kind cluster ([#13324](https://github.com/netdata/netdata/issues/13324))
- Protect shared variables with log lock. ([#13306](https://github.com/netdata/netdata/issues/13306))
- UpdateNodeCollectors message ([#13330](https://github.com/netdata/netdata/issues/13330))
- Silence compile warnings on external source ([#13332](https://github.com/netdata/netdata/issues/13332))
- Array allocator for dbengine page descriptors ([#13312](https://github.com/netdata/netdata/issues/13312))
- Fix coverity 379241 ([#13336](https://github.com/netdata/netdata/issues/13336))
- Better ACLK debug communication log ([#13281](https://github.com/netdata/netdata/issues/13281))
- Add github stars badge to readme ([#13338](https://github.com/netdata/netdata/issues/13338))
- Fix crash on start on slow disks because ml is initialized before dbengine starts ([#13342](https://github.com/netdata/netdata/issues/13342))
- Fix 32bit calculation on array allocator ([#13343](https://github.com/netdata/netdata/issues/13343))
- Fix(packaging): respect CFLAGS arg when building Docker image ([#13340](https://github.com/netdata/netdata/issues/13340))
- Send node info message sooner ([#13348](https://github.com/netdata/netdata/issues/13348))
- Get rid of extra comma in OpenTSDB exporting ([#13355](https://github.com/netdata/netdata/issues/13355))
- Exporting/send variables ([#13221](https://github.com/netdata/netdata/issues/13221))
- Move host tags to netdata_info ([#13358](https://github.com/netdata/netdata/issues/13358))
- Detect stored metric size by page type  ([#13334](https://github.com/netdata/netdata/issues/13334))
- Added another way to get ansible plays ([#13349](https://github.com/netdata/netdata/issues/13349))
- Chore(python.d): improve config file parsing error message ([#13363](https://github.com/netdata/netdata/issues/13363))
- Add job to move bugs to project board ([#13350](https://github.com/netdata/netdata/issues/13350))
- Address Coverity issues ([#13364](https://github.com/netdata/netdata/issues/13364))
- Actually allow running a test release in a fork of the repo. ([#13331](https://github.com/netdata/netdata/issues/13331))
- Also run repoconfig package builds when distro list is changed. ([#13276](https://github.com/netdata/netdata/issues/13276))
- Query engine: omit first point if not needed ([#13345](https://github.com/netdata/netdata/issues/13345))
- Add document explaining how to proxy Netdata via H2O ([#13266](https://github.com/netdata/netdata/issues/13266))
- Bump go.d.plugin version to v0.33.1 ([#13369](https://github.com/netdata/netdata/issues/13369))
- Chore(dashboard): update chrony dashboard info ([#13371](https://github.com/netdata/netdata/issues/13371))
- Chore(python.d): remove python.d/* announced in v1.35.0 deprecation notice ([#13370](https://github.com/netdata/netdata/issues/13370))
- Guide for troubleshooting Agent with Cloud connection for new nodes ([#13322](https://github.com/netdata/netdata/issues/13322))
- Add additional Docker image build with debug info included. ([#13359](https://github.com/netdata/netdata/issues/13359))
- Add Oracle Linux 9 to officially supported platforms. ([#13367](https://github.com/netdata/netdata/issues/13367))
- Fix missing openSUSE 15.4 in platform support list. ([#13373](https://github.com/netdata/netdata/issues/13373))
- Fix bitmap unit tests ([#13374](https://github.com/netdata/netdata/issues/13374))
- Add basic runtime checks to static build process. ([#13339](https://github.com/netdata/netdata/issues/13339))
- Update docs on metric storage ([#13327](https://github.com/netdata/netdata/issues/13327))
- Docs housekeeping ([#13179](https://github.com/netdata/netdata/issues/13179))
- Chore(python.d): clarify haproxy module readme ([#13388](https://github.com/netdata/netdata/issues/13388))
- Fix netdata-updater.sh sha256sum on BSDs ([#13391](https://github.com/netdata/netdata/issues/13391))
- Fix chart update ebpf.plugin ([#13351](https://github.com/netdata/netdata/issues/13351))
- Fix coverity issue 379240 (Unchecked return value) ([#13401](https://github.com/netdata/netdata/issues/13401))
- Chore(health): remove py web_log alarms ([#13404](https://github.com/netdata/netdata/issues/13404))
- Store host system information in the database ([#13402](https://github.com/netdata/netdata/issues/13402))
- Minor fixes on metadata fields ([#13406](https://github.com/netdata/netdata/issues/13406))
- Report version in build workflow output.
- Codacy/lgtm ignore judy sources ([#13411](https://github.com/netdata/netdata/issues/13411))
- Add missing comma (handle coverity warning CID 379360) ([#13413](https://github.com/netdata/netdata/issues/13413))
- Add ML bullet point to features section on README ([#13418](https://github.com/netdata/netdata/issues/13418))
- Add discord, youtube, linkedin links to README ([#13419](https://github.com/netdata/netdata/issues/13419))
- Remove octopus from demo-sites ([#13423](https://github.com/netdata/netdata/issues/13423))
- Include Judy into our source tree ([#13362](https://github.com/netdata/netdata/issues/13362))
- Rrdcontext ([#13335](https://github.com/netdata/netdata/issues/13335))
- Skip repo-specific CI on forks. ([#13410](https://github.com/netdata/netdata/issues/13410))
- Remove Ubuntu 21.10 from CI and package builds. ([#12918](https://github.com/netdata/netdata/issues/12918))
- Bump actions/add-to-project from 0.1.0 to 0.3.0 ([#13429](https://github.com/netdata/netdata/issues/13429))
- Set value to SN_EMPTY_SLOT if flags is SN_EMPTY_SLOT ([#13417](https://github.com/netdata/netdata/issues/13417))
- Tiering statistics API endpoint ([#13420](https://github.com/netdata/netdata/issues/13420))
- Dont duplicate buffered bytes ([#13435](https://github.com/netdata/netdata/issues/13435))
- Fix boolean value for ProtectControlGroups ([#11281](https://github.com/netdata/netdata/issues/11281))
- Fix agent crash when archived host has not been registered to the cloud ([#13437](https://github.com/netdata/netdata/issues/13437))
- Fix typo in PostgreSQL section header ([#13440](https://github.com/netdata/netdata/issues/13440))
- Delete aclk_alert table on start streaming from seq 1 batch 1 ([#13438](https://github.com/netdata/netdata/issues/13438))
- Query queue only for queries ([#13431](https://github.com/netdata/netdata/issues/13431))
- Additional stats ([#13445](https://github.com/netdata/netdata/issues/13445))
- Get last_entry_t only when st changes ([#13448](https://github.com/netdata/netdata/issues/13448))
- Store host label information in the metadata database ([#13441](https://github.com/netdata/netdata/issues/13441))
- Revert "Query queue only for queries" ([#13452](https://github.com/netdata/netdata/issues/13452))
- Remove Igor and Marius as codeowners. ([#13456](https://github.com/netdata/netdata/issues/13456))
- Fix a guide so we can reference it's subsections ([#13455](https://github.com/netdata/netdata/issues/13455))
- Fix(python.d/smartd_log): handle log rotation ([#13460](https://github.com/netdata/netdata/issues/13460))
- Docs: add a note about network interface monitoring when running in a Docker container ([#13458](https://github.com/netdata/netdata/issues/13458))
- Show last 15 alerts in notification ([#13434](https://github.com/netdata/netdata/issues/13434))
- Rrdcontext support for hidden charts ([#13466](https://github.com/netdata/netdata/issues/13466))
- Fix cgroup name detection for docker containers in containerd cgroup ([#13470](https://github.com/netdata/netdata/issues/13470))
- /api/v1/weights endpoint ([#13449](https://github.com/netdata/netdata/issues/13449))
- Load host labels for archived hosts ([#13464](https://github.com/netdata/netdata/issues/13464))
- Remove the single threaded arrayallocator optiomization during agent startup ([#13473](https://github.com/netdata/netdata/issues/13473))
- Handle cases where entries where stored as text (with strftime("%s")) ([#13472](https://github.com/netdata/netdata/issues/13472))
- Fix tests so that the actual metadata database is not accessed ([#13439](https://github.com/netdata/netdata/issues/13439))
- Enable rrdcontexts by default ([#13471](https://github.com/netdata/netdata/issues/13471))
- Update postgres dashboard info ([#13474](https://github.com/netdata/netdata/issues/13474))
- Feat(cgroups.plugin): resolve nomad containers name (docker driver only) ([#13481](https://github.com/netdata/netdata/issues/13481))
- Send chart context with alert events to the cloud ([#13409](https://github.com/netdata/netdata/issues/13409))
- Chore: add WireGuard description and icon to dashboard info ([#13483](https://github.com/netdata/netdata/issues/13483))
- Bump go.d.plugin version to v0.34.0 ([#13484](https://github.com/netdata/netdata/issues/13484))
- Health: disable go python last collected alarms ([#13485](https://github.com/netdata/netdata/issues/13485))
- Check for protected when excluding mounts ([#13479](https://github.com/netdata/netdata/issues/13479))
- Docs: add a note about edit-config for docker installs ([#13487](https://github.com/netdata/netdata/issues/13487))
- Trimmed-median, trimmed-mean and percentile ([#13469](https://github.com/netdata/netdata/issues/13469))
- Docs: fix unresolved file references ([#13488](https://github.com/netdata/netdata/issues/13488))
- Remove SIGSEGV and SIGABRT (ebpf.plugin) ([#13407](https://github.com/netdata/netdata/issues/13407))
- Remove prompt to add dashboard issues ([#13490](https://github.com/netdata/netdata/issues/13490))
- Add chart_context to alert snapshots ([#13492](https://github.com/netdata/netdata/issues/13492))
- Bump go.d version to v0.35.0 ([#13494](https://github.com/netdata/netdata/issues/13494))
- Add PgBouncer charts description and icon to dashboard info ([#13493](https://github.com/netdata/netdata/issues/13493))
- Docs: change postgres links to go version ([#13496](https://github.com/netdata/netdata/issues/13496))
- Docs: add deprecation notice to python.d/postgres readme ([#13497](https://github.com/netdata/netdata/issues/13497))
- Rrdcontexts allow not linked dimensions and charts ([#13501](https://github.com/netdata/netdata/issues/13501))
- Explicitly fetch git ref in build workflow. ([#13508](https://github.com/netdata/netdata/issues/13508))
- Fix fix for versioning issues.

## [1.35.0] - 2022-06-08

### Merged Pull Requests:

- Adjust ACLK label ([#12689](https://github.com/netdata/netdata/issues/12689))
- Fix branch handling for minor releases in release workflow. ([#12690](https://github.com/netdata/netdata/issues/12690))
- Ensure versioned release tags include a leading `v` in workflows. ([#12695](https://github.com/netdata/netdata/issues/12695))
- Fix typo in release handling script.
- Fix branch handling for patch releases.
- Annotate release tags.
- Fix retry code in build CI. ([#12691](https://github.com/netdata/netdata/issues/12691))
- Fix_inbound:Add missing values to algorithm vector ([#12698](https://github.com/netdata/netdata/issues/12698))
- Disable automake dependency tracking in our various one-time builds. ([#12701](https://github.com/netdata/netdata/issues/12701))
- Fix Valgrind errors ([#12619](https://github.com/netdata/netdata/issues/12619))
- Feat(apps.plugin): add proxmox-ve processes to apps_groups.conf ([#12704](https://github.com/netdata/netdata/issues/12704))
- Chore(ebpf.plugin): re-enable socket module by default ([#12702](https://github.com/netdata/netdata/issues/12702))
- Fix: use NETDATA_LISTENER_PORT in docker healtcheck ([#12676](https://github.com/netdata/netdata/issues/12676))
- Add the ability to perform a data query using an offline node id ([#12650](https://github.com/netdata/netdata/issues/12650))
- Allocate buffer memory for uv_write and release in the callback function ([#12688](https://github.com/netdata/netdata/issues/12688))
- Chore(cgroups.plugin): reduce the CPU time required for cgroup-network-helper.sh ([#12711](https://github.com/netdata/netdata/issues/12711))
- Fix disable-dependency-tracking typo ([#12714](https://github.com/netdata/netdata/issues/12714))
- Fix upgrading all currently installed packages when updating Netdata on Debian
- Gotify notifications ([#12639](https://github.com/netdata/netdata/issues/12639))
- Feat(apps.plugin): add caddy to apps_groups.conf ([#12678](https://github.com/netdata/netdata/issues/12678))
- [Uninstall Netdata] - Add description in the docs to use uninstaller script with force arg ([#12687](https://github.com/netdata/netdata/issues/12687))
- Add a 2 minute timeout to stream receiver socket ([#12673](https://github.com/netdata/netdata/issues/12673))
- Small typo change in macOS docs ([#12724](https://github.com/netdata/netdata/issues/12724))
- Docs: fix GitHub format ([#12682](https://github.com/netdata/netdata/issues/12682))
- Store alert log entries even if alert is repeating. ([#12226](https://github.com/netdata/netdata/issues/12226))
- Remove commented code. ([#12726](https://github.com/netdata/netdata/issues/12726))
- Docs templates ([#12466](https://github.com/netdata/netdata/issues/12466))
- Add new dashboard/web server reference file ([#11161](https://github.com/netdata/netdata/issues/11161))
- Chore(kickstart.sh): remove unused `--auto-update` option when using static/build install method ([#12725](https://github.com/netdata/netdata/issues/12725))
- Feat(cgroups.plugin): add k8s_qos_class label ([#12737](https://github.com/netdata/netdata/issues/12737))
- Chore: remove Codacy badge from the repo readme ([#12742](https://github.com/netdata/netdata/issues/12742))
- Mention serial numbers in chart names in the plugins.d API documentation ([#12733](https://github.com/netdata/netdata/issues/12733))
- Fix(cgroups.plugin): run renaming script only for containers in k8s ([#12747](https://github.com/netdata/netdata/issues/12747))
- Feat(cgroups.plugin): add "CPU Time Relative Share" chart ([#12741](https://github.com/netdata/netdata/issues/12741))
- Fix(cgroups.plugin): remove "search for cgroups under PATH" conf option to fix memory leak ([#12752](https://github.com/netdata/netdata/issues/12752))
- Fix(cgroups.plugin): remove "enable cgroup X" config option on cgroup deletion ([#12746](https://github.com/netdata/netdata/issues/12746))
- Tag Gotify health notifications for the Gotify phone app ([#12753](https://github.com/netdata/netdata/issues/12753))
- Chore(ci): add the root dir markdown files to area/docs ([#12749](https://github.com/netdata/netdata/issues/12749))
- Chore: remove kickoke from codeowners ([#12743](https://github.com/netdata/netdata/issues/12743))
- Fix implicit declaration of function 'appconfig_section_option_destroy_non_loaded' ([#12756](https://github.com/netdata/netdata/issues/12756))
- Chore: reduce logging in rrdset ([#12739](https://github.com/netdata/netdata/issues/12739))
- Memory CO-RE ([#12684](https://github.com/netdata/netdata/issues/12684))
- Chore(cgroup.plugin): remove undocumented feature reading cgroups-names.sh when renaming cgroups ([#12745](https://github.com/netdata/netdata/issues/12745))
- Fix: use 'diskutil info` to calculate the disk size on macOS ([#12764](https://github.com/netdata/netdata/issues/12764))
- Add options to kickstart.sh for explicitly passing options to installer code. ([#12658](https://github.com/netdata/netdata/issues/12658))
- Correctly propagate errors and warnings up to the kickstart script from scripts it calls. ([#12686](https://github.com/netdata/netdata/issues/12686))
- Treat auto-updates as a tristate internally. ([#12634](https://github.com/netdata/netdata/issues/12634))
- Expand on the various parent-child config options ([#12734](https://github.com/netdata/netdata/issues/12734))
- Feat(dbengine): make dbengine page cache undumpable and dedupuble ([#12765](https://github.com/netdata/netdata/issues/12765))
- Use aclk_parse_otp_error ([#12767](https://github.com/netdata/netdata/issues/12767))
- Check the return of setsockopt ([#12772](https://github.com/netdata/netdata/issues/12772))
- Fix checking of enviornment files. ([#12768](https://github.com/netdata/netdata/issues/12768))
- Tweak static build process to improve build speed and debuggability. ([#12708](https://github.com/netdata/netdata/issues/12708))
- Update netdata-installer.sh ([#12755](https://github.com/netdata/netdata/issues/12755))
- Faster execution of external programs ([#12759](https://github.com/netdata/netdata/issues/12759))
- Some config updates for ml ([#12771](https://github.com/netdata/netdata/issues/12771))
- Fix printing warning msg ([#12781](https://github.com/netdata/netdata/issues/12781))
- Use '%b' argument when printing deferred errors ([#12786](https://github.com/netdata/netdata/issues/12786))
- Fix(proc/net/dev): exclude Proxmox bridge interfaces ([#12789](https://github.com/netdata/netdata/issues/12789))
- Don't use MADV_DONTDUMP on non-linux builds ([#12795](https://github.com/netdata/netdata/issues/12795))
- Chore(deps): bump google-github-actions/upload-cloud-storage ([#12794](https://github.com/netdata/netdata/issues/12794))
- Just a simple fix to avoid recompiling protobuf all the time ([#12790](https://github.com/netdata/netdata/issues/12790))
- Procfile: more comfortable initial settings and faster/fewer reallocs ([#12791](https://github.com/netdata/netdata/issues/12791))
- Add `-pipe` to CFLAGS in most cases for builds. ([#12709](https://github.com/netdata/netdata/issues/12709))
- Fix(cgroups.plugin): do not add network devices if cgroup proc is in the host net ns ([#12788](https://github.com/netdata/netdata/issues/12788))
- Make atomics a hard-dep. ([#12730](https://github.com/netdata/netdata/issues/12730))
- Avoid clearing already unset flags. ([#12727](https://github.com/netdata/netdata/issues/12727))
- Chore(python.d): remove python.d/* announced in v1.34.0 deprecation notice ([#12796](https://github.com/netdata/netdata/issues/12796))
- Reduce alert events sent to the cloud. ([#12544](https://github.com/netdata/netdata/issues/12544))
- Speed up BUFFER increases (minimize reallocs) ([#12792](https://github.com/netdata/netdata/issues/12792))
- One way allocator to double the speed of parallel context queries ([#12787](https://github.com/netdata/netdata/issues/12787))
- Trace rwlocks of netdata ([#12785](https://github.com/netdata/netdata/issues/12785))
- Remove node.d.plugin and relevant files ([#12769](https://github.com/netdata/netdata/issues/12769))
- Check for chart obsoletion on children re-connections ([#12707](https://github.com/netdata/netdata/issues/12707))
- Rename --install option for kickstart.sh ([#12798](https://github.com/netdata/netdata/issues/12798))
- Configurable storage engine for Netdata agents: step 1 ([#12776](https://github.com/netdata/netdata/issues/12776))
- Feat(cgroups.plugin): add filtering by cgroups names and improve renaming in k8s ([#12778](https://github.com/netdata/netdata/issues/12778))
- Skip dimension deletion on free (temp fix) ([#12777](https://github.com/netdata/netdata/issues/12777))
- Improve handling of release channel selection in kickstart.sh. ([#12635](https://github.com/netdata/netdata/issues/12635))
- Remove per chart configuration. ([#12728](https://github.com/netdata/netdata/issues/12728))
- Update ml defaults in docs ([#12782](https://github.com/netdata/netdata/issues/12782))
- Onewayallocator to use mallocz() instead of mmap() ([#12810](https://github.com/netdata/netdata/issues/12810))
- Improve agent cloud chart synchronization ([#12655](https://github.com/netdata/netdata/issues/12655))
- Add --repositories-only flag ([#12806](https://github.com/netdata/netdata/issues/12806))
- Fix!: do not replace a hyphen in the chart name with an underscore ([#12812](https://github.com/netdata/netdata/issues/12812))
- Metric correlations ([#12582](https://github.com/netdata/netdata/issues/12582))
- * Add a parameter for the libuv worker threads to pre-initialize ([#12814](https://github.com/netdata/netdata/issues/12814))
- Write the entire request with parameters in the access.log file ([#12815](https://github.com/netdata/netdata/issues/12815))
- Broadcast completion before unlocking condition variable's mutex ([#12822](https://github.com/netdata/netdata/issues/12822))
- Optimize linking of foreach alarms to dimensions. ([#12813](https://github.com/netdata/netdata/issues/12813))
- Accept a data query timeout parameter from the cloud ([#12823](https://github.com/netdata/netdata/issues/12823))
- Fill missing removed events after a crash ([#12803](https://github.com/netdata/netdata/issues/12803))
- Improve storage number unpacking by using a lookup table. ([#11048](https://github.com/netdata/netdata/issues/11048))
- Cleanup node instance ([#12825](https://github.com/netdata/netdata/issues/12825))
- Add --install-version flag for installing specific version of Netdata ([#12729](https://github.com/netdata/netdata/issues/12729))
- Fix netdata-uninstaller.sh ([#12828](https://github.com/netdata/netdata/issues/12828))
- Add chart filtering parameter to the allmetrics API query ([#12820](https://github.com/netdata/netdata/issues/12820))
- Reduce the number of messages logged to one that sums up the numbr of metrics ignored ([#12829](https://github.com/netdata/netdata/issues/12829))
- Feat(plugins.d): allow external plugins to create chart labels ([#12834](https://github.com/netdata/netdata/issues/12834))
- Remove sync warning ([#12831](https://github.com/netdata/netdata/issues/12831))
- Make 'send charts matching' behave the same as 'filter' ([#12832](https://github.com/netdata/netdata/issues/12832))
- Set a page wait timeout to 1 second ([#12836](https://github.com/netdata/netdata/issues/12836))
- Speedup queries by providing optimization in the main loop ([#12811](https://github.com/netdata/netdata/issues/12811))
- Save built packages in CI before testing them. ([#12842](https://github.com/netdata/netdata/issues/12842))
- Fix memory leaks and mismatches of the use of the z functions for allocations ([#12841](https://github.com/netdata/netdata/issues/12841))
- Resolve coverity issues ([#12846](https://github.com/netdata/netdata/issues/12846))
- Workers utilization charts ([#12807](https://github.com/netdata/netdata/issues/12807))
- Dim rates ([#12833](https://github.com/netdata/netdata/issues/12833))
- Add a database checkpoint command ([#12859](https://github.com/netdata/netdata/issues/12859))
- Feat(cgroups.plugin): add k8s cluster name label (GKE only) ([#12858](https://github.com/netdata/netdata/issues/12858))
- Bump go.d.plugin version to v0.32.3 ([#12862](https://github.com/netdata/netdata/issues/12862))
- Fix(proc.plugin): consider ZFS ARC as cache when collecting memory usage on Linux ([#12847](https://github.com/netdata/netdata/issues/12847))
- Initialize the metadata database when performing dbengine stress test ([#12861](https://github.com/netdata/netdata/issues/12861))
- Use prebuilt builder images for static builds. ([#12826](https://github.com/netdata/netdata/issues/12826))
- Fix(cgroups.plugin): do not disable K8s pod/container cgroups if can't rename them ([#12865](https://github.com/netdata/netdata/issues/12865))
- Workers fixes and improvements ([#12863](https://github.com/netdata/netdata/issues/12863))
- Fix for negative per job busy time ([#12867](https://github.com/netdata/netdata/issues/12867))
- Update README.md ([#12868](https://github.com/netdata/netdata/issues/12868))
- Docs: fix unresolved file references ([#12872](https://github.com/netdata/netdata/issues/12872))
- Switch to Alma Linux for RHEL compatible support. ([#12799](https://github.com/netdata/netdata/issues/12799))
- Set trust durations to have data from children properly aligned ([#12870](https://github.com/netdata/netdata/issues/12870))
- Fix(health): change duplicate health template message logging level to 'info' ([#12873](https://github.com/netdata/netdata/issues/12873))
- Configurable storage engine for Netdata agents: step 2 ([#12808](https://github.com/netdata/netdata/issues/12808))
- Expose anomaly-bit option to health. ([#12835](https://github.com/netdata/netdata/issues/12835))
- Consider ZFS ARC shrinkable as cache on FreeBSD ([#12879](https://github.com/netdata/netdata/issues/12879))
- Update dashboard to version v2.25.2. ([#12884](https://github.com/netdata/netdata/issues/12884))
- Feat(proc/cgroups.plugin): add PSI stall time charts ([#12869](https://github.com/netdata/netdata/issues/12869))
- Fix compilation warnings ([#12886](https://github.com/netdata/netdata/issues/12886))
- Chore(deps): bump docker/setup-buildx-action from 1 to 2 ([#12848](https://github.com/netdata/netdata/issues/12848))
- Chore(deps): bump docker/setup-qemu-action from 1 to 2 ([#12849](https://github.com/netdata/netdata/issues/12849))
- Chore(deps): bump docker/login-action from 1 to 2 ([#12850](https://github.com/netdata/netdata/issues/12850))
- Chore(deps): bump docker/build-push-action from 2 to 3 ([#12851](https://github.com/netdata/netdata/issues/12851))
- Pause alert pushes to the cloud ([#12852](https://github.com/netdata/netdata/issues/12852))
- Take into account the in queue wait time when executing a data query ([#12885](https://github.com/netdata/netdata/issues/12885))
- Return stable or nightly based on version if the file check fails ([#12894](https://github.com/netdata/netdata/issues/12894))
- Implements new capability fields in aclk_schemas ([#12602](https://github.com/netdata/netdata/issues/12602))
- Remove CPU-specific info from cpuidle dimensions ([#12898](https://github.com/netdata/netdata/issues/12898))
- Update reconnect node with kickstart info ([#12891](https://github.com/netdata/netdata/issues/12891))
- Fix(cgroups.plugin): use correct identifier when registering the main thread "chart" worker job ([#12902](https://github.com/netdata/netdata/issues/12902))
- Chore(worker_utilization): log an error when re-registering an already registered job ([#12903](https://github.com/netdata/netdata/issues/12903))
- Fix release channel in the node info message ([#12905](https://github.com/netdata/netdata/issues/12905))
- Fix compilation warnings in FreeBSD ([#12887](https://github.com/netdata/netdata/issues/12887))
- Added worker jobs for cgroup-rename, cgroup-network and cgroup-first-time ([#12910](https://github.com/netdata/netdata/issues/12910))
- Chore(streaming): bump default "buffer size bytes" to 10MB ([#12913](https://github.com/netdata/netdata/issues/12913))
- Fix(cgroups.plugin): improve check for uninitialized containers in k8s ([#12912](https://github.com/netdata/netdata/issues/12912))
- Fix `[global statistics]` section in netdata.conf ([#12916](https://github.com/netdata/netdata/issues/12916))
- Fix virtualization detection when `systemd-detect-virt` is not available ([#12911](https://github.com/netdata/netdata/issues/12911))
- Fix the log entry for incoming cloud start streaming commands ([#12908](https://github.com/netdata/netdata/issues/12908))
- User configurable sqlite PRAGMAs ([#12917](https://github.com/netdata/netdata/issues/12917))
- Chore(cgroups.plugin): remove "enable new cgroups detected at run time" config option ([#12906](https://github.com/netdata/netdata/issues/12906))
- Restore a broken symbolic link ([#12923](https://github.com/netdata/netdata/issues/12923))
- Chore(fping.plugin): bump default fping version to 5.1 ([#12930](https://github.com/netdata/netdata/issues/12930))
- Chore: add links to SQLite init options in the src code ([#12920](https://github.com/netdata/netdata/issues/12920))
- Collectors: apps.plugin: apps_groups: update net, aws, ha groups ([#12921](https://github.com/netdata/netdata/issues/12921))
- Adjust alarms count ([#12896](https://github.com/netdata/netdata/issues/12896))
- Remove Alpine 3.12 from CI. ([#12919](https://github.com/netdata/netdata/issues/12919))
- Adjust the dimension liveness status check ([#12933](https://github.com/netdata/netdata/issues/12933))
- Reduce timeout to 1 second for getting cloud instance info ([#12941](https://github.com/netdata/netdata/issues/12941))
- Feat: move dirs, logs, and env vars config options to separate sections ([#12935](https://github.com/netdata/netdata/issues/12935))
- Include proper package dependency ([#12518](https://github.com/netdata/netdata/issues/12518))
- Add support for installing static builds on systems without usable internet connections. ([#12809](https://github.com/netdata/netdata/issues/12809))
- Move kickstart argument parsing code to a function. ([#12805](https://github.com/netdata/netdata/issues/12805))
- Fix and improve netdata-updater.sh script ([#12757](https://github.com/netdata/netdata/issues/12757))
- Autodetect channel for specific version ([#12856](https://github.com/netdata/netdata/issues/12856))
- Prevent command_to_be_logged from overflowing ([#12947](https://github.com/netdata/netdata/issues/12947))
- Update libbpf version ([#12945](https://github.com/netdata/netdata/issues/12945))
- Detailed dbengine stats ([#12948](https://github.com/netdata/netdata/issues/12948))
- Optimize the dimensions option store to the metadata database ([#12952](https://github.com/netdata/netdata/issues/12952))
- Defer the dimension payload check to the ACLK sync thread ([#12951](https://github.com/netdata/netdata/issues/12951))
- Suppress warning when freeing a NULL pointer in onewayalloc_freez ([#12955](https://github.com/netdata/netdata/issues/12955))
- Cleanup chart hash and map tables on startup ([#12956](https://github.com/netdata/netdata/issues/12956))
- Statsd sets should count unique values ([#12963](https://github.com/netdata/netdata/issues/12963))
- Apply some logic to possible streaming destinations ([#12866](https://github.com/netdata/netdata/issues/12866))
- Fix: keep virtualization unknown if all used commands are not available ([#12964](https://github.com/netdata/netdata/issues/12964))
- Cleanup and optimize rrdeng_load_metric_next() ([#12966](https://github.com/netdata/netdata/issues/12966))
- Don't permanetly disable a destination because of denied access ([#12971](https://github.com/netdata/netdata/issues/12971))
- Feat(charts.d/apcupds): add load usage chart (Watts) ([#12965](https://github.com/netdata/netdata/issues/12965))
- Chore: check link local address before querying cloud instance metadata ([#12973](https://github.com/netdata/netdata/issues/12973))
- Optimize poll_events() to spread the work over the threads more evenly ([#12975](https://github.com/netdata/netdata/issues/12975))
- Query engine optimizations and cleanup ([#12978](https://github.com/netdata/netdata/issues/12978))
- Chore(apps.plugin): change cpu_guest chart context ([#12983](https://github.com/netdata/netdata/issues/12983))
- Add automatic retries fo static builds during nightly and release builds. ([#12961](https://github.com/netdata/netdata/issues/12961))
- Fix(kickstart.sh): handle the case when `tput colors` doesn't return a number ([#12979](https://github.com/netdata/netdata/issues/12979))
- Fix: don't kill Netdata PIDs if successfully stopped Netdata ([#12982](https://github.com/netdata/netdata/issues/12982))
- Modify code to resolve compile warning issue ([#12969](https://github.com/netdata/netdata/issues/12969))
- Make heartbeat a static chart ([#12986](https://github.com/netdata/netdata/issues/12986))
- Improve reconnect node instructions ([#12987](https://github.com/netdata/netdata/issues/12987))
- Faster queries ([#12988](https://github.com/netdata/netdata/issues/12988))
- Stream and advertise metric correlations to the cloud ([#12940](https://github.com/netdata/netdata/issues/12940))
- Return rc->last_update from alarms_values api ([#12968](https://github.com/netdata/netdata/issues/12968))
- Fix compilation warnings ([#12993](https://github.com/netdata/netdata/issues/12993))
- Fix nanosleep on platforms other than Linux ([#12991](https://github.com/netdata/netdata/issues/12991))
- Run the /net/dev module of the proc plugin in a separate thread ([#12996](https://github.com/netdata/netdata/issues/12996))
- Update dashboard to version v2.25.4. ([#13000](https://github.com/netdata/netdata/issues/13000))
- Don't expose the chart definition to streaming if there is no metadata change ([#12990](https://github.com/netdata/netdata/issues/12990))
- Add dictionary support to statsd ([#12980](https://github.com/netdata/netdata/issues/12980))
- Delay children chart obsoletion check ([#12992](https://github.com/netdata/netdata/issues/12992))
- Use printf instead of echo for printing collected warnings in kickstart.sh. ([#13002](https://github.com/netdata/netdata/issues/13002))
- Autodetect coverity install path to increase robustness ([#12995](https://github.com/netdata/netdata/issues/12995))
- Alarms py collector add filtering ([#12972](https://github.com/netdata/netdata/issues/12972))
- Add Alpine 3.16 to CI and platform support document. ([#12997](https://github.com/netdata/netdata/issues/12997))
- Fix COVERITY_PATH added with INSTALL_DIR into PATH ([#13014](https://github.com/netdata/netdata/issues/13014))
- Cleanup Challenge Response Code ([#11730](https://github.com/netdata/netdata/issues/11730))
- Pass the child machine's guid to the goto_url link ([#12609](https://github.com/netdata/netdata/issues/12609))
- Only try to update repo metadata in updater script if needed. ([#13009](https://github.com/netdata/netdata/issues/13009))
- Cache invariant components in static builds to reduce build times. ([#12877](https://github.com/netdata/netdata/issues/12877))
- Fix coverity issue 378598 ([#13022](https://github.com/netdata/netdata/issues/13022))
- Initialize a pointer and add a check for it ([#13023](https://github.com/netdata/netdata/issues/13023))
- Prevent gap filling on dbengine gaps ([#13027](https://github.com/netdata/netdata/issues/13027))
- Update dashboard to version v2.25.6. ([#13028](https://github.com/netdata/netdata/issues/13028))
- Add hostname to mirrored hosts ([#13030](https://github.com/netdata/netdata/issues/13030))
- Update apps_groups.conf ([#13033](https://github.com/netdata/netdata/issues/13033))
- Trigger queue removed alerts on health log exchange with cloud ([#12954](https://github.com/netdata/netdata/issues/12954))
- Check return value and log an error on failure ([#13037](https://github.com/netdata/netdata/issues/13037))
- Fix coverity issue 378617,378615 ([#13021](https://github.com/netdata/netdata/issues/13021))
- Skip collecting network interface speed and duplex if carrier is down ([#13019](https://github.com/netdata/netdata/issues/13019))
- When sending a dimension for the first time, make sure there is a non zero created_at timestamp ([#13035](https://github.com/netdata/netdata/issues/13035))
- Treat dimensions as normal when we don't have enough/valid data. ([#13005](https://github.com/netdata/netdata/issues/13005))
- Replace `history` with relevant `dbengine` params ([#13041](https://github.com/netdata/netdata/issues/13041))
- Fix the retry count and netdata_exit check when running an sqlite3_step command ([#13040](https://github.com/netdata/netdata/issues/13040))
- Write pid file (needed by logrotate) ([#9377](https://github.com/netdata/netdata/issues/9377))
- Add additional metadata to the data response ([#13036](https://github.com/netdata/netdata/issues/13036))
- Fix disabled apps (ebpf.plugin) ([#13044](https://github.com/netdata/netdata/issues/13044))
- Add note about anomaly advisor ([#13042](https://github.com/netdata/netdata/issues/13042))
- Schedule retention message calculation to a worker thread ([#13039](https://github.com/netdata/netdata/issues/13039))
- Dictionary with JudyHS and double linked list ([#13032](https://github.com/netdata/netdata/issues/13032))
- Coverity fixes about statsd; removal of strsame ([#13049](https://github.com/netdata/netdata/issues/13049))
- Fix dictionary crash walkthrough empty ([#13051](https://github.com/netdata/netdata/issues/13051))
- Dictionary improvements ([#13052](https://github.com/netdata/netdata/issues/13052))
- Check for host labels when linking alerts for children ([#13053](https://github.com/netdata/netdata/issues/13053))
- Fix coverity 378625 ([#13055](https://github.com/netdata/netdata/issues/13055))
- Add the ability to merge dictionary items ([#13054](https://github.com/netdata/netdata/issues/13054))
- Fix(cgroup.plugin): read k8s_cluster_name label from the correct file ([#13062](https://github.com/netdata/netdata/issues/13062))
- Initialize chart label key parameter correctly ([#13061](https://github.com/netdata/netdata/issues/13061))
- Update codeowners ([#13060](https://github.com/netdata/netdata/issues/13060))
- Fix handling of temp directory in kickstart when uninstalling. ([#13056](https://github.com/netdata/netdata/issues/13056))
- Fix locking access to chart labels ([#13064](https://github.com/netdata/netdata/issues/13064))
- Allow usage of the new MQTT 5 implementation ([#12838](https://github.com/netdata/netdata/issues/12838))
- Added Alma Linux 9 and RHEL 9 support to CI and packaging. ([#13058](https://github.com/netdata/netdata/issues/13058))
- Update default value for "host anomaly rate threshold" ([#13075](https://github.com/netdata/netdata/issues/13075))
- Add improved reinstall documentation. ([#13047](https://github.com/netdata/netdata/issues/13047))
- Fix handling of DEB package naming in CI. ([#13076](https://github.com/netdata/netdata/issues/13076))
- Fix(updater): don't produce any output if binpkg update completed successfully ([#13081](https://github.com/netdata/netdata/issues/13081))
- Remove Fedora 34 from CI and package builds. ([#12875](https://github.com/netdata/netdata/issues/12875))
- Fix Coverity errors in mqtt_websockets submodule ([#13082](https://github.com/netdata/netdata/issues/13082))
- Update README.md ([#13088](https://github.com/netdata/netdata/issues/13088))
- Update README.md ([#13089](https://github.com/netdata/netdata/issues/13089))
- Fix(updater): return 0 on successful update for native packages when running interactively ([#13083](https://github.com/netdata/netdata/issues/13083))

## [1.34.0] - 2022-04-14

### Merged Pull Requests:

- Removed reference to latest release
- Rename DO_NOT_TRACK to DISABLE_TELEMETRY ([#12126](https://github.com/netdata/netdata/issues/12126))
- Documentation: Fixed broken links ([#12142](https://github.com/netdata/netdata/issues/12142))
- Fix typo in ZFS ARC Cache size info ([#12138](https://github.com/netdata/netdata/issues/12138))
- Kickstart.sh: fix quoting for globbing ([#12148](https://github.com/netdata/netdata/issues/12148))
- Consolidate build matrix across CI jobs. ([#11807](https://github.com/netdata/netdata/issues/11807))
- Fix: CPU frequency calculation in system-info.sh ([#12162](https://github.com/netdata/netdata/issues/12162))
- Fix so that allow_past correctly works in memory mode ram and save ([#12136](https://github.com/netdata/netdata/issues/12136))
- Fix the format=array output in context queries ([#12129](https://github.com/netdata/netdata/issues/12129))
- Docs: Removed Google Analytics tags ([#12145](https://github.com/netdata/netdata/issues/12145))
- Improve messaging around unknown install handling in kickstart script. ([#12134](https://github.com/netdata/netdata/issues/12134))
- Show the number of processes/threads for empty apps groups ([#11834](https://github.com/netdata/netdata/issues/11834))
- Feat(apps.plugin): group Apple Filing Protocol daemons into `afp` group ([#12078](https://github.com/netdata/netdata/issues/12078))
- Fix alerts to raise correctly when the delay and repeat parameters are used together ([#12164](https://github.com/netdata/netdata/issues/12164))
- Remove check for aclk_ng and prometheus in order to assume protobuf in buildinfo ([#12168](https://github.com/netdata/netdata/issues/12168))
- Tidy up the installer script usage message ([#12171](https://github.com/netdata/netdata/issues/12171))
- Corrected the cloud claiming options ([#12161](https://github.com/netdata/netdata/issues/12161))
- Add `stress-ng` and `gremlin` to apps_groups.conf ([#12165](https://github.com/netdata/netdata/issues/12165))
- Fix: claiming with wget ([#12163](https://github.com/netdata/netdata/issues/12163))
- Restructured cloud installation ([#12143](https://github.com/netdata/netdata/issues/12143))
- Adds install method to /api/v1/info as label ([#12040](https://github.com/netdata/netdata/issues/12040))
- Overhaul handling of auto-updates in the installer code. ([#12076](https://github.com/netdata/netdata/issues/12076))
- Finish pushing handling of kickstart checksums to netdata/learn. ([#12176](https://github.com/netdata/netdata/issues/12176))
- Revert "Overhaul handling of auto-updates in the installer code. ([#12076](https://github.com/netdata/netdata/issues/12076))" ([#12182](https://github.com/netdata/netdata/issues/12182))
- Fix typos ([#12183](https://github.com/netdata/netdata/issues/12183))
- Create a removed alert event if chart is obsolete ([#12021](https://github.com/netdata/netdata/issues/12021))
- Fix(docs): unresolved file references ([#12191](https://github.com/netdata/netdata/issues/12191))
- Fix compilation warnings on macOS ([#12082](https://github.com/netdata/netdata/issues/12082))
- Fix(python.d/nvidia_smi): use uid when can't find the username ([#12184](https://github.com/netdata/netdata/issues/12184))
- Update libs code ([#12190](https://github.com/netdata/netdata/issues/12190))
- Add serial numbers to chart names ([#12067](https://github.com/netdata/netdata/issues/12067))
- Update packaging CI to only run a limited set of jobs on PRs. ([#12156](https://github.com/netdata/netdata/issues/12156))
- Bump google-github-actions/setup-gcloud from 0.5.0 to 0.5.1 ([#12194](https://github.com/netdata/netdata/issues/12194))
- Properly check out the repo when running the packaging workflow on push. ([#12203](https://github.com/netdata/netdata/issues/12203))
- Docs: document the issue with seccomp and claiming ([#12192](https://github.com/netdata/netdata/issues/12192))
- Fix `hpssa` parse error ([#12206](https://github.com/netdata/netdata/issues/12206))
- Remove deprecated node.d modules ([#12047](https://github.com/netdata/netdata/issues/12047))
- Fix two small typos in documentation ([#12208](https://github.com/netdata/netdata/issues/12208))
- Add -W keepopenfds option. ([#12211](https://github.com/netdata/netdata/issues/12211))
- Remove NETDATA_WITH_UUID def because it's not used anywhere. ([#12044](https://github.com/netdata/netdata/issues/12044))
- Remove unused NETDATA_NO_ATOMIC_INSTRUCTIONS macro ([#12045](https://github.com/netdata/netdata/issues/12045))
- Skip info field in protobuf alerts messages if it doesn't exist. ([#12210](https://github.com/netdata/netdata/issues/12210))
- Update AWS SNS README.md ([#11946](https://github.com/netdata/netdata/issues/11946))
- Remove SIZEOF_VOIDP and ENVIRONMENT{32,64} macros. ([#12046](https://github.com/netdata/netdata/issues/12046))
- Bump follow-redirects from 1.14.7 to 1.14.8 ([#12124](https://github.com/netdata/netdata/issues/12124))
- Bump karma from 6.0.2 to 6.3.14 ([#12116](https://github.com/netdata/netdata/issues/12116))
- Update github's code owners configuration. ([#12213](https://github.com/netdata/netdata/issues/12213))
- Remove chart specific configuration from netdata.conf except enabled ([#12209](https://github.com/netdata/netdata/issues/12209))
- Improve cleaning up of orphan hosts ([#12201](https://github.com/netdata/netdata/issues/12201))
- Add `--no-same-owner` to `tar -xf` in installer ([#11940](https://github.com/netdata/netdata/issues/11940))
- Assorted CI cleanup. ([#11777](https://github.com/netdata/netdata/issues/11777))
- Skip training of constant metrics. ([#12212](https://github.com/netdata/netdata/issues/12212))
- Store dimension hidden option in the metadata db ([#12196](https://github.com/netdata/netdata/issues/12196))
- Remove ACLK_NEWARCH_DEVMODE ([#12018](https://github.com/netdata/netdata/issues/12018))
- Minor - remove dead code from ACLK Legacy ([#12230](https://github.com/netdata/netdata/issues/12230))
- Track anomaly rates with DBEngine. ([#12083](https://github.com/netdata/netdata/issues/12083))
- Fix node information send to the cloud for older agent versions ([#12223](https://github.com/netdata/netdata/issues/12223))
- Adds all query types to aclk_processed_query_type ([#12036](https://github.com/netdata/netdata/issues/12036))
- Fix handling of repository name in CI workflows. ([#12234](https://github.com/netdata/netdata/issues/12234))
- Fix builds where HAVE_C___ATOMIC is not defined. ([#12240](https://github.com/netdata/netdata/issues/12240))
- Add a fix to correctly register child nodes to the cloud via a parent ([#12241](https://github.com/netdata/netdata/issues/12241))
- Bundle protobuf on CentOS 7 and earlier. ([#12167](https://github.com/netdata/netdata/issues/12167))
- Add a check to make sure internal chart state is initialized
- Fixed typo in docs/guides/monitor/anomaly-detection-python.md file ([#12220](https://github.com/netdata/netdata/issues/12220))
- EBPF installation fixes ([#12242](https://github.com/netdata/netdata/issues/12242))
- [makeself] Fix license URL ([#12219](https://github.com/netdata/netdata/issues/12219))
- Adds chart for incoming proto msgs in new cloud protocol ([#11969](https://github.com/netdata/netdata/issues/11969))
- Docs: Fix typo in step-10.md ([#12263](https://github.com/netdata/netdata/issues/12263))
- Setting a DB version (to make future schema changes / migration easier) ([#12249](https://github.com/netdata/netdata/issues/12249))
- Netdata.service: unbreak plugins that use sudo ([#10201](https://github.com/netdata/netdata/issues/10201))
- If not separator is found in url, clean decoded_query_string ([#12266](https://github.com/netdata/netdata/issues/12266))
- Fix: correct the spelling of @thiagoftsm in codeowners ([#12267](https://github.com/netdata/netdata/issues/12267))
- Delete package.json ([#12265](https://github.com/netdata/netdata/issues/12265))
- Inform cloud about inability to deliver data payload ([#12041](https://github.com/netdata/netdata/issues/12041))
- Make netdata-uninstaller.sh POSIX compatibility and add --uninstall flag… ([#12195](https://github.com/netdata/netdata/issues/12195))
- Add host labels _aclk_ng_new_cloud_protocol ([#12278](https://github.com/netdata/netdata/issues/12278))
- Use the new error mechanism in case host not found ([#12277](https://github.com/netdata/netdata/issues/12277))
- Timex: make offset rrd independently configurable ([#12281](https://github.com/netdata/netdata/issues/12281))
- Fixed typos in docs/Running-behind-haproxy.md ([#12272](https://github.com/netdata/netdata/issues/12272))
- Feat(health): add charts.d/nut alarms ([#12285](https://github.com/netdata/netdata/issues/12285))
- Add support to the updater to toggle auto-updates on and off. ([#12202](https://github.com/netdata/netdata/issues/12202))
- Fix detection of existing installs. ([#12199](https://github.com/netdata/netdata/issues/12199))
- Fix(kickstart): use correct syntax for claiming extra parameters ([#12289](https://github.com/netdata/netdata/issues/12289))
- Chore: remove unused variable in the system-info script ([#12297](https://github.com/netdata/netdata/issues/12297))
- Fix: cpu system info detection on macOS ([#12293](https://github.com/netdata/netdata/issues/12293))
- Fixing stderr output when testing tmpdir ([#12298](https://github.com/netdata/netdata/issues/12298))
- Fix: CPU frequency detection for some containers ([#12306](https://github.com/netdata/netdata/issues/12306))
- Add proper handling for legacy kickstart install detection. ([#12273](https://github.com/netdata/netdata/issues/12273))
- Fix incorrect install type on some older nightly installs. ([#12282](https://github.com/netdata/netdata/issues/12282))
- Adds node_id into mirrored_hosts list ([#12307](https://github.com/netdata/netdata/issues/12307))
- Fix uninstall using kickstart flag ([#12304](https://github.com/netdata/netdata/issues/12304))
- Fix 'connect' typo anomaly-detection-python.md ([#12317](https://github.com/netdata/netdata/issues/12317))
- Fix(health): adjust 10s_ipv4_tcp_resets_sent warn trigger ([#12320](https://github.com/netdata/netdata/issues/12320))
- Fix: returning 0 for CPU frequency when unknown ([#12323](https://github.com/netdata/netdata/issues/12323))
- Fix underscore in libnetfilter-acct-dev package ([#12326](https://github.com/netdata/netdata/issues/12326))
- Remove check for config file in stock conf dir ([#12327](https://github.com/netdata/netdata/issues/12327))
- Add latency dimension ([#12329](https://github.com/netdata/netdata/issues/12329))
- Pull in build dependencies when updating a locally built install. ([#12294](https://github.com/netdata/netdata/issues/12294))
- Bump actions/checkout from 2 to 3 ([#12330](https://github.com/netdata/netdata/issues/12330))
- Fix incorrect function names in netdata-updater.sh.
- Introduce new chart for process states metrics ([#12305](https://github.com/netdata/netdata/issues/12305))
- Fix: container virtualization detection with systemd-detect-virt ([#12338](https://github.com/netdata/netdata/issues/12338))
- Fix: use default "bind to" in native packages ([#12336](https://github.com/netdata/netdata/issues/12336))
- Add Fedora 36 to CI and package builds. ([#12268](https://github.com/netdata/netdata/issues/12268))
- Add Ubuntu 22.04 to CI and package builds. ([#12269](https://github.com/netdata/netdata/issues/12269))
- Workflow to trigger cloud regression e2e tests ([#12299](https://github.com/netdata/netdata/issues/12299))
- CO-RE and syscalls ([#12318](https://github.com/netdata/netdata/issues/12318))
- Redirect dependency handling script output to logfile when running from updater. ([#12341](https://github.com/netdata/netdata/issues/12341))
- Adjust cloud dimension update frequency  ([#12284](https://github.com/netdata/netdata/issues/12284))
- Prepend context in anomaly rate dimension id. ([#12342](https://github.com/netdata/netdata/issues/12342))
- Adds more info to aclk-state API call ([#12231](https://github.com/netdata/netdata/issues/12231))
- Final migration of release code off of Travis CI. ([#12239](https://github.com/netdata/netdata/issues/12239))
- Fix string handling for Slack CI notification bodies. ([#12235](https://github.com/netdata/netdata/issues/12235))
- Add warning about broken Docker hosts in container entrypoint. ([#12175](https://github.com/netdata/netdata/issues/12175))
- Improve agent to cloud synchronization performance ([#12348](https://github.com/netdata/netdata/issues/12348))
- Fix(health): make ioping_disk_latency alarm less sensitive ([#12351](https://github.com/netdata/netdata/issues/12351))
- Docs fix: Add missing frontmatter ([#12353](https://github.com/netdata/netdata/issues/12353))
- Fix typo in new release workflow.
- Fix pushing of changelog and versioning changes in release process.
- Fix chart synchronization with the cloud #12356
- Replace write with read locks ([#12309](https://github.com/netdata/netdata/issues/12309))
- Minor - fix analytics_build_info ([#12354](https://github.com/netdata/netdata/issues/12354))
- Fix handling of pushing commits for release process. ([#12359](https://github.com/netdata/netdata/issues/12359))
- Only store alert hashes once per health config iteration ([#12292](https://github.com/netdata/netdata/issues/12292))
- Fix(ci/release): limit the number of issues to fetch from GitHub when generating changelog ([#12371](https://github.com/netdata/netdata/issues/12371))
- Fix pushing version bump commits in release/nightly build workflow. ([#12372](https://github.com/netdata/netdata/issues/12372))
- Fix version handling issues in release workflow. ([#12375](https://github.com/netdata/netdata/issues/12375))
- Change default OOM score and scheduling policy to behave more sanely. ([#12271](https://github.com/netdata/netdata/issues/12271))
- Fix(ebpf.plugin): remove pid file on exit ([#12379](https://github.com/netdata/netdata/issues/12379))
- Chore(ci): add area/ebpf to PR labeler ([#12382](https://github.com/netdata/netdata/issues/12382))
- Fix double host prefix ([#12380](https://github.com/netdata/netdata/issues/12380))
- Bump google-github-actions/setup-gcloud from 0.5.1 to 0.6.0 ([#12386](https://github.com/netdata/netdata/issues/12386))
- Bump google-github-actions/upload-cloud-storage from 0.5.0 to 0.7.0 ([#12387](https://github.com/netdata/netdata/issues/12387))
- Dont check host health enabled if host is null ([#12392](https://github.com/netdata/netdata/issues/12392))
- Fix: shellcheck warnings in docker run.sh ([#12377](https://github.com/netdata/netdata/issues/12377))
- Delay removed event for 60 seconds after the chart's last collected time ([#12388](https://github.com/netdata/netdata/issues/12388))
- Remove unecessary error report for proc and sys files ([#12385](https://github.com/netdata/netdata/issues/12385))
- Bump the version of Coverity we are using to the latest. ([#12398](https://github.com/netdata/netdata/issues/12398))
- Remove owner check from webserver ([#12339](https://github.com/netdata/netdata/issues/12339))
- Fix crash when netdatacli command output too long ([#12393](https://github.com/netdata/netdata/issues/12393))
- Update dashboard to version v2.21.3. ([#12407](https://github.com/netdata/netdata/issues/12407))
- Remove backends subsystem ([#12146](https://github.com/netdata/netdata/issues/12146))
- Fix handling of checks for newer updater script on update. ([#12367](https://github.com/netdata/netdata/issues/12367))
- Fix update/install commands in Docker image test code. ([#12378](https://github.com/netdata/netdata/issues/12378))
- Chore: remove "web files" options leftovers ([#12403](https://github.com/netdata/netdata/issues/12403))
- Chore: remove contrib/sles11 ([#12410](https://github.com/netdata/netdata/issues/12410))
- Add additional link to badges doc ([#12412](https://github.com/netdata/netdata/issues/12412))
- Fix: temporary disable charts.d apcupsd collectors ([#12415](https://github.com/netdata/netdata/issues/12415))
- Reorder functions properly in updater script. ([#12399](https://github.com/netdata/netdata/issues/12399))
- Fix(charts.d.plugin): fix recursion in apcupsd_check and enable it again ([#12418](https://github.com/netdata/netdata/issues/12418))
- Fix: lowercase uuidgen ([#12422](https://github.com/netdata/netdata/issues/12422))
- Fix: add a delay between starting Netdata and checking pids ([#12420](https://github.com/netdata/netdata/issues/12420))
- Fix packaging CI failure notifications to actually report _all_ steps. ([#12394](https://github.com/netdata/netdata/issues/12394))
- Add retries in preparation of test environments for build CI. ([#12198](https://github.com/netdata/netdata/issues/12198))
- Sanely handle very large PR bodies in package build CI matrix generation. ([#12218](https://github.com/netdata/netdata/issues/12218))
- Add a dry run mode to the kickstart script. ([#12322](https://github.com/netdata/netdata/issues/12322))
- Fix os_name for older agent versions streaming to a parent ([#12425](https://github.com/netdata/netdata/issues/12425))
- Revise claiming error message in kickstart script. ([#12248](https://github.com/netdata/netdata/issues/12248))
- Ensure claim_id is sent always lowercase ([#12423](https://github.com/netdata/netdata/issues/12423))
- Docs: Fix broken link ([#12428](https://github.com/netdata/netdata/issues/12428))
- Fix(kickstart.sh): prefer shasum over sha256sum ([#12429](https://github.com/netdata/netdata/issues/12429))
- Update Agent version in the Swagger API ([#12374](https://github.com/netdata/netdata/issues/12374))
- Don't publish nightlies if they are unchanged since the last nightly. ([#12411](https://github.com/netdata/netdata/issues/12411))
- Update build/m4/ax_pthread.m4 ([#12390](https://github.com/netdata/netdata/issues/12390))
- Apps.plugin: fix for plugin sending unnecessary data in freebsd ([#12446](https://github.com/netdata/netdata/issues/12446))
- Fix unclaimed agents ([#12449](https://github.com/netdata/netdata/issues/12449))
- Add delay on missing priv_key ([#12450](https://github.com/netdata/netdata/issues/12450))
- Fix(cups.plugin): add `cups` prefix to chart context ([#12444](https://github.com/netdata/netdata/issues/12444))
- Fix install type in netdata-uninstaller.sh ([#12438](https://github.com/netdata/netdata/issues/12438))
- Fix: CPU frequency detection of FreeBSD ([#12440](https://github.com/netdata/netdata/issues/12440))
- Update dashboard to version v2.21.8. ([#12455](https://github.com/netdata/netdata/issues/12455))
- Fix(collectors/cgroups): use different context for cgroup network charts ([#12454](https://github.com/netdata/netdata/issues/12454))
- Feat(statsd.plugin): add Asterisk configuration file with synthetic charts ([#12381](https://github.com/netdata/netdata/issues/12381))
- Add content for eBPF documentation ([#12417](https://github.com/netdata/netdata/issues/12417))
- Docs(collectors/python.d): remove mention of compatibility with py2/py3 ([#12465](https://github.com/netdata/netdata/issues/12465))
- Allow updates without environment files in some cases. ([#12400](https://github.com/netdata/netdata/issues/12400))
- Chore(deps): bump google-github-actions/upload-cloud-storage ([#12468](https://github.com/netdata/netdata/issues/12468))
- Feat(collectors/cgroups): prefer `blkio.*_recursive` when available ([#12462](https://github.com/netdata/netdata/issues/12462))
- Minor - fix configure output of eBPF ([#12471](https://github.com/netdata/netdata/issues/12471))
- Implement fine-grained error replies to cloud queries ([#12460](https://github.com/netdata/netdata/issues/12460))
- Switch to using netdata-updater.sh to toggle auto updates on and off when installing. ([#12296](https://github.com/netdata/netdata/issues/12296))
- Use the built agentversion for Netdata static build archive name. ([#12335](https://github.com/netdata/netdata/issues/12335))
- Extend aclk-state information ([#12458](https://github.com/netdata/netdata/issues/12458))
- Update ebpf dashboard ([#12467](https://github.com/netdata/netdata/issues/12467))
- Add suraj to codeowners ([#12492](https://github.com/netdata/netdata/issues/12492))
- Open fd3 before first use ([#12491](https://github.com/netdata/netdata/issues/12491))
- Adjust timex.plugin information to be less cryptic ([#12495](https://github.com/netdata/netdata/issues/12495))
- Updated static build components to latest versions. ([#12461](https://github.com/netdata/netdata/issues/12461))
- PRs template: Include user information section ([#12499](https://github.com/netdata/netdata/issues/12499))
- Bump the debhelper compat level to 10 in our DEB packaging code. ([#12488](https://github.com/netdata/netdata/issues/12488))
- Dont send a snapshot with snapshot id 0 ([#12469](https://github.com/netdata/netdata/issues/12469))
- Provide better handling of config files in Docker containers. ([#12310](https://github.com/netdata/netdata/issues/12310))
- Stream compression - Deactivate compression at runtime in case of a compressor buffer overflow ([#12037](https://github.com/netdata/netdata/issues/12037))
- Timex: this plugin enables timex plugin for non-linux systems ([#12489](https://github.com/netdata/netdata/issues/12489))
- Feat(collectors/timex.plugin): add clock status chart ([#12501](https://github.com/netdata/netdata/issues/12501))
- Fix centos7 gpg key issue ([#12506](https://github.com/netdata/netdata/issues/12506))
- Remove Konstantinos Kaskavelis from CODEOWNERS. ([#12508](https://github.com/netdata/netdata/issues/12508))
- Fix: Netdata segfault because of 2 timex.plugin threads ([#12512](https://github.com/netdata/netdata/issues/12512))
- Add ml notebooks ([#12313](https://github.com/netdata/netdata/issues/12313))
- Feat(netdata-updater): add `--force-update` parameter ([#12493](https://github.com/netdata/netdata/issues/12493))
- Fix using incorrect repo when building native packages ([#12522](https://github.com/netdata/netdata/issues/12522))
- Use live charts to count the total number of dimensions. ([#12504](https://github.com/netdata/netdata/issues/12504))
- Skip `foreach` alarms for dimensions of anomaly rate chart. ([#12441](https://github.com/netdata/netdata/issues/12441))
- Fix(kickstart.sh): use `$ROOTCMD` when setting auto updates ([#12526](https://github.com/netdata/netdata/issues/12526))
- Docs: fix unresolved file references ([#12528](https://github.com/netdata/netdata/issues/12528))
- Feat(collectors): update go.d.plugin version to v0.32.0 ([#12536](https://github.com/netdata/netdata/issues/12536))
- Fix: use internal defaults for sched policy/oom score in native packages ([#12529](https://github.com/netdata/netdata/issues/12529))
- Allocate buffer and release on callback when executing agent CLI commands ([#12540](https://github.com/netdata/netdata/issues/12540))
- Fix(netdata-updater): properly handle update for debian packages ([#12524](https://github.com/netdata/netdata/issues/12524))
- Reduce min `dbengine anomaly rate every` 60s->30s ([#12543](https://github.com/netdata/netdata/issues/12543))
- Packaging: upgrage protocol buffer version to 3.19.4 ([#12537](https://github.com/netdata/netdata/issues/12537))
- Fix: use `/proc/cpuinfo` for CPU freq detection as a last resort ([#12550](https://github.com/netdata/netdata/issues/12550))
- Socket connections (eBPF) and bug fix ([#12532](https://github.com/netdata/netdata/issues/12532))
- Unblock cgroup version detection with systemd ([#12553](https://github.com/netdata/netdata/issues/12553))
- ML-related changes to address issue/discussion comments. ([#12494](https://github.com/netdata/netdata/issues/12494))
- Don't send alert events without wc->host ([#12547](https://github.com/netdata/netdata/issues/12547))
- Add spport for passing extraclaiming options when claiming with Docker. ([#12457](https://github.com/netdata/netdata/issues/12457))
- Make sure registered static threads are unique. ([#12538](https://github.com/netdata/netdata/issues/12538))
- Configure.ac: Unconditionally link against libatomic ([#12366](https://github.com/netdata/netdata/issues/12366))
- Feat(netdata-updater): add the script name when logging ([#12557](https://github.com/netdata/netdata/issues/12557))
- Fix FreeBSD bundled protobuf build if system one is present ([#12552](https://github.com/netdata/netdata/issues/12552))
- Fix coverity scan. ([#12561](https://github.com/netdata/netdata/issues/12561))
- Chore(deps): bump peter-evans/create-pull-request from 3 to 4 ([#12533](https://github.com/netdata/netdata/issues/12533))
- [Agent crash on api/v1/info call] - fixes #12559 ([#12565](https://github.com/netdata/netdata/issues/12565))
- Explicitly use debhelper to enable systemd service ([#12542](https://github.com/netdata/netdata/issues/12542))
- Fix temporary directory handling for dependency handling script in updater. ([#12562](https://github.com/netdata/netdata/issues/12562))
- Fix Build on MacOS ([#12554](https://github.com/netdata/netdata/issues/12554))
- Set repo priority in YUM/DNF repository configuration. ([#12332](https://github.com/netdata/netdata/issues/12332))
- Initialize foreach alarms of dimensions in health thread. ([#12452](https://github.com/netdata/netdata/issues/12452))
- Properly skip running the updater in kickstart dry-run mode. ([#12497](https://github.com/netdata/netdata/issues/12497))
- Properly recognize Almalinux as an RHEL clone. ([#12487](https://github.com/netdata/netdata/issues/12487))
- Improve ACLK sync logging  ([#12534](https://github.com/netdata/netdata/issues/12534))
- Respect dimension hidden option when executing a query and building the dimension list from the database ([#12570](https://github.com/netdata/netdata/issues/12570))
- Update ebpf doc ([#12503](https://github.com/netdata/netdata/issues/12503))
- Fix invocation of the coverity script. ([#12576](https://github.com/netdata/netdata/issues/12576))
- Fix ioping permissions ([#12580](https://github.com/netdata/netdata/issues/12580))
- Update links to documentation (eBPF) ([#12581](https://github.com/netdata/netdata/issues/12581))
- Fix memory leaks on Netdata exit ([#12511](https://github.com/netdata/netdata/issues/12511))
- Fix issue with charts not properly synchronized with the cloud ([#12451](https://github.com/netdata/netdata/issues/12451))
- Feat(collectors): update go.d.plugin version to v0.32.1 ([#12586](https://github.com/netdata/netdata/issues/12586))
- Chore: disable chart exists message ([#12594](https://github.com/netdata/netdata/issues/12594))
- Update ML-related charts ([#12574](https://github.com/netdata/netdata/issues/12574))
- Check if libatomic can be linked ([#12583](https://github.com/netdata/netdata/issues/12583))
- Fix coverity issues ([#12598](https://github.com/netdata/netdata/issues/12598))
- Fix ebpf exit ([#12590](https://github.com/netdata/netdata/issues/12590))
- Better check for IOMainPort on MacOS ([#12600](https://github.com/netdata/netdata/issues/12600))
- Feat(cgroups.plugin): add CPU throttling charts ([#12591](https://github.com/netdata/netdata/issues/12591))
- Enable streaming of anomaly_detection.* charts ([#12606](https://github.com/netdata/netdata/issues/12606))
- Fix a compilation warning ([#12608](https://github.com/netdata/netdata/issues/12608))
- Fix training/prediction stats charts context. ([#12610](https://github.com/netdata/netdata/issues/12610))
- Update anonymous-statistics readme for PH Cloud ([#12571](https://github.com/netdata/netdata/issues/12571))
- Update dashboard to version v2.22.3. ([#12607](https://github.com/netdata/netdata/issues/12607))
- Add some new ml params to README ([#12575](https://github.com/netdata/netdata/issues/12575))
- Feat: add support for cloud providers info to /api/v1/info ([#12613](https://github.com/netdata/netdata/issues/12613))
- Kickstart improved messaging ([#12577](https://github.com/netdata/netdata/issues/12577))
- Fix gpg key issue ([#12519](https://github.com/netdata/netdata/issues/12519))
- Fix print: command not found issue ([#12615](https://github.com/netdata/netdata/issues/12615))
- Fix(cgroups.plugin): set CPU prev usage before first usage. ([#12622](https://github.com/netdata/netdata/issues/12622))
- Don't do fatal on error writing the health api management key. ([#12623](https://github.com/netdata/netdata/issues/12623))
- Add eBPF CO-RE version and checksum files to distfile list. ([#12627](https://github.com/netdata/netdata/issues/12627))
- Bump mqtt_websockets ([#12625](https://github.com/netdata/netdata/issues/12625))
- Feat: add k8s_cluster_name host tag (GKE only) ([#12638](https://github.com/netdata/netdata/issues/12638))
- Update dashboard to version v2.22.6. ([#12653](https://github.com/netdata/netdata/issues/12653))
- Add handling for claiming non-standard install types with kickstart. ([#12064](https://github.com/netdata/netdata/issues/12064))
- Add --reinstall-clean flag and update documentation ([#12548](https://github.com/netdata/netdata/issues/12548))
- Only-build to build-only ([#12657](https://github.com/netdata/netdata/issues/12657))
- Add `locust` to `apps_groups.conf` ([#12498](https://github.com/netdata/netdata/issues/12498))
- EBPF update dashboard ([#12617](https://github.com/netdata/netdata/issues/12617))
- Fix: remove instance-specific information from chart titles ([#12644](https://github.com/netdata/netdata/issues/12644))
- Bump go.d.plugin to v0.32.2 ([#12663](https://github.com/netdata/netdata/issues/12663))
- Properly limit repository configuration dependencies. ([#12661](https://github.com/netdata/netdata/issues/12661))
- Add a timeout parameter to data queries ([#12649](https://github.com/netdata/netdata/issues/12649))
- Trigger cloud intergration workflow for PRs and pushes against master ([#12349](https://github.com/netdata/netdata/issues/12349))
- Add a chart label filter parameter in context data queries ([#12652](https://github.com/netdata/netdata/issues/12652))
- Update dashboard to version v2.24.0. ([#12668](https://github.com/netdata/netdata/issues/12668))
- [Stream compression Docs] - Enabled by default ([#12669](https://github.com/netdata/netdata/issues/12669))
- Remove on pull_request trigger ([#12670](https://github.com/netdata/netdata/issues/12670))
- Show error when clock synchronization state is unavailable ([#12667](https://github.com/netdata/netdata/issues/12667))
- Fix(ebpf.plugin): add missing chart context for cgroups charts ([#12671](https://github.com/netdata/netdata/issues/12671))
- Delete ML-related data of a host in the proper order. ([#12672](https://github.com/netdata/netdata/issues/12672))
- Chore(deps): bump actions/upload-artifact from 2 to 3 ([#12645](https://github.com/netdata/netdata/issues/12645))
- Chore(deps): bump actions/download-artifact from 2 to 3 ([#12646](https://github.com/netdata/netdata/issues/12646))
- Chore(deps): bump google-github-actions/upload-cloud-storage ([#12647](https://github.com/netdata/netdata/issues/12647))
- Add collectors/* labels ([#12675](https://github.com/netdata/netdata/issues/12675))
- Summarize encountered errors and warnings at end of kickstart script run. ([#12636](https://github.com/netdata/netdata/issues/12636))
- Fix the static build code in light of CVE-2022-24765 ([#12683](https://github.com/netdata/netdata/issues/12683))
- Dashboard network title ([#12665](https://github.com/netdata/netdata/issues/12665))
- Cancel anomaly detection threads before joining. ([#12681](https://github.com/netdata/netdata/issues/12681))
- Update dashboard to version v2.25.0. ([#12680](https://github.com/netdata/netdata/issues/12680))
- Fix regexes in release workflow code.

## [1.33.1] - 2022-02-14

### Merged Pull Requests:

- Fix handling of removed packages with leftover config files in package check. ([#12033](https://github.com/netdata/netdata/issues/12033))
- Updated the docs to match new install script ([#12042](https://github.com/netdata/netdata/issues/12042))
- Fix(docs): unresolved file references ([#12053](https://github.com/netdata/netdata/issues/12053))
- [Stream Compression] - Bug fix #12043 - lz4.h compilation error - compile from source ([#12049](https://github.com/netdata/netdata/issues/12049))
- Update dashboard to version v2.20.16. ([#12052](https://github.com/netdata/netdata/issues/12052))
- Fix handling of non-x86 static builds in updater. ([#12055](https://github.com/netdata/netdata/issues/12055))
- Fix typo, tidy up sentence ([#12062](https://github.com/netdata/netdata/issues/12062))
- Replace CentOS 8 with RockyLinux 8 in CI and package builds. ([#11801](https://github.com/netdata/netdata/issues/11801))
- Updated formatting issues and copy ([#11944](https://github.com/netdata/netdata/issues/11944))
- Fix compilation errors for OpenSSL on macOS ([#12048](https://github.com/netdata/netdata/issues/12048))
- Fix runtime reclaim (aclk_kill_link) reconnect loop ([#12074](https://github.com/netdata/netdata/issues/12074))
- Docs install cleanup ([#12057](https://github.com/netdata/netdata/issues/12057))
- Docs: improve "Docker container names resolution" section ([#12079](https://github.com/netdata/netdata/issues/12079))
- Remove mention of libJudy in installation documentation for macOS ([#12080](https://github.com/netdata/netdata/issues/12080))
- Disable_ebpf_socket: Disable thread while race condition is fixed ([#12085](https://github.com/netdata/netdata/issues/12085))
- Add support for native rocky install ([#12081](https://github.com/netdata/netdata/issues/12081))
- Docs: add a note that the "Install Netdata on Synology" is maintained by community ([#12086](https://github.com/netdata/netdata/issues/12086))
- Add existing OS dependencies and add fedora/rockylinux scripts ([#11963](https://github.com/netdata/netdata/issues/11963))
- Make a lack of an os-release file non-fatal on install. ([#12087](https://github.com/netdata/netdata/issues/12087))
- Bump google-github-actions/setup-gcloud from 0.4.0 to 0.5.0 ([#12093](https://github.com/netdata/netdata/issues/12093))
- Added interactive kickstart scripts where possible ([#12098](https://github.com/netdata/netdata/issues/12098))
- Update ml/ code owners. ([#12094](https://github.com/netdata/netdata/issues/12094))
- Update scripts for POSIX compatibility ([#11961](https://github.com/netdata/netdata/issues/11961))
- Disable hashes for charts and alerts if openssl is not available or cloud is disabled ([#12071](https://github.com/netdata/netdata/issues/12071))
- Remove aclk legacy information ([#12103](https://github.com/netdata/netdata/issues/12103))
- Updated doc to match the new component name ([#12106](https://github.com/netdata/netdata/issues/12106))
- Add info about installer interactivity to anonymous installer telemetry events. ([#12088](https://github.com/netdata/netdata/issues/12088))
- Properly handle non-interactive installs as non-root users. ([#12089](https://github.com/netdata/netdata/issues/12089))
- Update repoconfig package build workflow to run on PRs and pushes. ([#12102](https://github.com/netdata/netdata/issues/12102))
- Fix handling of OracleLinux repoconfig packages. ([#12100](https://github.com/netdata/netdata/issues/12100))
- Add proper support for Oracle Linux native packages to installer. ([#12101](https://github.com/netdata/netdata/issues/12101))
- Docs: Fix paths to install boxes ([#12109](https://github.com/netdata/netdata/issues/12109))
- Adds legacy protocol deprecation banner to agent log ([#12065](https://github.com/netdata/netdata/issues/12065))
- Decouple the instal detection code from the handling code for existing installs. ([#12110](https://github.com/netdata/netdata/issues/12110))
- Update dashboard to version v2.20.18. ([#12117](https://github.com/netdata/netdata/issues/12117))
- Add feature request form ([#12119](https://github.com/netdata/netdata/issues/12119))
- Update syntax for Caddy v2 ([#12092](https://github.com/netdata/netdata/issues/12092))
- Update github template chooser ([#12125](https://github.com/netdata/netdata/issues/12125))
- Docs: rename kickstart install badges units ([#12131](https://github.com/netdata/netdata/issues/12131))
- [netdata patch release] 1.33.1

## [1.33.0] - 2022-01-26

### Merged Pull Requests:

- Fix getting latest release tag ([#11908](https://github.com/netdata/netdata/issues/11908))
- Don’t verify optional dependencies in build test environments in CI. ([#11910](https://github.com/netdata/netdata/issues/11910))
- Fix the code that checks for available updates. ([#11870](https://github.com/netdata/netdata/issues/11870))
- Fi handling of agent restart on update. ([#11887](https://github.com/netdata/netdata/issues/11887))
- Fix(docs): unresolved file references ([#11903](https://github.com/netdata/netdata/issues/11903))
- Fix slight errors ([#11902](https://github.com/netdata/netdata/issues/11902))
- Added "==" to the list of expression operators ([#11905](https://github.com/netdata/netdata/issues/11905))
- Add note with link to guide for using on Pi ([#11605](https://github.com/netdata/netdata/issues/11605))
- Fix title of exporting reference doc ([#11252](https://github.com/netdata/netdata/issues/11252))
- Fix claim node examples in kickstart(-64) documentation ([#11242](https://github.com/netdata/netdata/issues/11242))
- Indicate availability on Gentoo ([#7675](https://github.com/netdata/netdata/issues/7675))
- Chore(docs): fix tables side borders ([#11923](https://github.com/netdata/netdata/issues/11923))
- Send ML feature information with UpdateNodeInfo. ([#11913](https://github.com/netdata/netdata/issues/11913))
- Provide runtime ml info from a new endpoint. ([#11886](https://github.com/netdata/netdata/issues/11886))
- Spelling ([#10976](https://github.com/netdata/netdata/issues/10976))
- Improve PagerDuty notification doc ([#11147](https://github.com/netdata/netdata/issues/11147))
- Chore(ci): add area/claim to PR labeler ([#11926](https://github.com/netdata/netdata/issues/11926))
- Fix(ci): install ESLint before running reviewdog/action-eslint ([#11922](https://github.com/netdata/netdata/issues/11922))
- Chore: update community link of alert notifications ([#11860](https://github.com/netdata/netdata/issues/11860))
- Include libatomic twice to allow protobuf to resolve ([#11917](https://github.com/netdata/netdata/issues/11917))
- Fix(claim): set URL_BASE only if `-url` parameter value is not null ([#11919](https://github.com/netdata/netdata/issues/11919))
- Feat(python.d/fail2ban): add "Failed attempts" chart, cleanup ([#11825](https://github.com/netdata/netdata/issues/11825))
- Nvidia_smi_chart.py : fixed username for not-local users ([#11858](https://github.com/netdata/netdata/issues/11858))
- Update dashboard to version v2.20.15. ([#11934](https://github.com/netdata/netdata/issues/11934))
- Removes ACLK Legacy ([#11841](https://github.com/netdata/netdata/issues/11841))
- Optimize rx msg name resolution ([#11811](https://github.com/netdata/netdata/issues/11811))
- Remove Ubuntu 21.04 from CI and packaging. ([#11851](https://github.com/netdata/netdata/issues/11851))
- Fix configure syntax error ([#11937](https://github.com/netdata/netdata/issues/11937))
- Add bug report form ([#11891](https://github.com/netdata/netdata/issues/11891))
- Fix tps decode, add memory usage chart ([#11797](https://github.com/netdata/netdata/issues/11797))
- Postgres: use block_size instead of 8*1024 ([#11815](https://github.com/netdata/netdata/issues/11815))
- Postgres: mat. views considered as tables in table size/count chart ([#11816](https://github.com/netdata/netdata/issues/11816))
- Fix cachestat on kernel 5.15.x (eBPF) ([#11833](https://github.com/netdata/netdata/issues/11833))
- Fix compilation warnings ([#11846](https://github.com/netdata/netdata/issues/11846))
- Fix unit tests for Prometheus remote write exporting connector ([#11883](https://github.com/netdata/netdata/issues/11883))
- Update dependencies for the pubsub exporting connector ([#11872](https://github.com/netdata/netdata/issues/11872))
- Don't check for symbols in libaws-cpp-sdk-core ([#11867](https://github.com/netdata/netdata/issues/11867))
- Update_libbpf: Add new libbpf version ([#11865](https://github.com/netdata/netdata/issues/11865))
- Add support to updater for updating native DEB/RPM installs with our official packages. ([#11753](https://github.com/netdata/netdata/issues/11753))
- Fix retrieving service commands without failure ([#11947](https://github.com/netdata/netdata/issues/11947))
- Fix a broken link in dashboard_info.js ([#11948](https://github.com/netdata/netdata/issues/11948))
- Fix cmake build ([#11862](https://github.com/netdata/netdata/issues/11862))
- Allow PushBullet notifications to be sent to PushBullet channels ([#11850](https://github.com/netdata/netdata/issues/11850))
- Fix time_t format ([#11897](https://github.com/netdata/netdata/issues/11897))
- ACLK-NG remove 'cmd' switch by message type ([#11866](https://github.com/netdata/netdata/issues/11866))
- Try to find worker thread from parked ones ([#11928](https://github.com/netdata/netdata/issues/11928))
- Fix: add a note that netfilter's `new` and `ignore` counters are removed in the latest kernel ([#11950](https://github.com/netdata/netdata/issues/11950))
- Python.d/nvidia_smi: add bar1 chart ([#11956](https://github.com/netdata/netdata/issues/11956))
- Fix(nfacct.plugin): Netfilter accounting charts priority ([#11952](https://github.com/netdata/netdata/issues/11952))
- Fix(nfacct.plugin): Netfilter accounting data collection ([#11951](https://github.com/netdata/netdata/issues/11951))
- Add a missing capability for the perf plugin ([#11958](https://github.com/netdata/netdata/issues/11958))
- Send the cloud protocol used to posthog ([#11842](https://github.com/netdata/netdata/issues/11842))
- Improved the code example in SNMP v3 documentation ([#11959](https://github.com/netdata/netdata/issues/11959))
- Find host and pass health_enabled to cloud health log message ([#11960](https://github.com/netdata/netdata/issues/11960))
- Remove bitfields from rrdhost. ([#11964](https://github.com/netdata/netdata/issues/11964))
- Use absolute features when doing training/prediction. ([#11876](https://github.com/netdata/netdata/issues/11876))
- Ignore clangd cache directory. ([#11803](https://github.com/netdata/netdata/issues/11803))
- Fixed formatting ([#11943](https://github.com/netdata/netdata/issues/11943))
- Fix aclk chart description ([#11970](https://github.com/netdata/netdata/issues/11970))
- Perform a host metadata update on reconnection ([#11965](https://github.com/netdata/netdata/issues/11965))
- Free claim_id ([#11973](https://github.com/netdata/netdata/issues/11973))
- Bump engine.io from 4.1.0 to 4.1.2 ([#11968](https://github.com/netdata/netdata/issues/11968))
- Bump follow-redirects from 1.13.2 to 1.14.7 ([#11972](https://github.com/netdata/netdata/issues/11972))
- Better handle creation of UUID for claiming. ([#11974](https://github.com/netdata/netdata/issues/11974))
- Fix(python.d): ignore decoding errors in ExecutableService ([#11979](https://github.com/netdata/netdata/issues/11979))
- Bump lodash from 4.17.19 to 4.17.21 ([#11976](https://github.com/netdata/netdata/issues/11976))
- Add localhost hostname to the edit_command ([#11793](https://github.com/netdata/netdata/issues/11793))
- Fix(updater): checksum validation for static build ([#11986](https://github.com/netdata/netdata/issues/11986))
- Remove "component" from PR template ([#11988](https://github.com/netdata/netdata/issues/11988))
- Use libnetdata/required_dummies.h in collectors. ([#11971](https://github.com/netdata/netdata/issues/11971))
- Do not use dbengine headers when dbengine is disabled. ([#11967](https://github.com/netdata/netdata/issues/11967))
- Fix yum config-manager check ([#11945](https://github.com/netdata/netdata/issues/11945))
- Included link to charts.d example ([#11990](https://github.com/netdata/netdata/issues/11990))
- Fix ib counters ([#11994](https://github.com/netdata/netdata/issues/11994))
- Initial release of new kickstart script. ([#11764](https://github.com/netdata/netdata/issues/11764))
- Update go.d.plugin version to v0.31.1 ([#11995](https://github.com/netdata/netdata/issues/11995))
- Add alternative install command for macOS. ([#11997](https://github.com/netdata/netdata/issues/11997))
- Refined the python example for clarity ([#11989](https://github.com/netdata/netdata/issues/11989))
- Fix install prefix handling for claiming code in new kickstart script. ([#11999](https://github.com/netdata/netdata/issues/11999))
- Deleted duplicate getting started doc ([#11978](https://github.com/netdata/netdata/issues/11978))
- Compute platform-specific list of static_threads at runtime. ([#11955](https://github.com/netdata/netdata/issues/11955))
- Fix(python.d.plugin): prefer python3 if available ([#12001](https://github.com/netdata/netdata/issues/12001))
- Fix permissions of plugins that may be built ([#11877](https://github.com/netdata/netdata/issues/11877))
- Fix handling of static archive selection for installs. ([#12004](https://github.com/netdata/netdata/issues/12004))
- Update go.d.plugin version to v0.31.2 ([#12005](https://github.com/netdata/netdata/issues/12005))
- EBPF plugin CO-RE and monitoring ([#11992](https://github.com/netdata/netdata/issues/11992))
- Update libmongoc CMake config ([#11962](https://github.com/netdata/netdata/issues/11962))
- Add code for LZ4 streaming data compression ([#11821](https://github.com/netdata/netdata/issues/11821))
- Fix queue removed alerts ([#11996](https://github.com/netdata/netdata/issues/11996))
- Handle re-claim while the agent is running in new architecture ([#11924](https://github.com/netdata/netdata/issues/11924))
- Blocking publish and in flight buffer regrowth ([#11932](https://github.com/netdata/netdata/issues/11932))
- Fix typo in the dashboard_info.js spigot part ([#12008](https://github.com/netdata/netdata/issues/12008))
- Deleted an EOL file ([#12000](https://github.com/netdata/netdata/issues/12000))
- Remove internal dbengine header from spawn/spawn_client.c ([#12009](https://github.com/netdata/netdata/issues/12009))
- Add support for NVME disks with blkext driver ([#12007](https://github.com/netdata/netdata/issues/12007))
- Mqtt_websockets submodule to latest master ([#12011](https://github.com/netdata/netdata/issues/12011)) ([#12015](https://github.com/netdata/netdata/issues/12015))
- Remove unecessary call that was enabling disabled threads ([#12014](https://github.com/netdata/netdata/issues/12014))
- Updated idlejitter-plugin docs ([#12012](https://github.com/netdata/netdata/issues/12012))
- [Stream Compression] - Compressor buffer overflow causes stream corruption. ([#12019](https://github.com/netdata/netdata/issues/12019))
- Update documentation with new dependencies ([#11373](https://github.com/netdata/netdata/issues/11373))
- Fix cleanup from a failed DEB install. ([#12006](https://github.com/netdata/netdata/issues/12006))
- Docs Bugfix: Fixed Markdown formatting ([#12026](https://github.com/netdata/netdata/issues/12026))
- Docs Bugfix: Capitalization ([#12024](https://github.com/netdata/netdata/issues/12024))
- Fix passing of version to GHA release workflow. ([#11909](https://github.com/netdata/netdata/issues/11909))
- Add install type info to `-W buildinfo` output. ([#12010](https://github.com/netdata/netdata/issues/12010))
- Bump google-github-actions/setup-gcloud from 0.3 to 0.4.0 ([#12031](https://github.com/netdata/netdata/issues/12031))
- Have cURL properly fail on non-2xx status codes. ([#12038](https://github.com/netdata/netdata/issues/12038))
- Re-instate plugins_action for clabels ([#12039](https://github.com/netdata/netdata/issues/12039))
- [netdata minor release] v1.33.0

## [1.32.1] - 2021-12-14

### Merged Pull Requests:

- Remove Fedora 33 from CI. ([#11640](https://github.com/netdata/netdata/issues/11640))
- Remove OpenSUSE Leap 15.2 from CI. ([#11600](https://github.com/netdata/netdata/issues/11600))
- Bump static builds to use Alpine 3.15 as a base. ([#11836](https://github.com/netdata/netdata/issues/11836))
- Fix token name in release draft workflow. ([#11847](https://github.com/netdata/netdata/issues/11847))
- Update nightly badge link ([#11843](https://github.com/netdata/netdata/issues/11843))
- Explicitly conflict with netdata-core DEB package. ([#11855](https://github.com/netdata/netdata/issues/11855))
- Create ML README.md ([#11848](https://github.com/netdata/netdata/issues/11848))
- Set the enabled struct element to 1 ([#11856](https://github.com/netdata/netdata/issues/11856))
- Fix(health): used_swap alarm calc ([#11868](https://github.com/netdata/netdata/issues/11868))
- Detect whether libatomic should be linked in when using CXX linker. ([#11818](https://github.com/netdata/netdata/issues/11818))
- Fix static build, curl will be staict binary; extra args can be transfer ([#11852](https://github.com/netdata/netdata/issues/11852))
- Fix(updater): fix exit code when updating static install && updater script ([#11873](https://github.com/netdata/netdata/issues/11873))
- Make netdata-updater.sh POSIX compliant. ([#11755](https://github.com/netdata/netdata/issues/11755))
- Fix(updater): don't produce output when static update succeeded ([#11879](https://github.com/netdata/netdata/issues/11879))
- Add z score alarm example ([#11871](https://github.com/netdata/netdata/issues/11871))
- Fix postdrop handling for systemd systems. ([#11885](https://github.com/netdata/netdata/issues/11885))
- Minor ACLK docu updates ([#11882](https://github.com/netdata/netdata/issues/11882))
- Fixed formatting issues. ([#11888](https://github.com/netdata/netdata/issues/11888))
- Moved data privacy section into a separate topic ([#11889](https://github.com/netdata/netdata/issues/11889))
- Use the chart id instead of chart name in response to incoming cloud context queries ([#11898](https://github.com/netdata/netdata/issues/11898))
- Bump google-github-actions/setup-gcloud from 0.2.1 to 0.3 ([#11893](https://github.com/netdata/netdata/issues/11893))
- Bump google-github-actions/upload-cloud-storage from 0.4.0 to 0.5.0 ([#11894](https://github.com/netdata/netdata/issues/11894))
- Clean up anomaly-detection guide docs ([#11901](https://github.com/netdata/netdata/issues/11901))
- Adds Swagger docs for new `/api/v1/aclk` endpoint ([#11881](https://github.com/netdata/netdata/issues/11881))
- [netdata patch release] v1.32.1

## [1.32.0] - 2021-11-30

### Merged Pull Requests:

- Store info about the installation type for later retrieval. ([#11157](https://github.com/netdata/netdata/issues/11157))
- Adding more postgres metrics ([#11169](https://github.com/netdata/netdata/issues/11169))
- Health: make stocks alarms less sensitive (2) ([#11153](https://github.com/netdata/netdata/issues/11153))
- Health: add python.d/go.d jobs last_collected_secs alarms ([#11168](https://github.com/netdata/netdata/issues/11168))
- Health: add system clock synchronization state alarm ([#11177](https://github.com/netdata/netdata/issues/11177))
- Move mdstat charts near to Disks ([#11119](https://github.com/netdata/netdata/issues/11119))
- Remove an unnecessary check for cgroup v1 ([#11137](https://github.com/netdata/netdata/issues/11137))
- Fix mqtt_websockets (ACLK-NG) on MacOS ([#11145](https://github.com/netdata/netdata/issues/11145))
- Fixing sneaky broken links ([#11175](https://github.com/netdata/netdata/issues/11175))
- Ebpf swap ([#11090](https://github.com/netdata/netdata/issues/11090))
- Fix typo in aclk.c ([#11170](https://github.com/netdata/netdata/issues/11170))
- Query the size of the hw.intrnames mib instead of using of a fixed va… ([#11159](https://github.com/netdata/netdata/issues/11159))
- Fixes ACLK-NG on FreeBSD ([#11172](https://github.com/netdata/netdata/issues/11172))
- Remove unecessary relative paths when including headers. ([#11124](https://github.com/netdata/netdata/issues/11124))
- Remove deprecated options. ([#11149](https://github.com/netdata/netdata/issues/11149))
- Update news in main README for latest release ([#11165](https://github.com/netdata/netdata/issues/11165))
- Move parser from children to main thread ([#11152](https://github.com/netdata/netdata/issues/11152))
- Remove Fedora 32 from CI. ([#11143](https://github.com/netdata/netdata/issues/11143))
- Add link to example conf ([#11182](https://github.com/netdata/netdata/issues/11182))
- Fix mqtt_websockets submodule version ([#11196](https://github.com/netdata/netdata/issues/11196))
- Rename default from job 'local' to 'anomalies' ([#11178](https://github.com/netdata/netdata/issues/11178))
- Fix ebpf.plugin segfault when ebpf_load_program return null pointer ([#11203](https://github.com/netdata/netdata/issues/11203))
- Labeler: add "mqtt_websockets" to the ACLK ([#11197](https://github.com/netdata/netdata/issues/11197))
- Fix `install_type` detection during update ([#11199](https://github.com/netdata/netdata/issues/11199))
- VFS new thread ([#11187](https://github.com/netdata/netdata/issues/11187))
- Add Microsoft Teams to supported notification endpoints ([#11205](https://github.com/netdata/netdata/issues/11205))
- Check return status of execution of anonymous statistics script ([#11188](https://github.com/netdata/netdata/issues/11188))
- Claiming: exit 0 when daemon not running and the claim was successful ([#11195](https://github.com/netdata/netdata/issues/11195))
- Provide UTC offset in seconds and edit health config command ([#11051](https://github.com/netdata/netdata/issues/11051))
- Only report the exit code without strerror ([#11215](https://github.com/netdata/netdata/issues/11215))
- Ignore dbengine journal files that can not be read ([#11210](https://github.com/netdata/netdata/issues/11210))
- Do not fail agent if DBENGINE is not available and memory mode is set to dbengine ([#11207](https://github.com/netdata/netdata/issues/11207))
- Compile/Link with absolute paths for bundled/vendored deps. ([#11129](https://github.com/netdata/netdata/issues/11129))
- Store uuid_t metric_uuid in the dimension state structure instead of uuid_t * ([#11212](https://github.com/netdata/netdata/issues/11212))
- Health: fix alarm-line-charts matching ([#11204](https://github.com/netdata/netdata/issues/11204))
- Check for non ascii characters in health log ([#11193](https://github.com/netdata/netdata/issues/11193))
- Python.d: merge user/stock plugin configuration files ([#11217](https://github.com/netdata/netdata/issues/11217))
- EBPF ext4 (new thread for collector) ([#11224](https://github.com/netdata/netdata/issues/11224))
- Add data privacy links ([#11226](https://github.com/netdata/netdata/issues/11226))
- New email notification template ([#11219](https://github.com/netdata/netdata/issues/11219))
- Ebpf arrays ([#11230](https://github.com/netdata/netdata/issues/11230))
- Decentralized ([#11220](https://github.com/netdata/netdata/issues/11220))
- Health: update cockroachdb alarms ([#11235](https://github.com/netdata/netdata/issues/11235))
- Packaging: update go.d.plugin version to v0.29.0 ([#11239](https://github.com/netdata/netdata/issues/11239))
- Allows ACLK NG and Legacy to coexist ([#11225](https://github.com/netdata/netdata/issues/11225))
- Swap class and type attributes in stock alarm configurations ([#11240](https://github.com/netdata/netdata/issues/11240))
- Adds xfs filesystem monitoring to eBPF ([#11238](https://github.com/netdata/netdata/issues/11238))
- Fixes error on --disable-cloud ([#11244](https://github.com/netdata/netdata/issues/11244))
- Disable telemetry in CI. ([#11233](https://github.com/netdata/netdata/issues/11233))
- Send correct aclk implementation used by agent to posthog. ([#11247](https://github.com/netdata/netdata/issues/11247))
- Add more nics to FreeBSD plugin ([#11251](https://github.com/netdata/netdata/issues/11251))
- EBPF keep values from `ebpf.d.conf` ([#11253](https://github.com/netdata/netdata/issues/11253))
- Slabinfo: Handle slabs added after discovery ([#11257](https://github.com/netdata/netdata/issues/11257))
- Updates the docu with info about dual ACLK ([#11243](https://github.com/netdata/netdata/issues/11243))
- Fix libjudy installation on CentOS 8. ([#11248](https://github.com/netdata/netdata/issues/11248))
- Add openSUSE 15.3 CI checks. ([#11258](https://github.com/netdata/netdata/issues/11258))
- Ebpf apps memory usage ([#11256](https://github.com/netdata/netdata/issues/11256))
- Fix kickstart-static64.sh install script fail when trying to access `.install-type` before it is created ([#11262](https://github.com/netdata/netdata/issues/11262))
- Explicitly update libarchive on CentOS 8 when installing dependencies. ([#11264](https://github.com/netdata/netdata/issues/11264))
- Added new postgres charts and updated standby charts to include slot_… ([#11267](https://github.com/netdata/netdata/issues/11267))
- Add vkalintiris as a code owner for more components ([#11221](https://github.com/netdata/netdata/issues/11221))
- Add openSUSE 15.3 package builds. ([#11259](https://github.com/netdata/netdata/issues/11259))
- Update old log to new ([#11263](https://github.com/netdata/netdata/issues/11263))
- Makes ACLK-NG the default if available ([#11272](https://github.com/netdata/netdata/issues/11272))
- Add Alpine 3.14 to CI. ([#11270](https://github.com/netdata/netdata/issues/11270))
- Fixes confusing error in ACLK Legacy ([#11278](https://github.com/netdata/netdata/issues/11278))
- Bump actions/upload-artifact from 2.2.3 to 2.2.4 ([#11269](https://github.com/netdata/netdata/issues/11269))
- Extra posthog attributes ([#11237](https://github.com/netdata/netdata/issues/11237))
- Support TLS SNI in ACLK-NG ([#11285](https://github.com/netdata/netdata/issues/11285))
- Remove access check for install-type file ([#11288](https://github.com/netdata/netdata/issues/11288))
- Fix `mdstat` current operation charts context/title ([#11289](https://github.com/netdata/netdata/issues/11289))
- EBPF plugin remove parallel plugins ([#11287](https://github.com/netdata/netdata/issues/11287))
- Health: remove pythond modules specific last_collected alarms ([#11307](https://github.com/netdata/netdata/issues/11307))
- [docs] fix prometheus node cpu alert rule ([#11309](https://github.com/netdata/netdata/issues/11309))
- Fix various python modules charts contexts ([#11310](https://github.com/netdata/netdata/issues/11310))
- Ebpf disk latency ([#11276](https://github.com/netdata/netdata/issues/11276))
- V2.18.5 ([#11316](https://github.com/netdata/netdata/issues/11316))
- Add hop count for children ([#11311](https://github.com/netdata/netdata/issues/11311))
- ACLK-NG New Cloud NodeInstance related msgs ([#11234](https://github.com/netdata/netdata/issues/11234))
- Fix tiny issues in docs ([#11320](https://github.com/netdata/netdata/issues/11320))
- Add some more entries to gitignore ([#11319](https://github.com/netdata/netdata/issues/11319))
- Fixes coverity errors in ACLK ([#11322](https://github.com/netdata/netdata/issues/11322))
- Add HTTP access log messages for ACLK-NG ([#11318](https://github.com/netdata/netdata/issues/11318))
- EBPF NFS monitoring ([#11313](https://github.com/netdata/netdata/issues/11313))
- V2.19.1 ([#11323](https://github.com/netdata/netdata/issues/11323))
- Fix typo in analytics.c ([#11329](https://github.com/netdata/netdata/issues/11329))
- Update get-started.mdx ([#11303](https://github.com/netdata/netdata/issues/11303))
- Auto-detect PGID in Dockerfile's ENTRYPOINT script ([#11274](https://github.com/netdata/netdata/issues/11274))
- Adds aclk-schemas to dist_noinst_DATA ([#11338](https://github.com/netdata/netdata/issues/11338))
- Log message when page cache sleeps for more than 1 second. ([#11314](https://github.com/netdata/netdata/issues/11314))
- Properly handle the file list for updating the dashboard. ([#11282](https://github.com/netdata/netdata/issues/11282))
- Add postgresql version to requirements section ([#11328](https://github.com/netdata/netdata/issues/11328))
- EBPF ZFS monitoring ([#11330](https://github.com/netdata/netdata/issues/11330))
- Move cleanup of obsolete charts to a separate thread ([#11222](https://github.com/netdata/netdata/issues/11222))
- Add ACLK-NG cloud request type charts ([#11326](https://github.com/netdata/netdata/issues/11326))
- Assorted kickstart install fixes. ([#11342](https://github.com/netdata/netdata/issues/11342))
- Packaging: update go.d.plugin version to v0.30.0 ([#11349](https://github.com/netdata/netdata/issues/11349))
- Add geth default config ([#11341](https://github.com/netdata/netdata/issues/11341))
- Allow bundled protobuf ([#11335](https://github.com/netdata/netdata/issues/11335))
- Check if sendmail supports -F parameter ([#11283](https://github.com/netdata/netdata/issues/11283))
- Fix sending MS Teams notifications to multiple channels ([#11355](https://github.com/netdata/netdata/issues/11355))
- Ebpf btrfs ([#11348](https://github.com/netdata/netdata/issues/11348))
- Fix_vfs_index: Fix index reference ([#11356](https://github.com/netdata/netdata/issues/11356))
- Health: fix cockroachdb replication alarms ([#11360](https://github.com/netdata/netdata/issues/11360))
- Remove Ubuntu 20.10 from CI checks. ([#11265](https://github.com/netdata/netdata/issues/11265))
- Disable oom_kill alarm if the node is k8s node ([#11359](https://github.com/netdata/netdata/issues/11359))
- Fix `gearman_workers_queued` alarm ([#11361](https://github.com/netdata/netdata/issues/11361))
- Properly handle eBPF plugin in RPM packages. ([#11362](https://github.com/netdata/netdata/issues/11362))
- Allows ACLK-NG to grow MQTT buffer ([#11340](https://github.com/netdata/netdata/issues/11340))
- CODEOWNERS: Remove knatsakis ([#11377](https://github.com/netdata/netdata/issues/11377))
- Ebpf latency description ([#11363](https://github.com/netdata/netdata/issues/11363))
- Update handling of builds of bundled dependencies. ([#11375](https://github.com/netdata/netdata/issues/11375))
- EBPF mount ([#11358](https://github.com/netdata/netdata/issues/11358))
- Add code for repository configuration packages. ([#11273](https://github.com/netdata/netdata/issues/11273))
- Specify module for threads ([#11387](https://github.com/netdata/netdata/issues/11387))
- Charts.d.plugin: set "module" when sending CHART ([#11390](https://github.com/netdata/netdata/issues/11390))
- Ebpf_remove_warning: Change function call from strncpy to memcpy ([#11389](https://github.com/netdata/netdata/issues/11389))
- Add HTTP basic authentication to some exporting connectors ([#11394](https://github.com/netdata/netdata/issues/11394))
- Update perf.events and add new charts ([#11392](https://github.com/netdata/netdata/issues/11392))
- Fix freebsd and macos plugin names ([#11398](https://github.com/netdata/netdata/issues/11398))
- Use only stock configuration filenames as module names ([#11400](https://github.com/netdata/netdata/issues/11400))
- Docs: Remove extra 's' ([#11376](https://github.com/netdata/netdata/issues/11376))
- New Cloud chart related parsers and generators ([#11393](https://github.com/netdata/netdata/issues/11393))
- Replaced reference to raw.githubuser to a relative path ([#11405](https://github.com/netdata/netdata/issues/11405))
- Fix coverity issue 372222 ([#11404](https://github.com/netdata/netdata/issues/11404))
- Fix bundled protobuf linkage on systems needing -latomic ([#11406](https://github.com/netdata/netdata/issues/11406))
- Changed the term claim to connect (to Cloud) on docs ([#11378](https://github.com/netdata/netdata/issues/11378))
- Fix CID372233 to CID 372236 ([#11411](https://github.com/netdata/netdata/issues/11411))
- Remove "vernemq.queue_messages_in_queues" from dashboard_info.js ([#11403](https://github.com/netdata/netdata/issues/11403))
- Custom dash broken links ([#11413](https://github.com/netdata/netdata/issues/11413))
- Minor - remove trailing whitespace ([#11407](https://github.com/netdata/netdata/issues/11407))
- Add support for claiming existing installs via kickstarter scripts. ([#11350](https://github.com/netdata/netdata/issues/11350))
- Remove Ubuntu 20.10 from repository config package builds. ([#11421](https://github.com/netdata/netdata/issues/11421))
- Fix conditional in repoconfig package CI job.
- Really fix conditional in repoconfig packages CI.
- Add ACLK synchronization event loop ([#11396](https://github.com/netdata/netdata/issues/11396))
- Final syntax fixes for repoconfig packages workflow.
- Remove conditional jobs from repoconfig packages workflow.
- Fix opensuse 15.3 repository package build.
- Use DebHelper compat level 9 in repoconfig packages to support Ubuntu 16.04 ([#11426](https://github.com/netdata/netdata/issues/11426))
- Properly handle reuploads of packages to PackageCloud. ([#11427](https://github.com/netdata/netdata/issues/11427))
- Split eBPF programs ([#11401](https://github.com/netdata/netdata/issues/11401))
- Additional checks to address coverity report ([#11429](https://github.com/netdata/netdata/issues/11429))
- Simple SQLite unit tests ([#11422](https://github.com/netdata/netdata/issues/11422))
- Default to not using LTO for builds. ([#11432](https://github.com/netdata/netdata/issues/11432))
- Force play timezone ([#11433](https://github.com/netdata/netdata/issues/11433))
- Fix issue #11434 regarding inconsistent status check on  component. ([#11435](https://github.com/netdata/netdata/issues/11435))
- Add terra to blockchains apps groups ([#11437](https://github.com/netdata/netdata/issues/11437))
- SQLite v3.36.0 ([#11423](https://github.com/netdata/netdata/issues/11423))
- Remove ClearLinux from CI. ([#11438](https://github.com/netdata/netdata/issues/11438))
- Added support for bundling protobuf as part of the install. ([#11374](https://github.com/netdata/netdata/issues/11374))
- Adds NodeInstanceInfo internal API ([#11419](https://github.com/netdata/netdata/issues/11419))
- Add Debian 11 (Bullseye) to CI. ([#11334](https://github.com/netdata/netdata/issues/11334))
- EBPF Hard IRQ latency ([#11410](https://github.com/netdata/netdata/issues/11410))
- Update ebpf documentation ([#11440](https://github.com/netdata/netdata/issues/11440))
- Fix list corruption in ACLK sync code and remove fatal ([#11444](https://github.com/netdata/netdata/issues/11444))
- Update ebpf socket ([#11441](https://github.com/netdata/netdata/issues/11441))
- Update "Install Netdata on Synology" guide ([#11449](https://github.com/netdata/netdata/issues/11449))
- Remove AWS Kinesis CI. ([#11451](https://github.com/netdata/netdata/issues/11451))
- Check for failed protobuf configure or make ([#11450](https://github.com/netdata/netdata/issues/11450))
- EBPF Soft IRQ latency ([#11445](https://github.com/netdata/netdata/issues/11445))
- Fix ram level alarms ([#11452](https://github.com/netdata/netdata/issues/11452))
- Don’t bail early if we fail to build cloud deps with required cloud. ([#11446](https://github.com/netdata/netdata/issues/11446))
- Fix postgres replication_slot chart on standby ([#11455](https://github.com/netdata/netdata/issues/11455))
- #10773 add capsh check ([#11386](https://github.com/netdata/netdata/issues/11386))
- Add Travis ctrl file for checking if changes happened ([#11383](https://github.com/netdata/netdata/issues/11383))
- Fix edge repository configuration DEB packages. ([#11458](https://github.com/netdata/netdata/issues/11458))
- Use correct release codename for Debian 11 repoconfig packages. ([#11459](https://github.com/netdata/netdata/issues/11459))
- Adds Alert Related API for new protocol ([#11424](https://github.com/netdata/netdata/issues/11424))
- Add a note how to find web files directory ([#11461](https://github.com/netdata/netdata/issues/11461))
- EBPF vsn bump to v0.7.9.1 ([#11471](https://github.com/netdata/netdata/issues/11471))
- Installation review ([#11442](https://github.com/netdata/netdata/issues/11442))
- Remove broken link ([#11482](https://github.com/netdata/netdata/issues/11482))
- Clean netdata naming ([#11484](https://github.com/netdata/netdata/issues/11484))
- Embed build architecture in static build archive names. ([#11463](https://github.com/netdata/netdata/issues/11463))
- Revert "add Travis ctrl file for checking if changes happened ([#11383](https://github.com/netdata/netdata/issues/11383))" ([#11486](https://github.com/netdata/netdata/issues/11486))
- Add support for runtime configuration of UID/GID for Netdata user. ([#10683](https://github.com/netdata/netdata/issues/10683))
- Exclude bundled dashboard files from eslint checks. ([#11488](https://github.com/netdata/netdata/issues/11488))
- Fix issues in Alarm API ([#11491](https://github.com/netdata/netdata/issues/11491))
- Update claim README.md ([#11492](https://github.com/netdata/netdata/issues/11492))
- Revert "Add support for runtime configuration of UID/GID for Netdata user. ([#10683](https://github.com/netdata/netdata/issues/10683))" ([#11495](https://github.com/netdata/netdata/issues/11495))
- Use system copy of protobuf in Docker images and static builds. ([#11496](https://github.com/netdata/netdata/issues/11496))
- Fix elasticsearch null values returned by _cat/indices API ([#11501](https://github.com/netdata/netdata/issues/11501))
- Add custom e-mail headers ([#11454](https://github.com/netdata/netdata/issues/11454))
- Allow arbitrary options to be passed to make from netdata-installer.sh. ([#11479](https://github.com/netdata/netdata/issues/11479))
- V2.19.9 ([#11505](https://github.com/netdata/netdata/issues/11505))
- Add extra verification to Docker builds. ([#11497](https://github.com/netdata/netdata/issues/11497))
- Better check for supported -F parameter in sendmail ([#11506](https://github.com/netdata/netdata/issues/11506))
- Convert uppercase to lowercase for eBPF submenus ([#11511](https://github.com/netdata/netdata/issues/11511))
- Update handling of dashboard PR genertion to handle file deletions. ([#11489](https://github.com/netdata/netdata/issues/11489))
- Remove unused script ([#11516](https://github.com/netdata/netdata/issues/11516))
- Remove reset_netdata_trace.sh from netdata.service ([#11517](https://github.com/netdata/netdata/issues/11517))
- EBPF OOM kill tracking ([#11470](https://github.com/netdata/netdata/issues/11470))
- Improved some wordings of the file README.md ([#11510](https://github.com/netdata/netdata/issues/11510))
- Clean up dependency handling for CentOS/RHEL ([#11515](https://github.com/netdata/netdata/issues/11515))
- Install basic netdata deps by default. ([#11508](https://github.com/netdata/netdata/issues/11508))
- Update dashboard to version v2.20.0. ([#11521](https://github.com/netdata/netdata/issues/11521))
- Adds aclk/cloud state command to netdatacli ([#11462](https://github.com/netdata/netdata/issues/11462))
- Add a note about handling backslashes ([#11527](https://github.com/netdata/netdata/issues/11527))
- Add ipc semaphores charts info ([#11523](https://github.com/netdata/netdata/issues/11523))
- Use sqlite to store the health log and alert configurations. ([#11399](https://github.com/netdata/netdata/issues/11399))
- Re-added EPEL on CentOS 7. ([#11525](https://github.com/netdata/netdata/issues/11525))
- Fix issue with log messages appearing in the terminal instead of the error.log on startup ([#11524](https://github.com/netdata/netdata/issues/11524))
- Don't write updater log under root ([#10901](https://github.com/netdata/netdata/issues/10901))
- Add diskstats charts info ([#11528](https://github.com/netdata/netdata/issues/11528))
- Add/update proc_interrupts charts info ([#11532](https://github.com/netdata/netdata/issues/11532))
- Add node message support for ACLK new architecture ([#11514](https://github.com/netdata/netdata/issues/11514))
- Update libbpf ([#11480](https://github.com/netdata/netdata/issues/11480))
- Update london demo to point at london3 ([#11533](https://github.com/netdata/netdata/issues/11533))
- Remove unecessary blank line ([#11538](https://github.com/netdata/netdata/issues/11538))
- Fix broken links ([#11540](https://github.com/netdata/netdata/issues/11540))
- Add new cloud protocol files to cmake ([#11536](https://github.com/netdata/netdata/issues/11536))
- Add proc_mdstat charts info ([#11537](https://github.com/netdata/netdata/issues/11537))
- Fix coverity ([#11535](https://github.com/netdata/netdata/issues/11535))
- Add proc_meminfo charts info ([#11541](https://github.com/netdata/netdata/issues/11541))
- Fix installer flag --use-system-protobuf ([#11539](https://github.com/netdata/netdata/issues/11539))
- Use the correct exit status for the updater with static updates. ([#11520](https://github.com/netdata/netdata/issues/11520))
- Fix proc collector: Undefined state DEGRADED for zpool ([#11545](https://github.com/netdata/netdata/issues/11545))
- Add proc_net_dev charts info ([#11543](https://github.com/netdata/netdata/issues/11543))
- Add chart message support for ACLK new architecture ([#11447](https://github.com/netdata/netdata/issues/11447))
- Address coverity report issues CID_373247-373251 ([#11549](https://github.com/netdata/netdata/issues/11549))
- Add proc_net_ip_vs_stats charts info ([#11546](https://github.com/netdata/netdata/issues/11546))
- Reorganize Docker CI to run faster. ([#11513](https://github.com/netdata/netdata/issues/11513))
- Update ebpf dashboard ([#11547](https://github.com/netdata/netdata/issues/11547))
- Add proc_net_netstat charts info ([#11554](https://github.com/netdata/netdata/issues/11554))
- Add proc_net_snmp charts info ([#11557](https://github.com/netdata/netdata/issues/11557))
- Add proc_net_sctp_snmp charts info ([#11564](https://github.com/netdata/netdata/issues/11564))
- Add alert message support for ACLK new architecture ([#11552](https://github.com/netdata/netdata/issues/11552))
- Remove Ubuntu 16.04 from CI. ([#11556](https://github.com/netdata/netdata/issues/11556))
- Fix branch handling for automated dashoard PRs. ([#11526](https://github.com/netdata/netdata/issues/11526))
- Add option for netdata-installer to allow compilation only on X86_64 ([#11566](https://github.com/netdata/netdata/issues/11566))
- Add proc_net_snmp6 charts info ([#11565](https://github.com/netdata/netdata/issues/11565))
- Add proc_net_sockstat and sockstat6 charts info ([#11567](https://github.com/netdata/netdata/issues/11567))
- Add proc_uptime charts info ([#11569](https://github.com/netdata/netdata/issues/11569))
- Add shared memory to cgroup ([#11559](https://github.com/netdata/netdata/issues/11559))
- Add DShreve2 to code owners ([#11572](https://github.com/netdata/netdata/issues/11572))
- Add missing privilege to fix MySQL slave reporting ([#11574](https://github.com/netdata/netdata/issues/11574))
- Update alarms info ([#11481](https://github.com/netdata/netdata/issues/11481))
- Clean up YAML files in the repository. ([#11570](https://github.com/netdata/netdata/issues/11570))
- Add archive uploads for dist, package build, and static build checks. ([#11534](https://github.com/netdata/netdata/issues/11534))
- Fix handling of claiming in kickstart script when running as non-root. ([#11507](https://github.com/netdata/netdata/issues/11507))
- Add proc_softirqs charts info ([#11577](https://github.com/netdata/netdata/issues/11577))
- Sorting the Postgres cluster databases in the postgres collector ([#11580](https://github.com/netdata/netdata/issues/11580))
- Add proc_net_stat_conntrack charts info ([#11576](https://github.com/netdata/netdata/issues/11576))
- Fix CID 339027 and reverse arguments ([#11578](https://github.com/netdata/netdata/issues/11578))
- Add proc_net_stat_synproxy charts info ([#11581](https://github.com/netdata/netdata/issues/11581))
- Remove unused synproxy chart ([#11582](https://github.com/netdata/netdata/issues/11582))
- Free analytics data when analytics thread stops ([#11575](https://github.com/netdata/netdata/issues/11575))
- Remove OpenSUSE Tumbleweed from CI. ([#11584](https://github.com/netdata/netdata/issues/11584))
- Add proc_stat charts info ([#11586](https://github.com/netdata/netdata/issues/11586))
- EBPF Shared Memory system call tracking ([#11560](https://github.com/netdata/netdata/issues/11560))
- Add sys_devices_system_edac_mc charts info ([#11589](https://github.com/netdata/netdata/issues/11589))
- Adds api/v1/aclk call to webserver ([#11588](https://github.com/netdata/netdata/issues/11588))
- Update dashboard to version v2.20.2. ([#11593](https://github.com/netdata/netdata/issues/11593))
- Makes New Cloud architecture optional for ACLK-NG ([#11587](https://github.com/netdata/netdata/issues/11587))
- Add sys_kernel_mm_ksm charts info ([#11595](https://github.com/netdata/netdata/issues/11595))
- Update global code owners ([#11562](https://github.com/netdata/netdata/issues/11562))
- Add proc_vmstat charts info ([#11597](https://github.com/netdata/netdata/issues/11597))
- Integrate eBPF and cgroup (consumer side) ([#11573](https://github.com/netdata/netdata/issues/11573))
- Add apps.plugin charts descriptions ([#11601](https://github.com/netdata/netdata/issues/11601))
- Fix varnish VBE parsing ([#11596](https://github.com/netdata/netdata/issues/11596))
- Fix https client  ([#11608](https://github.com/netdata/netdata/issues/11608))
- Add cgroups.plugin charts descriptions ([#11607](https://github.com/netdata/netdata/issues/11607))
- Apps: disable reporting min/avg/max group uptime by default ([#11609](https://github.com/netdata/netdata/issues/11609))
- Added ARM binary package builds to CI. ([#10769](https://github.com/netdata/netdata/issues/10769))
- Fix RSS memory counter for systemd services ([#11616](https://github.com/netdata/netdata/issues/11616))
- Fix swap size calculation for cgroups ([#11617](https://github.com/netdata/netdata/issues/11617))
- Add @iigorkarpov to CODEOWNERS. ([#11614](https://github.com/netdata/netdata/issues/11614))
- Add sys_class_power_supply charts info ([#11619](https://github.com/netdata/netdata/issues/11619))
- Add cgroups.plugin systemd units charts info ([#11618](https://github.com/netdata/netdata/issues/11618))
- Fix proc nfsd "proc4ops" chart family ([#11623](https://github.com/netdata/netdata/issues/11623))
- Add proc_net_wireless charts info ([#11626](https://github.com/netdata/netdata/issues/11626))
- Initialize write_ctx struct with zeroes ([#11621](https://github.com/netdata/netdata/issues/11621))
- Add proc_net_rpc_nfs and nfsd charts info ([#11625](https://github.com/netdata/netdata/issues/11625))
- Add proc_pagetypeinfo charts info ([#11627](https://github.com/netdata/netdata/issues/11627))
- Enable additional functionality for the new cloud architecture ([#11579](https://github.com/netdata/netdata/issues/11579))
- Add sys_class_infiniband charts info ([#11628](https://github.com/netdata/netdata/issues/11628))
- Fix memory leak ([#11631](https://github.com/netdata/netdata/issues/11631))
- Fix nfsd RPC metrics and remove unused nfsd charts and metrics ([#11632](https://github.com/netdata/netdata/issues/11632))
- Update dashboard to version v2.20.7. ([#11629](https://github.com/netdata/netdata/issues/11629))
- Add timex.plugin charts info ([#11635](https://github.com/netdata/netdata/issues/11635))
- Add proc zfs charts info ([#11630](https://github.com/netdata/netdata/issues/11630))
- EBPF and cgroup (process, file descriptor, VFS, directory cache and OOMkill) ([#11611](https://github.com/netdata/netdata/issues/11611))
- Fix an overflow when unsigned integer subtracted ([#11638](https://github.com/netdata/netdata/issues/11638))
- Fix ci dashboard pr branch name ([#11636](https://github.com/netdata/netdata/issues/11636))
- Various fixes and updates for dashboard info ([#11639](https://github.com/netdata/netdata/issues/11639))
- Add note for the new release of charts on the cloud ([#11637](https://github.com/netdata/netdata/issues/11637))
- Fix chart config overflow ([#11645](https://github.com/netdata/netdata/issues/11645))
- Fixes typo in URL ([#11651](https://github.com/netdata/netdata/issues/11651))
- Use submodules in Clang build checks. ([#11649](https://github.com/netdata/netdata/issues/11649))
- Add initial implementation of new kickstart script. ([#11493](https://github.com/netdata/netdata/issues/11493))
- Add POWER8+ support to our official Docker images. ([#11592](https://github.com/netdata/netdata/issues/11592))
- Added static builds for ARMv7l and ARMv8a ([#11490](https://github.com/netdata/netdata/issues/11490))
- Restructure review check CI to properly show jobs as skipped. ([#11553](https://github.com/netdata/netdata/issues/11553))
- EBPF cgroup integration ([#11642](https://github.com/netdata/netdata/issues/11642))
- Update optional parameters for upcoming installer. ([#11604](https://github.com/netdata/netdata/issues/11604))
- Add concurency limits on GHA workflows. ([#11656](https://github.com/netdata/netdata/issues/11656))
- Fix build issue related to legacy aclk and new arch code ([#11655](https://github.com/netdata/netdata/issues/11655))
- Adds new alarm status protocol messages ([#11612](https://github.com/netdata/netdata/issues/11612))
- Update dashboard to version v2.20.9. ([#11661](https://github.com/netdata/netdata/issues/11661))
- Migrated release build process from Travis CI to GitHub Actions. ([#11055](https://github.com/netdata/netdata/issues/11055))
- Add Ubuntu 21.10 to CI. ([#11585](https://github.com/netdata/netdata/issues/11585))
- Fix file name typos in Travis config from #11055 ([#11667](https://github.com/netdata/netdata/issues/11667))
- Revert "Update alarms info" ([#11633](https://github.com/netdata/netdata/issues/11633))
- Fix swap_used alarm calc ([#11672](https://github.com/netdata/netdata/issues/11672))
- EBPF process (collector improvements) ([#11643](https://github.com/netdata/netdata/issues/11643))
- Bump google-github-actions/upload-cloud-storage from 0.2.1 to 0.4.0 ([#11671](https://github.com/netdata/netdata/issues/11671))
- Fix interval usage and reduce I/O ([#11662](https://github.com/netdata/netdata/issues/11662))
- Fix line arguments (eBPF) ([#11670](https://github.com/netdata/netdata/issues/11670))
- Add snapshot message and calls to sql_queue_removed_alerts_to_aclk ([#11664](https://github.com/netdata/netdata/issues/11664))
- Fix permissions for artifact build CI. ([#11673](https://github.com/netdata/netdata/issues/11673))
- Optimize static build and update various dependencies. ([#11660](https://github.com/netdata/netdata/issues/11660))
- Explicitly opt out of LTO in RPM builds. ([#11644](https://github.com/netdata/netdata/issues/11644))
- Add flag to mark containers as created from official images in analytics. ([#11606](https://github.com/netdata/netdata/issues/11606))
- Mark unmaintained tests as expected failures. ([#11657](https://github.com/netdata/netdata/issues/11657))
- Mark g++ for freebsd as NOTREQUIRED ([#11678](https://github.com/netdata/netdata/issues/11678))
- New eBPF and libbpf releases ([#11680](https://github.com/netdata/netdata/issues/11680))
- Fix typo in release build workflow. ([#11686](https://github.com/netdata/netdata/issues/11686))
- Fix "lsns: unknown column" logging in cgroup-network-helper script ([#11687](https://github.com/netdata/netdata/issues/11687))
- Update pfsense.md ([#11674](https://github.com/netdata/netdata/issues/11674))
- Ci: remove concurrency for labeler ([#11691](https://github.com/netdata/netdata/issues/11691))
- Fix handling of disabling telemetry in static builds. ([#11689](https://github.com/netdata/netdata/issues/11689))
- Postgres collector: Fix crash the wal query if wal-file was removed concurrently ([#11697](https://github.com/netdata/netdata/issues/11697))
- Fix yet another typo in the release build CI. ([#11698](https://github.com/netdata/netdata/issues/11698))
- Charts 2.0 - fix broken link ([#11701](https://github.com/netdata/netdata/issues/11701))
- Fix bug in http client ([#11650](https://github.com/netdata/netdata/issues/11650))
- Updater: don't use api.github.com when checking for latest stable version ([#11700](https://github.com/netdata/netdata/issues/11700))
- Fix libbpf handling in RPM builds. ([#11702](https://github.com/netdata/netdata/issues/11702))
- Fix coverity issues 373612 & 373611 ([#11684](https://github.com/netdata/netdata/issues/11684))
- Fix warnings from -Wformat-truncation=2 ([#11676](https://github.com/netdata/netdata/issues/11676))
- Reuse the SN_EXISTS bit to track anomaly status. ([#11154](https://github.com/netdata/netdata/issues/11154))
- Fix handling of artifacts in release build workflow. ([#11705](https://github.com/netdata/netdata/issues/11705))
- Ebpf doc ([#11703](https://github.com/netdata/netdata/issues/11703))
- Fix kickstart.md Installation Guide Links ([#11708](https://github.com/netdata/netdata/issues/11708))
- EBPF mdflush ([#11681](https://github.com/netdata/netdata/issues/11681))
- Stream chart labels ([#11675](https://github.com/netdata/netdata/issues/11675))
- Queue removed alerts to cloud for new architecture ([#11704](https://github.com/netdata/netdata/issues/11704))
- Fix artifact consolidation in release build. ([#11712](https://github.com/netdata/netdata/issues/11712))
- Add support for local builds to the new kickstart script. ([#11654](https://github.com/netdata/netdata/issues/11654))
- Add sensors to charts.d.conf and add a note how to enable it ([#11715](https://github.com/netdata/netdata/issues/11715))
- Fix artifact handling for release artifact uploads. ([#11717](https://github.com/netdata/netdata/issues/11717))
- Update README.md ([#11714](https://github.com/netdata/netdata/issues/11714))
- Adding (eBPF) to submenu ([#11721](https://github.com/netdata/netdata/issues/11721))
- Anomaly Detection MVP ([#11548](https://github.com/netdata/netdata/issues/11548))
- Fix handling of artifacts for nightlies and release builds. ([#11725](https://github.com/netdata/netdata/issues/11725))
- Fix handling of distfile links in release/nightly builds. ([#11726](https://github.com/netdata/netdata/issues/11726))
- Updating Docker Node Instructions for Clarity ([#11713](https://github.com/netdata/netdata/issues/11713))
- Update README.md ([#11728](https://github.com/netdata/netdata/issues/11728))
- Fixing Link to New Charts ([#11729](https://github.com/netdata/netdata/issues/11729))
- Add log grouping in installer and static build code when running under GitHub Actions. ([#11720](https://github.com/netdata/netdata/issues/11720))
- Make package builds more resilient against network issues. ([#11731](https://github.com/netdata/netdata/issues/11731))
- Bring eBPF to static binaries ([#11709](https://github.com/netdata/netdata/issues/11709))
- Move initial snapshot_proto generation inside the loop ([#11719](https://github.com/netdata/netdata/issues/11719))
- Fix ACLK online chart ([#11734](https://github.com/netdata/netdata/issues/11734))
- Fix typo in aclk_query.c ([#11737](https://github.com/netdata/netdata/issues/11737))
- Remove Alpine 3.11 from CI. ([#11598](https://github.com/netdata/netdata/issues/11598))
- Add @maneamarius to CODEOWNERS. ([#11740](https://github.com/netdata/netdata/issues/11740))
- Only add comma in api/v1/info if ml-info is going to be printed ([#11739](https://github.com/netdata/netdata/issues/11739))
- Update jQuery Dependency ([#11710](https://github.com/netdata/netdata/issues/11710))
- Disable C++ warnings from dlib library. ([#11738](https://github.com/netdata/netdata/issues/11738))
- Minor - fix typo popocorn->popcorn ([#11745](https://github.com/netdata/netdata/issues/11745))
- Add Fedora 35 to CI. ([#11641](https://github.com/netdata/netdata/issues/11641))
- Add *.mdx to labeler config ([#11748](https://github.com/netdata/netdata/issues/11748))
- Teach GH about ML label and its code owners. ([#11750](https://github.com/netdata/netdata/issues/11750))
- Improve the ACLK sync process for the new cloud architecture ([#11744](https://github.com/netdata/netdata/issues/11744))
- Update eBPF documentation ([#11741](https://github.com/netdata/netdata/issues/11741))
- Update dashboard to version v2.20.11. ([#11743](https://github.com/netdata/netdata/issues/11743))
- Update enable-streaming.mdx ([#11747](https://github.com/netdata/netdata/issues/11747))
- Add basic telemetry to the new kickstart script. ([#11718](https://github.com/netdata/netdata/issues/11718))
- Sanely handle installing on systems with limited RAM. ([#11658](https://github.com/netdata/netdata/issues/11658))
- Dont extend popcorn timer for children ([#11758](https://github.com/netdata/netdata/issues/11758))
- Add exit points to ACLK-NG ([#11751](https://github.com/netdata/netdata/issues/11751))
- Fix (cgroups.plugin): containers name resolution for crio/containerd cri ([#11756](https://github.com/netdata/netdata/issues/11756))
- Add SSL_MODE_ENABLE_PARTIAL_WRITE to netdata_srv_ctx ([#11754](https://github.com/netdata/netdata/issues/11754))
- Fix retention messages ([#11762](https://github.com/netdata/netdata/issues/11762))
- Add protobuf to `-W buildinfo` output. ([#11634](https://github.com/netdata/netdata/issues/11634))
- Minor improvement to CPU number function regarding macOS. ([#11746](https://github.com/netdata/netdata/issues/11746))
- Update eBPF documenation (Filesystem and HardIRQ) ([#11752](https://github.com/netdata/netdata/issues/11752))
- Fix log if D_ACLK is used ([#11763](https://github.com/netdata/netdata/issues/11763))
- Implements cloud initiated disconnect command ([#11723](https://github.com/netdata/netdata/issues/11723))
- Show stats for protected mount points in diskspace plugin ([#11767](https://github.com/netdata/netdata/issues/11767))
- Store and submit dimension delete messages for new cloud architecture ([#11765](https://github.com/netdata/netdata/issues/11765))
- Fix host hop count reported to the cloud ([#11768](https://github.com/netdata/netdata/issues/11768))
- Update netdata-security.md ([#11772](https://github.com/netdata/netdata/issues/11772))
- Fix link to new charts. ([#11773](https://github.com/netdata/netdata/issues/11773))
- Skip sending hidden dimensions via ACLK ([#11770](https://github.com/netdata/netdata/issues/11770))
- Remove feature flag and commented out code ([#11774](https://github.com/netdata/netdata/issues/11774))
- Announce proto capability and enable if cloud supports ([#11476](https://github.com/netdata/netdata/issues/11476))
- Insert into aclk_alert instead of queuing ([#11769](https://github.com/netdata/netdata/issues/11769))
- Temporary fix for cgroup renaming ([#11775](https://github.com/netdata/netdata/issues/11775))
- Add command for new health entity file. ([#11733](https://github.com/netdata/netdata/issues/11733))
- Add nightly release version to readme ([#11780](https://github.com/netdata/netdata/issues/11780))
- Fix proc/interrupts parser ([#11783](https://github.com/netdata/netdata/issues/11783))
- Packaging: update go.d.plugin version to v0.31.0 ([#11789](https://github.com/netdata/netdata/issues/11789))
- Removing dated contact suggestion. ([#11732](https://github.com/netdata/netdata/issues/11732))
- Adding parenthesis ([#11766](https://github.com/netdata/netdata/issues/11766))
- Overhaul build CI. ([#11699](https://github.com/netdata/netdata/issues/11699))
- Fix typos ([#11782](https://github.com/netdata/netdata/issues/11782))
- Create directory structure for splitting out install-required-packages.sh ([#11790](https://github.com/netdata/netdata/issues/11790))
- Verify checksums of makeself deps. ([#11791](https://github.com/netdata/netdata/issues/11791))
- Fix the new static archive verification job. ([#11792](https://github.com/netdata/netdata/issues/11792))
- Delete from aclk alerts table if ack'ed from cloud one day ago ([#11779](https://github.com/netdata/netdata/issues/11779))
- Use correct hop count if host is already in memory ([#11785](https://github.com/netdata/netdata/issues/11785))
- Add Oracle Linux 8 to CI and package builds. ([#11776](https://github.com/netdata/netdata/issues/11776))
- Use the proper format specifier when logging configuration options. ([#11795](https://github.com/netdata/netdata/issues/11795))
- Assorted cleanups to static builds. ([#11798](https://github.com/netdata/netdata/issues/11798))
- Update libbpf ([#11800](https://github.com/netdata/netdata/issues/11800))
- Add some logging for cloud new architecture to access.log ([#11788](https://github.com/netdata/netdata/issues/11788))
- Add POWER8+ static builds. ([#11802](https://github.com/netdata/netdata/issues/11802))
- Always queue alerts to aclk_alert ([#11806](https://github.com/netdata/netdata/issues/11806))
- Update interact-charts.mdx ([#11808](https://github.com/netdata/netdata/issues/11808))
- Fix coverity issues  ([#11809](https://github.com/netdata/netdata/issues/11809))
- Cleanup compilation warnings ([#11810](https://github.com/netdata/netdata/issues/11810))
- Specify pip3 when installing git-semver package ([#11817](https://github.com/netdata/netdata/issues/11817))
- Use two digits after the decimal point for the anomaly rate. ([#11804](https://github.com/netdata/netdata/issues/11804))
- Simple fix for the data API query ([#11787](https://github.com/netdata/netdata/issues/11787))
- Δont use wc στρθψτ if it may not exist ([#11820](https://github.com/netdata/netdata/issues/11820))
- Add kickoke to docs codeowners ([#11824](https://github.com/netdata/netdata/issues/11824))
- Set NETDATA_CONTAINER_OS_DETECTION to system_info->container_os_detection ([#11827](https://github.com/netdata/netdata/issues/11827))
- Feat(apps.plugin): add aws to apps_groups.conf ([#11826](https://github.com/netdata/netdata/issues/11826))
- Add a note about pkg-config file location for freeipmi ([#11831](https://github.com/netdata/netdata/issues/11831))
- Add commands to check and fix database corruption ([#11828](https://github.com/netdata/netdata/issues/11828))
- Remove pihole_blocked_queries alert ([#11829](https://github.com/netdata/netdata/issues/11829))
- Updating ansible steps for clarity ([#11823](https://github.com/netdata/netdata/issues/11823))
- Feat(apps.plugin): add consul to apps_groups.conf ([#11839](https://github.com/netdata/netdata/issues/11839))
- Fix alarms info ([#11844](https://github.com/netdata/netdata/issues/11844))
- Proto optional fix ([#11840](https://github.com/netdata/netdata/issues/11840))
- [netdata minor release] v1.32.0

## [1.31.0] - 2021-05-19

### Merged Pull Requests:

- Add lists of monitored metrics to the cgroups plugin documentation ([#10924](https://github.com/netdata/netdata/issues/10924))
- Add a chart for out of memory kills ([#10880](https://github.com/netdata/netdata/issues/10880))
- Add new charts for extended disk metrics ([#10939](https://github.com/netdata/netdata/issues/10939))
- Add a plugin for the system clock synchronization state ([#10895](https://github.com/netdata/netdata/issues/10895))
- Health: add Inconsistent state to the mysql_galera_cluster_state alarm ([#10945](https://github.com/netdata/netdata/issues/10945))
- Add a metric for percpu memory ([#10964](https://github.com/netdata/netdata/issues/10964))
- Fix epbf crash when process exit ([#10957](https://github.com/netdata/netdata/issues/10957))
- Update cloud-providers.md ([#10942](https://github.com/netdata/netdata/issues/10942))
- Spelling build ([#10909](https://github.com/netdata/netdata/issues/10909))
- Spelling exporting ([#10915](https://github.com/netdata/netdata/issues/10915))
- Spelling health ([#10916](https://github.com/netdata/netdata/issues/10916))
- Spelling libnetdata ([#10917](https://github.com/netdata/netdata/issues/10917))
- Spelling tests ([#10920](https://github.com/netdata/netdata/issues/10920))
- Spelling aclk ([#10910](https://github.com/netdata/netdata/issues/10910))
- Spelling: backend ([#10911](https://github.com/netdata/netdata/issues/10911))
- Spelling daemon ([#10913](https://github.com/netdata/netdata/issues/10913))
- Spelling database ([#10914](https://github.com/netdata/netdata/issues/10914))
- Spelling: bidirectional ([#10918](https://github.com/netdata/netdata/issues/10918))
- Spelling streaming ([#10919](https://github.com/netdata/netdata/issues/10919))
- Spelling web gui ([#10922](https://github.com/netdata/netdata/issues/10922))
- Spelling collectors ([#10912](https://github.com/netdata/netdata/issues/10912))
- Add --recursive to docu ([#10932](https://github.com/netdata/netdata/issues/10932))
- Health: add synchronization.conf to the Makefile ([#10907](https://github.com/netdata/netdata/issues/10907))
- Health: add systemdunits alarms ([#10906](https://github.com/netdata/netdata/issues/10906))
- Web/gui: add systemdunits info to the dashboard_info.js ([#10904](https://github.com/netdata/netdata/issues/10904))
- Spelling web api server ([#10921](https://github.com/netdata/netdata/issues/10921))
- Remove RewriteEngine for dedicated vHost ([#10873](https://github.com/netdata/netdata/issues/10873))
- Fix formatting and wording in the Running-behind-apache guide ([#8706](https://github.com/netdata/netdata/issues/8706))
- Health: fix alarm line options syntax in the docs ([#10974](https://github.com/netdata/netdata/issues/10974))
- Bump actions/upload-artifact from v2.2.2 to v2.2.3 ([#10959](https://github.com/netdata/netdata/issues/10959))
- Fix uil in statsd guide ([#10975](https://github.com/netdata/netdata/issues/10975))
- Nvidia-smi: update README.md ([#10214](https://github.com/netdata/netdata/issues/10214))
- Add docs on Nginx with IPv6 listen for certbot to work ([#10473](https://github.com/netdata/netdata/issues/10473))
- Python.d(smartd_log): collect attribute 249 -- NAND Writes 1GiB ([#10872](https://github.com/netdata/netdata/issues/10872))
- Replace references to Google Analytics with Posthog where relevant ([#10868](https://github.com/netdata/netdata/issues/10868))
- Collectors/charts.d/opensips: fix detection of `opensipsctl` executable ([#10978](https://github.com/netdata/netdata/issues/10978))
- Update fping version ([#10977](https://github.com/netdata/netdata/issues/10977))
- Fine tune clang-format ([#7271](https://github.com/netdata/netdata/issues/7271))
- Upgrade OKay repository RPM for RHEL8 ([#10973](https://github.com/netdata/netdata/issues/10973))
- Improvements to dash-example.html ([#10870](https://github.com/netdata/netdata/issues/10870))
- Remove error message on netdata restart ([#8685](https://github.com/netdata/netdata/issues/8685))
- Contributing revamp, take 2 ([#10956](https://github.com/netdata/netdata/issues/10956))
- Remove condition that was creating gaps on cachestat ([#10972](https://github.com/netdata/netdata/issues/10972))
- Assorted fixes for Travis CI code. ([#10981](https://github.com/netdata/netdata/issues/10981))
- Update eBPF documentation ([#10982](https://github.com/netdata/netdata/issues/10982))
- Bring flexible adjust for eBPF hash tables ([#10962](https://github.com/netdata/netdata/issues/10962))
- Update web server options for respecting browser DNT ([#10157](https://github.com/netdata/netdata/issues/10157))
- Remove obsolete docs ([#10979](https://github.com/netdata/netdata/issues/10979))
- Implements new https client for ACLK ([#10805](https://github.com/netdata/netdata/issues/10805))
- Move global stats to a separate thread ([#10991](https://github.com/netdata/netdata/issues/10991))
- Implements ACLK env endpoint ([#10833](https://github.com/netdata/netdata/issues/10833))
- Fix MQTT connection on OTP fail ([#10839](https://github.com/netdata/netdata/issues/10839))
- Add missing SPDX ([#10990](https://github.com/netdata/netdata/issues/10990))
- Add a chart with netdata uptime ([#10997](https://github.com/netdata/netdata/issues/10997))
- Provide new attributes in health conf files ([#10961](https://github.com/netdata/netdata/issues/10961))
- Ci: fix aws-kinesis builds ([#10992](https://github.com/netdata/netdata/issues/10992))
- Backend chart filtering backward compatibility fix ([#11002](https://github.com/netdata/netdata/issues/11002))
- Msteams 2 ([#9905](https://github.com/netdata/netdata/issues/9905))
- Python.d: add plugin and module names to the runtime charts ([#11007](https://github.com/netdata/netdata/issues/11007))
- ACLK Passwd endpoint update ([#10859](https://github.com/netdata/netdata/issues/10859))
- Remove vneg from ACLK-NG ([#10980](https://github.com/netdata/netdata/issues/10980))
- Provide more agent analytics to posthog ([#10887](https://github.com/netdata/netdata/issues/10887))
- Allow the remote write configuration have multiple destinations ([#11005](https://github.com/netdata/netdata/issues/11005))
- Revert "Provide more agent analytics to posthog ([#10887](https://github.com/netdata/netdata/issues/10887))" ([#11011](https://github.com/netdata/netdata/issues/11011))
- Improvements to anomalies collector following dogfooding ([#11003](https://github.com/netdata/netdata/issues/11003))
- Persist claim ids in local database for parent and children ([#10993](https://github.com/netdata/netdata/issues/10993))
- [area/collectors] Added support for libvirtd LXC containers to the `cgroup-name.sh` cgroup name normalization script ([#11006](https://github.com/netdata/netdata/issues/11006))
- Anonymous-statistics: add a timeout when using `curl` ([#11010](https://github.com/netdata/netdata/issues/11010))
- Improve get started/installation docs ([#10995](https://github.com/netdata/netdata/issues/10995))
- Report porcelain output ([#10494](https://github.com/netdata/netdata/issues/10494))
- Rename struct fields from class to classification. ([#11019](https://github.com/netdata/netdata/issues/11019))
- ACLK new cloud architecture new TBEB ([#10941](https://github.com/netdata/netdata/issues/10941))
- Bump to netdata-pandas==0.0.38 ([#11022](https://github.com/netdata/netdata/issues/11022))
- Proc/mdstat: add raid level to the family ([#11024](https://github.com/netdata/netdata/issues/11024))
- Store null claim id in the database for non claimed children ([#11036](https://github.com/netdata/netdata/issues/11036))
- Health/vernemq: use `average` instead of  `sum` ([#11037](https://github.com/netdata/netdata/issues/11037))
- Remove links to old install doc ([#11014](https://github.com/netdata/netdata/issues/11014))
- Zscores python collector ([#10673](https://github.com/netdata/netdata/issues/10673))
- Provide more agent analytics to posthog ([#11020](https://github.com/netdata/netdata/issues/11020))
- K6 quality of life updates ([#10985](https://github.com/netdata/netdata/issues/10985))
- Dashboard version 2.17.0 ([#10856](https://github.com/netdata/netdata/issues/10856))
- Create ebpf.d directory in PLUGINDIR for debian packages(netdata#11017) ([#11031](https://github.com/netdata/netdata/issues/11031))
- Load names ([#11034](https://github.com/netdata/netdata/issues/11034))
- Remove dots in cgroup ids ([#11050](https://github.com/netdata/netdata/issues/11050))
- Add python changefinder collector ([#10672](https://github.com/netdata/netdata/issues/10672))
- Add `charts` to templates ([#11054](https://github.com/netdata/netdata/issues/11054))
- Fix coverity issue (CID 370510) #11060
- Limit maximum concurrent CI jobs to avoid blocking other CI. ([#11057](https://github.com/netdata/netdata/issues/11057))
- Add Third-party collector: nextcloud plugin ([#11032](https://github.com/netdata/netdata/issues/11032))
- Overhaul streaming documentation ([#10709](https://github.com/netdata/netdata/issues/10709))
- Improve dashboard documentation (part 1) ([#11015](https://github.com/netdata/netdata/issues/11015))
- Add documentation for claiming during kickstart installation ([#11052](https://github.com/netdata/netdata/issues/11052))
- Add functionality to store node_id for a host ([#11059](https://github.com/netdata/netdata/issues/11059))
- Change_cahestat_type: Change apps chart type to improve chart visualization and give more meaninful information ([#11074](https://github.com/netdata/netdata/issues/11074))
- Ebpf directory cache ([#10855](https://github.com/netdata/netdata/issues/10855))
- Fix typo ([#11082](https://github.com/netdata/netdata/issues/11082))
- Health: clarify which health configuration entities are required / optional ([#11086](https://github.com/netdata/netdata/issues/11086))
- Reduce info logging ([#11091](https://github.com/netdata/netdata/issues/11091))
- Fix SSL random failures when using multithreaded web server with OpenSSL < 1.1.0 ([#11089](https://github.com/netdata/netdata/issues/11089))
- Netdata-installer.sh: Enable IPv6 support in libwebsockets ([#11079](https://github.com/netdata/netdata/issues/11079)) ([#11080](https://github.com/netdata/netdata/issues/11080))
- Add an event when an incomplete agent shutdown is detected #11078
- Improve dashboard documentation (part 2) ([#11065](https://github.com/netdata/netdata/issues/11065))
- Add a module for ZFS pool state ([#11071](https://github.com/netdata/netdata/issues/11071))
- Cgroups: fix network interfaces detection when using `virsh` ([#11096](https://github.com/netdata/netdata/issues/11096))
- Improve installation method for Alpine ([#11035](https://github.com/netdata/netdata/issues/11035))
- Don't repeat the cgroup discovery cleanup info message ([#11101](https://github.com/netdata/netdata/issues/11101))
- Add host_cloud_enabled attribute to analytics ([#11100](https://github.com/netdata/netdata/issues/11100))
- Aclk/legacy: change aclk statistics charts units from kB/s to KiB/s ([#11103](https://github.com/netdata/netdata/issues/11103))
- Check the version of the default cgroup mountpoint ([#11102](https://github.com/netdata/netdata/issues/11102))
- Packaging: update go.d.plugin version to v0.28.2 ([#11104](https://github.com/netdata/netdata/issues/11104))
- Add a workflow to generate version bump PRs for the dashboard. ([#11076](https://github.com/netdata/netdata/issues/11076))
- Build mqtt_websockets with netdata autotools ([#11083](https://github.com/netdata/netdata/issues/11083))
- Minor -fixes typo in ACLK-NG ([#11107](https://github.com/netdata/netdata/issues/11107))
- Support mulitple jobs in make(1) when building LWS. ([#10799](https://github.com/netdata/netdata/issues/10799))
- Updates mqtt_websockets ([#11105](https://github.com/netdata/netdata/issues/11105))
- Check configuration for CUSTOM and MSTEAM ([#11113](https://github.com/netdata/netdata/issues/11113))
- Analytics: reduce alarms notifications dump logging ([#11116](https://github.com/netdata/netdata/issues/11116))
- Automatically trigger Helmchart PR on agent release. ([#11084](https://github.com/netdata/netdata/issues/11084))
- Remove dash-example, place in community repo ([#11077](https://github.com/netdata/netdata/issues/11077))
- Fix broken link in doc ([#11122](https://github.com/netdata/netdata/issues/11122))
- Fix broken links in various docs ([#11109](https://github.com/netdata/netdata/issues/11109))
- Update k6.md ([#11127](https://github.com/netdata/netdata/issues/11127))
- Reduce the number of ACLK chart updates during chart obsoletion ([#11133](https://github.com/netdata/netdata/issues/11133))
- Use size_t instead of int for vfs_bufspace_count in FreeBSD plugin ([#11142](https://github.com/netdata/netdata/issues/11142))
- Bundle the react dashboard code into the agent repo directly. ([#11139](https://github.com/netdata/netdata/issues/11139))
- Update performance.md ([#11144](https://github.com/netdata/netdata/issues/11144))
- Fix broken link ([#11148](https://github.com/netdata/netdata/issues/11148))
- Init new files and create connections ([#11099](https://github.com/netdata/netdata/issues/11099))
- Add sections for class, component and type. ([#10984](https://github.com/netdata/netdata/issues/10984))
- [netdata minor release] v1.31.0

## [1.30.1] - 2021-04-12

### Merged Pull Requests:

- Fixed bundling of ACLK-NG components in dist tarballs. ([#10894](https://github.com/netdata/netdata/issues/10894))
- Properly handle binary package reuplods. ([#10878](https://github.com/netdata/netdata/issues/10878))
- Spelling build ([#10428](https://github.com/netdata/netdata/issues/10428))
- Bump version of OpenSSL bundled in static builds to 1.1.1k ([#10884](https://github.com/netdata/netdata/issues/10884))
- Add libzstd-dev ([#10925](https://github.com/netdata/netdata/issues/10925))
- Update news and GIF in README, fix typo ([#10900](https://github.com/netdata/netdata/issues/10900))
- Update README.md ([#10898](https://github.com/netdata/netdata/issues/10898))
- Fix incorrect health log entries ([#10822](https://github.com/netdata/netdata/issues/10822))
- Update CODEOWNERS ([#10928](https://github.com/netdata/netdata/issues/10928))
- Fix memory corruption issue when executing context queries in RAM/SAVE memory mode ([#10933](https://github.com/netdata/netdata/issues/10933))
- Add a CRASH event when the agent fails to properly shutdown ([#10893](https://github.com/netdata/netdata/issues/10893))
- Don’t use glob expansion in argument to `cd` in updater. ([#10936](https://github.com/netdata/netdata/issues/10936))
- [netdata patch release] v1.30.1

## [1.30.0] - 2021-03-31

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Update screenshots and text for new Cloud nav ([#10664](https://github.com/netdata/netdata/issues/10664))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Fix broken links in active alarms doc ([#10678](https://github.com/netdata/netdata/issues/10678))
- Try to keep all pages from extents read from disk in the cache. ([#10558](https://github.com/netdata/netdata/issues/10558))
- Improve the Kubernetes deployment documentation ([#10662](https://github.com/netdata/netdata/issues/10662))
- Remove unreachable #else directives in plugins. ([#10523](https://github.com/netdata/netdata/issues/10523))
- Cpu stats per query thread ([#10634](https://github.com/netdata/netdata/issues/10634))
- Installer: update go.d.plugin version to v0.28.0 ([#10660](https://github.com/netdata/netdata/issues/10660))
- Don't add duplicate _total suffixes for the prometheus go.d module ([#10674](https://github.com/netdata/netdata/issues/10674))
- Web/gui: Fix broken external links ([#10586](https://github.com/netdata/netdata/issues/10586))
- Fix a typo in the email notifications readme ([#10668](https://github.com/netdata/netdata/issues/10668))
- Revamp statsd docs ([#10637](https://github.com/netdata/netdata/issues/10637))
- Ebpf support new collectors ([#10680](https://github.com/netdata/netdata/issues/10680))
- Add ACLK stats per cloud query type ([#10602](https://github.com/netdata/netdata/issues/10602))
- Increases ACLK TBEB randomness ([#10373](https://github.com/netdata/netdata/issues/10373))
- Add support for changing the number of pages per extent dynamically during runtime. ([#10593](https://github.com/netdata/netdata/issues/10593))
- Add new cookie to fix 8094 ([#10676](https://github.com/netdata/netdata/issues/10676))
- Update_kernel_version
- Fix disk utilization and backlog charts ([#10705](https://github.com/netdata/netdata/issues/10705))
- Add noauthcodecheck workaround flag to the freeipmi plugin ([#10701](https://github.com/netdata/netdata/issues/10701))
- Add Linux page cache metrics to eBPF ([#10693](https://github.com/netdata/netdata/issues/10693))
- Change all refs from service to systemctl ([#10703](https://github.com/netdata/netdata/issues/10703))
- Add a new workflow to test that updater works as expected ([#10599](https://github.com/netdata/netdata/issues/10599))
- New version eBPF programs. ([#10707](https://github.com/netdata/netdata/issues/10707))
- Changed Docker image tagging to use semver tags for releases. ([#10648](https://github.com/netdata/netdata/issues/10648))
- Update guide: Kubernetes monitoring with Netdata: Overview and visualizations ([#10691](https://github.com/netdata/netdata/issues/10691))
- Add JSON output option for buildinfo. ([#10706](https://github.com/netdata/netdata/issues/10706))
- Log ACLK cloud commands to access.log ([#10697](https://github.com/netdata/netdata/issues/10697))
- Python.d/smartd_log: collect attribute 233 (Media Wearout Indicator (SSD)). ([#10711](https://github.com/netdata/netdata/issues/10711))
- Add guide: LAMP stack monitoring ([#10698](https://github.com/netdata/netdata/issues/10698))
- Fix a parameter binding issue when storing chart names in the database ([#10717](https://github.com/netdata/netdata/issues/10717))
- Added support for claiming nodes as part of installation. ([#10084](https://github.com/netdata/netdata/issues/10084))
- Fix typo in backend_prometheus.c ([#10716](https://github.com/netdata/netdata/issues/10716))
- Alarms collector add alarm values ([#10675](https://github.com/netdata/netdata/issues/10675))
- Remove unused fnc warning from ACLK Legacy ([#10731](https://github.com/netdata/netdata/issues/10731))
- Add the ability to store chart labels in the database ([#10718](https://github.com/netdata/netdata/issues/10718))
- Update chart's metadata in database when it already exists during creation ([#10728](https://github.com/netdata/netdata/issues/10728))
- Health: make alarms less sensitive ([#10688](https://github.com/netdata/netdata/issues/10688))
- Fix claim behind proxy ([#10734](https://github.com/netdata/netdata/issues/10734))
- Use of out-of-line struct definitions. ([#10739](https://github.com/netdata/netdata/issues/10739))
- Use a parameter name that is not a reserved keyword in C++ ([#10738](https://github.com/netdata/netdata/issues/10738))
- Activate multidb context always when dbengine is compiled ([#10732](https://github.com/netdata/netdata/issues/10732))
- Rename struct avl to avl_element and the typedef to avl_t ([#10735](https://github.com/netdata/netdata/issues/10735))
- Collectors/apps.plugin: Add wireguard to vpn ([#10743](https://github.com/netdata/netdata/issues/10743))
- Replace GA with PostHog for backend telemetry events. ([#10636](https://github.com/netdata/netdata/issues/10636))
- Move network interface speed, duplex, and operstate variables to charts ([#10740](https://github.com/netdata/netdata/issues/10740))
- Skip C++ incompatible header in main libnetdata header ([#10737](https://github.com/netdata/netdata/issues/10737))
- Fixed detection of already claimed node in Docker images. ([#10720](https://github.com/netdata/netdata/issues/10720))
- Add state map to duplex and operstate charts ([#10752](https://github.com/netdata/netdata/issues/10752))
- Web/gui: add supervisord to the dashboard_info.js ([#10754](https://github.com/netdata/netdata/issues/10754))
- Add Working Set charts to the cgroups plugin ([#10712](https://github.com/netdata/netdata/issues/10712))
- Comment out memory mode mention in example ([#10751](https://github.com/netdata/netdata/issues/10751))
- Collectors/cgroups: fix cpuset.cpus count ([#10757](https://github.com/netdata/netdata/issues/10757))
-  Fix wrong count of paramteres ([#10564](https://github.com/netdata/netdata/issues/10564))
- Fixed handling of permissions for some plugins. ([#10490](https://github.com/netdata/netdata/issues/10490))
- Support VS Code container devenv ([#10723](https://github.com/netdata/netdata/issues/10723))
- Dashboard@v2.13.28 ([#10761](https://github.com/netdata/netdata/issues/10761))
- Docker-based packaging workflow in GitHub Actions. ([#9964](https://github.com/netdata/netdata/issues/9964))
- Fixed handling of perf.plugin capabilities. ([#10766](https://github.com/netdata/netdata/issues/10766))
- Enable metadata persistence in all memory modes ([#10742](https://github.com/netdata/netdata/issues/10742))
- Adds ACLK-NG as fallback([#10315](https://github.com/netdata/netdata/issues/10315))
- Fixed Travis config issues related to new packaging workflows. ([#10774](https://github.com/netdata/netdata/issues/10774))
- Add guide: Unsupervised anomaly detection for Raspberry Pi monitoring ([#10713](https://github.com/netdata/netdata/issues/10713))
- Health: make vernemq alarms less sensitive ([#10770](https://github.com/netdata/netdata/issues/10770))
- Health/: fix various alarms critical and warning thresholds hysteresis ([#10779](https://github.com/netdata/netdata/issues/10779))
- Fix typo in dashboard_info.js ([#10775](https://github.com/netdata/netdata/issues/10775))
- Web/gui: add max value to the nvidia_smi.fan_speed gauge ([#10780](https://github.com/netdata/netdata/issues/10780))
- Add k6.conf ([#10733](https://github.com/netdata/netdata/issues/10733))
- Health: add `wmi_` prefix to the wmi collector network alarms ([#10782](https://github.com/netdata/netdata/issues/10782))
- Add a dump_methods parameter to alarm-notify.sh.in ([#10772](https://github.com/netdata/netdata/issues/10772))
- Add processes and move clamav ([#9313](https://github.com/netdata/netdata/issues/9313))
- Adds _aclk_impl label ([#10778](https://github.com/netdata/netdata/issues/10778))
- Rename abs to ABS to avoid clash with standard definitions. Fixes #10353. ([#10354](https://github.com/netdata/netdata/issues/10354))
- New thread for ebpf.plugin 
- Health: use separate packets_dropped_ratio alarms for wifi network interfaces ([#10785](https://github.com/netdata/netdata/issues/10785))
- Add Slack notifications for build failures. ([#10781](https://github.com/netdata/netdata/issues/10781))
- Add statsd guide ([#10719](https://github.com/netdata/netdata/issues/10719))
- Health: remove ram_in_swap alarm ([#10789](https://github.com/netdata/netdata/issues/10789))
- Update Coverity version so that scanning works again. ([#10794](https://github.com/netdata/netdata/issues/10794))
- Properly prepare version for binary package builds. ([#10790](https://github.com/netdata/netdata/issues/10790))
- Fix typos in GHA workflows. ([#10803](https://github.com/netdata/netdata/issues/10803))
- EBPF plugin 
- Expand what platforms we run updater CI checks on. ([#10792](https://github.com/netdata/netdata/issues/10792))
- Run the Docker CI checks unconditionally instead of only when we see changes. ([#10808](https://github.com/netdata/netdata/issues/10808))
- Claiming: increase curl connect-timeout and decrease number of claim attempts ([#10800](https://github.com/netdata/netdata/issues/10800))
- Fix claiming via env vars in docker container ([#10811](https://github.com/netdata/netdata/issues/10811))
- Health: exclude cgroups net ifaces from packets dropped alarms ([#10806](https://github.com/netdata/netdata/issues/10806))
- Fix eBPF compilation
- Don't show alarms for charts without data ([#10804](https://github.com/netdata/netdata/issues/10804))
- Add check for children connecting to a parent agent with unsupported memory mode ([#10787](https://github.com/netdata/netdata/issues/10787))
- Move https_client into separate file ([#10784](https://github.com/netdata/netdata/issues/10784))
- Update bug report template ([#10807](https://github.com/netdata/netdata/issues/10807))
- Fix handling of nightly and release packages in GHA workflows. ([#10819](https://github.com/netdata/netdata/issues/10819))
- Health: apply adapter_raid alarms for every logical/physical device ([#10820](https://github.com/netdata/netdata/issues/10820))
- Health: log an error if any when send email notification ([#10818](https://github.com/netdata/netdata/issues/10818))
- Add data query support for archived charts ([#10771](https://github.com/netdata/netdata/issues/10771))
- Installer: update go.d.plugin version to v0.28.1 ([#10826](https://github.com/netdata/netdata/issues/10826))
- Added Ubuntu 21.04 and Fedora 34 to our CI checks and binary package builds. ([#10791](https://github.com/netdata/netdata/issues/10791))
- Health: remove exporting_metrics_lost template ([#10829](https://github.com/netdata/netdata/issues/10829))
- Fix resource allocation management during health reload (CID 367566) ([#10813](https://github.com/netdata/netdata/issues/10813))
- Health: add collector prefix to the external collectors alarms/templates ([#10830](https://github.com/netdata/netdata/issues/10830))
- Fix broken link in StatsD guide ([#10831](https://github.com/netdata/netdata/issues/10831))
- Fix name of PackageCLoud API token secret in workflows. ([#10828](https://github.com/netdata/netdata/issues/10828))
- Health: apply megacli alarms for all adapters/physical disks ([#10834](https://github.com/netdata/netdata/issues/10834))
- Add Installation method to the bug template ([#10836](https://github.com/netdata/netdata/issues/10836))
- Add lock check to avoid shutdown when compiled with internal and locking checks ([#10835](https://github.com/netdata/netdata/issues/10835))
- Add basic failure notifications for the Coverity workflow. ([#10796](https://github.com/netdata/netdata/issues/10796))
- Adding a default job with some params and example of additional job. ([#10777](https://github.com/netdata/netdata/issues/10777))
- Properly reference the distro-ID parsing script for package uploads. ([#10840](https://github.com/netdata/netdata/issues/10840))
- Fix memory leak when archived data is requested ([#10837](https://github.com/netdata/netdata/issues/10837))
- Assorted updater fixes. ([#10613](https://github.com/netdata/netdata/issues/10613))
- Fix_repeat: Update repeat_every and avoid unecessary test ([#10846](https://github.com/netdata/netdata/issues/10846))
- Check device names in diskstats plugin ([#10843](https://github.com/netdata/netdata/issues/10843))
- Fix agent crash when executing data query with context and non-existing chart_label_key ([#10844](https://github.com/netdata/netdata/issues/10844))
- Ebpf extend sync ([#10814](https://github.com/netdata/netdata/issues/10814))
- Web/gui: make network state map sytanx consistent in the dashboard info ([#10849](https://github.com/netdata/netdata/issues/10849))
- Mqtt-c coverity fixes ([#10851](https://github.com/netdata/netdata/issues/10851))
- Add guide: Develop a custom data collector for Netdata in Python ([#10710](https://github.com/netdata/netdata/issues/10710))
- Minor - add info about --aclk-ng to netdata-installer ([#10852](https://github.com/netdata/netdata/issues/10852))
- Fix typo in main.h ([#10858](https://github.com/netdata/netdata/issues/10858))
- Fix handling of binary package uploads. ([#10860](https://github.com/netdata/netdata/issues/10860))
- Add a new parameter 'chart' to the /api/v1/alarm_log. ([#10788](https://github.com/netdata/netdata/issues/10788))
- Health: improve alarms infos ([#10853](https://github.com/netdata/netdata/issues/10853))
- Alarm(irc): add support to change IRC_PORT ([#10824](https://github.com/netdata/netdata/issues/10824))
- Remove corss-platform builds on Travis. ([#10865](https://github.com/netdata/netdata/issues/10865))
- Add carrier and mtu charts for network interfaces ([#10866](https://github.com/netdata/netdata/issues/10866))
- Update syntax for Caddy v2 ([#10823](https://github.com/netdata/netdata/issues/10823))
- Properly handle different netcat command names. ([#10883](https://github.com/netdata/netdata/issues/10883))
- [netdata minor release] v1.30.0

## [1.29.3] - 2021-02-23

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Fix wrong link on Netdata Agent Daemon ([#10659](https://github.com/netdata/netdata/issues/10659))
- Fix broken links in docs and add collectors to list ([#10651](https://github.com/netdata/netdata/issues/10651))
- Fixed condition controlling use of static LWS in RPM builds. ([#10661](https://github.com/netdata/netdata/issues/10661))
- Invalidate RRDSETVAR pointers on obsoletion. ([#10667](https://github.com/netdata/netdata/issues/10667))
- Statsd dashboard ([#10640](https://github.com/netdata/netdata/issues/10640))
- [netdata patch release] v1.29.3

## [1.29.2] - 2021-02-18

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Dashboard@v2.13.6 ([#10618](https://github.com/netdata/netdata/issues/10618))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Update claiming docs for Docker containers. ([#10570](https://github.com/netdata/netdata/issues/10570))
- Health: make Opsgenie API URL configurable ([#10561](https://github.com/netdata/netdata/issues/10561))
- Reduce logging amount in ACLK ([#10596](https://github.com/netdata/netdata/issues/10596))
- Allow the REMOVED status to be sent if a previous status was WARN/CRIT ([#10533](https://github.com/netdata/netdata/issues/10533))
- Add freeswitch to apps_groups ([#10621](https://github.com/netdata/netdata/issues/10621))
- Collectors/proc: change ksm mem chart type to stacked ([#10598](https://github.com/netdata/netdata/issues/10598))
- Fixes #10597 raw binary data should never be printed ([#10603](https://github.com/netdata/netdata/issues/10603))
- Collectors/elasticsearch: document `scheme` option ([#10572](https://github.com/netdata/netdata/issues/10572))
- Change eBPF plugin internal ([#10442](https://github.com/netdata/netdata/issues/10442))
- Disable stock alarms ([#10617](https://github.com/netdata/netdata/issues/10617))
- Add ACLK proxy setting as host label ([#10619](https://github.com/netdata/netdata/issues/10619))
- Add resetting CapabilityBoundingSet workaround to the python.d collectors (that use `sudo`) readmes ([#10587](https://github.com/netdata/netdata/issues/10587))
- Fix type in web/gui/readme.md ([#10623](https://github.com/netdata/netdata/issues/10623))
- Add k8s_cluster_id host label ([#10588](https://github.com/netdata/netdata/issues/10588))
- Fix sendmail unrecognized option F error ([#10631](https://github.com/netdata/netdata/issues/10631))
- Collectors/proc: fix collecting operstate for virtual network interfaces ([#10633](https://github.com/netdata/netdata/issues/10633))
- Enable apps.plugin aggregation debug messages ([#10645](https://github.com/netdata/netdata/issues/10645))
- Add small delay to the ipv4_tcp_resets alarms ([#10644](https://github.com/netdata/netdata/issues/10644))
- Fix container/host detection in system-info script ([#10647](https://github.com/netdata/netdata/issues/10647))
- Fix the context filtering on the data query endpoint ([#10652](https://github.com/netdata/netdata/issues/10652))
- [netdata patch release] v1.29.2

## [1.29.1] - 2021-02-09

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Update latest release on main README ([#10590](https://github.com/netdata/netdata/issues/10590))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Fix crash during shutdown of cgroups internal plugin. ([#10614](https://github.com/netdata/netdata/issues/10614))
- Fixed handling of Docker image tags for release builds. ([#10615](https://github.com/netdata/netdata/issues/10615))
- [netdata patch release] v1.29.1

## [1.29.0] - 2021-02-03

### Merged Pull Requests:

- Web/gui: Added support for per series styling for dygraphs ([#8668](https://github.com/netdata/netdata/issues/8668))
- Add dependabot config to check for updates for GHA workflows. ([#10342](https://github.com/netdata/netdata/issues/10342))
- Persist `$TMPDIR` from installer to updater. ([#10384](https://github.com/netdata/netdata/issues/10384))
- Exclude autofs by default in diskspace plugin ([#10441](https://github.com/netdata/netdata/issues/10441))
- Qick and dirty fix for #10420 ([#10424](https://github.com/netdata/netdata/issues/10424))
- Improve configuration docs with common changes and start/stop/restart directions ([#10415](https://github.com/netdata/netdata/issues/10415))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Updated messages about checksum validation failures on install. ([#10448](https://github.com/netdata/netdata/issues/10448))
- Update and improve the Netdata style guide ([#10433](https://github.com/netdata/netdata/issues/10433))
- Add previously missing section ([#10453](https://github.com/netdata/netdata/issues/10453))
- Change links at bottom of all install docs ([#10416](https://github.com/netdata/netdata/issues/10416))
- Change lint standard for lists ([#10371](https://github.com/netdata/netdata/issues/10371))
- Small updates, improvements, and housekeeping to docs ([#10405](https://github.com/netdata/netdata/issues/10405))
- Docs housekeeping for SEO and syntax, part 1 ([#10388](https://github.com/netdata/netdata/issues/10388))
- Add guide: Detect anomalies in nodes and applications with Netdata ([#10451](https://github.com/netdata/netdata/issues/10451))
- Fixes for SEO changes ([#10468](https://github.com/netdata/netdata/issues/10468))
- ACLK fix error for older compilers ([#10470](https://github.com/netdata/netdata/issues/10470))
- Fixed bundling of libwebsockets in binary packages. ([#10460](https://github.com/netdata/netdata/issues/10460))
- Add vkalintiris to CODEOWNERS for CI, packaging, and installer code. ([#10478](https://github.com/netdata/netdata/issues/10478))
- Fix data source option for Prometheus web API in exporting configuration ([#10397](https://github.com/netdata/netdata/issues/10397))
- Change HDDtemp to report None instead of 0 ([#10429](https://github.com/netdata/netdata/issues/10429))
- Python.d/fail2ban: Add handling "yes" and "no" as bool, match flexible spaces ([#10400](https://github.com/netdata/netdata/issues/10400))
- Update README.md ([#10467](https://github.com/netdata/netdata/issues/10467))
- GitHub action markdown link check update ([#10474](https://github.com/netdata/netdata/issues/10474))
- Truncate excessive information from titles for apps and cgroups ([#10479](https://github.com/netdata/netdata/issues/10479))
- Fixed handling of environment file in updater script. ([#10447](https://github.com/netdata/netdata/issues/10447))
- Fixed function name in updater script. ([#10462](https://github.com/netdata/netdata/issues/10462))
- Dispatch cgroup discovery into another thread ([#10399](https://github.com/netdata/netdata/issues/10399))
- Health: make mdstat_mismatch_cnt alarm less strict ([#10488](https://github.com/netdata/netdata/issues/10488))
- Mention PostgreSQL Prometheus Adapter in the documentation ([#10487](https://github.com/netdata/netdata/issues/10487))
- Bump ini from 1.3.5 to 1.3.8 ([#10489](https://github.com/netdata/netdata/issues/10489))
- Add instructions on enabling explicitly disabled collectors ([#10418](https://github.com/netdata/netdata/issues/10418))
- Bump actions/upload-artifact from v1 to v2.2.2 ([#10475](https://github.com/netdata/netdata/issues/10475))
- Fix memory allocation when computing standard deviation ([#10484](https://github.com/netdata/netdata/issues/10484))
- Fixed handling of TLS config so that cURL works in all cases. ([#10491](https://github.com/netdata/netdata/issues/10491))
- New eBPF kernel ([#10434](https://github.com/netdata/netdata/issues/10434))
- Fix heap-use-after-free due to the chart using netdata_config memory for some strings. ([#10498](https://github.com/netdata/netdata/issues/10498))
- Add guide: Monitor and visualize anomalies with Netdata ([#10480](https://github.com/netdata/netdata/issues/10480))
- Anomalies collector custom model bugfix for issue #10456 ([#10459](https://github.com/netdata/netdata/issues/10459))
- Support multiple chart label keys in data queries ([#10483](https://github.com/netdata/netdata/issues/10483))
- Fix broken dbengine stress tests. ([#10502](https://github.com/netdata/netdata/issues/10502))
- Claiming retry/backoff ([#10482](https://github.com/netdata/netdata/issues/10482))
- Switch to using GitHub Actions for publishing Docker images. ([#10365](https://github.com/netdata/netdata/issues/10365))
- Switched to using system libwebsockets for RPM builds. ([#10507](https://github.com/netdata/netdata/issues/10507))
- Spelling md ([#10508](https://github.com/netdata/netdata/issues/10508))
- Add `_is_k8s_node` label to the host labels ([#10501](https://github.com/netdata/netdata/issues/10501))
- Fix coverity issue CID_365322 
- Health/mysql: match 0 in mysql.slave_status ([#10513](https://github.com/netdata/netdata/issues/10513))
- [health][NFC] Remove unused struct. ([#10517](https://github.com/netdata/netdata/issues/10517))
- [health][NFC] Mark internal functions as static. ([#10518](https://github.com/netdata/netdata/issues/10518))
- Move ACLK Legacy into a subfolder ([#10265](https://github.com/netdata/netdata/issues/10265))
- Dashboard@v2.12.5 ([#10520](https://github.com/netdata/netdata/issues/10520))
- Remove unused entries from structures ([#10519](https://github.com/netdata/netdata/issues/10519))
- Reduce the number of alarm updates on ACLK #10524
- Add link to specific feedback megathread for the anomalies collector ([#10505](https://github.com/netdata/netdata/issues/10505))
- Update pfsense.md ([#10466](https://github.com/netdata/netdata/issues/10466))
- Add link to specific feedback megathread for the anomalies collector ([#10506](https://github.com/netdata/netdata/issues/10506))
- Spelling python plugin ([#10525](https://github.com/netdata/netdata/issues/10525))
- Fix postgres password bug and change default config ([#10531](https://github.com/netdata/netdata/issues/10531))
- Update README.md on postgres collector ([#10532](https://github.com/netdata/netdata/issues/10532))
- Fixed triggering of Docker image builds from Travis. ([#10541](https://github.com/netdata/netdata/issues/10541))
- Make some tweaks/improvements to conf docs ([#10528](https://github.com/netdata/netdata/issues/10528))
- Installer: update go.d.plugin version to v0.27.0 ([#10544](https://github.com/netdata/netdata/issues/10544))
- Properly handle arguments and responses for triggering Docker builds. ([#10545](https://github.com/netdata/netdata/issues/10545))
- Fixed argument handling in `.travis/trigger_docker_build.sh`. ([#10546](https://github.com/netdata/netdata/issues/10546))
- Properly handle saved temporary directory on updates. ([#10550](https://github.com/netdata/netdata/issues/10550))
- Fix values in Prometheus export for metrics, collected by the Prometheus collector ([#10551](https://github.com/netdata/netdata/issues/10551))
- Fix prometheus remote write header ([#10560](https://github.com/netdata/netdata/issues/10560))
- Fix minor vulnerability alert, updating socket-io dependency ([#10557](https://github.com/netdata/netdata/issues/10557))
- Fix disconnect message sent via ACLK on agent shutdown ([#10563](https://github.com/netdata/netdata/issues/10563))
- Dashboard@v2.13.0 ([#10565](https://github.com/netdata/netdata/issues/10565))
- Remove OpenSUSE Leap 15.1 from CI. ([#10543](https://github.com/netdata/netdata/issues/10543))
- Add Alpine 3.13 and remove Alpine 3.9 from our CI. ([#10542](https://github.com/netdata/netdata/issues/10542))
- Fixed Netdata Cloud support in RPM packages. ([#10578](https://github.com/netdata/netdata/issues/10578))
- Fix container detection from systemd-detect-virt ([#10569](https://github.com/netdata/netdata/issues/10569))
- Fixed docker image tagging for nightly builds. ([#10584](https://github.com/netdata/netdata/issues/10584))
- Bump version of `git-semver` to one that should actually work.
- [netdata minor release] v1.29.0

## [1.27.0_0104103941] - 2021-01-04

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Bump Fedora version for RPM packaging to 32. ([#10404](https://github.com/netdata/netdata/issues/10404))
- Add centralized Cloud notifications to core docs ([#10374](https://github.com/netdata/netdata/issues/10374))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Update main README with release news ([#10412](https://github.com/netdata/netdata/issues/10412))
- Add Realtek network cards to the list of physical interfaces on FreeBSD ([#10414](https://github.com/netdata/netdata/issues/10414))
- Added instructions on which file to edit. ([#10398](https://github.com/netdata/netdata/issues/10398))
- Use bash shell as user netdata for debug ([#10425](https://github.com/netdata/netdata/issues/10425))
- ACLK use mguid instead of hostname ([#10394](https://github.com/netdata/netdata/issues/10394))

## [1.28.0] - 2020-12-18

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Fix locking after an ACLK on_connect failure ([#10401](https://github.com/netdata/netdata/issues/10401))
- [netdata minor release] v1.27.1

## [1.27.0] - 2020-12-17

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Update README.md ([#10067](https://github.com/netdata/netdata/issues/10067))
- Removed redundant build dependencies from Debian control file ([#10085](https://github.com/netdata/netdata/issues/10085))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Removed @prologic from CODEOWNERS. ([#10059](https://github.com/netdata/netdata/issues/10059))
- Added more robust doucmentation around updates. ([#10100](https://github.com/netdata/netdata/issues/10100))
- Replace memcpy() with memmove() for overlapping memory ranges. ([#10097](https://github.com/netdata/netdata/issues/10097))
- Fix formatting source code blocks in custom dashboard page ([#10050](https://github.com/netdata/netdata/issues/10050))
- Add per queue charts in rabbitmq.chart.py ([#10064](https://github.com/netdata/netdata/issues/10064))
- Collectors/cgroups: filter pod level cgroups ([#10095](https://github.com/netdata/netdata/issues/10095))
- Collectors/cgroups: fix resolving container names in k8s ([#10072](https://github.com/netdata/netdata/issues/10072))
- Add support for HBA drives in hpssa.chart.py ([#10093](https://github.com/netdata/netdata/issues/10093))
- Nvidia_smi: Not count users with zero memory allocated ([#10098](https://github.com/netdata/netdata/issues/10098))
- New alarm entities ([#10041](https://github.com/netdata/netdata/issues/10041))
- Wireless statistics ([#10052](https://github.com/netdata/netdata/issues/10052))
- Update supported collectors list with new collectors ([#10102](https://github.com/netdata/netdata/issues/10102))
- Don't check for ebpf dependencies if ebpf is disabled. ([#10034](https://github.com/netdata/netdata/issues/10034))
- Rewrite the repository's main README ([#10108](https://github.com/netdata/netdata/issues/10108))
- Installer: update go.d.plugin version to v0.24.0 ([#10109](https://github.com/netdata/netdata/issues/10109))
- Fixed compile error in CENTOS 6 ([#10110](https://github.com/netdata/netdata/issues/10110))
- Add documentation for Cloud Overview ([#10082](https://github.com/netdata/netdata/issues/10082))
- Fix platform dependent printf format ([#10120](https://github.com/netdata/netdata/issues/10120))
- Disregard host tags configuration pointer and keep duplicate string from streaming handshake. ([#10121](https://github.com/netdata/netdata/issues/10121))
- Added Konstas Kaskavelis as a code owner for CI. ([#10126](https://github.com/netdata/netdata/issues/10126))
- Completely hide SSO iframe ([#10027](https://github.com/netdata/netdata/issues/10027))
- Added new data query option "allow_past" ([#10112](https://github.com/netdata/netdata/issues/10112))
- Updated distros for CI checks and package builds. ([#10123](https://github.com/netdata/netdata/issues/10123))
- Add documentation for configuring/editing hostnames of Docker-run Agents ([#10087](https://github.com/netdata/netdata/issues/10087))
- Update README.md ([#10146](https://github.com/netdata/netdata/issues/10146))
- Dashboard@2.7.4 ([#10122](https://github.com/netdata/netdata/issues/10122))
- Fix links ([#10115](https://github.com/netdata/netdata/issues/10115))
- Fix configuration category ([#10145](https://github.com/netdata/netdata/issues/10145))
- Skip ReviewDog runs for PRs that don’t need them. ([#10148](https://github.com/netdata/netdata/issues/10148))
- Ebpf memory cleanup ([#10096](https://github.com/netdata/netdata/issues/10096))
- Opsgenie integration ([#9879](https://github.com/netdata/netdata/issues/9879))
- Update the version of libJudy that we bundle to 1.0.5-netdata2 ([#10158](https://github.com/netdata/netdata/issues/10158))
- Update CODE_OF_CONDUCT.md ([#10161](https://github.com/netdata/netdata/issues/10161))
- Allows use of system libwebsockets instead of bundled one ([#9984](https://github.com/netdata/netdata/issues/9984))
- Hangout thread ([#10160](https://github.com/netdata/netdata/issues/10160))
- Dashboard v2.7.5 ([#10179](https://github.com/netdata/netdata/issues/10179))
- Fix an infinite loop in the statsd plugin ([#10180](https://github.com/netdata/netdata/issues/10180))
- Don't cache registry responses ([#10181](https://github.com/netdata/netdata/issues/10181))
- Remove knatsakis from makefile code ownership. ([#10184](https://github.com/netdata/netdata/issues/10184))
- Add notices to FreeBSD/pfSense docs that they are community-supported ([#10171](https://github.com/netdata/netdata/issues/10171))
- Fix: make comma optional when parsing ipsec trafficstatus ([#10190](https://github.com/netdata/netdata/issues/10190))
- Add supported notification platforms to docs ([#10170](https://github.com/netdata/netdata/issues/10170))
- Inform users about an issue with the newest gRPC versions ([#10194](https://github.com/netdata/netdata/issues/10194))
- Add HTTP and HTTPS support to the simple exporting connector ([#9911](https://github.com/netdata/netdata/issues/9911))
- Adds metric showing how long Query spent in Queue ([#10016](https://github.com/netdata/netdata/issues/10016))
- Page duty V2 ([#10189](https://github.com/netdata/netdata/issues/10189))
- Re-enable CentOS 8 CI checks. ([#10156](https://github.com/netdata/netdata/issues/10156))
- Remove usage of deprecated GHA syntax. ([#10154](https://github.com/netdata/netdata/issues/10154))
- Fixed builds using particular versions of Clang. ([#10155](https://github.com/netdata/netdata/issues/10155))
- Fixed two bugs related to version handling in install and update code. ([#10162](https://github.com/netdata/netdata/issues/10162))
- Move shared memory accounting from "cached" to "used" dimension ([#10183](https://github.com/netdata/netdata/issues/10183))
- Update k8s docs with new Helm repo ([#10172](https://github.com/netdata/netdata/issues/10172))
- Make libnetdata headers compilable by C++. ([#10185](https://github.com/netdata/netdata/issues/10185))
- Fix repeated frontmatter ([#10211](https://github.com/netdata/netdata/issues/10211))
- Installer: update go.d.plugin version to v0.25.0 ([#10215](https://github.com/netdata/netdata/issues/10215))
- Fixed bug in auto-updater for FreeBSD ([#10198](https://github.com/netdata/netdata/issues/10198)) ([#10204](https://github.com/netdata/netdata/issues/10204))
- Fix coverity issues ([#10216](https://github.com/netdata/netdata/issues/10216))
- Fix chart filtering ([#10218](https://github.com/netdata/netdata/issues/10218))
- Don't stop Prometheus remote write collector when data is not available for dimension formatting ([#10217](https://github.com/netdata/netdata/issues/10217))
- Streaming: fix a typo in the README.md ([#10225](https://github.com/netdata/netdata/issues/10225))
- Dashboard_info.js: fix a typo (vernemq) ([#10223](https://github.com/netdata/netdata/issues/10223))
- Collectors/xenstat.plugin: recieved => received ([#10224](https://github.com/netdata/netdata/issues/10224))
- Update CoC and widen scope to community ([#10186](https://github.com/netdata/netdata/issues/10186))
- Add allocated space metrics to oracledb charts ([#10197](https://github.com/netdata/netdata/issues/10197))
- Health: convert `elasticsearch_last_collected` alarm to template ([#10226](https://github.com/netdata/netdata/issues/10226))
- Add guide: Deploy Netdata with Ansible ([#10199](https://github.com/netdata/netdata/issues/10199))
- Add `nvidia_smi` collector data to the dashboard_info.js ([#10230](https://github.com/netdata/netdata/issues/10230))
- Disable chart obsoletion code for archived chart creation. ([#10231](https://github.com/netdata/netdata/issues/10231))
- New ebpf release ([#10202](https://github.com/netdata/netdata/issues/10202))
- Update ansible.md ([#10232](https://github.com/netdata/netdata/issues/10232))
- Database: fix endless loop when cleaning obsolete charts ([#10236](https://github.com/netdata/netdata/issues/10236))
- Fix streaming buffer size ([#10240](https://github.com/netdata/netdata/issues/10240))
- Dashboard v2.9.4 ([#10239](https://github.com/netdata/netdata/issues/10239))
- Fix broken links ([#10253](https://github.com/netdata/netdata/issues/10253))
- Fix Docs GitHub Action with ignore list and update ([#10002](https://github.com/netdata/netdata/issues/10002))
- Update CONTRIBUTING.md ([#10252](https://github.com/netdata/netdata/issues/10252))
- Updated 3rd party static build dependencies and use alpine 3.12 ([#10241](https://github.com/netdata/netdata/issues/10241))
- Docs: Point users to proper configure doc ([#10254](https://github.com/netdata/netdata/issues/10254))
- Remove Docker example from update docs and add section to claim troubleshooting ([#10103](https://github.com/netdata/netdata/issues/10103))
- Add kernel to black list ([#10262](https://github.com/netdata/netdata/issues/10262))
- New issue templates ([#10259](https://github.com/netdata/netdata/issues/10259))
- Fix bug_report.md syntax error ([#10269](https://github.com/netdata/netdata/issues/10269))
- Document the Agent reinstallation process ([#10270](https://github.com/netdata/netdata/issues/10270))
- Python.d/nvidia_smi: use `pwd` lib to get username if not inside a container ([#10268](https://github.com/netdata/netdata/issues/10268))
- Migrate metadata log to SQLite ([#10139](https://github.com/netdata/netdata/issues/10139))
- Address coverity errors (CID 364045,364046) ([#10282](https://github.com/netdata/netdata/issues/10282))
- Use new libmosquitto release (with MacOS libMosq fix) #10283
- Fix hostname when syslog is used ([#10275](https://github.com/netdata/netdata/issues/10275))
- Installer: update go.d.plugin version to v0.26.0 ([#10284](https://github.com/netdata/netdata/issues/10284))
- Fixed the data endpoint so that the context param is correctly applied to children ([#10290](https://github.com/netdata/netdata/issues/10290))
- Health/web_log: remove `crit` from unmatched alarms ([#10280](https://github.com/netdata/netdata/issues/10280))
- ACLK Child Availability Messages ([#9918](https://github.com/netdata/netdata/issues/9918))
- Fix race condition in rrdset_first_entry_t() and rrdset_last_entry_t() ([#10276](https://github.com/netdata/netdata/issues/10276))
- Updated contributing guidelines to suggest use of Draft PRs. ([#10125](https://github.com/netdata/netdata/issues/10125))
- Fix compilation with https disabled. Fixes #10278 ([#10279](https://github.com/netdata/netdata/issues/10279))
- Alarms collector ([#10042](https://github.com/netdata/netdata/issues/10042))
- Python.d: always create a runtime chart on `create` call ([#10296](https://github.com/netdata/netdata/issues/10296))
- Add guide: How to optimize Netdata's performance ([#10271](https://github.com/netdata/netdata/issues/10271))
- Update UPDATE.md ([#10301](https://github.com/netdata/netdata/issues/10301))
- HAProxy spelling correction ([#10300](https://github.com/netdata/netdata/issues/10300))
- Adds child query support to ACLK ([#10030](https://github.com/netdata/netdata/issues/10030))
- Add optional info on how to also add some default alarms as part of submitting a collector. ([#10302](https://github.com/netdata/netdata/issues/10302))
- Removed lifecycle checks from Travis CI. ([#10305](https://github.com/netdata/netdata/issues/10305))
- Anomalies collector ([#10060](https://github.com/netdata/netdata/issues/10060))
- Fix UUID_STR_LEN undefined on MacOS ([#10313](https://github.com/netdata/netdata/issues/10313))
- Dbengine extent cache ([#10293](https://github.com/netdata/netdata/issues/10293))
- Python.d/nvidia_smi: fix gpu data filtering ([#10312](https://github.com/netdata/netdata/issues/10312))
- File descr alarm v01 ([#10192](https://github.com/netdata/netdata/issues/10192))
- Dashboard@v2.10.1 ([#10314](https://github.com/netdata/netdata/issues/10314))
- Add privacy information about aclk connection ([#10292](https://github.com/netdata/netdata/issues/10292))
- Added support for MSE (Massive Storage Engine) in Varnish-Plus ([#10317](https://github.com/netdata/netdata/issues/10317))
- EBPF synchronization ([#10299](https://github.com/netdata/netdata/issues/10299))
- Installer: update go.d.plugin version to v0.26.1 ([#10319](https://github.com/netdata/netdata/issues/10319))
- Fix a compilation warning ([#10320](https://github.com/netdata/netdata/issues/10320))
- Add new collectors to list ([#10310](https://github.com/netdata/netdata/issues/10310))
- Health: disable 'used_file_descriptors' alarm ([#10328](https://github.com/netdata/netdata/issues/10328))
- Made the update script significantly more robust and user friendly. ([#10261](https://github.com/netdata/netdata/issues/10261))
- Fix exporting config ([#10323](https://github.com/netdata/netdata/issues/10323))
- Improve core documentation to align with recent Netdata Cloud releases ([#10318](https://github.com/netdata/netdata/issues/10318))
- Added info about network usage requirements for the update script. ([#10334](https://github.com/netdata/netdata/issues/10334))
- Added patch to build LWS properly on macOS. ([#10333](https://github.com/netdata/netdata/issues/10333))
- Fix backend options ([#10343](https://github.com/netdata/netdata/issues/10343))
- Use `glibtoolize` on macOS instead of regular `libtoolize`. ([#10346](https://github.com/netdata/netdata/issues/10346))
- Add guide: Monitor any process in real-time with Netdata ([#10338](https://github.com/netdata/netdata/issues/10338))
- Fix handling of PowerTools repo on CentOS 8. ([#10344](https://github.com/netdata/netdata/issues/10344))
- Added numerous improvements to our Docker image. ([#10308](https://github.com/netdata/netdata/issues/10308))
- Update macOS instructions with cmake ([#10295](https://github.com/netdata/netdata/issues/10295))
- Installer: update go.d.plugin version to v0.26.2 ([#10355](https://github.com/netdata/netdata/issues/10355))
- Fix handling of Python dependency for RPM package. ([#10345](https://github.com/netdata/netdata/issues/10345))
- Fixed handling of self-updating in updater script. ([#10352](https://github.com/netdata/netdata/issues/10352))
- Explicitly set platform for Docker builds. ([#10357](https://github.com/netdata/netdata/issues/10357))
- Switch to using official Docker actions for GHA CI. ([#10335](https://github.com/netdata/netdata/issues/10335))
- Fixed use of multiarch/qemu-user-static image for Docker builds. ([#10364](https://github.com/netdata/netdata/issues/10364))
- Added number of allocated/stored objects within each Varnish storage ([#10329](https://github.com/netdata/netdata/issues/10329))
- Add two more insignificant warnings to suppress in anomalies collector ([#10369](https://github.com/netdata/netdata/issues/10369))
- Python.d/alarms: add alarms obsoletion and disable by default ([#10375](https://github.com/netdata/netdata/issues/10375))
- Python.d/alarms: fix sending chart definition on every data collection ([#10378](https://github.com/netdata/netdata/issues/10378))
- Fix hostname configuration in the exporting engine ([#10361](https://github.com/netdata/netdata/issues/10361))
- Update macos.md ([#10379](https://github.com/netdata/netdata/issues/10379))
- Kubernetes labels ([#10107](https://github.com/netdata/netdata/issues/10107))
- Update alarms collector readme image to use one from the related netdata PR ([#10348](https://github.com/netdata/netdata/issues/10348))
- Dashboard v2.11 ([#10383](https://github.com/netdata/netdata/issues/10383))
- Fix issue with chart metadata sent multiple times over ACLK ([#10381](https://github.com/netdata/netdata/issues/10381))
- Fix a lock check ([#10385](https://github.com/netdata/netdata/issues/10385))
- New ebpf charts ([#10360](https://github.com/netdata/netdata/issues/10360))
- Update README.md ([#10303](https://github.com/netdata/netdata/issues/10303))
- Fix typo in performance.md ([#10386](https://github.com/netdata/netdata/issues/10386))
- Add paragraph in anomalies collector README to ask for feedback ([#10363](https://github.com/netdata/netdata/issues/10363))
- Fix a buffer overflow when extracting information from a STREAM connection ([#10391](https://github.com/netdata/netdata/issues/10391))
- Fixed handling of dependencies on Gentoo. ([#10382](https://github.com/netdata/netdata/issues/10382))
- Add documentation for time & date picker in Agent and Cloud ([#10347](https://github.com/netdata/netdata/issues/10347))
- Initialize ebpf.plugin variables ([#10395](https://github.com/netdata/netdata/issues/10395))
- Fixed option parsing in kickstart.sh. ([#10396](https://github.com/netdata/netdata/issues/10396))
- [netdata minor release] v1.27.0

## [1.26.0] - 2020-10-14

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Unix socket docker ([#9927](https://github.com/netdata/netdata/issues/9927))
- Add guide for monitoring Pi-hole and Raspberry Pi ([#9770](https://github.com/netdata/netdata/issues/9770))
- Add persistent configuration details to Docker docs ([#9926](https://github.com/netdata/netdata/issues/9926))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Added support for using `/etc/cron.d` for auto-updates. ([#9598](https://github.com/netdata/netdata/issues/9598))
- Added context parameter to the data endpoint ([#9931](https://github.com/netdata/netdata/issues/9931))
-  Fix resource leak in case of malformed cloud request ([#9934](https://github.com/netdata/netdata/issues/9934))
- Added a way to get build configuration info from the agent. ([#9913](https://github.com/netdata/netdata/issues/9913))
- Adds ACLK DISABLE_CLOUD to -W buildinfo ([#9936](https://github.com/netdata/netdata/issues/9936))
- Add mirrored_hosts_status into OpenAPI of api/info ([#9867](https://github.com/netdata/netdata/issues/9867))
- Use automatic dependency generation for RPM builds. ([#9937](https://github.com/netdata/netdata/issues/9937))
- Add missing file to gitignore ([#9946](https://github.com/netdata/netdata/issues/9946))
- Fixed chart's last accessed time during context queries ([#9952](https://github.com/netdata/netdata/issues/9952))
- Merge branch 'develop'
- Fix build for the AWS Kinesis exporting connector ([#9823](https://github.com/netdata/netdata/issues/9823))
- Fix typo inside netdata-installer.sh ([#9962](https://github.com/netdata/netdata/issues/9962))
- Stackpulse integration ([#9965](https://github.com/netdata/netdata/issues/9965))
- Remove dupplication ([#9968](https://github.com/netdata/netdata/issues/9968))
- Cleanup CODEOWNERS ([#9971](https://github.com/netdata/netdata/issues/9971))
- Use non-interactive backend for debconf in Kinesis CI setup. ([#9972](https://github.com/netdata/netdata/issues/9972))
- Removed Patti from Codeowner
- Quick fix to eBPF-apps setting ([#9967](https://github.com/netdata/netdata/issues/9967))
- Allows using LWS without SOCKS5 ([#9973](https://github.com/netdata/netdata/issues/9973))
- Improved the data query when using the context parameter ([#9978](https://github.com/netdata/netdata/issues/9978))
- Added more stringent check for C99 support in configure script. ([#9982](https://github.com/netdata/netdata/issues/9982))
- Fixed typos in installer functions. ([#9992](https://github.com/netdata/netdata/issues/9992))
- Fix cleanup of obsolete charts ([#9985](https://github.com/netdata/netdata/issues/9985))
- Fixed locking order to address CID_362348 ([#9991](https://github.com/netdata/netdata/issues/9991))
- Fix missing libelf-dev dependency. ([#9974](https://github.com/netdata/netdata/issues/9974))
- Added improved auto-update support. ([#9966](https://github.com/netdata/netdata/issues/9966))
- Use our installer's bundling code for libJudy in static installs. ([#9988](https://github.com/netdata/netdata/issues/9988))
- Minor - removes leading whitespace before JSON in ACLK ([#9998](https://github.com/netdata/netdata/issues/9998))
- Add docsv2 project to master branch ([#10000](https://github.com/netdata/netdata/issues/10000))
- Add missing tests ([#10008](https://github.com/netdata/netdata/issues/10008))
- Change default ACLK query thread count ([#10009](https://github.com/netdata/netdata/issues/10009))
- Add a few changes that were missed by the systemd updater support. ([#10007](https://github.com/netdata/netdata/issues/10007))
- Add documentation for claiming k8s parent pods and Prometheus service discovery ([#10001](https://github.com/netdata/netdata/issues/10001))
- Update freebsd.md ([#10005](https://github.com/netdata/netdata/issues/10005))
- Fix file descriptor leak ([#10013](https://github.com/netdata/netdata/issues/10013))
- Clean up and better cross-link new docsv2 documents ([#10015](https://github.com/netdata/netdata/issues/10015))
- Allow connecting to arbitrary MQTT WSS broker for devs ([#9999](https://github.com/netdata/netdata/issues/9999))
- Fixed the data endpoint to prioritize chart over context if both are present ([#10032](https://github.com/netdata/netdata/issues/10032))
- Fixed incorrect condition in updater type detection. ([#10028](https://github.com/netdata/netdata/issues/10028))
- Fix README exporting link ([#10020](https://github.com/netdata/netdata/issues/10020))
- Update README.md ([#9925](https://github.com/netdata/netdata/issues/9925))
- Fixed gauges for go web_log module ([#10029](https://github.com/netdata/netdata/issues/10029))
- Python.d/rabbitmq: Add chart for churn rates ([#10031](https://github.com/netdata/netdata/issues/10031))
- Rename NETDATA_PORT to NETDATA_LISTENER_PORT ([#10045](https://github.com/netdata/netdata/issues/10045))
- Installer: update go.d.plugin version to v0.23.0 ([#10046](https://github.com/netdata/netdata/issues/10046))
- Health/portcheck: add `failed` dim to the `connection_fails` alarm ([#10048](https://github.com/netdata/netdata/issues/10048))
- Small docs update - adding note about using `nolock` when debugging ([#10036](https://github.com/netdata/netdata/issues/10036))
- Add missing period in netdata dashboard ([#9960](https://github.com/netdata/netdata/issues/9960))
- Skip all build checks on packaging builds. ([#10058](https://github.com/netdata/netdata/issues/10058))
- Fix systemd comment syntax ([#10066](https://github.com/netdata/netdata/issues/10066))
- [netdata minor release] v1.26.0

## [1.25.0] - 2020-09-15

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Replace alarm redirection link for cloud ([#9688](https://github.com/netdata/netdata/issues/9688))
- Fix print message when building for Ubuntu Focal ([#9694](https://github.com/netdata/netdata/issues/9694))
- Correct vulnerability reporting instructions ([#9696](https://github.com/netdata/netdata/issues/9696))
- Fix collectors on MacOS and FreeBSD to ignore archived charts. ([#9695](https://github.com/netdata/netdata/issues/9695))
- Fix crash when receiving malformed labels via streaming. ([#9715](https://github.com/netdata/netdata/issues/9715))
- Fix the default value of the home directory  ([#9711](https://github.com/netdata/netdata/issues/9711))
- Remove broken optimization in the sender thread ([#9703](https://github.com/netdata/netdata/issues/9703))
- Fixed issue with missing alarms ([#9712](https://github.com/netdata/netdata/issues/9712))
- Fixed global GUID map memory leak ([#9725](https://github.com/netdata/netdata/issues/9725))
- Fix for ignored LXC containers ([#9645](https://github.com/netdata/netdata/issues/9645))
- Removed Ubuntu 20.04 32-bit x86 package builds. ([#9718](https://github.com/netdata/netdata/issues/9718))
- Add CAP_SYS_CHROOT for netdata service ([#9726](https://github.com/netdata/netdata/issues/9726))
- Added proper certificate handling to static cURL. ([#9733](https://github.com/netdata/netdata/issues/9733))
- Update README.md ([#9721](https://github.com/netdata/netdata/issues/9721))
- Add community link to readme ([#9602](https://github.com/netdata/netdata/issues/9602))
- Update health_alarm_notify.conf ([#9740](https://github.com/netdata/netdata/issues/9740))
- Send follow up alarms when the initial status matches the notification ([#9698](https://github.com/netdata/netdata/issues/9698))
- Update netdata-installer.sh to fix #8862 ([#9360](https://github.com/netdata/netdata/issues/9360))
- Fix code formatting for the mdstat collector ([#9749](https://github.com/netdata/netdata/issues/9749))
- Fix flushing errors ([#9738](https://github.com/netdata/netdata/issues/9738))
- Network viewer charts ([#9591](https://github.com/netdata/netdata/issues/9591))
- Doc: netdata user is also a default ([#9555](https://github.com/netdata/netdata/issues/9555))
- Python.d/varnish: multiple storage backends fix ([#9668](https://github.com/netdata/netdata/issues/9668))
- Python.d/ipfs: disable call to the `/api/v0/stats/repo` endpoint by default ([#9687](https://github.com/netdata/netdata/issues/9687))
- Fix exporting update point ([#9748](https://github.com/netdata/netdata/issues/9748))
- Add check for spurious wakeups ([#9751](https://github.com/netdata/netdata/issues/9751))
- Python.d/isc_dhcpd: add support for ip ranges ([#9755](https://github.com/netdata/netdata/issues/9755))
- Fix netfilter for it closes when sigpipe happens ([#9756](https://github.com/netdata/netdata/issues/9756))
- Python.d/redis: collect `maxmemory` ([#9767](https://github.com/netdata/netdata/issues/9767))
- Fix unit tests for exporting engine ([#9766](https://github.com/netdata/netdata/issues/9766))
- Fix broken link in privacy policy ([#9771](https://github.com/netdata/netdata/issues/9771))
- Fix HTTP header for the remote write exporting connector ([#9775](https://github.com/netdata/netdata/issues/9775))
- Fix netdata/netdata Docker image size ([#9669](https://github.com/netdata/netdata/issues/9669))
- Cgroups.plugin: add and document support for reading container names from Podman ([#9474](https://github.com/netdata/netdata/issues/9474))
- Fix long stats.d chart names (thanks to @vince-lessbits) ([#9783](https://github.com/netdata/netdata/issues/9783))
- Add missing value to list simple pattern
- Fixed numerous bugs in duplicate install handling. ([#9769](https://github.com/netdata/netdata/issues/9769))
- Debian packaging ([#8982](https://github.com/netdata/netdata/issues/8982))
- Docs: Add daemon config to health section and standardize IP references ([#8837](https://github.com/netdata/netdata/issues/8837))
- Fix proxy redirect 
- Remove ebpf debug messages ([#9754](https://github.com/netdata/netdata/issues/9754))
- Dashboard v1.3.1 ([#9786](https://github.com/netdata/netdata/issues/9786))
- Fix Travis CI builds and skip Fedora 31 i386 build/test cycles ([#9781](https://github.com/netdata/netdata/issues/9781))
- Change timestamps for global variables in Prometheus output ([#9779](https://github.com/netdata/netdata/issues/9779))
- Don't run packaging checks on Travis builds that build packages. ([#9795](https://github.com/netdata/netdata/issues/9795))
- Added code to release memory used by the global GUID map ([#9729](https://github.com/netdata/netdata/issues/9729))
- Fix loading custom dashboard_info in /old dashboard ([#9792](https://github.com/netdata/netdata/issues/9792))
- Package ebpf plugin only if enabled in config.h ([#9752](https://github.com/netdata/netdata/issues/9752))
- Fix docker packaging caddyserver basicauth link ([#9812](https://github.com/netdata/netdata/issues/9812))
- Fix install if system does not have ebpf.plugin ([#9809](https://github.com/netdata/netdata/issues/9809))
- Fixed handling of offline installs. ([#9805](https://github.com/netdata/netdata/issues/9805))
- Fix the netdata-updater.sh to correctly pass REINSTALL_OPTIONS (finally) ([#8808](https://github.com/netdata/netdata/issues/8808))
- Remove PrivateMounts ([#9619](https://github.com/netdata/netdata/issues/9619))
- Adds claimed_id streaming ([#9804](https://github.com/netdata/netdata/issues/9804))
- Improve dbengine docs and add new multihost setting ([#9817](https://github.com/netdata/netdata/issues/9817))
- Don't always assume old Dashboard is hosted with "/old" suffix. For third party packages that assumption can be wrong. Detect the suffix using document.currentScript, to allow backwards compatibility ([#9814](https://github.com/netdata/netdata/issues/9814))
- Fix link and clean up frontmatter in health ([#9813](https://github.com/netdata/netdata/issues/9813))
- Ensure Arch Linux images are up to date in CI before running checks. ([#9825](https://github.com/netdata/netdata/issues/9825))
- Improved temporary directory checking in installer and updater. ([#9797](https://github.com/netdata/netdata/issues/9797))
- Fix empty dbengine files ([#9820](https://github.com/netdata/netdata/issues/9820))
- Fix handling of NETDATA_NIGHTLIES_BASEURL. ([#9831](https://github.com/netdata/netdata/issues/9831))
- Fixes proxy forwarding claim_id to old parent ([#9828](https://github.com/netdata/netdata/issues/9828))
- Remove Google Charts info ([#9826](https://github.com/netdata/netdata/issues/9826))
- Fixed updater bug introduced by incomplete variable rename in #8808. ([#9834](https://github.com/netdata/netdata/issues/9834))
- Change a log level in cgroup-network helper ([#9836](https://github.com/netdata/netdata/issues/9836))
- Don't falsely report that the group was not deleted ([#9835](https://github.com/netdata/netdata/issues/9835))
- Dashboard v1.4.2 ([#9837](https://github.com/netdata/netdata/issues/9837))
- Fix redirect with parameters
- Fixes compilation warnings ([#9845](https://github.com/netdata/netdata/issues/9845))
- Add frontmatter ([#9847](https://github.com/netdata/netdata/issues/9847))
- Use printf instead of echo for better POSIX compliance. ([#9842](https://github.com/netdata/netdata/issues/9842))
- Don't install eBPF plugin components when they shouldn't be installed ([#9844](https://github.com/netdata/netdata/issues/9844))
- Rpm: Fix rpm build script version issues ([#9808](https://github.com/netdata/netdata/issues/9808))
- Fix multi-host DB corruption when legacy metrics reside in localhost. ([#9855](https://github.com/netdata/netdata/issues/9855))
- Fixed bugs in handling of Python 3 dependencies on install. ([#9839](https://github.com/netdata/netdata/issues/9839))
- Added code to bundle libJudy on systems which do not provide a usable copy of it. ([#9776](https://github.com/netdata/netdata/issues/9776))
- Python.d/openldap: fix tls over ldap ([#9853](https://github.com/netdata/netdata/issues/9853))
- Collect active processes limit feature v2 ([#9843](https://github.com/netdata/netdata/issues/9843))
- Health_fix_typo: Fix typo ([#9860](https://github.com/netdata/netdata/issues/9860))
- Removed dependency on libJudy for systems which don't have it. ([#9859](https://github.com/netdata/netdata/issues/9859))
- Labeler: add `area/exporting` ([#9866](https://github.com/netdata/netdata/issues/9866))
- Python.d/dnsdist: fix latency-avg chart units ([#9871](https://github.com/netdata/netdata/issues/9871))
- Fix race condition with orphan hosts ([#9862](https://github.com/netdata/netdata/issues/9862))
- Installer: update go.d.plugin version to v0.21.0 ([#9881](https://github.com/netdata/netdata/issues/9881))
- Fixed lack of macOS RAM info in system-info.sh ([#9882](https://github.com/netdata/netdata/issues/9882))
- Fixed handling of libJudy bundling for RPM packages. ([#9875](https://github.com/netdata/netdata/issues/9875))
- Fix lock order reversal. ([#9888](https://github.com/netdata/netdata/issues/9888))
- ACLK Version Negotiation ([#9819](https://github.com/netdata/netdata/issues/9819))
- Fixed typo in option name used to use bundled libJudy ([#9893](https://github.com/netdata/netdata/issues/9893))
- Improve_http_message: Change error message to be nearest possible RFC2616 ([#9887](https://github.com/netdata/netdata/issues/9887))
- Make internal Travis CI notifications behave better. ([#9897](https://github.com/netdata/netdata/issues/9897))
- Installer: update go.d.plugin version to v0.22.0 ([#9898](https://github.com/netdata/netdata/issues/9898))
- Fix missing newline concatentation slash causing rpm build to fail ([#9900](https://github.com/netdata/netdata/issues/9900))
- Fix buffer overflow in rrdr structure when metric timestamps are out of order. ([#9903](https://github.com/netdata/netdata/issues/9903))
- Correctly fix handling of CI Slack notifications. ([#9902](https://github.com/netdata/netdata/issues/9902))
- Fixed another typo in the libJudy bundling code. ([#9904](https://github.com/netdata/netdata/issues/9904))
- Implements ACLK v2 http message with compression ([#9895](https://github.com/netdata/netdata/issues/9895))
- Change instruction to reload HEALTH ([#9869](https://github.com/netdata/netdata/issues/9869))
- Update supported collectors doc to organize by type ([#9513](https://github.com/netdata/netdata/issues/9513))
- Fix memory mode none not marking dimensions as obsolete. ([#9912](https://github.com/netdata/netdata/issues/9912))
- Fix memory mode none not dropping stale dimension data in general when streaming to a parent. ([#9917](https://github.com/netdata/netdata/issues/9917))
- [netdata minor release] v1.25.0

## [1.24.0] - 2020-08-10

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Suppress warning -Wformat-truncation in ACLK ([#9547](https://github.com/netdata/netdata/issues/9547))
- Revert the eBPF package bundling that breaks the release and DEB packages. ([#9552](https://github.com/netdata/netdata/issues/9552))
- Use the libbpf library for the eBPF plugin ([#9490](https://github.com/netdata/netdata/issues/9490))
- Change all instances of alarm to template ([#9553](https://github.com/netdata/netdata/issues/9553))
- Implemented default disk space size calculation for multihost db ([#9504](https://github.com/netdata/netdata/issues/9504))
- Implemented the HOST command in metadata log replay ([#9489](https://github.com/netdata/netdata/issues/9489))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Adding pihole to the dns app group ([#9557](https://github.com/netdata/netdata/issues/9557))
- Enable simple sandboxing on systemd service ([#9234](https://github.com/netdata/netdata/issues/9234))
- Add better checks for existing installs to the kickstart scripts. ([#9408](https://github.com/netdata/netdata/issues/9408))
- Add libbpf patch to make dist. ([#9571](https://github.com/netdata/netdata/issues/9571))
- Add CAP_SYS_RESOURCE to capability bounding set. ([#9569](https://github.com/netdata/netdata/issues/9569))
- Update CODEOWNERS
- Python.d: add job file lock registry ([#9564](https://github.com/netdata/netdata/issues/9564))
- Charts.d.plugin: never use `-t` option for `timeout` ([#9568](https://github.com/netdata/netdata/issues/9568))
- Replaces mempcpy with memcpy ([#9575](https://github.com/netdata/netdata/issues/9575))
- Network Viewer options ([#9495](https://github.com/netdata/netdata/issues/9495))
- Removed runtime support for Polymorphic Linux from our Docker containers. ([#9566](https://github.com/netdata/netdata/issues/9566))
- Added proper handling for autogen on Ubuntu 18.04 ([#9586](https://github.com/netdata/netdata/issues/9586))
- Add explicit CODEOWNERS rule for `system/`. ([#9587](https://github.com/netdata/netdata/issues/9587))
- Removed delay in updater script for non-interactive runs from install scripts. ([#9589](https://github.com/netdata/netdata/issues/9589))
- Added lock dir ([#9584](https://github.com/netdata/netdata/issues/9584))
- Sends netdata.public.unique.id (machine GUID) with claim ([#9574](https://github.com/netdata/netdata/issues/9574))
- Add alarms for FreeBSD interface errors ([#8340](https://github.com/netdata/netdata/issues/8340))
- Stop mdstat collector from looking up archived charts. ([#9583](https://github.com/netdata/netdata/issues/9583))
- Python.d/gearmand: handle func prefixes in `status\n` response ([#9610](https://github.com/netdata/netdata/issues/9610))
- Addd sandboxing exception for `/run/netdata`. ([#9613](https://github.com/netdata/netdata/issues/9613))
- Implemented multihost database ([#9556](https://github.com/netdata/netdata/issues/9556))
- Read socket information from kernel ring ([#9549](https://github.com/netdata/netdata/issues/9549))
- Added eBPF collector support to DEB and RPM packages. ([#9628](https://github.com/netdata/netdata/issues/9628))
- Fix netdata.spec.in default permissions for /usr/libexec/netdata ([#9621](https://github.com/netdata/netdata/issues/9621))
- Add documentation to provide a comprehensive guide for package maintainers ([#9467](https://github.com/netdata/netdata/issues/9467))
- Add 1.23.1 and 1.23.0 to news section ([#9518](https://github.com/netdata/netdata/issues/9518))
- Adjust check-kernel-config.sh to run in bash ([#9633](https://github.com/netdata/netdata/issues/9633))
- Require cloud build to succeed in make dist checks. ([#9218](https://github.com/netdata/netdata/issues/9218))
- Fetch libbpf from netdata fork ([#9637](https://github.com/netdata/netdata/issues/9637))
- Fix Travis CI and remove deprecated/removed builds that have no upstream LXC image ([#9630](https://github.com/netdata/netdata/issues/9630))
- Dashboard v1.0.26 ([#9639](https://github.com/netdata/netdata/issues/9639))
- Charts.d: fix `current_time_ms_from_date` on macOS ([#9636](https://github.com/netdata/netdata/issues/9636))
- Installer: fix `govercomp` ([#9646](https://github.com/netdata/netdata/issues/9646))
- Python.d: fix `find_binary` ([#9641](https://github.com/netdata/netdata/issues/9641))
- Fix Travis config ([#9655](https://github.com/netdata/netdata/issues/9655))
- Fix missing comma. ([#9656](https://github.com/netdata/netdata/issues/9656))
- Fix_gcc_10_warning: Fix warning when compiled on gcc-10.1 ([#9651](https://github.com/netdata/netdata/issues/9651))
- Nvidia_smi: charts for memory used by each user and number of distinct users ([#9372](https://github.com/netdata/netdata/issues/9372))
- Installer: update `go.d.plugin` version to v0.20.0 ([#9644](https://github.com/netdata/netdata/issues/9644))
- Detect a buggy Ubuntu kernel ([#9648](https://github.com/netdata/netdata/issues/9648))
- Hide archived chart from mdstat collector. ([#9667](https://github.com/netdata/netdata/issues/9667))
- Fix Static Netdata to correctly build with Netdata Cloud support. ([#9381](https://github.com/netdata/netdata/issues/9381))
- Remove obsoleted libraries from install/uninstall scripts ([#9661](https://github.com/netdata/netdata/issues/9661))
- Add support for DEB packages for Ubuntu 20.04 (focal) ([#9592](https://github.com/netdata/netdata/issues/9592))
- Stop multi-host DB statistics from being counted multiple times. ([#9685](https://github.com/netdata/netdata/issues/9685))
- [netdata minor release] v1.24.0

## [1.23.2] - 2020-07-16

### Merged Pull Requests:

- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Add guide for monitoring a k8s cluster with Netdata
- Fix broken link in Kavenegar notification doc ([#9492](https://github.com/netdata/netdata/issues/9492))
- Fix vulnerability in JSON parsing ([#9491](https://github.com/netdata/netdata/issues/9491))
- Fixed the check condition for chart name change ([#9503](https://github.com/netdata/netdata/issues/9503))
- Fix ACLK protocol version always parsed as 0 ([#9502](https://github.com/netdata/netdata/issues/9502))
- Remove the ability to update the chart family on the fly. ([#9509](https://github.com/netdata/netdata/issues/9509))
- Python.d: thread safe safe_print (stdout write) ([#9508](https://github.com/netdata/netdata/issues/9508))
- Charts.d: loopsleepms: fix now_ms ([#9510](https://github.com/netdata/netdata/issues/9510))
- Adds support for multiple ACLK query processing threads ([#9355](https://github.com/netdata/netdata/issues/9355))
- Remove health from archived metrics ([#9520](https://github.com/netdata/netdata/issues/9520))
- Mysql: respect `my.cnf` parameter using PyMySQL library ([#9526](https://github.com/netdata/netdata/issues/9526))
- Properly include eBPF collector in binary packages. ([#9450](https://github.com/netdata/netdata/issues/9450))
- Fix transition from archived to active charts not generating alarms. ([#9536](https://github.com/netdata/netdata/issues/9536))
- Remove Fedora 30 from CI. ([#9274](https://github.com/netdata/netdata/issues/9274))
- Disable CentOS 8.x CI (temporarily) ([#9538](https://github.com/netdata/netdata/issues/9538))
- Fixed stored number accuracy ([#9540](https://github.com/netdata/netdata/issues/9540))
- Fixes cmake build failing if ACLK is disabled ([#9537](https://github.com/netdata/netdata/issues/9537))
- Fix potential memory leak in ebpf.plugin ([#9484](https://github.com/netdata/netdata/issues/9484))
- Add eBPF bundling script to `make dist`. ([#9539](https://github.com/netdata/netdata/issues/9539))
- Update apps_groups.conf ([#9535](https://github.com/netdata/netdata/issues/9535))
- Fix compilation warnings ([#9544](https://github.com/netdata/netdata/issues/9544))
- Disable failing unit tests in CMake build ([#9545](https://github.com/netdata/netdata/issues/9545))
- Fix SHA256 handling in eBPF bundling code. ([#9546](https://github.com/netdata/netdata/issues/9546))
- [netdata patch release] v1.23.2

## [1.23.1_infiniband] - 2020-07-03

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Autodetects cgroupsv2 on systems with systemd ([#9249](https://github.com/netdata/netdata/issues/9249))
- Add notice to eBPF documentation about incompatibility with static builds ([#9418](https://github.com/netdata/netdata/issues/9418))
- Add first class support for FreeBSD ([#9413](https://github.com/netdata/netdata/issues/9413))
- Fix broken link to Polyverse in Docker documentation ([#9426](https://github.com/netdata/netdata/issues/9426))
- Finish adding notices ([#9422](https://github.com/netdata/netdata/issues/9422))
- Fix typo in netdata-installer.sh ([#9433](https://github.com/netdata/netdata/issues/9433))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Add infiniband monitoring to collector proc.plugin ([#9091](https://github.com/netdata/netdata/issues/9091))
- Wrap header definitions in compilation conditions ([#9458](https://github.com/netdata/netdata/issues/9458))
- Added missing caps letters ([#9379](https://github.com/netdata/netdata/issues/9379))
- Fixed typo in the streaming readme ([#9378](https://github.com/netdata/netdata/issues/9378))
- Fix a coverity defect ([#9462](https://github.com/netdata/netdata/issues/9462))
- UrlService add support get headers ([#9236](https://github.com/netdata/netdata/issues/9236))
- Ipfs-plugin: change HTTP method to make it compatible with ipfs 0.5.0+ ([#9248](https://github.com/netdata/netdata/issues/9248))
- Fixes error in Swagger Documentation ([#9417](https://github.com/netdata/netdata/issues/9417))
- Fix the exporting engine unit tests ([#9460](https://github.com/netdata/netdata/issues/9460))
- Add documentation for installing Netdata on k8s clusters ([#9364](https://github.com/netdata/netdata/issues/9364))
- Read the prefix option from instance config sections ([#9463](https://github.com/netdata/netdata/issues/9463))
- Bring code owner for missing directory ([#9465](https://github.com/netdata/netdata/issues/9465))

## [1.23.1] - 2020-07-01

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Stop reading from /proc/sys/kernel/osrelease at trailing newline. ([#9374](https://github.com/netdata/netdata/issues/9374))
- Fix internal registry  ([#9434](https://github.com/netdata/netdata/issues/9434))
- Fix children version on stream ([#9438](https://github.com/netdata/netdata/issues/9438))
- Update description in registry with minor copy edits ([#9441](https://github.com/netdata/netdata/issues/9441))
- Disallow dimensions or charts being obsoleted and archived simultaneously. ([#9436](https://github.com/netdata/netdata/issues/9436))
- Fix_unit_test: Fix the unittest execution ([#9445](https://github.com/netdata/netdata/issues/9445))
- Corrected virtualization detection in system-info.sh. ([#9425](https://github.com/netdata/netdata/issues/9425))
- Fixed duplicate alarm ids in health-log.db ([#9428](https://github.com/netdata/netdata/issues/9428))
- Show cgroups/containers ran by kubelet without access to kubernetes cluster information ([#9321](https://github.com/netdata/netdata/issues/9321))
- [netdata patch release] v1.23.1

## [1.23.0] - 2020-06-25

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Fix file name weblog.conf -> web_log.conf ([#8959](https://github.com/netdata/netdata/issues/8959))
- [varnish] : added compatibility for varnish-plus ([#8940](https://github.com/netdata/netdata/issues/8940))
- Postgres.chart.py: fix template databases ignore ([#8929](https://github.com/netdata/netdata/issues/8929))
- Update README news with 1.22 ([#8963](https://github.com/netdata/netdata/issues/8963))
- Add text to ACLK doc mentioning WebSockets and port ([#8968](https://github.com/netdata/netdata/issues/8968))
- Caddy section lacked data persist volumes ([#8999](https://github.com/netdata/netdata/issues/8999))
- Update daemon output with new URLs and dates ([#8965](https://github.com/netdata/netdata/issues/8965))
- Ebpf options ([#8879](https://github.com/netdata/netdata/issues/8879))
- Rename eBPF collector ([#8822](https://github.com/netdata/netdata/issues/8822))
- Add a Google Cloud Pub/Sub connector to the exporting engine ([#8855](https://github.com/netdata/netdata/issues/8855))
- Fix wrong hostnames in the exporting engine ([#8892](https://github.com/netdata/netdata/issues/8892))
- Account for zfs.arc_size.min, and correct calc ([#8913](https://github.com/netdata/netdata/issues/8913))
- Fixed formatting in API swagger json file ([#8814](https://github.com/netdata/netdata/issues/8814))
- Fix error handling in exporting connector ([#8910](https://github.com/netdata/netdata/issues/8910))
- Improve the impact of health code on netdata scalability ([#8407](https://github.com/netdata/netdata/issues/8407))
- Add text to claiming doc about reclaiming with id= ([#9027](https://github.com/netdata/netdata/issues/9027))
- Removed simley face per Chris since it didn't show up ([#8872](https://github.com/netdata/netdata/issues/8872))
- Fix link in web server log guide ([#9033](https://github.com/netdata/netdata/issues/9033))
- Docs: Remove old Cloud/dashboard and replace with new Cloud/dashboard ([#8874](https://github.com/netdata/netdata/issues/8874))
- Sort alphabetically and automatic scroll ([#8762](https://github.com/netdata/netdata/issues/8762))
- [python.d/samba] Only use sudo when not running as root user ([#9038](https://github.com/netdata/netdata/issues/9038))
- Add agent restart note for reclaiming ([#9049](https://github.com/netdata/netdata/issues/9049))
- Claim: fix `New/ephemeral Agent containers` instruction ([#9058](https://github.com/netdata/netdata/issues/9058))
- Update freebsd.md ([#8643](https://github.com/netdata/netdata/issues/8643))
- Typo. ([#8703](https://github.com/netdata/netdata/issues/8703))
- Add frontmatter to exporting connectors ([#9052](https://github.com/netdata/netdata/issues/9052))
- Add config for big CPUs and explain ([#9062](https://github.com/netdata/netdata/issues/9062))
- Python.d/proxysql: add `Requirements` to the readme ([#9071](https://github.com/netdata/netdata/issues/9071))
- Update the exporting documentation ([#9066](https://github.com/netdata/netdata/issues/9066))
- Add links to promote database engine calculator ([#9067](https://github.com/netdata/netdata/issues/9067))
- Clean instances ([#9081](https://github.com/netdata/netdata/issues/9081))
- Install and enable eBPF Plugin by default ([#8665](https://github.com/netdata/netdata/issues/8665))
- Reduce minimum size for dbengine disk space ([#9094](https://github.com/netdata/netdata/issues/9094))
- Fix issue #9085:  Prometheus TYPE lines incorrectly formatted (when enabled via query parm) ([#9086](https://github.com/netdata/netdata/issues/9086))
- Removeed Polyverse Polymorphic Linux from Docker builds. ([#8802](https://github.com/netdata/netdata/issues/8802))
- Fix typo in dashboard description ([#9096](https://github.com/netdata/netdata/issues/9096))
- Docs: Update contributing guidelines ([#8781](https://github.com/netdata/netdata/issues/8781))
- Update pfsense.md ([#8544](https://github.com/netdata/netdata/issues/8544))
- Update synology.md ([#8658](https://github.com/netdata/netdata/issues/8658))
- Include 'cmake' in the list of pkgs installed ([#9031](https://github.com/netdata/netdata/issues/9031))
- Add GitHub CI job to check Markdown links during PRs ([#9003](https://github.com/netdata/netdata/issues/9003))
- Don't overwrite netdata.conf on update on static installs. ([#9046](https://github.com/netdata/netdata/issues/9046))
- Prepare the main cleanup function for the exporting engine ([#9099](https://github.com/netdata/netdata/issues/9099))
- Add ACLK Connection Details ([#9047](https://github.com/netdata/netdata/issues/9047))
- Restore SIGCHLD signal handler after being replaced by libuv ([#9107](https://github.com/netdata/netdata/issues/9107))
- Regenerate topic base on connect ([#9044](https://github.com/netdata/netdata/issues/9044))
- Update eBPF documentation to reflect default enabled status ([#9105](https://github.com/netdata/netdata/issues/9105))
- Fix macOS builds building and linking against openssl ([#8865](https://github.com/netdata/netdata/issues/8865))
- Dynamic memory cleanup for MongoDB exporting connector ([#9103](https://github.com/netdata/netdata/issues/9103))
- Fix suid bits on plugin for debian packaging ([#8996](https://github.com/netdata/netdata/issues/8996))
- Improve system-info.sh to better handle certain cases when gathering info on the system's disk capacity. ([#7902](https://github.com/netdata/netdata/issues/7902))
- Update step-10.md ([#9000](https://github.com/netdata/netdata/issues/9000))
- Package: obsoletes conflicting EPEL packages (#6879 #8784) ([#9108](https://github.com/netdata/netdata/issues/9108))
- Fix paths to trigger docs CI workflow ([#9128](https://github.com/netdata/netdata/issues/9128))
- Remove old docs generation tooling ([#8783](https://github.com/netdata/netdata/issues/8783))
- Dynamic memory cleanup for Pub/Sub exporting connector ([#9112](https://github.com/netdata/netdata/issues/9112))
- Fix buffer splitting in the Kinesis exporting connector ([#9122](https://github.com/netdata/netdata/issues/9122))
- Fix docs CI to handle absolute links between docs ([#9132](https://github.com/netdata/netdata/issues/9132))
- Fixes enable/start of netdata service in debian package ([#9005](https://github.com/netdata/netdata/issues/9005))
- Send anonymous statistics from backends and exporting engine ([#9125](https://github.com/netdata/netdata/issues/9125))
- Revert "Fix macOS builds building and linking against openssl ([#8865](https://github.com/netdata/netdata/issues/8865))" ([#9137](https://github.com/netdata/netdata/issues/9137))
- Remove the unused Dockerfile.docs and associated Docker Hub image ([#9126](https://github.com/netdata/netdata/issues/9126))
- Check update interval for exporting connector instance ([#9131](https://github.com/netdata/netdata/issues/9131))
- Fix incorrect issue link URL in install-required-packages.sh ([#8911](https://github.com/netdata/netdata/issues/8911))
- Exporting cleanup ([#9098](https://github.com/netdata/netdata/issues/9098))
- Implement new incremental parser ([#9074](https://github.com/netdata/netdata/issues/9074))
- Correctly track last num vcpus in xenstat_plugin ([#8720](https://github.com/netdata/netdata/issues/8720))
- Added required bundle for libuuid on ClearLinux. ([#9060](https://github.com/netdata/netdata/issues/9060))
- Add CI for our Static Netdata builds (which kickstart-static64 uses) ([#9130](https://github.com/netdata/netdata/issues/9130))
- Introduce a random sleep in the Netdata updater ([#9079](https://github.com/netdata/netdata/issues/9079))
- Accept empty lines in parser ([#9158](https://github.com/netdata/netdata/issues/9158))
- Missing error aws ([#9048](https://github.com/netdata/netdata/issues/9048))
- Revert "Introduce a random sleep in the Netdata updater ([#9079](https://github.com/netdata/netdata/issues/9079))" ([#9161](https://github.com/netdata/netdata/issues/9161))
- New alarms (exporting and Backend) ([#9075](https://github.com/netdata/netdata/issues/9075))
- Missing checks exporting ([#9034](https://github.com/netdata/netdata/issues/9034))
- Fixed coverity warning (CID 358971) ([#9157](https://github.com/netdata/netdata/issues/9157))
- Move nc backend ([#9030](https://github.com/netdata/netdata/issues/9030))
- Fix typo in step-03.md ([#9150](https://github.com/netdata/netdata/issues/9150))
- OpenTSDB and TLS ([#9068](https://github.com/netdata/netdata/issues/9068))
- Change backends to exporting engine in general documentation pages ([#9045](https://github.com/netdata/netdata/issues/9045))
- Remove the experimental label from the exporting engine documentation ([#9171](https://github.com/netdata/netdata/issues/9171))
- Update the kernel-collector version to v0.2.0 ([#9118](https://github.com/netdata/netdata/issues/9118))
- Update README.md ([#9151](https://github.com/netdata/netdata/issues/9151))
- Remove knatsakis and ncmans from CODEOWNERS for the agent. ([#9173](https://github.com/netdata/netdata/issues/9173))
- Fix error > emerge openssl-devel ([#9141](https://github.com/netdata/netdata/issues/9141))
- Cov_358988: Remove coverity bug ([#9180](https://github.com/netdata/netdata/issues/9180))
- Fix missing ebpf packaging files from dist archive ([#9182](https://github.com/netdata/netdata/issues/9182))
- Add missing source code files and folder ([#9186](https://github.com/netdata/netdata/issues/9186))
- Added health check functionality to our Docker images. ([#9172](https://github.com/netdata/netdata/issues/9172))
- Clean type_name in exporting connector instance configuration ([#9188](https://github.com/netdata/netdata/issues/9188))
- Ceph: Added OSD size collection ([#8649](https://github.com/netdata/netdata/issues/8649))
- Fix exporting unit tests ([#9183](https://github.com/netdata/netdata/issues/9183))
- EBPF modular ([#9148](https://github.com/netdata/netdata/issues/9148))
- Fix small typo ([#9205](https://github.com/netdata/netdata/issues/9205))
- Update eBPF to use kernel-collector version 0.4.0. ([#9212](https://github.com/netdata/netdata/issues/9212))
- Add support for eBPF for Netdata static64 (kickstart-static64.sh) ([#9104](https://github.com/netdata/netdata/issues/9104))
- Add CI check for building against LibreSSL ([#8842](https://github.com/netdata/netdata/issues/8842)) ([#9216](https://github.com/netdata/netdata/issues/9216))
- Improve dbengine docs for streaming setups ([#9177](https://github.com/netdata/netdata/issues/9177))
- Fix compilation for older systems ([#9198](https://github.com/netdata/netdata/issues/9198))
- Really prevent overwriting netdata.conf on static installs. ([#9174](https://github.com/netdata/netdata/issues/9174))
- Fix reliability of kickstart/kickstart-static64 with checksums sometimes failing ([#9165](https://github.com/netdata/netdata/issues/9165))
- Add new exporting "home base" document ([#9246](https://github.com/netdata/netdata/issues/9246))
- Fix bugs in streaming and enable support for gap filling ([#9214](https://github.com/netdata/netdata/issues/9214))
- Add a random offset to the update script when running non-interactively. ([#9245](https://github.com/netdata/netdata/issues/9245))
- Fixes documentation ambiguity leading into issue #8239 ([#9255](https://github.com/netdata/netdata/issues/9255))
- Add dash ([#9262](https://github.com/netdata/netdata/issues/9262))
- Add notes/known issues section to installation page ([#9053](https://github.com/netdata/netdata/issues/9053))
- Cleanup of main README and registry doc ([#9265](https://github.com/netdata/netdata/issues/9265))
- Move/refactor docs to accomodate new Guides section on Learn ([#9266](https://github.com/netdata/netdata/issues/9266))
- Fix Coverity defects 359164, 359165 and 358989. ([#9268](https://github.com/netdata/netdata/issues/9268))
- Update apps.plugin documentation and dashboard.info ([#9199](https://github.com/netdata/netdata/issues/9199))
- Fixed handling of OpenSSL on CentOS/RHEL by bundling a static copy and selecting a configuration directory at install time. ([#9263](https://github.com/netdata/netdata/issues/9263))
- Single quote apostrophe ([#8723](https://github.com/netdata/netdata/issues/8723))
- Add link to kernel docs for ftrace ([#9211](https://github.com/netdata/netdata/issues/9211))
- Added support for macOS/Homebrew in `install-required-packages.sh`. ([#8286](https://github.com/netdata/netdata/issues/8286))
- Support for matrix notifications ([#9196](https://github.com/netdata/netdata/issues/9196))
- Dashboard_info.js: ebpf: fix close code block ([#9293](https://github.com/netdata/netdata/issues/9293))
- Installer: update go.d.plugin version to v0.19.0 ([#9294](https://github.com/netdata/netdata/issues/9294))
- Add revisions to Matrix doc ([#9295](https://github.com/netdata/netdata/issues/9295))
- Fix crash in #9291 ([#9297](https://github.com/netdata/netdata/issues/9297))
- Minor copy edits ([#9298](https://github.com/netdata/netdata/issues/9298))
- Update_apps_groups: Bring imunify and lsphp to apps groups ([#9284](https://github.com/netdata/netdata/issues/9284))
- Add verbose prints when spawn server fails to spawn. ([#9305](https://github.com/netdata/netdata/issues/9305))
- Add guide to exporting metrics to Graphite ([#9285](https://github.com/netdata/netdata/issues/9285))
- Installer: update go.d.plugin version to v0.19.1 ([#9309](https://github.com/netdata/netdata/issues/9309))
- Fix remote write HTTP header ([#9302](https://github.com/netdata/netdata/issues/9302))
- Correct the repo in the docs for CentOS 8. ([#9308](https://github.com/netdata/netdata/issues/9308))
- Ensures we get consistent kubernetes cgroup container names, regardless of whether netdata runs from within a kubernetes pod, or directly on the host machine. ([#9303](https://github.com/netdata/netdata/issues/9303))
- Apps_groups.conf: add agent-service-discovery ([#9315](https://github.com/netdata/netdata/issues/9315))
- Added dummy `--enable-ebpf` flag to avoid breaking updates. ([#9310](https://github.com/netdata/netdata/issues/9310))
- Adds metrics for ACLK performance and status ([#9269](https://github.com/netdata/netdata/issues/9269))
- Adds missing files for streaming changes into cmake build ([#9316](https://github.com/netdata/netdata/issues/9316))
- Add support for persistent metadata ([#9324](https://github.com/netdata/netdata/issues/9324))
- Override linker and include paths for static builds. ([#9311](https://github.com/netdata/netdata/issues/9311))
- Fix check for remote write header in unit tests ([#9318](https://github.com/netdata/netdata/issues/9318))
- Integration between eBPF and Apps ([#9178](https://github.com/netdata/netdata/issues/9178))
- Fixed invalid pointer access `rrddim_free_custom` ([#9326](https://github.com/netdata/netdata/issues/9326))
- Remove Gentoo from CI ([#9327](https://github.com/netdata/netdata/issues/9327))
- Change streaming terminology to parent-child in the code ([#9323](https://github.com/netdata/netdata/issues/9323))
- Change streaming terminology to parent/child in docs ([#9312](https://github.com/netdata/netdata/issues/9312))
- Fixed compiler warnings ([#9337](https://github.com/netdata/netdata/issues/9337))
- Fix coverity errors CID 359774 and CID 359773 ([#9338](https://github.com/netdata/netdata/issues/9338))
- Installer: update go.d.plugin version to v0.19.2 ([#9340](https://github.com/netdata/netdata/issues/9340))
- Fix issues on ebpf.plugin ([#9333](https://github.com/netdata/netdata/issues/9333))
- Improve PR Guidelines for Developers and Contributors. ([#8809](https://github.com/netdata/netdata/issues/8809))
- Get netdata execution path early to avoid user permission issues ([#9339](https://github.com/netdata/netdata/issues/9339))
- Revert "Override linker and include paths for static builds. ([#9311](https://github.com/netdata/netdata/issues/9311))" ([#9343](https://github.com/netdata/netdata/issues/9343))
- Replace assert calls ([#9349](https://github.com/netdata/netdata/issues/9349))
- Dashboard v1.0.14_2 ([#9350](https://github.com/netdata/netdata/issues/9350))
- Add missing slash ([#9257](https://github.com/netdata/netdata/issues/9257))
- Fixed ACLK shutdown sequence ([#9367](https://github.com/netdata/netdata/issues/9367))
- Improved error handling and recovery during compaction and metadata log replay ([#9354](https://github.com/netdata/netdata/issues/9354))
- Fixes the race-hazard in streaming during the shutdown sequence ([#9370](https://github.com/netdata/netdata/issues/9370))
- Add libuv thread names support to FATAL log level ([#9382](https://github.com/netdata/netdata/issues/9382))
- Fixed concurrency bug in health sending HOST VARIABLE to receiver ([#9396](https://github.com/netdata/netdata/issues/9396))
- Update freebsd.md ([#9116](https://github.com/netdata/netdata/issues/9116))
- Add guide for troubleshooting with eBPF metrics ([#9352](https://github.com/netdata/netdata/issues/9352))
- Fix a bug in the simple exporting connector ([#9389](https://github.com/netdata/netdata/issues/9389))
- Update synology.md ([#9400](https://github.com/netdata/netdata/issues/9400))
- Added OpenSSL to list of dependencies for Netdata Cloud. ([#9398](https://github.com/netdata/netdata/issues/9398))
- Fix Coverity Defect CID 304732 ([#9402](https://github.com/netdata/netdata/issues/9402))
- Fix PR title guideline examples in CONTRIBUTING guidelines
- [netdata minor release] v1.23.0

## [1.22.1] - 2020-05-12

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Docs: Update with go-live claiming and ACLK information ([#8859](https://github.com/netdata/netdata/issues/8859)) ([#8960](https://github.com/netdata/netdata/issues/8960))
- Fix shutdown via netdatacli with musl C library ([#8931](https://github.com/netdata/netdata/issues/8931))
- Docs: Fix internal links and remove obsolete admonitions ([#8946](https://github.com/netdata/netdata/issues/8946))
- Remove UNUSED word from flood protection configuration options documentation. ([#8964](https://github.com/netdata/netdata/issues/8964))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Remove check for old alarm status ([#8978](https://github.com/netdata/netdata/issues/8978))
- Fixed bundling of React dashboard in DEB and RPM packages. ([#8988](https://github.com/netdata/netdata/issues/8988))
- Added JSON-C packaging fils to make dist. ([#8986](https://github.com/netdata/netdata/issues/8986))
- Restore old semantics of "netdata -W set" command ([#8987](https://github.com/netdata/netdata/issues/8987))
- Fix the latency issue on the ACLK and suppress the diagnostics ([#8992](https://github.com/netdata/netdata/issues/8992))
- [netdata patch release] v1.22.1

## [1.22.0] - 2020-05-11

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Revert "Revert changes since v1.21 in pereparation for hotfix release."
- Explicitly include libffi on ArchLinux CI tests. ([#8699](https://github.com/netdata/netdata/issues/8699))
- Fixes compatibility with RH 7.x family ([#8694](https://github.com/netdata/netdata/issues/8694))
- Yamllint: enable truthy rule ([#8698](https://github.com/netdata/netdata/issues/8698))
- Packaging/docker/publish.sh: Publish docker images synchronously ([#8701](https://github.com/netdata/netdata/issues/8701))
- Packaging/docker/{build,publish}.sh: Remove DEVEL support ([#8702](https://github.com/netdata/netdata/issues/8702))
- Docs: Standardize links between documentation ([#8638](https://github.com/netdata/netdata/issues/8638))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Fix the build matrix in the build & install checks. ([#8715](https://github.com/netdata/netdata/issues/8715))
- Remove useless scripts ([#8704](https://github.com/netdata/netdata/issues/8704))
- Added certificate revocation alert ([#8684](https://github.com/netdata/netdata/issues/8684))
- Improved ACLK reconnection sequence  ([#8708](https://github.com/netdata/netdata/issues/8708))
- Revert "Improved ACLK reconnection sequence  ([#8708](https://github.com/netdata/netdata/issues/8708))" ([#8728](https://github.com/netdata/netdata/issues/8728))
- Improved ACLK reconnection sequence ([#8729](https://github.com/netdata/netdata/issues/8729))
- Packaging/docker/publish.sh: Wait for tag to appear in hub.docker.com ([#8713](https://github.com/netdata/netdata/issues/8713))
- Charts.d/apcupsd: fix ups status check ([#8688](https://github.com/netdata/netdata/issues/8688))
- Docs: Combined claiming+ACLK documentation ([#8724](https://github.com/netdata/netdata/issues/8724))
- Fix docs Docker-based builde riamge ([#8718](https://github.com/netdata/netdata/issues/8718))
- Added support for building libmosquitto on FreeBSD/macOS. ([#8254](https://github.com/netdata/netdata/issues/8254))
- Fix crash when shutdown with ACLK disabled ([#8725](https://github.com/netdata/netdata/issues/8725))
- Additional cases for the thread exit fix ([#8750](https://github.com/netdata/netdata/issues/8750))
- Dashboard v.0.4.17: ([#8757](https://github.com/netdata/netdata/issues/8757))
- Add Fedora 32 to build checks. ([#8417](https://github.com/netdata/netdata/issues/8417))
- Fix_lock: Add the missing lock ([#8780](https://github.com/netdata/netdata/issues/8780))
- Added missing path ([#8740](https://github.com/netdata/netdata/issues/8740))
- Added whoisquery health templates ([#8700](https://github.com/netdata/netdata/issues/8700))
- Ebpf index size ([#8743](https://github.com/netdata/netdata/issues/8743))
- Improved offline installation instructions ([#8680](https://github.com/netdata/netdata/issues/8680))
- Update pfSense doc and add warning for apcupsd users ([#8686](https://github.com/netdata/netdata/issues/8686))
- Added JSON-C dependency handling to instlal and packaging. ([#8776](https://github.com/netdata/netdata/issues/8776))
- Web/gui/demo2.html: Silence Netlify's mixed content warnings ([#8759](https://github.com/netdata/netdata/issues/8759))
- Capitalize title ([#8712](https://github.com/netdata/netdata/issues/8712))
- Docs: Add Docker instructions to claiming ([#8755](https://github.com/netdata/netdata/issues/8755))
- Fixed issue in `system-info.sh`regarding the parsing of `lscpu` output. ([#8754](https://github.com/netdata/netdata/issues/8754))
- Health/portcheck: remove no-clear-notification ([#8748](https://github.com/netdata/netdata/issues/8748))
- Dashboard v0.4.18 ([#8786](https://github.com/netdata/netdata/issues/8786))
- Health: fix mdstat `failed devices` alarm ([#8794](https://github.com/netdata/netdata/issues/8794))
- Add http headers to responses ([#8760](https://github.com/netdata/netdata/issues/8760))
- Packaging/docker/{build,publish}.sh: Simplify scripts. Support only single ARCH ([#8747](https://github.com/netdata/netdata/issues/8747))
- Use a prefix for the old dashboard. ([#8752](https://github.com/netdata/netdata/issues/8752))
- Fix build and add bundle-dashbaord.sh to dist_noinst_DATA ([#8823](https://github.com/netdata/netdata/issues/8823))
- Removed old function call in netdata-installer.sh ([#8824](https://github.com/netdata/netdata/issues/8824))
- Fix typo in netdata-installer ([#8811](https://github.com/netdata/netdata/issues/8811))
- Bind to should be in [web] section and update netdata.service.v235.in too ([#8454](https://github.com/netdata/netdata/issues/8454))
- Fix bundling of dashboard in binary packages. ([#8844](https://github.com/netdata/netdata/issues/8844))
- Add CI check for building against LibreSSL ([#8842](https://github.com/netdata/netdata/issues/8842))
- Revert "Add CI check for building against LibreSSL ([#8842](https://github.com/netdata/netdata/issues/8842))"
- Correct typo ([#8861](https://github.com/netdata/netdata/issues/8861))
- Fix kickstart error removing old cron symlink ([#8849](https://github.com/netdata/netdata/issues/8849))
- Added docmentation about workaround for clang build errors. ([#8867](https://github.com/netdata/netdata/issues/8867))
- Update Running-behind-nginx.md ([#8880](https://github.com/netdata/netdata/issues/8880))
- Fix missing NETDATA_STOP_CMD in netdata-installer.sh ([#8897](https://github.com/netdata/netdata/issues/8897))
- Github/workflow: disable `document-start` yamllint check ([#8522](https://github.com/netdata/netdata/issues/8522))
- Fix command name for getting postfix queue ([#8857](https://github.com/netdata/netdata/issues/8857))
- Docs: Add instructions to persist metrics and restart policy ([#8813](https://github.com/netdata/netdata/issues/8813))
- Docs: Add custom label to collectors frontmatter to fix sidebar titles ([#8936](https://github.com/netdata/netdata/issues/8936))
- Updates main copyright and links for the year 2020 ([#8937](https://github.com/netdata/netdata/issues/8937))
- Enable support for Netdata Cloud.
- [netdata minor release] v1.22.0

## [1.21.1] - 2020-04-13

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Prometheus web api connector ([#8540](https://github.com/netdata/netdata/issues/8540))
- Remove an automatic restart of the apps.plugin ([#8592](https://github.com/netdata/netdata/issues/8592))
- Charts.d/libreswan: fix sudo check ([#8569](https://github.com/netdata/netdata/issues/8569))
- Packaging: fix errors during install-requred-packages ([#8606](https://github.com/netdata/netdata/issues/8606))
- Docs: Change MacOS to macOS ([#8562](https://github.com/netdata/netdata/issues/8562))
- Update main README with 1.21 release news ([#8619](https://github.com/netdata/netdata/issues/8619))
- Health Alarm to Dynatrace Event implementation ([#8476](https://github.com/netdata/netdata/issues/8476))
- Collectors/python.d: change threads_creation_rate context to `mysql.threads_creation_rate` ([#8636](https://github.com/netdata/netdata/issues/8636))
- Pin mkdocs-material ([#8639](https://github.com/netdata/netdata/issues/8639))
- Update apps_groups.conf ([#8646](https://github.com/netdata/netdata/issues/8646))
- Add session-id using connect timestamp ([#8633](https://github.com/netdata/netdata/issues/8633))
- Health/alarm_notify: add dynatrace enabled check ([#8654](https://github.com/netdata/netdata/issues/8654))
- Update apps_groups.conf ([#8656](https://github.com/netdata/netdata/issues/8656))
- Update apps_groups.conf ([#8655](https://github.com/netdata/netdata/issues/8655))
- Update apps_groups.conf ([#8659](https://github.com/netdata/netdata/issues/8659))
- Improved ACLK memory management and shutdown sequence ([#8611](https://github.com/netdata/netdata/issues/8611))
- Show internal stats for the exporting engine ([#8635](https://github.com/netdata/netdata/issues/8635))
- V1.21.0 dashboard performance fix extended ([#8664](https://github.com/netdata/netdata/issues/8664))
- Revert changes since v1.21 in pereparation for hotfix release.
- [netdata patch release] v1.21.1

## [1.21.0] - 2020-04-06

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- Tutorials to support v1.20 release ([#7943](https://github.com/netdata/netdata/issues/7943))
- Added support for cross-host docker-compose builds ([#7754](https://github.com/netdata/netdata/issues/7754))
- Update the manual install documentation with better info. ([#8088](https://github.com/netdata/netdata/issues/8088))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Revert "Revert "Added hack to sha256sums.txt to force users of NetData on v1.19.0-483 with a broken updater to update to latest ([#8057](https://github.com/netdata/netdata/issues/8057))" ([#8076](https://github.com/netdata/netdata/issues/8076))" ([#8141](https://github.com/netdata/netdata/issues/8141))
- Remove OpenSUSE Leap 15.0 from CI. ([#7990](https://github.com/netdata/netdata/issues/7990))
- Remove Ubuntu 19.04 from CI and packaging. ([#8040](https://github.com/netdata/netdata/issues/8040))
- Added support for Clear Linux in `install-required-packages.sh`. ([#8154](https://github.com/netdata/netdata/issues/8154))
- Remove Fedora 29 from CI and packaging. ([#8100](https://github.com/netdata/netdata/issues/8100))
- Revert "Revert "Revert "Added hack to sha256sums.txt to force users of NetData on v1.19.0-483 with a broken updater to update to latest ([#8057](https://github.com/netdata/netdata/issues/8057))" ([#8076](https://github.com/netdata/netdata/issues/8076))" ([#8141](https://github.com/netdata/netdata/issues/8141))" ([#8158](https://github.com/netdata/netdata/issues/8158))
- Openldap: fix dict access with python3 ([#8162](https://github.com/netdata/netdata/issues/8162))
- Backup group updated, added lsyncd ([#8159](https://github.com/netdata/netdata/issues/8159))
- Merging the feature branch for the ACLK in the previous sprint. ([#8179](https://github.com/netdata/netdata/issues/8179))
- Gihtub/actions: switch to checkout@v2 ([#8170](https://github.com/netdata/netdata/issues/8170))
- Fix formatting in "Custom dashboards" section ([#8102](https://github.com/netdata/netdata/issues/8102))
- Docs: Added PR title guidelines to the contribution guidelines, to make CHANGELOG more meaningful ([#8150](https://github.com/netdata/netdata/issues/8150))
- Packaging/installer: fix get_latest_version for nightly channel ([#8172](https://github.com/netdata/netdata/issues/8172))
- Correct installation instruction for apache2 ([#8169](https://github.com/netdata/netdata/issues/8169))
- Restrict GA message ([#8161](https://github.com/netdata/netdata/issues/8161))
- Docs: Fixed figure+image without closing tag ([#8177](https://github.com/netdata/netdata/issues/8177))
- Added eBPF to docs navigation and improved title ([#8191](https://github.com/netdata/netdata/issues/8191))
- Fix bold text surplus stars ([#8193](https://github.com/netdata/netdata/issues/8193))
- Add an AWS Kinesis connector to the exporting engine ([#8145](https://github.com/netdata/netdata/issues/8145))
- Added libwebsockets bundling code to netdata-installer.sh ([#8144](https://github.com/netdata/netdata/issues/8144))
- Removed tmem stat collection from xenstat plugin for Xen 4.13 ([#7951](https://github.com/netdata/netdata/issues/7951))
- Fixed type ([#8213](https://github.com/netdata/netdata/issues/8213))
- Add support to new kernels ([#8192](https://github.com/netdata/netdata/issues/8192))
- Retry transient failures from our lifecycle tests on Travis CI ([#8203](https://github.com/netdata/netdata/issues/8203))
- Fix claiming script ([#8220](https://github.com/netdata/netdata/issues/8220))
- Packaging/installer: fix bundle_libwebsockets ([#8219](https://github.com/netdata/netdata/issues/8219))
- Adding support for ACLK build-configuration ([#8223](https://github.com/netdata/netdata/issues/8223))
- Removed reviewdog golang check. ([#8221](https://github.com/netdata/netdata/issues/8221))
- Added connections (backend) usage to postgres monitoring ([#8126](https://github.com/netdata/netdata/issues/8126))
- Implement OpenGraph and basic Schema tags ([#8224](https://github.com/netdata/netdata/issues/8224))
- Adapt the claiming script to new API responses ([#8245](https://github.com/netdata/netdata/issues/8245))
- Fix misspelling of openSUSE and SUSE ([#8233](https://github.com/netdata/netdata/issues/8233))
- Added requirements for exim. Issue #8087 ([#8096](https://github.com/netdata/netdata/issues/8096))
- Vernemq alarms, dashboard info and godplugin new version ([#8236](https://github.com/netdata/netdata/issues/8236))
- Add SRE team as code owners for Debian packaging files. ([#8256](https://github.com/netdata/netdata/issues/8256))
- Added Docker build tests to PR checks. ([#8257](https://github.com/netdata/netdata/issues/8257))
- Revert "Added Docker build tests to PR checks. ([#8257](https://github.com/netdata/netdata/issues/8257))" ([#8260](https://github.com/netdata/netdata/issues/8260))
- Disable Schema tag in documentation ([#8264](https://github.com/netdata/netdata/issues/8264))
- Tweak eBPF documentation and add performance data ([#8261](https://github.com/netdata/netdata/issues/8261))
- Fixed misplaced commas ([#8266](https://github.com/netdata/netdata/issues/8266))
- Add libwebsockets files to make dist. ([#8275](https://github.com/netdata/netdata/issues/8275))
- Added ability to change ID used to connect to ceph. ([#8276](https://github.com/netdata/netdata/issues/8276))
- Fix RHEL / CentOS 8.x dependencies for Judy-devel and others ([#8202](https://github.com/netdata/netdata/issues/8202))
- Fixed Travis CI build handling. ([#8288](https://github.com/netdata/netdata/issues/8288))
- Python.d/ceph: fix get_osd_perf() for 14.2+ ([#8248](https://github.com/netdata/netdata/issues/8248))
- Add yamllint to reviewdog PR checks. ([#8291](https://github.com/netdata/netdata/issues/8291))
- ACLK  cmake fixes ([#8280](https://github.com/netdata/netdata/issues/8280))
- Minor fixes for the yamllint CI. ([#8302](https://github.com/netdata/netdata/issues/8302))
- Added ability to get pod name from cgroup with kubectl in bare metal deployment ([#7416](https://github.com/netdata/netdata/issues/7416))
- Updated PR labeling to utilize new area/build label. ([#8310](https://github.com/netdata/netdata/issues/8310))
- Support rhel by not installing the cups plugin when v1.7 is not satisfiable ([#7216](https://github.com/netdata/netdata/issues/7216))
- Switch to pulling in Python 3 by default instead of Python 2. ([#8318](https://github.com/netdata/netdata/issues/8318))
- Add acronyms to style guide ([#8313](https://github.com/netdata/netdata/issues/8313))
- Revert "Fixed Source0 URL in RPM spec ([#7794](https://github.com/netdata/netdata/issues/7794))" ([#8305](https://github.com/netdata/netdata/issues/8305))
- Fix missing folders in `/var/` ([#8314](https://github.com/netdata/netdata/issues/8314))
- Remvoed the use of clang-format that does not actually block PRs or surface anything to developers #8188 ([#8196](https://github.com/netdata/netdata/issues/8196))
- Removed extra printed `\n` ([#8324](https://github.com/netdata/netdata/issues/8324))
- Removed extra printed `\n` ([#8325](https://github.com/netdata/netdata/issues/8325))
- Removed extra printed `\n` ([#8326](https://github.com/netdata/netdata/issues/8326))
- Fixed dependency names for Arch Linux. ([#8334](https://github.com/netdata/netdata/issues/8334))
- Added Docker build tests to PR checks. ([#8262](https://github.com/netdata/netdata/issues/8262))
- Fix dependencies for Debian Jessie. ([#8290](https://github.com/netdata/netdata/issues/8290))
- Add retries for more Travis transient failures ([#8327](https://github.com/netdata/netdata/issues/8327))
- Rename the review workflow and be consistent about workflow and job names. ([#8332](https://github.com/netdata/netdata/issues/8332))
- CLeanup CODEOWNERS for the build system itself (not to be confused with packaging) ([#8098](https://github.com/netdata/netdata/issues/8098))
- Migrate Travis based checks to Github Actions ([#8329](https://github.com/netdata/netdata/issues/8329))
- Remove mention saying that .deb packages are experimental ([#8250](https://github.com/netdata/netdata/issues/8250))
- Added code to bundle LWS in binary packages. ([#8255](https://github.com/netdata/netdata/issues/8255))
- Fix installation for ubuntu 14.04 ([#7690](https://github.com/netdata/netdata/issues/7690))
- Fixed typo ([#8335](https://github.com/netdata/netdata/issues/8335))
- Added various fixes and improvements to the installers. ([#8315](https://github.com/netdata/netdata/issues/8315))
- Fix links in packaging/installer to work on GitHub and docs ([#8319](https://github.com/netdata/netdata/issues/8319))
- Consolidate and clean up artifact validation. ([#8352](https://github.com/netdata/netdata/issues/8352))
- Remove the confusion around the multiple Dockerfile(s) we have ([#8214](https://github.com/netdata/netdata/issues/8214))
- Fix cosmetic error checking for CentOS 8 version in install-required-packages ([#8339](https://github.com/netdata/netdata/issues/8339))
- Migrate coverity-scan to Github Actions ([#8321](https://github.com/netdata/netdata/issues/8321))
- Remove possible erroneous blank line causing Travis to fail possibly and default to magical behaviour ([#8355](https://github.com/netdata/netdata/issues/8355))
- Improve ACLK according to results of the smoke-test. ([#8358](https://github.com/netdata/netdata/issues/8358))
- Add packaging/bundle-lws.sh to dist_noinst_DATA (was missed) ([#8356](https://github.com/netdata/netdata/issues/8356))
- Ebpf plugin info typo fix ([#8360](https://github.com/netdata/netdata/issues/8360))
- Added quotes around markdown=1 ([#8362](https://github.com/netdata/netdata/issues/8362))
- Bulk add frontmatter to all documentation ([#8354](https://github.com/netdata/netdata/issues/8354))
- Add proper parsing/stripping of comments around docs frontmatter ([#8372](https://github.com/netdata/netdata/issues/8372))
- Change topics for ACLK ([#8374](https://github.com/netdata/netdata/issues/8374))
- New version of godplugin and pulsar alarms, dashboard info ([#8364](https://github.com/netdata/netdata/issues/8364))
- Fix Travis configuration for nightly builds. ([#8376](https://github.com/netdata/netdata/issues/8376))
- Improve Pull Request template to have a shorter testing section with enhanced instructions ([#8357](https://github.com/netdata/netdata/issues/8357))
- Docs: fix go.d modules in the COLLECTORS.md ([#8380](https://github.com/netdata/netdata/issues/8380))
- Format of commit messages ([#8365](https://github.com/netdata/netdata/issues/8365))
- Add deferred error message handling to the installer. ([#8381](https://github.com/netdata/netdata/issues/8381))
- Add a Prometheus Remote Write connector to the exporting engine ([#8292](https://github.com/netdata/netdata/issues/8292))
- Add Patti's video to docs ([#8385](https://github.com/netdata/netdata/issues/8385))
- Enconde slave fields ([#8216](https://github.com/netdata/netdata/issues/8216))
- Migrate make dist validation to GHA Workflows ([#8373](https://github.com/netdata/netdata/issues/8373))
- Update paragraph on install-required-packages ([#8347](https://github.com/netdata/netdata/issues/8347))
- Fix coverity scan ([#8388](https://github.com/netdata/netdata/issues/8388))
- Correct a typo in .travis/README.md ([#8333](https://github.com/netdata/netdata/issues/8333))
- ACLK: Improved the agent "pop-corning" phase ([#8398](https://github.com/netdata/netdata/issues/8398))
- Migrate Tests from Travis CI to Github Workflows ([#8331](https://github.com/netdata/netdata/issues/8331))
- Improving the ACLK performance - initial changes ([#8399](https://github.com/netdata/netdata/issues/8399))
- Improved the performance of the ACLK. ([#8391](https://github.com/netdata/netdata/issues/8391)) ([#8401](https://github.com/netdata/netdata/issues/8401))
- Update the type message for the alarm updates ([#8403](https://github.com/netdata/netdata/issues/8403))
- Support SOCKS5 in ACLK Challenge/Response and rewrite with LWS ([#8404](https://github.com/netdata/netdata/issues/8404))
- Fix streaming scaling ([#8375](https://github.com/netdata/netdata/issues/8375))
- Fix Prometheus Remote Write build ([#8411](https://github.com/netdata/netdata/issues/8411))
- Add mising files to CMake ([#8412](https://github.com/netdata/netdata/issues/8412))
- General cleanup of GitHub Actions workflows. ([#8383](https://github.com/netdata/netdata/issues/8383))
- Fix outstanding problems in claiming and add SOCKS5 support. ([#8406](https://github.com/netdata/netdata/issues/8406))
- Fixed JSON parsing ([#8426](https://github.com/netdata/netdata/issues/8426))
- ACLK: Implemented Last Will and Testament ([#8410](https://github.com/netdata/netdata/issues/8410))
- Fix the new cloud info in the info endpoint ([#8430](https://github.com/netdata/netdata/issues/8430))
- Fixed response payload to match the new specification ([#8420](https://github.com/netdata/netdata/issues/8420))
- Health: add dns_query module alarm ([#8434](https://github.com/netdata/netdata/issues/8434))
- Fix the ACLK installation with the installer switch ([#8443](https://github.com/netdata/netdata/issues/8443))
- Fix broken dependencies for Ubuntu 19.10 (eoan) ([#8397](https://github.com/netdata/netdata/issues/8397))
- Update the update instructions with per-method details ([#8394](https://github.com/netdata/netdata/issues/8394))
- Fix syntax error in claiming script. ([#8452](https://github.com/netdata/netdata/issues/8452))
- Improve installer output re newlines ([#8447](https://github.com/netdata/netdata/issues/8447))
- Fixes support for uninstalling the eBPF collector in the uninstaller and fixes a minor bug ([#8444](https://github.com/netdata/netdata/issues/8444))
- Memory leak with labels on stream ([#8460](https://github.com/netdata/netdata/issues/8460))
- Add high precision timer support for plugins such as idlejitter. ([#8441](https://github.com/netdata/netdata/issues/8441))
- Fix flushing error threshold ([#8425](https://github.com/netdata/netdata/issues/8425))
- Adding the claiming script to the packaging multi-stage Dockerfile whitelist ([#8465](https://github.com/netdata/netdata/issues/8465))
- Installer creates claim.d but is run as root, patch to correct ownership ([#8475](https://github.com/netdata/netdata/issues/8475))
- Added Docker build arg to pass extra options to installer. ([#8472](https://github.com/netdata/netdata/issues/8472))
- HTTP proxy support + some cleanup ([#8418](https://github.com/netdata/netdata/issues/8418))
- Fix the lack of cleanup in the netdata updater ([#8414](https://github.com/netdata/netdata/issues/8414))
- Minor - makes ACLK build fail more prominent ([#8470](https://github.com/netdata/netdata/issues/8470))
- Python.d.plugin: add prefix to the module name during loading s… ([#8474](https://github.com/netdata/netdata/issues/8474))
- Report ACLK Connection Failure ([#8456](https://github.com/netdata/netdata/issues/8456))
- Fake collector to provoke ACLK messages ([#8427](https://github.com/netdata/netdata/issues/8427))
- Fix install-required-packages script to self-update apt ([#8491](https://github.com/netdata/netdata/issues/8491))
- Fix erroneous \n printed in uninstaller ([#8446](https://github.com/netdata/netdata/issues/8446))
- Packaging/docker: add --build-arg CFLAGS support ([#8485](https://github.com/netdata/netdata/issues/8485))
- Installer: update go.d.plugin version to v0.18.0 ([#8477](https://github.com/netdata/netdata/issues/8477))
- Python.d/SimpleService: fix module name ([#8492](https://github.com/netdata/netdata/issues/8492))
- Fix openSUSE 15.1 RPM Package Buidls ([#8494](https://github.com/netdata/netdata/issues/8494))
- Allow insecure SSL in the testing environment ([#8489](https://github.com/netdata/netdata/issues/8489))
- Improved ACLK  ([#8498](https://github.com/netdata/netdata/issues/8498))
- Report Why ACLK build failed ([#8429](https://github.com/netdata/netdata/issues/8429))
- Adds install-fake-charts.d.sh to gitignore ([#8502](https://github.com/netdata/netdata/issues/8502))
- Remove stackscale and clean up page ([#8509](https://github.com/netdata/netdata/issues/8509))
- Github: add ACLK to the labeler config ([#8521](https://github.com/netdata/netdata/issues/8521))
- Fix auto updates for static installs (kickstart_static64.sh) ([#8507](https://github.com/netdata/netdata/issues/8507))
- Fix our Debian/Ubuntu packages to actually package the SystemD Unit files we expect. ([#8468](https://github.com/netdata/netdata/issues/8468))
- Add a MongoDB connector to the exporting engine ([#8416](https://github.com/netdata/netdata/issues/8416))
- Enhanced ACLK header payload to include timestamp-offset-usec ([#8499](https://github.com/netdata/netdata/issues/8499))
- Fix minimist vulnerability ([#8537](https://github.com/netdata/netdata/issues/8537))
- Cleans up cloud config files [agent_cloud_link] -> [cloud] ([#8501](https://github.com/netdata/netdata/issues/8501))
- Write the failure reason during ACLK challenge / response ([#8538](https://github.com/netdata/netdata/issues/8538))
- Charts.d.plugin: add keepalive to global_update ([#8529](https://github.com/netdata/netdata/issues/8529))
- Updating the info endpoint for cloud notifications ([#8519](https://github.com/netdata/netdata/issues/8519))
- Yamllint: increase line length 80=>120 ([#8542](https://github.com/netdata/netdata/issues/8542))
- Add python.d configuration files to the yaml-files ([#8541](https://github.com/netdata/netdata/issues/8541))
- Switched to the new React dashboard code as the default dashboard. ([#8363](https://github.com/netdata/netdata/issues/8363))
- Improve the behavior of claiming ([#8516](https://github.com/netdata/netdata/issues/8516))
- Apache: fix `bytespersec` chart context ([#8550](https://github.com/netdata/netdata/issues/8550))
- Dashboard v0.4.10 ([#8553](https://github.com/netdata/netdata/issues/8553))
- Switching over to soft feature flag ([#8545](https://github.com/netdata/netdata/issues/8545))
- Bail early on LWS build if cmake is not presen. ([#8559](https://github.com/netdata/netdata/issues/8559))
- Fix broken pipe ignoring in apps plugin ([#8554](https://github.com/netdata/netdata/issues/8554))
- Extend TLS Support ([#8505](https://github.com/netdata/netdata/issues/8505))
- Add missing override for Ubuntu eoan ([#8547](https://github.com/netdata/netdata/issues/8547))
- Update README.md ([#8552](https://github.com/netdata/netdata/issues/8552))
- Github/workflow: remove duplicate key (`line-length`) from the… ([#8551](https://github.com/netdata/netdata/issues/8551))
- Fix regressions in cloud functionality (build, CI, claiming) ([#8568](https://github.com/netdata/netdata/issues/8568))
- Fix broken Fedora 30/31 RPM builds ([#8572](https://github.com/netdata/netdata/issues/8572))
- Fix Debian 8 (jessie) support ([#8590](https://github.com/netdata/netdata/issues/8590))
- Ensure we only enable jessie-backports for Debian 8 (jessie) once ([#8593](https://github.com/netdata/netdata/issues/8593))
- Cove355076: Config per section ([#8588](https://github.com/netdata/netdata/issues/8588))
- Add netdata.service.* to .gitignore ([#8556](https://github.com/netdata/netdata/issues/8556))
- Fix compiler warnings in the claiming code ([#8567](https://github.com/netdata/netdata/issues/8567))
- Fix Coverity defects ([#8579](https://github.com/netdata/netdata/issues/8579))
- Fix Coverity Defect CID-349684 ([#8586](https://github.com/netdata/netdata/issues/8586))
- Fix ubuntu build with both libcap-dev and libcapng ([#8596](https://github.com/netdata/netdata/issues/8596))
- Correctly fixed RPM package builds on Fedora. ([#8595](https://github.com/netdata/netdata/issues/8595))
- Change all https://app.netdata.cloud URLs to https://netdata.cloud to restore connectivity with netdata cloud.
- Switch to dashboard v0.4.12 ([#8599](https://github.com/netdata/netdata/issues/8599))
- [netdata minor release] v1.21.0

## [1.20.0] - 2020-02-21

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package i386 RPM] Package build process trigger
- Add release 1.19.0 to news
- Tutorials to support v1.19 release ([#7359](https://github.com/netdata/netdata/issues/7359))
- Nvidia-smi: not loop mode ([#7372](https://github.com/netdata/netdata/issues/7372))
- Do not crash when logging UTF-8 data in Python 2 ([#7376](https://github.com/netdata/netdata/issues/7376))
- Smartd_log: change ATTR5 chart algorithm to absolute ([#7384](https://github.com/netdata/netdata/issues/7384))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- [Package i386 RPM][Build latest] Package build process trigger
- Update python.d README  ([#7357](https://github.com/netdata/netdata/issues/7357))
- Fix typo and markup in packaging/installer README ([#7368](https://github.com/netdata/netdata/issues/7368))
- Fixing errors ([#7340](https://github.com/netdata/netdata/issues/7340))
- Fixing linter errors in packaging/docker/README ([#7199](https://github.com/netdata/netdata/issues/7199))
- Proc.plugin: add pressure stall information ([#7209](https://github.com/netdata/netdata/issues/7209))
- Health: Proposed restructuring of health documentation ([#7329](https://github.com/netdata/netdata/issues/7329))
- Documentation on per-chart configuration options ([#7345](https://github.com/netdata/netdata/issues/7345))
- Fix broken docs builds ([#7409](https://github.com/netdata/netdata/issues/7409))
- Monit: overwrite __eq__, __ne__ in child classes (lgtm warnings) ([#7387](https://github.com/netdata/netdata/issues/7387))
- Installer: include go.d.plugin version v0.12.0 ([#7418](https://github.com/netdata/netdata/issues/7418))
- .travis.yml: Remove CentOS 6 package building and lifecycle tests ([#7425](https://github.com/netdata/netdata/issues/7425))
- Docs: Fixes to new health documentation structure ([#7419](https://github.com/netdata/netdata/issues/7419))
- Implement netdata command server and cli tool ([#7325](https://github.com/netdata/netdata/issues/7325))
- Address lgtm alerts ([#7441](https://github.com/netdata/netdata/issues/7441))
- Changed sed in testinternal ([#7431](https://github.com/netdata/netdata/issues/7431))
- Add generator dirs to gitignore ([#7421](https://github.com/netdata/netdata/issues/7421))
- Add HP Smart Storage Array python plugin ([#7181](https://github.com/netdata/netdata/issues/7181))
- Indicate we no longer build packages for CentOS 6 ([#7430](https://github.com/netdata/netdata/issues/7430))
- Fix dbengine dirty page flushing warning ([#7469](https://github.com/netdata/netdata/issues/7469))
- Rabbitmq: fix handle_disabled_disk_monitoring ([#7464](https://github.com/netdata/netdata/issues/7464))
- Fix missing parenthesis on softnet.conf ([#7476](https://github.com/netdata/netdata/issues/7476))
- Sensors: check fix ([#7447](https://github.com/netdata/netdata/issues/7447))
- Fix race condition with page cache descriptors ([#7478](https://github.com/netdata/netdata/issues/7478))
- Ci: remove ubuntu trusty 14.04 from build ([#7481](https://github.com/netdata/netdata/issues/7481))
- Fix to wrong instructions during a non-privileged install from installer ([#7393](https://github.com/netdata/netdata/issues/7393))
- .travis.yml: Add timestamps to output ([#7239](https://github.com/netdata/netdata/issues/7239))
- Implement the main flow for the Exporting Engine ([#7149](https://github.com/netdata/netdata/issues/7149))
- Minor docker related cleanups ([#7240](https://github.com/netdata/netdata/issues/7240))
- Updates and grammar fixes to README.md ([#7193](https://github.com/netdata/netdata/issues/7193))
- Inject archived backports repository on Debian Jessie for CI package builds. ([#7495](https://github.com/netdata/netdata/issues/7495))
- Update Netdata RPM spec file to package netdatacli. ([#7513](https://github.com/netdata/netdata/issues/7513))
- Force repository name in tag to be lowercase. ([#7506](https://github.com/netdata/netdata/issues/7506))
- Remove `-f` option from `groupdel` in uninstaller. ([#7507](https://github.com/netdata/netdata/issues/7507))
- Fix valgrind errors ([#7532](https://github.com/netdata/netdata/issues/7532))
- Update codeowners ([#7530](https://github.com/netdata/netdata/issues/7530))
- Updater_checks.sh: Fix issue with ca-certificates-mozilla-2.34-lp151.2.6.1.noarch in OpenSUSE 15.1
- Fix backend config ([#7538](https://github.com/netdata/netdata/issues/7538))
- Labels issues ([#7515](https://github.com/netdata/netdata/issues/7515))
- Fix race condition in dbengine ([#7533](https://github.com/netdata/netdata/issues/7533))
- Proc_pressure: increment fail_count on read fail ([#7547](https://github.com/netdata/netdata/issues/7547))
- Add Fedora 31 CI integrations. ([#7524](https://github.com/netdata/netdata/issues/7524))
- Merge the matrix and jobs keys in Travis config. ([#7544](https://github.com/netdata/netdata/issues/7544))
- Revert "Fix race condition in dbengine ([#7533](https://github.com/netdata/netdata/issues/7533))" ([#7560](https://github.com/netdata/netdata/issues/7560))
- Cleanup the main exporting engine thread on exit ([#7558](https://github.com/netdata/netdata/issues/7558))
- Make the docker image to run as arbitrary user ([#6543](https://github.com/netdata/netdata/issues/6543))
- Silencers_info: Change error to info ([#7479](https://github.com/netdata/netdata/issues/7479))
- Fix race condition in dbengine ([#7565](https://github.com/netdata/netdata/issues/7565))
- Docs: Add notice about mod_evasive to Apache proxy guide ([#7578](https://github.com/netdata/netdata/issues/7578))
- CODEOWNERS: Replace @netdata/automation with individual team members ([#7581](https://github.com/netdata/netdata/issues/7581))
- Agent claiming ([#7525](https://github.com/netdata/netdata/issues/7525))
- Skip unit testing during CI when it's not needed. ([#7559](https://github.com/netdata/netdata/issues/7559))
- Add anon tracking notice for installers ([#7437](https://github.com/netdata/netdata/issues/7437))
- Fix not detecting more than one adapter in hpssa collector ([#7580](https://github.com/netdata/netdata/issues/7580))
- Installer: include go.d.plugin version v0.13.0 ([#7574](https://github.com/netdata/netdata/issues/7574))
- Packaging: Set default release channel to stable for gh releases ([#7399](https://github.com/netdata/netdata/issues/7399))
- Set standard name to non-libnetdata threads (libuv, pthread) ([#7584](https://github.com/netdata/netdata/issues/7584))
- Add netdata-claim.sh to the RPM spec file. ([#7592](https://github.com/netdata/netdata/issues/7592))
- The step-by-step Netdata tutorial ([#7489](https://github.com/netdata/netdata/issues/7489))
- Docs: add configuration details for vhost about DOSPageCount to Apache proxy guide ([#7582](https://github.com/netdata/netdata/issues/7582))
- Python.d.plugin: UrlService bytes decode, logger unicode encodi… ([#7601](https://github.com/netdata/netdata/issues/7601))
- Fix a warning in prometheus remote write backend ([#7609](https://github.com/netdata/netdata/issues/7609))
- Python.d logger: do not unicode decode if it is already unicode ([#7614](https://github.com/netdata/netdata/issues/7614))
- Alamrs -> alarms ([#7637](https://github.com/netdata/netdata/issues/7637))
- Redis: populate `keys_redis` chart in runtime ([#7639](https://github.com/netdata/netdata/issues/7639))
- Python.d logger: unicode_str handle TypeError ([#7645](https://github.com/netdata/netdata/issues/7645))
- Fix typos ([#7375](https://github.com/netdata/netdata/issues/7375))
- [libnetdata/threads] Change log level on error ([#7653](https://github.com/netdata/netdata/issues/7653))
- [github/templates] Add samples cmds to get OS env ([#7550](https://github.com/netdata/netdata/issues/7550))
- Bump handlebars from 4.2.0 to 4.5.3 ([#7654](https://github.com/netdata/netdata/issues/7654))
- Limit 'support activities on main branch' to main repo. ([#7543](https://github.com/netdata/netdata/issues/7543))
- Add Ubuntu 19.10 to packaging and lifecycle checks. ([#7629](https://github.com/netdata/netdata/issues/7629))
- [Fix] remove pthread_setname_np segfault on musl ([#7664](https://github.com/netdata/netdata/issues/7664))
- Adjust alarm labels ([#7600](https://github.com/netdata/netdata/issues/7600))
- Netdata/installer: Make netdata installer more flexible, to accommodate install with ssl on MacOS ([#6922](https://github.com/netdata/netdata/issues/6922))
- Remove EOL distros from CI jobs. ([#7628](https://github.com/netdata/netdata/issues/7628))
- Samba: properly check if it is allowed to run smbstatus with su… ([#7655](https://github.com/netdata/netdata/issues/7655))
- Redirect when url =~ \/host\/hostname$ ([#7539](https://github.com/netdata/netdata/issues/7539)) ([#7643](https://github.com/netdata/netdata/issues/7643))
- Installer: include go.d.plugin version v0.14.0 ([#7666](https://github.com/netdata/netdata/issues/7666))
- Update the distribution support matrix to represent reality. ([#7636](https://github.com/netdata/netdata/issues/7636))
- Feat(docker): Add freeipmi support ([#7081](https://github.com/netdata/netdata/issues/7081))
- Clean up host labels in API responses ([#7616](https://github.com/netdata/netdata/issues/7616))
- Fix spelling of Prometheus ([#7673](https://github.com/netdata/netdata/issues/7673)) ([#7674](https://github.com/netdata/netdata/issues/7674))
- Fix buildyaml.sh script so that docs generation works correctly. ([#7662](https://github.com/netdata/netdata/issues/7662))
- Update handling of shutdown of the Netdata agent on update and uninstall. ([#7595](https://github.com/netdata/netdata/issues/7595))
- Restore support for protobuf 3.0 ([#7683](https://github.com/netdata/netdata/issues/7683))
- Docs: Improve documentation of opting out of anonymous statistics ([#7597](https://github.com/netdata/netdata/issues/7597))
- Network interface speed, duplex, operstate #5989 ([#7395](https://github.com/netdata/netdata/issues/7395))
- Add missing quoting in shell scripts. ([#7685](https://github.com/netdata/netdata/issues/7685))
- Fix a syntax error in the packaging functions. ([#7686](https://github.com/netdata/netdata/issues/7686))
- Switch PR labeling to use GitHub Actions. ([#7630](https://github.com/netdata/netdata/issues/7630))
- Switch to using the netdatabot access token for actions. ([#7697](https://github.com/netdata/netdata/issues/7697))
- Send host labels via exporting connectors ([#7554](https://github.com/netdata/netdata/issues/7554))
- Update PR labeling to not depend on fork owner access. ([#7699](https://github.com/netdata/netdata/issues/7699))
- General fixes to the installer. ([#7698](https://github.com/netdata/netdata/issues/7698))
- Fix unclosed brackets in softnet alarm ([#7693](https://github.com/netdata/netdata/issues/7693))
- Error exit when rrdhost localhost init fails #7504 ([#7663](https://github.com/netdata/netdata/issues/7663))
- Fix remote write value with average data source ([#7694](https://github.com/netdata/netdata/issues/7694))
- Add support for different .rtreport format ([#7705](https://github.com/netdata/netdata/issues/7705))
- Fixes for pfSense Installation ([#7665](https://github.com/netdata/netdata/issues/7665))
- Control introduction of new languages in docs translation ([#7722](https://github.com/netdata/netdata/issues/7722))
- Docs: Linter fixes for main README ([#7526](https://github.com/netdata/netdata/issues/7526))
- Tweaks and linter fixes ([#7407](https://github.com/netdata/netdata/issues/7407))
- Stream with labels ([#7549](https://github.com/netdata/netdata/issues/7549))
- .travis.yml: Reduce notifications ([#7714](https://github.com/netdata/netdata/issues/7714))
- Make auto-updates work on kickstart-static64 installs. ([#7704](https://github.com/netdata/netdata/issues/7704))
- Reduce broken pipe errors ([#7588](https://github.com/netdata/netdata/issues/7588))
- Installer: include go.d.plugin version v0.14.1 ([#7732](https://github.com/netdata/netdata/issues/7732))
- Fix a check for nfnetlink_conntrack.h ([#7727](https://github.com/netdata/netdata/issues/7727))
- Update stop-notifications-alarms.md ([#7737](https://github.com/netdata/netdata/issues/7737))
- Multiple files: fix typos ([#7752](https://github.com/netdata/netdata/issues/7752))
- Adds a Dockerfile.docs for more easily and reproducibly building/rebuilding docs ([#7688](https://github.com/netdata/netdata/issues/7688))
- Move the script for installing required packages into the main repo. ([#7563](https://github.com/netdata/netdata/issues/7563))
- Restrict quotes in label values ([#7594](https://github.com/netdata/netdata/issues/7594))
- Filter out lxc cgroups which are not useful ([#7760](https://github.com/netdata/netdata/issues/7760))
- On cloud error, inform user to update their netdata. ([#7750](https://github.com/netdata/netdata/issues/7750))
- Limit PR labeler runs to the main repo. ([#7768](https://github.com/netdata/netdata/issues/7768))
- Fixes support for read-only /lib on SystemD systems like CoreOS in  kickstart static64 ([#7726](https://github.com/netdata/netdata/issues/7726))
- Fix the formatting of the trailer line in the Debian changelog template. ([#7763](https://github.com/netdata/netdata/issues/7763))
- Alarm Log labels ([#7548](https://github.com/netdata/netdata/issues/7548))
- Add a missing parameter to the allmetrics endpoint in Swagger Editor ([#7776](https://github.com/netdata/netdata/issues/7776))
- Fix libuv IPC pipe cleanup problem ([#7778](https://github.com/netdata/netdata/issues/7778))
- Fix a Coverity issue ([#7780](https://github.com/netdata/netdata/issues/7780))
- Fix CSV -> SSV in docs ([#7782](https://github.com/netdata/netdata/issues/7782))
- Improve styling of documentation site and use Algolia search ([#7753](https://github.com/netdata/netdata/issues/7753))
- Do not alert the #automation channel on checksum failures that will fail a PR in CI anyway ([#7733](https://github.com/netdata/netdata/issues/7733))
- Cleanup packaging/makeself/build-x86_64-static.sh to use /bin/sh and remove use of sudo ([#7725](https://github.com/netdata/netdata/issues/7725))
- Remove unnessecary `echo` call in updater. ([#7783](https://github.com/netdata/netdata/issues/7783))
- Add swagger docu for `fixed_width_lbl` and `fixed_width_val` ([#7764](https://github.com/netdata/netdata/issues/7764))
- Fixed install on FreeBSD systems with non GNU sed (do't use -i) ([#7796](https://github.com/netdata/netdata/issues/7796))
- Added reviewdog/shellcheck to CI via Github Actions on changed shell scripts in PRs ([#7795](https://github.com/netdata/netdata/issues/7795))
- Issue 7488 docker labels ([#7770](https://github.com/netdata/netdata/issues/7770))
- Node.d/snmp: snmpv3 support ([#7802](https://github.com/netdata/netdata/issues/7802))
- Netdata/packaging: following the pattern from CUPS, separate freeIPMI ([#6939](https://github.com/netdata/netdata/issues/6939))
- Netdata/packaging: split free IPMI for RPM ([#6935](https://github.com/netdata/netdata/issues/6935))
- Bug_report improvements ([#7805](https://github.com/netdata/netdata/issues/7805))
- Add Korean translation ([#7723](https://github.com/netdata/netdata/issues/7723))
- Node.d/snmp.node.js: format code ([#7816](https://github.com/netdata/netdata/issues/7816))
- Fix unit tests for the exporting engine ([#7784](https://github.com/netdata/netdata/issues/7784))
- Add an environment variable check to allow disabling nightlies. ([#7765](https://github.com/netdata/netdata/issues/7765))
- Update collect-apache-nginx-web-logs.md to deprecated ([#7835](https://github.com/netdata/netdata/issues/7835))
- Don't remove groups/users in Debian postrm ([#7817](https://github.com/netdata/netdata/issues/7817))
- Fixed typo in README ([#7843](https://github.com/netdata/netdata/issues/7843))
- Collectors/python.d: format modules code ([#7832](https://github.com/netdata/netdata/issues/7832))
- Fix install permissions ([#7632](https://github.com/netdata/netdata/issues/7632))
- Attempt to use system service manager to shut down Netdata. ([#7814](https://github.com/netdata/netdata/issues/7814))
- Improve the system-info.sh script to report CPU and RAM meta-data. ([#7815](https://github.com/netdata/netdata/issues/7815))
- Python.d/retroshare: add readme ([#7849](https://github.com/netdata/netdata/issues/7849))
- Added ReviewDOg CI checks for JavaScript ([#7828](https://github.com/netdata/netdata/issues/7828))
- Remove all refernces to .keep files ([#7829](https://github.com/netdata/netdata/issues/7829))
- Update stream documentation bringing explanation of some errors ([#6995](https://github.com/netdata/netdata/issues/6995))
- Adds Docker based build system for Binary Packages, CI/CD, Smoke Testing and Development. ([#7735](https://github.com/netdata/netdata/issues/7735))
- Added ReviewDOg CI checks for Golang ([#7827](https://github.com/netdata/netdata/issues/7827))
- Fixes and improves the installer/updater shell scripts. ([#7847](https://github.com/netdata/netdata/issues/7847))
- Docs: Overhaul of installation documentation ([#7841](https://github.com/netdata/netdata/issues/7841))
- Small updates to dash.html ([#7757](https://github.com/netdata/netdata/issues/7757))
- Missing extern ([#7877](https://github.com/netdata/netdata/issues/7877))
- Collectors/python.d/phpfpm: fix readme and per process chart ti… ([#7876](https://github.com/netdata/netdata/issues/7876))
- /collectors/python.d: remove unbound module ([#7853](https://github.com/netdata/netdata/issues/7853))
- .travis.yml: Add -fno-common to CFLAGS ([#7870](https://github.com/netdata/netdata/issues/7870))
- Fixed Source0 URL in RPM spec ([#7794](https://github.com/netdata/netdata/issues/7794))
- Add release channel customization to docker build ([#7373](https://github.com/netdata/netdata/issues/7373))
- Add disk size detection to system-info.sh. ([#7866](https://github.com/netdata/netdata/issues/7866))
- Better systemd service file ([#7790](https://github.com/netdata/netdata/issues/7790))
- Adds support for opting out of telemetry via the DO_NOT_TRACK envirnment variable ([#7846](https://github.com/netdata/netdata/issues/7846))
- Add docs about using caching proxies with our package repos. ([#7909](https://github.com/netdata/netdata/issues/7909))
- Clarify editing health config files in health quickstart ([#7883](https://github.com/netdata/netdata/issues/7883))
- Add possibility to change badge text font color ([#7809](https://github.com/netdata/netdata/issues/7809))
- Set ownership correctly for plugins in netdata-installer.sh ([#7923](https://github.com/netdata/netdata/issues/7923))
- Add doc with post-install instructions for GCP ([#7912](https://github.com/netdata/netdata/issues/7912))
- Fix typo in PULL_REQUEST_TEMPLATE ([#7924](https://github.com/netdata/netdata/issues/7924))
- Installer: include go.d.plugin version v0.15.0 ([#7882](https://github.com/netdata/netdata/issues/7882))
- Fixes a bug in DO_NOT_TRACK expression ([#7929](https://github.com/netdata/netdata/issues/7929))
- /collectors/python.d/varnish: collect smf metrics ([#7926](https://github.com/netdata/netdata/issues/7926))
- Parse host tags ([#7702](https://github.com/netdata/netdata/issues/7702))
- Fix wrong code fragments in signing in ([#7950](https://github.com/netdata/netdata/issues/7950))
- Fix setuid for freeipmi.plugin in Docker images ([#7684](https://github.com/netdata/netdata/issues/7684))
- Netdata-updater.sh: explicitly return 0 from update ([#7955](https://github.com/netdata/netdata/issues/7955))
- Assorted cleanup items in the RPM spec file. ([#7927](https://github.com/netdata/netdata/issues/7927))
- /pythond.d/UrlService.py: add body ([#7956](https://github.com/netdata/netdata/issues/7956))
- Update httpcheck.conf ([#7952](https://github.com/netdata/netdata/issues/7952))
- Cleanup of macOS installation docs ([#7925](https://github.com/netdata/netdata/issues/7925))
- Fix cmake build error ([#7960](https://github.com/netdata/netdata/issues/7960))
- Fixed a typo in ./packaging/installer/functions.sh with wrong message for updater cron script ([#7934](https://github.com/netdata/netdata/issues/7934))
- Added new simpler (Alpine based) Dockerfile for quick dev and testing ([#7914](https://github.com/netdata/netdata/issues/7914))
- Reformats ./packaging/installer/install-required-packages.sh with: shfmt -w -i 2 -ci -sr ([#7915](https://github.com/netdata/netdata/issues/7915))
- Indicate FreeIPMI supported in Docker image ([#7964](https://github.com/netdata/netdata/issues/7964))
- Adds a GHA workflow to test install-required-packages ([#7949](https://github.com/netdata/netdata/issues/7949))
- Install go.d.plugin only if there is new version ([#7946](https://github.com/netdata/netdata/issues/7946))
- Fixes static builds and nightlies ([#7971](https://github.com/netdata/netdata/issues/7971))
- Adds docs for how to build/install NetData on CentOS 8.x ([#7890](https://github.com/netdata/netdata/issues/7890))
- Adds GHA Workflow to actually Build the Agent across all the OS/Distro(s) we support today ([#7969](https://github.com/netdata/netdata/issues/7969))
- Re-formatted ./packaging/installer/netdata-updater.sh with shfmt -w -i 2 -ci -sr ([#7937](https://github.com/netdata/netdata/issues/7937))
- Fixes error/warnings found by shellcheck for ./packaging/installer/netdata-updater.sh ([#7938](https://github.com/netdata/netdata/issues/7938))
- Re-formated ./system/edit-config.in with shfmt -w -i 2 -ci -sr ([#7932](https://github.com/netdata/netdata/issues/7932))
- Fixes support for editing configuration when NetData is installed to a symlinked /opt ([#7933](https://github.com/netdata/netdata/issues/7933))
- Adds support for only performing updates if there is a newer version ([#7939](https://github.com/netdata/netdata/issues/7939))
- Collectors: apps.plugin: apps_groups: update ceph & samba colle… ([#7982](https://github.com/netdata/netdata/issues/7982))
- CODEOWNERS: change collectors/charts.d.plugin/ owners ([#7963](https://github.com/netdata/netdata/issues/7963))
- Fix permissions issues caused by 986bc2052. ([#7984](https://github.com/netdata/netdata/issues/7984))
- Fix typos ([#7978](https://github.com/netdata/netdata/issues/7978))
- Stream with version ([#7851](https://github.com/netdata/netdata/issues/7851))
- Support prom remote write ([#7691](https://github.com/netdata/netdata/issues/7691))
- /collectors/python.d.plugin/third_party: patch monotonic synolo… ([#7980](https://github.com/netdata/netdata/issues/7980))
- ACLK agent 1 ([#7894](https://github.com/netdata/netdata/issues/7894))
- Drop dirty dbengine pages if disk cannot keep up ([#7777](https://github.com/netdata/netdata/issues/7777))
- Fix CentOS 7 RPM build failures. ([#7993](https://github.com/netdata/netdata/issues/7993))
- /collectors/charts.d.plugin: format modules ([#7973](https://github.com/netdata/netdata/issues/7973))
- Change sed to include parentheses ([#7995](https://github.com/netdata/netdata/issues/7995))
- Don't push a commit for i386 RPM builds. ([#7989](https://github.com/netdata/netdata/issues/7989))
- Update database servers group in apps_groups.conf ([#8004](https://github.com/netdata/netdata/issues/8004))
- Alarms_values: New endpoint ([#7836](https://github.com/netdata/netdata/issues/7836))
- Update `api/v1/info ` ([#7862](https://github.com/netdata/netdata/issues/7862))
- Health_doc_name: Clarify the rules to create an alarm name ([#7911](https://github.com/netdata/netdata/issues/7911))
- Fix variety of linter errors across docs ([#7944](https://github.com/netdata/netdata/issues/7944))
- /docs/generator: add an option to use last dir name for page name  ([#7997](https://github.com/netdata/netdata/issues/7997))
- /docs/generator: build docs only for go.d itself and its modules ([#8005](https://github.com/netdata/netdata/issues/8005))
- /docs/generator: use h1 heading as page title for collectors pages ([#8009](https://github.com/netdata/netdata/issues/8009))
- Invalid literal for float(): NN.NNt ([#8013](https://github.com/netdata/netdata/issues/8013))
- /collectors/charts.d.plugin: fix `os_id` detection in `run` ([#8002](https://github.com/netdata/netdata/issues/8002))
- Fix missing variables on stream ([#8011](https://github.com/netdata/netdata/issues/8011))
- Update wrong default stated in docu ([#8017](https://github.com/netdata/netdata/issues/8017))
- Docs: Promote DB engine/long-term metrics storage more heavily ([#8031](https://github.com/netdata/netdata/issues/8031))
- Github/workflow: change labeler ([#8032](https://github.com/netdata/netdata/issues/8032))
- Fix_exclusive_notification: ([#7769](https://github.com/netdata/netdata/issues/7769))
- Check if ACLK can be built ([#8030](https://github.com/netdata/netdata/issues/8030))
- Add support for libmosquitto to netdata-installer.sh for ACLK support. ([#8025](https://github.com/netdata/netdata/issues/8025))
- Fixes conditional for NetData Updater when checking for new updates ([#8028](https://github.com/netdata/netdata/issues/8028))
- Collectors: apps.plugin: apps_groups: create 'dns' group. ([#8058](https://github.com/netdata/netdata/issues/8058))
- /collectors/charts.d.plugin: remove deprecated modules ([#7962](https://github.com/netdata/netdata/issues/7962))
- Added collector config to relevant READMEs ([#8052](https://github.com/netdata/netdata/issues/8052))
- Make temporary directories relative to $TEMPDIR. ([#8066](https://github.com/netdata/netdata/issues/8066))
- Adding testing section to the PR template. ([#8068](https://github.com/netdata/netdata/issues/8068))
- Refactor collectors documentation ([#7996](https://github.com/netdata/netdata/issues/7996))
- Update to new release of libmosquitto fork. ([#8067](https://github.com/netdata/netdata/issues/8067))
- Added hack to sha256sums.txt to force users of NetData on v1.19.0-483 with a broken updater to update to latest ([#8057](https://github.com/netdata/netdata/issues/8057))
- Revert "Added hack to sha256sums.txt to force users of NetData on v1.19.0-483 with a broken updater to update to latest ([#8057](https://github.com/netdata/netdata/issues/8057))" ([#8076](https://github.com/netdata/netdata/issues/8076))
- Github/actions: update labeler config and bump version ([#8071](https://github.com/netdata/netdata/issues/8071))
- Fixed text if current version is >= latest version and already installed ([#8078](https://github.com/netdata/netdata/issues/8078))
- Add required build dep for ACLK dependencies to Dockerfile. ([#8047](https://github.com/netdata/netdata/issues/8047))
- Updates for issue 8006 ([#8074](https://github.com/netdata/netdata/issues/8074))
- Fix Node and Bash collector titles ([#8086](https://github.com/netdata/netdata/issues/8086))
- Initial MQTT over Secure Websockets support for ACLK ([#7988](https://github.com/netdata/netdata/issues/7988))
- Add handling of libmosquitto to binary packages. ([#8085](https://github.com/netdata/netdata/issues/8085))
- Add Patti to docs and .md codeowners ([#8092](https://github.com/netdata/netdata/issues/8092))
- Fix nightly RPM builds. ([#8109](https://github.com/netdata/netdata/issues/8109))
- EBPF process plugin ([#7979](https://github.com/netdata/netdata/issues/7979))
- Integrates the eBPF Kernel Collector with the NetData Installer ([#8075](https://github.com/netdata/netdata/issues/8075))
- Fixes NetData installer on *BSD systems post libmosquitto / eBPF ([#8121](https://github.com/netdata/netdata/issues/8121))
- Update eBPF docs with better install/enable instructions ([#8125](https://github.com/netdata/netdata/issues/8125))
- Fix netdata-installer ([#8133](https://github.com/netdata/netdata/issues/8133))
- Ebpf coverity ([#8135](https://github.com/netdata/netdata/issues/8135))
- [netdata minor release] v1.20.0

## [1.19.0] - 2019-11-27

### Merged Pull Requests:

- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package i386 RPM] Package build process trigger
- Update news with v1.18.1
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- [Package i386 RPM][Build latest] Package build process trigger
- [collector/proc.plugin] Add /proc/pagetypeinfo parser ([#6843](https://github.com/netdata/netdata/issues/6843))
- Netdata not returning correct value for unknow variables ([#6984](https://github.com/netdata/netdata/issues/6984))
- Mysql: add cluster_status alarm ([#6989](https://github.com/netdata/netdata/issues/6989))
- Telegram: fix broken links, add setup instructions ([#7033](https://github.com/netdata/netdata/issues/7033))
- Initial documentation for the CMake build-system. ([#7114](https://github.com/netdata/netdata/issues/7114))
- Xenstat.plugin: check xenstat_vbd_error presence ([#7103](https://github.com/netdata/netdata/issues/7103))
- Add support for am2320 sensor ([#7024](https://github.com/netdata/netdata/issues/7024))
- Add user information to MySQL Python module documentation ([#7128](https://github.com/netdata/netdata/issues/7128))
- Detect if the disk cannot keep up with data collection ([#7139](https://github.com/netdata/netdata/issues/7139))
- Fixing DNS-lookup performance issue on FreeBSD. ([#7132](https://github.com/netdata/netdata/issues/7132))
- Contrib/debian: Fix typo in Description ([#7154](https://github.com/netdata/netdata/issues/7154))
- Coverity_350131: Fix sizeof on callocz ([#7187](https://github.com/netdata/netdata/issues/7187))
- Kickstart-static64.sh passes --auto-update to netdata-latest.gz.run ([#7076](https://github.com/netdata/netdata/issues/7076))
- Suggest using /var/run/netdata for the unix socket ([#7206](https://github.com/netdata/netdata/issues/7206))
- Kickstart: pass options to installer ([#7051](https://github.com/netdata/netdata/issues/7051))
- Include limits.h before using LONG_MAX ([#7224](https://github.com/netdata/netdata/issues/7224))
- .travis.yml: Increase timeout for docker image builds to 20 minutes ([#7214](https://github.com/netdata/netdata/issues/7214))
- Cgroup-network-helper doesn't work on Proxmox 6 ([#7037](https://github.com/netdata/netdata/issues/7037))
- Update alarm-notify.sh to enable IRC notifications ([#7148](https://github.com/netdata/netdata/issues/7148))
- Fix counter reset detection ([#7220](https://github.com/netdata/netdata/issues/7220))
- Postgres: do not return cached data ([#7228](https://github.com/netdata/netdata/issues/7228))
- Disable pagetypeinfo by default ([#7230](https://github.com/netdata/netdata/issues/7230))
- UrlService: allow to skip tls_verify for http scheme ([#7223](https://github.com/netdata/netdata/issues/7223))
- Rabbitmq: handle "disk_free": "disk_free_monitoring_disabled" ([#7226](https://github.com/netdata/netdata/issues/7226))
- .travis.yml: Prevent nightly jobs from timing out (again) ([#7238](https://github.com/netdata/netdata/issues/7238))
- Clarify database engine/RAM in getting started guide ([#7225](https://github.com/netdata/netdata/issues/7225))
- Building a fuzzer against the API ([#7163](https://github.com/netdata/netdata/issues/7163)) ([#7210](https://github.com/netdata/netdata/issues/7210))
- Typo ([#7242](https://github.com/netdata/netdata/issues/7242))
- Netdata/docs: fix nit introduced in 545aa9745 ([#7246](https://github.com/netdata/netdata/issues/7246))
- Update SYN cookie alarm to be less aggressive. ([#7250](https://github.com/netdata/netdata/issues/7250))
- Upgraded the swagger definition to OpenAPI3.0
- Netdata-installer.sh follow-up based on #7060 review ([#7200](https://github.com/netdata/netdata/issues/7200))
- Second part of fix for #7040 ([#7083](https://github.com/netdata/netdata/issues/7083))
- Netdata/installer: add missing flags from installer inventory, so that users can define them during execution ([#7027](https://github.com/netdata/netdata/issues/7027))
- Remove documentation about kickstart-static64.sh and netdata updater ([#7262](https://github.com/netdata/netdata/issues/7262))
- Initial CMocka testing against web_client.c ([#7229](https://github.com/netdata/netdata/issues/7229)). ([#7264](https://github.com/netdata/netdata/issues/7264))
- Fix_irc_notification: Remove line break from message ([#7243](https://github.com/netdata/netdata/issues/7243))
- Container-engines: add balena* to apps_group.conf ([#7287](https://github.com/netdata/netdata/issues/7287))
- Makefile.am files indentation ([#7252](https://github.com/netdata/netdata/issues/7252))
- Web_log: treat 401 Unauthorized requests as successful ([#7256](https://github.com/netdata/netdata/issues/7256))
- Ownership and permissions of /etc/netdata ([#7244](https://github.com/netdata/netdata/issues/7244))
- Apps.plugin: add process group for git-related processes ([#7289](https://github.com/netdata/netdata/issues/7289))
- TimescaleDB connection page ([#7180](https://github.com/netdata/netdata/issues/7180))
- Stream_ssl_slave: Fix socket overwrite ([#7306](https://github.com/netdata/netdata/issues/7306))
- Updating the Travis pipeline (issue 7189) ([#7312](https://github.com/netdata/netdata/issues/7312))
- Fine tune various alarm values. ([#7322](https://github.com/netdata/netdata/issues/7322))
- Installer: add missing trailing backslash ([#7326](https://github.com/netdata/netdata/issues/7326))
- - Retrieve current affinity of the process and make sure not to ([#7318](https://github.com/netdata/netdata/issues/7318))
- Update README.md ([#7330](https://github.com/netdata/netdata/issues/7330))
- Update plugins.d/README.md ([#7335](https://github.com/netdata/netdata/issues/7335))
- Fixed Caddy line ([#7088](https://github.com/netdata/netdata/issues/7088))
- Added GA links to new documents ([#7194](https://github.com/netdata/netdata/issues/7194))
- Update netdata-security.md ([#7343](https://github.com/netdata/netdata/issues/7343))
- Collectors: apps.plugin: apps_groups: added new frr daemons. ([#7333](https://github.com/netdata/netdata/issues/7333))
- CMocka tests for Issue 7274 ([#7308](https://github.com/netdata/netdata/issues/7308))
- Fixed package dependencies on Debian Jessie ([#7342](https://github.com/netdata/netdata/issues/7342))
- Correct versions of FreeNAS that Netdata is available on ([#7355](https://github.com/netdata/netdata/issues/7355))
- Minor grammar change in /web/gui documentation ([#7363](https://github.com/netdata/netdata/issues/7363))
- Installer: include go.d.plugin version v0.11.0 ([#7365](https://github.com/netdata/netdata/issues/7365))
- [netdata minor release] 1.19

## [1.18.1] - 2019-10-18

### Merged Pull Requests:

- Tutorials to support v1.18 features ([#6993](https://github.com/netdata/netdata/issues/6993))
- Add release 1.18.0 to news ([#7054](https://github.com/netdata/netdata/issues/7054))
- Fix BSD/pfSense documentation ([#7041](https://github.com/netdata/netdata/issues/7041))
- Disable slabinfo plugin by default ([#7056](https://github.com/netdata/netdata/issues/7056))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package i386 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- [Package i386 RPM][Build latest] Package build process trigger
- Fix dbengine not working when mmap fails ([#7065](https://github.com/netdata/netdata/issues/7065))
- Fix typo in health_alarm_notify.conf ([#7062](https://github.com/netdata/netdata/issues/7062))
- Fix size of a zeroed block ([#7061](https://github.com/netdata/netdata/issues/7061))
- Add dbengine RAM usage statistics ([#7038](https://github.com/netdata/netdata/issues/7038))
- Template_foreach_fix: Fix underscore dash ([#7069](https://github.com/netdata/netdata/issues/7069))
- SimpleService: change chart suppress msg level to info ([#7085](https://github.com/netdata/netdata/issues/7085))
- Fix(freeipmi): Update frequency config check ([#7078](https://github.com/netdata/netdata/issues/7078))
- Add CMocka unit tests ([#6985](https://github.com/netdata/netdata/issues/6985))
- Clang warnings ([#7090](https://github.com/netdata/netdata/issues/7090))
- Run the trigger for deb and rpm package build in separate stage ([#7105](https://github.com/netdata/netdata/issues/7105))
- Megacli: search binary and sudo check fix ([#7108](https://github.com/netdata/netdata/issues/7108))
- Add VMware VMXNET3 driver to the default interafaces list ([#7109](https://github.com/netdata/netdata/issues/7109))
- Fix segmentation fault in FreeBSD ([#7102](https://github.com/netdata/netdata/issues/7102))
- Don't write an HTTP response 204 to logs ([#7035](https://github.com/netdata/netdata/issues/7035))
- Documenting the structure of the data responses. ([#7012](https://github.com/netdata/netdata/issues/7012))
- Unbound: fix init ([#7112](https://github.com/netdata/netdata/issues/7112))
- Fix CPU charts in apps plugin on FreeBSD ([#7115](https://github.com/netdata/netdata/issues/7115))
- Partial fix for #7039 ([#7060](https://github.com/netdata/netdata/issues/7060))
- Feat(reaper): Add process reaper support ([#7059](https://github.com/netdata/netdata/issues/7059))
- Convert recursion timings to miliseconds. ([#7121](https://github.com/netdata/netdata/issues/7121))
- Fixing broken links ([#7123](https://github.com/netdata/netdata/issues/7123))
- Implement hangouts chat notifications ([#7013](https://github.com/netdata/netdata/issues/7013))
- Fix build when CMocka isn't installed ([#7129](https://github.com/netdata/netdata/issues/7129))
- Fix upgrade path from v1.17.1 to v1.18.x for deb packages ([#7118](https://github.com/netdata/netdata/issues/7118))
- 7040 enable stable channel option ([#7082](https://github.com/netdata/netdata/issues/7082))
- [netdata patch release] v1.18.1

## [1.18.0] - 2019-10-10

### Merged Pull Requests:

- Netdata/packaging: no need to overengineer with these checks. The stage is triggered only on specific keyword, that should be enough ([#6834](https://github.com/netdata/netdata/issues/6834))
- [Package amd64 DEB] Build stable
- [Package amd64 RPM] Build stable
- Add news of 1.17.1 to README ([#6836](https://github.com/netdata/netdata/issues/6836))
- Netdata/packaging: we didnt fix changelog handling, fixes and nits now ([#6837](https://github.com/netdata/netdata/issues/6837))
- Netdata/packaging: Ensure that we do not mess with CI tooling, when building stable ([#6838](https://github.com/netdata/netdata/issues/6838))
- Update CHANGELOG.md
- Netdata/packaging: nit - missed trailing slash ([#6840](https://github.com/netdata/netdata/issues/6840))
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- Buffer overflow ([#6817](https://github.com/netdata/netdata/issues/6817))
- Netdata/packaging: nits and fixes for packaging ([#6842](https://github.com/netdata/netdata/issues/6842))
- [Package i386 DEB][Build latest] Package build process trigger
- [Package i386 RPM][Build latest] Package build process trigger
- Netdata/packaging: Bring on board two scripts that build libuv and judy from source ([#6850](https://github.com/netdata/netdata/issues/6850))
- Netdata/packaging: Introduce separate CUPS package for debian distributions ([#6724](https://github.com/netdata/netdata/issues/6724))
- Netdata/packaging: Split CUPS plugin to separate package (RPM) ([#6700](https://github.com/netdata/netdata/issues/6700))
- Single job build fix ([#6856](https://github.com/netdata/netdata/issues/6856))
- Resolve broken links ([#6854](https://github.com/netdata/netdata/issues/6854))
- Squash integration ([#5566](https://github.com/netdata/netdata/issues/5566))
- Update grep to be more specific ([#6794](https://github.com/netdata/netdata/issues/6794))
- Center the chart on timeframe when an alarm is raised ([#6391](https://github.com/netdata/netdata/issues/6391))
- Fixes netdata group deletion on linux for uninstall script ([#6645](https://github.com/netdata/netdata/issues/6645))
- Changed naming for redirect_uri param ([#6663](https://github.com/netdata/netdata/issues/6663))
- Add example for prometheus archiving source parameter
- Dont redirect when redirectURI is the same ([#6868](https://github.com/netdata/netdata/issues/6868))
- Gearman plugin for Netdata ([#6567](https://github.com/netdata/netdata/issues/6567))
- Cppcheck fixes ([#6386](https://github.com/netdata/netdata/issues/6386))
- Instructions for simple SMTP transport ([#6870](https://github.com/netdata/netdata/issues/6870))
- /var/lib/netdata/registry was being left behind after purge ([#6867](https://github.com/netdata/netdata/issues/6867))
- Changes to launching the python.d plugin aggregator. ([#6781](https://github.com/netdata/netdata/issues/6781))
- Installer: include go.d.plugin version v0.9.0 ([#6872](https://github.com/netdata/netdata/issues/6872))
- Vcsa collector: charts description and alarms ([#6772](https://github.com/netdata/netdata/issues/6772))
- Netdata/installer: Add support for offline installs using kickstart or kickstart-static64 ([#6693](https://github.com/netdata/netdata/issues/6693))
- Update python.d module checklist to match the current paths and… ([#6874](https://github.com/netdata/netdata/issues/6874))
- NPM Packages version update ([#6801](https://github.com/netdata/netdata/issues/6801))
- Update docs for offline install ([#6884](https://github.com/netdata/netdata/issues/6884))
- Get all k8s container names ([#6885](https://github.com/netdata/netdata/issues/6885))
- Collector slabinfo ([#6800](https://github.com/netdata/netdata/issues/6800))
- Change the log level for chart updates ([#6887](https://github.com/netdata/netdata/issues/6887))
- Markdown syntax fixes for MDX parser ([#6877](https://github.com/netdata/netdata/issues/6877))
- Allow hostnames in Access Control Lists ([#6796](https://github.com/netdata/netdata/issues/6796))
- Remove Dollar sign from Bash code in documentation and fix remark-lint warnings ([#6880](https://github.com/netdata/netdata/issues/6880))
- Netdata/packaging: fix kickstart-static64 argument parsing ([#6892](https://github.com/netdata/netdata/issues/6892))
- Permit x-auth-token in Access-Control-Allow-Headers ([#6894](https://github.com/netdata/netdata/issues/6894))
- [collector/slabinfo] Fix pagesize not defined in non-x86 arches ([#6897](https://github.com/netdata/netdata/issues/6897))
- Fix some errors reported by Coverity ([#6797](https://github.com/netdata/netdata/issues/6797))
- Improve changelog generation and add it back to the pipeline ([#6900](https://github.com/netdata/netdata/issues/6900))
- Fix LGTM warnings ([#6875](https://github.com/netdata/netdata/issues/6875))
- Add clang-format. Update Contribution guidelines. ([#6677](https://github.com/netdata/netdata/issues/6677))
- Netdata/packaging: remove rhel7 - i386, until its settled from bug #6849 ([#6902](https://github.com/netdata/netdata/issues/6902))
- Netdata/ci: fix branch check ([#6905](https://github.com/netdata/netdata/issues/6905))
- Correct read length of silencers file ([#6909](https://github.com/netdata/netdata/issues/6909))
- Improve documentation for the SNMP collector ([#6915](https://github.com/netdata/netdata/issues/6915))
- Suggest using /run or /var/run for the unix socket ([#6916](https://github.com/netdata/netdata/issues/6916))
- Netdata/ci: nits and fixes around package release workflow ([#6914](https://github.com/netdata/netdata/issues/6914))
- Fix remark lint for Contrib  ([#6921](https://github.com/netdata/netdata/issues/6921))
- Fix log warnings in start_job ([#6928](https://github.com/netdata/netdata/issues/6928))
- Installer: include go.d.plugin version v0.10.0 ([#6929](https://github.com/netdata/netdata/issues/6929))
- Netdata/packaging: fix broken links on web files, for deb ([#6930](https://github.com/netdata/netdata/issues/6930))
- Detect deadlock in dbengine page cache ([#6911](https://github.com/netdata/netdata/issues/6911))
- Netdata.spec.in: Do not build CUPS plugin subpackage on CentOS 6 and CentOS 7 ([#6926](https://github.com/netdata/netdata/issues/6926))
- Docs: Overhaul of Getting started guide ([#6811](https://github.com/netdata/netdata/issues/6811))
- Restore original alignment behaviour of RRDR ([#6938](https://github.com/netdata/netdata/issues/6938))
- Zookeeper and hdfs: alarms and dashboard_info ([#6927](https://github.com/netdata/netdata/issues/6927))
- Check for curl to not get wrong error message ([#6931](https://github.com/netdata/netdata/issues/6931))
- Fix a memory leak ([#6945](https://github.com/netdata/netdata/issues/6945))
- Create a template for all dimensions ([#6560](https://github.com/netdata/netdata/issues/6560))
- Add family to allmetrics_json resp ([#6966](https://github.com/netdata/netdata/issues/6966))
- Reduce overhead during write io ([#6964](https://github.com/netdata/netdata/issues/6964))
- Fix Remark Lint for READMEs in Database ([#6942](https://github.com/netdata/netdata/issues/6942))
- Netdata/packaging: Make spec file more consistent with version dependencies, plus some documentation nits ([#6948](https://github.com/netdata/netdata/issues/6948))
- Common pattern for web and alarms together with two bug fixes ([#6783](https://github.com/netdata/netdata/issues/6783))
- #3925 implementation ([#6903](https://github.com/netdata/netdata/issues/6903))
- Fix coverity erro (CID 349552) double lock ([#6970](https://github.com/netdata/netdata/issues/6970))
- Fix dbengine consistency when a writer modifies a page concurrently with a reader querying its metrics ([#6979](https://github.com/netdata/netdata/issues/6979))
- Coverity 20190924 ([#6941](https://github.com/netdata/netdata/issues/6941))
- Make dbengine the default memory mode ([#6977](https://github.com/netdata/netdata/issues/6977))
- Elasticsearch: collect metrics from _cat/indices ([#6965](https://github.com/netdata/netdata/issues/6965))
- Mysql: collect galera cluster metrics ([#6962](https://github.com/netdata/netdata/issues/6962))
- Fixing broken links found via linkchecker ([#6983](https://github.com/netdata/netdata/issues/6983))
- Rabbitmq: collect vhosts msg metrics from `/api/vhosts` ([#6976](https://github.com/netdata/netdata/issues/6976))
- Fix Remark Lint Warnings for Backends ([#6917](https://github.com/netdata/netdata/issues/6917))
- Fix remark warnings for Daemon README ([#6920](https://github.com/netdata/netdata/issues/6920))
- Update README.md ([#6961](https://github.com/netdata/netdata/issues/6961))
- Remove warning from Coverity ([#6992](https://github.com/netdata/netdata/issues/6992))
- Increase dbengine default cache size ([#6997](https://github.com/netdata/netdata/issues/6997))
- Netdata/installer: allow netdata service install, when docker runs systemd ([#6987](https://github.com/netdata/netdata/issues/6987))
- Add Portuguese (Brazil) as a language option ([#7004](https://github.com/netdata/netdata/issues/7004))
- Fix bug: issue #7002 ([#7003](https://github.com/netdata/netdata/issues/7003))
- Remove hard cap from page cache size to eliminate deadlocks. ([#7006](https://github.com/netdata/netdata/issues/7006))
- Fix resource leak ([#7007](https://github.com/netdata/netdata/issues/7007))
- Handle cases where metric timestamps are inversed and data collection interval rounds to 0 ([#7008](https://github.com/netdata/netdata/issues/7008))
- Fix crash on FreeBSD due to do_dev_cpu_temperature stack corrup… ([#7014](https://github.com/netdata/netdata/issues/7014))
- Checklinks fix ([#6994](https://github.com/netdata/netdata/issues/6994))
- Rabbitmq: survive lack of vhosts ([#7019](https://github.com/netdata/netdata/issues/7019))
- Netdata: Add knatsakis as codeowner, wherever paulkatsoulakis was ([#7036](https://github.com/netdata/netdata/issues/7036))
- [netdata minor release] 1.18.0
- Move call to set_tag_for_release [ci skip]
- [netdata minor release] 1.18.0 Try 2
- [Package amd64 DEB] Package build process trigger
- [Package i386 DEB] Package build process trigger
- [Package amd64 RPM] Package build process trigger
- [Package i386 RPM] Package build process trigger

## [1.17.1] - 2019-09-12

### Merged Pull Requests:

- Add release 1.17.0 to News
- Add separator to news
- [Package amd64 DEB][Build latest] Package build process trigger
- [Package amd64 RPM][Build latest] Package build process trigger
- HTTP response message ([#6595](https://github.com/netdata/netdata/issues/6595))
- Stop configure.ac from linking against dbengine and https libraries when dbengine or https are disabled ([#6658](https://github.com/netdata/netdata/issues/6658))
- [Package amd64 RPM] Build stable
- [Package amd64 DEB] Build stable
- Netdata/packaging: Trigger stable package generation upon release process ([#6766](https://github.com/netdata/netdata/issues/6766))
- Fix clear notification missing ([#6638](https://github.com/netdata/netdata/issues/6638))
- (Documentation) fix pfsense instructions and links ([#6768](https://github.com/netdata/netdata/issues/6768))
- Update cache hashes for js and css imports ([#6756](https://github.com/netdata/netdata/issues/6756))
- Dash.html ([#6603](https://github.com/netdata/netdata/issues/6603))
- [libnetdata/thread] Set thread name from tag ([#6745](https://github.com/netdata/netdata/issues/6745))
- Add high level explanation of dashboard contents ([#6648](https://github.com/netdata/netdata/issues/6648))
- Netdata/packaging: override control file for debian/buster, different library available for protoc runtime ([#6777](https://github.com/netdata/netdata/issues/6777))
- Netdata/packaging: fix changelog generation failing the build ([#6778](https://github.com/netdata/netdata/issues/6778))
- Netdata/packaging: work around redhat complaining on build-id binary ([#6792](https://github.com/netdata/netdata/issues/6792))
- Expand dashboard auto-scaling and convertible units ([#5920](https://github.com/netdata/netdata/issues/5920))
- Netdata/packaging: remove fedora/28, is no longer available as unsupported ([#6808](https://github.com/netdata/netdata/issues/6808))
- Netdata/ci: use the right packaging user for the commits to trigger packaging ([#6813](https://github.com/netdata/netdata/issues/6813))
- Pythond respect prev running jobs and refactor ([#6661](https://github.com/netdata/netdata/issues/6661))
- Netdata/ci: Force last good version of git-semver, they broke it ([#6820](https://github.com/netdata/netdata/issues/6820))
- Netdata/packaging: fix ubuntu/xenial runtime dependencies ([#6825](https://github.com/netdata/netdata/issues/6825))
- Netdata/ci: second batch of fixes for coverity scan script and others ([#6804](https://github.com/netdata/netdata/issues/6804))
- Stress test insertions into dbengine and bugfixes ([#6814](https://github.com/netdata/netdata/issues/6814))
- Sidebar-info update - DB engine ([#6744](https://github.com/netdata/netdata/issues/6744))
- [netdata patch release] v1.17.1

## [1.17.0] - 2019-09-03

### Merged Pull Requests:

- Fix crash in malloc ([#6583](https://github.com/netdata/netdata/issues/6583))
- Netdata/packaging: [ci skip] make slack usage a soft error here (the library should be available though, so this is a workaround fix until i figure out the WOW)
- Build DEB and RPM packages in parallel ([#6579](https://github.com/netdata/netdata/issues/6579))
- Fixed typo ([#6575](https://github.com/netdata/netdata/issues/6575))
- Fix configure.ac allowing deprecated LZ4 libraries ([#6589](https://github.com/netdata/netdata/issues/6589))
- Mongodb: ssl connection ([#6546](https://github.com/netdata/netdata/issues/6546))
- Update plugin_nfacct.c ([#6098](https://github.com/netdata/netdata/issues/6098))
- Mysql collector: slave_status charts per replication channel ([#6597](https://github.com/netdata/netdata/issues/6597))
- Netdata/installer: do not enable netdata, if it was previously disabled ([#6606](https://github.com/netdata/netdata/issues/6606))
- Netdata/packaging: Expect .tar.gz version of go.d plugin ([#6590](https://github.com/netdata/netdata/issues/6590))
- Mysql: do not remove `slave_status` from queries in module ([#6617](https://github.com/netdata/netdata/issues/6617))
- Netdata Cloud documentation ([#6476](https://github.com/netdata/netdata/issues/6476))
- Better system OS detection for RHEL6 and Mac OS X ([#6612](https://github.com/netdata/netdata/issues/6612))
- Netdata: Add cosmix as codeowner, wherever cakrit is ([#6618](https://github.com/netdata/netdata/issues/6618))
- Netdata/packaging: Documentation on distribution support matrix and functionality availability ([#6552](https://github.com/netdata/netdata/issues/6552))
- [Package amd64 RPM][Build latest] Nightlies
- [Package amd64 DEB][Build latest] Nightlies
- Update terms of use for U.S. legal reasons ([#6631](https://github.com/netdata/netdata/issues/6631))
- Update package version requirements for LZ4 and libuv ([#6607](https://github.com/netdata/netdata/issues/6607))
- Netdata/packaging: Bare OS validations ([#6574](https://github.com/netdata/netdata/issues/6574))
-  Documentation style guide & build instructions ([#6563](https://github.com/netdata/netdata/issues/6563))
- Netdata/packaging: put go.d version in one place ([#6557](https://github.com/netdata/netdata/issues/6557))
- .travis.yml: Remove 'sudo: true' as it is now deprecated ([#6624](https://github.com/netdata/netdata/issues/6624))
- Vsphere collector: charts descritpion and alarms ([#6572](https://github.com/netdata/netdata/issues/6572))
- Fix a segmentation fault in backends ([#6627](https://github.com/netdata/netdata/issues/6627))
- (re-open) ZRAM info collector module (proc.plugin) ([#6424](https://github.com/netdata/netdata/issues/6424))
- Fix spigotmc plugin bugs ([#6635](https://github.com/netdata/netdata/issues/6635))
- Fix typos in: 'README.md' file. ([#6604](https://github.com/netdata/netdata/issues/6604))
- Fix none in left nav ([#6632](https://github.com/netdata/netdata/issues/6632))
- Accept <> around links in markdown ([#6646](https://github.com/netdata/netdata/issues/6646))
- Netdata/installer: Fix error running kickstart as a non-privileged user ([#6642](https://github.com/netdata/netdata/issues/6642))
-  Change "netdata" to "Netdata" in all docs ([#6621](https://github.com/netdata/netdata/issues/6621))
- Add MongoDB backend ([#6524](https://github.com/netdata/netdata/issues/6524))
- Prometheus version update ([#6652](https://github.com/netdata/netdata/issues/6652))
- [Package i386 RPM][Build latest] Nightlies
- Netdata/packaging: update distribution matrix for x86
- Fix Markdown Lint warnings ([#6664](https://github.com/netdata/netdata/issues/6664))
- Fix_compilation_test:  Eliminate git messages ([#6660](https://github.com/netdata/netdata/issues/6660))
- Netdata/packaging: separately identify dependency resolution for HTTPS and DB Engine ([#6670](https://github.com/netdata/netdata/issues/6670))
- Added some README instructions for apache CSP ([#6667](https://github.com/netdata/netdata/issues/6667))
- Add CHANGELOG.md to .remarkignore ([#6671](https://github.com/netdata/netdata/issues/6671))
- Netdata/packaging: Add auto-generation of packages for nightly ([#6675](https://github.com/netdata/netdata/issues/6675))
- Netdata/packaging: [ci skip] fix syntax and wording
- Netdata/packaging: [ci skip] Remove a stale command, also use git depth false for full repo retrieval
- [Package amd64 DEB][Build latest] Package build process trigger
- Netdata/packaging: [ci skip] nit
- Netdata/packaging: [ci skip] Mitigate build-id issue for go.d binary (Temp workaround)
- Netdata/packaging: [ci skip] Correlate configure command ([#6678](https://github.com/netdata/netdata/issues/6678))
- Netdata/packaging: [ci skip] The proposed flag did not work, removing and re-arranging the install of the binary
- :pencil2: fix typos. ([#6680](https://github.com/netdata/netdata/issues/6680))
- Netdata/packaging: in the peculiar case where a patch release has been applied, versioning will be messed up for nightlies.
- [Package amd64 RPM][Build latest] Package build process trigger
- Netdata/packaging: Align libdir in all configure commands ([#6682](https://github.com/netdata/netdata/issues/6682))
- Netdata/ci: [ci skip] Remove Fedora/31, still unstable
- Netdata/packaging: fix script naming, rpm was not accurate on that contexT
- Add alarm variables to the response of chart and data ([#6615](https://github.com/netdata/netdata/issues/6615))
- Install Netdata with Docker  ([#6596](https://github.com/netdata/netdata/issues/6596))
- Tabulatin on health/health.c ([#6691](https://github.com/netdata/netdata/issues/6691))
- .travis.yml: Build docker images in parallel ([#6672](https://github.com/netdata/netdata/issues/6672))
- Add alarm status counter api call ([#6554](https://github.com/netdata/netdata/issues/6554))
- Netdata/packaging: [ci skip] Emergent workaround fix for RPM packages - we have to check why build-id error started popping up now for RPM on go.d binary
- Netdata/ci: [ci skip] Fix changelog modification time script
- Netdata/packaging: [ci skip] Add trusty build process
- Netdata/packaging: [ci skip] Add xenial build process
- Netdata/packaging: [ci skip] Update dependency versions for ubuntu/trusty distro
- Netdata/packaging: Introduce gitlab simple script (beta)
- Empty commit trigger for testing
- Variable Granularity support for data collection ([#6430](https://github.com/netdata/netdata/issues/6430))
- Exact path to netdata.conf in .gitignore ([#6709](https://github.com/netdata/netdata/issues/6709))
- Netdata-installer warning removed ([#6715](https://github.com/netdata/netdata/issues/6715))
- Fix corrupted transaction payload handling during start-up of the database engine. ([#6731](https://github.com/netdata/netdata/issues/6731))
- Netdata/packaging: add shellcheck
- Netdata/packaging: remove sudo
- Url_registry: Remove of unecessary NULL ([#6714](https://github.com/netdata/netdata/issues/6714))
- History tips ([#6711](https://github.com/netdata/netdata/issues/6711))
- Netdata/packaging: Add purging logic for package cloud repositories ([#6732](https://github.com/netdata/netdata/issues/6732))
- .travis.yml: packaging/docker/check_login.sh can cause the build to fail ([#6655](https://github.com/netdata/netdata/issues/6655))
- .travis.yml: Improve template readability ([#6673](https://github.com/netdata/netdata/issues/6673))
- Netdata/packaging: Documentation nits
- Display uptime for processes ([#6654](https://github.com/netdata/netdata/issues/6654))
- Netdata/installer: fix static64 installer always overwriting configuration ([#6710](https://github.com/netdata/netdata/issues/6710))
- Netdata/packaging: fix coverity problem in travis (2 issues) ([#6743](https://github.com/netdata/netdata/issues/6743))
- Netdata/packaging: Add a more accurate title
- Make coverity-scan.sh usable by hand ([#6747](https://github.com/netdata/netdata/issues/6747))
- Netdata/packaging: Update depedency preparation for newly introduced coverity scanning
- Netdata/ci: non-interactive
- Netdata/ci: Use sudo for apt-get
- Netdata/packaging: more deps
- Netdata/ci: [ci skip] Use newer environment
- Netdata/ci: [ci skip] add protobuf compiler
- Netdata/packaging: [ci skip] lxc for python on a different package for 1804
- [Package amd64 RPM][Build latest] Package build for nightlies
- [Package amd64 DEB][Build latest] Package build for nightlies
- Update CODEOWNERS
- Add command-line option descriptions for apps.plugin ([#6738](https://github.com/netdata/netdata/issues/6738))
- [netdata minor release] v1.17.0
- Netdata/packaging: Add python3-lxc dependency too, different package for different version ([#6753](https://github.com/netdata/netdata/issues/6753))
- [netdata minor release] v1.17.0 retry
- Increase minimum release for changelog ([#6758](https://github.com/netdata/netdata/issues/6758))
- [netdata minor release] v1.17.0 final retry
- Skip issues from release changelog ([#6759](https://github.com/netdata/netdata/issues/6759))
- [netdata minor release] v1.17.0 final retry 2
- Remove changelog generation from release, as it keeps breaking ([#6761](https://github.com/netdata/netdata/issues/6761))
- [netdata minor release] v1.17.0 retry 7
- Update version
- [netdata minor release] v1.17.0 retry 8

## [1.16.1] - 2019-07-31

### Merged Pull Requests:

- Netdata/packaging: [ci skip] Emergent fix - Make sure you pick up latest branch details for the whole docker process
- Netdata/packaging: Add Packaging beta badge
- [Package AMD64 RPM] Building v1.16.0
- [Package arm64 RPM] Building v1.16.0
- [Package i386 RPM] Building v1.16.0
- Reimplemented mypopen() function family ([#6339](https://github.com/netdata/netdata/issues/6339))
- Add ZRAM collector module to the proc plugin
- Fix duplicate kills of collection threads on shutdown ([#6387](https://github.com/netdata/netdata/issues/6387))
- Add news of v1.16.0 to main README ([#6411](https://github.com/netdata/netdata/issues/6411))
- Revert "Add ZRAM collector module to the proc plugin"
- Snapshot uniqueId fix ([#6400](https://github.com/netdata/netdata/issues/6400))
- DOCFix ([#6404](https://github.com/netdata/netdata/issues/6404))
- Update Running-behind-apache.md ([#6406](https://github.com/netdata/netdata/issues/6406))
- Add apps grouping debug messages ([#6375](https://github.com/netdata/netdata/issues/6375))
- Updated logos in the infographic and remaining favicons ([#6417](https://github.com/netdata/netdata/issues/6417))
- Netdata/packaging/doc: Update documentation dependencies, these packages are not for basic install ([#6421](https://github.com/netdata/netdata/issues/6421))
- Netdata/packaging: Fix RPM packaging workflow issues, plus draft changes for .DEB packaging ([#6415](https://github.com/netdata/netdata/issues/6415))
- [Package AMD64 RPM] Packaging for v1.16.0
- Netdata/packaging: [ci skip] Nit - pass container parameter
- Netdata/packaging: [ci skip] Wrong positioning of arguments
- [Package i386 RPM] Packaging for v1.16.0
- SSL vs. TLS consistency and clarification in documentation ([#6414](https://github.com/netdata/netdata/issues/6414))
- [Package arm64 RPM] Packaging for v1.16.0
- [Package amd64 RPM][Build latest] Nightly binary package build
- Netdata/packaging: [ci skip] Dont use caps there, no need
- Netdata/packaging: [ci skip] replace all necessary items with amd64
- Netdata/packaging: Add documentation for binary packages, plus draft table for distributions support ([#6422](https://github.com/netdata/netdata/issues/6422))
- Netdata/packaging: [ci skip] Attempt to fix broken link on documentation
- Add more codeowners to the core ([#6413](https://github.com/netdata/netdata/issues/6413))
- Rethinkdb collector new driver support ([#6431](https://github.com/netdata/netdata/issues/6431))
- Fix issue with HTML docs generation ([#6433](https://github.com/netdata/netdata/issues/6433))
- Netdata/packaging: Remove Ventureer from demo sites ([#6442](https://github.com/netdata/netdata/issues/6442))
- Add more supported backends to the documentation ([#6443](https://github.com/netdata/netdata/issues/6443))
- Add global configuration option for zero metrics ([#6419](https://github.com/netdata/netdata/issues/6419))
- Fix CRC and I/O error handling in dbengine so that netdata is not halted and relevant error messages are printed and alarms are raised ([#6452](https://github.com/netdata/netdata/issues/6452))
- Python sensors collector: sensor chips filtering fix ([#6463](https://github.com/netdata/netdata/issues/6463))
- Fix broken links in dashboard_info.js ([#6461](https://github.com/netdata/netdata/issues/6461))
- Added site_url to config to stop it linking weird ([#6445](https://github.com/netdata/netdata/issues/6445))
- Styling improvements to documentation ([#6425](https://github.com/netdata/netdata/issues/6425))
- Netdata/packaging: Binary distributions - clean up .DEB package generation process ([#6465](https://github.com/netdata/netdata/issues/6465))
- [Package amd64 RPM][Build latest] testing
- [Package amd64 DEB][Build latest] Nightlies
- Update Nginx guide with changes ([#6466](https://github.com/netdata/netdata/issues/6466))
- Netdata/packaging: [ci skip] Make an update early in the repo
- Netdata/packaging: [ci skip] well, when no match in place, its equal to zero. Fix it.
- [Package amd64 RPM][Build latest] Nightlies
- Add a statement about permissions for the diskspace plugin ([#6474](https://github.com/netdata/netdata/issues/6474))
- Update docs health monitoring and health management api ([#6435](https://github.com/netdata/netdata/issues/6435))
- Json function could create overflow ([#6460](https://github.com/netdata/netdata/issues/6460))
- New 'homepage' for documentation site ([#6428](https://github.com/netdata/netdata/issues/6428))
- Change default installation to stable in documentation ([#6388](https://github.com/netdata/netdata/issues/6388))
- Netdata/packaging: Enable built-in support for prometheus remote write in packaging ([#6480](https://github.com/netdata/netdata/issues/6480))
- Fix the snappy library check ([#6479](https://github.com/netdata/netdata/issues/6479))
- Do not try to write log in /tmp ([#6491](https://github.com/netdata/netdata/issues/6491))
- Get user and group names from files  ([#6472](https://github.com/netdata/netdata/issues/6472))
- Added: We intend to keep the netdata agent forever FOSS ([#6504](https://github.com/netdata/netdata/issues/6504))
- Netdata/docs: Add @joelhans as co-owner on documentation ([#6501](https://github.com/netdata/netdata/issues/6501))
- Netdata/packaging: [ci skip] hot fix -- changelog file requires two spaces after email and before date
- Fix nodes menu sizing (responsive) ([#6455](https://github.com/netdata/netdata/issues/6455))
- Netdata/packaging: Do not deliver edit-config as part of the distribution tarball ([#6507](https://github.com/netdata/netdata/issues/6507))
- Add support for plain text only emails ([#6485](https://github.com/netdata/netdata/issues/6485))
- Fixed broken left navbar links in translated site ([#6505](https://github.com/netdata/netdata/issues/6505))
- Netdata/packaging: Fix installer scripts documentation. updater is, well, updater (not uninstaller). Also some style
- Add netdata haproxy documentation page ([#6454](https://github.com/netdata/netdata/issues/6454))
- Mongodb: change `password` to `pass` in the module config ([#6518](https://github.com/netdata/netdata/issues/6518))
- Revert "netdata/packaging: Do not deliver edit-config as part of the distribution tarball ([#6507](https://github.com/netdata/netdata/issues/6507))"
- Make use of GCC's __attribute__((unused)) ([#6392](https://github.com/netdata/netdata/issues/6392))
- Utf8 Badge Fix And URL Parser International Support (initial) ([#6426](https://github.com/netdata/netdata/issues/6426))
- Add CSS to restore navigation in mobile and better links ([#6533](https://github.com/netdata/netdata/issues/6533))
- Smartd_log: Disk __eq__ fix ([#6540](https://github.com/netdata/netdata/issues/6540))
- Url parser refactoring ([#6247](https://github.com/netdata/netdata/issues/6247))
- Add self.name() to contrib.md ([#6538](https://github.com/netdata/netdata/issues/6538))
- 6542: after clicking Nodes and successfully logging in, user should be redirected to console ([#6544](https://github.com/netdata/netdata/issues/6544))
- Removed text about nightly version and replaced with new boilerplate ([#6534](https://github.com/netdata/netdata/issues/6534))
- Fix parsing SSL ACL along with others ([#6468](https://github.com/netdata/netdata/issues/6468))
- Minor - code readibility HTTP CODES as defines ([#6539](https://github.com/netdata/netdata/issues/6539))
- Safer container names ([#6441](https://github.com/netdata/netdata/issues/6441))
- Netdata/ci: [ci skip] Do not include issues for now
- Netdata/packaging: Adopt netdata-updater to run properly for static64 installations. ([#6520](https://github.com/netdata/netdata/issues/6520))
- Netdata/streaming: fix bug for non-ssl installations - we used a definition that only exists on ssl-enabled installs
- Netdata/packaging: [ci skip] Make sure you notify us when nightlies changelog generation fails. It is a soft error, but we do want to know about it
- Netdata/packaging: Notify us when CHANGELOG.md gets too old ([#6556](https://github.com/netdata/netdata/issues/6556))
- .travis.yml: Fix some yamllint errors ([#6526](https://github.com/netdata/netdata/issues/6526))
- Add configurable default locations for trusted CA certificates ([#6549](https://github.com/netdata/netdata/issues/6549))
- Netdata/packaging: Move tarball checksum information into lib dir of netdata ([#6555](https://github.com/netdata/netdata/issues/6555))
- Smartd_log: use `del_dimension` instead of `hide_dimension` to… ([#6547](https://github.com/netdata/netdata/issues/6547))
- Handle disconnected sockets in unbound collector. ([#6561](https://github.com/netdata/netdata/issues/6561))
- [netdata patch release] v1.16.1

## [1.16.0] - 2019-07-08

### Merged Pull Requests:

- Use github templating mechanisms to classify issues when they are created ([#5776](https://github.com/netdata/netdata/issues/5776))
- Netdata: Fix labels usage, quotes are not needed ([#6091](https://github.com/netdata/netdata/issues/6091))
- Corrected links to web_log.conf ([#6087](https://github.com/netdata/netdata/issues/6087))
- Create missing /etc/netdata/custom-plugins.d ([#6089](https://github.com/netdata/netdata/issues/6089))
- Fix path #6085 ([#6093](https://github.com/netdata/netdata/issues/6093))
- Fix small typos ([#6090](https://github.com/netdata/netdata/issues/6090))
- Update go.d version and checksums ([#6097](https://github.com/netdata/netdata/issues/6097))
- Wmi alarms ([#6068](https://github.com/netdata/netdata/issues/6068))
- Move call to send_statistics later, to get more events from docker ([#6096](https://github.com/netdata/netdata/issues/6096))
- Mention anonymous statistics in additional places in the docs ([#6084](https://github.com/netdata/netdata/issues/6084))
- Fix incorrect module name: energi ([#6112](https://github.com/netdata/netdata/issues/6112))
- Revert "Move call to send_statistics later, to get more events from docker ([#6096](https://github.com/netdata/netdata/issues/6096))"
- Remove system_info copying ([#6113](https://github.com/netdata/netdata/issues/6113))
- Remove unecessary 2nd call of get_system_info at startup ([#6128](https://github.com/netdata/netdata/issues/6128))
- Active pid number alert ([#6116](https://github.com/netdata/netdata/issues/6116))
- Add mysql deadlock chart ([#6115](https://github.com/netdata/netdata/issues/6115))
- Netdata/packaging/installer: nits and fixes ([#6121](https://github.com/netdata/netdata/issues/6121))
- Move telemetry config before netdata is restarted and fix the console message ([#6127](https://github.com/netdata/netdata/issues/6127))
- Add modules to charts.d.conf ([#6120](https://github.com/netdata/netdata/issues/6120))
- Update README.md ([#6111](https://github.com/netdata/netdata/issues/6111))
- Change 'netdata' to 'Netdata' in docs/ and README ([#6137](https://github.com/netdata/netdata/issues/6137))
- Documentation fixes ([#6144](https://github.com/netdata/netdata/issues/6144))
- X509check: add last_collected alarm ([#6139](https://github.com/netdata/netdata/issues/6139))
- Web_log: remove trailing space from nginx_ext2 pattern ([#6138](https://github.com/netdata/netdata/issues/6138))
- Update README.md ([#6146](https://github.com/netdata/netdata/issues/6146))
- Add "custom-plugins.d" to fix error in log file ([#6080](https://github.com/netdata/netdata/issues/6080))
- Pass correct info to run funct. ([#6126](https://github.com/netdata/netdata/issues/6126))
- Properly add security policy ([#6163](https://github.com/netdata/netdata/issues/6163))
- Update security policy ([#6166](https://github.com/netdata/netdata/issues/6166))
- DB engine optimize RAM usage ([#6134](https://github.com/netdata/netdata/issues/6134))
- Add empty page detection in DB engine ([#6173](https://github.com/netdata/netdata/issues/6173))
- Varnish v4 compatibility fix ([#6168](https://github.com/netdata/netdata/issues/6168))
- Web log pattern fix ([#6180](https://github.com/netdata/netdata/issues/6180))
- SSL implementation for Netdata ([#5956](https://github.com/netdata/netdata/issues/5956))
- Netdata/packaging: always update on empty checksum ([#6182](https://github.com/netdata/netdata/issues/6182))
- Correct date used in pushbullet notifications ([#6179](https://github.com/netdata/netdata/issues/6179))
- Make custom notification's instructions clearer ([#6181](https://github.com/netdata/netdata/issues/6181))
- Correct example sensor list ([#6189](https://github.com/netdata/netdata/issues/6189))
- Turn tv.html links to https ([#6198](https://github.com/netdata/netdata/issues/6198))
- Change print level from error to info ([#6195](https://github.com/netdata/netdata/issues/6195))
- Support falling back to buffered I/O when direct I/O is unavailable ([#6174](https://github.com/netdata/netdata/issues/6174))
- Add perforce server process monitoring ([#6064](https://github.com/netdata/netdata/issues/6064))
- Change 509check_last_collected_secs alarm every to 60s ([#6194](https://github.com/netdata/netdata/issues/6194))
- Usw `fa-server` icon for wmi collector ([#6197](https://github.com/netdata/netdata/issues/6197))
- NEW: local remark-lint checks and autofix support ([#5898](https://github.com/netdata/netdata/issues/5898))
- Terminate email header lines with \r\n ([#6187](https://github.com/netdata/netdata/issues/6187))
- Netdata/daemon: SSL fix - broken compilation case when ssl library not present! ([#6201](https://github.com/netdata/netdata/issues/6201))
- Increase the cpu_limit chart precision ([#6172](https://github.com/netdata/netdata/issues/6172))
- Fix mdstat disks chart ([#6164](https://github.com/netdata/netdata/issues/6164))
- Add note to make smartd directory ([#6203](https://github.com/netdata/netdata/issues/6203))
- Smartd documentation improvements ([#6207](https://github.com/netdata/netdata/issues/6207))
- Fix page cache descriptor race condition ([#6202](https://github.com/netdata/netdata/issues/6202))
- Update anonymous-statistics.md ([#6208](https://github.com/netdata/netdata/issues/6208))
- Simplify health cmdapi tester - no setup/cleanup needed ([#6210](https://github.com/netdata/netdata/issues/6210))
- Add code style guidance to CONTRIBUTING ([#6212](https://github.com/netdata/netdata/issues/6212))
- Netdata/packaging/ci: Add lifecycle checks to bare operating system installations ([#6209](https://github.com/netdata/netdata/issues/6209))
- Fill chart gaps efficiently. ([#6216](https://github.com/netdata/netdata/issues/6216))
- Bump go.d 0.6.1 ([#6217](https://github.com/netdata/netdata/issues/6217))
- Netdata/daemon: Eliminate a couple of warnings, plus tabs removal ([#6222](https://github.com/netdata/netdata/issues/6222))
- SSL_fix_format Fix wrong format used with SSL! ([#6219](https://github.com/netdata/netdata/issues/6219))
- New URL parser ([#6070](https://github.com/netdata/netdata/issues/6070))
- URL_parser fixing allmetrics! ([#6231](https://github.com/netdata/netdata/issues/6231))
- Remove CNCF logo and TOC presentation reference ([#6234](https://github.com/netdata/netdata/issues/6234))
- Prometheus remote write backend ([#6062](https://github.com/netdata/netdata/issues/6062))
- Force page alignment per dimension of chart. ([#6240](https://github.com/netdata/netdata/issues/6240))
- Update CODEOWNERS ([#6241](https://github.com/netdata/netdata/issues/6241))
- MGMT_fixes change functions ([#6242](https://github.com/netdata/netdata/issues/6242))
- Revert "URL_parser fixing allmetrics! ([#6231](https://github.com/netdata/netdata/issues/6231))"
- Revert "MGMT_fixes change functions ([#6242](https://github.com/netdata/netdata/issues/6242))"
- Revert "New URL parser ([#6070](https://github.com/netdata/netdata/issues/6070))"
- Netdata/packaging/docker: Fix docker socket utilization, first pass ([#6233](https://github.com/netdata/netdata/issues/6233))
- Netdata/packaging: Introducing automatic binary packages generation and delivery for RPM types (Phase 1) ([#6223](https://github.com/netdata/netdata/issues/6223))
- Netdata/packaging: Add more distribution validations ([#6235](https://github.com/netdata/netdata/issues/6235))
- Dns_query_time py module: saving dns request in 'r', checking response for answer, recording '-… ([#6237](https://github.com/netdata/netdata/issues/6237))
- Netdata/packaging: Fix netdata/netdata docker image failure, when users passing PGID that already exists on the system ([#6259](https://github.com/netdata/netdata/issues/6259))
- Netdata/packaging: Add option for slack messages to be pushed on alternative channel, than the default. Push all info to #automation, make #ci-status error reporting only ([#6268](https://github.com/netdata/netdata/issues/6268))
- UrlService: add min required version check ([#6263](https://github.com/netdata/netdata/issues/6263))
- Netdata/packaging: it seems that libexecdir may deviate the expected path, explictly set this with configure to avoid uncomfortable situations ([#6272](https://github.com/netdata/netdata/issues/6272))
- Netdata/packaging/documentation: Its Redhat, then came the others ([#6271](https://github.com/netdata/netdata/issues/6271))
- Fix devuan support for initd ([#6275](https://github.com/netdata/netdata/issues/6275))
- Fix variable namespace in memory health check ([#6261](https://github.com/netdata/netdata/issues/6261))
- Add comments about AWS SDK for C++ installation ([#6277](https://github.com/netdata/netdata/issues/6277))
- Fix typo in nfacct.plugin ([#6260](https://github.com/netdata/netdata/issues/6260))
- Update streaming documentation and config file with more info on how health enabled by default = auto works. ([#6281](https://github.com/netdata/netdata/issues/6281))
- Netdata/packaging: Separate beta messages from production messages ([#6282](https://github.com/netdata/netdata/issues/6282))
- Doc: remove single/multi-threaded web server configuration ([#6291](https://github.com/netdata/netdata/issues/6291))
- Web ([#6294](https://github.com/netdata/netdata/issues/6294))
- Stale bot limits update ([#6297](https://github.com/netdata/netdata/issues/6297))
- Add note regarding libexecdir ([#6301](https://github.com/netdata/netdata/issues/6301))
- Add a riak plugin ([#6286](https://github.com/netdata/netdata/issues/6286))
- Chart name streaming ([#6304](https://github.com/netdata/netdata/issues/6304))
- Fix elasticsearch plugin ([#6311](https://github.com/netdata/netdata/issues/6311))
- Perf plugin ([#6225](https://github.com/netdata/netdata/issues/6225))
- Update the documentation on charts with zero metrics ([#6314](https://github.com/netdata/netdata/issues/6314))
- [freeipmi] Remove id in sensor name when already unique ([#6296](https://github.com/netdata/netdata/issues/6296))
- Handle file descriptors running out ([#6303](https://github.com/netdata/netdata/issues/6303))
- Update documentation about dbengine ([#6264](https://github.com/netdata/netdata/issues/6264))
- Installer: include go.d.plugin version v0.7.0 ([#6328](https://github.com/netdata/netdata/issues/6328))
- Dnsmasq_dhcp: dhcp-range utilization alarm ([#6319](https://github.com/netdata/netdata/issues/6319))
- Pihole: add to the dashboard_info ([#6325](https://github.com/netdata/netdata/issues/6325))
- Pihole collector: add alarms ([#6320](https://github.com/netdata/netdata/issues/6320))
- SSL_better_name change name! ([#6336](https://github.com/netdata/netdata/issues/6336))
- Adaptec_raid: logical device regex fix ([#6338](https://github.com/netdata/netdata/issues/6338))
- Pihole: alarms delay fix ([#6342](https://github.com/netdata/netdata/issues/6342))
- Netdata/packaging/docker: Fix docker documentation and a fix to avoid failures ([#6344](https://github.com/netdata/netdata/issues/6344))
- Tomcat status invalid XML fix ([#6345](https://github.com/netdata/netdata/issues/6345))
- Add userstats charts for mysql ([#6118](https://github.com/netdata/netdata/issues/6118))
- Easily disable alarms, by persisting the silencers configuration ([#6274](https://github.com/netdata/netdata/issues/6274))
- Backend and SSL! ([#6220](https://github.com/netdata/netdata/issues/6220))
- Better checks for nfacct headers ([#6351](https://github.com/netdata/netdata/issues/6351))
- Revert "Easily disable alarms, by persisting the silencers configuration ([#6274](https://github.com/netdata/netdata/issues/6274))"
- Redirect to new site at www.netdata.cloud ([#6359](https://github.com/netdata/netdata/issues/6359))
- Monit: obsolete service in runtime ([#6340](https://github.com/netdata/netdata/issues/6340))
- Apps.plugin: detect openldap server processes by default on Deb… ([#6364](https://github.com/netdata/netdata/issues/6364))
- Repeating alarm notifications ([#6309](https://github.com/netdata/netdata/issues/6309))
- Easily disable alarms, by persisting the silencers configuration ([#6360](https://github.com/netdata/netdata/issues/6360))
- Update README.md ([#6372](https://github.com/netdata/netdata/issues/6372))
- Health_df ([#6379](https://github.com/netdata/netdata/issues/6379))
- Netdata/packaging: Netdata binary packages generation - spec file refinement, support for nightlies (RPM) ([#6369](https://github.com/netdata/netdata/issues/6369))
- Netdata/packaging: [ci skip] Revert modifications added to help testing
- Health could not read properly the health silencers file ([#6374](https://github.com/netdata/netdata/issues/6374))
- Alarm-notify.sh should respect the cloud base url setting  ([#6383](https://github.com/netdata/netdata/issues/6383))
- Add a check for a macro declaration for the perf plugin ([#6382](https://github.com/netdata/netdata/issues/6382))
- Update apps_groups.conf for time group ([#6397](https://github.com/netdata/netdata/issues/6397))
- Update to icons ([#6396](https://github.com/netdata/netdata/issues/6396))
- Changed links from my-netdata.io to netdata.cloud ([#6389](https://github.com/netdata/netdata/issues/6389))
- Update favicon with new logo in docs and index.html ([#6398](https://github.com/netdata/netdata/issues/6398))
- Add a .gitattributes file ([#6381](https://github.com/netdata/netdata/issues/6381))
- Health_index ([#6377](https://github.com/netdata/netdata/issues/6377))
- Add more debug messages for pluginsd pipe errors ([#6373](https://github.com/netdata/netdata/issues/6373))
- Ignore /dev and /run space/inode usage ([#6399](https://github.com/netdata/netdata/issues/6399))
- Netdata/packaging: leftover cleanup, dont use dev branch on this condition
- [netdata minor release] v1.16.0

## [1.15.0] - 2019-05-22

### Merged Pull Requests:

- Extend netdata info API call ([#5889](https://github.com/netdata/netdata/issues/5889))
- NEW: allow additional name argument passing to urllib3 request in UrlService ([#5893](https://github.com/netdata/netdata/issues/5893))
- Add ioping plugin ([#5725](https://github.com/netdata/netdata/issues/5725))
- SocketService: set socket operation timeout before connecting ([#5911](https://github.com/netdata/netdata/issues/5911))
- Smartd_log: attrs 3, 194 fix ([#5923](https://github.com/netdata/netdata/issues/5923))
- Netdata/packaging/docker: fix docker permissions and other things ([#5917](https://github.com/netdata/netdata/issues/5917))
- NEW: Energi Core daemon monitoring, suits other Bitcoin forks ([#5894](https://github.com/netdata/netdata/issues/5894))
- Fix lifecycle script ([#5918](https://github.com/netdata/netdata/issues/5918))
- Fixing a typo ([#5936](https://github.com/netdata/netdata/issues/5936))
- Nvidia_smi: power chart algorithm,mul,div fix ([#5940](https://github.com/netdata/netdata/issues/5940))
- Netdata/packaging/ci: Add some extra info on various stages, also introduce a check_login.sh step in prior to docker publishing, for early fail if credentials are messed up. Waiting the full build is overhead ([#5928](https://github.com/netdata/netdata/issues/5928))
- Info API minor enhancements
- Netdata/packaging/ci:  Make timeout usage more cross-distro compliant ([#5938](https://github.com/netdata/netdata/issues/5938))
- Add support for Mac OS X Name and Version ([#5949](https://github.com/netdata/netdata/issues/5949))
- Fix coverity warnings on get_system_info ([#5952](https://github.com/netdata/netdata/issues/5952))
- Netdata/packaging/ci: Create manual nightly deployment tool ([#5899](https://github.com/netdata/netdata/issues/5899))
- Add rel. 1.14 to news section
- Update Node app_group ([#5962](https://github.com/netdata/netdata/issues/5962))
- Mongodb: various KeyError  fixes ([#5931](https://github.com/netdata/netdata/issues/5931))
- Change HTTP version to HTTP method in web_log docs ([#5974](https://github.com/netdata/netdata/issues/5974))
- Fix typo in the mysql graph ([#5980](https://github.com/netdata/netdata/issues/5980))
- Implement unified cgroup cpu limit ([#5895](https://github.com/netdata/netdata/issues/5895))
- Fix pfsense instructions ([#5982](https://github.com/netdata/netdata/issues/5982))
- UserService self._get_raw_data except fix ([#5997](https://github.com/netdata/netdata/issues/5997))
- Do not cache alarms and info api calls. Extend no-cache headers ([#5999](https://github.com/netdata/netdata/issues/5999))
- Add sample implementation to custom_sender ([#5992](https://github.com/netdata/netdata/issues/5992))
- Add "text-only" chart renderer ([#5971](https://github.com/netdata/netdata/issues/5971))
- Add system info streaming ([#5996](https://github.com/netdata/netdata/issues/5996))
- Add AWS Kinesis backend ([#5914](https://github.com/netdata/netdata/issues/5914))
- Netdata/packaging: Do not install netdata service when within docker ([#5947](https://github.com/netdata/netdata/issues/5947))
- Fix Coverity defects ([#6008](https://github.com/netdata/netdata/issues/6008))
- Fix segmentation fault ([#6011](https://github.com/netdata/netdata/issues/6011))
- Netdata/packaging: Make docker image bring onboard the required packages for the new database ([#6014](https://github.com/netdata/netdata/issues/6014))
- Database engine ([#5282](https://github.com/netdata/netdata/issues/5282))
- Netdata/packaging: you need more content to fetch git describe info. Cant explain why it didnt fail before though ([#6007](https://github.com/netdata/netdata/issues/6007))
- Correct instructions on Slack webhooks ([#6016](https://github.com/netdata/netdata/issues/6016))
- Support for aggregate node view ([#5902](https://github.com/netdata/netdata/issues/5902))
- Netdata/packaging: Fix broken netdata docker image for dbengine-enabled code ([#6020](https://github.com/netdata/netdata/issues/6020))
- Add prowl to list of methods checked for enablement of notifications ([#6022](https://github.com/netdata/netdata/issues/6022))
- Add database engine doc to the menu ([#6029](https://github.com/netdata/netdata/issues/6029))
- Initial script for API load testing ([#5892](https://github.com/netdata/netdata/issues/5892))
- Reduce HTML documentation font size ([#6030](https://github.com/netdata/netdata/issues/6030))
- Remove nl2br addon, to get the same view in html docs as in markdown ([#6032](https://github.com/netdata/netdata/issues/6032))
- Installer: include go.d.plugin version v0.5.0 ([#6025](https://github.com/netdata/netdata/issues/6025))
- Fix timestamps being reversed for backends ([#6040](https://github.com/netdata/netdata/issues/6040))
- Netdata/packaging: Fix makeself packaging ([#6041](https://github.com/netdata/netdata/issues/6041))
- Netdata/packaging: Fine tune documentation on how to test docker images ([#6024](https://github.com/netdata/netdata/issues/6024))
- Minor change from @VLegakis ([#6028](https://github.com/netdata/netdata/issues/6028))
- Netdata/packaging: Adjust auto-updater installation logic ([#6035](https://github.com/netdata/netdata/issues/6035))
- Netdata/daemon: Remove copy/paste bug
- Netdata/packaging: Fix kickstart/kickstart-static64 formatting bugs ([#6048](https://github.com/netdata/netdata/issues/6048))
- Netdata/daemon/backends: Fix AWS Kinesis link error when building on Mac OS ([#6047](https://github.com/netdata/netdata/issues/6047))
- Netdata/packaging/ci: Fix slack integration
- Netdata/packaging/ci: Make slack lib fail loud when parameters are broken
- Netdata/packaging: install/uninstall fixes for macOS case ([#6045](https://github.com/netdata/netdata/issues/6045))
- Update configuration-guide.md ([#6052](https://github.com/netdata/netdata/issues/6052))
- Fix delete datafile error ([#6057](https://github.com/netdata/netdata/issues/6057))
- [netdata minor release] v1.15
- Add 1.15 to news section of main README ([#6065](https://github.com/netdata/netdata/issues/6065))
- Update swagger with definition of api/v1/alarm_variables ([#6055](https://github.com/netdata/netdata/issues/6055))
- Add more metrics to the tests ([#6074](https://github.com/netdata/netdata/issues/6074))
- Fix creating chart directories when not necessary with memory mode dbengine ([#6078](https://github.com/netdata/netdata/issues/6078))
- Fix race condition in DB engine API ([#6079](https://github.com/netdata/netdata/issues/6079))
- Shorten netdata version and correctly send OS_VERSION_ID ([#6082](https://github.com/netdata/netdata/issues/6082))
- Fix build errors ([#6081](https://github.com/netdata/netdata/issues/6081))
- Netdata/packaging/ci: pull all git changes, prior to publishing
- [netdata minor release] v1.15.0 - Republishing for critical fixes

## [1.14.0] - 2019-04-18

### Merged Pull Requests:

- Fix checksum ([#5750](https://github.com/netdata/netdata/issues/5750))
- Fix some misspells in docs and code ([#5549](https://github.com/netdata/netdata/issues/5549))
- Postgres module: connect via uri ([#5758](https://github.com/netdata/netdata/issues/5758))
- Libapache2-mod-proxy-html was a transitional package for apache2-bin ([#5753](https://github.com/netdata/netdata/issues/5753))
- Fix the Polyverse reinstall that caused APK broken state ([#5751](https://github.com/netdata/netdata/issues/5751))
- Netdata/packaging/installer: fix sha256sum failure on freeBSD ([#5760](https://github.com/netdata/netdata/issues/5760))
- Correct typo in ceph README ([#5742](https://github.com/netdata/netdata/issues/5742))
- Added RocketChat default recipient for roles ([#5545](https://github.com/netdata/netdata/issues/5545))
- Add simonnagl as CODEOWNER for cups.plugin ([#5453](https://github.com/netdata/netdata/issues/5453))
- Make netdata.spec more futureproof ([#5766](https://github.com/netdata/netdata/issues/5766))
- Netdata/packaging/kickstart: fix kickstart ([#5771](https://github.com/netdata/netdata/issues/5771))
- Netdata/packaging: Remove .tar.gz on distclean ([#5763](https://github.com/netdata/netdata/issues/5763))
- Fix smstools3 error handling ([#5770](https://github.com/netdata/netdata/issues/5770))
- Netdata: Add another global owner ([#5777](https://github.com/netdata/netdata/issues/5777))
- Netdata/packaging/ci: Add kickstart execution integrity tests ([#5778](https://github.com/netdata/netdata/issues/5778))
- Netdata/packaging/ci: fix travis syntax ([#5780](https://github.com/netdata/netdata/issues/5780))
- Netdata/packaging/updater: fix updater ([#5785](https://github.com/netdata/netdata/issues/5785))
- Fix unix socket access on FreeBSD ([#5756](https://github.com/netdata/netdata/issues/5756))
- Netdata/packaging: Fix non compatible function declaration ([#5789](https://github.com/netdata/netdata/issues/5789))
- Add preferred disk id pattern ([#5779](https://github.com/netdata/netdata/issues/5779))
- Netdata/packaging/docker: Change password ([#5790](https://github.com/netdata/netdata/issues/5790))
- Python.d.plugin zombie fix ([#5797](https://github.com/netdata/netdata/issues/5797))
- Python.d.plugin: allow delete dimension in runtime ([#5795](https://github.com/netdata/netdata/issues/5795))
- Add memory free and per process memory usage to nvidia_smi ([#5796](https://github.com/netdata/netdata/issues/5796))
- Netdata/packaging/installer: HoS situation - Fix broken install-or-update script ([#5806](https://github.com/netdata/netdata/issues/5806))
- Support configurable syslog facilities ([#5792](https://github.com/netdata/netdata/issues/5792))
- Netdata/packaging/installer: Update README ([#5811](https://github.com/netdata/netdata/issues/5811))
- Return responses even in memory mode none ([#5819](https://github.com/netdata/netdata/issues/5819))
- Unified cgroup support ([#5407](https://github.com/netdata/netdata/issues/5407))
- Add TypeError in except ([#5833](https://github.com/netdata/netdata/issues/5833))
- Elasticsearch: update config file ([#5834](https://github.com/netdata/netdata/issues/5834))
- Start job in thread after recheck ([#5837](https://github.com/netdata/netdata/issues/5837))
- Phpfpm collector: add last_collected_secs health check ([#5836](https://github.com/netdata/netdata/issues/5836))
- Python.d.plugin: py2 fix crash on macos ([#5838](https://github.com/netdata/netdata/issues/5838))
- Openldap tls support rebased ([#5859](https://github.com/netdata/netdata/issues/5859))
- Netdata/packaging/installer: Dont use --always, when git describe cant find a tag we have the alternative of packaging/version content file ([#5860](https://github.com/netdata/netdata/issues/5860))
- Netdata/web/gui/dashboard: do not remove the dashboard upon make clean. We regenerate the dashboard file anyway always, so its fine ([#5853](https://github.com/netdata/netdata/issues/5853))
- Netdata/packaging/installer: correlate permissions amongst plugins to 0750 ([#5856](https://github.com/netdata/netdata/issues/5856))
- Installer: include go.d.plugin version v0.4.0 ([#5849](https://github.com/netdata/netdata/issues/5849))
- Netdata/packaging/ci: Use proper notifier in slack message ([#5866](https://github.com/netdata/netdata/issues/5866))
- Netdata/packaging/ci: Do not trigger deployment if certain conditions are not met ([#5816](https://github.com/netdata/netdata/issues/5816))
- Netdata/collectors/cgroups.plugin: When jq not available, prompt the user he may have to install jq ([#5848](https://github.com/netdata/netdata/issues/5848))
- Fix segmentation fault in streaming ([#5882](https://github.com/netdata/netdata/issues/5882))
- Pipeline redesign master ([#5885](https://github.com/netdata/netdata/issues/5885))
- [netdata minor release] v1.14
- [netdata minor release] v1.14 (Repeating trigger)

## [1.14.0-rc0] - 2019-03-30

### Merged Pull Requests:

- Add v1.13 news to main README ([#5646](https://github.com/netdata/netdata/issues/5646))
- Fix ([#5581](https://github.com/netdata/netdata/issues/5581))
- X509check alarm fix ([#5645](https://github.com/netdata/netdata/issues/5645))
- Fix path to pidfile in FreeBSD rc.d file ([#5657](https://github.com/netdata/netdata/issues/5657))
- Load gtm only if anonymous_statistics are enabled ([#5651](https://github.com/netdata/netdata/issues/5651))
- Fix slack notifications footer and set cloud redirect URL to http ([#5650](https://github.com/netdata/netdata/issues/5650))
- Remove obsolete python modules ([#5659](https://github.com/netdata/netdata/issues/5659))
- Fix py2-psycopg2 right after upgrade ([#5667](https://github.com/netdata/netdata/issues/5667))
- Patch netdata-installer.sh to avoid unwanted errors during stock config cleanup ([#5571](https://github.com/netdata/netdata/issues/5571))
- Netdata/build: A small house keeping around coverity scan (no functional  or process change) ([#5656](https://github.com/netdata/netdata/issues/5656))
- Make sign-in functionality more visible ([#5569](https://github.com/netdata/netdata/issues/5569))
- Py stuff: change l2isbad to ilyam8 ([#5676](https://github.com/netdata/netdata/issues/5676))
- Fix incorrect use of isnormal() ([#5677](https://github.com/netdata/netdata/issues/5677))
- Bring uninstaller back ([#5675](https://github.com/netdata/netdata/issues/5675))
- Do not show the modal on demo sites ([#5686](https://github.com/netdata/netdata/issues/5686))
- Netdata/packaging/uninstaller: Update uninstall document ([#5678](https://github.com/netdata/netdata/issues/5678))
- Split docker build script into build and publish - attempt small cleanups along the way ([#5591](https://github.com/netdata/netdata/issues/5591))
- Netdata/packaging/docker: Fix build - typo on array iteration ([#5691](https://github.com/netdata/netdata/issues/5691))
- Netdata/packaging/docker/publish: Manifest list naming should take place after version determination (gotcha). Add some extra logging too ([#5692](https://github.com/netdata/netdata/issues/5692))
- Add a description how to achieve vhost access logs with nginx in web_log ([#5694](https://github.com/netdata/netdata/issues/5694))
- Remove temp log file if no update needed ([#5695](https://github.com/netdata/netdata/issues/5695))
- Add SMS Server Tools 3 SMS notifications ([#5662](https://github.com/netdata/netdata/issues/5662))
- Integrity testing: Check published kickstart files integrity ([#5689](https://github.com/netdata/netdata/issues/5689))
- Add 'containers priority' option to cgroups plugin ([#5700](https://github.com/netdata/netdata/issues/5700))
- Postgres add ssl connection support ([#5661](https://github.com/netdata/netdata/issues/5661))
- Netdata/packaging/ci: nits ([#5709](https://github.com/netdata/netdata/issues/5709))
- Add some kubernetes to apps_groups.conf ([#5714](https://github.com/netdata/netdata/issues/5714))
- Add xenstat plugin ([#5660](https://github.com/netdata/netdata/issues/5660))
- Update fping version ([#5719](https://github.com/netdata/netdata/issues/5719))
- Send custom docs ([#5703](https://github.com/netdata/netdata/issues/5703))
- Fix dist build ([#5728](https://github.com/netdata/netdata/issues/5728))
- Spelling fix for streaming readme.md ([#5734](https://github.com/netdata/netdata/issues/5734))
- Add some kubelet alarms ([#5724](https://github.com/netdata/netdata/issues/5724))
- NEW: authdb option for MongoDB collector ([#5707](https://github.com/netdata/netdata/issues/5707))
- Installer: include go.d.plugin version v0.3.1 ([#5740](https://github.com/netdata/netdata/issues/5740))
- Netdata/packaging/installer: netdata-installer.sh script (and subscripts) refactoring wrap-up ([#5736](https://github.com/netdata/netdata/issues/5736))
- Netdata/packaging/ci: Make Travis CI more strict on nightlies run ([#5708](https://github.com/netdata/netdata/issues/5708))
- Access: fix codeowners ([#5739](https://github.com/netdata/netdata/issues/5739))
- Netdata/packaging/makeself: no comment, i will be adding artifact emulation on the builds, not just make dist ^_^ ([#5743](https://github.com/netdata/netdata/issues/5743))
- Netdata/packaging/ci: small improvements in logging ([#5746](https://github.com/netdata/netdata/issues/5746))
- [netdata release candidate] Release candidate v1.13.0-rc0
- [netdata release candidate] Release candidate v1.14.0-rc0 (repeat with correct comment)
- [netdata release candidate] Release candidate v1.14.0-rc0

## [1.13.0] - 2019-03-14

### Merged Pull Requests:

- Update unbound module documenttion with troubleshooting section. ([#5528](https://github.com/netdata/netdata/issues/5528))
- Prevent data corruption upon GUID duplication between master and slave netdata instances ([#5511](https://github.com/netdata/netdata/issues/5511))
- Registry delete should allow deleting the host we are looking at ([#5537](https://github.com/netdata/netdata/issues/5537))
- Fix typo in demo sites ([#5546](https://github.com/netdata/netdata/issues/5546))
- Correct go.d.plugin sha256sum check ([#5539](https://github.com/netdata/netdata/issues/5539))
- Support legacy Prometheus metric names for source average ([#5531](https://github.com/netdata/netdata/issues/5531))
- Have the debug option set the freeipmi debug flags ([#5548](https://github.com/netdata/netdata/issues/5548))
- Add news for 1.12.1 and 1.12.2 to main readme ([#5544](https://github.com/netdata/netdata/issues/5544))
- Minor fixes around plugin_directories initialization ([#5536](https://github.com/netdata/netdata/issues/5536))
- Pass agent id to authorization pages ([#5551](https://github.com/netdata/netdata/issues/5551))
- Don't send zeroes for empty groups ([#5540](https://github.com/netdata/netdata/issues/5540))
- Convert SpigotMC module to use regexes for parsing. ([#5507](https://github.com/netdata/netdata/issues/5507))
- Add zero minimum ([#5395](https://github.com/netdata/netdata/issues/5395))
- Add IPC shared memory charts ([#5522](https://github.com/netdata/netdata/issues/5522))
- Python.d.plugin: use separate process for initial module checking ([#5552](https://github.com/netdata/netdata/issues/5552))
- Fix incorrect icon for streaming master #5560 ([#5561](https://github.com/netdata/netdata/issues/5561))
- Wait for logs to be opened before calling anonymous statistics ([#5573](https://github.com/netdata/netdata/issues/5573))
- Correct PLUGINS_DIR directory in CMakeLists.txt ([#5555](https://github.com/netdata/netdata/issues/5555))
- Delay renaming for docker containers ([#5557](https://github.com/netdata/netdata/issues/5557))
- SimpleService cleanup: do not inherit from OldVersionCompatibility ([#5594](https://github.com/netdata/netdata/issues/5594))
- Spigotmc: py2 compatibility fix ([#5593](https://github.com/netdata/netdata/issues/5593))
- Spigotmc fix UnicodeDecodeError ([#5598](https://github.com/netdata/netdata/issues/5598))
- Fix nonobsolete dimension deletion ([#5563](https://github.com/netdata/netdata/issues/5563))
- Python loaders cleanup ([#5602](https://github.com/netdata/netdata/issues/5602))
- Update custom dashboards documentation ([#5600](https://github.com/netdata/netdata/issues/5600))
- Mysql module add ssl connection support ([#5610](https://github.com/netdata/netdata/issues/5610))
- Fix a bug in cgroups renaming ([#5612](https://github.com/netdata/netdata/issues/5612))
- Use total_* memory counters for cgroups ([#5592](https://github.com/netdata/netdata/issues/5592))
- Postgres connect fix ([#5617](https://github.com/netdata/netdata/issues/5617))
- Fix Postgres connect, incorrect port value ([#5618](https://github.com/netdata/netdata/issues/5618))
- Sslcheck module: (remote) SSL certificate expiry time check ([#5365](https://github.com/netdata/netdata/issues/5365))
- When running from within a k8s pod, use the k8s API to get the cgroup name  ([#5576](https://github.com/netdata/netdata/issues/5576))
- Fix memory leaks ([#5604](https://github.com/netdata/netdata/issues/5604))
- Add link to k8s helm chart in installation ([#5627](https://github.com/netdata/netdata/issues/5627))
- Remove ssl check module ([#5626](https://github.com/netdata/netdata/issues/5626))
- Remove paulfantom code ownership and TODO notices ([#5579](https://github.com/netdata/netdata/issues/5579))
- Beanstalk fix ([#5633](https://github.com/netdata/netdata/issues/5633))
- Installer: include go.d.plugin version v0.2.0 ([#5638](https://github.com/netdata/netdata/issues/5638))
- [netdata minor release] Releasing v1.13

## [1.12.2] - 2019-02-28

### Merged Pull Requests:

- Increase timeout for download of go.d.plugin ([#5468](https://github.com/netdata/netdata/issues/5468))
- Added rocketchat to method-list ([#5471](https://github.com/netdata/netdata/issues/5471))
- Update README.md ([#5473](https://github.com/netdata/netdata/issues/5473))
- Apps plugin is not an internal collector ([#5472](https://github.com/netdata/netdata/issues/5472))
- Fix QoS docs code fragment for HTML ([#5469](https://github.com/netdata/netdata/issues/5469))
- Increase curl timeout to address spotty network ([#5476](https://github.com/netdata/netdata/issues/5476))
- Make curl silent and show errors only if it fails ([#5485](https://github.com/netdata/netdata/issues/5485))
- Fix SIGSEGV crash during shutdown of tc plugin. ([#5495](https://github.com/netdata/netdata/issues/5495))
- Kickstart md5sums ([#5496](https://github.com/netdata/netdata/issues/5496))
- Docker: use base images build by us ([#5465](https://github.com/netdata/netdata/issues/5465))
- Prevent merging changes to kickstart.sh when checksum in docs is wrong ([#5498](https://github.com/netdata/netdata/issues/5498))
- Introduce "stable channel" placeholder ([#5499](https://github.com/netdata/netdata/issues/5499))
- Update CODEOWNERS
- Update netdata-updater.sh
- Add heartbeat ([#5503](https://github.com/netdata/netdata/issues/5503))
- Fix CMake warning ([#5379](https://github.com/netdata/netdata/issues/5379))
- Oracledb py module ([#5421](https://github.com/netdata/netdata/issues/5421))
- Show streamed servers even for users that are not signed in! #5482 ([#5519](https://github.com/netdata/netdata/issues/5519))
- Introduce stable installation channel ([#5487](https://github.com/netdata/netdata/issues/5487))
- Release 
- Retry release

## [1.12.1] - 2019-02-21

### Merged Pull Requests:

- Fix FreeBSD plugin Codacy issues ([#5338](https://github.com/netdata/netdata/issues/5338))
- Codacy js fixes ([#5337](https://github.com/netdata/netdata/issues/5337))
- Add go.d documentation and modify collector menu ([#5215](https://github.com/netdata/netdata/issues/5215))
- More robust GH release creation
- Fix cgroups Codacy issue ([#5340](https://github.com/netdata/netdata/issues/5340))
- Fix AC_CHECK_LIB to work correctly with cups library ([#5349](https://github.com/netdata/netdata/issues/5349))
- Provide more precise uninstall instructions ([#5347](https://github.com/netdata/netdata/issues/5347))
- Fix replacement of whitespace for versions retrieved from github ([#5355](https://github.com/netdata/netdata/issues/5355))
- Fix warning condition for mem.available ([#5353](https://github.com/netdata/netdata/issues/5353))
- Add link to writing a new module in example readme ([#5348](https://github.com/netdata/netdata/issues/5348))
- Cups.plugin: Support older versions ([#5350](https://github.com/netdata/netdata/issues/5350))
- Fix: wget log spam in headless mode ([#5359](https://github.com/netdata/netdata/issues/5359))
- Add message queue statistics ([#5115](https://github.com/netdata/netdata/issues/5115))
- Add cgroup cpu and memory limits and alarms ([#5172](https://github.com/netdata/netdata/issues/5172))
- Added missing BuildRequires for autoconf, automake ([#5363](https://github.com/netdata/netdata/issues/5363))
- Lint alarm notify ([#5164](https://github.com/netdata/netdata/issues/5164))
- Automatic shellchecking on .sh.in scripts ([#5165](https://github.com/netdata/netdata/issues/5165))
- Split nfacct plugin into separate process ([#5361](https://github.com/netdata/netdata/issues/5361))
- Add support for tera-byte size for Linux bcache. ([#4719](https://github.com/netdata/netdata/issues/4719)) ([#5373](https://github.com/netdata/netdata/issues/5373))
- Don't send host/port in to anonymous stats in fatal of STREAM_RECEIVER
- Localization support in HTML docs, simplification of checklinks.sh ([#5342](https://github.com/netdata/netdata/issues/5342))
- Cleanup updater script and no `/opt` usage ([#5218](https://github.com/netdata/netdata/issues/5218))
- Correct Installation link in updating doc ([#5380](https://github.com/netdata/netdata/issues/5380))
- Render MyNetdata menu after fetching hosts info #5370 ([#5371](https://github.com/netdata/netdata/issues/5371))
- Add documentation for network interfaces ([#5381](https://github.com/netdata/netdata/issues/5381))
- Update CODEOWNERS ([#5389](https://github.com/netdata/netdata/issues/5389))
- Fix ceph.chart.py for Python3 ([#5396](https://github.com/netdata/netdata/issues/5396))
- Python module sensors fix ([#5406](https://github.com/netdata/netdata/issues/5406))
- Copy version file to GCS upload directory ([#5408](https://github.com/netdata/netdata/issues/5408))
- Refactored static kickstart script ([#5397](https://github.com/netdata/netdata/issues/5397))
- Use netnsid for detecting cgroup networks; fixes #5383 ([#5413](https://github.com/netdata/netdata/issues/5413))
- When running a binary with CLOCK_BOOTTIME defined on a system with a linux ([#5415](https://github.com/netdata/netdata/issues/5415))
- Remove redudant pipes ([#5417](https://github.com/netdata/netdata/issues/5417))
- Uninstall instruction improvements ([#5414](https://github.com/netdata/netdata/issues/5414))
- Add driver-type option to the freeipmi plugin ([#5384](https://github.com/netdata/netdata/issues/5384))
- Improve configure.ac mnl and netfilter_acc checks for static builds ([#5424](https://github.com/netdata/netdata/issues/5424))
- Spec: fixed template issue for netdata source. ([#5427](https://github.com/netdata/netdata/issues/5427))
- Fix #5430 - LogService._get_raw_data under python3 fails on undecodable data ([#5431](https://github.com/netdata/netdata/issues/5431))
- Fix curl download ([#5439](https://github.com/netdata/netdata/issues/5439))
- Correct duplicate flag enum in health.h ([#5441](https://github.com/netdata/netdata/issues/5441))
- Change email address for automated commits ([#5444](https://github.com/netdata/netdata/issues/5444))
- Update README.md - add news for 1.12 ([#5437](https://github.com/netdata/netdata/issues/5437))
- Remove v from Server header ([#5440](https://github.com/netdata/netdata/issues/5440))
- Cpuidle handle newlines in names ([#5425](https://github.com/netdata/netdata/issues/5425))
- Correct version check in UI ([#5429](https://github.com/netdata/netdata/issues/5429))
- Delay raising the linux power supply alarm, to prevent errors during netdata startup ([#5447](https://github.com/netdata/netdata/issues/5447))
- Apcupsd - Treat ONBATT status the same as ONLINE ([#5435](https://github.com/netdata/netdata/issues/5435))
- Fix Coverity defects ([#5394](https://github.com/netdata/netdata/issues/5394))
- Fix SEGV by removing free of vars of charts that do not exist ([#5455](https://github.com/netdata/netdata/issues/5455))
- Installer: include go.d.plugin version v0.1.0 ([#5446](https://github.com/netdata/netdata/issues/5446))
- Update md5sums on kickstart scripts README.md ([#5456](https://github.com/netdata/netdata/issues/5456))
- Add tor to the default app groups ([#5434](https://github.com/netdata/netdata/issues/5434))
- Update icon in demosites.html ([#5458](https://github.com/netdata/netdata/issues/5458))
- Handle cases when go.d plugin can't be downloaded (no connection to internet) ([#5457](https://github.com/netdata/netdata/issues/5457))
- Fix #5426 ([#5448](https://github.com/netdata/netdata/issues/5448))
- Mention installer option `--disable-go` ([#5461](https://github.com/netdata/netdata/issues/5461))
- Fix timer crash during exit ([#5464](https://github.com/netdata/netdata/issues/5464))
- Revert #5457 and test if files exist after installation ([#5460](https://github.com/netdata/netdata/issues/5460))

## [1.12.0] - 2019-02-06

### Merged Pull Requests:

- Do not build images in parallel due to too limited CI resources
- Correct link to Rest API ([#5193](https://github.com/netdata/netdata/issues/5193))
- Fix path to updater file ([#5209](https://github.com/netdata/netdata/issues/5209))
- Add go.d.plugin to apps_groups.conf ([#5214](https://github.com/netdata/netdata/issues/5214))
- Update bug_report.md
- Bug fix for netdata behind authenticated proxies ([#5216](https://github.com/netdata/netdata/issues/5216))
- Python dockerd module: check version ([#5217](https://github.com/netdata/netdata/issues/5217))
- Update netdata-installer.sh
- Fix md5sum ([#5230](https://github.com/netdata/netdata/issues/5230))
- Update kickstart md5sum
- Fix nightly builds and cron autoupdater ([#5232](https://github.com/netdata/netdata/issues/5232))
- Fix check for install-required-packages.sh ([#5241](https://github.com/netdata/netdata/issues/5241))
- Update kickstart.sh md5sum in docs ([#5242](https://github.com/netdata/netdata/issues/5242))
- Pass correct options to the configure command ([#5244](https://github.com/netdata/netdata/issues/5244))
- Plugins.d doc: Remove empty similar headline ([#5245](https://github.com/netdata/netdata/issues/5245))
- Go through whole nightly before quiting ([#5219](https://github.com/netdata/netdata/issues/5219))
- Remove v before the version ([#5223](https://github.com/netdata/netdata/issues/5223))
- Alarm-notify: Add Prowl integration for iOS users. ([#5132](https://github.com/netdata/netdata/issues/5132))
- Mysql charts fix ([#5250](https://github.com/netdata/netdata/issues/5250))
- Instruct users to use edit-config ([#5222](https://github.com/netdata/netdata/issues/5222))
- Update info on plugins ([#5101](https://github.com/netdata/netdata/issues/5101))
- Check version.txt in correct directory and fix link to docs ([#5256](https://github.com/netdata/netdata/issues/5256))
- Don't show zero charts for ZFS filesystem ([#5211](https://github.com/netdata/netdata/issues/5211))
- Update alarm-notify.sh.in ([#5263](https://github.com/netdata/netdata/issues/5263))
- Fix typo in docs/configuration-guide.md ([#5259](https://github.com/netdata/netdata/issues/5259))
- Fix invalid json returned after 'prefix': 'osd df' ([#5260](https://github.com/netdata/netdata/issues/5260))
- SUSE addition ([#5258](https://github.com/netdata/netdata/issues/5258))
- Always run make clean before make ([#5265](https://github.com/netdata/netdata/issues/5265))
- Improvements to QoS (tc) documentation ([#5221](https://github.com/netdata/netdata/issues/5221))
- Anonymous statistics ([#5113](https://github.com/netdata/netdata/issues/5113))
- Fix incorrect parsing of ACLs ([#5275](https://github.com/netdata/netdata/issues/5275))
- Netdata update instructions after recent changes ([#5277](https://github.com/netdata/netdata/issues/5277))
- Cloud Sign-In ([#5095](https://github.com/netdata/netdata/issues/5095))
- Correct auto-updater to netdata-updater ([#5281](https://github.com/netdata/netdata/issues/5281))
- Kickstart.sh: remove updater symlink ([#5276](https://github.com/netdata/netdata/issues/5276))
- Additional UI fixes ([#5284](https://github.com/netdata/netdata/issues/5284))
- GUI Update check - use version instead of commit ([#5283](https://github.com/netdata/netdata/issues/5283))
- Updated cncf landscape url ([#5288](https://github.com/netdata/netdata/issues/5288))
- Add errno to fatal event for statistics ([#5291](https://github.com/netdata/netdata/issues/5291))
- Add back the symlink netdata-latest.gz.run ([#5286](https://github.com/netdata/netdata/issues/5286))
- Correct info on what kickstart.sh does ([#5292](https://github.com/netdata/netdata/issues/5292))
- Kickstart: noexec detection ([#5293](https://github.com/netdata/netdata/issues/5293))
- Minor updates to anonymous statistics ([#5295](https://github.com/netdata/netdata/issues/5295))
- Minor fixes ([#5294](https://github.com/netdata/netdata/issues/5294))
- Improve apps grouping config and docs ([#5269](https://github.com/netdata/netdata/issues/5269))
- Varnish module: add instance_name option ([#5264](https://github.com/netdata/netdata/issues/5264))
- Registrypath is not used and causes issues in slack ([#5302](https://github.com/netdata/netdata/issues/5302))
- Minor fix ([#5307](https://github.com/netdata/netdata/issues/5307))
- Fix 5226 ([#5312](https://github.com/netdata/netdata/issues/5312))
- Remove warnings for send_statistics ([#5316](https://github.com/netdata/netdata/issues/5316))
- Clarify that uninstaller.sh needs to be downloaded ([#5315](https://github.com/netdata/netdata/issues/5315))
- CUPS plugin ([#5188](https://github.com/netdata/netdata/issues/5188))
- Fix compilation of cups.plugin; fixes #5324 ([#5325](https://github.com/netdata/netdata/issues/5325))
- Install go.d.plugin ([#5199](https://github.com/netdata/netdata/issues/5199))
- Update .codacy.yml
- Remove deprecated API call ([#5326](https://github.com/netdata/netdata/issues/5326))
- Global NETDATA for linter ([#5329](https://github.com/netdata/netdata/issues/5329))
- Remove codacy warnings from sma_webbox ([#5330](https://github.com/netdata/netdata/issues/5330))
- Fix some python codacy errors ([#5331](https://github.com/netdata/netdata/issues/5331))
- Remove unused var ([#5332](https://github.com/netdata/netdata/issues/5332))
- Add global comments to js for Codacy ([#5335](https://github.com/netdata/netdata/issues/5335))
- Fix Codacy issues for FreeBSD plugin ([#5334](https://github.com/netdata/netdata/issues/5334))
- Allow user to override the default behavior for read-only mounts ([#5327](https://github.com/netdata/netdata/issues/5327))
- [netdata minor release]

## [1.12.0-rc3] - 2019-01-17

### Merged Pull Requests:

- Update tagger.sh
- Add variables to alarm-notify.sh to show number of warning and critical alarms, evaluated expression and expression variable values. Use them in the email notifications ([#5096](https://github.com/netdata/netdata/issues/5096))
- Do not report stale metrics to prometheus; fixes #5064 ([#5084](https://github.com/netdata/netdata/issues/5084))
- Generate a configure script for RPM build ([#4570](https://github.com/netdata/netdata/issues/4570)) ([#4571](https://github.com/netdata/netdata/issues/4571))
- Unify versioning ([#5051](https://github.com/netdata/netdata/issues/5051))
- Do not publish artifacts on RC tags ([#5114](https://github.com/netdata/netdata/issues/5114))
- Add version file and force git describe to always create a version ([#5119](https://github.com/netdata/netdata/issues/5119))
- Update Charts.md ([#5124](https://github.com/netdata/netdata/issues/5124))
- Web-site content; why-netdata content ([#5097](https://github.com/netdata/netdata/issues/5097))
- Clarify backend modes of operation ([#5116](https://github.com/netdata/netdata/issues/5116))
- Better artifacts uploading ([#5130](https://github.com/netdata/netdata/issues/5130))
- Change ownership of .gitignore ([#5131](https://github.com/netdata/netdata/issues/5131))
- Update CODEOWNERS
- Exclude 'docs' directory from build system ([#5126](https://github.com/netdata/netdata/issues/5126))
- Don't use disk model as dim name ([#5140](https://github.com/netdata/netdata/issues/5140))
- Go_expavar fix: don't check for duplicate expvars ([#5141](https://github.com/netdata/netdata/issues/5141))
- Scramble packages in docker images with polymorphic linux ([#5137](https://github.com/netdata/netdata/issues/5137))
- Rabbitmq: api/nodes requests fix ([#5142](https://github.com/netdata/netdata/issues/5142))
- Add option to opt-out from telemetry program ([#5138](https://github.com/netdata/netdata/issues/5138))
- Temporary disable OSX builds ([#5148](https://github.com/netdata/netdata/issues/5148))
- Test building docker container on every PR ([#5145](https://github.com/netdata/netdata/issues/5145))
- Add vtnet interface name into the list of interfaces which represent ([#5149](https://github.com/netdata/netdata/issues/5149))
- Fix typo in plugins.d/README.md ([#5150](https://github.com/netdata/netdata/issues/5150))
- Correct SNMP module name in plugin error handling ([#5153](https://github.com/netdata/netdata/issues/5153))
- Fix cached memory calculation ([#5151](https://github.com/netdata/netdata/issues/5151))
- Better artifacts uploading; remove build hacks ([#5134](https://github.com/netdata/netdata/issues/5134))
- Nightly build only when sth changed ([#5168](https://github.com/netdata/netdata/issues/5168))
- Lint cgroup name.sh.in ([#5162](https://github.com/netdata/netdata/issues/5162))
- Lint tc-qos-helper.sh.in ([#5163](https://github.com/netdata/netdata/issues/5163))
- Change how the ip address and port are logged in socket.c ([#5166](https://github.com/netdata/netdata/issues/5166))
- Updated Polyverse reinstall commands in Dockerfile ([#5173](https://github.com/netdata/netdata/issues/5173))
- Update Makefile.am
- Fix for fireqos classname not showing, close #5171 ([#5176](https://github.com/netdata/netdata/issues/5176))
- Port ACLs, Management API and Health commands ([#4969](https://github.com/netdata/netdata/issues/4969))
- GCS-based updater ([#5174](https://github.com/netdata/netdata/issues/5174))
- Fix for unix sockets after addition of port ACLs ([#5184](https://github.com/netdata/netdata/issues/5184))
- Self-contained uninstaller ([#5121](https://github.com/netdata/netdata/issues/5121))
- Remove double 'afraid to' in CONTRIBUTING.md ([#5189](https://github.com/netdata/netdata/issues/5189))
- Add missing modules to python.d.conf ([#5194](https://github.com/netdata/netdata/issues/5194))
- Update bug_report.md ([#5205](https://github.com/netdata/netdata/issues/5205))
- Use tarballs from GCS in kickstart.sh ([#5185](https://github.com/netdata/netdata/issues/5185))
- Allow less verbose container image build ([#5187](https://github.com/netdata/netdata/issues/5187))

## [1.12.0-rc2] - 2019-01-03

### Merged Pull Requests:

- Don't care about artifacts in RC releases
- Change number of days needed by issue to go stale ([#5043](https://github.com/netdata/netdata/issues/5043))
- Apcupsd add check for UPS online ([#5037](https://github.com/netdata/netdata/issues/5037))
- New option clear_alarm_always ([#5050](https://github.com/netdata/netdata/issues/5050))
- Fixed typo ([#5054](https://github.com/netdata/netdata/issues/5054))
- Add warning for offset in Counter64 metrics ([#5032](https://github.com/netdata/netdata/issues/5032))
- Gracefully ignore the offset if the value is not a number ([#5040](https://github.com/netdata/netdata/issues/5040))
- Add other web servers to proxy instructions ([#5027](https://github.com/netdata/netdata/issues/5027))
- Fix coverity issues ([#5061](https://github.com/netdata/netdata/issues/5061))
- Disable cpuidle module if schedstat file is missing ([#5059](https://github.com/netdata/netdata/issues/5059))
- Fix process statistics collection for FreeBSD in apps.plugin ([#5038](https://github.com/netdata/netdata/issues/5038))
- Fix cpuidle statistics in containers ([#5065](https://github.com/netdata/netdata/issues/5065))
- Add how to add new alarm ([#5069](https://github.com/netdata/netdata/issues/5069))
- Add systemd pattern list parameter to the documentation ([#5077](https://github.com/netdata/netdata/issues/5077))
- Fix update instructions URL in frontend ([#5076](https://github.com/netdata/netdata/issues/5076))
- Smartd_log: skip non-CSVs early ([#5081](https://github.com/netdata/netdata/issues/5081))
- Fix IEC units in bash modules ([#5049](https://github.com/netdata/netdata/issues/5049))
- Improve instructions on how to view the slave UI ([#5083](https://github.com/netdata/netdata/issues/5083))
- Dashboard grammar change ([#5080](https://github.com/netdata/netdata/issues/5080))
- Removed c3, morris and raphael JS libraries ([#5086](https://github.com/netdata/netdata/issues/5086)) ([#5088](https://github.com/netdata/netdata/issues/5088))
- Fix web site install link ([#5092](https://github.com/netdata/netdata/issues/5092))
- Move makeself ([#4688](https://github.com/netdata/netdata/issues/4688))
- Move kickstart files ([#5011](https://github.com/netdata/netdata/issues/5011))
- Copy updater script instead of linking it ([#5010](https://github.com/netdata/netdata/issues/5010))
- UrlService dont respect Retry-After header by default ([#5082](https://github.com/netdata/netdata/issues/5082))
- Postgres : fix WAL query ([#5105](https://github.com/netdata/netdata/issues/5105))
- Correct memory usage statement in memory=none ([#5100](https://github.com/netdata/netdata/issues/5100))
- Fix permissions for log files when building rpms ([#5099](https://github.com/netdata/netdata/issues/5099))

## [1.12.0-rc1] - 2018-12-19

### Merged Pull Requests:

- Removed vlvkobal as a codeowner of web/gui ([#4929](https://github.com/netdata/netdata/issues/4929))
- Update code owners ([#4930](https://github.com/netdata/netdata/issues/4930))
- Use proper request types and urls to update labels ([#4931](https://github.com/netdata/netdata/issues/4931))
- Cleaner labeler code ([#4933](https://github.com/netdata/netdata/issues/4933))
- Config docs improvements ([#4918](https://github.com/netdata/netdata/issues/4918))
- Python.d.plugin update ([#4936](https://github.com/netdata/netdata/issues/4936))
- Update README.md ([#4937](https://github.com/netdata/netdata/issues/4937))
- Update Performance.md ([#4935](https://github.com/netdata/netdata/issues/4935))
- Ga ([#4938](https://github.com/netdata/netdata/issues/4938))
- Add doc before path to GA in static site ([#4940](https://github.com/netdata/netdata/issues/4940))
- Update GA in demosites.html ([#4946](https://github.com/netdata/netdata/issues/4946))
- Show demosite/host in GA ([#4947](https://github.com/netdata/netdata/issues/4947))
- Temporary workaround for #4945 ([#4951](https://github.com/netdata/netdata/issues/4951))
- Add header to SMA webbox readme ([#4942](https://github.com/netdata/netdata/issues/4942))
- Add cakrit to health codeowners ([#4953](https://github.com/netdata/netdata/issues/4953))
- Add support for providing FQDN in alarm notifications. ([#4943](https://github.com/netdata/netdata/issues/4943))
- Dovecot readme and config update for v2.3 ([#4959](https://github.com/netdata/netdata/issues/4959))
- Fix link in streaming hosts list ([#4948](https://github.com/netdata/netdata/issues/4948))
- Introduced IEC-compliant unit abbreviations #4711 ([#4912](https://github.com/netdata/netdata/issues/4912))
- Fix month 'Dec' being detected as IPv6 address in ovpn python.d plugin ([#4970](https://github.com/netdata/netdata/issues/4970))
- Prevent netdata-updater.sh from sending cron report for git stash entries ([#4952](https://github.com/netdata/netdata/issues/4952))
- Allow label modification ([#4949](https://github.com/netdata/netdata/issues/4949))
- Add support for Factorio server monitoring ([#4966](https://github.com/netdata/netdata/issues/4966))
- GCS access key shouldn't be encrypted ([#4976](https://github.com/netdata/netdata/issues/4976))
- Fix mdstat parsing ([#4977](https://github.com/netdata/netdata/issues/4977))
- Add mdstat to CMake configuration ([#4965](https://github.com/netdata/netdata/issues/4965))
- Fix file permissions ([#4974](https://github.com/netdata/netdata/issues/4974))
- Postgres fix: detect servers version and use the right query ([#4944](https://github.com/netdata/netdata/issues/4944))
- Pass cloud_base_url from daemon to web/gui through hello endpoint #4980 ([#4982](https://github.com/netdata/netdata/issues/4982))
- Fix to #4968, custom recipients were not working properly ([#4978](https://github.com/netdata/netdata/issues/4978))
- Move power supply python module to proc plugin ([#4960](https://github.com/netdata/netdata/issues/4960))
- Add support for nonredundant arrays ([#4923](https://github.com/netdata/netdata/issues/4923))
- Typo: `stab_status` -> `stub_status` ([#4984](https://github.com/netdata/netdata/issues/4984))
- Postgres timeouts ([#4988](https://github.com/netdata/netdata/issues/4988))
- Fix crash in mdstat module ([#4992](https://github.com/netdata/netdata/issues/4992))
- Integrate patches from freeipmi and set set paramters ([#4993](https://github.com/netdata/netdata/issues/4993))
- Make units compliant with IEC standard ([#4985](https://github.com/netdata/netdata/issues/4985))
- Allow development build ([#5015](https://github.com/netdata/netdata/issues/5015))
- Try fixing LGTM
- [python] make units compliant with IEC standard  ([#4995](https://github.com/netdata/netdata/issues/4995))
- Add new generation uploading schema ([#5018](https://github.com/netdata/netdata/issues/5018))
- Fix missing method_name: kavenegar ([#5019](https://github.com/netdata/netdata/issues/5019))
- Kavenegar returns 200 ([#5020](https://github.com/netdata/netdata/issues/5020))
- Update cgroup-name.sh.in ([#4991](https://github.com/netdata/netdata/issues/4991))
- Discard empty labels
- Remove debugging statement from labeler
- Use auth when connecting to Github API
- Show a warning if JavaScript is disabled #2422 ([#4999](https://github.com/netdata/netdata/issues/4999))
- Fix location of encrypted file ([#5024](https://github.com/netdata/netdata/issues/5024))
- Non-interactive uninstaller ([#5021](https://github.com/netdata/netdata/issues/5021))
- Remove cross-directory dependency in build system ([#5012](https://github.com/netdata/netdata/issues/5012))
- Update labeler.sh
- Copy artifacts to 'upload/' ([#5036](https://github.com/netdata/netdata/issues/5036))
- Move installer dir under packaging ([#5009](https://github.com/netdata/netdata/issues/5009))
- [netdata release candidate]

## [1.12.0-rc0] - 2018-12-06

### Merged Pull Requests:

- Test integrity of dashboard.js ([#4715](https://github.com/netdata/netdata/issues/4715))
- Strictier use of URL separators; fixes #3253; fixes #4714 ([#4716](https://github.com/netdata/netdata/issues/4716))
- Sanitize headers and htmlstructure ([#4713](https://github.com/netdata/netdata/issues/4713))
- Add more layers to container image ([#4722](https://github.com/netdata/netdata/issues/4722))
- Exempt feature requests from going stale ([#4723](https://github.com/netdata/netdata/issues/4723))
- Correctly apply B unit conversion ([#4724](https://github.com/netdata/netdata/issues/4724))
- Better changelog generation when releasing new version ([#4728](https://github.com/netdata/netdata/issues/4728))
- Docker: correct invalid syntax ([#4738](https://github.com/netdata/netdata/issues/4738))
- Make the whole title area clickable,  closes #4721 ([#4733](https://github.com/netdata/netdata/issues/4733))
- Updated installation page, added getting-started ([#4734](https://github.com/netdata/netdata/issues/4734))
- Make Getting Started just a top level link ([#4740](https://github.com/netdata/netdata/issues/4740))
- Rename `doc` to `docs` and move `htmldoc` ([#4741](https://github.com/netdata/netdata/issues/4741))
- Put back the obsolete bash module readmes ([#4742](https://github.com/netdata/netdata/issues/4742))
- Python.d: use real time for calc sinceLast ([#4720](https://github.com/netdata/netdata/issues/4720))
- Lint all shell collectors code ([#4690](https://github.com/netdata/netdata/issues/4690))
- Update codeowners file ([#4750](https://github.com/netdata/netdata/issues/4750))
- Docs point to docs.netdata.cloud instead of wiki. Correct padding-bot… ([#4747](https://github.com/netdata/netdata/issues/4747))
- Move build Dockerfiles to external repo ([#4749](https://github.com/netdata/netdata/issues/4749))
- Use var to make NETDATA variable global ([#4752](https://github.com/netdata/netdata/issues/4752))
- Sensors: don't ignore 0 RPM funs on start ([#4753](https://github.com/netdata/netdata/issues/4753))
- Mongodb: readme update ([#4754](https://github.com/netdata/netdata/issues/4754))
- Create better issue and PR templates ([#4758](https://github.com/netdata/netdata/issues/4758))
- General issue template ([#4764](https://github.com/netdata/netdata/issues/4764))
- Web_log: add alarm on unmatched lines ([#4757](https://github.com/netdata/netdata/issues/4757))
- Bugfix: query engine resampling duration ([#4759](https://github.com/netdata/netdata/issues/4759))
- Remove rolling version suffix ([#4748](https://github.com/netdata/netdata/issues/4748))
- Improve support for slack recipients ([#4765](https://github.com/netdata/netdata/issues/4765))
- Fail2ban fix: add 'Restore Ban' action ([#4772](https://github.com/netdata/netdata/issues/4772))
- Buildhtml.sh should exit with 1 if anything fails ([#4773](https://github.com/netdata/netdata/issues/4773))
- Fix typo in "Github Star" documentation ([#4776](https://github.com/netdata/netdata/issues/4776))
- Upload artifacts to gcs ([#4744](https://github.com/netdata/netdata/issues/4744))
- Added a few more debugging instructions for notifications ([#4774](https://github.com/netdata/netdata/issues/4774))
- Generalize the recipient finding logic and reduce the boilerplate code. ([#3960](https://github.com/netdata/netdata/issues/3960))
- Update README.md for release 1.11.1 ([#4777](https://github.com/netdata/netdata/issues/4777))
- Cleanup docker packaging and contrib ([#4627](https://github.com/netdata/netdata/issues/4627))
- Contributing.md updates ([#4767](https://github.com/netdata/netdata/issues/4767))
- Documentation TOC bug fix ([#4787](https://github.com/netdata/netdata/issues/4787))
- Automatic labeling of new features ([#4792](https://github.com/netdata/netdata/issues/4792))
- Small content change to the netdata-installer.sh ([#4790](https://github.com/netdata/netdata/issues/4790))
- Better updater ([#4558](https://github.com/netdata/netdata/issues/4558))
- Netdata-security doc corrections ([#4786](https://github.com/netdata/netdata/issues/4786))
- Auto-label PRs and minor cleanup ([#4795](https://github.com/netdata/netdata/issues/4795))
- RPM spec and patches for sles 11 ([#3708](https://github.com/netdata/netdata/issues/3708))
- Add api/v1/info endpoint ([#4770](https://github.com/netdata/netdata/issues/4770))
- Added Legal section to documentation, added missing link for apps.plugin ([#4797](https://github.com/netdata/netdata/issues/4797))
- Add debug instructions for python modules ([#4799](https://github.com/netdata/netdata/issues/4799))
- Add cookie consent javascript to docs ([#4801](https://github.com/netdata/netdata/issues/4801))
- Improve SYNPROXY documentation ([#4800](https://github.com/netdata/netdata/issues/4800))
- Minor updates in htmldoc ([#4802](https://github.com/netdata/netdata/issues/4802))
- Anonymize IPs in README.md Google Analytics ([#4803](https://github.com/netdata/netdata/issues/4803))
- Update CONTRIBUTING.md ([#4805](https://github.com/netdata/netdata/issues/4805))
- Add info from PR 208 ([#4804](https://github.com/netdata/netdata/issues/4804))
- Add api/v1/info endpoint to swagger ([#4807](https://github.com/netdata/netdata/issues/4807))
- Nvidia_smi: handle `N/A` values ([#4893](https://github.com/netdata/netdata/issues/4893))
- Added more debug outpput to freeipmi ([#4894](https://github.com/netdata/netdata/issues/4894))
- Added debug statements when loading health config files ([#4896](https://github.com/netdata/netdata/issues/4896))
- Added more debug for #4809 ([#4897](https://github.com/netdata/netdata/issues/4897))
- Treat DT_UNKNOWN files as regular files ([#4898](https://github.com/netdata/netdata/issues/4898))
- Added info on health configuration, with a separate page for Charts, Dimensions, Alarms, Contexts ([#4895](https://github.com/netdata/netdata/issues/4895))
- Fix(pagerduty): Use cURL instead of PagerDuty agent to send alarms. ([#4694](https://github.com/netdata/netdata/issues/4694))
- Postgres module: locks count fix ([#4901](https://github.com/netdata/netdata/issues/4901))
- Do not use protected variable name in updater script ([#4902](https://github.com/netdata/netdata/issues/4902))
- Do not update CI system ([#4907](https://github.com/netdata/netdata/issues/4907))
- Smartd_log: ata 194 attr fix ([#4908](https://github.com/netdata/netdata/issues/4908))
- Move cpuidle python module to proc plugin ([#4635](https://github.com/netdata/netdata/issues/4635))
- Lifecycle test ([#4789](https://github.com/netdata/netdata/issues/4789))
- Fix info api method compilation warnings ([#4911](https://github.com/netdata/netdata/issues/4911))
- Don't use IE11 incompatible for-const #4710 ([#4906](https://github.com/netdata/netdata/issues/4906))
- Update python.d readme ([#4905](https://github.com/netdata/netdata/issues/4905))
- Improve docker installation readme, docs navbar fix ([#4914](https://github.com/netdata/netdata/issues/4914))
- Better labeling ([#4915](https://github.com/netdata/netdata/issues/4915))
- RabbitMQ chart for message rates should be "line" ([#4916](https://github.com/netdata/netdata/issues/4916))
- Use the new logo in the UI ([#4913](https://github.com/netdata/netdata/issues/4913))
- Update .travis.yml
- Move mdstat python module to proc plugin ([#4768](https://github.com/netdata/netdata/issues/4768))
- Send all git log msg to fd3 ([#4922](https://github.com/netdata/netdata/issues/4922))
- Fix symbolic link file detection in etc ([#4926](https://github.com/netdata/netdata/issues/4926))
- Use relative path for logo ([#4927](https://github.com/netdata/netdata/issues/4927))
- Run shfmt on CI scripts ([#4928](https://github.com/netdata/netdata/issues/4928))

## [1.11.1] - 2018-11-22

### Merged Pull Requests:

- After release cleanup ([#4552](https://github.com/netdata/netdata/issues/4552))
- Minor README file updates ([#4548](https://github.com/netdata/netdata/issues/4548))
- During release create changelog after tagging ([#4553](https://github.com/netdata/netdata/issues/4553))
- Edit-config: Better support for custom editors. ([#4551](https://github.com/netdata/netdata/issues/4551))
- Switch e-mail threading to be enabled by default. ([#3780](https://github.com/netdata/netdata/issues/3780))
- Decouple nightly cron jobs from packaging stage ([#4559](https://github.com/netdata/netdata/issues/4559))
- Incremental overflows should not show zeros values ([#4538](https://github.com/netdata/netdata/issues/4538))
- Add tor python module ([#4546](https://github.com/netdata/netdata/issues/4546))
- Smartd_log refactor plus SCSI support ([#4523](https://github.com/netdata/netdata/issues/4523))
- Clarify application configuration and fix broken link ([#4554](https://github.com/netdata/netdata/issues/4554))
- Netdata-openrc: Move check from depends() function to start_pre() ([#4575](https://github.com/netdata/netdata/issues/4575))
- Fix badges link that leads to 404. ([#4569](https://github.com/netdata/netdata/issues/4569))
- Add diagrams for internal data structures of netdata ([#4567](https://github.com/netdata/netdata/issues/4567))
- Minor documentation improvements ([#4566](https://github.com/netdata/netdata/issues/4566))
- Refactoring dashboard.js, splitting monolithic file into multiple source files. ([#4496](https://github.com/netdata/netdata/issues/4496))
- Split js 2 ([#4581](https://github.com/netdata/netdata/issues/4581))
- Smartd_log: py2 compatibility fix ([#4584](https://github.com/netdata/netdata/issues/4584))
- Cleanup index.html ([#4587](https://github.com/netdata/netdata/issues/4587))
- Update links to badges documentation. ([#4588](https://github.com/netdata/netdata/issues/4588))
- Fixed max interface speed calculation ([#4594](https://github.com/netdata/netdata/issues/4594))
- Fixed conntrack_max alarm ([#4595](https://github.com/netdata/netdata/issues/4595))
- Alerta.io notification improvements ([#4576](https://github.com/netdata/netdata/issues/4576))
- New readme ([#4596](https://github.com/netdata/netdata/issues/4596))
- Updated readme ([#4599](https://github.com/netdata/netdata/issues/4599))
- Updated readme ([#4600](https://github.com/netdata/netdata/issues/4600))
- Updated readme ([#4604](https://github.com/netdata/netdata/issues/4604))
- Update readme ([#4605](https://github.com/netdata/netdata/issues/4605))
- Updated readme ([#4606](https://github.com/netdata/netdata/issues/4606))
- Another Readme Update ([#4612](https://github.com/netdata/netdata/issues/4612))
- Updated video ([#4620](https://github.com/netdata/netdata/issues/4620))
- Nvidia_smi: init version added ([#4589](https://github.com/netdata/netdata/issues/4589))
- Bad text in example config ([#4618](https://github.com/netdata/netdata/issues/4618))
- Fix spelling mistake in dashboard_info.js ([#4601](https://github.com/netdata/netdata/issues/4601))
- Fixed tc-helper plugin broken link ([#4617](https://github.com/netdata/netdata/issues/4617))
- Fixes and cleanup in release pipeline ([#4625](https://github.com/netdata/netdata/issues/4625))
- Issue 4582 (Show alternate urls in my-netdata menu) ([#4590](https://github.com/netdata/netdata/issues/4590))
- Htmldoc ([#4607](https://github.com/netdata/netdata/issues/4607))
- Update README.md ([#4629](https://github.com/netdata/netdata/issues/4629))
- Added Dygraph and EasyPieChart info to README.md ([#4630](https://github.com/netdata/netdata/issues/4630))
- Fix readme ([#4631](https://github.com/netdata/netdata/issues/4631))
- Firehol -> netdata ([#4632](https://github.com/netdata/netdata/issues/4632))
- Revert to wiki version with fixed links ([#4638](https://github.com/netdata/netdata/issues/4638))
- Fix documentation in beanstalk.conf. ([#4639](https://github.com/netdata/netdata/issues/4639))
- Add more charts ([#4640](https://github.com/netdata/netdata/issues/4640))
- Replace wiki links in backends WALKTHROUGH.md ([#4648](https://github.com/netdata/netdata/issues/4648))
- Fix custom charts links ([#4646](https://github.com/netdata/netdata/issues/4646))
- Replace link to creating badges ([#4644](https://github.com/netdata/netdata/issues/4644))
- Configuration readme links ([#4642](https://github.com/netdata/netdata/issues/4642))
- Replace Anti-DDoS demo site in proc plugin README ([#4647](https://github.com/netdata/netdata/issues/4647))
- Add Nim back to Third-Party-Plugins.md ([#4649](https://github.com/netdata/netdata/issues/4649))
- Update functions.sh ([#4643](https://github.com/netdata/netdata/issues/4643))
- Minor cleanup of main.js ([#4634](https://github.com/netdata/netdata/issues/4634))
- Sensors module fix ([#4651](https://github.com/netdata/netdata/issues/4651))
- Update README.md ([#4652](https://github.com/netdata/netdata/issues/4652))
- Properly parse network interface names with colon on them ([#4653](https://github.com/netdata/netdata/issues/4653))
- Update README.md ([#4654](https://github.com/netdata/netdata/issues/4654))
- Update README.md ([#4655](https://github.com/netdata/netdata/issues/4655))
- Added new branding material #4598 ([#4656](https://github.com/netdata/netdata/issues/4656))
- Openldap monitoring plugin added ([#4513](https://github.com/netdata/netdata/issues/4513))
- Fix changelog path, add all README.md files to Debian package doc ([#4657](https://github.com/netdata/netdata/issues/4657))
- Move cpufreq python module to proc plugin ([#4562](https://github.com/netdata/netdata/issues/4562))
- Update README.md ([#4663](https://github.com/netdata/netdata/issues/4663))
- Update Doc links for adding charts and alarms in sidebar. Isuue #4650 ([#4669](https://github.com/netdata/netdata/issues/4669))
- Update lm_sensors and catch specific errors. ([#4667](https://github.com/netdata/netdata/issues/4667))
- Fix typo in README.md ([#4665](https://github.com/netdata/netdata/issues/4665))
- Updates in various READMEs while testing the link checker ([#4671](https://github.com/netdata/netdata/issues/4671))
- Update README.md ([#4674](https://github.com/netdata/netdata/issues/4674))
- Update README.md ([#4683](https://github.com/netdata/netdata/issues/4683))
- Clone full git history for changelog generation ([#4681](https://github.com/netdata/netdata/issues/4681))
- Enable issue closing with stale bot ([#4686](https://github.com/netdata/netdata/issues/4686))
- Allign code ownership ([#4682](https://github.com/netdata/netdata/issues/4682))
- Fix typo and py2 compatibility issue. ([#4697](https://github.com/netdata/netdata/issues/4697))
- Wiki Link Updates ([#4699](https://github.com/netdata/netdata/issues/4699))
- Fix broken links ([#4700](https://github.com/netdata/netdata/issues/4700))
- Add missing quote to tc-qos-helper.sh.in ([#4703](https://github.com/netdata/netdata/issues/4703))
- Update installer/README.md ([#4689](https://github.com/netdata/netdata/issues/4689))
- Documentation links sanity checker ([#4701](https://github.com/netdata/netdata/issues/4701))
- Add CPU section to proc plugin documentation ([#4704](https://github.com/netdata/netdata/issues/4704))
- Cleanup of web/gui footer ([#4709](https://github.com/netdata/netdata/issues/4709))
- Added byte unit scaling ([#4707](https://github.com/netdata/netdata/issues/4707))
- Add option to create release candidates ([#4706](https://github.com/netdata/netdata/issues/4706))
- Remove left over code ([#4662](https://github.com/netdata/netdata/issues/4662))
- Move changelog generation to the end in release pipeline ([#4712](https://github.com/netdata/netdata/issues/4712))

## [1.11.0] - 2018-11-02

### Merged Pull Requests:

- Post release 1.10.0
- Added 1.10 release to readme
- More info and fixed typo
- Merge pull request #3582 from ktsaou/master
- Minor updates to the BTRFS chart help text.
- Convert Markdown syntax to actual HTML.
- Merge pull request #3584 from Ferroin/patch-1
- Added six.py to LICENSE-REDISTRIBUTED.md and updated the missing licenses on index.html; https://github.com/firehol/netdata/issues/651#issuecomment-376829669
- Merge pull request #3586 from ktsaou/master
- Improved error logging when netdata cannot find fireqos class names
- Merge pull request #3587 from ktsaou/master
- Web file group should not influence the group netdata runs as
- In cgroups, rss includes rss_huge
- Merge pull request #3592 from ktsaou/master
- Fixing typo
- Merge pull request #3597 from rossaffandy/typo
- Update openrc init script
- Merge pull request #3601 from prometheanfire/more-openrc-fixes
- Postgres module: TypeError fix in query_stats_
- Merge pull request #3621 from l2isbad/postgres_fix
- Update copyright year
- Merge pull request #3612 from paulfantom/patch-1
- UrlService self signed certs support fix
- Merge pull request #3631 from l2isbad/UrlService_fix
- Likely/unlikely optimization for statsd flushes
- Statsd histograms mutex narrowed
- Statsd better comments
- Statsd sets should show zero when not collected
- Statsd now tracks useful metrics and loops through them only
- Added chart to track the useful statsd metrics
- Code cleanup
- Merge pull request #3633 from ktsaou/master
- Fix apps.plugin security issues identified by Synacktiv
- Strip control characters from URLs before logged
- Allow debug logs of individual targets to be printed
- Merge pull request #3635 from ktsaou/master
- More security fixes by Synacktiv
- Fix compilation on freebsd
- Fix compilation on freebsd/macos again
- Remove NAME from apps.plugin help
- Cgroup-network does not allow softlinks either
- Restore cgroup-network operation - also netdata reads /proc/1/net/dev when host prefix is defined to allow it read the network interfaces of the host
- Merge pull request #3638 from ktsaou/master
- Web_log: py3 use sys.maxsize instead sys.maxint
- Merge pull request #3640 from l2isbad/web_log_fix
- UrlService: do data decode() in _get_raw_data_with_status
- Merge pull request #3645 from l2isbad/UrlService_fix
- Fix statsd sampling rates calculations; fixes #3630
- Merge pull request #3649 from ktsaou/master
- Install init file on amzn-2018 distro; fixes #3650
- Merge pull request #3653 from ktsaou/master
- Fix 100% cpu when adding dimension in parallel to the same chart
- Merge pull request #3657 from ktsaou/master
- UrlService temp workaround: do not execute decode for str (py2)
- Merge pull request #3661 from l2isbad/UrlService_fix
- Allow netdata to work without fontawesome; fixes #3644
- Allow overwriting subset of icons
- Merge pull request #3659 from ktsaou/master
- FIXED: "alarm-notify.sh test" produces error exit code on success
- Merge pull request #3668 from andvgal/notify-test-exit-code-fix
- Allow hidding each axis on dygraphs; fixes #3654
- Merge pull request #3663 from ktsaou/master
- Use new API.
- Merge pull request #3607 from tancou/master
- Allow hiding dygraph axis - fix broken sparklines
- Merge pull request #3680 from ktsaou/master
- NEW: TLS client and CA certificate support
- Merge pull request #3678 from andvgal/add-client-tls-cert
- Update README.md
- Merge pull request #3673 from obissick/patch-1
- Update .gitignore to ignore `.swp` files created by Vim
- Merge pull request #3671 from Ferroin/patch-1
- Added net.core.netdev_budget_usecs to chart info; #1076
- Increased version
- Merge pull request #3690 from ktsaou/master
- NEW: Puppet Server and Puppet DB basic monitoring
- Updated python.conf.d with puppet plugin
- Puppet: added missing documentation & misc
- Puppet module: minor refactoring & fixes
- Puppet plugin: fixed variable definitions
- Puppet plugin: converted fd_max to variable
- Merge pull request #3679 from andvgal/puppet-status-plugin
- Do not set TCP_NODELAY on unix domain sockets and do not log errors about optional setsockopt() calls; fixes #3682
- Merge pull request #3691 from ktsaou/master
- Added option --disable-x86-sse to netdata-installer.sh; #2909
- Merge pull request #3692 from ktsaou/master
- Install startup script on MacOS; fixes #3684
- Fix for installing macos plist file
- Merge pull request #3694 from ktsaou/master
- Add support for arbitrary date formats for netdata alerts.
- Merge pull request #3702 from Ferroin/update-alert-date-handling
- Added SCTP monitoring; fixes #1218
- Changed SCTP title
- Do not create ipv4 charts with just zero values; fixes #3706
- Sctp sent packets should be negative
- Merge pull request #3705 from ktsaou/master
- Add basic SSL support to SocketService framework.
- Add a plugin for Unbound DNS stats.
- Fix missing ':' pointed out by codeclimate.
- Fix issues pointed out by Codacy
- Various fixes for unbound.chart.py:
- Use bundled YAML parser for unbound plugin.
- Redo SSL configuration for SocketService.
- Further fix SSL configuration for SocketService
- Fix some configuration auto-detection issues.
- Remove string conversion from ssl option fetching.
- Remove unneeded keys() from unbound.chart.conf.
- Copy CHARTS and ORDER instead of just assigning them.
- Try to make Codacy happier.
- Make _check_raw_data() a static method.
- FIx the one spot missed by 51b4ec9.
- Update SocketService TLS config to be consistent with UrlService.
- Fix overzealous conversion of 'SSL" to 'TLS' in previous commit.
- Add Unbound plugin to makefiles.
- Fixed incorrect logging method in SocketService.
- Merge pull request #3670 from Ferroin/unbound-dns
- Add syslog support to alarm-notify.sh.
- Fixed bogus variable name pointed out by Codacy.
- Update syslog support to allow per-role configuration.
- Fix yet another stupid typo pointed out by Codacy...
- Add the chart name to syslog messages.
- Merge pull request #3599 from Ferroin/alarm-logger
- Add a plugin for Spigot Minecraft server stats.
- Fixes for the SpigotMC plugin
- Fixes for the spigotmc plugin:
- Fix auto-reconnect for the spigotmc plugin.
- Changed collection period for spigotmc plugin to 5 seconds.
- Merge branch 'master' into spigotmc
- Merge pull request #3664 from Ferroin/spigotmc
- Fix dashboard_info.js; fixes #3707
- Merge pull request #3712 from ktsaou/master
- Merge pull request #3742 from marulitua/fixing-typo
- Apps.plugin: match browsers and systemd user sessions under X, match the default systemd tree as other
- Fix btrfs over bcache sector size; fixes #3746
- Updated configs signatures
- Merge pull request #3747 from ktsaou/master
- Add runtime for UPS
- Merge pull request #3741 from Shini31/nut
- Openvpn plugin: process also incoming IPv6 connections
- Openvpn plugin: ignore UNDEF clients
- Update very inefficient regex (thanks to @l2isbad in #3734)
- Common Name isn't the first column when using status-version 2/3, see https://github.com/OpenVPN/openvpn/blob/499794596deb16965164b611ff61c8609c6cd08e/src/openvpn/multi.c#L943
- Merge pull request #3734 from vpnable/master
- Fix the new date handling in alarm-notify.sh
- Merge pull request #3724 from Ferroin/alarm-date-fix
- Invalid use of shell -eq with strings; fixes #3733
- Merge pull request #3753 from ktsaou/master
- Enable bash loadable module for sleep when available; fixes #3754
- Use official loadable modules dir
- Remove file if it is not a pipe; prefer read over builtin sleep; fallback to sleep if builtin sleep fails
- Properly stop when builtin sleep is detected
- Rename to mysleep_builtin to conform with the rest of the functions
- Do not attempt to use bash loadable modules on static builds; update bash to 4.4.18 and curl to 7.60.0
- The missing variable definition of the last commit
- Merge pull request #3755 from ktsaou/master
- Web_log.chart squid part: restrict chars in mime-type
- Check mime types against known-good list
- Squid log: match only IP as client address
- Merge pull request #3739 from veksh/fix-squid-weblog-mimetype
- Added bcache cache allocation chart; related to #3504
- Added bcache cache_read_races metric for tracking cache device read failures; related to #3504
- Added bcache alarms
- Updated configs.signatures
- Merge pull request #3762 from ktsaou/master
- Fix memory leak in cgroup-network
- Merge pull request #3763 from ktsaou/master
- Bcache: read priority_stats once every minute; related to #3762
- Merge pull request #3765 from ktsaou/master
- Bcache: disable priority_stats by default
- Bcache: added cache I/O errors
- Merge pull request #3766 from ktsaou/master
- Remove the old obsolete web interface.
- Remove old web interface from make targets.
- Merge pull request #3767 from Ferroin/remove-old-web-interface
- Align db checks with alarm checks to allow chart updates, up to 5 seconds behind present time; #3752
- Merge pull request #3769 from ktsaou/master
- Add the option to thread email notifications.
- Merge pull request #3768 from Ferroin/alarm-email-threading
- Fix uninstaller for MacOS; fixes #2941
- Fixed typo
- Added -p to read
- Added missing escapes to uninstaller user and group checks
- Rename variable x to g; identified by codacy
- Merge pull request #3773 from ktsaou/master
- Bcache io_errors and cache_read_races do not have units; fixes #3766
- Merge pull request #3775 from ktsaou/master
- Added debug code to trace #3752
- Log clock_gettime() errors; #3776
- Merge pull request #3779 from ktsaou/master
- Python.d.plugin: remove unused import (time.time)
- Add monotonic time func for py2 (https://stackoverflow.com/a/1205762)
- SimpleService: use local monotonic time func instead of built-in (py2)
- Add monotonic to makefile
- Python monotonic: use CLOCK_MONOTONIC instead of CLOCK_MONOTONIC_RAW
- Merge pull request #3776 from l2isbad/py2_monotonic_time
- Fix a typo in snmp.conf.md
- Merge pull request #3804 from felixonmars/patch-1
- SPDX License header prep.
- Removed unnessecary COPYING file.
- Clean up trailing spaces in LICENSE-REDISTRIBUTED.md
- Add SPDX-License-Identifier headers to most files.
- Fix Makefile.am to update license file changes.
- Fix src/avl.{c,h} licensing.
- Add a notice about the usage of SPDX license tags.
- Add SPDX license tag for mcrcon redistributed code.
- Add SPDX license tag for `six` redistributed code.
- Add SPDX license tag for clipboard-polyfill.
- Add SPDX license tag for pako redistributed code.
- Add SPDX license tag for lz-string redistributed code.
- Add SPDX license tags to urllib3 redistributed code.
- Add SPDX license tags to pyyaml redistributed code.
- Add SPDX license tag to lm_sensors redistributed code.
- Add SPDX license tag for pixl-xml redistributed code.
- Add SPDX license tags to node-asn1-ber code.
- Add SPDX license tag to node-net-snmp code.
- Add SPDX license tag fo node-extend code.
- Add license for icons.
- Add license tags for fontawesome redistributed data.
- Add SPDX license tag for perfect-scrollbar.
- Added SPDX tag for tableexport jquery plugin.
- Add SPDX tags to bootstrap files and extras.
- Add SPDX tags to bootstrap CSS files missed in the last commit.
- Added SPDX tag to jQuery code.
- Add SPDX license tag to D3 redistributable code.
- Add SPDX license tag to C3 redistributed code.
- Add SPDX license tag for raphael.js
- Added SPDX license tag for morris.js
- Add SPDX license tag for peity jQuery plugin.
- Add SPDX license tag for sparklines jQuery plugin.
- Add SPDX license tag to d3pie.
- Add SPDX license tag for Guage.js
- Add SPDX license tag for Easy Pie Chart jQuery plugin.
- Add SPDX license tag to dygraphs redistributed code.
- Add SPDX tags to a few files that were missed earlier.
- Added SPDX tags to remaining python code.
- Add SPDX tags to most of the rest of the build files.
- Tidied up license formattin to be more consistent with widely used versions.
- Add SPDX license tags for Dockerfiles.
- Add missing licenses to Makefile.am.
- Merge pull request #3772 from Ferroin/licensing-cleanup
- Add rocketchat integration
- Comment fixing
- Indent fixing
- Merge pull request #3777 from Hermsi1337/rocketchat_support
- Litespeed python module added
- Litespeed module conf file added
- Set update_every to 10
- Litespeed: rename is_changed to is_updated
- Add litespeed module to makefiles
- Add litespeed to python.d.conf
- Litespeed: set modification time to 0 on init for DataFile
- Litespeed: save old data between iterations
- Litespeed: add network throughput charts
- Litespeed: use _PER_SEC values instead of TOT_
- Litespeed: add connections charts
- Litespeed: do not check if file was changed on every iteration
- Litespeed: net throughput bytes => bits
- Litespeed: add "Requests In Processing" chart
- Litespeed: add module to python.d readme
- Litespeed: user "/tmp/lshttpd/" as default "path"
- Litespeed: update python.d readme
- Add netdata to nobody group (litespeed plugin)
- Merge pull request #3782 from l2isbad/litespeed_module
- Added mcrcon python module to Makefile.am.
- Merge pull request #3785 from Ferroin/mcrcon-makefile-fix
- Add per-thread stats reporting for the unbound plugin.
- Fix chart ordering issues for per-thread charts.
- Fix dashboard_info.js.
- Remove unused variable pointed out by Codacy.
- Multiple fixes:
- Merge pull request #3787 from Ferroin/unbound-per-thread-stats
- Add a pinned tab icon for Safari.
- Merge pull request #3791 from Ferroin/safari-pinned-tab
- Add fleep.io notification support.
- Merge pull request #3794 from Ferroin/fleep-notifications
- Merge pull request #3805 from ktsaou/master
- Increase version number of javascript files to for browser uncaching
- Merge pull request #3806 from ktsaou/master
- Btrfs physical disk allocation chart color improvements; fixes #3719
- Merge pull request #3807 from ktsaou/master
- Allow netdata to be compiled under clion
- Updated net-snmp.js to latest version
- Merge pull request #3812 from ktsaou/master
- Replace LICENSE symlink with actual file.
- Merge pull request #3818 from Ferroin/license-fix
- Add a Python module for interacting with BOINC.
- Add boinc_client python module to Makefile.am
- Add a python.d module for monitoring BOINC clients.
- Multiple fixes for the BOINC module.
- Update BOINC plugin reconnect handling.
- Fixed HTML tag issue in dashboard_info.js.
- Added TODO comment for the is_alive() check.
- Add conf.d/python.d/boinc.conf to conf.d/Makefile.am
- Fixed a syntax error in boinc.chart.py
- Converted all string formatting to new style.
- Fix buffer handling to accomodate python 2 and 3.
- Fixed format string issue.
- Moved line continuation so Codacy doesn't lose it's mind.
- Updated BOINC alarms to be a bit more sensible.
- Dead code removal.
- Update connection error handling to not be Linux specific.
- Remove unused import.
- Merge pull request #3786 from Ferroin/boinc-plugin
- Add 1-Wire temperature sensor monitoring
- Merge pull request #3822 from dspinellis/w1sensor
- Mdstat: refactor + read mismatch_cnt feature added
- Mdstat: mismatch_cnt alarm added
- Merge pull request #3839 from l2isbad/mdstat_mismatch_cnt
- Add custom request feature to SocketService._get_raw_data()
- Add Pika support to redis module
- Redis: simplify cop_chart func
- Redis: Service.do_auth fix
- Redis: add evicted keys chart
- Redis: add uptime chart
- Merge pull request #3832 from l2isbad/redis_pika
- Add the BOINC alarms config to Makefile.am
- Merge pull request #3831 from Ferroin/boinc-alarm-fix
- Log received signals before exiting, bypassing log rate protection; #3844
- Merge pull request #3848 from ktsaou/master
- Hddtemp: correctly parse /disk/by-id + refactor
- Hddtemp: update regex
- Hddtemp: replace for loop with dict comp
- Litespeed: add SPDX-License-Identifier header
- W1sensor: add SPDX-License-Identifier header
- Merge pull request #3841 from l2isbad/hddtemp_fix
- Default excluded filesystems from disk space monitoring; fixes #3842
- Merge pull request #3852 from ktsaou/master
- Added contributors license agreement
- Updated CLA with company info and added some comments
- Added CONTRIBUTORS.md to makefile
- Avoid conflict
- Merge pull request #3695 from ktsaou/cla
- Add my CLA signature
- Merge pull request #3855 from tycho/sign-cla
- Sign CLA
- Merge pull request #3857 from philwhineray/master
- Merge pull request #3858 from paulfantom/patch-1
- Sign the CLA.
- Merge pull request #3860 from Ferroin/patch-1
- Add cla signature
- Merge pull request #3861 from l2isbad/add_my_cla
- Kickstart-static64.sh set UID when it is missing; fixes #3840
- Merge pull request #3863 from ktsaou/master
- Alarm-notify.sh: allow sender names with spaces; fixes #3843
- Merge pull request #3864 from ktsaou/master
- Python.d.plugin: disabled_by_default feature added
- Merge pull request #3869 from l2isbad/python.d.disabled_by_default
- Update license file names so Github correctly detects our license.
- Merge pull request #3871 from Ferroin/license-file-naming
- Merge pull request #3873 from rlefevre/cla
- Add a module for monitoring logind sessions.
- Removed unused imports.
- Spelling fix.
- Fixed syntax in dashboard_info.js.
- Fix module prioirty.
- Disable the plugin by default.
- Merge pull request #3815 from Ferroin/logind-plugin
- Merge pull request #3874 from ktsaou/master
- Merge pull request #3875 from vlvkobal/master
- Fix: Missing pipe in CONTRIBUTORS.md
- Merge pull request #3877 from simonnagl/patch-1
- Update CONTRIBUTORS.md
- Merge pull request #3879 from user501254/patch-2
- Merge branch 'master' into patch-1
- Merge pull request #3880 from manosf/patch-1
- Sign the CLA
- Merge pull request #3882 from t-h-e/master
- Sign CLA.
- Merge pull request #3884 from facetoe/sign_cla
- Update CONTRIBUTORS.md
- Merge pull request #3886 from ntlug/patch-1
- Sign the CLA
- Merge pull request #3887 from alonbl/contrib
- Fix typo in BOINC plugin chart description.
- Merge pull request #3885 from Ferroin/patch-1
- Add ability to alias nut UPS names
- Add support for ES 6.3 'write' threadpool
- Sign the CLA
- Add CLA
- Merge pull request #3889 from Wing924/cla
- Merge branch 'master' into elasticsearch-6.3
- Merge pull request #3888 from NeonSludge/elasticsearch-6.3
- Merge branch 'master' into master
- Merge pull request #3890 from kmlucy/master
- Merge pull request #3895 from 383c57/sign_cla
- Sign CLA
- Merge pull request #3898 from jimcooley/master
- Merge branch 'master' into sign_cla
- Merge pull request #3901 from ccremer/sign_cla
- Update dashboard.js to scalableUnits packages(pps)
- Update freebsd_getifaddrs.c for system.N
- Merge pull request #3894 from RicardoSette/master
- Merge pull request #3899 from davidak/patch-1
- Adding Microsoft Team support for alert notification
- Adding suggested modifications from PR #3903
- Removing Splunk stuff in the MS Team payload, to much specific to my env.
- Removing curl option setup '--insecure' & specific export for test purpose in alarm-notify.sh
- Removing comment trace
- Comment curl_option
- Uncomment curl_option as original
- Adding better channel integration based on @ktsaou advices
- Merge pull request #3904 from Chocobo1/cla
- Increase js version numbers to uncache CDN
- Merge pull request #3902 from ktsaou/master
- Fix redis auth
- Merge pull request #3910 from cosmix/fix-redis-auth
- Update CONTRIBUTORS.md
- Merge pull request #3917 from shadycuz/update_cla
- Merge branch 'master' into patch-6
- Merge pull request #3915 from Flums/patch-6
- Merge pull request #3916 from domschl/patch-1
- Log failed commands return code; #3920
- Merge pull request #3921 from ktsaou/master
- Limit the rate of streaming requests
- Streaming rate limiting return error 503
- Streaming rate limiting recalc
- Streaming rate limiting config option
- Merge pull request #3938 from ktsaou/master
- Fix tomcat plugin typo: commited -> committed
- Merge pull request #3934 from Wing924/fix_tomcat_typo
- Add basic apcupsd alarm templates
- Adjusted alarm values
- Fire alarm if under 100% charge + docs
- Merge pull request #3928 from ccremer/apcupsd
- Merge branch 'master' into ms_team_notification_support
- Missing pipe to table
- Merge branch 'ms_team_notification_support' of https://github.com/tioumen/netdata into ms_team_notification_support
- Updating code based on cadacy report
- Detect when netdata-installer.sh is run without ./; fixes #3940
- Merge pull request #3942 from ktsaou/master
- ExecutableService: custom command support for _get_raw_data method
- Megacli: initial version added
- Megacli: added to makefile
- Megacli: pds dims => incremental
- Megacli: rename command => megacli
- Megacli: run megacli via sudo
- Megacli: add battery stats
- Megacli: add configuration file
- Megacli: add module python.d README
- Megacli: remove call to battery info on every iter if it fails on check
- Megacli: battery parse fix
- Megacli: create separate chart for every bbu (needed for aralms)
- Megacli: alarms added
- Python.d README: move megacli below mdstat
- Megacli: add media err and predict failure alarms
- Merge pull request #3930 from l2isbad/megacli
- Merge pull request #3943 from arch273/patch-1
- Merge pull request #3944 from jasonwbarnett/patch-1
- Sign x4FF3
- Merge pull request #3946 from x4FF3/patch-1
- Add ecowed to Contributors.md
- Merge pull request #3947 from ecowed/patch-2
- Sign CLA: glensc
- Merge pull request #3952 from glensc/patch-1
- Merge pull request #3951 from lets00/patch-1
- Merge remote-tracking branch 'upstream/master'
- Agreement signature
- Merge pull request #3950 from wungad/master
- Python loaders: fallback to yaml package
- Merge pull request #3949 from l2isbad/yaml_import_fix
- Merge pull request #3903 from tioumen/ms_team_notification_support
- Added boolean badges units with dash too; fixes #3613
- More generic solution for badge units
- Converted badges color map to list with hashes
- Merge pull request #3954 from ktsaou/master
- Fixed alarm-notify.sh
- Merge pull request #3958 from ktsaou/master
- Sync chart clock, when the definition of the chart is sent to netdata
- Added debug code to track data collection duration discards
- Do not overwrite discard_reason
- Sync clock on dimension creation attempts; refresh the chart to upstream on chart creation attempt
- Resync clock on chart creation attempt
- Fixes #3966
- The master now detects slave chart refreshes and syncs chart clock; fixes #3966
- Merge pull request #3979 from ktsaou/slave-sync
- Heartbeat now reports durations in realtime
- Merge pull request #3975 from ktsaou/clocks
- Relaxed network alarms
- Merge pull request #3976 from ktsaou/network-alarms
- Merge pull request #3980 from ktsaou/master
- Statsd extracts and ignores datadog statsd tags; fixes #3978
- Use hash for tags
- Merge pull request #3981 from ktsaou/master
- Sign the CLA #3952
- Merge pull request #3982 from rda0/patch-1
- Powerdns module: powerdns recursor support added
- Powerdns: python.d readme update
- Powerdns fix
- Merge pull request #4001 from l2isbad/powerdns_recursor
- Add Amazon SNS notification support.
- Fixed typo in variable name.
- Minor change to get codacy to be quiet.
- Fixed trivial mistake in AWS SNS command.
- Merge pull request #3962 from Ferroin/amazon-sns-alerts
- Add support for float values for time_multiplier in web_log
- Change the comment for time_multiplier
- Change error log for time_multiplier
- Merge pull request #4006 from alibo/patch-2
- Add (yaml)safe_load to loaders
- Beanstalk: use loaders.safe_load instead of yaml.load
- Merge pull request #4014 from l2isbad/beanstalk_yaml_load_fix
- Split bash expression for not using && in simple brackets
- Merge pull request #4015 from Nani-o/fix_issystemd_bash_function
- Initial revision of python plugin for monit (https://mmonit.com/monit/)
- Removed forgotten pdb module
- Added conf.d/monit.conf (also forgotten, sorry)
- Small changes requested at PR#4027
- Duplicate code moved to parse()
- Partial rewrite of _get_data()
- Strings now formatted via format() instead of '%'
- Added positional indexes in format()
- Added more positional indexes in format() (all of them? 0_o)
- - final replace for format()
- Changes for "New Module PR Checklist" (makefiles,readme,dashboard)
- - removed unused copy module
- Forgot to update python.d/monit.conf (removed URL suffix)
- Signing the CLA
- MySQL: chart active vs. max connections
- MySQL: add health checks for active connections
- Fix /proc/interrupts parsing
- Fix /proc/softirqs parsing
- Merge pull request #4055 from abalabahaha/parser-fix
- Download public keys by fingerprint in travis
- Replace key used to check source tags in build
- Merge pull request #4052 from philwhineray/master
- Updated configs.signature
- Removed obsolete check; #4051
- Merge pull request #4057 from ktsaou/master
- Merge branch 'master' into mysql-connections
- Merge pull request #4030 from amichelic/mysql-connections
- Merge branch 'master' into python-monit-plugin
- Merge pull request #4027 from OSSHelp/python-monit-plugin
- Python.d: add 'hidden' option to charts
- Merge pull request #4024 from l2isbad/hidden_charts
- Merge pull request #4078 from ktsaou/master
- Do not clear the database when it refers to the future
- Merge pull request #4109 from ktsaou/master
- Remove biased code part
- Remove static dir config
- Merge pull request #4134 from paulfantom/biased_code
- Remove script with one command
- Remove last mention of autogen.sh
- Merge pull request #4132 from paulfantom/repo_cleanup
- Added how to enable status in ovpn
- Merge pull request #4113 from ntalekt/master
- Make clearer what hooks are
- Merge pull request #4135 from paulfantom/githooks
- Add `node`
- Merge pull request #4064 from jonfairbanks/master
- Merge pull request #4138 from ktsaou/master
- :rainbow: :whale: unified, cross-arch, parametrized Dockerfile :whale: :rainbow:
- Merge pull request #3995 from paulfantom/docker
- Update functions.sh
- Merge pull request #4139 from paulfantom/patch-1
- When running under systemd, keep the scheduling parameters set by systemd, but report them to error.log
- Added info for giving netdata max priority
- Merge pull request #4143 from ktsaou/master
- Allow coverity-scan.sh to obtain the token from environment variable
- Minimum /proc/net/snmp IcmpMsg line is 2 words, not 3
- Merge pull request #4147 from ktsaou/master
- Remove license templates; add info about SPDX to main license file
- Fix redistribution year
- Info about licenses location
- Fix Makefile
- Merge pull request #4136 from paulfantom/legal
- :truck: move profiling to tests directory
- Merge pull request #4140 from paulfantom/clean_tests
- Add ignore-status option to freeipmi_plugin
- Add @plasticrake to contributers
- Merge branch 'master' into ipmi-ignore-status
- Merge pull request #4141 from plasticrake/ipmi-ignore-status
- Do not get the address of FILE pointer; fixes #4145
- Do not set stdin, stdout, stderr
- Merge pull request #4149 from ktsaou/std-file-pointers
- [nginx_plus] fix handling of non-contiguous peer ids
- Merge pull request #4093 from illes/patch-1
- Optimize counting of recusive pins
- Merge pull request #4095 from pjz/patch-1
- Netdata.service is now installed in /lib/systemd/system; fixes #4087
- Remove check for running systemd process
- Merge pull request #4151 from ktsaou/systemd-in-lib
- Use pidfile to send HUP to netdata via logrotate; fixes #4103; fixes #4020
- Netdata pid is in run/netdata/netdata.pid
- All startup files use the same pid file; all startup files remove pid file on exit
- Delete pidfile only when it exists
- Merge pull request #4157 from ktsaou/pidfile
- Remove condition from netdata.service
- Merge pull request #4170 from ktsaou/master
- [WIP] fail2ban: ipv6 support added + module simplification ([#4168](https://github.com/netdata/netdata/issues/4168))
- [cleanup crusade] travis build stages ([#4142](https://github.com/netdata/netdata/issues/4142))
- Fix lack of dot ([#4172](https://github.com/netdata/netdata/issues/4172))
- Add variable system.cpu.processors for alarms; fixes #3003 ([#4155](https://github.com/netdata/netdata/issues/4155))
- CI builds in containers ([#4174](https://github.com/netdata/netdata/issues/4174))
- Disable linters on files which should be soon deprecated ([#4176](https://github.com/netdata/netdata/issues/4176))
- Add alarms for abnormally high load averages. ([#4175](https://github.com/netdata/netdata/issues/4175))
- Updated configs.signatures ([#4179](https://github.com/netdata/netdata/issues/4179))
- Fix for load alarms ([#4180](https://github.com/netdata/netdata/issues/4180))
-  create pid directory, if not present ([#4181](https://github.com/netdata/netdata/issues/4181))
- [cleanup crusade] linting shell scripts for docker, tests and python ([#4162](https://github.com/netdata/netdata/issues/4162))
- Shellcheck in contrib ([#4160](https://github.com/netdata/netdata/issues/4160))
- Shellcheck bash scripts starting on A; disable shebang checking in all ([#4159](https://github.com/netdata/netdata/issues/4159))
- Add permission file check in ceph module ([#4177](https://github.com/netdata/netdata/issues/4177))
- Improve packaging checks ([#4188](https://github.com/netdata/netdata/issues/4188))
- Rethinkdb python plugin ([#3955](https://github.com/netdata/netdata/issues/3955))
- Elasticsearch: handle json parse error in threads ([#4186](https://github.com/netdata/netdata/issues/4186))
- More linting of bash modules ([#4183](https://github.com/netdata/netdata/issues/4183))
- Name veritas volume disk groups ([#4150](https://github.com/netdata/netdata/issues/4150))
- Time-duration badges should show "undefined" instead of "never" when the value is not a valid number; fixes #4029 ([#4193](https://github.com/netdata/netdata/issues/4193))
- Update CONTRIBUTORS.md ([#4197](https://github.com/netdata/netdata/issues/4197))
- Nginx_plus: use upstream server IP:port in dimension names, not the transient id ([#4194](https://github.com/netdata/netdata/issues/4194))
- Web_log Virtual host enhancement and http/https ([#4076](https://github.com/netdata/netdata/issues/4076))
- Python plugin monotonic fix ([#4156](https://github.com/netdata/netdata/issues/4156))
- Redis plugin: add one more check before collecting redis specific data ([#4205](https://github.com/netdata/netdata/issues/4205))
- Added UTC to server timezones list; fixes #4202 ([#4207](https://github.com/netdata/netdata/issues/4207))
- Allow empty values in config settings; fixes #3974 ([#4208](https://github.com/netdata/netdata/issues/4208))
- Fixes identified by LGTM ([#4209](https://github.com/netdata/netdata/issues/4209))
- Send host variables to prometheus ([#4200](https://github.com/netdata/netdata/issues/4200))
- Merge pull request #4210 from ktsaou/master
- More LGTM minor fixes ([#4211](https://github.com/netdata/netdata/issues/4211))
- Fix netdata server URL detection in dashboard.js; fixes #4212
- Merge pull request #4215 from ktsaou/master
- Fixed issues identified by lgtm
- Merge pull request #4216 from ktsaou/lgtm-fixes3
- Lgtm workaround for false-positives; https://github.com/Semmle/ql/issues/199
- Merge pull request #4218 from ktsaou/lgtm-false-positives
- Pythond_small_fixes ([#4185](https://github.com/netdata/netdata/issues/4185))
- Add docker plugin ([#4191](https://github.com/netdata/netdata/issues/4191))
- Create lgtm config ([#4213](https://github.com/netdata/netdata/issues/4213))
- Fixes identified by LGTM ([#4220](https://github.com/netdata/netdata/issues/4220))
- CLA signing using cla-assistant.io ([#4226](https://github.com/netdata/netdata/issues/4226))
- Disable IPFS Pin API ([#4224](https://github.com/netdata/netdata/issues/4224))
- Varnish plugin bugfix ([#4228](https://github.com/netdata/netdata/issues/4228))
- Fix missing comma in couchdb module. ([#4238](https://github.com/netdata/netdata/issues/4238))
- Fix LGTM complaints in monit module. ([#4237](https://github.com/netdata/netdata/issues/4237))
- Command js is not node.js ([#4239](https://github.com/netdata/netdata/issues/4239))
- Daemon cleanup ([#4231](https://github.com/netdata/netdata/issues/4231))
- Merge pull request #4240 from ktsaou/master
- Add some extra error logging to the spigotmc module. ([#4148](https://github.com/netdata/netdata/issues/4148))
- Apps.plugin now checks fds for changes, with adaptive caching ([#4243](https://github.com/netdata/netdata/issues/4243))
- Fixed typo in prometheus_all_hosts output
- Show version on console when submitting to coverity
- Merge pull request #4245 from ktsaou/master
- Added -NoLog parameter for megacli calls ([#4242](https://github.com/netdata/netdata/issues/4242))
- Travis and docker setup after migration ([#4247](https://github.com/netdata/netdata/issues/4247))
- Replaced referenced to firehol github org with netdata github org ([#4249](https://github.com/netdata/netdata/issues/4249))
- Fix tagging problem ([#4250](https://github.com/netdata/netdata/issues/4250))
- Fix badges ([#4251](https://github.com/netdata/netdata/issues/4251))
- Coverity should still use firehol/netdata until we find a solution
- Merge pull request #4253 from ktsaou/master
- Push host tags for graphite; fixes #3936
- Merge branch 'master' into graphite-host-tags
- Merge pull request #3992 from ktsaou/graphite-host-tags
- [project management] add github CODEOWNERS ([#4137](https://github.com/netdata/netdata/issues/4137))
- Collect TcpExtTCPReqQFullDrop; #3234 ([#4246](https://github.com/netdata/netdata/issues/4246))
- Fix typo in documentation ([#4255](https://github.com/netdata/netdata/issues/4255))
- Fail fast in docker builds
- Merge pull request #4252 from paulfantom/fail_fast
- Release less artifacts ([#4260](https://github.com/netdata/netdata/issues/4260))
- Updated readme for netdata org ([#4262](https://github.com/netdata/netdata/issues/4262))
- Finetune python ownership; add CI ownership to @paulfantom ([#4264](https://github.com/netdata/netdata/issues/4264))
- Apps.plugin fixes ([#4267](https://github.com/netdata/netdata/issues/4267))
- Fix several typos in documentation ([#4270](https://github.com/netdata/netdata/issues/4270))
- [WIP] LGTM tag classification ([#4269](https://github.com/netdata/netdata/issues/4269))
- Update .lgtm.yml ([#4272](https://github.com/netdata/netdata/issues/4272))
- Fix python warnings identified by LGTM ([#4275](https://github.com/netdata/netdata/issues/4275))
- Add other common IoT services to apps_groups.conf ([#4276](https://github.com/netdata/netdata/issues/4276))
- Fixup small python-logind typos ([#4271](https://github.com/netdata/netdata/issues/4271))
- Allow DOCKER_HOST env variable to override default docker socket path ([#4277](https://github.com/netdata/netdata/issues/4277))
- Make method in url service configurable ([#4257](https://github.com/netdata/netdata/issues/4257))
- Megacli plugin: adapter regex update ([#4279](https://github.com/netdata/netdata/issues/4279))
- Nightly builds + coverity scan ([#4273](https://github.com/netdata/netdata/issues/4273))
- Fix typo in documentation ([#4284](https://github.com/netdata/netdata/issues/4284))
- Add code of conduct ([#4280](https://github.com/netdata/netdata/issues/4280))
- Fix typo ([#4290](https://github.com/netdata/netdata/issues/4290))
- Give credit where credit is due ([#4291](https://github.com/netdata/netdata/issues/4291))
- Update variable after install ([#4292](https://github.com/netdata/netdata/issues/4292))
- Use flake8 instead of pylint ([#4282](https://github.com/netdata/netdata/issues/4282))
- Reproducible build system ([#4294](https://github.com/netdata/netdata/issues/4294))
- Python.d PEP 8 cleanup, modules A-C ([#4286](https://github.com/netdata/netdata/issues/4286))
- Python.d PEP 8 cleanup, modules D-H ([#4287](https://github.com/netdata/netdata/issues/4287))
- Python.d PEP 8 cleanup, modules I-L ([#4288](https://github.com/netdata/netdata/issues/4288))
- Python.d PEP 8 cleanup, modules N-O ([#4297](https://github.com/netdata/netdata/issues/4297))
- Python.d PEP 8 cleanup, modules M ([#4289](https://github.com/netdata/netdata/issues/4289))
- Python.d PEP 8 cleanup, modules S-Z ([#4302](https://github.com/netdata/netdata/issues/4302))
- Build OSX earlier ([#4305](https://github.com/netdata/netdata/issues/4305))
- Update coverity-scan.sh ([#4304](https://github.com/netdata/netdata/issues/4304))
- Tcp syn and accept queue charts and alarms ([#4281](https://github.com/netdata/netdata/issues/4281))
- Stock configs in /usr/lib/netdata ([#4283](https://github.com/netdata/netdata/issues/4283))
- Force symlink of netdata-updater.sh ([#4307](https://github.com/netdata/netdata/issues/4307))
- Cleanup FIXME tags ([#4309](https://github.com/netdata/netdata/issues/4309))
- Python.d PEP 8 cleanup, modules P-R ([#4299](https://github.com/netdata/netdata/issues/4299))
- Install some libs for coverity ([#4314](https://github.com/netdata/netdata/issues/4314))
- [cleanup crusade] Shellcheck ([#4261](https://github.com/netdata/netdata/issues/4261))
- More code owners ([#4316](https://github.com/netdata/netdata/issues/4316))
- Updated LGTM URLs ([#4317](https://github.com/netdata/netdata/issues/4317))
- Use docker manifests ([#4315](https://github.com/netdata/netdata/issues/4315))
- Fix docker image ([#4330](https://github.com/netdata/netdata/issues/4330))
- Fix spdx ([#4327](https://github.com/netdata/netdata/issues/4327))
- Run CI builds on alpine ([#4329](https://github.com/netdata/netdata/issues/4329))
- Use newer docker in CI build ([#4332](https://github.com/netdata/netdata/issues/4332))
- Releaser ([#4328](https://github.com/netdata/netdata/issues/4328))
- Fixes coverity identified issues ([#4333](https://github.com/netdata/netdata/issues/4333))
- Reimplement #4332 ([#4336](https://github.com/netdata/netdata/issues/4336))
- Fix BIND outgoing stats in a multiview environment ([#4337](https://github.com/netdata/netdata/issues/4337))
- Better daemon errors about files;  ([#4342](https://github.com/netdata/netdata/issues/4342))
- Update CODEOWNERS ([#4340](https://github.com/netdata/netdata/issues/4340))
- Added edit-config ([#4338](https://github.com/netdata/netdata/issues/4338))
- ExecutableService: retrun [] instead of None if no data. ([#4346](https://github.com/netdata/netdata/issues/4346))
- Fix apache ipv6 configuration ([#4349](https://github.com/netdata/netdata/issues/4349))
- Fix phpfpm ipv6 configuration ([#4348](https://github.com/netdata/netdata/issues/4348))
- Log flood should not be disabled;  ([#4344](https://github.com/netdata/netdata/issues/4344))
- Fix the last few PEP 8 compliance issues. ([#4345](https://github.com/netdata/netdata/issues/4345))
- Add query types to mysql plugin ([#4347](https://github.com/netdata/netdata/issues/4347))
- Add a python plugin for monitoring power supplies on Linux. ([#3799](https://github.com/netdata/netdata/issues/3799))
- Fix firehol image tagging ([#4355](https://github.com/netdata/netdata/issues/4355))
- Updated configs.signatures ([#4356](https://github.com/netdata/netdata/issues/4356))
- Send pipes URL encoded ([#4358](https://github.com/netdata/netdata/issues/4358))
- Edit-config should use . instead of source with /bin/sh ([#4360](https://github.com/netdata/netdata/issues/4360))
- Python.d/postgres.chart.py PEP 8 code cleanup ([#4298](https://github.com/netdata/netdata/issues/4298))
- Make future code PEP8 compliant ([#4382](https://github.com/netdata/netdata/issues/4382))
- Modularize C source code ([#4372](https://github.com/netdata/netdata/issues/4372))
- Correct ram_in_use alarm calculation on FreeBSD ([#4363](https://github.com/netdata/netdata/issues/4363))
- Fix docker builds ([#4367](https://github.com/netdata/netdata/issues/4367))
- Support filtering of charts during streaming; fixes #4223 ([#4361](https://github.com/netdata/netdata/issues/4361))
- Updated swagger info for HTTPS ([#4386](https://github.com/netdata/netdata/issues/4386))
- Normalized plugin names on all plugins; #4379 ([#4387](https://github.com/netdata/netdata/issues/4387))
- LGTM links should go to netdata/netdata ([#4388](https://github.com/netdata/netdata/issues/4388))
- Modularized all source code ([#4391](https://github.com/netdata/netdata/issues/4391))
- Fix compilation on FreeBSD;  ([#4398](https://github.com/netdata/netdata/issues/4398))
- Add sendmail into the list of mail servers. ([#4402](https://github.com/netdata/netdata/issues/4402))
- Fix make dist ([#4401](https://github.com/netdata/netdata/issues/4401))
- Update CODEOWNERS ([#4405](https://github.com/netdata/netdata/issues/4405))
- Account "Laundry" pages as a separate RAM dimension on FreeBSD. ([#4390](https://github.com/netdata/netdata/issues/4390))
- Fix linters in CI ([#4399](https://github.com/netdata/netdata/issues/4399))
- Fix netdata.spec for new directory structure ([#4410](https://github.com/netdata/netdata/issues/4410))
- Update CODEOWNERS ([#4412](https://github.com/netdata/netdata/issues/4412))
- Update README.md ([#4414](https://github.com/netdata/netdata/issues/4414))
- Fix node.d.plugin; fixes #4406 ([#4413](https://github.com/netdata/netdata/issues/4413))
- Fixed documentation links ([#4418](https://github.com/netdata/netdata/issues/4418))
- Fix cmake build on macos ([#4420](https://github.com/netdata/netdata/issues/4420))
- Evaluate $used_ram_to_ignore on FreeBSD ([#4419](https://github.com/netdata/netdata/issues/4419))
- Added uwsgi plugin ([#4404](https://github.com/netdata/netdata/issues/4404))
- Moved stream.conf initialization after log files have been open; fixes #4403 ([#4422](https://github.com/netdata/netdata/issues/4422))
- Add github templates ([#4424](https://github.com/netdata/netdata/issues/4424))
- Fix streaming bug; fixes #4370 ([#4425](https://github.com/netdata/netdata/issues/4425))
- Fix GitHub issue templates ([#4427](https://github.com/netdata/netdata/issues/4427))
- Moved related wiki pages into the repo ([#4428](https://github.com/netdata/netdata/issues/4428))
- Fixed README.md links ([#4433](https://github.com/netdata/netdata/issues/4433))
- Create stale bot integration ([#4268](https://github.com/netdata/netdata/issues/4268))
- Remove unused variables ([#4437](https://github.com/netdata/netdata/issues/4437))
- Disallow stale bot from removing labels ([#4442](https://github.com/netdata/netdata/issues/4442))
- Fix permissions for config files in a container ([#4454](https://github.com/netdata/netdata/issues/4454))
- Fix systemd detection; fixes #4421 ([#4423](https://github.com/netdata/netdata/issues/4423))
- Unify headers in github templates ([#4451](https://github.com/netdata/netdata/issues/4451))
- Mongodb: add min pymongo package version ([#4449](https://github.com/netdata/netdata/issues/4449))
- Icecast fix ([#4448](https://github.com/netdata/netdata/issues/4448))
- Update CODEOWNERS ([#4447](https://github.com/netdata/netdata/issues/4447))
- Invalidate incorrect rpm spec changelog ([#4445](https://github.com/netdata/netdata/issues/4445))
- Indicate FreeIPMI support fro FreeBSD ([#4440](https://github.com/netdata/netdata/issues/4440))
- Add autogenerated changelog ([#4444](https://github.com/netdata/netdata/issues/4444))
- Modularize the query api ([#4443](https://github.com/netdata/netdata/issues/4443))
- Add ProxySQL python plugin ([#4112](https://github.com/netdata/netdata/issues/4112))
- Remove duplicated entry and put modules in order in python.d.conf ([#4460](https://github.com/netdata/netdata/issues/4460))
- Add proxysql in python.d.plugin Makefile.am ([#4466](https://github.com/netdata/netdata/issues/4466))
- Fix duplicate in CODEOWNERS file ([#4467](https://github.com/netdata/netdata/issues/4467))
- Adaptec_raid python module ([#4429](https://github.com/netdata/netdata/issues/4429))
- Updated tests for the new hierarchy ([#4464](https://github.com/netdata/netdata/issues/4464))
- Optimized ses and added des ([#4470](https://github.com/netdata/netdata/issues/4470))
- Bug-fix: fixed aligned queries that returned no data ([#4472](https://github.com/netdata/netdata/issues/4472))
- Feat: detect NIC speed and alarm on each device for net traffic overflow ([#4430](https://github.com/netdata/netdata/issues/4430))
- Fix checking of grouping time ([#4478](https://github.com/netdata/netdata/issues/4478))
- Query code cleanup ([#4480](https://github.com/netdata/netdata/issues/4480))
- Fix query sum ([#4482](https://github.com/netdata/netdata/issues/4482))
- Query engine documentation and stats ([#4483](https://github.com/netdata/netdata/issues/4483))
- Updated queries README ([#4484](https://github.com/netdata/netdata/issues/4484))
- Updated queries README ([#4485](https://github.com/netdata/netdata/issues/4485))
- Updated queries README ([#4486](https://github.com/netdata/netdata/issues/4486))
- Restored min-max calculation of RRDR ([#4489](https://github.com/netdata/netdata/issues/4489))
- Diskspace plugin should not stat() excluded mountpoints ([#4494](https://github.com/netdata/netdata/issues/4494))
- Fix query min-max, again... ([#4495](https://github.com/netdata/netdata/issues/4495))
- Add option to run netdata in the background ([#4364](https://github.com/netdata/netdata/issues/4364))
- Disable python sudo modules by default ([#4477](https://github.com/netdata/netdata/issues/4477))
- Fixed rpm build; ([#4503](https://github.com/netdata/netdata/issues/4503))
- Split the API formatters in modules ([#4504](https://github.com/netdata/netdata/issues/4504))
- Fix RPM build ([#4507](https://github.com/netdata/netdata/issues/4507))
- Do not send duplicate chart names ([#4508](https://github.com/netdata/netdata/issues/4508))
- Updated docker pulls badges ([#4510](https://github.com/netdata/netdata/issues/4510))
- Exclude web/gui/src from codacy checks ([#4515](https://github.com/netdata/netdata/issues/4515))
- Updated infographic ([#4511](https://github.com/netdata/netdata/issues/4511))
- Fix parse oidname and santilize dimension name ([#4498](https://github.com/netdata/netdata/issues/4498))
- Fixed vulnerabilities identified by red4sec.com ([#4521](https://github.com/netdata/netdata/issues/4521))
- Allow debugging memory per module ([#4524](https://github.com/netdata/netdata/issues/4524))
- Do not enable unused per core interrupts by default ([#4519](https://github.com/netdata/netdata/issues/4519))
- Fixed broken links ([#4530](https://github.com/netdata/netdata/issues/4530))
- Added @gmosx to CONTRIBUTORS.md ([#4531](https://github.com/netdata/netdata/issues/4531))
- New releaser ([#4526](https://github.com/netdata/netdata/issues/4526))
- Fixed wrong annotations given to google charts ([#4535](https://github.com/netdata/netdata/issues/4535))
- Changed swagger editor url to the correct one ([#4539](https://github.com/netdata/netdata/issues/4539))
- Simplify CI system configuration ([#4534](https://github.com/netdata/netdata/issues/4534))
- Cleaner releaser.sh script ([#4542](https://github.com/netdata/netdata/issues/4542))
- Fix CI scripts configuration and [netdata minor release] and [minor] (just to be sure)

