# tree-sitter-gitattributes

[![CI][ci]](https://github.com/tree-sitter-grammars/tree-sitter-gitattributes/actions/workflows/ci.yml)
[![discord][discord]](https://discord.gg/w7nTvsVJhm)
[![matrix][matrix]](https://matrix.to/#/#nvim-treesitter:matrix.org)
[![npm][npm]](https://www.npmjs.com/package/tree-sitter-gitattributes)
[![crates][crates]](https://crates.io/crates/tree-sitter-gitattributes)

A tree-sitter parser for `.gitattributes` files.

## References

* [gitattributes Documentation](https://git-scm.com/docs/gitattributes|)
* [gitignore Documentation (Pattern Format)](https://git-scm.com/docs/gitignore#_pattern_format)
* [git source code (`attr.c`)](https://github.com/git/git/blob/master/attr.c)
* [git source code (`wildmatch.c`)](https://github.com/git/git/blob/master/wildmatch.c)
* [ANSI-C Quoting](https://www.gnu.org/software/bash/manual/html_node/ANSI_002dC-Quoting.html)
* [Character Classes and Bracket Expressions](https://www.gnu.org/software/grep/manual/html_node/Character-Classes-and-Bracket-Expressions.html)

## Editors

- [x] Neovim
- [ ] Helix _(has alternative)_
- [x] Emacs
- [ ] Zed

[ci]: https://img.shields.io/github/actions/workflow/status/tree-sitter-grammars/tree-sitter-gitattributes/ci.yml?logo=github&label=CI
[discord]: https://img.shields.io/discord/1063097320771698699?logo=discord&label=tree-sitter
[matrix]: https://img.shields.io/matrix/nvim-treesitter%3Amatrix.org?logo=matrix&label=nvim-treesitter
[npm]: https://img.shields.io/npm/v/tree-sitter-gitattributes?logo=npm
[crates]: https://img.shields.io/crates/v/tree-sitter-gitattributes?logo=rust
